/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.StringChunkEx;
import com.kreative.openxion.util.StringChunkType;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMComparator;
import com.kreative.openxion.xom.XOMContainer;
import com.kreative.openxion.xom.XOMStringContainer;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMString;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMStringChunk
extends XOMContainer
implements XOMStringContainer {
    private static final long serialVersionUID = 1L;
    private XOMVariant parent;
    private StringChunkType chunkType;
    private int startIndex;
    private int endIndex;

    public XOMStringChunk(XOMVariant xOMVariant, StringChunkType stringChunkType, int n, int n2) {
        this.parent = xOMVariant;
        this.chunkType = stringChunkType;
        this.startIndex = n;
        this.endIndex = n2;
    }

    @Override
    public boolean canGetParent(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getParent(XNContext xNContext) {
        return this.parent;
    }

    private StringChunkInfo getChunkInfo(XNContext xNContext, boolean bl, boolean bl2) {
        int n;
        String string;
        String string2;
        if (bl || bl2) {
            this.parent = this.parent.asContainer(xNContext, false);
            string2 = this.parent.getContents(xNContext).toTextString(xNContext);
        } else {
            string2 = this.parent.canGetContents(xNContext) ? this.parent.getContents(xNContext).toTextString(xNContext) : this.parent.toTextString(xNContext);
        }
        char c = xNContext.getItemDelimiter();
        char c2 = xNContext.getColumnDelimiter();
        char c3 = xNContext.getRowDelimiter();
        int n2 = StringChunkEx.count(string2, this.chunkType, c, c2, c3);
        int[] nArray = XIONUtil.index(1, n2, this.startIndex, this.endIndex);
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (bl && n3 > n2 || bl2 && n4 > n2) {
            if (this.chunkType == StringChunkType.LINE) {
                string = "";
                int n5 = (bl && bl2 ? Math.max(n3, n4) : (bl ? n3 : (bl2 ? n4 : n2))) - n2;
                if (n2 == 0) {
                    ++n2;
                }
                while (true) {
                    int n6 = --n5;
                    --n5;
                    if (n6 <= 0) break;
                    string = string + xNContext.getLineEnding();
                    ++n2;
                }
                string2 = string2 + string;
                this.parent.putAfterContents(xNContext, new XOMString(string));
            } else if (this.chunkType == StringChunkType.ITEM || this.chunkType == StringChunkType.ROW || this.chunkType == StringChunkType.COLUMN) {
                char c4;
                switch (this.chunkType) {
                    case ITEM: {
                        c4 = c;
                        break;
                    }
                    case ROW: {
                        c4 = c3;
                        break;
                    }
                    case COLUMN: {
                        c4 = c2;
                        break;
                    }
                    default: {
                        c4 = '\uffff';
                    }
                }
                String string3 = "";
                n = (bl && bl2 ? Math.max(n3, n4) : (bl ? n3 : (bl2 ? n4 : n2))) - n2;
                if (n2 == 0) {
                    ++n2;
                }
                while (true) {
                    int n7 = --n;
                    --n;
                    if (n7 <= 0) break;
                    string3 = string3 + c4;
                    ++n2;
                }
                string2 = string2 + string3;
                this.parent.putAfterContents(xNContext, new XOMString(string3));
            }
        }
        if (bl && n3 < 1 || bl2 && n4 < 1) {
            if (this.chunkType == StringChunkType.LINE) {
                string = "";
                int n8 = 1 - (bl && bl2 ? Math.min(n3, n4) : (bl ? n3 : (bl2 ? n4 : 1)));
                if (n2 == 0) {
                    ++n2;
                }
                while (true) {
                    int n9 = --n8;
                    --n8;
                    if (n9 <= 0) break;
                    string = string + xNContext.getLineEnding();
                    ++n2;
                    ++n3;
                    ++n4;
                }
                string2 = string + string2;
                this.parent.putBeforeContents(xNContext, new XOMString(string));
            } else if (this.chunkType == StringChunkType.ITEM || this.chunkType == StringChunkType.ROW || this.chunkType == StringChunkType.COLUMN) {
                char c5;
                switch (this.chunkType) {
                    case ITEM: {
                        c5 = c;
                        break;
                    }
                    case ROW: {
                        c5 = c3;
                        break;
                    }
                    case COLUMN: {
                        c5 = c2;
                        break;
                    }
                    default: {
                        c5 = '\uffff';
                    }
                }
                String string4 = "";
                n = 1 - (bl && bl2 ? Math.min(n3, n4) : (bl ? n3 : (bl2 ? n4 : 1)));
                if (n2 == 0) {
                    ++n2;
                }
                while (true) {
                    int n10 = --n;
                    --n;
                    if (n10 <= 0) break;
                    string4 = string4 + c5;
                    ++n2;
                    ++n3;
                    ++n4;
                }
                string2 = string4 + string2;
                this.parent.putBeforeContents(xNContext, new XOMString(string4));
            }
        }
        StringChunkInfo stringChunkInfo = new StringChunkInfo();
        stringChunkInfo.parentContent = string2;
        stringChunkInfo.startChunkIndex = n3;
        stringChunkInfo.endChunkIndex = n4;
        stringChunkInfo.startCharIndex = StringChunkEx.start(string2, this.chunkType, n3, c, c2, c3);
        stringChunkInfo.endCharIndex = StringChunkEx.end(string2, this.chunkType, n4, c, c2, c3);
        stringChunkInfo.deleteEndCharIndex = StringChunkEx.start(string2, this.chunkType, n4 + 1, c, c2, c3);
        if (stringChunkInfo.startCharIndex > stringChunkInfo.endCharIndex) {
            stringChunkInfo.endCharIndex = stringChunkInfo.startCharIndex;
        }
        if (stringChunkInfo.startCharIndex > stringChunkInfo.deleteEndCharIndex) {
            stringChunkInfo.deleteEndCharIndex = stringChunkInfo.startCharIndex;
        }
        return stringChunkInfo;
    }

    @Override
    public boolean canDelete(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canDeleteString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void delete(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canDeleteString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            xOMStringContainer.deleteString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.deleteEndCharIndex);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            String string = stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex);
            String string2 = stringChunkInfo.parentContent.substring(stringChunkInfo.deleteEndCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string + string2));
        } else {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canDeleteString(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canDeleteString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void deleteString(XNContext xNContext, int n, int n2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canDeleteString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.deleteString(xNContext, n3, n4);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n6 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            String string = stringChunkInfo.parentContent.substring(0, n5);
            String string2 = stringChunkInfo.parentContent.substring(n6);
            this.parent.putIntoContents(xNContext, new XOMString(string + string2));
        } else {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canGetContents(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getContents(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canGetString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            return xOMStringContainer.getString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex);
        }
        StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
        return new XOMString(stringChunkInfo.parentContent.substring(stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex));
    }

    @Override
    public boolean canGetString(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getString(XNContext xNContext, int n, int n2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canGetString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            return xOMStringContainer.getString(xNContext, n3, n4);
        }
        StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
        int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
        int n6 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
        return new XOMString(stringChunkInfo.parentContent.substring(n5, n6));
    }

    @Override
    public boolean canPutContents(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            xOMStringContainer.putIntoString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            String string = stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex);
            String string2 = stringChunkInfo.parentContent.substring(stringChunkInfo.endCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putIntoContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            xOMStringContainer.putBeforeString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            String string = stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex);
            String string2 = stringChunkInfo.parentContent.substring(stringChunkInfo.startCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            xOMStringContainer.putAfterString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            String string = stringChunkInfo.parentContent.substring(0, stringChunkInfo.endCharIndex);
            String string2 = stringChunkInfo.parentContent.substring(stringChunkInfo.endCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putAfterContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            xOMStringContainer.putIntoString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            String string2 = stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex);
            String string3 = stringChunkInfo.parentContent.substring(stringChunkInfo.endCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putIntoContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            xOMStringContainer.putBeforeString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            String string2 = stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex);
            String string3 = stringChunkInfo.parentContent.substring(stringChunkInfo.startCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            xOMStringContainer.putAfterString(xNContext, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            String string2 = stringChunkInfo.parentContent.substring(0, stringChunkInfo.endCharIndex);
            String string3 = stringChunkInfo.parentContent.substring(stringChunkInfo.endCharIndex);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putAfterContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public boolean canPutString(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putIntoString(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n6 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            String string = stringChunkInfo.parentContent.substring(0, n5);
            String string2 = stringChunkInfo.parentContent.substring(n6);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putIntoContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putBeforeString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putBeforeString(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            String string = stringChunkInfo.parentContent.substring(0, n5);
            String string2 = stringChunkInfo.parentContent.substring(n5);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putAfterString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putAfterString(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            String string = stringChunkInfo.parentContent.substring(0, n5);
            String string2 = stringChunkInfo.parentContent.substring(n5);
            this.parent.putIntoContents(xNContext, new XOMString(string + xOMVariant.toTextString(xNContext) + string2));
        } else {
            super.putAfterContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putIntoString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putIntoString(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n6 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            String string2 = stringChunkInfo.parentContent.substring(0, n5);
            String string3 = stringChunkInfo.parentContent.substring(n6);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putIntoContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putBeforeString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putBeforeString(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            String string2 = stringChunkInfo.parentContent.substring(0, n5);
            String string3 = stringChunkInfo.parentContent.substring(n5);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putAfterString(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.putAfterString(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n5 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            String string2 = stringChunkInfo.parentContent.substring(0, n5);
            String string3 = stringChunkInfo.parentContent.substring(n5);
            this.parent.putIntoContents(xNContext, new XOMString(string2 + xOMVariant.toTextString(xNContext) + string3), string, xOMVariant2);
        } else {
            super.putAfterContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public boolean canSortContents(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canRearrangeString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void sortContents(XNContext xNContext, XOMComparator xOMComparator) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canRearrangeString(xNContext)) {
            Object object;
            Serializable serializable;
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            Vector<XOMStringChunk> vector = new Vector<XOMStringChunk>();
            Vector<Integer> vector2 = new Vector<Integer>();
            Vector<Integer> vector3 = new Vector<Integer>();
            vector2.add(0);
            for (int i = stringChunkInfo.startChunkIndex; i <= stringChunkInfo.endChunkIndex; ++i) {
                serializable = new XOMStringChunk(this.parent, this.chunkType, i, i);
                vector.add((XOMStringChunk)serializable);
                object = ((XOMStringChunk)serializable).getChunkInfo(xNContext, false, false);
                vector3.add(((StringChunkInfo)object).startCharIndex);
                vector2.add(((StringChunkInfo)object).endCharIndex);
            }
            vector3.add(stringChunkInfo.parentContent.length());
            Collections.sort(vector, xOMComparator);
            Vector vector4 = new Vector();
            serializable = new Vector();
            while (!vector2.isEmpty() && !vector3.isEmpty() || !vector.isEmpty()) {
                if (!vector2.isEmpty() && !vector3.isEmpty()) {
                    vector4.add(vector2.remove(0));
                    ((Vector)serializable).add(vector3.remove(0));
                }
                if (vector.isEmpty()) continue;
                object = (XOMStringChunk)vector.remove(0);
                StringChunkInfo stringChunkInfo2 = super.getChunkInfo(xNContext, false, false);
                vector4.add(stringChunkInfo2.startCharIndex);
                ((Vector)serializable).add(stringChunkInfo2.endCharIndex);
            }
            object = new int[vector4.size()];
            for (int i = 0; i < vector4.size(); ++i) {
                object[i] = (Integer)vector4.get(i);
            }
            int[] nArray = new int[((Vector)serializable).size()];
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                nArray[i] = (Integer)((Vector)serializable).get(i);
            }
            xOMStringContainer.rearrangeString(xNContext, (int[])object, nArray);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            Vector<XOMStringChunk> vector = new Vector<XOMStringChunk>();
            Vector<String> vector5 = new Vector<String>();
            int n = 0;
            for (int i = stringChunkInfo.startChunkIndex; i <= stringChunkInfo.endChunkIndex; ++i) {
                XOMStringChunk xOMStringChunk = new XOMStringChunk(this.parent, this.chunkType, i, i);
                vector.add(xOMStringChunk);
                StringChunkInfo stringChunkInfo3 = xOMStringChunk.getChunkInfo(xNContext, false, false);
                vector5.add(stringChunkInfo.parentContent.substring(n, stringChunkInfo3.startCharIndex));
                n = stringChunkInfo3.endCharIndex;
            }
            vector5.add(stringChunkInfo.parentContent.substring(n, stringChunkInfo.parentContent.length()));
            Collections.sort(vector, xOMComparator);
            StringBuffer stringBuffer = new StringBuffer();
            while (!vector5.isEmpty() || !vector.isEmpty()) {
                if (!vector5.isEmpty()) {
                    stringBuffer.append((String)vector5.remove(0));
                }
                if (vector.isEmpty()) continue;
                stringBuffer.append(((XOMVariant)vector.remove(0)).toTextString(xNContext));
            }
            this.parent.putIntoContents(xNContext, new XOMString(stringBuffer.toString()));
        } else {
            super.sortContents(xNContext, xOMComparator);
        }
    }

    @Override
    public boolean canRearrangeString(XNContext xNContext) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canRearrangeString(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void rearrangeString(XNContext xNContext, int[] nArray, int[] nArray2) {
        if (this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canPutString(xNContext)) {
            int n;
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int[] nArray3 = new int[nArray.length + 2];
            int[] nArray4 = new int[nArray2.length + 2];
            nArray3[0] = 0;
            nArray4[0] = stringChunkInfo.startCharIndex;
            for (n = 0; n < nArray.length; ++n) {
                nArray3[n + 1] = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + nArray[n]));
            }
            for (n = 0; n < nArray2.length; ++n) {
                nArray4[n + 1] = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + nArray2[n]));
            }
            nArray3[nArray3.length - 1] = stringChunkInfo.endCharIndex;
            nArray4[nArray4.length - 1] = stringChunkInfo.parentContent.length();
            xOMStringContainer.rearrangeString(xNContext, nArray3, nArray4);
        } else if (this.parent.canPutContents(xNContext)) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringChunkInfo.parentContent.substring(0, stringChunkInfo.startCharIndex));
            for (int i = 0; i < nArray.length && i < nArray2.length; ++i) {
                int n = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + nArray[i]));
                int n2 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + nArray2[i]));
                stringBuffer.append(stringChunkInfo.parentContent.substring(n, n2));
            }
            stringBuffer.append(stringChunkInfo.parentContent.substring(stringChunkInfo.endCharIndex));
            this.parent.putIntoContents(xNContext, new XOMString(stringBuffer.toString()));
        } else {
            super.sortContents(xNContext, null);
        }
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return string.equalsIgnoreCase("number") || this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canGetStringProperty(xNContext, string);
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (string.equalsIgnoreCase("number")) {
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            return new XOMInteger(stringChunkInfo.endChunkIndex - stringChunkInfo.startChunkIndex + 1);
        }
        if (this.canGetProperty(xNContext, string)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            return xOMStringContainer.getStringProperty(xNContext, xNModifier, string, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canGetStringProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canGetStringProperty(xNContext, string);
    }

    @Override
    public XOMVariant getStringProperty(XNContext xNContext, XNModifier xNModifier, String string, int n, int n2) {
        if (this.canGetStringProperty(xNContext, string)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            return xOMStringContainer.getStringProperty(xNContext, xNModifier, string, n3, n4);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canSetProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canSetStringProperty(xNContext, string);
    }

    @Override
    public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        if (this.canSetProperty(xNContext, string)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            xOMStringContainer.setStringProperty(xNContext, string, stringChunkInfo.startCharIndex, stringChunkInfo.endCharIndex, xOMVariant);
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public boolean canSetStringProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMStringContainer && ((XOMStringContainer)((Object)this.parent)).canSetStringProperty(xNContext, string);
    }

    @Override
    public void setStringProperty(XNContext xNContext, String string, int n, int n2, XOMVariant xOMVariant) {
        if (this.canSetProperty(xNContext, string)) {
            XOMStringContainer xOMStringContainer = (XOMStringContainer)((Object)this.parent);
            StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n));
            int n4 = Math.max(stringChunkInfo.startCharIndex, Math.min(stringChunkInfo.endCharIndex, stringChunkInfo.startCharIndex + n2));
            xOMStringContainer.setStringProperty(xNContext, string, n3, n4, xOMVariant);
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public String toLanguageString() {
        if (this.startIndex == this.endIndex) {
            return this.chunkType.toString() + " " + this.startIndex + " of " + this.parent.toLanguageString();
        }
        return this.chunkType.toPluralString() + " " + this.startIndex + " through " + this.endIndex + " of " + this.parent.toLanguageString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return this.getContents(xNContext).toTextString(xNContext);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
        Vector<XOMStringChunk> vector = new Vector<XOMStringChunk>();
        if (stringChunkInfo != null) {
            for (int i = stringChunkInfo.startChunkIndex; i <= stringChunkInfo.endChunkIndex; ++i) {
                vector.add(new XOMStringChunk(this.parent, this.chunkType, i, i));
            }
        }
        return vector;
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        StringChunkInfo stringChunkInfo = this.getChunkInfo(xNContext, false, false);
        Vector<XOMString> vector = new Vector<XOMString>();
        if (stringChunkInfo != null) {
            for (int i = stringChunkInfo.startChunkIndex; i <= stringChunkInfo.endChunkIndex; ++i) {
                vector.add(new XOMString(new XOMStringChunk(this.parent, this.chunkType, i, i).toTextString(xNContext)));
            }
        }
        return vector;
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode() ^ this.chunkType.hashCode() ^ this.startIndex ^ this.endIndex;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMStringChunk) {
            XOMStringChunk xOMStringChunk = (XOMStringChunk)object;
            return this.parent.equals(xOMStringChunk.parent) && this.chunkType == xOMStringChunk.chunkType && this.startIndex == xOMStringChunk.startIndex && this.endIndex == xOMStringChunk.endIndex;
        }
        return false;
    }

    private static class StringChunkInfo {
        public String parentContent;
        public int startChunkIndex;
        public int endChunkIndex;
        public int startCharIndex;
        public int endCharIndex;
        public int deleteEndCharIndex;

        private StringChunkInfo() {
        }
    }
}

