/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.type;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.type.XOMListType;
import com.kreative.openxion.xom.type.XOMNumericDataType;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMIntegerType
extends XOMNumericDataType<XOMInteger> {
    private static final long serialVersionUID = 1L;
    public static final XOMIntegerType instance = new XOMIntegerType();
    public static final XOMListType listInstance = new XOMListType("integers", 0, instance);

    private XOMIntegerType() {
        super("integer", 0, XOMInteger.class);
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        if (xOMVariant instanceof XOMNumber) {
            try {
                ((XOMNumber)xOMVariant).toBigDecimal().toBigIntegerExact();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (xOMVariant instanceof XOMComplex) {
            if (((XOMComplex)xOMVariant).isReal()) {
                try {
                    ((XOMComplex)xOMVariant).toBigDecimals()[0].toBigIntegerExact();
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            return bl;
        }
        if (string.equalsIgnoreCase("inf") || string.equalsIgnoreCase("-inf") || string.equalsIgnoreCase("nan")) {
            return true;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        try {
            xNContext.getNumberFormat().parseBigInteger(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected XOMInteger makeInstanceFromImpl(XNContext xNContext) {
        return XOMInteger.ZERO;
    }

    @Override
    protected XOMInteger makeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        if (xOMVariant instanceof XOMNumber) {
            try {
                BigInteger bigInteger = ((XOMNumber)xOMVariant).toBigDecimal().toBigIntegerExact();
                return new XOMInteger(bigInteger);
            }
            catch (Exception exception) {
                throw new XOMMorphError(this.typeName);
            }
        }
        if (xOMVariant instanceof XOMComplex) {
            if (((XOMComplex)xOMVariant).isReal()) {
                try {
                    BigInteger bigInteger = ((XOMComplex)xOMVariant).toBigDecimals()[0].toBigIntegerExact();
                    return new XOMInteger(bigInteger);
                }
                catch (Exception exception) {
                    throw new XOMMorphError(this.typeName);
                }
            }
            throw new XOMMorphError(this.typeName);
        }
        throw new XOMMorphError(this.typeName);
    }

    @Override
    protected XOMInteger makeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            if (bl) {
                return XOMInteger.ZERO;
            }
            throw new XOMMorphError(this.typeName);
        }
        if (string.equalsIgnoreCase("inf")) {
            return XOMInteger.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-inf")) {
            return XOMInteger.NEGATIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("nan")) {
            return XOMInteger.NaN;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        try {
            BigInteger bigInteger = xNContext.getNumberFormat().parseBigInteger(string);
            return new XOMInteger(bigInteger);
        }
        catch (Exception exception) {
            throw new XOMMorphError(this.typeName);
        }
    }
}

