/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc;

import com.kreative.xiondoc.HTMLSDOMGenerator;
import com.kreative.xiondoc.sdom.Script;
import com.kreative.xiondoc.xdom.Article;
import com.kreative.xiondoc.xdom.Descriptor;
import com.kreative.xiondoc.xdom.Dialect;
import com.kreative.xiondoc.xdom.DocumentationSet;
import com.kreative.xiondoc.xdom.Precedence;
import com.kreative.xiondoc.xdom.Term;
import com.kreative.xiondoc.xdom.TermName;
import com.kreative.xiondoc.xdom.TermSpec;
import com.kreative.xiondoc.xdom.TermType;
import com.kreative.xiondoc.xdom.VersionNumber;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLXDOMGenerator {
    private static final String LOG_ENCODING = "UTF-8";
    private static final String CSS_ENCODING = "UTF-8";
    private static final String HTML_ENCODING = "UTF-8";
    private DocumentationSet ds;
    private File base;
    private String basePath;
    private HTMLSDOMGenerator sdomg;
    private PrintWriter out;
    private static String mainCSS = null;
    private static String navCSS = null;
    private static final Comparator<TermSpec> termSpecComparator = new Comparator<TermSpec>(){

        @Override
        public int compare(TermSpec termSpec, TermSpec termSpec2) {
            return HTMLXDOMGenerator.compareTermNames(termSpec.getName(), termSpec2.getName());
        }
    };

    public HTMLXDOMGenerator(DocumentationSet documentationSet, File file, boolean bl) {
        this.ds = documentationSet;
        this.base = file;
        this.basePath = file.getAbsolutePath();
        this.sdomg = new HTMLSDOMGenerator(documentationSet.terms());
        if (bl) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
        } else {
            this.out = null;
        }
    }

    public HTMLXDOMGenerator(DocumentationSet documentationSet, File file, PrintWriter printWriter) {
        this.ds = documentationSet;
        this.base = file;
        this.basePath = file.getAbsolutePath();
        this.sdomg = new HTMLSDOMGenerator(documentationSet.terms());
        this.out = printWriter;
    }

    public void writeAll() throws IOException {
        this.deltree(this.base);
        this.base.mkdir();
        for (Dialect dialect : this.ds.dialects()) {
            for (VersionNumber versionNumber : dialect.versions()) {
                if (this.out != null) {
                    this.out.println("Writing " + dialect.type().toString().toLowerCase() + " " + dialect.name() + " " + versionNumber.toString() + "...");
                }
                this.write(dialect, versionNumber, versionNumber);
            }
            if (this.out != null) {
                this.out.println("Writing " + dialect.type().toString().toLowerCase() + " " + dialect.name() + " (all versions)...");
            }
            this.write(dialect, null, (VersionNumber)dialect.versions().last());
        }
        if (this.out != null) {
            this.out.println("Writing all dialects...");
        }
        this.write(null, null, null);
    }

    private void write(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        String string;
        if (dialect == null) {
            string = null;
            this.sdomg.unsetDialect();
        } else {
            string = dialect.name();
            this.sdomg.setDialect(string, dialect.getTitle(), versionNumber2);
        }
        Vector<TermSpec> vector = new Vector<TermSpec>();
        for (Term term : this.ds.terms().getTerms(null, null, string, versionNumber2)) {
            for (TermName object : term.names()) {
                if (dialect != null && !object.getDialects().matches(string, versionNumber2)) continue;
                vector.add(new TermSpec(term.type(), object.getName()));
            }
        }
        Collections.sort(vector, new Comparator<TermSpec>(){

            @Override
            public int compare(TermSpec termSpec, TermSpec termSpec2) {
                if (termSpec.getName().equalsIgnoreCase(termSpec2.getName())) {
                    return termSpec.getType().compareTo(termSpec2.getType());
                }
                return HTMLXDOMGenerator.compareTermNames(termSpec.getName(), termSpec2.getName());
            }
        });
        for (TermType termType : TermType.values()) {
            TreeMap<TermSpec, Term> treeMap = new TreeMap<TermSpec, Term>();
            for (Term term : this.ds.terms().getTerms(termType, null, string, versionNumber2)) {
                for (TermName termName : term.names()) {
                    if (dialect != null && !termName.getDialects().matches(string, versionNumber2)) continue;
                    treeMap.put(new TermSpec(termType, termName.getName()), term);
                }
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                this.sdomg.setTerm(((TermSpec)entry.getKey()).getType(), ((TermSpec)entry.getKey()).getName());
                this.writeVocabularyItem(dialect, versionNumber, versionNumber2, termType, ((TermSpec)entry.getKey()).getName(), (Term)entry.getValue(), vector, treeMap);
            }
            this.sdomg.unsetTerm();
            this.writeChapter(dialect, versionNumber, termType, treeMap);
            this.writeIndex(dialect, versionNumber, termType, treeMap);
        }
        this.writeAllIndex(dialect, versionNumber, vector);
        this.writeSuperIndex(dialect, versionNumber, vector);
        this.writeColors(dialect, versionNumber, versionNumber2);
        this.writeOperators(dialect, versionNumber, versionNumber2);
        this.writeConstants(dialect, versionNumber, versionNumber2);
        this.writeSynonyms(dialect, versionNumber, versionNumber2);
        List<Article> list = dialect == null ? this.ds.articles() : dialect.articles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Article article = (Article)iterator.next();
            this.writeArticle(dialect, versionNumber, article);
        }
        this.writeVocabTypeIndex(dialect, versionNumber, versionNumber2, list);
        this.writeDialectIndex(dialect, versionNumber);
        this.writeIntro(dialect, versionNumber);
        this.writeMainCSS(dialect, versionNumber);
        this.writeNavCSS(dialect, versionNumber);
        this.writeFrameset(dialect, versionNumber);
    }

    private void writeVocabularyItem(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2, TermType termType, String string, Term term, List<TermSpec> list, SortedMap<TermSpec, Term> sortedMap) throws IOException {
        Vector<TermSpec> vector;
        this.sdomg.setURLPrefix("../");
        PrintWriter printWriter = this.openFile(dialect, versionNumber, termType, string);
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + " - " + HTMLXDOMGenerator.htmlencode(string) + "</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + " - " + HTMLXDOMGenerator.htmlencode(string) + "</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + " - " + HTMLXDOMGenerator.htmlencode(string) + "</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + ", " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + ", " + HTMLXDOMGenerator.htmlencode(string) + "\">");
        printWriter.println("<meta name=\"description\" content=\"This page describes the " + HTMLXDOMGenerator.htmlencode(string) + " " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</h1>");
        printWriter.println("<h2>" + HTMLXDOMGenerator.htmlencode(string) + "</h2>");
        printWriter.println("<h3>Supported By</h3>");
        printWriter.println("<ul class=\"block unorderedlist indent0 border0 nobullet\">");
        for (Dialect object2 : this.ds.dialects()) {
            boolean termSpec = true;
            block1: for (VersionNumber versionNumber3 : object2.versions()) {
                for (TermName termName : term.names()) {
                    if (!termName.getDialects().matches(object2.name(), versionNumber3)) continue;
                    if (termSpec) {
                        printWriter.print("<li>" + HTMLXDOMGenerator.htmlencode(object2.getTitle()) + " (" + HTMLXDOMGenerator.htmlencode(versionNumber3.toString()));
                        termSpec = false;
                        continue block1;
                    }
                    printWriter.print(", " + HTMLXDOMGenerator.htmlencode(versionNumber3.toString()));
                    continue block1;
                }
            }
            if (termSpec) continue;
            printWriter.println(")</li>");
        }
        printWriter.println("</ul>");
        if (term.hasAppliesTo()) {
            printWriter.println("<h3>Applies To</h3>");
            printWriter.println(this.sdomg.generateSectionHTML(term.getAppliesTo()));
        }
        if (term.descriptors() != null && !term.descriptors().isEmpty()) {
            printWriter.println("<h3>Descriptors</h3>");
            printWriter.println("<ul class=\"block unorderedlist indent0 border0 nobullet\">");
            for (Descriptor descriptor : term.descriptors()) {
                String string2 = descriptor.getExample(string);
                string2 = string2.contains("steve") ? "put " + string2 + " into bill" : "put " + string2 + " into steve";
                printWriter.println("<li>" + HTMLXDOMGenerator.htmlencode(descriptor.getName()) + ": <code>" + HTMLXDOMGenerator.htmlencode(string2) + "</code></li>");
            }
            printWriter.println("</ul>");
        }
        if (term.properties() != null && !term.properties().isEmpty()) {
            vector = new Vector();
            vector.addAll(term.properties());
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TermSpec termSpec = (TermSpec)iterator.next();
                if (!this.ds.terms().getTerms(termSpec.getType(), termSpec.getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) continue;
                iterator.remove();
            }
            if (!vector.isEmpty()) {
                printWriter.println("<h3>Properties</h3>");
                printWriter.print("<p class=\"block paragraph indent0\">");
                boolean bl = true;
                for (TermSpec termSpec : vector) {
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.print(", ");
                    }
                    printWriter.print("<code><a href=\"../" + HTMLXDOMGenerator.htmlencode(HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName())) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code>");
                }
                printWriter.println("</p>");
            }
        }
        if (term.hasSyntax()) {
            printWriter.println("<h3>Syntax</h3>");
            printWriter.println(this.sdomg.generateSectionHTML(term.getSyntax()));
        }
        if (term.hasExamples()) {
            if (term.getExamples().size(Script.class) > 1) {
                printWriter.println("<h3>Examples</h3>");
            } else {
                printWriter.println("<h3>Example</h3>");
            }
            printWriter.println(this.sdomg.generateSectionHTML(term.getExamples()));
        }
        if (term.hasDescription()) {
            printWriter.println("<h3>Description</h3>");
            printWriter.println(this.sdomg.generateSectionHTML(term.getDescription()));
        }
        if (term.hasScripts()) {
            if (term.getScripts().size(Script.class) > 1) {
                printWriter.println("<h3>Scripts</h3>");
            } else {
                printWriter.println("<h3>Script</h3>");
            }
            printWriter.println(this.sdomg.generateSectionHTML(term.getScripts()));
        }
        if (term.hasNotes()) {
            if (term.getNotes().size() > 1) {
                printWriter.println("<h3>Notes</h3>");
            } else {
                printWriter.println("<h3>Note</h3>");
            }
            printWriter.println(this.sdomg.generateSectionHTML(term.getNotes()));
        }
        if (term.hasSecurity()) {
            printWriter.println("<h3>Security</h3>");
            printWriter.println(this.sdomg.generateSectionHTML(term.getSecurity()));
        }
        if (term.hasCompatibility()) {
            printWriter.println("<h3>Compatibility</h3>");
            printWriter.println(this.sdomg.generateSectionHTML(term.getCompatibility()));
        }
        if (term.hasSynonyms(dialect == null ? null : dialect.name(), versionNumber2)) {
            vector = new Vector();
            vector.addAll(term.getSynonyms(dialect == null ? null : dialect.name(), versionNumber2, string));
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TermSpec termSpec = (TermSpec)iterator.next();
                if (!this.ds.terms().getTerms(termSpec.getType(), termSpec.getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) continue;
                iterator.remove();
            }
            if (!vector.isEmpty()) {
                if (vector.size() > 1) {
                    printWriter.println("<h3>Synonyms</h3>");
                } else {
                    printWriter.println("<h3>Synonym</h3>");
                }
                printWriter.print("<p class=\"block paragraph indent0\">");
                boolean bl = true;
                for (TermSpec termSpec : vector) {
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.print(", ");
                    }
                    printWriter.print("<code><a href=\"../" + HTMLXDOMGenerator.htmlencode(HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName())) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code>");
                }
                printWriter.println("</p>");
            }
        }
        if (term.seeAlso() != null && !term.seeAlso().isEmpty()) {
            vector = new Vector<TermSpec>();
            vector.addAll(term.seeAlso());
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TermSpec termSpec = (TermSpec)iterator.next();
                if (!this.ds.terms().getTerms(termSpec.getType(), termSpec.getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) continue;
                iterator.remove();
            }
            if (!vector.isEmpty()) {
                printWriter.println("<h3>See Also</h3>");
                printWriter.print("<p class=\"block paragraph indent0\">");
                boolean bl = true;
                for (TermSpec termSpec : vector) {
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.print(", ");
                    }
                    printWriter.print("<code><a href=\"../" + HTMLXDOMGenerator.htmlencode(HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName())) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code>");
                }
                printWriter.println("</p>");
            }
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        this.sdomg.unsetURLPrefix();
    }

    private void writeChapter(Dialect dialect, VersionNumber versionNumber, TermType termType, SortedMap<TermSpec, Term> sortedMap) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, termType, "index");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + ", " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + ", " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + " descriptions\">");
        printWriter.println("<meta name=\"description\" content=\"This page describes the " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + " supported by " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</h1>");
        printWriter.println("<p class=\"block paragraph indent0\">This page describes the " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + " supported by " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".</p>");
        printWriter.println("<ul class=\"block unorderedlist indent0 border0 nobullet\">");
        for (TermSpec termSpec : sortedMap.keySet()) {
            printWriter.println("<li><code><a href=\"" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></li>");
        }
        printWriter.println("</ul>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeIndex(Dialect dialect, VersionNumber versionNumber, TermType termType, SortedMap<TermSpec, Term> sortedMap) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, termType.getCode() + "-index.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " " + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + ", " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + ", " + HTMLXDOMGenerator.htmlencode(termType.getSingular()) + " index\">");
        printWriter.println("<meta name=\"description\" content=\"A list of XION " + HTMLXDOMGenerator.htmlencode(termType.getPlural()) + " with documentation available in " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xionnav.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(termType.getPluralTitleCase()) + "</h1>");
        printWriter.println("<ul>");
        for (TermSpec termSpec : sortedMap.keySet()) {
            printWriter.println("<li><code><a href=\"" + HTMLXDOMGenerator.fnencode(termType.getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\" target=\"xncontent\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></li>");
        }
        printWriter.println("</ul>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeAllIndex(Dialect dialect, VersionNumber versionNumber, List<TermSpec> list) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "all-index.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Vocabulary Index</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Vocabulary Index</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Vocabulary Index</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", vocabulary, all vocabulary, vocabulary index\">");
        printWriter.println("<meta name=\"description\" content=\"A list of XION vocabulary terms with documentation available in " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xionnav.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>All Vocabulary</h1>");
        printWriter.println("<ul>");
        for (TermSpec termSpec : list) {
            printWriter.println("<li><code><a href=\"" + HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\" target=\"xncontent\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code> <span class=\"expl\">(" + HTMLXDOMGenerator.htmlencode(termSpec.getType().getSingular()) + ")</span></li>");
        }
        printWriter.println("</ul>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeSuperIndex(Dialect dialect, VersionNumber versionNumber, List<TermSpec> list) throws IOException {
        PrintWriter[] printWriterArray = new PrintWriter[27];
        printWriterArray[0] = this.openFile(dialect, versionNumber, "index-symb.html");
        int n = 1;
        for (int i = 97; n < printWriterArray.length && i <= 122; ++n, ++i) {
            printWriterArray[n] = this.openFile(dialect, versionNumber, "index-" + (char)i + ".html");
        }
        for (n = 0; n < printWriterArray.length; ++n) {
            printWriterArray[n].println("<html>");
            printWriterArray[n].println("<head>");
            if (dialect == null) {
                printWriterArray[n].println("<title>XION Vocabulary Index - " + (n == 0 ? "Symbols" : "" + (n - 1 + 65)) + "</title>");
            } else if (versionNumber == null) {
                printWriterArray[n].println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Vocabulary Index - " + (n == 0 ? "Symbols" : "" + (n - 1 + 65)) + "</title>");
            } else {
                printWriterArray[n].println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Vocabulary Index - " + (n == 0 ? "Symbols" : "" + (n - 1 + 65)) + "</title>");
            }
            printWriterArray[n].println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            printWriterArray[n].println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
            printWriterArray[n].println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", vocabulary, all vocabulary, vocabulary index\">");
            printWriterArray[n].println("<meta name=\"description\" content=\"A list of XION vocabulary terms with documentation available in " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
            printWriterArray[n].println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
            printWriterArray[n].println("</head>");
            printWriterArray[n].println("<body>");
            printWriterArray[n].println("<h1>" + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " Vocabulary Index</h1>");
            printWriterArray[n].println("<p class=\"indexnav\"><a href=\"index-a.html\">A</a> - <a href=\"index-b.html\">B</a> - <a href=\"index-c.html\">C</a> - <a href=\"index-d.html\">D</a> - <a href=\"index-e.html\">E</a> - <a href=\"index-f.html\">F</a> - <a href=\"index-g.html\">G</a> - <a href=\"index-h.html\">H</a> - <a href=\"index-i.html\">I</a> - <a href=\"index-j.html\">J</a> - <a href=\"index-k.html\">K</a> - <a href=\"index-l.html\">L</a> - <a href=\"index-m.html\">M</a> - <a href=\"index-n.html\">N</a> - <a href=\"index-o.html\">O</a> - <a href=\"index-p.html\">P</a> - <a href=\"index-q.html\">Q</a> - <a href=\"index-r.html\">R</a> - <a href=\"index-s.html\">S</a> - <a href=\"index-t.html\">T</a> - <a href=\"index-u.html\">U</a> - <a href=\"index-v.html\">V</a> - <a href=\"index-w.html\">W</a> - <a href=\"index-x.html\">X</a> - <a href=\"index-y.html\">Y</a> - <a href=\"index-z.html\">Z</a> - <a href=\"index-symb.html\">#</a></p>");
            printWriterArray[n].println("<table class=\"block table indent0 border0\">");
            printWriterArray[n].println("<tr><th>Term</th><th>Type</th></tr>");
        }
        for (TermSpec termSpec : list) {
            char c = termSpec.getName().charAt(0);
            int n2 = c >= 'a' && c <= 'z' ? c - 97 + 1 : (c >= 'A' && c <= 'Z' ? c - 65 + 1 : 0);
            printWriterArray[n2].println("<tr><td><code><a href=\"" + HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a>" + "</td>" + "<td>" + HTMLXDOMGenerator.htmlencode(termSpec.getType().getSingular()) + "</td>" + "</tr>");
        }
        for (int i = 0; i < printWriterArray.length; ++i) {
            printWriterArray[i].println("</table>");
            printWriterArray[i].println("</body>");
            printWriterArray[i].println("</html>");
            printWriterArray[i].close();
        }
    }

    private void writeColors(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        Object object;
        Object object22;
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "colors.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Color Chart</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Color Chart</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Color Chart</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", color, colors, colour, colours, color constants, colour constants, RGB values\">");
        printWriter.println("<meta name=\"description\" content=\"This page lists the names, RGB values, and color swatches of each color defined as a constant in " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " Color Chart</h1>");
        Vector<TermSpec> vector = new Vector<TermSpec>();
        final HashMap<TermSpec, int[]> hashMap = new HashMap<TermSpec, int[]>();
        for (Term serializable : this.ds.terms().getTerms(TermType.CONSTANT, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            if (serializable.getDataType() == null || !serializable.getDataType().getName().equalsIgnoreCase("color") && !serializable.getDataType().getName().equalsIgnoreCase("colour") || serializable.getDataValue() == null) continue;
            for (Object object22 : serializable.names()) {
                String[] stringArray;
                if (dialect != null && !((TermName)object22).getDialects().matches(dialect.name(), versionNumber2) || (stringArray = serializable.getDataValue().trim().split("\\s*,\\s*")).length != 3) continue;
                try {
                    int[] nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
                    TermSpec termSpec = new TermSpec(TermType.CONSTANT, ((TermName)object22).getName());
                    vector.add(termSpec);
                    hashMap.put(termSpec, nArray);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        Collections.sort(vector, termSpecComparator);
        printWriter.println("<h2>Colors by Name</h2>");
        printWriter.println("<p class=\"block paragraph indent0\"><a name=\"byname\">The table below lists the name, the RGB value, and a color swatch for each <code><a href=\"dt/color.html\">color</a></code> defined as a constant, sorted by name. See also <a href=\"#byhue\">by hue</a>.</a></p>");
        printWriter.println("<table class=\"block table indent0 border0\">");
        printWriter.println("<tr><th>Name</th><th>R</th><th>G</th><th>B</th><th>Swatch</th></tr>");
        for (TermSpec termSpec : vector) {
            object = (int[])hashMap.get(termSpec);
            object22 = "000000" + Integer.toString(object[0] / 257 << 16 | object[1] / 257 << 8 | object[2] / 257, 16);
            object22 = ((String)object22).substring(((String)object22).length() - 6);
            printWriter.print("<tr>");
            printWriter.print("<td><code><a href=\"cn/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
            printWriter.print("<td>" + (int)object[0] + "</td><td>" + (int)object[1] + "</td><td>" + (int)object[2] + "</td>");
            printWriter.print("<td style=\"width: 100px; background: #" + (String)object22 + ";\">&nbsp;</td>");
            printWriter.println("</tr>");
        }
        printWriter.println("</table>");
        Collections.sort(vector, new Comparator<TermSpec>(){

            @Override
            public int compare(TermSpec termSpec, TermSpec termSpec2) {
                int[] nArray = (int[])hashMap.get(termSpec);
                int[] nArray2 = (int[])hashMap.get(termSpec2);
                float[] fArray = Color.RGBtoHSB(nArray[0] / 257, nArray[1] / 257, nArray[2] / 257, new float[3]);
                float[] fArray2 = Color.RGBtoHSB(nArray2[0] / 257, nArray2[1] / 257, nArray2[2] / 257, new float[3]);
                double d = Math.atan2(fArray[1], fArray[2]);
                double d2 = Math.atan2(fArray2[1], fArray2[2]);
                double d3 = Math.hypot(fArray[1], fArray[2]);
                double d4 = Math.hypot(fArray2[1], fArray2[2]);
                if ((double)Math.abs(fArray[0] - fArray2[0]) > 0.01) {
                    return (int)Math.signum(fArray[0] - fArray2[0]);
                }
                if (Math.abs(d - d2) > 0.01) {
                    return (int)Math.signum(d - d2);
                }
                if (Math.abs(d3 - d4) > 0.01) {
                    return (int)Math.signum(d3 - d4);
                }
                return HTMLXDOMGenerator.compareTermNames(termSpec.getName(), termSpec2.getName());
            }
        });
        printWriter.println("<h2>Colors by Hue</h2>");
        printWriter.println("<p class=\"block paragraph indent0\"><a name=\"byhue\">The table below lists the name, the RGB value, and a color swatch for each <code><a href=\"dt/color.html\">color</a></code> defined as a constant, sorted by hue. See also <a href=\"#byname\">by name</a>.</a></p>");
        printWriter.println("<table class=\"block table indent0 border0\">");
        printWriter.println("<tr><th>Name</th><th>R</th><th>G</th><th>B</th><th>Swatch</th></tr>");
        for (TermSpec termSpec : vector) {
            object = (int[])hashMap.get(termSpec);
            object22 = "000000" + Integer.toString(object[0] / 257 << 16 | object[1] / 257 << 8 | object[2] / 257, 16);
            object22 = ((String)object22).substring(((String)object22).length() - 6);
            printWriter.print("<tr>");
            printWriter.print("<td><code><a href=\"cn/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
            printWriter.print("<td>" + (int)object[0] + "</td><td>" + (int)object[1] + "</td><td>" + (int)object[2] + "</td>");
            printWriter.print("<td style=\"width: 100px; background: #" + (String)object22 + ";\">&nbsp;</td>");
            printWriter.println("</tr>");
        }
        printWriter.println("</table>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        printWriter.close();
    }

    private void writeOperators(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "precedence.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Operator Precedence Table</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Operator Precedence Table</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Operator Precedence Table</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", operator, operators, operator precedence, operator precedence chart, operator precedence table\">");
        printWriter.println("<meta name=\"description\" content=\"This page shows the order of precedence of operators in " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " Operator Precedence Table</h1>");
        printWriter.println("<p class=\"block paragraph indent0\">The table below shows the order of precedence of operators in " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ". " + "In a complex expression containing more than one operator, the operations " + "indicated by operators with lower-numbered precedence will be performed before " + "those with higher-numbered precedence. Operators of equal precedence are " + "evaluated left-to-right, except for exponentiation, which goes right-to-left. " + "If you use parentheses, the innermost parenthetical expression is evaluated " + "first.</p>");
        printWriter.println("<table class=\"block table indent0 border0 linedrowgroups\">");
        printWriter.println("<thead>");
        printWriter.println("<tr>");
        printWriter.println("<th>Order</th>");
        printWriter.println("<th>Operators</th>");
        printWriter.println("<th>Type of Operator</th>");
        printWriter.println("</tr>");
        printWriter.println("</thead>");
        HashMap<TermSpec, Term> hashMap = new HashMap<TermSpec, Term>();
        Vector vector = new Vector();
        for (Term precedenceArray : this.ds.terms().getTerms(TermType.OPERATOR, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            for (TermName termName : precedenceArray.names()) {
                if (dialect != null && !termName.getDialects().matches(dialect.name(), versionNumber2)) continue;
                hashMap.put(new TermSpec(TermType.OPERATOR, termName.getName()), precedenceArray);
            }
        }
        int n = 1;
        for (Precedence precedence : Precedence.values()) {
            Map.Entry entry2;
            vector.clear();
            for (Map.Entry entry2 : hashMap.entrySet()) {
                if (!((Term)entry2.getValue()).hasPrecedence() || ((Term)entry2.getValue()).getPrecedence() != precedence) continue;
                vector.add(entry2.getKey());
            }
            Collections.sort(vector, termSpecComparator);
            if (vector.isEmpty()) continue;
            printWriter.println("<tbody>");
            boolean bl = true;
            entry2 = vector.iterator();
            while (entry2.hasNext()) {
                TermSpec termSpec = (TermSpec)entry2.next();
                printWriter.print("<tr>");
                if (bl) {
                    printWriter.print("<td>" + n++ + " - " + HTMLXDOMGenerator.htmlencode(precedence.getName()) + "</td>");
                    bl = false;
                } else {
                    printWriter.print("<td></td>");
                }
                printWriter.print("<td><code><a href=\"op/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
                Term term = (Term)hashMap.get(termSpec);
                printWriter.print("<td>" + (term.hasDescriptionShort() ? HTMLXDOMGenerator.htmlencode(term.getDescriptionShort()) : "") + "</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</tbody>");
        }
        printWriter.println("</table>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeConstants(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        Object object;
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "constants.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Constant Summary</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Constant Summary</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Constant Summary</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", constant, constants, built-in constant, built-in constants, constant summary\">");
        printWriter.println("<meta name=\"description\" content=\"This page summarizes " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + "'s built-in constants.\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " Constant Summary</h1>");
        printWriter.println("<p class=\"block paragraph indent0\">This page summarizes " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + "'s built-in constants." + " A constant is a named value that never changes." + " You cannot change its value or use its name as a variable name." + " If you try, the interpreter will trigger a script error.</p>");
        final HashMap<TermSpec, Term> hashMap = new HashMap<TermSpec, Term>();
        Vector<TermSpec> vector = new Vector<TermSpec>();
        for (Term serializable : this.ds.terms().getTerms(TermType.CONSTANT, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            for (TermName termName : serializable.names()) {
                if (dialect != null && !termName.getDialects().matches(dialect.name(), versionNumber2)) continue;
                TermSpec termSpec = new TermSpec(TermType.CONSTANT, termName.getName());
                hashMap.put(termSpec, serializable);
                vector.add(termSpec);
            }
        }
        Collections.sort(vector, termSpecComparator);
        printWriter.println("<h2>Constants by Name</h2>");
        printWriter.println("<p class=\"block paragraph indent0\"><a name=\"byname\">The table below lists all the built-in constants by name. See also <a href=\"#bytype\">by data type</a> and <a href=\"#byvalue\">by value</a>.</a></p>");
        printWriter.println("<table class=\"block table indent0 border0\">");
        printWriter.println("<thead>");
        printWriter.println("<tr>");
        printWriter.println("<th>Constant Name</th>");
        printWriter.println("<th>Data Type</th>");
        printWriter.println("<th>Value</th>");
        printWriter.println("</tr>");
        printWriter.println("</thead>");
        printWriter.println("<tbody>");
        for (TermSpec termSpec : vector) {
            object = (Term)hashMap.get(termSpec);
            printWriter.println("<tr>");
            printWriter.println("<td><code><a href=\"cn/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
            if (((Term)object).hasDataType()) {
                boolean bl = !this.ds.terms().getTerms(TermType.DATA_TYPE, ((Term)object).getDataType().getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty();
                printWriter.println("<td><code>");
                if (bl) {
                    printWriter.println("<a href=\"dt/" + HTMLXDOMGenerator.fnencode(((Term)object).getDataType().getName()) + ".html\">");
                }
                printWriter.println(HTMLXDOMGenerator.htmlencode(((Term)object).getDataType().getName()));
                if (bl) {
                    printWriter.println("</a>");
                }
                printWriter.println("</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            if (((Term)object).hasDataValue()) {
                printWriter.println("<td><code>" + HTMLXDOMGenerator.htmlencode(((Term)object).getDataValue()) + "</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            printWriter.println("</tr>");
        }
        printWriter.println("</tbody>");
        printWriter.println("</table>");
        Collections.sort(vector, new Comparator<TermSpec>(){

            @Override
            public int compare(TermSpec termSpec, TermSpec termSpec2) {
                Term term = (Term)hashMap.get(termSpec);
                Term term2 = (Term)hashMap.get(termSpec2);
                String string = term.hasDataType() ? term.getDataType().getName() : "variant";
                String string2 = term2.hasDataType() ? term2.getDataType().getName() : "variant";
                return string.compareToIgnoreCase(string2);
            }
        });
        printWriter.println("<h2>Constants by Type</h2>");
        printWriter.println("<p class=\"block paragraph indent0\"><a name=\"bytype\">The table below lists all the built-in constants by data type. See also <a href=\"#byname\">by name</a> and <a href=\"#byvalue\">by value</a>.</a></p>");
        printWriter.println("<table class=\"block table indent0 border0\">");
        printWriter.println("<thead>");
        printWriter.println("<tr>");
        printWriter.println("<th>Constant Name</th>");
        printWriter.println("<th>Data Type</th>");
        printWriter.println("<th>Value</th>");
        printWriter.println("</tr>");
        printWriter.println("</thead>");
        printWriter.println("<tbody>");
        for (TermSpec termSpec : vector) {
            object = (Term)hashMap.get(termSpec);
            printWriter.println("<tr>");
            printWriter.println("<td><code><a href=\"cn/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
            if (((Term)object).hasDataType()) {
                boolean bl = !this.ds.terms().getTerms(TermType.DATA_TYPE, ((Term)object).getDataType().getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty();
                printWriter.println("<td><code>");
                if (bl) {
                    printWriter.println("<a href=\"dt/" + HTMLXDOMGenerator.fnencode(((Term)object).getDataType().getName()) + ".html\">");
                }
                printWriter.println(HTMLXDOMGenerator.htmlencode(((Term)object).getDataType().getName()));
                if (bl) {
                    printWriter.println("</a>");
                }
                printWriter.println("</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            if (((Term)object).hasDataValue()) {
                printWriter.println("<td><code>" + HTMLXDOMGenerator.htmlencode(((Term)object).getDataValue()) + "</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            printWriter.println("</tr>");
        }
        printWriter.println("</tbody>");
        printWriter.println("</table>");
        Collections.sort(vector, new Comparator<TermSpec>(){

            @Override
            public int compare(TermSpec termSpec, TermSpec termSpec2) {
                Term term = (Term)hashMap.get(termSpec);
                Term term2 = (Term)hashMap.get(termSpec2);
                String string = term.hasDataValue() ? term.getDataValue() : "";
                String string2 = term2.hasDataValue() ? term2.getDataValue() : "";
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigDecimal bigDecimal2 = new BigDecimal(string2);
                    return bigDecimal.compareTo(bigDecimal2);
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareToIgnoreCase(string2);
                }
            }
        });
        printWriter.println("<h2>Constants by Value</h2>");
        printWriter.println("<p class=\"block paragraph indent0\"><a name=\"byvalue\">The table below lists all the built-in constants by value. See also <a href=\"#byname\">by name</a> and <a href=\"#bytype\">by data type</a>.</a></p>");
        printWriter.println("<table class=\"block table indent0 border0\">");
        printWriter.println("<thead>");
        printWriter.println("<tr>");
        printWriter.println("<th>Constant Name</th>");
        printWriter.println("<th>Data Type</th>");
        printWriter.println("<th>Value</th>");
        printWriter.println("</tr>");
        printWriter.println("</thead>");
        printWriter.println("<tbody>");
        for (TermSpec termSpec : vector) {
            object = (Term)hashMap.get(termSpec);
            printWriter.println("<tr>");
            printWriter.println("<td><code><a href=\"cn/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></code></td>");
            if (((Term)object).hasDataType()) {
                boolean bl = !this.ds.terms().getTerms(TermType.DATA_TYPE, ((Term)object).getDataType().getName(), dialect == null ? null : dialect.name(), versionNumber2).isEmpty();
                printWriter.println("<td><code>");
                if (bl) {
                    printWriter.println("<a href=\"dt/" + HTMLXDOMGenerator.fnencode(((Term)object).getDataType().getName()) + ".html\">");
                }
                printWriter.println(HTMLXDOMGenerator.htmlencode(((Term)object).getDataType().getName()));
                if (bl) {
                    printWriter.println("</a>");
                }
                printWriter.println("</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            if (((Term)object).hasDataValue()) {
                printWriter.println("<td><code>" + HTMLXDOMGenerator.htmlencode(((Term)object).getDataValue()) + "</code></td>");
            } else {
                printWriter.println("<td></td>");
            }
            printWriter.println("</tr>");
        }
        printWriter.println("</tbody>");
        printWriter.println("</table>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeSynonyms(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        SequencedCollection<TermSpec> sequencedCollection;
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "synonyms.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Synonyms</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Synonyms</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Synonyms</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", synonym, synonyms\">");
        printWriter.println("<meta name=\"description\" content=\"This page lists the alternative ways that " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " terms can be used.\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " Synonyms</h1>");
        printWriter.println("<p class=\"block paragraph indent0\">The table below lists the alternative ways that " + (dialect == null ? "XION" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + " terms can be used.</p>");
        Vector<Term> vector = new Vector<Term>();
        final HashMap hashMap = new HashMap();
        for (Term term : this.ds.terms().getTerms(null, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            if (!term.hasSynonyms(dialect == null ? null : dialect.name(), versionNumber2)) continue;
            sequencedCollection = term.getSynonyms(dialect == null ? null : dialect.name(), versionNumber2, null);
            Vector<TermSpec> vector2 = new Vector<TermSpec>();
            vector2.addAll(sequencedCollection);
            Collections.sort(vector2, termSpecComparator);
            vector.add(term);
            hashMap.put(term, vector2);
        }
        Collections.sort(vector, new Comparator<Term>(){

            @Override
            public int compare(Term term, Term term2) {
                return HTMLXDOMGenerator.compareTermNames(((TermSpec)((List)hashMap.get(term)).get(0)).getName(), ((TermSpec)((List)hashMap.get(term2)).get(0)).getName());
            }
        });
        printWriter.println("<table class=\"block table indent0 border0 linedrowgroups\">");
        printWriter.println("<thead>");
        printWriter.println("<tr>");
        printWriter.println("<th>Synonym</th>");
        printWriter.println("<th>Term</th>");
        printWriter.println("</tr>");
        printWriter.println("</thead>");
        for (Term term : vector) {
            printWriter.println("<tbody>");
            sequencedCollection = (List)hashMap.get(term);
            int n = sequencedCollection.size();
            for (int i = 0; i < n; ++i) {
                TermSpec termSpec = (TermSpec)sequencedCollection.get(i);
                if (i % 4 == 0) {
                    printWriter.println("<tr>");
                }
                printWriter.println("<td><code><a href=\"" + HTMLXDOMGenerator.fnencode(termSpec.getType().getCode()) + "/" + HTMLXDOMGenerator.fnencode(termSpec.getName()) + ".html\">" + HTMLXDOMGenerator.htmlencode(termSpec.getName()) + "</a></td>");
                if (i % 4 != 3) continue;
                printWriter.println("</tr>");
            }
            while (n % 4 != 0) {
                printWriter.println("<td>&nbsp;</td>");
                if (n % 4 == 3) {
                    printWriter.println("</tr>");
                }
                ++n;
            }
            printWriter.println("</tbody>");
        }
        printWriter.println("</table>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeArticle(Dialect dialect, VersionNumber versionNumber, Article article) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, HTMLXDOMGenerator.fnencode(article.name()) + ".html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(article.getTitle()) + "</title>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", " + HTMLXDOMGenerator.htmlencode(article.getTitle()) + "\">");
        if (article.hasSummary()) {
            printWriter.println("<meta name=\"description\" content=\"" + HTMLXDOMGenerator.htmlencode(article.getSummary()) + "\">");
        }
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(article.getTitle()) + "</h1>");
        if (article.hasContent()) {
            printWriter.println(this.sdomg.generateSectionHTML(article.getContent()));
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeVocabTypeIndex(Dialect dialect, VersionNumber versionNumber, VersionNumber versionNumber2, List<Article> list) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "vocabtypes.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Vocabulary Type Index</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Vocabulary Type Index</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Vocabulary Type Index</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", vocabulary type, vocabulary type index\">");
        printWriter.println("<meta name=\"description\" content=\"A list of the types of XION vocabulary terms in " + (dialect == null ? "all dialects, modules, and libraries in this documentation set" : HTMLXDOMGenerator.htmlencode(dialect.getTitle())) + ".\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xionnav.css\">");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        printWriter.println("<!--");
        printWriter.println("function loadAllVocab() {");
        printWriter.println("parent.xnvocab.location.href='all-index.html';");
        printWriter.println("parent.xncontent.location.href='intro.html';");
        printWriter.println("return false;");
        printWriter.println("}");
        printWriter.println("function loadVocabType(x) {");
        printWriter.println("parent.xnvocab.location.href=x+'-index.html';");
        printWriter.println("parent.xncontent.location.href=x+'/index.html';");
        printWriter.println("return false;");
        printWriter.println("}");
        printWriter.println("//-->");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        if (dialect == null) {
            printWriter.println("<h1>" + this.allString() + "</h1>");
        } else if (versionNumber == null) {
            printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + "</h1>");
        } else {
            printWriter.println("<h1>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + "</h1>");
        }
        printWriter.println("<ul>");
        printWriter.println("<li><a href=\"all-index.html\" target=\"xnvocab\" onclick=\"return loadAllVocab();\">All Vocabulary</a></li>");
        for (TermType object : TermType.values()) {
            if (this.ds.terms().getTerms(object, null, dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) continue;
            printWriter.println("<li><a href=\"" + HTMLXDOMGenerator.htmlencode(object.getCode()) + "-index.html\" target=\"xnvocab\" onclick=\"return loadVocabType('" + HTMLXDOMGenerator.htmlencode(object.getCode()) + "');\">" + HTMLXDOMGenerator.htmlencode(object.getPluralTitleCase()) + "</a></li>");
        }
        printWriter.println("</ul>");
        if (list != null && !list.isEmpty()) {
            printWriter.println("<ul>");
            for (Article article : list) {
                printWriter.println("<li><a href=\"" + HTMLXDOMGenerator.htmlencode(article.name()) + ".html\" target=\"xncontent\">" + HTMLXDOMGenerator.htmlencode(article.getTitle()) + "</a></li>");
            }
            printWriter.println("</ul>");
        }
        printWriter.println("<ul>");
        if (!this.ds.terms().getTerms(TermType.CONSTANT, null, dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) {
            printWriter.println("<li><a href=\"constants.html\" target=\"xncontent\">Constant Summary</a></li>");
        }
        if (!this.ds.terms().getTerms(TermType.OPERATOR, null, dialect == null ? null : dialect.name(), versionNumber2).isEmpty()) {
            printWriter.println("<li><a href=\"precedence.html\" target=\"xncontent\">Operator Precedence Table</a></li>");
        }
        boolean bl = false;
        for (Term term : this.ds.terms().getTerms(null, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            if (!term.hasSynonyms(dialect == null ? null : dialect.name(), versionNumber2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            printWriter.println("<li><a href=\"synonyms.html\" target=\"xncontent\">Synonyms</a></li>");
        }
        boolean bl2 = false;
        for (Term term : this.ds.terms().getTerms(TermType.CONSTANT, null, dialect == null ? null : dialect.name(), versionNumber2)) {
            if (term.getDataType() == null || !term.getDataType().getName().equalsIgnoreCase("color") && !term.getDataType().getName().equalsIgnoreCase("colour")) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            printWriter.println("<li><a href=\"colors.html\" target=\"xncontent\">Color Chart</a></li>");
        }
        printWriter.println("<li><a href=\"index-a.html\" target=\"xncontent\">Index</a></li>");
        printWriter.println("</ul>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    /*
     * WARNING - void declaration
     */
    private String allString() {
        void var5_16;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Dialect object2 : this.ds.dialects()) {
            switch (object2.type()) {
                case DIALECT: {
                    bl = true;
                    break;
                }
                case MODULE: {
                    bl2 = true;
                    break;
                }
                case LIBRARY: {
                    bl3 = true;
                }
            }
        }
        Vector vector = new Vector();
        if (bl) {
            vector.add("Dialects");
        }
        if (bl2) {
            vector.add("Modules");
        }
        if (bl3) {
            vector.add("Libraries");
        }
        switch (vector.size()) {
            case 0: {
                String string = "All Dialects, Modules, and Libraries";
                break;
            }
            case 1: {
                String string = "All " + (String)vector.get(0);
                break;
            }
            case 2: {
                String string = "All " + (String)vector.get(0) + " and " + (String)vector.get(1);
                break;
            }
            default: {
                String string = "All ";
                for (int i = 0; i < vector.size(); ++i) {
                    void var5_13;
                    void var5_10;
                    String string2 = (String)var5_10 + (String)vector.get(i);
                    if (i <= vector.size() - 2) {
                        String string3 = string2 + ", ";
                    }
                    if (i != vector.size() - 2) continue;
                    String string4 = (String)var5_13 + "and ";
                }
            }
        }
        return var5_16;
    }

    /*
     * WARNING - void declaration
     */
    private void writeDialectIndex(Dialect dialect, VersionNumber versionNumber) throws IOException {
        void var8_19;
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "dialects.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>XION Dialect Index</title>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", dialect, dialects, dialect index, module, modules, module index, library, libraries, library index\">");
        printWriter.println("<meta name=\"description\" content=\"A list of XION dialects, OpenXION modules, and XION code libraries with documentation available in this documentation set.\">");
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xionnav.css\">");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        printWriter.println("<!--");
        printWriter.println("function loadAllDialects() {");
        printWriter.println("parent.xnvocabtypes.location.href='vocabtypes.html';");
        printWriter.println("parent.xnvocab.location.href='all-index.html';");
        printWriter.println("parent.xncontent.location.href='intro.html';");
        printWriter.println("return false;");
        printWriter.println("}");
        if (dialect == null) {
            printWriter.println("function loadDialect(x) {");
            printWriter.println("parent.xnvocabtypes.location.href=x+'/vocabtypes.html';");
            printWriter.println("parent.xnvocab.location.href=x+'/all-index.html';");
            printWriter.println("parent.xncontent.location.href=x+'/intro.html';");
            printWriter.println("return false;");
            printWriter.println("}");
        } else {
            printWriter.println("function loadDialect(x) {");
            printWriter.println("parent.xnvocabtypes.location.href='vocabtypes.html';");
            printWriter.println("parent.xnvocab.location.href='all-index.html';");
            printWriter.println("parent.xncontent.location.href='intro.html';");
            printWriter.println("return false;");
            printWriter.println("}");
        }
        if (dialect == null) {
            printWriter.println("function loadDialectVersion(x, y) {");
            printWriter.println("parent.xnvocabtypes.location.href=x+'/'+y+'/vocabtypes.html';");
            printWriter.println("parent.xnvocab.location.href=x+'/'+y+'/all-index.html';");
            printWriter.println("parent.xncontent.location.href=x+'/'+y+'/intro.html';");
            printWriter.println("return false;");
            printWriter.println("}");
        } else if (versionNumber == null) {
            printWriter.println("function loadDialectVersion(x, y) {");
            printWriter.println("parent.xnvocabtypes.location.href=y+'/vocabtypes.html';");
            printWriter.println("parent.xnvocab.location.href=y+'/all-index.html';");
            printWriter.println("parent.xncontent.location.href=y+'/intro.html';");
            printWriter.println("return false;");
            printWriter.println("}");
        } else {
            printWriter.println("function loadDialectVersion(x, y) {");
            printWriter.println("parent.xnvocabtypes.location.href='vocabtypes.html';");
            printWriter.println("parent.xnvocab.location.href='all-index.html';");
            printWriter.println("parent.xncontent.location.href='intro.html';");
            printWriter.println("return false;");
            printWriter.println("}");
        }
        printWriter.println("//-->");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        Vector<Dialect> vector = new Vector<Dialect>();
        Vector<Dialect> vector2 = new Vector<Dialect>();
        Vector<Dialect> vector3 = new Vector<Dialect>();
        if (dialect == null) {
            for (Dialect object2 : this.ds.dialects()) {
                switch (object2.type()) {
                    case DIALECT: {
                        vector.add(object2);
                        break;
                    }
                    case MODULE: {
                        vector2.add(object2);
                        break;
                    }
                    case LIBRARY: {
                        vector3.add(object2);
                    }
                }
            }
        } else {
            switch (dialect.type()) {
                case DIALECT: {
                    vector.add(dialect);
                    break;
                }
                case MODULE: {
                    vector2.add(dialect);
                    break;
                }
                case LIBRARY: {
                    vector3.add(dialect);
                }
            }
        }
        Vector vector4 = new Vector();
        if (!vector.isEmpty()) {
            vector4.add("Dialects");
        }
        if (!vector2.isEmpty()) {
            vector4.add("Modules");
        }
        if (!vector3.isEmpty()) {
            vector4.add("Libraries");
        }
        switch (vector4.size()) {
            case 0: {
                String string = "All Dialects, Modules, and Libraries";
                break;
            }
            case 1: {
                String string = "All " + (String)vector4.get(0);
                break;
            }
            case 2: {
                String string = "All " + (String)vector4.get(0) + " and " + (String)vector4.get(1);
                break;
            }
            default: {
                String string = "All ";
                for (int i = 0; i < vector4.size(); ++i) {
                    void var8_16;
                    void var8_13;
                    String string2 = (String)var8_13 + (String)vector4.get(i);
                    if (i <= vector4.size() - 2) {
                        String string3 = string2 + ", ";
                    }
                    if (i != vector4.size() - 2) continue;
                    String string4 = (String)var8_16 + "and ";
                }
            }
        }
        printWriter.println("<ul>");
        printWriter.println("<li>");
        printWriter.println("<a href=\"vocabtypes.html\" target=\"xnvocabtypes\" onclick=\"return loadAllDialects();\">" + (String)var8_19 + "</a>");
        printWriter.println("</li>");
        printWriter.println("</ul>");
        if (!vector.isEmpty()) {
            printWriter.println("<h1>Dialects</h1>");
            this.writeDialectList(dialect, versionNumber, printWriter, vector);
        }
        if (!vector2.isEmpty()) {
            printWriter.println("<h1>Modules</h1>");
            this.writeDialectList(dialect, versionNumber, printWriter, vector2);
        }
        if (!vector3.isEmpty()) {
            printWriter.println("<h1>Libraries</h1>");
            this.writeDialectList(dialect, versionNumber, printWriter, vector3);
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeDialectList(Dialect dialect, VersionNumber versionNumber, PrintWriter printWriter, List<Dialect> list) {
        printWriter.println("<ul>");
        for (Dialect dialect2 : list) {
            String string = dialect == null ? HTMLXDOMGenerator.htmlencode(dialect2.name()) + "/vocabtypes.html" : "vocabtypes.html";
            printWriter.println("<li>");
            printWriter.println("<a href=\"" + string + "\" target=\"xnvocabtypes\" onclick=\"return loadDialect('" + HTMLXDOMGenerator.htmlencode(dialect2.name()) + "');\">" + HTMLXDOMGenerator.htmlencode(dialect2.getTitle()) + "</a>");
            printWriter.print("<span class=\"dversion\">(");
            if (versionNumber == null || dialect == null) {
                boolean bl = true;
                for (VersionNumber versionNumber2 : dialect2.versions().descendingSet()) {
                    String string2;
                    String string3 = string2 = dialect == null ? HTMLXDOMGenerator.htmlencode(dialect2.name()) + "/" + HTMLXDOMGenerator.htmlencode(versionNumber2.toString()) + "/vocabtypes.html" : HTMLXDOMGenerator.htmlencode(versionNumber2.toString()) + "/vocabtypes.html";
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.print(", ");
                    }
                    printWriter.print("<a href=\"" + string2 + "\" target=\"xnvocabtypes\" onclick=\"return loadDialectVersion('" + HTMLXDOMGenerator.htmlencode(dialect2.name()) + "','" + HTMLXDOMGenerator.htmlencode(versionNumber2.toString()) + "');\">" + HTMLXDOMGenerator.htmlencode(versionNumber2.toString()) + "</a>");
                }
            } else {
                printWriter.print("<a href=\"vocabtypes.html\" target=\"xnvocabtypes\" onclick=\"return loadDialectVersion('" + HTMLXDOMGenerator.htmlencode(dialect2.name()) + "','" + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + "');\">" + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + "</a>");
            }
            printWriter.println(")</span>");
            printWriter.println("</li>");
        }
        printWriter.println("</ul>");
    }

    private void writeIntro(Dialect dialect, VersionNumber versionNumber) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "intro.html");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>Welcome to XION</title>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + ", intro, introduction\">");
        if (dialect == null) {
            if (this.ds.hasSummary()) {
                printWriter.println("<meta name=\"description\" content=\"" + HTMLXDOMGenerator.htmlencode(this.ds.getSummary()) + "\">");
            }
        } else if (dialect.hasSummary()) {
            printWriter.println("<meta name=\"description\" content=\"" + HTMLXDOMGenerator.htmlencode(dialect.getSummary()) + "\">");
        }
        printWriter.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"xiondoc.css\">");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>Welcome to XION</h1>");
        if (dialect == null) {
            if (this.ds.hasDescription()) {
                printWriter.println(this.sdomg.generateSectionHTML(this.ds.getDescription()));
            }
        } else if (dialect.hasDescription()) {
            printWriter.println(this.sdomg.generateSectionHTML(dialect.getDescription()));
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeMainCSS(Dialect dialect, VersionNumber versionNumber) throws IOException {
        Object object;
        if (mainCSS == null) {
            String string;
            int n;
            object = HTMLXDOMGenerator.class.getResource("xiondoc.css");
            URLConnection uRLConnection = ((URL)object).openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            mainCSS = string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        object = this.openFile(dialect, versionNumber, "xiondoc.css");
        ((PrintWriter)object).print(mainCSS);
        ((PrintWriter)object).close();
    }

    private void writeNavCSS(Dialect dialect, VersionNumber versionNumber) throws IOException {
        Object object;
        if (navCSS == null) {
            String string;
            int n;
            object = HTMLXDOMGenerator.class.getResource("xionnav.css");
            URLConnection uRLConnection = ((URL)object).openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            navCSS = string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        object = this.openFile(dialect, versionNumber, "xionnav.css");
        ((PrintWriter)object).print(navCSS);
        ((PrintWriter)object).close();
    }

    private void writeFrameset(Dialect dialect, VersionNumber versionNumber) throws IOException {
        PrintWriter printWriter = this.openFile(dialect, versionNumber, "index.html");
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        printWriter.println("<html>");
        printWriter.println("<head>");
        if (dialect == null) {
            printWriter.println("<title>XION Documentation</title>");
        } else if (versionNumber == null) {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " Documentation</title>");
        } else {
            printWriter.println("<title>" + HTMLXDOMGenerator.htmlencode(dialect.getTitle()) + " " + HTMLXDOMGenerator.htmlencode(versionNumber.toString()) + " Documentation</title>");
        }
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        printWriter.println("<meta name=\"generator\" content=\"XIONDoc 1.3\">");
        printWriter.println("<meta name=\"keywords\" content=\"" + this.baseKeywords(dialect, versionNumber) + "\">");
        if (dialect == null) {
            if (this.ds.hasSummary()) {
                printWriter.println("<meta name=\"description\" content=\"" + HTMLXDOMGenerator.htmlencode(this.ds.getSummary()) + "\">");
            }
        } else if (dialect.hasSummary()) {
            printWriter.println("<meta name=\"description\" content=\"" + HTMLXDOMGenerator.htmlencode(dialect.getSummary()) + "\">");
        }
        printWriter.println("</head>");
        printWriter.println("<frameset cols=\"320,*\">");
        printWriter.println("<frameset rows=\"160,240,*\">");
        printWriter.println("<frame name=\"xndialects\" src=\"dialects.html\" />");
        printWriter.println("<frame name=\"xnvocabtypes\" src=\"vocabtypes.html\" />");
        printWriter.println("<frame name=\"xnvocab\" src=\"all-index.html\" />");
        printWriter.println("</frameset>");
        printWriter.println("<frame name=\"xncontent\" src=\"intro.html\" />");
        printWriter.println("</frameset>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private String baseKeywords(Dialect dialect, VersionNumber versionNumber) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XION, OpenXION, XIONDoc, XIONDocs, XION docs, OpenXION docs, ");
        stringBuffer.append("XION documentation, OpenXION documentation, XION manual, OpenXION manual, ");
        stringBuffer.append("HyperTalk, HyperTalk clone, xTalk");
        if (dialect != null) {
            stringBuffer.append(", ");
            stringBuffer.append(HTMLXDOMGenerator.htmlencode(dialect.getTitle()));
            if (versionNumber != null) {
                stringBuffer.append(", ");
                stringBuffer.append(HTMLXDOMGenerator.htmlencode(dialect.getTitle()));
                stringBuffer.append(" ");
                stringBuffer.append(HTMLXDOMGenerator.htmlencode(versionNumber.toString()));
            }
        }
        return stringBuffer.toString();
    }

    private static String htmlencode(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    break;
                }
                case '\u00a0': {
                    stringBuffer.append("&nbsp;");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                        stringBuffer.append(" ");
                        break;
                    }
                    if (c >= '\u00a0') {
                        stringBuffer.append("&#" + c + ";");
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString().trim().replaceAll("\\s+", " ");
    }

    private static int compareTermNames(String string, String string2) {
        boolean bl;
        boolean bl2 = string.length() > 0 && Character.isLetterOrDigit(string.charAt(0));
        boolean bl3 = bl = string2.length() > 0 && Character.isLetterOrDigit(string2.charAt(0));
        if (bl2 == bl) {
            return string.compareToIgnoreCase(string2);
        }
        if (bl2) {
            return -1;
        }
        if (bl) {
            return 1;
        }
        return string.compareToIgnoreCase(string2);
    }

    private void deltree(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.deltree(file2);
            }
        }
        file.delete();
    }

    private PrintWriter openFile(Dialect dialect, VersionNumber versionNumber, TermType termType, String string) throws IOException {
        File file = this.getFile(dialect == null ? null : dialect.name(), versionNumber, termType, string);
        if (this.out != null) {
            this.out.println("Writing " + this.fileToString(file) + "...");
        }
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
    }

    private PrintWriter openFile(Dialect dialect, VersionNumber versionNumber, String string) throws IOException {
        File file = this.getFile(dialect == null ? null : dialect.name(), versionNumber, string);
        if (this.out != null) {
            this.out.println("Writing " + this.fileToString(file) + "...");
        }
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
    }

    private File getFile(String string, VersionNumber versionNumber, TermType termType, String string2) {
        return new File(this.getFile(string, versionNumber, termType), HTMLXDOMGenerator.fnencode(string2.toLowerCase()) + ".html");
    }

    private File getFile(String string, VersionNumber versionNumber, TermType termType) {
        File file = new File(this.getFile(string, versionNumber), termType.getCode());
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private File getFile(String string, VersionNumber versionNumber, String string2) {
        return new File(this.getFile(string, versionNumber), string2.toLowerCase());
    }

    private File getFile(String string, VersionNumber versionNumber) {
        if (!this.base.exists()) {
            this.base.mkdir();
        }
        if (string != null) {
            File file = new File(this.base, string.toLowerCase());
            if (!file.exists()) {
                file.mkdir();
            }
            if (versionNumber != null) {
                File file2 = new File(file, versionNumber.toString().toLowerCase());
                if (!file2.exists()) {
                    file2.mkdir();
                }
                return file2;
            }
            return file;
        }
        return this.base;
    }

    private String fileToString(File file) {
        return file.getAbsolutePath().substring(this.basePath.length());
    }

    private static String fnencode(String string) {
        boolean bl = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toLowerCase());
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c > ' ' && c < '\u007f' && Character.isLetterOrDigit(c)) {
                bl = true;
                break;
            }
            c = stringCharacterIterator.next();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringCharacterIterator = new StringCharacterIterator(string.toLowerCase());
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 > ' ' && c2 < '\u007f' && Character.isLetterOrDigit(c2)) {
                stringBuffer.append(c2);
            } else if (bl && (c2 == ' ' || c2 == '-' || c2 == '_' || c2 == '.' || c2 == '\'')) {
                stringBuffer.append('_');
            } else {
                String string2 = "0000" + Integer.toHexString(c2).toUpperCase();
                stringBuffer.append('$');
                stringBuffer.append(string2.substring(string2.length() - 4));
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

