/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc;

import com.kreative.xiondoc.HTMLDWriter;
import com.kreative.xiondoc.XIONDocReader;
import com.kreative.xiondoc.XIONDocWriter;
import com.kreative.xiondoc.XMLReader;
import com.kreative.xiondoc.xdom.DocumentationSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XIONDoc {
    public static final String XIONDOC_NAME = "XIONDoc";
    public static final String XIONDOC_VERSION = "1.3";

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            XIONDoc.help();
        } else {
            boolean bl = true;
            String string = "UTF-8";
            XIONDocReader xIONDocReader = new XMLReader();
            XIONDocWriter xIONDocWriter = new HTMLDWriter();
            File file = null;
            DocumentationSet documentationSet = null;
            Option option = Option.DOCUMENTATION_FILE;
            for (String string2 : stringArray) {
                if (bl && string2.startsWith("-")) {
                    if (string2.equals("-f")) {
                        option = Option.DOCUMENTATION_FILE;
                        continue;
                    }
                    if (string2.equals("-E")) {
                        option = Option.TEXT_ENCODING;
                        continue;
                    }
                    if (string2.equals("-R")) {
                        option = Option.READER;
                        continue;
                    }
                    if (string2.equals("-W")) {
                        option = Option.WRITER;
                        continue;
                    }
                    if (string2.equals("-o")) {
                        option = Option.OUTPUT_FILE;
                        continue;
                    }
                    if (string2.equals("-h") || string2.equals("-help") || string2.equals("--help")) {
                        XIONDoc.help();
                        continue;
                    }
                    if (string2.equals("-v") || string2.equals("-version") || string2.equals("--version")) {
                        XIONDoc.version();
                        continue;
                    }
                    if (string2.equals("--")) {
                        bl = false;
                        continue;
                    }
                    System.err.println("Unrecognized option: " + string2);
                    continue;
                }
                switch (option) {
                    case DOCUMENTATION_FILE: {
                        try {
                            File file2 = new File(string2);
                            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
                            byte[] byArray = new byte[(int)randomAccessFile.length()];
                            randomAccessFile.readFully(byArray);
                            randomAccessFile.close();
                            String string3 = new String(byArray, string);
                            if (file != null && documentationSet != null) {
                                xIONDocReader.read(string3, documentationSet);
                                break;
                            }
                            DocumentationSet documentationSet2 = new DocumentationSet();
                            xIONDocReader.read(string3, documentationSet2);
                            File file3 = xIONDocWriter.derive(xIONDocReader.derive(file2));
                            xIONDocWriter.write(documentationSet2, file3);
                        }
                        catch (IOException iOException) {
                            System.err.println("Error generating documentation from " + string2 + ":");
                            iOException.printStackTrace();
                        }
                        break;
                    }
                    case TEXT_ENCODING: {
                        string = string2;
                        break;
                    }
                    case READER: {
                        try {
                            xIONDocReader = Class.forName(string2).asSubclass(XIONDocReader.class).newInstance();
                        }
                        catch (Exception exception) {
                            System.err.println("Error loading reader " + string2 + ":");
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case WRITER: {
                        try {
                            xIONDocWriter = Class.forName(string2).asSubclass(XIONDocWriter.class).newInstance();
                        }
                        catch (Exception exception) {
                            System.err.println("Error loading writer " + string2 + ":");
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case OUTPUT_FILE: {
                        if (file != null && documentationSet != null) {
                            try {
                                xIONDocWriter.write(documentationSet, file);
                            }
                            catch (IOException iOException) {
                                System.err.println("Error generating documentation:");
                                iOException.printStackTrace();
                            }
                        }
                        file = new File(string2);
                        documentationSet = new DocumentationSet();
                    }
                }
                option = Option.DOCUMENTATION_FILE;
            }
            if (file != null && documentationSet != null) {
                try {
                    xIONDocWriter.write(documentationSet, file);
                }
                catch (IOException iOException) {
                    System.err.println("Error generating documentation:");
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static void help() {
        System.out.println("Usage: xiondoc [options] [--] [docfile] [docfile] [...]");
        System.out.println("  -E encoding     specify the text encoding used to read documentation files");
        System.out.println("                  (default is UTF-8)");
        System.out.println("  -f docfile      generate documentation from the specified documentation file");
        System.out.println("  -h              print help screen");
        System.out.println("  -o outputfile   generate a single unified documentation set at the given path");
        System.out.println("                  (default is to generate a documentation set for each file)");
        System.out.println("  -R classname    use the specified documentation reader");
        System.out.println("                  (default is com.kreative.xiondoc.XMLReader)");
        System.out.println("  -v              print XIONDoc, Java, and OS version numbers");
        System.out.println("  -W classname    use the specified documentation writer");
        System.out.println("                  (default is com.kreative.xiondoc.HTMLDWriter)");
        System.out.println("  --help          print help screen");
        System.out.println("  --version       print XIONDoc, Java, and OS version numbers");
        System.out.println("  --              treat remaining arguments as file names");
    }

    private static void version() {
        System.out.println("XIONDoc 1.3");
        System.out.println(System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"));
        System.out.println(System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        System.out.println(System.getProperty("os.name") + " " + System.getProperty("os.version"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Option {
        DOCUMENTATION_FILE,
        TEXT_ENCODING,
        READER,
        WRITER,
        OUTPUT_FILE;

    }
}

