/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc;

import com.kreative.xiondoc.XMLSDOMParser;
import com.kreative.xiondoc.sdom.Section;
import com.kreative.xiondoc.xdom.Article;
import com.kreative.xiondoc.xdom.Descriptor;
import com.kreative.xiondoc.xdom.Dialect;
import com.kreative.xiondoc.xdom.DialectSpecList;
import com.kreative.xiondoc.xdom.DialectType;
import com.kreative.xiondoc.xdom.DocumentationSet;
import com.kreative.xiondoc.xdom.Precedence;
import com.kreative.xiondoc.xdom.Term;
import com.kreative.xiondoc.xdom.TermName;
import com.kreative.xiondoc.xdom.TermSpec;
import com.kreative.xiondoc.xdom.TermSpecList;
import com.kreative.xiondoc.xdom.TermType;
import com.kreative.xiondoc.xdom.VersionNumberList;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLXDOMParser {
    private XMLSDOMParser sdomp = new XMLSDOMParser();
    private PrintWriter out;

    public XMLXDOMParser(boolean bl) {
        if (bl) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
        } else {
            this.out = null;
        }
    }

    public XMLXDOMParser(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public DocumentationSet parseDocument(Document document, DocumentationSet documentationSet) {
        if (documentationSet == null) {
            documentationSet = new DocumentationSet();
        }
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (string.equalsIgnoreCase("xiondoc")) {
                this.parseDocSet(node, documentationSet);
                continue;
            }
            if (string.equalsIgnoreCase("docset")) {
                this.parseDocSet(node, documentationSet);
                continue;
            }
            if (!string.equalsIgnoreCase("documentationset")) continue;
            this.parseDocSet(node, documentationSet);
        }
        return documentationSet;
    }

    public DocumentationSet parseDocSet(Node node, DocumentationSet documentationSet) {
        if (documentationSet == null) {
            documentationSet = new DocumentationSet();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("summary")) {
                documentationSet.appendSummary(node2.getTextContent().trim().replaceAll("\\s+", " "));
                continue;
            }
            if (string.equalsIgnoreCase("description")) {
                documentationSet.appendDescription(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("article")) {
                documentationSet.articles().add(this.parseArticle(node2));
                continue;
            }
            if (DialectType.forString(string.toLowerCase()) != null) {
                documentationSet.dialects().add(this.parseDialect(node2));
                continue;
            }
            if (TermType.forTagName(string.toLowerCase()) == null) continue;
            documentationSet.terms().addTerm(this.parseTerm(node2));
        }
        return documentationSet;
    }

    public Dialect parseDialect(Node node) {
        DialectType dialectType = DialectType.forString(node.getNodeName().toLowerCase());
        String string = null;
        String string2 = null;
        VersionNumberList versionNumberList = null;
        String string3 = null;
        Section section = null;
        Vector<Article> vector = new Vector<Article>();
        if (this.out != null) {
            this.out.print("Reading " + dialectType.toString().toLowerCase() + "...");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equalsIgnoreCase("name")) {
                string = node2.getTextContent().trim();
                if (this.out == null) continue;
                this.out.print("\b\b\b " + string + "...");
                continue;
            }
            if (string4.equalsIgnoreCase("title")) {
                if (string2 == null) {
                    string2 = node2.getTextContent().trim().replaceAll("\\s+", " ");
                    continue;
                }
                string2 = string2 + " " + node2.getTextContent().trim().replaceAll("\\s+", " ");
                continue;
            }
            if (string4.equalsIgnoreCase("versions")) {
                if (versionNumberList == null) {
                    versionNumberList = new VersionNumberList(node2.getTextContent().trim());
                    continue;
                }
                versionNumberList.addAll(new VersionNumberList(node2.getTextContent().trim()));
                continue;
            }
            if (string4.equalsIgnoreCase("summary")) {
                if (string3 == null) {
                    string3 = node2.getTextContent().trim().replaceAll("\\s+", " ");
                    continue;
                }
                string3 = string3 + " " + node2.getTextContent().trim().replaceAll("\\s+", " ");
                continue;
            }
            if (string4.equalsIgnoreCase("description")) {
                if (section == null) {
                    section = this.sdomp.parseSection(node2);
                    continue;
                }
                section.addAll(this.sdomp.parseSection(node2));
                continue;
            }
            if (!string4.equalsIgnoreCase("article")) continue;
            if (this.out != null) {
                this.out.println();
            }
            vector.add(this.parseArticle(node2));
        }
        if (this.out != null) {
            this.out.println();
        }
        Dialect dialect = new Dialect(dialectType, string);
        dialect.setTitle(string2);
        if (versionNumberList != null) {
            dialect.versions().addAll(versionNumberList);
        }
        dialect.setSummary(string3);
        dialect.setDescription(section);
        dialect.articles().addAll(vector);
        return dialect;
    }

    public Article parseArticle(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Section section = null;
        if (this.out != null) {
            this.out.print("Reading article...");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equalsIgnoreCase("name")) {
                string = node2.getTextContent().trim();
                if (this.out == null) continue;
                this.out.print("\b\b\b " + string + "...");
                continue;
            }
            if (string4.equalsIgnoreCase("title")) {
                if (string2 == null) {
                    string2 = node2.getTextContent().trim().replaceAll("\\s+", " ");
                    continue;
                }
                string2 = string2 + " " + node2.getTextContent().trim().replaceAll("\\s+", " ");
                continue;
            }
            if (string4.equalsIgnoreCase("summary")) {
                if (string3 == null) {
                    string3 = node2.getTextContent().trim().replaceAll("\\s+", " ");
                    continue;
                }
                string3 = string3 + " " + node2.getTextContent().trim().replaceAll("\\s+", " ");
                continue;
            }
            if (!string4.equalsIgnoreCase("content")) continue;
            if (section == null) {
                section = this.sdomp.parseSection(node2);
                continue;
            }
            section.addAll(this.sdomp.parseSection(node2));
        }
        if (this.out != null) {
            this.out.println();
        }
        Article article = new Article(string);
        article.setTitle(string2);
        article.setSummary(string3);
        article.setContent(section);
        return article;
    }

    public Term parseTerm(Node node) {
        TermType termType = TermType.forTagName(node.getNodeName());
        Term term = new Term(termType);
        if (this.out != null) {
            this.out.print("Reading " + termType.getSingular() + "...");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            String[] stringArray;
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("name")) {
                stringArray = node2.getAttributes();
                Node node3 = stringArray.getNamedItem("dialects");
                object = stringArray.getNamedItem("modules");
                Node node4 = stringArray.getNamedItem("libraries");
                String string2 = node2.getTextContent().trim();
                StringBuffer stringBuffer = new StringBuffer();
                if (node3 != null) {
                    stringBuffer.append(node3.getTextContent().trim());
                    stringBuffer.append(',');
                }
                if (object != null) {
                    stringBuffer.append(object.getTextContent().trim());
                    stringBuffer.append(',');
                }
                if (node4 != null) {
                    stringBuffer.append(node4.getTextContent().trim());
                    stringBuffer.append(',');
                }
                if (this.out != null) {
                    this.out.print("\b\b\b " + string2 + "...");
                }
                term.names().add(new TermName(string2, new DialectSpecList(stringBuffer.toString())));
                continue;
            }
            if (string.equalsIgnoreCase("applies-to")) {
                term.appendAppliesTo(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("precedence")) {
                term.setPrecedence(Precedence.forString(node2.getTextContent().trim()));
                continue;
            }
            if (string.equalsIgnoreCase("description-short")) {
                term.appendDescriptionShort(node2.getTextContent().trim().replaceAll("\\s+", " "));
                continue;
            }
            if (string.equalsIgnoreCase("type")) {
                term.setDataType(new TermSpec(node2.getTextContent().trim(), TermType.DATA_TYPE));
                continue;
            }
            if (string.equalsIgnoreCase("value")) {
                term.setDataValue(node2.getTextContent());
                continue;
            }
            if (string.equalsIgnoreCase("syntax")) {
                term.appendSyntax(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("examples")) {
                term.appendExamples(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("description")) {
                term.appendDescription(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("descriptors")) {
                stringArray = node2.getTextContent().trim().split(",");
                for (int j = 0; j < stringArray.length; ++j) {
                    object = Descriptor.forCode(stringArray[j].trim());
                    if (object == null) continue;
                    term.descriptors().add((Descriptor)((Object)object));
                }
                continue;
            }
            if (string.equalsIgnoreCase("properties")) {
                term.properties().addAll(new TermSpecList(node2.getTextContent().trim(), TermType.PROPERTY));
                continue;
            }
            if (string.equalsIgnoreCase("scripts")) {
                term.appendScripts(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("notes")) {
                term.appendNotes(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("security")) {
                term.appendSecurity(this.sdomp.parseSection(node2));
                continue;
            }
            if (string.equalsIgnoreCase("compatibility")) {
                term.appendCompatibility(this.sdomp.parseSection(node2));
                continue;
            }
            if (!string.equalsIgnoreCase("see-also")) continue;
            term.seeAlso().addAll(new TermSpecList(node2.getTextContent().trim(), termType));
        }
        if (this.out != null) {
            this.out.println();
        }
        return term;
    }
}

