/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import java.text.StringCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TermType {
    CONTROL_STRUCTURE("cs", "structure", "control structure", "control structures"),
    KEYWORD("kw", "keyword", "other keyword", "other keywords"),
    EVENT("ev", "event", "event", "events"),
    COMMAND("cm", "command", "command", "commands"),
    FUNCTION("fn", "function", "function", "functions"),
    DATA_TYPE("dt", "datatype", "data type", "data types"),
    PROPERTY("pr", "property", "property", "properties"),
    OPERATOR("op", "operator", "operator", "operators"),
    CONSTANT("cn", "constant", "constant", "constants"),
    ORDINAL("or", "ordinal", "ordinal", "ordinals"),
    IO_METHOD("mt", "iomethod", "I/O method", "I/O methods"),
    IO_MANAGER("mg", "iomanager", "I/O manager", "I/O managers"),
    EXTERNAL_LANGUAGE("xl", "extlang", "external language", "external languages"),
    VERSION("vr", "version", "version", "versions");

    private String twoletter;
    private String xml;
    private String singular;
    private String plural;

    private TermType(String string2, String string3, String string4, String string5) {
        this.twoletter = string2;
        this.xml = string3;
        this.singular = string4;
        this.plural = string5;
    }

    private static String tcase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = ' ';
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!Character.isLetter(c)) {
                stringBuffer.append(Character.toTitleCase(c2));
            } else {
                stringBuffer.append(Character.toLowerCase(c2));
            }
            c = c2;
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public String getCode() {
        return this.twoletter;
    }

    public String getTagName() {
        return this.xml;
    }

    public String getSingular() {
        return this.singular;
    }

    public String getSingularTitleCase() {
        return TermType.tcase(this.singular);
    }

    public String getPlural() {
        return this.plural;
    }

    public String getPluralTitleCase() {
        return TermType.tcase(this.plural);
    }

    public static TermType forCode(String string) {
        for (TermType termType : TermType.values()) {
            if (!termType.twoletter.equalsIgnoreCase(string)) continue;
            return termType;
        }
        return null;
    }

    public static TermType forTagName(String string) {
        for (TermType termType : TermType.values()) {
            if (!termType.xml.equalsIgnoreCase(string)) continue;
            return termType;
        }
        return null;
    }

    public static TermType forSingular(String string) {
        for (TermType termType : TermType.values()) {
            if (!termType.singular.equalsIgnoreCase(string)) continue;
            return termType;
        }
        return null;
    }

    public static TermType forPlural(String string) {
        for (TermType termType : TermType.values()) {
            if (!termType.plural.equalsIgnoreCase(string)) continue;
            return termType;
        }
        return null;
    }
}

