/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Serializable,
Comparable<VersionNumber> {
    private static final long serialVersionUID = 1L;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("[0-9]+|[A-Za-z]+");
    private String[] components;

    public VersionNumber(String string) {
        Vector<String> vector = new Vector<String>();
        Matcher matcher = COMPONENT_PATTERN.matcher(string);
        while (matcher.find()) {
            vector.add(matcher.group());
        }
        this.components = vector.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string : this.components) {
            boolean bl2 = NUMERIC_PATTERN.matcher(string).matches();
            if (bl == bl2) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
            bl = bl2;
        }
        return stringBuffer.toString();
    }

    private VersionNumber() {
    }

    public VersionNumber next() {
        int n = this.components.length;
        VersionNumber versionNumber = new VersionNumber();
        versionNumber.components = new String[n];
        for (int i = 0; i < n; ++i) {
            versionNumber.components[i] = this.components[i];
        }
        if (n > 0) {
            String string = this.components[n - 1];
            versionNumber.components[n - 1] = NUMERIC_PATTERN.matcher(string).matches() ? Integer.toString(Integer.parseInt(string) + 1) : Character.toString((char)(string.charAt(0) + '\u0001'));
        }
        return versionNumber;
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        for (int i = 0; i < this.components.length || i < versionNumber.components.length; ++i) {
            int n;
            int n2;
            String string = i < this.components.length ? this.components[i] : "";
            String string2 = i < versionNumber.components.length ? versionNumber.components[i] : "";
            boolean bl = NUMERIC_PATTERN.matcher(string).matches();
            boolean bl2 = NUMERIC_PATTERN.matcher(string2).matches();
            if (bl && bl2) {
                n2 = Integer.parseInt(string);
                if (n2 == (n = Integer.parseInt(string2))) continue;
                return n2 - n;
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return -1;
            }
            n2 = i >= this.components.length - 1 ? 1 : 0;
            int n3 = n = i >= versionNumber.components.length - 1 ? 1 : 0;
            if (n2 != 0 && n == 0) {
                return 1;
            }
            if (n != 0 && n2 == 0) {
                return -1;
            }
            if (string.equalsIgnoreCase(string2)) continue;
            return string.compareToIgnoreCase(string2);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof VersionNumber) {
            VersionNumber versionNumber = (VersionNumber)object;
            if (this.components.length == versionNumber.components.length) {
                for (int i = 0; i < this.components.length; ++i) {
                    String string = this.components[i];
                    String string2 = versionNumber.components[i];
                    boolean bl = NUMERIC_PATTERN.matcher(string).matches();
                    boolean bl2 = NUMERIC_PATTERN.matcher(string2).matches();
                    if (bl && bl2) {
                        int n;
                        int n2 = Integer.parseInt(string);
                        if (n2 == (n = Integer.parseInt(string2))) continue;
                        return false;
                    }
                    if (bl || bl2) {
                        return false;
                    }
                    if (string.equalsIgnoreCase(string2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (String string : this.components) {
            if (NUMERIC_PATTERN.matcher(string).matches()) {
                n = (n << 4 | n >>> 28) + Integer.parseInt(string);
                continue;
            }
            n ^= string.toLowerCase().hashCode();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            Vector<VersionNumber> vector = new Vector<VersionNumber>();
            Scanner scanner = new Scanner(new File(string));
            while (scanner.hasNextLine()) {
                vector.add(new VersionNumber(scanner.nextLine()));
            }
            scanner.close();
            Collections.sort(vector);
            for (VersionNumber versionNumber : vector) {
                System.out.println(versionNumber.toString() + " -> " + versionNumber.next().toString());
            }
        }
    }
}

