/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNModule;
import com.kreative.openxion.XNResponder;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.XNSecurityProfile;
import com.kreative.openxion.XNSecurityValue;
import com.kreative.openxion.XNStackFrame;
import com.kreative.openxion.XNUI;
import com.kreative.openxion.ast.XNFunctionHandler;
import com.kreative.openxion.ast.XNMessageHandler;
import com.kreative.openxion.ast.XNVariableScope;
import com.kreative.openxion.io.XNIOManager;
import com.kreative.openxion.io.XNIOMethod;
import com.kreative.openxion.math.FastMath;
import com.kreative.openxion.math.MathProcessor;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.util.XNNumberFormat;
import com.kreative.openxion.xom.XOMDataType;
import com.kreative.openxion.xom.XOMStaticVariableMap;
import com.kreative.openxion.xom.XOMVariableMap;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMEmpty;
import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private XNUI ui;
    private XNSecurityProfile security;
    private XNContext parent;
    private Map<String, XOMVariant> builtInConstants;
    private Map<String, Integer> builtInOrdinals;
    private Map<String, XOMDataType<? extends XOMVariant>> builtInDataTypes;
    private Map<String, XNModule.CommandParser> commandParsers;
    private Map<String, XNModule.Command> commandInterpreters;
    private Map<String, XNModule.Function> functionInterpreters;
    private Map<String, XNModule.Property> globalProperties;
    private Map<String, XNModule.ExternalLanguage> externalLanguages;
    private Map<String, XNModule.Version> versions;
    private List<XNIOManager> ioManagers;
    private List<XNIOMethod> ioMethods;
    private Map<String, XOMVariant> userConstants;
    private Map<String, Integer> userOrdinals;
    private Map<String, XOMDataType<? extends XOMVariant>> userDataTypes;
    private XOMVariableMap globalVariables;
    private XOMStaticVariableMap staticVariables;
    private Map<String, XNMessageHandler> globalUserCommands;
    private Map<String, XNFunctionHandler> globalUserFunctions;
    private Set<String> includedScripts;
    private String applicationPaths;
    private String documentPaths;
    private String includePaths;
    private char itemDelimiter;
    private char columnDelimiter;
    private char rowDelimiter;
    private boolean littleEndian;
    private boolean unsigned;
    private XNNumberFormat numberFormat;
    private String textEncoding;
    private String lineEnding;
    private MathContext mc;
    private MathProcessor mp;
    private Map<String, String> messages;
    private XNResponder firstResponder;
    private Stack<XNResponder> responderStack;
    private Stack<XNStackFrame> callStack;
    private XOMVariant result;

    public XNContext(XNUI xNUI) {
        this.ui = xNUI;
        this.security = new XNSecurityProfile();
        this.parent = null;
        this.initLanguageConstructs();
        this.initRuntime();
        this.initEnvironment();
        this.initStack();
    }

    public XNContext(XNUI xNUI, XNSecurityProfile xNSecurityProfile) {
        this.ui = xNUI;
        this.security = xNSecurityProfile;
        this.parent = null;
        this.initLanguageConstructs();
        this.initRuntime();
        this.initEnvironment();
        this.initStack();
    }

    public XNUI getUI() {
        return this.ui;
    }

    public void setUI(XNUI xNUI) {
        this.ui = xNUI;
    }

    public XNSecurityProfile getSecurityProfile() {
        return this.security;
    }

    public void setSecurityProfile(XNSecurityProfile xNSecurityProfile) {
        this.security = xNSecurityProfile;
    }

    public XNContext getParent() {
        return this.parent;
    }

    public void resetAll() {
        this.initLanguageConstructs();
        this.initRuntime();
        this.initEnvironment();
        this.initStack();
    }

    public void reset() {
        this.initRuntime();
        this.initEnvironment();
        this.initStack();
    }

    public void resetEnvironment() {
        this.initEnvironment();
    }

    public void resetStack() {
        this.initStack();
    }

    public boolean allow(XNSecurityKey xNSecurityKey, String ... stringArray) {
        if (this.security.containsKey((Object)xNSecurityKey)) {
            switch ((XNSecurityValue)((Object)this.security.get((Object)xNSecurityKey))) {
                case ALLOW: {
                    return true;
                }
                case DENY: {
                    return false;
                }
            }
        }
        XNSecurityKey[] xNSecurityKeyArray = new XNSecurityKey[]{xNSecurityKey};
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            linkedHashMap.put(stringArray[i], stringArray[i + 1]);
        }
        Map[] mapArray = new Map[]{linkedHashMap};
        this.ui.promptSecurity(xNSecurityKeyArray, blArray, blArray2, mapArray);
        if (blArray2[0]) {
            this.security.put(xNSecurityKey, blArray[0] ? XNSecurityValue.ALLOW : XNSecurityValue.DENY);
        }
        return blArray[0];
    }

    public XNContext fork(boolean bl) {
        return new XNContext(this, bl);
    }

    private XNContext(XNContext xNContext, boolean bl) {
        this.ui = xNContext.ui;
        this.security = xNContext.security;
        this.parent = xNContext;
        this.initLanguageConstructs(xNContext);
        this.initRuntime(xNContext);
        this.initEnvironment(xNContext);
        if (bl) {
            this.initStack(xNContext);
        } else {
            this.initStack();
        }
    }

    public void join(boolean bl) {
        if (this.parent != null) {
            this.parent.initLanguageConstructs(this);
            this.parent.initRuntime(this);
            this.parent.initEnvironment(this);
            if (bl) {
                this.parent.initStack(this);
            }
        }
    }

    private void initLanguageConstructs() {
        this.builtInConstants = new HashMap<String, XOMVariant>();
        this.builtInOrdinals = new HashMap<String, Integer>();
        this.builtInDataTypes = new HashMap<String, XOMDataType<? extends XOMVariant>>();
        this.commandParsers = new HashMap<String, XNModule.CommandParser>();
        this.commandInterpreters = new HashMap<String, XNModule.Command>();
        this.functionInterpreters = new HashMap<String, XNModule.Function>();
        this.globalProperties = new HashMap<String, XNModule.Property>();
        this.externalLanguages = new HashMap<String, XNModule.ExternalLanguage>();
        this.versions = new HashMap<String, XNModule.Version>();
        this.ioManagers = new Vector<XNIOManager>();
        this.ioMethods = new Vector<XNIOMethod>();
    }

    private void initLanguageConstructs(XNContext xNContext) {
        this.initLanguageConstructs();
        this.builtInConstants.putAll(xNContext.builtInConstants);
        this.builtInOrdinals.putAll(xNContext.builtInOrdinals);
        this.builtInDataTypes.putAll(xNContext.builtInDataTypes);
        this.commandParsers.putAll(xNContext.commandParsers);
        this.commandInterpreters.putAll(xNContext.commandInterpreters);
        this.functionInterpreters.putAll(xNContext.functionInterpreters);
        this.globalProperties.putAll(xNContext.globalProperties);
        this.externalLanguages.putAll(xNContext.externalLanguages);
        this.versions.putAll(xNContext.versions);
        this.ioManagers.addAll(xNContext.ioManagers);
        this.ioMethods.addAll(xNContext.ioMethods);
    }

    private void initRuntime() {
        this.userConstants = new HashMap<String, XOMVariant>();
        this.userOrdinals = new HashMap<String, Integer>();
        this.userDataTypes = new HashMap<String, XOMDataType<? extends XOMVariant>>();
        this.globalVariables = new XOMVariableMap();
        this.staticVariables = new XOMStaticVariableMap();
        this.globalUserCommands = new HashMap<String, XNMessageHandler>();
        this.globalUserFunctions = new HashMap<String, XNFunctionHandler>();
        this.includedScripts = new HashSet<String>();
    }

    private void initRuntime(XNContext xNContext) {
        this.initRuntime();
        this.userConstants.putAll(xNContext.userConstants);
        this.userOrdinals.putAll(xNContext.userOrdinals);
        this.userDataTypes.putAll(xNContext.userDataTypes);
        this.globalVariables.merge(xNContext.globalVariables);
        this.staticVariables.merge(xNContext.staticVariables);
        this.globalUserCommands.putAll(xNContext.globalUserCommands);
        this.globalUserFunctions.putAll(xNContext.globalUserFunctions);
        this.includedScripts.addAll(xNContext.includedScripts);
    }

    private void initEnvironment() {
        this.applicationPaths = null;
        this.documentPaths = null;
        this.includePaths = null;
        this.itemDelimiter = (char)44;
        this.columnDelimiter = (char)65520;
        this.rowDelimiter = (char)65521;
        this.littleEndian = false;
        this.unsigned = false;
        this.numberFormat = new XNNumberFormat(null);
        this.textEncoding = "ISO-8859-1";
        this.lineEnding = "\n";
        this.mc = new MathContext(100, RoundingMode.HALF_EVEN);
        this.mp = FastMath.instance;
        this.messages = new HashMap<String, String>();
    }

    private void initEnvironment(XNContext xNContext) {
        this.applicationPaths = xNContext.applicationPaths;
        this.documentPaths = xNContext.documentPaths;
        this.includePaths = xNContext.includePaths;
        this.itemDelimiter = xNContext.itemDelimiter;
        this.columnDelimiter = xNContext.columnDelimiter;
        this.rowDelimiter = xNContext.rowDelimiter;
        this.littleEndian = xNContext.littleEndian;
        this.unsigned = xNContext.unsigned;
        this.numberFormat = xNContext.numberFormat;
        this.textEncoding = xNContext.textEncoding;
        this.lineEnding = xNContext.lineEnding;
        this.mc = xNContext.mc;
        this.mp = xNContext.mp;
        this.messages = xNContext.messages;
    }

    private void initStack() {
        this.firstResponder = null;
        this.responderStack = new Stack();
        this.callStack = new Stack();
        this.result = null;
    }

    private void initStack(XNContext xNContext) {
        this.initStack();
        this.firstResponder = xNContext.firstResponder;
        this.responderStack.addAll(xNContext.responderStack);
        this.callStack.addAll(xNContext.callStack);
        this.result = xNContext.result;
    }

    public void loadModule(XNModule xNModule) {
        for (Map.Entry<String, XOMVariant> object : xNModule.constants.entrySet()) {
            this.builtInConstants.put(XIONUtil.normalizeVarName(object.getKey()), object.getValue());
        }
        for (Map.Entry<String, Serializable> entry : xNModule.ordinals.entrySet()) {
            this.builtInOrdinals.put(XIONUtil.normalizeVarName(entry.getKey()), (Integer)entry.getValue());
        }
        for (Map.Entry<String, Serializable> entry : xNModule.dataTypes.entrySet()) {
            this.builtInDataTypes.put(XIONUtil.normalizeVarName(entry.getKey()), (XOMDataType<? extends XOMVariant>)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.commandParsers.entrySet()) {
            this.commandParsers.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.CommandParser)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.commands.entrySet()) {
            this.commandInterpreters.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.Command)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.functions.entrySet()) {
            this.functionInterpreters.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.Function)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.properties.entrySet()) {
            this.globalProperties.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.Property)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.externalLanguages.entrySet()) {
            this.externalLanguages.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.ExternalLanguage)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : xNModule.versions.entrySet()) {
            this.versions.put(XIONUtil.normalizeVarName(entry.getKey()), (XNModule.Version)entry.getValue());
        }
        for (XNIOManager xNIOManager : xNModule.ioManagers) {
            this.ioManagers.add(xNIOManager);
        }
        for (XNIOMethod xNIOMethod : xNModule.ioMethods) {
            this.ioMethods.add(xNIOMethod);
        }
    }

    public XOMVariant getConstant(String string) {
        return this.userConstants.containsKey(string = XIONUtil.normalizeVarName(string)) ? this.userConstants.get(string) : this.builtInConstants.get(string);
    }

    public boolean hasConstant(String string) {
        return this.builtInConstants.containsKey(string = XIONUtil.normalizeVarName(string)) || this.userConstants.containsKey(string);
    }

    public int getOrdinal(String string) {
        return this.userOrdinals.containsKey(string = XIONUtil.normalizeVarName(string)) ? this.userOrdinals.get(string) : this.builtInOrdinals.get(string);
    }

    public boolean hasOrdinal(String string) {
        return this.builtInOrdinals.containsKey(string = XIONUtil.normalizeVarName(string)) || this.userOrdinals.containsKey(string);
    }

    public XOMDataType<? extends XOMVariant> getDataType(String string) {
        return this.userDataTypes.containsKey(string = XIONUtil.normalizeVarName(string)) ? this.userDataTypes.get(string) : this.builtInDataTypes.get(string);
    }

    public boolean hasDataType(String string) {
        return this.builtInDataTypes.containsKey(string = XIONUtil.normalizeVarName(string)) || this.userDataTypes.containsKey(string);
    }

    public Set<Map.Entry<String, XOMDataType<? extends XOMVariant>>> getBuiltInDataTypeEntrySet() {
        return this.builtInDataTypes.entrySet();
    }

    public Set<Map.Entry<String, XOMDataType<? extends XOMVariant>>> getUserDataTypeEntrySet() {
        return this.userDataTypes.entrySet();
    }

    public XNModule.CommandParser getCommandParser(String string) {
        return this.commandParsers.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasCommandParser(String string) {
        return this.commandParsers.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNModule.Command getCommandInterpreter(String string) {
        return this.commandInterpreters.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasCommandInterpreter(String string) {
        return this.commandInterpreters.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNModule.Function getFunctionInterpreter(String string) {
        return this.functionInterpreters.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasFunctionInterpreter(String string) {
        return this.functionInterpreters.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNModule.Property getGlobalProperty(String string) {
        return this.globalProperties.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasGlobalProperty(String string) {
        return this.globalProperties.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNModule.ExternalLanguage getExternalLanguage(String string) {
        return this.externalLanguages.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasExternalLanguage(String string) {
        return this.externalLanguages.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNModule.Version getVersion(String string) {
        return this.versions.get(XIONUtil.normalizeVarName(string));
    }

    public boolean hasVersion(String string) {
        return this.versions.containsKey(XIONUtil.normalizeVarName(string));
    }

    public XNIOManager getIOManager(XOMVariant xOMVariant) {
        for (XNIOManager xNIOManager : this.ioManagers) {
            if (!xNIOManager.worksWith(this, xOMVariant)) continue;
            return xNIOManager;
        }
        return null;
    }

    public boolean hasIOManager(XOMVariant xOMVariant) {
        for (XNIOManager xNIOManager : this.ioManagers) {
            if (!xNIOManager.worksWith(this, xOMVariant)) continue;
            return true;
        }
        return false;
    }

    public XNIOMethod getIOMethod(String string) {
        for (XNIOMethod xNIOMethod : this.ioMethods) {
            if (!xNIOMethod.worksWith(string)) continue;
            return xNIOMethod;
        }
        return null;
    }

    public boolean hasIOMethod(String string) {
        for (XNIOMethod xNIOMethod : this.ioMethods) {
            if (!xNIOMethod.worksWith(string)) continue;
            return true;
        }
        return false;
    }

    public void addUserConstant(String string, XOMVariant xOMVariant) {
        this.userConstants.put(XIONUtil.normalizeVarName(string), xOMVariant);
    }

    public void addUserOrdinal(String string, int n) {
        this.userOrdinals.put(XIONUtil.normalizeVarName(string), n);
    }

    public void addUserDataType(String string, XOMDataType<? extends XOMVariant> xOMDataType) {
        this.userDataTypes.put(XIONUtil.normalizeVarName(string), xOMDataType);
    }

    public XOMVariableMap globalVariables() {
        return this.globalVariables;
    }

    public XOMStaticVariableMap staticVariables() {
        return this.staticVariables;
    }

    public void defineGlobalUserCommand(String string, XNMessageHandler xNMessageHandler) {
        string = XIONUtil.normalizeVarName(string);
        this.globalUserCommands.put(string, xNMessageHandler);
    }

    public XNMessageHandler getGlobalUserCommand(String string) {
        string = XIONUtil.normalizeVarName(string);
        return this.globalUserCommands.get(string);
    }

    public void defineGlobalUserFunction(String string, XNFunctionHandler xNFunctionHandler) {
        string = XIONUtil.normalizeVarName(string);
        this.globalUserFunctions.put(string, xNFunctionHandler);
    }

    public XNFunctionHandler getGlobalUserFunction(String string) {
        string = XIONUtil.normalizeVarName(string);
        return this.globalUserFunctions.get(string);
    }

    public void addIncludedScript(String string) {
        this.includedScripts.add(string);
    }

    public boolean hasIncludedScript(String string) {
        return this.includedScripts.contains(string);
    }

    public String getApplicationPaths() {
        return this.applicationPaths;
    }

    public void setApplicationPaths(String string) {
        this.applicationPaths = string;
    }

    public String getDocumentPaths() {
        return this.documentPaths;
    }

    public void setDocumentPaths(String string) {
        this.documentPaths = string;
    }

    public String getIncludePaths() {
        return this.includePaths;
    }

    public void setIncludePaths(String string) {
        this.includePaths = string;
    }

    public char getItemDelimiter() {
        return this.itemDelimiter;
    }

    public void setItemDelimiter(char c) {
        this.itemDelimiter = c;
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnDelimiter(char c) {
        this.columnDelimiter = c;
    }

    public char getRowDelimiter() {
        return this.rowDelimiter;
    }

    public void setRowDelimiter(char c) {
        this.rowDelimiter = c;
    }

    public boolean getLittleEndian() {
        return this.littleEndian;
    }

    public void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    public boolean getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(boolean bl) {
        this.unsigned = bl;
    }

    public XNNumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String string) {
        this.numberFormat = new XNNumberFormat(string);
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String string) {
        this.textEncoding = string;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(String string) {
        this.lineEnding = string;
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }

    public MathProcessor getMathProcessor() {
        return this.mp;
    }

    public void setMathProcessor(MathProcessor mathProcessor) {
        this.mp = mathProcessor;
    }

    public String getMessage(String string) {
        return this.messages.containsKey(string) ? this.messages.get(string) : string;
    }

    public void addMessages(Map<String, String> map) {
        this.messages.putAll(map);
    }

    public XNResponder getFirstResponder() {
        return this.firstResponder;
    }

    public void setFirstResponder(XNResponder xNResponder) {
        this.firstResponder = xNResponder;
    }

    public void pushResponder(XNResponder xNResponder) {
        this.responderStack.push(xNResponder);
    }

    public void popResponder() {
        if (!this.responderStack.isEmpty()) {
            this.responderStack.pop();
        }
    }

    public XNResponder getCurrentResponder() {
        if (!this.responderStack.isEmpty()) {
            return this.responderStack.peek();
        }
        return null;
    }

    public void pushStackFrame(XNStackFrame xNStackFrame) {
        this.callStack.push(xNStackFrame);
    }

    public void popStackFrame() {
        if (!this.callStack.isEmpty()) {
            this.callStack.pop();
        }
    }

    public XNStackFrame getCurrentStackFrame() {
        if (!this.callStack.isEmpty()) {
            return this.callStack.peek();
        }
        return null;
    }

    public XOMVariant getResult() {
        return this.result == null ? XOMEmpty.EMPTY : this.result;
    }

    public void setResult(XOMVariant xOMVariant) {
        this.result = xOMVariant;
    }

    public void setVariableScope(String string, XNVariableScope xNVariableScope) {
        if (this.getCurrentStackFrame() != null) {
            this.getCurrentStackFrame().setVariableScope(string, xNVariableScope);
        }
    }

    public XOMVariableMap getVariableMap(String string) {
        XNVariableScope xNVariableScope = XNVariableScope.GLOBAL;
        String string2 = "";
        if (this.getCurrentStackFrame() != null) {
            xNVariableScope = this.getCurrentStackFrame().getVariableScope(string);
            if (xNVariableScope == null) {
                xNVariableScope = XNVariableScope.LOCAL;
            }
            if ((string2 = this.getCurrentStackFrame().getHandlerName()) == null) {
                string2 = "";
            }
        }
        switch (xNVariableScope) {
            case GLOBAL: {
                return this.globalVariables();
            }
            case SHARED: {
                if (this.getCurrentResponder() != null) {
                    return this.getCurrentResponder().sharedVariables();
                }
                return this.globalVariables();
            }
            case STATIC: {
                if (this.getCurrentResponder() != null) {
                    return this.getCurrentResponder().staticVariables().forHandler(string2);
                }
                return this.staticVariables().forHandler(string2);
            }
        }
        if (this.getCurrentStackFrame() != null) {
            return this.getCurrentStackFrame().localVariables();
        }
        if (this.getCurrentResponder() != null) {
            return this.getCurrentResponder().sharedVariables();
        }
        return this.globalVariables();
    }
}

