/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNExitedToInterpreterException;
import com.kreative.openxion.XNHandlerExit;
import com.kreative.openxion.XNHandlerExitStatus;
import com.kreative.openxion.XNLexer;
import com.kreative.openxion.XNModule;
import com.kreative.openxion.XNParseError;
import com.kreative.openxion.XNParser;
import com.kreative.openxion.XNResponder;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.XNStackFrame;
import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNBetweenExpression;
import com.kreative.openxion.ast.XNBinaryExpression;
import com.kreative.openxion.ast.XNCaseBlock;
import com.kreative.openxion.ast.XNCommandStatement;
import com.kreative.openxion.ast.XNConstantDeclaration;
import com.kreative.openxion.ast.XNConstantExpression;
import com.kreative.openxion.ast.XNDataType;
import com.kreative.openxion.ast.XNDictionaryExpression;
import com.kreative.openxion.ast.XNDoStatement;
import com.kreative.openxion.ast.XNEmptyExpression;
import com.kreative.openxion.ast.XNExitStatement;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNFunctionCallPropertyDescriptor;
import com.kreative.openxion.ast.XNFunctionHandler;
import com.kreative.openxion.ast.XNHandlerParameter;
import com.kreative.openxion.ast.XNIfBlock;
import com.kreative.openxion.ast.XNIfExpression;
import com.kreative.openxion.ast.XNIncludeStatement;
import com.kreative.openxion.ast.XNInstanceOfExpression;
import com.kreative.openxion.ast.XNListExpression;
import com.kreative.openxion.ast.XNMeExpression;
import com.kreative.openxion.ast.XNMessageHandler;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.ast.XNNewExpression;
import com.kreative.openxion.ast.XNNextStatement;
import com.kreative.openxion.ast.XNNumberExpression;
import com.kreative.openxion.ast.XNObjectTypeDeclaration;
import com.kreative.openxion.ast.XNObjectTypeName;
import com.kreative.openxion.ast.XNOperator;
import com.kreative.openxion.ast.XNOrdinalDeclaration;
import com.kreative.openxion.ast.XNPassStatement;
import com.kreative.openxion.ast.XNRepeatBlock;
import com.kreative.openxion.ast.XNRepeatForEachParameters;
import com.kreative.openxion.ast.XNRepeatForParameters;
import com.kreative.openxion.ast.XNRepeatParameters;
import com.kreative.openxion.ast.XNRepeatUntilParameters;
import com.kreative.openxion.ast.XNRepeatWhileParameters;
import com.kreative.openxion.ast.XNRepeatWithParameters;
import com.kreative.openxion.ast.XNReturnStatement;
import com.kreative.openxion.ast.XNSendStatement;
import com.kreative.openxion.ast.XNStatement;
import com.kreative.openxion.ast.XNStringExpression;
import com.kreative.openxion.ast.XNSuperExpression;
import com.kreative.openxion.ast.XNSwitchBlock;
import com.kreative.openxion.ast.XNTellBlock;
import com.kreative.openxion.ast.XNThrowStatement;
import com.kreative.openxion.ast.XNTryBlock;
import com.kreative.openxion.ast.XNUnaryExpression;
import com.kreative.openxion.ast.XNUseStatement;
import com.kreative.openxion.ast.XNVariableDeclaration;
import com.kreative.openxion.ast.XNVariableExpression;
import com.kreative.openxion.ast.XNVariableInitializer;
import com.kreative.openxion.ast.XNVariableScope;
import com.kreative.openxion.ast.XNVariantDescriptor;
import com.kreative.openxion.ast.XNVariantIdDescriptor;
import com.kreative.openxion.ast.XNVariantIndexNameDescriptor;
import com.kreative.openxion.ast.XNVariantMassDescriptor;
import com.kreative.openxion.ast.XNVariantOrdinalDescriptor;
import com.kreative.openxion.ast.XNVariantSingletonDescriptor;
import com.kreative.openxion.math.MathProcessor;
import com.kreative.openxion.math.XOMComplexMath;
import com.kreative.openxion.math.XOMNumberMath;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMDataType;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariable;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBoolean;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMDate;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMInterpreter;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMPoint;
import com.kreative.openxion.xom.inst.XOMRectangle;
import com.kreative.openxion.xom.inst.XOMReference;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.inst.XOMUserObject;
import com.kreative.openxion.xom.type.XOMBooleanType;
import com.kreative.openxion.xom.type.XOMComplexType;
import com.kreative.openxion.xom.type.XOMDateType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMInterpreterType;
import com.kreative.openxion.xom.type.XOMNumberType;
import com.kreative.openxion.xom.type.XOMPointType;
import com.kreative.openxion.xom.type.XOMRectangleType;
import com.kreative.openxion.xom.type.XOMReferenceType;
import com.kreative.openxion.xom.type.XOMStringType;
import com.kreative.openxion.xom.type.XOMUserObjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNInterpreter {
    private XNContext context;

    public XNInterpreter(XNContext xNContext) {
        this.context = xNContext;
    }

    public XOMVariant evaluateExpressionString(String string) {
        if (string == null) {
            return XOMEmpty.EMPTY;
        }
        XNLexer xNLexer = new XNLexer(string, new StringReader(string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        XNExpression xNExpression = xNParser.getListExpression(null);
        if (xNParser.getToken().isEOF()) {
            return this.evaluateExpression(xNExpression);
        }
        throw new XNScriptError("Can't understand this");
    }

    public XOMVariant evaluateExpressionStringOrLiteral(String string) {
        if (string == null) {
            return XOMEmpty.EMPTY;
        }
        XNLexer xNLexer = new XNLexer(string, new StringReader(string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        try {
            XNExpression xNExpression = xNParser.getListExpression(null);
            if (xNParser.getToken().isEOF()) {
                return this.evaluateExpression(xNExpression);
            }
            return new XOMString(string);
        }
        catch (XNParseError xNParseError) {
            return new XOMString(string);
        }
    }

    public XOMVariant evaluateExpression(XNExpression xNExpression) {
        if (xNExpression == null) {
            return XOMEmpty.EMPTY;
        }
        try {
            if (xNExpression instanceof XNStringExpression) {
                String string = XIONUtil.unquote(((XNStringExpression)xNExpression).literal.image, this.context.getTextEncoding());
                return new XOMString(string);
            }
            if (xNExpression instanceof XNNumberExpression) {
                String string = ((XNNumberExpression)xNExpression).literal.image;
                try {
                    BigDecimal bigDecimal = new BigDecimal(string.replace("''", "E-").replace("'", "E+"));
                    try {
                        BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                        return new XOMInteger(bigInteger);
                    }
                    catch (Exception exception) {
                        return new XOMNumber(bigDecimal);
                    }
                }
                catch (Exception exception) {
                    return new XOMString(string);
                }
            }
            if (xNExpression instanceof XNEmptyExpression) {
                return XOMEmpty.EMPTY;
            }
            if (xNExpression instanceof XNConstantExpression) {
                String string = ((XNConstantExpression)xNExpression).constant.image;
                XOMVariant xOMVariant = this.context.getConstant(string);
                if (xOMVariant != null) {
                    return xOMVariant;
                }
                throw new XNScriptError("The constant " + string + " is not defined");
            }
            if (xNExpression instanceof XNMeExpression) {
                XNResponder xNResponder = this.context.getCurrentResponder();
                if (xNResponder instanceof XOMVariant) {
                    return (XOMVariant)((Object)xNResponder);
                }
                return XOMInterpreter.INTERPRETER;
            }
            if (xNExpression instanceof XNSuperExpression) {
                XNResponder xNResponder = this.context.getCurrentResponder();
                if (xNResponder instanceof XOMUserObject) {
                    return ((XOMUserObject)xNResponder).asSuper();
                }
                if (xNResponder instanceof XOMVariant) {
                    return (XOMVariant)((Object)xNResponder);
                }
                return XOMInterpreter.INTERPRETER;
            }
            if (xNExpression instanceof XNUnaryExpression) {
                XNOperator xNOperator = ((XNUnaryExpression)xNExpression).operator;
                XNExpression xNExpression2 = ((XNUnaryExpression)xNExpression).argument;
                switch (xNOperator) {
                    case NOT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression2).asPrimitive(this.context);
                        boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean();
                        return bl ? XOMBoolean.FALSE : XOMBoolean.TRUE;
                    }
                    case UNARY_SUBTRACT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression2).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMInteger) {
                            return ((XOMInteger)xOMVariant).negate();
                        }
                        if (xOMVariant instanceof XOMNumber) {
                            return ((XOMNumber)xOMVariant).negate();
                        }
                        if (xOMVariant instanceof XOMComplex) {
                            return ((XOMComplex)xOMVariant).negate();
                        }
                        if (XOMIntegerType.instance.canMakeInstanceFrom(this.context, xOMVariant, true)) {
                            XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            return xOMInteger.negate();
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            return xOMNumber.negate();
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            return xOMComplex.negate();
                        }
                        throw new XOMMorphError("number");
                    }
                    case BIT_NOT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression2).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        if (bigInteger == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.not());
                    }
                    case EXISTS: {
                        if (xNExpression2 instanceof XNVariantDescriptor) {
                            return this.variantExists((XNVariantDescriptor)xNExpression2) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        throw new XNScriptError("Can't understand this");
                    }
                    case NOT_EXISTS: {
                        if (xNExpression2 instanceof XNVariantDescriptor) {
                            return this.variantExists((XNVariantDescriptor)xNExpression2) ? XOMBoolean.FALSE : XOMBoolean.TRUE;
                        }
                        throw new XNScriptError("Can't understand this");
                    }
                    case REFERENCE_TO: {
                        return new XOMReference(this.evaluateExpression(xNExpression2));
                    }
                    case REFERENT_OF: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression2).asPrimitive(this.context);
                        return XOMReferenceType.instance.makeInstanceFrom(this.context, xOMVariant).dereference(true);
                    }
                }
                throw new XNScriptError("Can't understand this");
            }
            if (xNExpression instanceof XNBinaryExpression) {
                XNOperator xNOperator = ((XNBinaryExpression)xNExpression).operator;
                XNExpression xNExpression3 = ((XNBinaryExpression)xNExpression).left;
                XNExpression xNExpression4 = ((XNBinaryExpression)xNExpression).right;
                MathContext mathContext = this.context.getMathContext();
                MathProcessor mathProcessor = this.context.getMathProcessor();
                switch (xNOperator) {
                    case EXPONENT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant2 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant2 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex2 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant2, true);
                            return XOMComplexMath.pow(xOMComplex, xOMComplex2, mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant2 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber2 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant2, true);
                            return XOMNumberMath.pow(xOMNumber, xOMNumber2, mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant2, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber3 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant2, true);
                            return XOMNumberMath.pow(xOMNumber, xOMNumber3, mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant2, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex3 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant2, true);
                            return XOMComplexMath.pow(xOMComplex, xOMComplex3, mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case MULTIPLY: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant3 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant3 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex4 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant3, true);
                            return XOMComplexMath.multiply(xOMComplex, xOMComplex4, mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant3 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber4 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant3, true);
                            return XOMNumberMath.multiply(xOMNumber, xOMNumber4, mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant3, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber5 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant3, true);
                            return XOMNumberMath.multiply(xOMNumber, xOMNumber5, mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant3, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex5 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant3, true);
                            return XOMComplexMath.multiply(xOMComplex, xOMComplex5, mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case DIVIDE: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant4 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant4 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex6 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant4, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex6, mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant4 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber6 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant4, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber6, mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant4, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber7 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant4, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber7, mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant4, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex7 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant4, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex7, mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case QUOT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant5 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant5 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex8 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant5, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex8, mathContext, mathProcessor).trunc();
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant5 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber8 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant5, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber8, mathContext, mathProcessor).trunc();
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant5, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber9 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant5, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber9, mathContext, mathProcessor).trunc();
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant5, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex9 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant5, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex9, mathContext, mathProcessor).trunc();
                        }
                        throw new XOMMorphError("number");
                    }
                    case REM: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant6 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant6 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex10 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant6, true);
                            return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex10, XOMComplexMath.divide(xOMComplex, xOMComplex10, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant6 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber10 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant6, true);
                            return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber10, XOMNumberMath.divide(xOMNumber, xOMNumber10, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant6, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber11 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant6, true);
                            return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber11, XOMNumberMath.divide(xOMNumber, xOMNumber11, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant6, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex11 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant6, true);
                            return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex11, XOMComplexMath.divide(xOMComplex, xOMComplex11, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case DIV: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant7 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant7 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex12 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant7, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex12, mathContext, mathProcessor).floor();
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant7 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber12 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant7, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber12, mathContext, mathProcessor).floor();
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant7, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber13 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant7, true);
                            return XOMNumberMath.divide(xOMNumber, xOMNumber13, mathContext, mathProcessor).floor();
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant7, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex13 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant7, true);
                            return XOMComplexMath.divide(xOMComplex, xOMComplex13, mathContext, mathProcessor).floor();
                        }
                        throw new XOMMorphError("number");
                    }
                    case MOD: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant8 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant8 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex14 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant8, true);
                            return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex14, XOMComplexMath.divide(xOMComplex, xOMComplex14, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant8 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber14 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant8, true);
                            return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber14, XOMNumberMath.divide(xOMNumber, xOMNumber14, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant8, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber15 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant8, true);
                            return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber15, XOMNumberMath.divide(xOMNumber, xOMNumber15, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant8, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex15 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant8, true);
                            return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex15, XOMComplexMath.divide(xOMComplex, xOMComplex15, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case ADD: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant9 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant9 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex16 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant9, true);
                            return XOMComplexMath.add(xOMComplex, xOMComplex16, mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant9 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber16 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant9, true);
                            return XOMNumberMath.add(xOMNumber, xOMNumber16, mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant9, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber17 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant9, true);
                            return XOMNumberMath.add(xOMNumber, xOMNumber17, mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant9, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex17 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant9, true);
                            return XOMComplexMath.add(xOMComplex, xOMComplex17, mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case SUBTRACT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant10 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        if (xOMVariant instanceof XOMComplex && xOMVariant10 instanceof XOMComplex) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex18 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant10, true);
                            return XOMComplexMath.subtract(xOMComplex, xOMComplex18, mathContext, mathProcessor);
                        }
                        if (xOMVariant instanceof XOMNumber && xOMVariant10 instanceof XOMNumber) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber18 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant10, true);
                            return XOMNumberMath.subtract(xOMNumber, xOMNumber18, mathContext, mathProcessor);
                        }
                        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant10, true)) {
                            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMNumber xOMNumber19 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant10, true);
                            return XOMNumberMath.subtract(xOMNumber, xOMNumber19, mathContext, mathProcessor);
                        }
                        if (XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(this.context, xOMVariant10, true)) {
                            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                            XOMComplex xOMComplex19 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(this.context, xOMVariant10, true);
                            return XOMComplexMath.subtract(xOMComplex, xOMComplex19, mathContext, mathProcessor);
                        }
                        throw new XOMMorphError("number");
                    }
                    case SHIFT_LEFT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant11 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger2 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant11, true)).toBigInteger();
                        if (bigInteger == null || bigInteger2 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.shiftLeft(bigInteger2.intValue()));
                    }
                    case SHIFT_RIGHT_SIGNED: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant12 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger3 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant12, true)).toBigInteger();
                        if (bigInteger == null || bigInteger3 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.shiftRight(bigInteger3.intValue()));
                    }
                    case SHIFT_RIGHT_UNSIGNED: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant13 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger4 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant13, true)).toBigInteger();
                        if (bigInteger == null || bigInteger4 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.shiftRight(bigInteger4.intValue()));
                    }
                    case BIT_AND: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant14 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger5 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant14, true)).toBigInteger();
                        if (bigInteger == null || bigInteger5 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.and(bigInteger5));
                    }
                    case BIT_XOR: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant15 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger6 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant15, true)).toBigInteger();
                        if (bigInteger == null || bigInteger6 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.xor(bigInteger6));
                    }
                    case BIT_OR: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant16 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant, true)).toBigInteger();
                        BigInteger bigInteger7 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant16, true)).toBigInteger();
                        if (bigInteger == null || bigInteger7 == null) {
                            return XOMInteger.NaN;
                        }
                        return new XOMInteger(bigInteger.or(bigInteger7));
                    }
                    case STR_CONCAT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant17 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context);
                        String string2 = xOMVariant17.toTextString(this.context);
                        return new XOMString(string + string2);
                    }
                    case STR_CONCAT_SPACE: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant18 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context);
                        String string3 = xOMVariant18.toTextString(this.context);
                        return new XOMString(string + " " + string3);
                    }
                    case LIST_APPEND: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant19 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant.toPrimitiveList(this.context);
                        Vector<XOMVariant> vector = new Vector<XOMVariant>();
                        vector.add(xOMVariant19);
                        return new XOMList(list, vector);
                    }
                    case LIST_CONCAT: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant20 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant.toPrimitiveList(this.context);
                        List<? extends XOMVariant> list2 = xOMVariant20.toPrimitiveList(this.context);
                        return new XOMList(list, list2);
                    }
                    case LT_NUM: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant21 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant21) < 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case GT_NUM: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant22 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant22) > 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case LE_NUM: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant23 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant23) <= 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case GE_NUM: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant24 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant24) >= 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case CONTAINS: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant25 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string4 = xOMVariant25.toTextString(this.context).toLowerCase();
                        return string.contains(string4) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case STARTS_WITH: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant26 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string5 = xOMVariant26.toTextString(this.context).toLowerCase();
                        return string.startsWith(string5) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case ENDS_WITH: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant27 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string6 = xOMVariant27.toTextString(this.context).toLowerCase();
                        return string.endsWith(string6) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case IN: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant28 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string7 = xOMVariant28.toTextString(this.context).toLowerCase();
                        return string7.contains(string) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case WITHIN: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant29 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        XOMRectangle xOMRectangle = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(this.context, xOMVariant29);
                        if (XOMRectangleType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                            XOMRectangle xOMRectangle2 = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(this.context, xOMVariant);
                            return xOMRectangle.contains(xOMRectangle2) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        if (XOMPointType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                            XOMPoint xOMPoint = (XOMPoint)XOMPointType.instance.makeInstanceFrom(this.context, xOMVariant);
                            return xOMRectangle.contains(xOMPoint) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        throw new XOMMorphError("point");
                    }
                    case ELEMENT_OF: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant30 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant30.toPrimitiveList(this.context);
                        for (XOMVariant xOMVariant31 : list) {
                            try {
                                if (this.compareVariants(xOMVariant, xOMVariant31) != 0) continue;
                                return XOMBoolean.TRUE;
                            }
                            catch (NaNComparisonException naNComparisonException) {
                            }
                        }
                        return XOMBoolean.FALSE;
                    }
                    case PRECISELY_ELEMENT_OF: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant32 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant32.toPrimitiveList(this.context);
                        for (XOMVariant xOMVariant33 : list) {
                            if (!xOMVariant.equals(xOMVariant33)) continue;
                            return XOMBoolean.TRUE;
                        }
                        return XOMBoolean.FALSE;
                    }
                    case NOT_CONTAINS: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant34 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string8 = xOMVariant34.toTextString(this.context).toLowerCase();
                        return !string.contains(string8) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case NOT_STARTS_WITH: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant35 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string9 = xOMVariant35.toTextString(this.context).toLowerCase();
                        return !string.startsWith(string9) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case NOT_ENDS_WITH: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant36 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string10 = xOMVariant36.toTextString(this.context).toLowerCase();
                        return !string.endsWith(string10) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case NOT_IN: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant37 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context).toLowerCase();
                        String string11 = xOMVariant37.toTextString(this.context).toLowerCase();
                        return !string11.contains(string) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case NOT_WITHIN: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant38 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        XOMRectangle xOMRectangle = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(this.context, xOMVariant38);
                        if (XOMRectangleType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                            XOMRectangle xOMRectangle3 = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(this.context, xOMVariant);
                            return !xOMRectangle.contains(xOMRectangle3) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        if (XOMPointType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                            XOMPoint xOMPoint = (XOMPoint)XOMPointType.instance.makeInstanceFrom(this.context, xOMVariant);
                            return !xOMRectangle.contains(xOMPoint) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        throw new XOMMorphError("point");
                    }
                    case NOT_ELEMENT_OF: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant39 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant39.toPrimitiveList(this.context);
                        for (XOMVariant xOMVariant40 : list) {
                            try {
                                if (this.compareVariants(xOMVariant, xOMVariant40) != 0) continue;
                                return XOMBoolean.FALSE;
                            }
                            catch (NaNComparisonException naNComparisonException) {
                            }
                        }
                        return XOMBoolean.TRUE;
                    }
                    case NOT_PRECISELY_ELEMENT_OF: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant41 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        List<? extends XOMVariant> list = xOMVariant41.toPrimitiveList(this.context);
                        for (XOMVariant xOMVariant42 : list) {
                            if (!xOMVariant.equals(xOMVariant42)) continue;
                            return XOMBoolean.FALSE;
                        }
                        return XOMBoolean.TRUE;
                    }
                    case EQUAL: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant43 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant43) == 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case STRICT_EQUAL: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant44 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        return xOMVariant.equals(xOMVariant44) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case NOT_EQUAL: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant45 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            return this.compareVariants(xOMVariant, xOMVariant45) != 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case NOT_STRICT_EQUAL: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant46 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        return !xOMVariant.equals(xOMVariant46) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case CMP_NUM: {
                        try {
                            XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                            XOMVariant xOMVariant47 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                            int n = this.compareVariants(xOMVariant, xOMVariant47);
                            return n < 0 ? XOMInteger.ONE.negate() : (n > 0 ? XOMInteger.ONE : XOMInteger.ZERO);
                        }
                        catch (NaNComparisonException naNComparisonException) {
                            return XOMBoolean.FALSE;
                        }
                    }
                    case CMP_STR: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant48 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        String string = xOMVariant.toTextString(this.context);
                        String string12 = xOMVariant48.toTextString(this.context);
                        int n = string.compareToIgnoreCase(string12);
                        return n < 0 ? XOMInteger.ONE.negate() : (n > 0 ? XOMInteger.ONE : XOMInteger.ZERO);
                    }
                    case AND: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant49 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean();
                        boolean bl2 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant49)).toBoolean();
                        return bl && bl2 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case SHORT_AND: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean();
                        if (!bl) {
                            return XOMBoolean.FALSE;
                        }
                        XOMVariant xOMVariant50 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        boolean bl3 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant50)).toBoolean();
                        if (!bl3) {
                            return XOMBoolean.FALSE;
                        }
                        return XOMBoolean.TRUE;
                    }
                    case OR: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        XOMVariant xOMVariant51 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean();
                        boolean bl4 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant51)).toBoolean();
                        return bl || bl4 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                    }
                    case SHORT_OR: {
                        XOMVariant xOMVariant = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                        boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean();
                        if (bl) {
                            return XOMBoolean.TRUE;
                        }
                        XOMVariant xOMVariant52 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                        boolean bl5 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant52)).toBoolean();
                        if (bl5) {
                            return XOMBoolean.TRUE;
                        }
                        return XOMBoolean.FALSE;
                    }
                }
                throw new XNScriptError("Can't understand this");
            }
            if (xNExpression instanceof XNInstanceOfExpression) {
                XNOperator xNOperator = ((XNInstanceOfExpression)xNExpression).operator;
                String string = ((XNInstanceOfExpression)xNExpression).datatype.toNameString();
                XOMDataType<? extends XOMVariant> xOMDataType = this.context.getDataType(string);
                XNExpression xNExpression5 = ((XNInstanceOfExpression)xNExpression).argument;
                XOMVariant xOMVariant = this.evaluateExpression(xNExpression5).asValue(this.context);
                switch (xNOperator) {
                    case IS_A: {
                        if (xOMDataType == null) {
                            return XOMBoolean.FALSE;
                        }
                        if (xOMDataType.canMakeInstanceFrom(this.context, xOMVariant)) {
                            return XOMBoolean.TRUE;
                        }
                        return XOMBoolean.FALSE;
                    }
                    case IS_PRECISELY_A: {
                        if (xOMDataType == null) {
                            return XOMBoolean.FALSE;
                        }
                        if (xOMDataType.getInstanceClass().isAssignableFrom(xOMVariant.getClass())) {
                            return XOMBoolean.TRUE;
                        }
                        return XOMBoolean.FALSE;
                    }
                    case IS_NOT_A: {
                        if (xOMDataType == null) {
                            return XOMBoolean.TRUE;
                        }
                        if (xOMDataType.canMakeInstanceFrom(this.context, xOMVariant)) {
                            return XOMBoolean.FALSE;
                        }
                        return XOMBoolean.TRUE;
                    }
                    case IS_NOT_PRECISELY_A: {
                        if (xOMDataType == null) {
                            return XOMBoolean.TRUE;
                        }
                        if (xOMDataType.getInstanceClass().isAssignableFrom(xOMVariant.getClass())) {
                            return XOMBoolean.FALSE;
                        }
                        return XOMBoolean.TRUE;
                    }
                    case AS: {
                        if (xOMDataType == null) {
                            throw new XNScriptError("Unknown variant type");
                        }
                        return xOMDataType.makeInstanceFrom(this.context, xOMVariant);
                    }
                }
                throw new XNScriptError("Can't understand this");
            }
            if (xNExpression instanceof XNBetweenExpression) {
                try {
                    XOMVariant xOMVariant = this.evaluateExpression(((XNBetweenExpression)xNExpression).left).asPrimitive(this.context);
                    XNOperator xNOperator = ((XNBetweenExpression)xNExpression).operator;
                    XOMVariant xOMVariant53 = this.evaluateExpression(((XNBetweenExpression)xNExpression).rightStart).asPrimitive(this.context);
                    XOMVariant xOMVariant54 = this.evaluateExpression(((XNBetweenExpression)xNExpression).rightEnd).asPrimitive(this.context);
                    int n = this.compareVariants(xOMVariant53, xOMVariant);
                    int n2 = this.compareVariants(xOMVariant, xOMVariant54);
                    switch (xNOperator) {
                        case BETWEEN: {
                            if (n < 0 && n2 < 0) {
                                return XOMBoolean.TRUE;
                            }
                            if (n == 0 && ((XNBetweenExpression)xNExpression).isLeftInclusive()) {
                                return XOMBoolean.TRUE;
                            }
                            if (n2 == 0 && ((XNBetweenExpression)xNExpression).isRightInclusive()) {
                                return XOMBoolean.TRUE;
                            }
                            return XOMBoolean.FALSE;
                        }
                        case NOT_BETWEEN: {
                            if (n < 0 && n2 < 0) {
                                return XOMBoolean.FALSE;
                            }
                            if (n == 0 && ((XNBetweenExpression)xNExpression).isLeftInclusive()) {
                                return XOMBoolean.FALSE;
                            }
                            if (n2 == 0 && ((XNBetweenExpression)xNExpression).isRightInclusive()) {
                                return XOMBoolean.FALSE;
                            }
                            return XOMBoolean.TRUE;
                        }
                    }
                    throw new XNScriptError("Can't understand this");
                }
                catch (NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            if (xNExpression instanceof XNIfExpression) {
                XNExpression xNExpression6 = ((XNIfExpression)xNExpression).condition;
                XNExpression xNExpression7 = ((XNIfExpression)xNExpression).trueCase;
                XNExpression xNExpression8 = ((XNIfExpression)xNExpression).falseCase;
                if (((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression6).asPrimitive(this.context))).toBoolean()) {
                    return this.evaluateExpression(xNExpression7);
                }
                return this.evaluateExpression(xNExpression8);
            }
            if (xNExpression instanceof XNListExpression) {
                Vector<XOMVariant> vector = new Vector<XOMVariant>();
                for (XNExpression xNExpression9 : ((XNListExpression)xNExpression).exprs) {
                    vector.add(this.evaluateExpression(xNExpression9).asPrimitive(this.context));
                }
                return new XOMList(vector);
            }
            if (xNExpression instanceof XNDictionaryExpression) {
                XNDictionaryExpression xNDictionaryExpression = (XNDictionaryExpression)xNExpression;
                LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
                for (int i = 0; i < xNDictionaryExpression.keyExprs.size() && i < xNDictionaryExpression.valueExprs.size(); ++i) {
                    String string = this.evaluateExpression(xNDictionaryExpression.keyExprs.get(i)).toTextString(this.context);
                    XOMVariant xOMVariant = this.evaluateExpression(xNDictionaryExpression.valueExprs.get(i)).asPrimitive(this.context);
                    linkedHashMap.put(string, xOMVariant);
                }
                return new XOMDictionary(linkedHashMap);
            }
            if (xNExpression instanceof XNVariableExpression) {
                String string = ((XNVariableExpression)xNExpression).varname.image;
                return new XOMVariable(this.context.getVariableMap(string), string);
            }
            if (xNExpression instanceof XNNewExpression) {
                XOMVariant xOMVariant;
                XNDataType xNDataType = ((XNNewExpression)xNExpression).datatype;
                String string = xNDataType.toNameString();
                XOMDataType<? extends XOMVariant> xOMDataType = this.context.getDataType(string);
                XNExpression xNExpression10 = ((XNNewExpression)xNExpression).parentVariant;
                XOMVariant xOMVariant2 = xOMVariant = xNExpression10 == null ? null : this.evaluateExpression(xNExpression10);
                if (xOMVariant != null) {
                    return xOMDataType.createChildVariant(this.context, xOMVariant);
                }
                return xOMDataType.createInstance(this.context);
            }
            if (xNExpression instanceof XNVariantDescriptor) {
                XOMVariant xOMVariant;
                XNDataType xNDataType = ((XNVariantDescriptor)xNExpression).datatype;
                String string = xNDataType.toNameString();
                XOMDataType<? extends XOMVariant> xOMDataType = this.context.getDataType(string);
                XNExpression xNExpression11 = ((XNVariantDescriptor)xNExpression).parentVariant;
                XOMVariant xOMVariant3 = xOMVariant = xNExpression11 == null ? null : this.evaluateExpression(xNExpression11);
                if (xNExpression instanceof XNVariantIdDescriptor) {
                    XNExpression xNExpression12 = ((XNVariantIdDescriptor)xNExpression).id;
                    XOMVariant xOMVariant57 = this.evaluateExpression(xNExpression12).asPrimitive(this.context);
                    XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant57, true);
                    if (xOMVariant != null) {
                        return xOMDataType.getChildVariantByID(this.context, xOMVariant, xOMInteger.toInt());
                    }
                    return xOMDataType.getInstanceByID(this.context, xOMInteger.toInt());
                }
                if (xNExpression instanceof XNVariantIndexNameDescriptor) {
                    XNExpression xNExpression13 = ((XNVariantIndexNameDescriptor)xNExpression).start;
                    XNExpression xNExpression14 = ((XNVariantIndexNameDescriptor)xNExpression).end;
                    if (xNExpression13 != null && xNExpression14 != null) {
                        int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression13).asPrimitive(this.context), true)).toInt();
                        int n3 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression14).asPrimitive(this.context), true)).toInt();
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n, n3);
                        }
                        return xOMDataType.getInstanceByIndex(this.context, n, n3);
                    }
                    if (xNExpression13 != null) {
                        XOMVariant xOMVariant58 = this.evaluateExpression(xNExpression13).asPrimitive(this.context);
                        if (!xOMVariant58.toTextString(this.context).equals("") && XOMIntegerType.instance.canMakeInstanceFrom(this.context, xOMVariant58, true)) {
                            int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant58, true)).toInt();
                            if (xOMVariant != null) {
                                return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n);
                            }
                            return xOMDataType.getInstanceByIndex(this.context, n);
                        }
                        String string13 = xOMVariant58.toTextString(this.context);
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByName(this.context, xOMVariant, string13);
                        }
                        return xOMDataType.getInstanceByName(this.context, string13);
                    }
                    if (xNExpression14 != null) {
                        XOMVariant xOMVariant59 = this.evaluateExpression(xNExpression14).asPrimitive(this.context);
                        if (!xOMVariant59.toTextString(this.context).equals("") && XOMIntegerType.instance.canMakeInstanceFrom(this.context, xOMVariant59, true)) {
                            int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant59, true)).toInt();
                            if (xOMVariant != null) {
                                return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n);
                            }
                            return xOMDataType.getInstanceByIndex(this.context, n);
                        }
                        String string14 = xOMVariant59.toTextString(this.context);
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByName(this.context, xOMVariant, string14);
                        }
                        return xOMDataType.getInstanceByName(this.context, string14);
                    }
                    throw new XNScriptError("Can't understand this");
                }
                if (xNExpression instanceof XNVariantMassDescriptor) {
                    if (xOMVariant != null) {
                        return xOMDataType.getChildMassVariant(this.context, xOMVariant);
                    }
                    return xOMDataType.getMassInstance(this.context);
                }
                if (xNExpression instanceof XNVariantOrdinalDescriptor) {
                    XNToken xNToken = ((XNVariantOrdinalDescriptor)xNExpression).startOrdinal;
                    XNToken xNToken2 = ((XNVariantOrdinalDescriptor)xNExpression).endOrdinal;
                    if (xNToken != null && xNToken2 != null) {
                        int n = this.context.getOrdinal(xNToken.image);
                        int n4 = this.context.getOrdinal(xNToken2.image);
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n, n4);
                        }
                        return xOMDataType.getInstanceByIndex(this.context, n, n4);
                    }
                    if (xNToken != null) {
                        int n = this.context.getOrdinal(xNToken.image);
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n);
                        }
                        return xOMDataType.getInstanceByIndex(this.context, n);
                    }
                    if (xNToken2 != null) {
                        int n = this.context.getOrdinal(xNToken2.image);
                        if (xOMVariant != null) {
                            return xOMDataType.getChildVariantByIndex(this.context, xOMVariant, n);
                        }
                        return xOMDataType.getInstanceByIndex(this.context, n);
                    }
                    throw new XNScriptError("Can't understand this");
                }
                if (xNExpression instanceof XNVariantSingletonDescriptor) {
                    if (xOMVariant != null) {
                        return xOMDataType.getChildSingletonVariant(this.context, xOMVariant);
                    }
                    return xOMDataType.getSingletonInstance(this.context);
                }
                throw new XNScriptError("Can't understand this");
            }
            if (xNExpression instanceof XNFunctionCallPropertyDescriptor) {
                XOMVariant xOMVariant;
                XNFunctionCallPropertyDescriptor xNFunctionCallPropertyDescriptor = (XNFunctionCallPropertyDescriptor)xNExpression;
                XOMVariant xOMVariant4 = xOMVariant = xNFunctionCallPropertyDescriptor.argument == null ? null : this.evaluateExpression(xNFunctionCallPropertyDescriptor.argument).asValue(this.context);
                if (xNFunctionCallPropertyDescriptor.isBuiltInFunction()) {
                    if (xOMVariant != null && xOMVariant.canGetProperty(this.context, xNFunctionCallPropertyDescriptor.identifier)) {
                        return xOMVariant.getProperty(this.context, xNFunctionCallPropertyDescriptor.modifier, xNFunctionCallPropertyDescriptor.identifier);
                    }
                    if ((xOMVariant == null || XOMInterpreterType.instance.canMakeInstanceFrom(this.context, xOMVariant)) && this.context.hasGlobalProperty(xNFunctionCallPropertyDescriptor.identifier) && this.context.getGlobalProperty(xNFunctionCallPropertyDescriptor.identifier).canGetProperty(this.context, xNFunctionCallPropertyDescriptor.identifier)) {
                        return this.context.getGlobalProperty(xNFunctionCallPropertyDescriptor.identifier).getProperty(this.context, xNFunctionCallPropertyDescriptor.modifier, xNFunctionCallPropertyDescriptor.identifier);
                    }
                    return this.evaluateBuiltInFunction(xNFunctionCallPropertyDescriptor.identifier, xNFunctionCallPropertyDescriptor.modifier, xOMVariant);
                }
                XOMVariant xOMVariant61 = this.evaluateFunction(xNFunctionCallPropertyDescriptor.identifier, xNFunctionCallPropertyDescriptor.modifier, xNFunctionCallPropertyDescriptor.argument, xOMVariant);
                return xOMVariant61 == null ? XOMEmpty.EMPTY : xOMVariant61;
            }
            throw new XNScriptError("Can't understand this");
        }
        catch (XNScriptError xNScriptError) {
            xNScriptError.setLineAndCol(xNExpression.getBeginLine(), xNExpression.getBeginCol());
            throw xNScriptError;
        }
    }

    public int compareVariants(XOMVariant xOMVariant, XOMVariant xOMVariant2) throws NaNComparisonException {
        if (xOMVariant instanceof XOMNumber && xOMVariant2 instanceof XOMNumber) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, false);
            XOMNumber xOMNumber2 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant2, false);
            if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
                throw new NaNComparisonException();
            }
            return XOMNumberMath.compare(xOMNumber, xOMNumber2);
        }
        if (xOMVariant instanceof XOMDate && xOMVariant2 instanceof XOMDate) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(this.context, xOMVariant);
            XOMDate xOMDate2 = (XOMDate)XOMDateType.instance.makeInstanceFrom(this.context, xOMVariant2);
            return xOMDate.toCalendar().compareTo(xOMDate2.toCalendar());
        }
        if (XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant, false) && XOMNumberType.instance.canMakeInstanceFrom(this.context, xOMVariant2, false)) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, false);
            XOMNumber xOMNumber3 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant2, false);
            if (xOMNumber.isNaN() || xOMNumber3.isNaN()) {
                throw new NaNComparisonException();
            }
            return XOMNumberMath.compare(xOMNumber, xOMNumber3);
        }
        if (XOMDateType.instance.canMakeInstanceFrom(this.context, xOMVariant) && XOMDateType.instance.canMakeInstanceFrom(this.context, xOMVariant2)) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(this.context, xOMVariant);
            XOMDate xOMDate3 = (XOMDate)XOMDateType.instance.makeInstanceFrom(this.context, xOMVariant2);
            return xOMDate.toCalendar().compareTo(xOMDate3.toCalendar());
        }
        return xOMVariant.toTextString(this.context).compareToIgnoreCase(xOMVariant2.toTextString(this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XOMVariant evaluateFunction(String string, XNModifier xNModifier, XNExpression xNExpression, XOMVariant xOMVariant) {
        ArrayList<XOMVariant> arrayList;
        XNHandlerExit xNHandlerExit;
        Cloneable cloneable;
        XNResponder xNResponder = this.context.getFirstResponder();
        if (this.context.getCurrentStackFrame() != null && (cloneable = this.context.getCurrentStackFrame().getLocalUserFunction(string)) != null) {
            this.context.pushResponder(xNResponder);
            xNHandlerExit = null;
            try {
                arrayList = new ArrayList<XOMVariant>();
                if (xNExpression instanceof XNListExpression) {
                    arrayList.addAll(xOMVariant.toPrimitiveList(this.context));
                } else {
                    arrayList.add(xOMVariant.asPrimitive(this.context));
                }
                xNHandlerExit = this.evaluateUserFunction((XNFunctionHandler)cloneable, arrayList);
            }
            finally {
                this.context.popResponder();
            }
            if (xNHandlerExit.status() == XNHandlerExitStatus.PASSED) {
                if (xNHandlerExit.nextResponderValue() != null) {
                    xNResponder = xNHandlerExit.nextResponderValue();
                } else if ("all".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                    xNResponder = null;
                }
            } else {
                if (xNHandlerExit.status() == XNHandlerExitStatus.RETURNED) {
                    return xNHandlerExit.returnValue();
                }
                throw new XNScriptError("Internal error: function evaluation");
            }
        }
        while (true) {
            if (xNResponder != null) {
                this.context.pushResponder(xNResponder);
                cloneable = null;
                try {
                    cloneable = xNResponder.evaluateFunction(this.context, string, xNModifier, xOMVariant);
                }
                finally {
                    this.context.popResponder();
                }
                if (((XNHandlerExit)cloneable).status() == XNHandlerExitStatus.PASSED) {
                    if (((XNHandlerExit)cloneable).nextResponderValue() != null) {
                        xNResponder = ((XNHandlerExit)cloneable).nextResponderValue();
                        continue;
                    }
                    if ("all".equalsIgnoreCase(((XNHandlerExit)cloneable).blockTypeValue())) {
                        xNResponder = null;
                        continue;
                    }
                    xNResponder = xNResponder.nextResponder();
                    continue;
                }
                if (((XNHandlerExit)cloneable).status() == XNHandlerExitStatus.RETURNED) {
                    return ((XNHandlerExit)cloneable).returnValue();
                }
                throw new XNScriptError("Internal error: function evaluation");
            }
            cloneable = this.context.getGlobalUserFunction(string);
            if (cloneable != null) {
                this.context.pushResponder(xNResponder);
                xNHandlerExit = null;
                try {
                    arrayList = new ArrayList();
                    if (xNExpression instanceof XNListExpression) {
                        arrayList.addAll(xOMVariant.toPrimitiveList(this.context));
                    } else {
                        arrayList.add(xOMVariant.asPrimitive(this.context));
                    }
                    xNHandlerExit = this.evaluateUserFunction((XNFunctionHandler)cloneable, arrayList);
                }
                finally {
                    this.context.popResponder();
                }
                if (xNHandlerExit.status() == XNHandlerExitStatus.PASSED) {
                    if (xNHandlerExit.nextResponderValue() != null) {
                        xNResponder = xNHandlerExit.nextResponderValue();
                    } else if ("all".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        xNResponder = null;
                    }
                } else {
                    if (xNHandlerExit.status() == XNHandlerExitStatus.RETURNED) {
                        return xNHandlerExit.returnValue();
                    }
                    throw new XNScriptError("Internal error: function evaluation");
                }
            }
            if (xNResponder == null) break;
        }
        return this.evaluateBuiltInFunction(string, xNModifier, xOMVariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XNHandlerExit evaluateUserFunction(XNFunctionHandler xNFunctionHandler, List<XOMVariant> list) {
        XNStackFrame xNStackFrame = new XNStackFrame(xNFunctionHandler.name, list);
        if (xNFunctionHandler.parameters != null) {
            for (int i = 0; i < xNFunctionHandler.parameters.size(); ++i) {
                XOMStringType xOMStringType;
                XNHandlerParameter xNHandlerParameter = xNFunctionHandler.parameters.get(i);
                String string = xNHandlerParameter.name;
                XNDataType xNDataType = xNHandlerParameter.datatype;
                XNExpression xNExpression = xNHandlerParameter.value;
                xNStackFrame.setVariableScope(string, XNVariableScope.LOCAL);
                XOMDataType xOMDataType = xOMStringType = xNDataType == null ? XOMStringType.instance : this.context.getDataType(xNDataType.toNameString());
                if (xOMStringType == null) {
                    throw new XNScriptError("Unrecognized data type");
                }
                XOMVariant xOMVariant = i < list.size() ? list.get(i) : (xNExpression == null ? XOMEmpty.EMPTY : this.evaluateExpression(xNExpression).asPrimitive(this.context));
                xNStackFrame.localVariables().declareVariable(this.context, string, xOMStringType, xOMVariant);
            }
        }
        this.context.pushStackFrame(xNStackFrame);
        XNHandlerExit xNHandlerExit = null;
        try {
            xNHandlerExit = this.executeStatements(xNFunctionHandler.body);
        }
        finally {
            this.context.popStackFrame();
        }
        switch (xNHandlerExit.status()) {
            case ENDED: {
                return XNHandlerExit.returned();
            }
            case RETURNED: {
                return xNHandlerExit;
            }
            case EXITED: {
                if (xNHandlerExit.blockTypeValue().equalsIgnoreCase(xNFunctionHandler.name)) {
                    if (xNHandlerExit.errorValue() != null) {
                        throw new XNScriptError(xNHandlerExit.errorValue().toTextString(this.context));
                    }
                    return XNHandlerExit.returned();
                }
                throw new XNScriptError("Found exit " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
            }
            case PASSED: {
                return xNHandlerExit;
            }
            case NEXTED: {
                throw new XNScriptError("Found next " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
            }
        }
        return XNHandlerExit.returned();
    }

    private XOMVariant evaluateBuiltInFunction(String string, XNModifier xNModifier, XOMVariant xOMVariant) {
        XNModule.Function function = this.context.getFunctionInterpreter(string);
        if (function != null) {
            XOMVariant xOMVariant2 = function.evaluateFunction(this.context, string, xNModifier, xOMVariant);
            return xOMVariant2 == null ? XOMEmpty.EMPTY : xOMVariant2;
        }
        throw new XNScriptError("Can't understand " + string);
    }

    private boolean variantExists(XNVariantDescriptor xNVariantDescriptor) {
        XOMVariant xOMVariant;
        XNDataType xNDataType = xNVariantDescriptor.datatype;
        String string = xNDataType.toNameString();
        XOMDataType<? extends XOMVariant> xOMDataType = this.context.getDataType(string);
        XNExpression xNExpression = xNVariantDescriptor.parentVariant;
        XOMVariant xOMVariant2 = xOMVariant = xNExpression == null ? null : this.evaluateExpression(xNExpression);
        if (xNVariantDescriptor instanceof XNVariantIdDescriptor) {
            XNExpression xNExpression2 = ((XNVariantIdDescriptor)xNVariantDescriptor).id;
            XOMVariant xOMVariant3 = this.evaluateExpression(xNExpression2).asPrimitive(this.context);
            XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant3, true);
            if (xOMVariant != null) {
                return xOMDataType.canGetChildVariantByID(this.context, xOMVariant, xOMInteger.toInt());
            }
            return xOMDataType.canGetInstanceByID(this.context, xOMInteger.toInt());
        }
        if (xNVariantDescriptor instanceof XNVariantIndexNameDescriptor) {
            XNExpression xNExpression3 = ((XNVariantIndexNameDescriptor)xNVariantDescriptor).start;
            XNExpression xNExpression4 = ((XNVariantIndexNameDescriptor)xNVariantDescriptor).end;
            if (xNExpression3 != null && xNExpression4 != null) {
                int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression3).asPrimitive(this.context), true)).toInt();
                int n2 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression4).asPrimitive(this.context), true)).toInt();
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n, n2);
                }
                return xOMDataType.canGetInstanceByIndex(this.context, n, n2);
            }
            if (xNExpression3 != null) {
                XOMVariant xOMVariant4 = this.evaluateExpression(xNExpression3).asPrimitive(this.context);
                if (!xOMVariant4.toTextString(this.context).equals("") && XOMIntegerType.instance.canMakeInstanceFrom(this.context, xOMVariant4, true)) {
                    int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant4, true)).toInt();
                    if (xOMVariant != null) {
                        return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n);
                    }
                    return xOMDataType.canGetInstanceByIndex(this.context, n);
                }
                String string2 = xOMVariant4.toTextString(this.context);
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByName(this.context, xOMVariant, string2);
                }
                return xOMDataType.canGetInstanceByName(this.context, string2);
            }
            if (xNExpression4 != null) {
                XOMVariant xOMVariant5 = this.evaluateExpression(xNExpression4).asPrimitive(this.context);
                if (!xOMVariant5.toTextString(this.context).equals("") && XOMIntegerType.instance.canMakeInstanceFrom(this.context, xOMVariant5, true)) {
                    int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, xOMVariant5, true)).toInt();
                    if (xOMVariant != null) {
                        return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n);
                    }
                    return xOMDataType.canGetInstanceByIndex(this.context, n);
                }
                String string3 = xOMVariant5.toTextString(this.context);
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByName(this.context, xOMVariant, string3);
                }
                return xOMDataType.canGetInstanceByName(this.context, string3);
            }
            throw new XNScriptError("Can't understand this");
        }
        if (xNVariantDescriptor instanceof XNVariantMassDescriptor) {
            if (xOMVariant != null) {
                return xOMDataType.canGetChildMassVariant(this.context, xOMVariant);
            }
            return xOMDataType.canGetMassInstance(this.context);
        }
        if (xNVariantDescriptor instanceof XNVariantOrdinalDescriptor) {
            XNToken xNToken = ((XNVariantOrdinalDescriptor)xNVariantDescriptor).startOrdinal;
            XNToken xNToken2 = ((XNVariantOrdinalDescriptor)xNVariantDescriptor).endOrdinal;
            if (xNToken != null && xNToken2 != null) {
                int n = this.context.getOrdinal(xNToken.image);
                int n3 = this.context.getOrdinal(xNToken2.image);
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n, n3);
                }
                return xOMDataType.canGetInstanceByIndex(this.context, n, n3);
            }
            if (xNToken != null) {
                int n = this.context.getOrdinal(xNToken.image);
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n);
                }
                return xOMDataType.canGetInstanceByIndex(this.context, n);
            }
            if (xNToken2 != null) {
                int n = this.context.getOrdinal(xNToken2.image);
                if (xOMVariant != null) {
                    return xOMDataType.canGetChildVariantByIndex(this.context, xOMVariant, n);
                }
                return xOMDataType.canGetInstanceByIndex(this.context, n);
            }
            throw new XNScriptError("Can't understand this");
        }
        if (xNVariantDescriptor instanceof XNVariantSingletonDescriptor) {
            if (xOMVariant != null) {
                return xOMDataType.canGetChildSingletonVariant(this.context, xOMVariant);
            }
            return xOMDataType.canGetSingletonInstance(this.context);
        }
        throw new XNScriptError("Can't understand this");
    }

    public void executeScriptFile(File file, String string) throws IOException {
        if (file == null) {
            return;
        }
        this.context.addMessages(XIONUtil.getMessagesForScriptFile(file, string));
        XNLexer xNLexer = new XNLexer(file, new InputStreamReader((InputStream)new FileInputStream(file), string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        List<XNStatement> list = xNParser.parse();
        this.executeScript(list);
    }

    public void executeScriptString(String string) {
        if (string == null) {
            return;
        }
        XNLexer xNLexer = new XNLexer(string, new StringReader(string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        List<XNStatement> list = xNParser.parse();
        this.executeScript(list);
    }

    public void executeScript(List<XNStatement> list) {
        if (list == null) {
            return;
        }
        try {
            XNHandlerExit xNHandlerExit = this.executeStatements(list);
            switch (xNHandlerExit.status()) {
                case RETURNED: {
                    this.context.setResult(xNHandlerExit.returnValue() == null ? XOMEmpty.EMPTY : xNHandlerExit.returnValue());
                    break;
                }
                case EXITED: {
                    if (xNHandlerExit.blockTypeValue() != null) {
                        throw new XNScriptError("Found exit " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                    }
                    if (xNHandlerExit.errorValue() == null) break;
                    throw new XNScriptError(xNHandlerExit.errorValue().toTextString(this.context));
                }
                case NEXTED: {
                    throw new XNScriptError("Found next " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                }
            }
        }
        catch (XNExitedToInterpreterException xNExitedToInterpreterException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessageString(XNResponder xNResponder, String string) {
        XNResponder xNResponder2 = this.context.getFirstResponder();
        this.context.setFirstResponder(xNResponder);
        this.context.pushResponder(xNResponder);
        try {
            XNLexer xNLexer = new XNLexer(string, new StringReader(string));
            XNParser xNParser = new XNParser(this.context, xNLexer);
            List<XNStatement> list = xNParser.parse();
            XNHandlerExit xNHandlerExit = this.executeStatements(list);
            switch (xNHandlerExit.status()) {
                case RETURNED: {
                    this.context.setResult(xNHandlerExit.returnValue() == null ? XOMEmpty.EMPTY : xNHandlerExit.returnValue());
                    return;
                }
                case EXITED: {
                    if (xNHandlerExit.blockTypeValue() != null && !xNHandlerExit.blockTypeValue().equalsIgnoreCase("tell")) {
                        throw new XNScriptError("Found exit " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                    }
                    if (xNHandlerExit.errorValue() == null) return;
                    throw new XNScriptError(xNHandlerExit.errorValue().toTextString(this.context));
                }
                case NEXTED: {
                    throw new XNScriptError("Found next " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                }
            }
            return;
        }
        finally {
            this.context.popResponder();
            this.context.setFirstResponder(xNResponder2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(XNResponder xNResponder, List<XNStatement> list) {
        XNResponder xNResponder2 = this.context.getFirstResponder();
        this.context.setFirstResponder(xNResponder);
        this.context.pushResponder(xNResponder);
        try {
            XNHandlerExit xNHandlerExit = this.executeStatements(list);
            switch (xNHandlerExit.status()) {
                case RETURNED: {
                    this.context.setResult(xNHandlerExit.returnValue() == null ? XOMEmpty.EMPTY : xNHandlerExit.returnValue());
                    return;
                }
                case EXITED: {
                    if (xNHandlerExit.blockTypeValue() != null && !xNHandlerExit.blockTypeValue().equalsIgnoreCase("tell")) {
                        throw new XNScriptError("Found exit " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                    }
                    if (xNHandlerExit.errorValue() == null) return;
                    throw new XNScriptError(xNHandlerExit.errorValue().toTextString(this.context));
                }
                case NEXTED: {
                    throw new XNScriptError("Found next " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
                }
            }
            return;
        }
        finally {
            this.context.popResponder();
            this.context.setFirstResponder(xNResponder2);
        }
    }

    public XNHandlerExit executeStatements(List<XNStatement> list) {
        if (list == null) {
            return XNHandlerExit.ended();
        }
        for (XNStatement xNStatement : list) {
            XNHandlerExit xNHandlerExit = this.executeStatement(xNStatement);
            if (xNHandlerExit.status() == XNHandlerExitStatus.ENDED) continue;
            return xNHandlerExit;
        }
        return XNHandlerExit.ended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XNHandlerExit executeStatement(XNStatement xNStatement) {
        if (xNStatement == null) {
            return XNHandlerExit.ended();
        }
        try {
            if (xNStatement instanceof XNCommandStatement) {
                String string = ((XNCommandStatement)xNStatement).commandName;
                List<XNExpression> list = ((XNCommandStatement)xNStatement).parameters;
                this.executeCommand(string, list);
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNConstantDeclaration) {
                String string = ((XNConstantDeclaration)xNStatement).identifier;
                XNExpression xNExpression = ((XNConstantDeclaration)xNStatement).value;
                if (!this.context.hasConstant(string)) {
                    this.context.addUserConstant(string, this.evaluateExpression(xNExpression).asPrimitive(this.context));
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNDoStatement) {
                XOMVariant xOMVariant = this.evaluateExpression(((XNDoStatement)xNStatement).whatToDo).asPrimitive(this.context);
                XNExpression xNExpression = ((XNDoStatement)xNStatement).language;
                XOMVariant xOMVariant2 = xNExpression == null ? XOMEmpty.EMPTY : this.evaluateExpression(xNExpression).asPrimitive(this.context);
                String string = ((XOMVariant)xOMVariant2).toTextString(this.context);
                if (string.equalsIgnoreCase("") || string.equalsIgnoreCase("xion") || string.equalsIgnoreCase("openxion") || string.equalsIgnoreCase("hypertalk")) {
                    if (!this.context.allow(XNSecurityKey.DO_AND_VALUE, "Code", xOMVariant.toTextString(this.context), "Language", string)) {
                        throw new XNScriptError("Security settings do not allow do");
                    }
                    this.executeScriptString(xOMVariant.toTextString(this.context));
                    return XNHandlerExit.ended();
                }
                if (this.context.hasExternalLanguage(string)) {
                    if (!this.context.allow(XNSecurityKey.EXTERNAL_SCRIPTS, "Code", xOMVariant.toTextString(this.context), "Language", string)) {
                        throw new XNScriptError("Security settings do not allow do");
                    }
                    XOMVariant xOMVariant3 = this.context.getExternalLanguage(string).execute(xOMVariant.toTextString(this.context));
                    if (xOMVariant3 != null) {
                        this.context.setResult(xOMVariant3);
                    }
                    return XNHandlerExit.ended();
                }
                throw new XNScriptError("The " + string + " language is not supported");
            }
            if (xNStatement instanceof XNExitStatement) {
                if (((XNExitStatement)xNStatement).whatToExitTo == null) {
                    if (((XNExitStatement)xNStatement).error != null) {
                        XOMVariant xOMVariant = this.evaluateExpression(((XNExitStatement)xNStatement).error).asPrimitive(this.context);
                        return XNHandlerExit.exitedBlockWithError(((XNExitStatement)xNStatement).whatToExit, xOMVariant);
                    }
                    return XNHandlerExit.exitedBlock(((XNExitStatement)xNStatement).whatToExit);
                }
                XOMVariant xOMVariant = this.evaluateExpression(((XNExitStatement)xNStatement).whatToExitTo).asValue(this.context);
                if (XOMInterpreterType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                    if (((XNExitStatement)xNStatement).error != null) {
                        XOMVariant xOMVariant4 = this.evaluateExpression(((XNExitStatement)xNStatement).error).asPrimitive(this.context);
                        throw new XNExitedToInterpreterException(xOMVariant4.toTextString(this.context));
                    }
                    throw new XNExitedToInterpreterException();
                }
                throw new XNScriptError("Can't exit to this");
            }
            if (xNStatement instanceof XNFunctionHandler) {
                if (this.context.getCurrentStackFrame() != null) {
                    this.context.getCurrentStackFrame().defineLocalUserFunction(((XNFunctionHandler)xNStatement).name, (XNFunctionHandler)xNStatement);
                } else {
                    this.context.defineGlobalUserFunction(((XNFunctionHandler)xNStatement).name, (XNFunctionHandler)xNStatement);
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNIfBlock) {
                XOMVariant xOMVariant = this.evaluateExpression(((XNIfBlock)xNStatement).condition).asPrimitive(this.context);
                if (((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, xOMVariant)).toBoolean()) {
                    XNHandlerExit xNHandlerExit = this.executeStatements(((XNIfBlock)xNStatement).thenBlock);
                    if (xNHandlerExit.status() == XNHandlerExitStatus.EXITED && "if".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        xNHandlerExit = XNHandlerExit.ended();
                    }
                    return xNHandlerExit;
                }
                if (((XNIfBlock)xNStatement).elseBlock != null) {
                    XNHandlerExit xNHandlerExit = this.executeStatements(((XNIfBlock)xNStatement).elseBlock);
                    if (xNHandlerExit.status() == XNHandlerExitStatus.EXITED && "if".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        xNHandlerExit = XNHandlerExit.ended();
                    }
                    return xNHandlerExit;
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNIncludeStatement) {
                XNIncludeStatement xNIncludeStatement = (XNIncludeStatement)xNStatement;
                String string = this.evaluateExpression(xNIncludeStatement.scriptName).toTextString(this.context);
                File file = XIONUtil.locateInclude(this.context, string, xNIncludeStatement.ask);
                if (file != null) {
                    block129: {
                        if (!xNIncludeStatement.once || !this.context.hasIncludedScript(file.getAbsolutePath())) {
                            this.context.addIncludedScript(file.getAbsolutePath());
                            try {
                                this.executeScriptFile(file, this.context.getTextEncoding());
                            }
                            catch (IOException iOException) {
                                if (!xNIncludeStatement.require) break block129;
                                throw new XNScriptError("Cannot read required include " + string);
                            }
                        }
                    }
                    return XNHandlerExit.ended();
                }
                if (xNIncludeStatement.require) {
                    throw new XNScriptError("Cannot find required include " + string);
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNMessageHandler) {
                if (this.context.getCurrentStackFrame() != null) {
                    this.context.getCurrentStackFrame().defineLocalUserCommand(((XNMessageHandler)xNStatement).name, (XNMessageHandler)xNStatement);
                } else {
                    this.context.defineGlobalUserCommand(((XNMessageHandler)xNStatement).name, (XNMessageHandler)xNStatement);
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNNextStatement) {
                return XNHandlerExit.nextedBlock(((XNNextStatement)xNStatement).whatToNext);
            }
            if (xNStatement instanceof XNObjectTypeDeclaration) {
                XOMUserObjectType xOMUserObjectType = new XOMUserObjectType(this.context, (XNObjectTypeDeclaration)xNStatement);
                for (XNObjectTypeName xNObjectTypeName : ((XNObjectTypeDeclaration)xNStatement).names) {
                    String string = "";
                    for (String naNComparisonException : xNObjectTypeName.name) {
                        string = string + " " + naNComparisonException;
                    }
                    if (this.context.hasDataType(string = XIONUtil.normalizeVarName(string))) continue;
                    if (xNObjectTypeName.plural) {
                        this.context.addUserDataType(string, xOMUserObjectType.listType());
                        continue;
                    }
                    this.context.addUserDataType(string, xOMUserObjectType);
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNOrdinalDeclaration) {
                String string = ((XNOrdinalDeclaration)xNStatement).identifier;
                XNExpression xNExpression = ((XNOrdinalDeclaration)xNStatement).value;
                if (!this.context.hasOrdinal(string)) {
                    XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression).asPrimitive(this.context), true);
                    this.context.addUserOrdinal(string, xOMInteger.toInt());
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNPassStatement) {
                if (((XNPassStatement)xNStatement).whatToPassTo == null) {
                    return XNHandlerExit.passed();
                }
                XOMVariant xOMVariant = this.evaluateExpression(((XNPassStatement)xNStatement).whatToPassTo).asValue(this.context);
                if (xOMVariant instanceof XNResponder) {
                    return XNHandlerExit.passedTo((XNResponder)((Object)xOMVariant));
                }
                if (XOMInterpreterType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                    return XNHandlerExit.passedToInterpreter();
                }
                throw new XNScriptError("Can't pass to this");
            }
            if (xNStatement instanceof XNRepeatBlock) {
                XNRepeatParameters xNRepeatParameters = ((XNRepeatBlock)xNStatement).params;
                List<XNStatement> list = ((XNRepeatBlock)xNStatement).body;
                List<XNStatement> list2 = ((XNRepeatBlock)xNStatement).lastlyBody;
                if (xNRepeatParameters instanceof XNRepeatForParameters) {
                    Serializable xOMVariable;
                    boolean bl;
                    XOMVariant xOMVariant;
                    XNExpression xNExpression = ((XNRepeatForParameters)xNRepeatParameters).count;
                    XOMVariant xOMVariant2 = xOMVariant = xNExpression == null ? null : this.evaluateExpression(xNExpression).asPrimitive(this.context);
                    if (xOMVariant == null) {
                        bl = true;
                        int n = Integer.MAX_VALUE;
                    } else {
                        xOMVariable = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, xOMVariant, true);
                        if (((XOMNumber)xOMVariable).isZero() || ((XOMNumber)xOMVariable).getSign() == 1) {
                            if (((XOMNumber)xOMVariable).isInfinite()) {
                                bl = true;
                                int xOMNumber = Integer.MAX_VALUE;
                            } else {
                                try {
                                    bl = false;
                                    int xOMVariant3 = ((XOMNumber)xOMVariable).toBigDecimal().intValueExact();
                                }
                                catch (Exception naNComparisonException) {
                                    throw new XNScriptError("Expected non-negative integer here");
                                }
                            }
                        } else {
                            throw new XNScriptError("Expected non-negative integer here");
                        }
                    }
                    while (bl || --xNExpression > 0) {
                        xOMVariable = this.executeStatements(list);
                        if (((XNHandlerExit)xOMVariable).status() == XNHandlerExitStatus.EXITED && "repeat".equalsIgnoreCase(((XNHandlerExit)xOMVariable).blockTypeValue())) {
                            return XNHandlerExit.ended();
                        }
                        if (((XNHandlerExit)xOMVariable).status() == XNHandlerExitStatus.NEXTED && "repeat".equalsIgnoreCase(((XNHandlerExit)xOMVariable).blockTypeValue()) || ((XNHandlerExit)xOMVariable).status() == XNHandlerExitStatus.ENDED) continue;
                        return xOMVariable;
                    }
                    if (list2 != null) {
                        return this.executeStatements(list2);
                    }
                    return XNHandlerExit.ended();
                }
                if (xNRepeatParameters instanceof XNRepeatWhileParameters) {
                    XNExpression xNExpression = ((XNRepeatWhileParameters)xNRepeatParameters).condition;
                    while (((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression).asPrimitive(this.context))).toBoolean()) {
                        XNHandlerExit xNHandlerExit = this.executeStatements(list);
                        if (xNHandlerExit.status() == XNHandlerExitStatus.EXITED && "repeat".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                            return XNHandlerExit.ended();
                        }
                        if (xNHandlerExit.status() == XNHandlerExitStatus.NEXTED && "repeat".equalsIgnoreCase(xNHandlerExit.blockTypeValue()) || xNHandlerExit.status() == XNHandlerExitStatus.ENDED) continue;
                        return xNHandlerExit;
                    }
                    if (list2 != null) {
                        return this.executeStatements(list2);
                    }
                    return XNHandlerExit.ended();
                }
                if (xNRepeatParameters instanceof XNRepeatUntilParameters) {
                    XNExpression xNExpression = ((XNRepeatUntilParameters)xNRepeatParameters).condition;
                    do {
                        XNHandlerExit xNHandlerExit;
                        if ((xNHandlerExit = this.executeStatements(list)).status() == XNHandlerExitStatus.EXITED && "repeat".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                            return XNHandlerExit.ended();
                        }
                        if (xNHandlerExit.status() == XNHandlerExitStatus.NEXTED && "repeat".equalsIgnoreCase(xNHandlerExit.blockTypeValue()) || xNHandlerExit.status() == XNHandlerExitStatus.ENDED) continue;
                        return xNHandlerExit;
                    } while (!((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(this.context, this.evaluateExpression(xNExpression).asPrimitive(this.context))).toBoolean());
                    if (list2 != null) {
                        return this.executeStatements(list2);
                    }
                    return XNHandlerExit.ended();
                }
                if (xNRepeatParameters instanceof XNRepeatWithParameters) {
                    block131: {
                        XOMVariable xOMVariable = this.evaluateExpression(((XNRepeatWithParameters)xNRepeatParameters).identifier).asVariable(this.context, true);
                        XOMVariant xOMVariant = this.evaluateExpression(((XNRepeatWithParameters)xNRepeatParameters).startvalue).asPrimitive(this.context);
                        XOMVariant xOMVariant6 = this.evaluateExpression(((XNRepeatWithParameters)xNRepeatParameters).endvalue).asPrimitive(this.context);
                        XOMNumber clazz = ((XNRepeatWithParameters)xNRepeatParameters).stepvalue == null ? (((XNRepeatWithParameters)xNRepeatParameters).toToken.image.toLowerCase().contains("down") ? XOMNumber.ONE.negate() : XOMNumber.ONE) : (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, this.evaluateExpression(((XNRepeatWithParameters)xNRepeatParameters).stepvalue).asPrimitive(this.context), true);
                        ((XOMVariant)xOMVariable).putIntoContents(this.context, xOMVariant);
                        while (true) {
                            XOMNumber xOMNumber;
                            XOMNumber xOMNumber2;
                            XNHandlerExit xOMVariant7;
                            block130: {
                                try {
                                    if (clazz.getSign() == 1) {
                                        if (this.compareVariants(xOMVariable, xOMVariant6) <= 0) break block130;
                                        break block131;
                                    }
                                    if (clazz.getSign() == -1) {
                                        if (this.compareVariants(xOMVariable, xOMVariant6) >= 0) break block130;
                                        break block131;
                                    }
                                    if (clazz.getSign() == Integer.MIN_VALUE) {
                                    }
                                }
                                catch (NaNComparisonException xNModule) {}
                                break block131;
                            }
                            if ((xOMVariant7 = this.executeStatements(list)).status() == XNHandlerExitStatus.EXITED && "repeat".equalsIgnoreCase(xOMVariant7.blockTypeValue())) {
                                return XNHandlerExit.ended();
                            }
                            if (!(xOMVariant7.status() == XNHandlerExitStatus.NEXTED && "repeat".equalsIgnoreCase(xOMVariant7.blockTypeValue()) || xOMVariant7.status() == XNHandlerExitStatus.ENDED)) {
                                return xOMVariant7;
                            }
                            MathContext method = this.context.getMathContext();
                            MathProcessor mathProcessor = this.context.getMathProcessor();
                            if (xOMVariable instanceof XOMNumber && clazz instanceof XOMNumber) {
                                xOMNumber2 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, (XOMVariant)xOMVariable, true);
                                xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, (XOMVariant)clazz, true);
                                ((XOMVariant)xOMVariable).putIntoContents(this.context, XOMNumberMath.add(xOMNumber2, xOMNumber, method, mathProcessor));
                                continue;
                            }
                            if (!XOMNumberType.instance.canMakeInstanceFrom(this.context, (XOMVariant)xOMVariable, true) || !XOMNumberType.instance.canMakeInstanceFrom(this.context, (XOMVariant)clazz, true)) break;
                            xOMNumber2 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, (XOMVariant)xOMVariable, true);
                            xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.context, (XOMVariant)clazz, true);
                            ((XOMVariant)xOMVariable).putIntoContents(this.context, XOMNumberMath.add(xOMNumber2, xOMNumber, method, mathProcessor));
                        }
                        throw new XOMMorphError("number");
                    }
                    if (list2 != null) {
                        return this.executeStatements(list2);
                    }
                    return XNHandlerExit.ended();
                }
                if (xNRepeatParameters instanceof XNRepeatForEachParameters) {
                    String string = ((XNRepeatForEachParameters)xNRepeatParameters).identifier;
                    List<? extends XOMVariant> list3 = this.evaluateExpression(((XNRepeatForEachParameters)xNRepeatParameters).list).toVariantList(this.context);
                    for (XOMVariant classNotFoundException : list3) {
                        XOMVariable xOMEmpty = new XOMVariable(this.context.getVariableMap(string), string);
                        ((XOMVariant)xOMEmpty).putIntoContents(this.context, classNotFoundException);
                        XNHandlerExit exception = this.executeStatements(list);
                        if (exception.status() == XNHandlerExitStatus.EXITED && "repeat".equalsIgnoreCase(exception.blockTypeValue())) {
                            return XNHandlerExit.ended();
                        }
                        if (exception.status() == XNHandlerExitStatus.NEXTED && "repeat".equalsIgnoreCase(exception.blockTypeValue()) || exception.status() == XNHandlerExitStatus.ENDED) continue;
                        return exception;
                    }
                    if (list2 != null) {
                        return this.executeStatements(list2);
                    }
                    return XNHandlerExit.ended();
                }
                throw new XNScriptError("Can't understand this");
            }
            if (xNStatement instanceof XNReturnStatement) {
                if (((XNReturnStatement)xNStatement).whatToReturn == null) {
                    return XNHandlerExit.returned();
                }
                return XNHandlerExit.returned(this.evaluateExpression(((XNReturnStatement)xNStatement).whatToReturn).asValue(this.context));
            }
            if (xNStatement instanceof XNSendStatement) {
                String string = this.evaluateExpression(((XNSendStatement)xNStatement).message).toTextString(this.context);
                XOMVariant xOMVariant = this.evaluateExpression(((XNSendStatement)xNStatement).recipient).asValue(this.context);
                boolean bl = ((XNSendStatement)xNStatement).withReply;
                if (xOMVariant instanceof XNResponder) {
                    this.sendMessageString((XNResponder)((Object)xOMVariant), string);
                    if (!bl) {
                        this.context.setResult(null);
                    }
                    return XNHandlerExit.ended();
                }
                if (XOMInterpreterType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                    if (!this.context.allow(XNSecurityKey.DO_AND_VALUE, "Code", string, "Language", "XION via Send")) {
                        throw new XNScriptError("Security settings do not allow send");
                    }
                    this.sendMessageString(null, string);
                    if (!bl) {
                        this.context.setResult(null);
                    }
                    return XNHandlerExit.ended();
                }
                throw new XNScriptError("Can't send to this");
            }
            if (xNStatement instanceof XNSwitchBlock) {
                XOMVariant xOMVariant = this.evaluateExpression(((XNSwitchBlock)xNStatement).switchOn).asPrimitive(this.context);
                Vector<XNCaseBlock> vector = new Vector<XNCaseBlock>();
                Vector<XNCaseBlock> vector2 = new Vector<XNCaseBlock>();
                for (XNCaseBlock xNCaseBlock : ((XNSwitchBlock)xNStatement).cases) {
                    if (vector.isEmpty()) {
                        if (xNCaseBlock.caseValues != null && !xNCaseBlock.caseValues.isEmpty()) {
                            for (XNExpression classCastException : xNCaseBlock.caseValues) {
                                XOMVariant xOMVariant4 = this.evaluateExpression(classCastException).asPrimitive(this.context);
                                try {
                                    if (this.compareVariants(xOMVariant, xOMVariant4) != 0) continue;
                                    vector.add(xNCaseBlock);
                                }
                                catch (NaNComparisonException naNComparisonException) {}
                            }
                        }
                    } else {
                        vector.add(xNCaseBlock);
                    }
                    if (vector2.isEmpty()) {
                        if (xNCaseBlock.caseValues != null && !xNCaseBlock.caseValues.isEmpty()) continue;
                        vector2.add(xNCaseBlock);
                        continue;
                    }
                    vector2.add(xNCaseBlock);
                }
                if (vector.isEmpty()) {
                    vector = vector2;
                }
                for (XNCaseBlock xNCaseBlock : vector) {
                    XNHandlerExit xNHandlerExit = this.executeStatements(xNCaseBlock.caseStatements);
                    if (xNHandlerExit.status() == XNHandlerExitStatus.EXITED && "switch".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        return XNHandlerExit.ended();
                    }
                    if (xNHandlerExit.status() == XNHandlerExitStatus.NEXTED && "case".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) continue;
                    return xNHandlerExit;
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNTellBlock) {
                List<XNStatement> list = ((XNTellBlock)xNStatement).messages;
                XOMVariant xOMVariant = this.evaluateExpression(((XNTellBlock)xNStatement).recipient).asValue(this.context);
                if (xOMVariant instanceof XNResponder) {
                    this.sendMessage((XNResponder)((Object)xOMVariant), list);
                    return XNHandlerExit.ended();
                }
                if (XOMInterpreterType.instance.canMakeInstanceFrom(this.context, xOMVariant)) {
                    this.sendMessage(null, list);
                    return XNHandlerExit.ended();
                }
                throw new XNScriptError("Can't tell this");
            }
            if (xNStatement instanceof XNThrowStatement) {
                XNExpression xNExpression = ((XNThrowStatement)xNStatement).whatToThrow;
                throw new XNScriptError(this.evaluateExpression(xNExpression).toTextString(this.context));
            }
            if (xNStatement instanceof XNTryBlock) {
                XNHandlerExit xNHandlerExit = XNHandlerExit.ended();
                try {
                    if (((XNTryBlock)xNStatement).tryBlock != null && (xNHandlerExit = this.executeStatements(((XNTryBlock)xNStatement).tryBlock)).status() == XNHandlerExitStatus.EXITED && "try".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        xNHandlerExit = XNHandlerExit.ended();
                    }
                }
                catch (XNScriptError xNScriptError) {
                    if (((XNTryBlock)xNStatement).catchBlock != null) {
                        this.context.getVariableMap(((XNTryBlock)xNStatement).catchIdentifier).declareVariable(this.context, ((XNTryBlock)xNStatement).catchIdentifier, XOMStringType.instance, new XOMString(xNScriptError.getMessage()));
                        xNHandlerExit = this.executeStatements(((XNTryBlock)xNStatement).catchBlock);
                        if (xNHandlerExit.status() == XNHandlerExitStatus.EXITED && "try".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                            xNHandlerExit = XNHandlerExit.ended();
                        }
                    }
                }
                finally {
                    if (((XNTryBlock)xNStatement).finallyBlock != null && (xNHandlerExit = this.executeStatements(((XNTryBlock)xNStatement).finallyBlock)).status() == XNHandlerExitStatus.EXITED && "try".equalsIgnoreCase(xNHandlerExit.blockTypeValue())) {
                        xNHandlerExit = XNHandlerExit.ended();
                    }
                }
                return xNHandlerExit;
            }
            if (xNStatement instanceof XNUseStatement) {
                XNExpression xNExpression = ((XNUseStatement)xNStatement).className;
                String[] stringArray = this.evaluateExpression(xNExpression).toTextString(this.context).split("[,:;]");
                if (!this.context.allow(XNSecurityKey.MODULE_LOAD, "Modules", stringArray.toString())) {
                    throw new XNScriptError("Security settings do not allow use");
                }
                for (String string : stringArray) {
                    try {
                        Class<XNModule> illegalAccessException = Class.forName(string).asSubclass(XNModule.class);
                        XNModule xNModule = null;
                        try {
                            Method method = illegalAccessException.getMethod("instance", new Class[0]);
                            xNModule = (XNModule)method.invoke(null, new Object[0]);
                        }
                        catch (Exception exception) {
                            xNModule = illegalAccessException.newInstance();
                        }
                        if (xNModule == null) {
                            throw new XNScriptError("Can't load module " + string);
                        }
                        this.context.loadModule(xNModule);
                    }
                    catch (ClassNotFoundException instantiationException) {
                        throw new XNScriptError("Can't find module " + string);
                    }
                    catch (ClassCastException xOMStringType) {
                        throw new XNScriptError("Can't find module " + string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new XNScriptError("Can't load module " + string);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new XNScriptError("Can't load module " + string);
                    }
                }
                return XNHandlerExit.ended();
            }
            if (xNStatement instanceof XNVariableDeclaration) {
                XNVariableScope xNVariableScope = ((XNVariableDeclaration)xNStatement).scope;
                for (XNVariableInitializer xNVariableInitializer : ((XNVariableDeclaration)xNStatement).vars) {
                    XOMStringType xOMStringType;
                    String string = xNVariableInitializer.name;
                    XNDataType xNDataType = xNVariableInitializer.datatype;
                    XNExpression xNExpression = xNVariableInitializer.value;
                    this.context.setVariableScope(string, xNVariableScope);
                    if (this.context.getVariableMap(string).getVariable(this.context, string) != null) continue;
                    XOMDataType xOMDataType = xOMStringType = xNDataType == null ? XOMStringType.instance : this.context.getDataType(xNDataType.toNameString());
                    if (xOMStringType == null) {
                        throw new XNScriptError("Unrecognized data type");
                    }
                    XOMEmpty xOMEmpty = xNExpression == null ? XOMEmpty.EMPTY : this.evaluateExpression(xNExpression).asPrimitive(this.context);
                    this.context.getVariableMap(string).declareVariable(this.context, string, xOMStringType, xOMEmpty);
                }
                return XNHandlerExit.ended();
            }
            throw new XNScriptError("Can't understand this");
        }
        catch (XNScriptError xNScriptError) {
            xNScriptError.setLineAndCol(xNStatement.getBeginLine(), xNStatement.getBeginCol());
            throw xNScriptError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(String string, List<XNExpression> list) {
        Object object;
        Vector<XOMVariant> vector;
        Cloneable cloneable;
        XNResponder xNResponder = this.context.getFirstResponder();
        if (this.context.getCurrentStackFrame() != null && (cloneable = this.context.getCurrentStackFrame().getLocalUserCommand(string)) != null) {
            vector = new Vector<XOMVariant>();
            for (XNExpression xNExpression : list) {
                vector.add(this.evaluateExpression(xNExpression).asPrimitive(this.context));
            }
            this.context.pushResponder(xNResponder);
            object = null;
            try {
                object = this.executeUserCommand((XNMessageHandler)cloneable, vector);
            }
            finally {
                this.context.popResponder();
            }
            if (((XNHandlerExit)object).status() == XNHandlerExitStatus.PASSED) {
                if (((XNHandlerExit)object).nextResponderValue() != null) {
                    xNResponder = ((XNHandlerExit)object).nextResponderValue();
                } else if ("all".equalsIgnoreCase(((XNHandlerExit)object).blockTypeValue())) {
                    xNResponder = null;
                }
            } else {
                if (((XNHandlerExit)object).status() == XNHandlerExitStatus.ENDED) {
                    return;
                }
                throw new XNScriptError("Internal error: command execution");
            }
        }
        while (true) {
            if (xNResponder != null) {
                this.context.pushResponder(xNResponder);
                cloneable = null;
                try {
                    cloneable = xNResponder.executeCommand(this.context, string, list);
                }
                finally {
                    this.context.popResponder();
                }
                if (((XNHandlerExit)cloneable).status() == XNHandlerExitStatus.PASSED) {
                    if (((XNHandlerExit)cloneable).nextResponderValue() != null) {
                        xNResponder = ((XNHandlerExit)cloneable).nextResponderValue();
                        continue;
                    }
                    if ("all".equalsIgnoreCase(((XNHandlerExit)cloneable).blockTypeValue())) {
                        xNResponder = null;
                        continue;
                    }
                    xNResponder = xNResponder.nextResponder();
                    continue;
                }
                if (((XNHandlerExit)cloneable).status() == XNHandlerExitStatus.ENDED) {
                    return;
                }
                throw new XNScriptError("Internal error: command execution");
            }
            cloneable = this.context.getGlobalUserCommand(string);
            if (cloneable != null) {
                vector = new Vector();
                for (XNExpression xNExpression : list) {
                    vector.add(this.evaluateExpression(xNExpression).asPrimitive(this.context));
                }
                this.context.pushResponder(xNResponder);
                object = null;
                try {
                    object = this.executeUserCommand((XNMessageHandler)cloneable, vector);
                }
                finally {
                    this.context.popResponder();
                }
                if (((XNHandlerExit)object).status() == XNHandlerExitStatus.PASSED) {
                    if (((XNHandlerExit)object).nextResponderValue() != null) {
                        xNResponder = ((XNHandlerExit)object).nextResponderValue();
                    } else if ("all".equalsIgnoreCase(((XNHandlerExit)object).blockTypeValue())) {
                        xNResponder = null;
                    }
                } else {
                    if (((XNHandlerExit)object).status() == XNHandlerExitStatus.ENDED) {
                        return;
                    }
                    throw new XNScriptError("Internal error: command execution");
                }
            }
            if (xNResponder == null) break;
        }
        this.executeBuiltInCommand(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XNHandlerExit executeUserCommand(XNMessageHandler xNMessageHandler, List<XOMVariant> list) {
        XNStackFrame xNStackFrame = new XNStackFrame(xNMessageHandler.name, list);
        if (xNMessageHandler.parameters != null) {
            for (int i = 0; i < xNMessageHandler.parameters.size(); ++i) {
                XOMStringType xOMStringType;
                XNHandlerParameter xNHandlerParameter = xNMessageHandler.parameters.get(i);
                String string = xNHandlerParameter.name;
                XNDataType xNDataType = xNHandlerParameter.datatype;
                XNExpression xNExpression = xNHandlerParameter.value;
                xNStackFrame.setVariableScope(string, XNVariableScope.LOCAL);
                XOMDataType xOMDataType = xOMStringType = xNDataType == null ? XOMStringType.instance : this.context.getDataType(xNDataType.toNameString());
                if (xOMStringType == null) {
                    throw new XNScriptError("Unrecognized data type");
                }
                XOMVariant xOMVariant = i < list.size() ? list.get(i) : (xNExpression == null ? XOMEmpty.EMPTY : this.evaluateExpression(xNExpression).asPrimitive(this.context));
                xNStackFrame.localVariables().declareVariable(this.context, string, xOMStringType, xOMVariant);
            }
        }
        this.context.pushStackFrame(xNStackFrame);
        XNHandlerExit xNHandlerExit = null;
        try {
            xNHandlerExit = this.executeStatements(xNMessageHandler.body);
        }
        finally {
            this.context.popStackFrame();
        }
        switch (xNHandlerExit.status()) {
            case ENDED: {
                return xNHandlerExit;
            }
            case RETURNED: {
                if (xNHandlerExit.returnValue() != null) {
                    this.context.setResult(xNHandlerExit.returnValue());
                }
                return XNHandlerExit.ended();
            }
            case EXITED: {
                if (xNHandlerExit.blockTypeValue().equalsIgnoreCase(xNMessageHandler.name)) {
                    if (xNHandlerExit.errorValue() != null) {
                        throw new XNScriptError(xNHandlerExit.errorValue().toTextString(this.context));
                    }
                    return XNHandlerExit.ended();
                }
                throw new XNScriptError("Found exit " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
            }
            case PASSED: {
                return xNHandlerExit;
            }
            case NEXTED: {
                throw new XNScriptError("Found next " + xNHandlerExit.blockTypeValue() + " outside a " + xNHandlerExit.blockTypeValue() + " block");
            }
        }
        return XNHandlerExit.ended();
    }

    private void executeBuiltInCommand(String string, List<XNExpression> list) {
        XNModule.Command command = this.context.getCommandInterpreter(string);
        if (command != null) {
            XOMVariant xOMVariant = command.executeCommand(this, this.context, string, list);
            if (xOMVariant != null) {
                this.context.setResult(xOMVariant);
            }
        } else {
            throw new XNScriptError("Can't understand " + string);
        }
    }

    public static class NaNComparisonException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

