/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.ast.XNFunctionHandler;
import com.kreative.openxion.ast.XNMessageHandler;
import com.kreative.openxion.ast.XNVariableScope;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMVariableMap;
import com.kreative.openxion.xom.XOMVariant;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNStackFrame
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9999L;
    private String handlerName;
    private List<? extends XOMVariant> parameters;
    private Map<String, XNVariableScope> variableScopes;
    private XOMVariableMap localVariables;
    private Map<String, XNMessageHandler> localUserCommands;
    private Map<String, XNFunctionHandler> localUserFunctions;

    public XNStackFrame(String string, List<? extends XOMVariant> list) {
        this.handlerName = string;
        this.parameters = list;
        this.variableScopes = new HashMap<String, XNVariableScope>();
        this.localVariables = new XOMVariableMap();
        this.localUserCommands = new HashMap<String, XNMessageHandler>();
        this.localUserFunctions = new HashMap<String, XNFunctionHandler>();
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public List<? extends XOMVariant> getParameters() {
        return this.parameters;
    }

    public XNVariableScope getVariableScope(String string) {
        if (this.variableScopes.containsKey(string = XIONUtil.normalizeVarName(string))) {
            return this.variableScopes.get(string);
        }
        return XNVariableScope.LOCAL;
    }

    public void setVariableScope(String string, XNVariableScope xNVariableScope) {
        string = XIONUtil.normalizeVarName(string);
        this.variableScopes.put(string, xNVariableScope);
    }

    public XOMVariableMap localVariables() {
        return this.localVariables;
    }

    public void defineLocalUserCommand(String string, XNMessageHandler xNMessageHandler) {
        string = XIONUtil.normalizeVarName(string);
        this.localUserCommands.put(string, xNMessageHandler);
    }

    public XNMessageHandler getLocalUserCommand(String string) {
        string = XIONUtil.normalizeVarName(string);
        return this.localUserCommands.get(string);
    }

    public void defineLocalUserFunction(String string, XNFunctionHandler xNFunctionHandler) {
        string = XIONUtil.normalizeVarName(string);
        this.localUserFunctions.put(string, xNFunctionHandler);
    }

    public XNFunctionHandler getLocalUserFunction(String string) {
        string = XIONUtil.normalizeVarName(string);
        return this.localUserFunctions.get(string);
    }
}

