/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.ast;

import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNStatement;
import java.util.List;

public class XNTryBlock
extends XNStatement {
    private static final long serialVersionUID = 116L;
    public XNToken tryToken;
    public List<XNStatement> tryBlock;
    public XNToken catchToken;
    public String catchIdentifier;
    public List<XNStatement> catchBlock;
    public XNToken finallyToken;
    public List<XNStatement> finallyBlock;
    public XNToken endTryToken;

    public int getTryLine() {
        if (this.tryToken == null) {
            return 0;
        }
        return this.tryToken.beginLine;
    }

    public int getTryCol() {
        if (this.tryToken == null) {
            return 0;
        }
        return this.tryToken.beginColumn;
    }

    public int getCatchLine() {
        if (this.catchToken == null) {
            return 0;
        }
        return this.catchToken.beginLine;
    }

    public int getCatchCol() {
        if (this.catchToken == null) {
            return 0;
        }
        return this.catchToken.beginColumn;
    }

    public int getFinallyLine() {
        if (this.finallyToken == null) {
            return 0;
        }
        return this.finallyToken.beginLine;
    }

    public int getFinallyCol() {
        if (this.finallyToken == null) {
            return 0;
        }
        return this.finallyToken.beginColumn;
    }

    public int getEndTryLine() {
        if (this.endTryToken == null) {
            return 0;
        }
        return this.endTryToken.beginLine;
    }

    public int getEndTryCol() {
        if (this.endTryToken == null) {
            return 0;
        }
        return this.endTryToken.beginColumn;
    }

    protected String toString(String string) {
        String string2 = string + "try";
        if (this.tryBlock != null) {
            for (XNStatement xNStatement : this.tryBlock) {
                string2 = string2 + "\n" + xNStatement.toString(string + "\t");
            }
        }
        if (this.catchBlock != null) {
            string2 = string2 + "\n" + string + "catch " + this.catchIdentifier;
            for (XNStatement xNStatement : this.catchBlock) {
                string2 = string2 + "\n" + xNStatement.toString(string + "\t");
            }
        }
        if (this.finallyBlock != null) {
            string2 = string2 + "\n" + string + "finally";
            for (XNStatement xNStatement : this.finallyBlock) {
                string2 = string2 + "\n" + xNStatement.toString(string + "\t");
            }
        }
        string2 = string2 + "\n" + string + "end try";
        return string2;
    }
}

