/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.Note;
import com.kreative.openxion.audio.Player;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MIDIPlayer
implements Player {
    private static final String[] stdNames = new String[]{"Acoustic Grand Piano", "Bright Acoustic Piano", "Electric Grand Piano", "Honky-Tonk Piano", "Rhodes Piano", "Chorused Piano", "Harpsichord", "Clavinet", "Celesta", "Glockenspiel", "Music Box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells", "Dulcimer", "Draw Organ", "Percussive Organ", "Rock Organ", "Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Accoustic Nylon Guitar", "Accoustic Steel Guitar", "Electric Jazz Guitar", "Electric Clean Guitar", "Electric Guitar Muted", "Overdriven Guitar", "Distortion Guitar", "Guitar Harmonics", "Wood Bass", "Electric Bass Fingered", "Electric Bass Picked", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Synth Bass 1", "Synth Bass 2", "Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp", "Timpani", "Acoustic String Ensemble 1", "Acoustic String Ensemble 2", "Synth Strings 1", "Synth Strings 2", "Aah Choir", "Ooh Choir", "Synvox", "Orchestra Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet", "French Horn", "Brass Section", "Synth Brass 1", "Synth Brass 2", "Soprano Sax", "Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder", "Pan Flute", "Bottle Blow", "Shakuhachi", "Whistle", "Ocarina", "Square Lead", "Saw Lead", "Calliope", "Chiffer", "Synth Lead 5", "Synth Lead 6", "Synth Lead 7", "Synth Lead 8", "Synth Pad 1", "Synth Pad 2", "Synth Pad 3", "Synth Pad 4", "Synth Pad 5", "Synth Pad 6", "Synth Pad 7", "Synth Pad 8", "Ice Rain", "Soundtracks", "Crystal", "Atmosphere", "Bright", "Goblin", "Echoes", "Space", "Sitar", "Banjo", "Shamisen", "Koto", "Kalimba", "Bagpipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums", "Woodblock", "Taiko Drum", "Melodic Tom", "Synth Tom", "Reverse Cymbal", "Guitar Fret Noise", "Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gunshot"};
    private static SortedMap<Integer, String> idToNameTable = new TreeMap<Integer, String>();
    private static Map<String, Integer> nameToIdTable = new HashMap<String, Integer>();
    private Vector<CynthiaSequence> q = new Vector();
    private CynthiaSequence qp = new CynthiaSequence(0, 0.0f, new Note[0]);
    private CynthiaThread qt = null;

    public String[] getInstruments() {
        return idToNameTable.values().toArray(new String[0]);
    }

    public boolean hasInstrument(String string) {
        string = string.trim().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return nameToIdTable.containsKey(string);
    }

    public synchronized void play(String string) {
        int n = nameToIdTable.containsKey(string = string.trim().replaceAll("[^A-Za-z0-9]", "").toLowerCase()) ? nameToIdTable.get(string) : 0;
        Note note = new Note();
        note.rest = false;
        note.note = 60;
        note.duration = 64;
        note.velocity = 127;
        note.stoccato = false;
        note.fermata = false;
        note.silent = false;
        note.chord = false;
        this.q.add(new CynthiaSequence(n, 120.0f, new Note[]{note}));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new CynthiaThread();
            this.qt.start();
        }
    }

    public synchronized void play(String string, float f, Note[] noteArray) {
        int n = nameToIdTable.containsKey(string = string.trim().replaceAll("[^A-Za-z0-9]", "").toLowerCase()) ? nameToIdTable.get(string) : 0;
        this.q.add(new CynthiaSequence(n, f, noteArray));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new CynthiaThread();
            this.qt.start();
        }
    }

    public synchronized boolean isPlaying() {
        return this.qt != null && this.qt.isAlive() || !this.q.isEmpty();
    }

    public synchronized String getInstrumentPlayed() {
        return (String)idToNameTable.get(this.qp.instrument);
    }

    public synchronized Note[] getNotesPlayed() {
        return this.qp.notes;
    }

    public synchronized void finishPlaying() {
        if (this.qt != null) {
            try {
                this.qt.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.qt = null;
        }
        this.q.clear();
    }

    public synchronized void stopPlaying() {
        if (this.qt != null) {
            this.qt.interrupt();
            this.qt = null;
        }
        this.q.clear();
    }

    private static MidiEvent makeInstEvent(int n, int n2, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(192, n, n2, 0);
        return new MidiEvent(shortMessage, l);
    }

    private static MidiEvent makeNoteEvent(int n, int n2, int n3, long l) throws InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(144, n, n2, n3);
        return new MidiEvent(shortMessage, l);
    }

    private static long addToTrack(Track track, int n, long l, Note[] noteArray) throws InvalidMidiDataException {
        for (Note note : noteArray) {
            if (note.rest) {
                l += (long)note.duration;
                continue;
            }
            if (!note.silent) {
                track.add(MIDIPlayer.makeNoteEvent(n, note.note, note.velocity, l));
            }
            if (!note.fermata) {
                if (!note.stoccato) {
                    track.add(MIDIPlayer.makeNoteEvent(n, note.note, 0, l + (long)note.duration));
                } else {
                    track.add(MIDIPlayer.makeNoteEvent(n, note.note, 0, l + (long)Math.max(1, note.duration - 4)));
                }
            }
            if (note.chord) continue;
            l += (long)note.duration;
        }
        return l;
    }

    private static Sequence createSequence(int n, Note[] noteArray) throws InvalidMidiDataException {
        Sequence sequence = new Sequence(0.0f, 64);
        Track track = sequence.createTrack();
        track.add(MIDIPlayer.makeInstEvent(1, n, 0L));
        MIDIPlayer.addToTrack(track, 1, 0L, noteArray);
        return sequence;
    }

    static {
        for (int i = 0; i < stdNames.length; ++i) {
            String string = stdNames[i];
            String string2 = string.trim().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            idToNameTable.put(i, string);
            nameToIdTable.put(string2, i);
        }
    }

    private class CynthiaThread
    extends Thread {
        private CynthiaThread() {
        }

        public void run() {
            while (!Thread.interrupted() && !MIDIPlayer.this.q.isEmpty()) {
                MIDIPlayer.this.qp = (CynthiaSequence)MIDIPlayer.this.q.remove(0);
                try {
                    Sequencer sequencer = MidiSystem.getSequencer();
                    sequencer.open();
                    sequencer.setSequence(MIDIPlayer.createSequence(((MIDIPlayer)MIDIPlayer.this).qp.instrument, ((MIDIPlayer)MIDIPlayer.this).qp.notes));
                    sequencer.setTempoInBPM(((MIDIPlayer)MIDIPlayer.this).qp.bpm);
                    sequencer.start();
                    while (!Thread.interrupted() && sequencer.isRunning()) {
                    }
                    sequencer.stop();
                    sequencer.close();
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    MIDIPlayer.this.q.add(0, MIDIPlayer.this.qp);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {}
            }
        }
    }

    private static class CynthiaSequence {
        public int instrument;
        public float bpm;
        public Note[] notes;

        public CynthiaSequence(int n, float f, Note[] noteArray) {
            this.instrument = n;
            this.bpm = f;
            this.notes = noteArray;
        }
    }
}

