/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.Speaker;
import com.kreative.openxion.util.XIONUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MacSpeaker
implements Speaker {
    private String dv;
    private String mv;
    private String fv;
    private String nv;
    private String[] voices;
    private Vector<String[]> q = new Vector();
    private String[] qmd = new String[]{"", "", "", ""};
    private MacSpeakerThread qt = null;
    private static final String[] VOICES_PY = new String[]{"from AppKit import NSSpeechSynthesizer\n", "defaultvoice = NSSpeechSynthesizer.defaultVoice()\n", "voices = NSSpeechSynthesizer.availableVoices()\n", "defaultvoiceattr = NSSpeechSynthesizer.attributesForVoice_(defaultvoice)\n", "defaultvoicename = defaultvoiceattr['VoiceName']\n", "print defaultvoicename\n", "for voice in voices:\n", "\tvoiceattr = NSSpeechSynthesizer.attributesForVoice_(voice)\n", "\tvoicename = voiceattr['VoiceName']\n", "\tvoicegender = voiceattr['VoiceGender']\n", "\tif voicegender == 'VoiceGenderMale':\n", "\t\tprint voicename\n", "\t\tbreak\n", "else:\n", "\tprint defaultvoicename\n", "for voice in voices:\n", "\tvoiceattr = NSSpeechSynthesizer.attributesForVoice_(voice)\n", "\tvoicename = voiceattr['VoiceName']\n", "\tvoicegender = voiceattr['VoiceGender']\n", "\tif voicegender == 'VoiceGenderFemale':\n", "\t\tprint voicename\n", "\t\tbreak\n", "else:\n", "\tprint defaultvoicename\n", "for voice in voices:\n", "\tvoiceattr = NSSpeechSynthesizer.attributesForVoice_(voice)\n", "\tvoicename = voiceattr['VoiceName']\n", "\tvoicegender = voiceattr['VoiceGender']\n", "\tif voicegender == 'VoiceGenderNeuter':\n", "\t\tprint voicename\n", "\t\tbreak\n", "else:\n", "\tprint defaultvoicename\n", "voicenames = []\n", "for voice in voices:\n", "\tvoiceattr = NSSpeechSynthesizer.attributesForVoice_(voice)\n", "\tvoicename = voiceattr['VoiceName']\n", "\tif voicename not in voicenames:\n", "\t\tvoicenames.append(voicename)\n", "for voicename in voicenames:\n", "\tprint voicename\n"};

    public MacSpeaker() throws IOException {
        Object object;
        File file = new File(System.getProperty("user.home"));
        file = new File(file, "Library");
        file = new File(file, "Preferences");
        file = new File(file, "com.kreative.openxion.voices.py");
        if (!file.exists()) {
            object = new FileOutputStream(file);
            for (String string : VOICES_PY) {
                ((FileOutputStream)object).write(string.getBytes());
            }
            ((FileOutputStream)object).close();
        }
        object = XIONUtil.captureProcessOutput(new String[]{"python", file.getAbsolutePath()});
        String[] stringArray = ((String)object).trim().split("\n");
        this.dv = stringArray[0];
        this.mv = stringArray[1];
        this.fv = stringArray[2];
        this.nv = stringArray[3];
        this.voices = new String[stringArray.length - 4];
        for (int i = 0; i < this.voices.length; ++i) {
            this.voices[i] = stringArray[i + 4];
        }
    }

    public String[] getVoices() {
        return this.voices;
    }

    public String getDefaultVoice() {
        return this.dv;
    }

    public String getMaleVoice() {
        return this.mv;
    }

    public String getFemaleVoice() {
        return this.fv;
    }

    public String getNeuterVoice() {
        return this.nv;
    }

    public boolean hasVoice(String string) {
        for (String string2 : this.voices) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized void speak(String string) {
        this.q.add(new String[]{"say", "-v", this.dv, string});
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new MacSpeakerThread();
            this.qt.start();
        }
    }

    public synchronized void speak(String string, String string2) {
        this.q.add(new String[]{"say", "-v", string, string2});
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new MacSpeakerThread();
            this.qt.start();
        }
    }

    public synchronized boolean isSpeaking() {
        return this.qt != null && this.qt.isAlive() || !this.q.isEmpty();
    }

    public synchronized String getVoiceSpoken() {
        return this.qmd[2];
    }

    public synchronized String getPhonemeSpoken() {
        return this.qmd[3];
    }

    public synchronized String getPhraseSpoken() {
        return this.qmd[3];
    }

    public synchronized void finishSpeaking() {
        if (this.qt != null) {
            try {
                this.qt.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.qt = null;
        }
        this.q.clear();
    }

    public synchronized void stopSpeaking() {
        if (this.qt != null) {
            this.qt.interrupt();
            this.qt = null;
        }
        this.q.clear();
    }

    static /* synthetic */ String[] access$202(MacSpeaker macSpeaker, String[] stringArray) {
        macSpeaker.qmd = stringArray;
        return stringArray;
    }

    private class MacSpeakerThread
    extends Thread {
        private MacSpeakerThread() {
        }

        public void run() {
            while (!Thread.interrupted() && !MacSpeaker.this.q.isEmpty()) {
                MacSpeaker.access$202(MacSpeaker.this, (String[])MacSpeaker.this.q.remove(0));
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(MacSpeaker.this.qmd);
                    process.waitFor();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    if (process == null) continue;
                    process.destroy();
                }
            }
        }
    }
}

