/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.BitInputStream;
import com.kreative.openxion.binpack.BitOutputStream;
import com.kreative.openxion.binpack.DFExpression;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFUnaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression expr;

    public DFUnaryExpression(Operation operation, DFExpression dFExpression) {
        this.op = operation;
        this.expr = dFExpression;
    }

    @Override
    public int evaluate() {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate() == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate() == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate();
            }
            case IDENTITY: {
                return this.expr.evaluate();
            }
            case ABS: {
                return Math.abs(this.expr.evaluate());
            }
            case NEGATE: {
                return -this.expr.evaluate();
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate());
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate());
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitInputStream bitInputStream, long l) {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate(map, bitInputStream, l) == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate(map, bitInputStream, l) == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate(map, bitInputStream, l);
            }
            case IDENTITY: {
                return this.expr.evaluate(map, bitInputStream, l);
            }
            case ABS: {
                return Math.abs(this.expr.evaluate(map, bitInputStream, l));
            }
            case NEGATE: {
                return -this.expr.evaluate(map, bitInputStream, l);
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate(map, bitInputStream, l));
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate(map, bitInputStream, l));
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitOutputStream bitOutputStream) {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate(map, bitOutputStream) == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate(map, bitOutputStream) == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate(map, bitOutputStream);
            }
            case IDENTITY: {
                return this.expr.evaluate(map, bitOutputStream);
            }
            case ABS: {
                return Math.abs(this.expr.evaluate(map, bitOutputStream));
            }
            case NEGATE: {
                return -this.expr.evaluate(map, bitOutputStream);
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate(map, bitOutputStream));
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate(map, bitOutputStream));
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                stringBuffer.append("!!");
                break;
            }
            case BOOLEAN_NOT: {
                stringBuffer.append("!");
                break;
            }
            case BITWISE_NOT: {
                stringBuffer.append("~");
                break;
            }
            case IDENTITY: {
                stringBuffer.append("+");
                break;
            }
            case NEGATE: {
                stringBuffer.append("-");
                break;
            }
            default: {
                stringBuffer.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        stringBuffer.append(this.expr.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        BOOLEAN_IDENTITY,
        BOOLEAN_NOT,
        BITWISE_NOT,
        IDENTITY,
        ABS,
        NEGATE,
        REVERSE_BITS,
        REVERSE_BYTES;

    }
}

