/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.ColorFormat;
import com.kreative.openxion.binpack.DFExpression;
import com.kreative.openxion.binpack.DFExpressionLexer;
import com.kreative.openxion.binpack.DFExpressionParser;
import com.kreative.openxion.binpack.DataField;
import com.kreative.openxion.binpack.DataType;
import com.kreative.openxion.binpack.DateFormat;
import com.kreative.openxion.binpack.ElaborationType;
import com.kreative.openxion.binpack.FPUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFormatParser {
    private static final int LOOKAHEAD_LIMIT = 65536;
    private static final List<DataField> POINT = new Vector<DataField>();
    private static final List<DataField> RECT = new Vector<DataField>();
    private static final List<DataField> COLOR = new Vector<DataField>();
    private static final Object[][] TYPES;
    private Reader reader;

    public DataFormatParser(Reader reader) {
        this.reader = reader;
    }

    public boolean isShortForm() throws IOException {
        this.parseWhitespace();
        this.reader.mark(65536);
        int n = 0;
        while (Character.isLetter(this.reader.read())) {
            ++n;
        }
        this.reader.reset();
        return n < 2;
    }

    public List<DataField> parseAuto() throws IOException {
        if (this.isShortForm()) {
            return this.parseShortForm();
        }
        return this.parseLongForm();
    }

    public List<DataField> parseLongForm() throws IOException {
        Vector<DataField> vector = new Vector<DataField>();
        while (!this.atEnd()) {
            Object object;
            boolean bl;
            int n;
            Object[] objectArray = this.parseDataType();
            DataType dataType = (DataType)((Object)objectArray[1]);
            if (objectArray.length > 2) {
                n = ((Number)objectArray[2]).intValue();
            } else if (dataType.usesSize()) {
                this.parseWhitespace();
                n = this.parseFieldSize(dataType.defaultSize());
            } else {
                n = 0;
            }
            if (objectArray.length > 3) {
                bl = (Boolean)objectArray[3];
            } else if (dataType.usesEndianness()) {
                this.parseWhitespace();
                bl = this.parseEndianness();
            } else {
                bl = false;
            }
            if (objectArray.length > 4) {
                object = objectArray[4];
            } else if (dataType.usesElaboration()) {
                this.parseWhitespace();
                object = this.parseElaboration(n, dataType.elaborationType());
            } else {
                object = null;
            }
            this.parseWhitespace();
            DFExpression dFExpression = this.parseItemCount();
            this.parseWhitespace();
            String string = this.parseFieldName();
            this.parseWhitespace();
            String string2 = this.parseFieldDescription();
            this.parseWhitespace();
            this.parseTerminator();
            vector.add(new DataField(dataType, n, bl, object, dFExpression, string, string2));
        }
        return vector;
    }

    public List<DataField> parseShortForm() throws IOException {
        Vector<DataField> vector = new Vector<DataField>();
        while (!this.atEnd()) {
            Object object;
            int n;
            Object[] objectArray = this.parseShortDataType();
            DataType dataType = (DataType)((Object)objectArray[0]);
            if (dataType.usesSize()) {
                this.parseWhitespace();
                n = this.parseFieldSize(dataType.defaultSize());
            } else {
                n = 0;
            }
            boolean bl = dataType.usesEndianness() ? (Boolean)objectArray[1] : false;
            if (dataType.usesElaboration()) {
                this.parseWhitespace();
                object = this.parseElaboration(n, dataType.elaborationType());
            } else {
                object = null;
            }
            this.parseWhitespace();
            DFExpression dFExpression = this.parseItemCount();
            this.parseWhitespace();
            String string = this.parseShortFieldName();
            this.parseWhitespace();
            String string2 = this.parseShortFieldDescription();
            vector.add(new DataField(dataType, n, bl, object, dFExpression, string, string2));
        }
        return vector;
    }

    public static String toLongString(List<DataField> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataField dataField : list) {
            DataType dataType = dataField.type();
            stringBuffer.append(dataType.toString());
            if (dataType.usesSize()) {
                stringBuffer.append(dataField.size());
            }
            if (dataType.usesEndianness()) {
                stringBuffer.append(DataFormatParser.endiannessToString(dataField.littleEndian()));
            }
            if (dataType.usesElaboration() && dataField.elaboration() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(DataFormatParser.elaborationToString(dataType.elaborationType(), dataField.elaboration()));
            }
            if (dataField.count() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(DataFormatParser.itemCountToString(dataField.count()));
            }
            if (dataField.name() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(DataFormatParser.fieldNameToString(dataField.name()));
            }
            if (dataField.description() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(DataFormatParser.fieldDescriptionToString(dataField.description()));
            }
            stringBuffer.append(";\n");
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String toShortString(List<DataField> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataField dataField : list) {
            DataType dataType = dataField.type();
            if (dataType.usesEndianness()) {
                if (dataField.littleEndian()) {
                    stringBuffer.append(dataType.toShortString().toLowerCase());
                } else {
                    stringBuffer.append(dataType.toShortString().toUpperCase());
                }
            } else {
                stringBuffer.append(dataType.toShortString());
            }
            if (dataType.usesSize()) {
                stringBuffer.append(dataField.size());
            }
            if (dataType.usesElaboration() && dataField.elaboration() != null) {
                stringBuffer.append(DataFormatParser.elaborationToShortString(dataType.elaborationType(), dataField.elaboration()));
            }
            if (dataField.count() != null) {
                stringBuffer.append(DataFormatParser.itemCountToString(dataField.count()));
            }
            if (dataField.name() != null) {
                stringBuffer.append(DataFormatParser.fieldNameToShortString(dataField.name()));
            }
            if (dataField.description() == null) continue;
            stringBuffer.append(DataFormatParser.fieldDescriptionToShortString(dataField.description()));
        }
        return stringBuffer.toString();
    }

    private boolean atEnd() throws IOException {
        this.reader.mark(65536);
        while (true) {
            int n;
            if ((n = this.reader.read()) < 0) {
                return true;
            }
            if (!Character.isWhitespace(n)) break;
            this.reader.mark(65536);
        }
        this.reader.reset();
        return false;
    }

    private void parseWhitespace() throws IOException {
        this.reader.mark(65536);
        while (Character.isWhitespace(this.reader.read())) {
            this.reader.mark(65536);
        }
        this.reader.reset();
    }

    private Object[] parseDataType() throws IOException {
        this.reader.mark(65536);
        for (Object[] objectArray : TYPES) {
            char[] cArray = new char[objectArray[0].toString().length()];
            this.reader.read(cArray);
            if (new String(cArray).equalsIgnoreCase(objectArray[0].toString())) {
                return objectArray;
            }
            this.reader.reset();
        }
        throw new RuntimeException("Parse error: expected data type");
    }

    private Object[] parseShortDataType() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        DataType dataType = DataType.fromChar((char)n);
        if (dataType == null) {
            this.reader.reset();
            throw new RuntimeException("Parse error: expected data type");
        }
        return new Object[]{dataType, Character.isLowerCase(n)};
    }

    private int parseFieldSize(int n) throws IOException {
        this.reader.mark(65536);
        int n2 = 0;
        while (Character.isDigit(this.reader.read())) {
            ++n2;
        }
        this.reader.reset();
        if (n2 == 0) {
            return n;
        }
        int n3 = 0;
        while (n2-- > 0) {
            n3 *= 10;
            n3 += Character.digit(this.reader.read(), 10);
        }
        return n3;
    }

    private boolean parseEndianness() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        int n2 = this.reader.read();
        if (!(n != 98 && n != 66 || n2 != 101 && n2 != 69)) {
            return false;
        }
        if (!(n != 108 && n != 76 || n2 != 101 && n2 != 69)) {
            return true;
        }
        this.reader.reset();
        return false;
    }

    private static String endiannessToString(boolean bl) {
        return bl ? "le" : "be";
    }

    private Object parseElaboration(int n, ElaborationType elaborationType) throws IOException {
        this.reader.mark(65536);
        if (this.reader.read() == 123) {
            int n2;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.reader.read()) >= 0) {
                if (n2 == 123) {
                    stringBuffer.append(Character.toChars(n2));
                    ++n3;
                    continue;
                }
                if (n2 == 125) {
                    if (n3 == 0) break;
                    stringBuffer.append(Character.toChars(n2));
                    --n3;
                    continue;
                }
                stringBuffer.append(Character.toChars(n2));
            }
            String string = stringBuffer.toString();
            switch (elaborationType) {
                case TEXT_ENCODING: {
                    return string.trim().toUpperCase();
                }
                case DATE_FORMAT: {
                    return this.parseDateFormat(string);
                }
                case COLOR_FORMAT: {
                    return new ColorFormat(n, string);
                }
                case FP_FORMAT: {
                    return this.parseFPFormat(string);
                }
                case VALUE: {
                    return this.parseInt(string);
                }
                case KV_SIGNED: {
                    return this.parseIntStringMap(-1, string);
                }
                case KV_UNSIGNED: {
                    return this.parseIntStringMap(n, string);
                }
                case STRUCT: {
                    return new DataFormatParser(new StringReader(string)).parseAuto();
                }
            }
            return string;
        }
        this.reader.reset();
        switch (elaborationType) {
            case TEXT_ENCODING: {
                return "ISO-8859-1";
            }
            case DATE_FORMAT: {
                return new DateFormat(DateFormat.UNIX);
            }
            case COLOR_FORMAT: {
                return new ColorFormat(n, "ARGB");
            }
            case FP_FORMAT: {
                return new int[]{FPUtilities.optimalSignWidth(n), FPUtilities.optimalExponentWidth(n), FPUtilities.optimalMantissaWidth(n), FPUtilities.optimalBias(FPUtilities.optimalExponentWidth(n))};
            }
            case VALUE: {
                return BigInteger.ZERO;
            }
            case KV_SIGNED: {
                return new HashMap();
            }
            case KV_UNSIGNED: {
                return new HashMap();
            }
            case STRUCT: {
                return new Vector();
            }
        }
        return "";
    }

    private static String elaborationToString(ElaborationType elaborationType, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        switch (elaborationType) {
            case TEXT_ENCODING: {
                stringBuffer.append(object.toString().toUpperCase());
                break;
            }
            case DATE_FORMAT: {
                stringBuffer.append(DataFormatParser.dateFormatToString((DateFormat)object));
                break;
            }
            case COLOR_FORMAT: {
                stringBuffer.append(((ColorFormat)object).toString());
                break;
            }
            case FP_FORMAT: {
                stringBuffer.append(DataFormatParser.fpFormatToString((int[])object));
                break;
            }
            case VALUE: {
                stringBuffer.append(object.toString());
                break;
            }
            case KV_SIGNED: 
            case KV_UNSIGNED: {
                Map map = (Map)object;
                stringBuffer.append("\n\t");
                stringBuffer.append(DataFormatParser.mapToString(map).trim().replace("\n", "\n\t"));
                stringBuffer.append("\n");
                break;
            }
            case STRUCT: {
                List list = (List)object;
                stringBuffer.append("\n\t");
                stringBuffer.append(DataFormatParser.toLongString(list).trim().replace("\n", "\n\t"));
                stringBuffer.append("\n");
                break;
            }
            default: {
                stringBuffer.append(object.toString());
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String elaborationToShortString(ElaborationType elaborationType, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        switch (elaborationType) {
            case TEXT_ENCODING: {
                stringBuffer.append(object.toString().toUpperCase());
                break;
            }
            case DATE_FORMAT: {
                stringBuffer.append(DataFormatParser.dateFormatToString((DateFormat)object));
                break;
            }
            case COLOR_FORMAT: {
                stringBuffer.append(((ColorFormat)object).toString());
                break;
            }
            case FP_FORMAT: {
                stringBuffer.append(DataFormatParser.fpFormatToString((int[])object));
                break;
            }
            case VALUE: {
                stringBuffer.append(object.toString());
                break;
            }
            case KV_SIGNED: 
            case KV_UNSIGNED: {
                Map map = (Map)object;
                stringBuffer.append(DataFormatParser.mapToShortString(map));
                break;
            }
            case STRUCT: {
                List list = (List)object;
                stringBuffer.append(DataFormatParser.toShortString(list));
                break;
            }
            default: {
                stringBuffer.append(object.toString());
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private DFExpression parseItemCount() throws IOException {
        this.reader.mark(65536);
        if (this.reader.read() == 91) {
            String string;
            int n;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = this.reader.read()) >= 0) {
                if (n == 91) {
                    stringBuffer.append(Character.toChars(n));
                    ++n2;
                    continue;
                }
                if (n == 93) {
                    if (n2 == 0) break;
                    stringBuffer.append(Character.toChars(n));
                    --n2;
                    continue;
                }
                stringBuffer.append(Character.toChars(n));
            }
            if ((string = stringBuffer.toString().trim()).length() == 0) {
                return null;
            }
            return new DFExpressionParser(new DFExpressionLexer(new StringReader(string))).parse();
        }
        this.reader.reset();
        return null;
    }

    private static String itemCountToString(DFExpression dFExpression) {
        return "[" + dFExpression.toString() + "]";
    }

    private String parseFieldName() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        if (n == 96) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.reader.read()) >= 0 && n2 != 96) {
                stringBuffer.append(Character.toChars(n2));
            }
            return stringBuffer.toString();
        }
        if (n == 95 || Character.isLetter(n)) {
            int n3;
            this.reader.mark(65536);
            int n4 = 0;
            while ((n3 = this.reader.read()) >= 0 && (Character.isDigit(n3) || Character.isLetter(n3) || n3 == 95)) {
                ++n4;
            }
            this.reader.reset();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toChars(n));
            while (n4-- > 0) {
                stringBuffer.append(Character.toChars(this.reader.read()));
            }
            return stringBuffer.toString();
        }
        this.reader.reset();
        return null;
    }

    private String parseShortFieldName() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        if (n == 96) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.reader.read()) >= 0 && n2 != 96) {
                stringBuffer.append(Character.toChars(n2));
            }
            return stringBuffer.toString();
        }
        this.reader.reset();
        return null;
    }

    private static String fieldNameToString(String string) {
        if (string.matches("^[A-Za-z_][A-Za-z0-9_]*$")) {
            return string;
        }
        return "`" + string.replace("`", "") + "`";
    }

    private static String fieldNameToShortString(String string) {
        return "`" + string.replace("`", "") + "`";
    }

    private String parseFieldDescription() throws IOException {
        int n;
        this.reader.mark(65536);
        int n2 = this.reader.read();
        if (n2 == 34 || n2 == 39) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n3 = this.reader.read()) >= 0 && n3 != n2) {
                stringBuffer.append(Character.toChars(n3));
            }
            return stringBuffer.toString();
        }
        if (n2 < 0 || n2 == 59) {
            this.reader.reset();
            return null;
        }
        this.reader.mark(65536);
        int n4 = 0;
        while ((n = this.reader.read()) >= 0 && n != 59) {
            ++n4;
        }
        this.reader.reset();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toChars(n2));
        while (n4-- > 0) {
            stringBuffer.append(Character.toChars(this.reader.read()));
        }
        String string = stringBuffer.toString().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private String parseShortFieldDescription() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        if (n == 34 || n == 39) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.reader.read()) >= 0 && n2 != n) {
                stringBuffer.append(Character.toChars(n2));
            }
            return stringBuffer.toString();
        }
        this.reader.reset();
        return null;
    }

    private static String fieldDescriptionToString(String string) {
        if (!string.contains("\"")) {
            return "\"" + string + "\"";
        }
        if (!string.contains("'")) {
            return "'" + string + "'";
        }
        if (!string.contains(";")) {
            return string;
        }
        return "\"" + string.replace("\"", "") + "\"";
    }

    private static String fieldDescriptionToShortString(String string) {
        if (!string.contains("\"")) {
            return "\"" + string + "\"";
        }
        if (!string.contains("'")) {
            return "'" + string + "'";
        }
        return "\"" + string.replace("\"", "") + "\"";
    }

    private void parseTerminator() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        if (n >= 0 && n != 59) {
            this.reader.reset();
            throw new RuntimeException("Parse error: expected terminator");
        }
    }

    private DateFormat parseDateFormat(String string) {
        String[] stringArray = string.trim().split("\\s*[.,:;]\\s*");
        switch (stringArray.length) {
            case 7: {
                return new DateFormat(Integer.parseInt(stringArray[0]), 0 + Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]));
            }
            case 6: {
                return new DateFormat(Integer.parseInt(stringArray[0]), 0 + Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]));
            }
            case 4: {
                return new DateFormat(Integer.parseInt(stringArray[0]), 0 + Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            case 3: {
                return new DateFormat(Integer.parseInt(stringArray[0]), 0 + Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]));
            }
            case 2: {
                return new DateFormat(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            case 1: {
                return new DateFormat(Integer.parseInt(stringArray[0]));
            }
        }
        throw new RuntimeException("Invalid date format");
    }

    private static String dateFormatToString(DateFormat dateFormat) {
        Calendar calendar = dateFormat.getEpoch();
        int n = dateFormat.getScale();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(1));
        stringBuffer.append(",");
        stringBuffer.append(calendar.get(2) - 0 + 1);
        stringBuffer.append(",");
        stringBuffer.append(calendar.get(5));
        stringBuffer.append(",");
        stringBuffer.append(calendar.get(11));
        stringBuffer.append(",");
        stringBuffer.append(calendar.get(12));
        stringBuffer.append(",");
        stringBuffer.append(calendar.get(13));
        stringBuffer.append(",");
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    private int[] parseFPFormat(String string) {
        String[] stringArray = string.trim().split("\\s*[.,:;]\\s*");
        switch (stringArray.length) {
            case 4: {
                return new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])};
            }
            case 3: {
                return new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), FPUtilities.optimalBias(Integer.parseInt(stringArray[1]))};
            }
        }
        throw new RuntimeException("Invalid FP format");
    }

    private static String fpFormatToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray[0]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[1]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[2]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[3]);
        return stringBuffer.toString();
    }

    private BigInteger parseInt(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            BigInteger bigInteger = BigInteger.ZERO;
            for (char c : string.substring(1, string.length() - 1).toCharArray()) {
                bigInteger = bigInteger.shiftLeft(8);
                bigInteger = bigInteger.or(BigInteger.valueOf((long)c & 0xFFL));
            }
            return bigInteger;
        }
        if (string.startsWith("0x") || string.startsWith("0X") || string.startsWith("U+") || string.startsWith("U-") || string.startsWith("u+") || string.startsWith("u-")) {
            return new BigInteger(string.substring(2).trim(), 16);
        }
        if (string.startsWith("0o") || string.startsWith("0O")) {
            return new BigInteger(string.substring(2).trim(), 8);
        }
        if (string.startsWith("0b") || string.startsWith("0B")) {
            return new BigInteger(string.substring(2).trim(), 2);
        }
        if (string.startsWith("$")) {
            return new BigInteger(string.substring(1).trim(), 16);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return new BigInteger(string.substring(1).trim(), 8);
        }
        return new BigInteger(string);
    }

    private Map<BigInteger, String> parseIntStringMap(int n, String string) {
        BigInteger bigInteger = n > 0 ? BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE) : null;
        HashMap<BigInteger, String> hashMap = new HashMap<BigInteger, String>();
        String[] stringArray = string.trim().split("\\s*[,;]\\s*");
        BigInteger bigInteger2 = BigInteger.ONE.negate();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split("\\s*[.:=]\\s*", 2);
            if (stringArray2.length > 1) {
                bigInteger2 = this.parseInt(stringArray2[0]);
                if (bigInteger != null) {
                    bigInteger2 = bigInteger2.and(bigInteger);
                }
                hashMap.put(bigInteger2, stringArray2[1]);
                continue;
            }
            bigInteger2 = bigInteger2.add(BigInteger.ONE);
            if (bigInteger != null) {
                bigInteger2 = bigInteger2.and(bigInteger);
            }
            hashMap.put(bigInteger2, stringArray2[0]);
        }
        return hashMap;
    }

    private static String mapToString(Map<?, ?> map) {
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() instanceof Comparable) {
                treeMap.put((Comparable)entry.getKey(), entry.getValue());
                continue;
            }
            treeMap = null;
            break;
        }
        if (treeMap != null) {
            map = treeMap;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue().toString());
            stringBuffer.append(";\n");
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String mapToShortString(Map<?, ?> map) {
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() instanceof Comparable) {
                treeMap.put((Comparable)entry.getKey(), entry.getValue());
                continue;
            }
            treeMap = null;
            break;
        }
        if (treeMap != null) {
            map = treeMap;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue().toString());
            stringBuffer.append(";");
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    static {
        POINT.add(new DataField(DataType.SINT, 16, false, null, null, "y", "Y coordinate"));
        POINT.add(new DataField(DataType.SINT, 16, false, null, null, "x", "X coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "top", "top Y coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "left", "left X coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "bottom", "bottom Y coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "right", "right X coordinate"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "red", "red channel intensity"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "green", "green channel intensity"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "blue", "blue channel intensity"));
        TYPES = new Object[][]{{"character", DataType.CHAR}, {"rectangle", DataType.STRUCT, 0, false, RECT}, {"rgbcolour", DataType.STRUCT, 0, false, COLOR}, {"bitfield", DataType.BITFIELD}, {"datetime", DataType.DATE}, {"rgbcolor", DataType.STRUCT, 0, false, COLOR}, {"boolean", DataType.BOOLEAN}, {"complex", DataType.COMPLEX}, {"pstring", DataType.PSTRING}, {"cstring", DataType.CSTRING}, {"eightcc", DataType.CHAR, 64}, {"wstring", DataType.PSTRING, 16}, {"lstring", DataType.PSTRING, 32}, {"wcharbe", DataType.CHAR, 16, false, "UTF-16BE"}, {"wcharle", DataType.CHAR, 16, true, "UTF-16BE"}, {"ufixed", DataType.UFIXED}, {"sfixed", DataType.SFIXED}, {"filler", DataType.FILLER}, {"binary", DataType.BINARY}, {"struct", DataType.STRUCT}, {"offset", DataType.OFFSET}, {"string", DataType.CSTRING}, {"colour", DataType.COLOR}, {"bshort", DataType.BINT, 16}, {"oshort", DataType.OINT, 16}, {"hshort", DataType.HINT, 16}, {"ushort", DataType.UINT, 16}, {"sshort", DataType.SINT, 16}, {"single", DataType.FLOAT, 32}, {"double", DataType.FLOAT, 64}, {"fourcc", DataType.CHAR, 32}, {"ostype", DataType.CHAR, 32, false, "MACROMAN"}, {"symbol", DataType.CHAR, 64, false, "ISO-8859-1"}, {"float", DataType.FLOAT}, {"color", DataType.COLOR}, {"magic", DataType.MAGIC}, {"align", DataType.ALIGN}, {"fixed", DataType.SFIXED}, {"bbyte", DataType.BINT, 8}, {"obyte", DataType.OINT, 8}, {"hbyte", DataType.HINT, 8}, {"ubyte", DataType.UINT, 8}, {"sbyte", DataType.SINT, 8}, {"short", DataType.SINT, 16}, {"blong", DataType.BINT, 64}, {"olong", DataType.OINT, 64}, {"hlong", DataType.HINT, 64}, {"ulong", DataType.UINT, 64}, {"slong", DataType.SINT, 64}, {"onecc", DataType.CHAR, 8}, {"twocc", DataType.CHAR, 16}, {"wchar", DataType.CHAR, 16, false, "UTF-16BE"}, {"point", DataType.STRUCT, 0, false, POINT}, {"enum", DataType.ENUM}, {"bint", DataType.BINT}, {"oint", DataType.OINT}, {"hint", DataType.HINT}, {"uint", DataType.UINT}, {"sint", DataType.SINT}, {"char", DataType.CHAR}, {"date", DataType.DATE}, {"bool", DataType.BOOLEAN}, {"time", DataType.DATE}, {"blob", DataType.BINARY}, {"byte", DataType.SINT, 8}, {"long", DataType.SINT, 64}, {"half", DataType.FLOAT, 16}, {"real", DataType.FLOAT, 32}, {"quad", DataType.FLOAT, 128}, {"rect", DataType.STRUCT, 0, false, RECT}, {"int", DataType.SINT}, {"occ", DataType.CHAR, 8}, {"tcc", DataType.CHAR, 16}, {"fcc", DataType.CHAR, 32}, {"ecc", DataType.CHAR, 64}};
    }
}

