/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.BitInputStream;
import com.kreative.openxion.binpack.ColorFormat;
import com.kreative.openxion.binpack.DataField;
import com.kreative.openxion.binpack.DateFormat;
import com.kreative.openxion.binpack.MapStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReader {
    private List<DataField> format;

    public DataReader(List<DataField> list) {
        this.format = list;
    }

    public List<Object> unpack(byte[] byArray) throws IOException {
        return this.unpack(new ByteArrayInputStream(byArray), (long)byArray.length);
    }

    public List<Object> unpack(File file) throws IOException {
        return this.unpack(new FileInputStream(file), file.length());
    }

    public List<Object> unpack(InputStream inputStream, long l) throws IOException {
        return this.unpack(new BitInputStream(inputStream), l);
    }

    public List<Object> unpack(BitInputStream bitInputStream, long l) throws IOException {
        return DataReader.unpack(this.format, new MapStack<String, Object>(), (BitInputStream)bitInputStream, (long)l, (boolean)false).listed;
    }

    public Map<String, Object> unpackNamed(byte[] byArray) throws IOException {
        return this.unpackNamed(new ByteArrayInputStream(byArray), (long)byArray.length);
    }

    public Map<String, Object> unpackNamed(File file) throws IOException {
        return this.unpackNamed(new FileInputStream(file), file.length());
    }

    public Map<String, Object> unpackNamed(InputStream inputStream, long l) throws IOException {
        return this.unpackNamed(new BitInputStream(inputStream), l);
    }

    public Map<String, Object> unpackNamed(BitInputStream bitInputStream, long l) throws IOException {
        return DataReader.unpack(this.format, new MapStack<String, Object>(), (BitInputStream)bitInputStream, (long)l, (boolean)true).named;
    }

    private static UnpackResult unpack(List<DataField> list, MapStack<String, Object> mapStack, BitInputStream bitInputStream, long l, boolean bl) throws IOException {
        UnpackResult unpackResult = new UnpackResult();
        mapStack.push(unpackResult.named);
        for (DataField dataField : list) {
            if (dataField.type().returns()) {
                Object object = DataReader.unpackFieldWithCount(dataField, mapStack, bitInputStream, l, bl);
                unpackResult.listed.add(object);
                if (dataField.name() == null) continue;
                unpackResult.named.put(dataField.name(), object);
                continue;
            }
            DataReader.unpackFieldWithCount(dataField, mapStack, bitInputStream, l, bl);
        }
        mapStack.pop();
        return unpackResult;
    }

    private static Object unpackFieldWithCount(DataField dataField, MapStack<String, Object> mapStack, BitInputStream bitInputStream, long l, boolean bl) throws IOException {
        if (dataField.count() == null || dataField.type().usesCustomCount()) {
            return DataReader.unpackFieldWithoutCount(dataField, mapStack, bitInputStream, l, bl);
        }
        int n = dataField.count().evaluate(mapStack, bitInputStream, l);
        if (dataField.type().returns()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n < 10 ? 10 : n);
            while (n-- > 0) {
                arrayList.add(DataReader.unpackFieldWithoutCount(dataField, mapStack, bitInputStream, l, bl));
            }
            return arrayList;
        }
        while (n-- > 0) {
            DataReader.unpackFieldWithoutCount(dataField, mapStack, bitInputStream, l, bl);
        }
        return null;
    }

    private static Object unpackFieldWithoutCount(DataField dataField, MapStack<String, Object> mapStack, BitInputStream bitInputStream, long l, boolean bl) throws IOException {
        switch (dataField.type()) {
            case BOOLEAN: {
                return !bitInputStream.readBits(dataField.size()).isEmpty();
            }
            case ENUM: {
                BigInteger bigInteger = dataField.littleEndian() ? bitInputStream.readUnsignedIntegerLE(dataField.size()) : bitInputStream.readUnsignedInteger(dataField.size());
                Map map = (Map)dataField.elaboration();
                if (map.containsKey(bigInteger)) {
                    return map.get(bigInteger);
                }
                return bigInteger;
            }
            case BITFIELD: {
                BitSet bitSet = dataField.littleEndian() ? bitInputStream.readBitsLE(dataField.size()) : bitInputStream.readBits(dataField.size());
                ArrayList arrayList = new ArrayList();
                Map map = (Map)dataField.elaboration();
                for (int i = 0; i < dataField.size(); ++i) {
                    if (!bitSet.get(i)) continue;
                    BigInteger bigInteger = BigInteger.valueOf(i);
                    if (map.containsKey(bigInteger)) {
                        arrayList.add(map.get(bigInteger));
                        continue;
                    }
                    if (!map.containsKey(i)) continue;
                    arrayList.add(map.get(i));
                }
                return arrayList;
            }
            case BINT: {
                if (dataField.littleEndian()) {
                    return bitInputStream.readUnsignedIntegerLE(dataField.size()).toString(2);
                }
                return bitInputStream.readUnsignedInteger(dataField.size()).toString(2);
            }
            case OINT: {
                if (dataField.littleEndian()) {
                    return bitInputStream.readUnsignedIntegerLE(dataField.size()).toString(8);
                }
                return bitInputStream.readUnsignedInteger(dataField.size()).toString(8);
            }
            case HINT: {
                if (dataField.littleEndian()) {
                    return bitInputStream.readUnsignedIntegerLE(dataField.size()).toString(16).toUpperCase();
                }
                return bitInputStream.readUnsignedInteger(dataField.size()).toString(16).toUpperCase();
            }
            case UINT: {
                if (dataField.littleEndian()) {
                    return bitInputStream.readUnsignedIntegerLE(dataField.size());
                }
                return bitInputStream.readUnsignedInteger(dataField.size());
            }
            case SINT: {
                if (dataField.littleEndian()) {
                    return bitInputStream.readIntegerLE(dataField.size());
                }
                return bitInputStream.readInteger(dataField.size());
            }
            case UFIXED: {
                if (dataField.littleEndian()) {
                    return new BigDecimal(bitInputStream.readUnsignedIntegerLE(dataField.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(dataField.size() / 2), MathContext.DECIMAL128);
                }
                return new BigDecimal(bitInputStream.readUnsignedInteger(dataField.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(dataField.size() / 2), MathContext.DECIMAL128);
            }
            case SFIXED: {
                if (dataField.littleEndian()) {
                    return new BigDecimal(bitInputStream.readIntegerLE(dataField.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(dataField.size() / 2), MathContext.DECIMAL128);
                }
                return new BigDecimal(bitInputStream.readInteger(dataField.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(dataField.size() / 2), MathContext.DECIMAL128);
            }
            case FLOAT: {
                int[] nArray = (int[])dataField.elaboration();
                if (dataField.littleEndian()) {
                    return bitInputStream.readFloatLE(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
                }
                return bitInputStream.readFloat(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
            }
            case COMPLEX: {
                int[] nArray = (int[])dataField.elaboration();
                if (dataField.littleEndian()) {
                    Number number = bitInputStream.readFloatLE(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
                    Number number2 = bitInputStream.readFloatLE(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
                    return new Number[]{number, number2};
                }
                Number number = bitInputStream.readFloat(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
                Number number3 = bitInputStream.readFloat(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128);
                return new Number[]{number, number3};
            }
            case CHAR: {
                if ((dataField.size() & 7) != 0) {
                    throw new IOException("Character values must be of a byte-multiple width");
                }
                int n = dataField.size() >> 3;
                byte[] byArray = new byte[n];
                bitInputStream.readFully(byArray);
                if (dataField.littleEndian()) {
                    int n2 = 0;
                    int n3 = byArray.length - 1;
                    while (n2 < byArray.length / 2) {
                        byte by = byArray[n2];
                        byArray[n2] = byArray[n3];
                        byArray[n3] = by;
                        ++n2;
                        --n3;
                    }
                }
                return new String(byArray, dataField.elaboration().toString());
            }
            case PSTRING: {
                int n = (dataField.littleEndian() ? bitInputStream.readUnsignedIntegerLE(dataField.size()) : bitInputStream.readUnsignedInteger(dataField.size())).intValue();
                byte[] byArray = new byte[n];
                bitInputStream.readFully(byArray);
                return new String(byArray, dataField.elaboration().toString());
            }
            case CSTRING: {
                if ((dataField.size() & 7) != 0) {
                    throw new IOException("C-string values must be of a byte-multiple width");
                }
                int n = dataField.size() >> 3;
                byte[] byArray = new byte[n];
                bitInputStream.readFully(byArray);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (true) {
                    boolean bl2 = true;
                    for (byte by : byArray) {
                        if (by == 0) continue;
                        bl2 = false;
                    }
                    if (bl2) break;
                    byteArrayOutputStream.write(byArray[0]);
                    for (int i = 1; i < byArray.length; ++i) {
                        byArray[i - 1] = byArray[i];
                    }
                    byArray[byArray.length - 1] = bitInputStream.readByte();
                }
                return new String(byteArrayOutputStream.toByteArray(), dataField.elaboration().toString());
            }
            case DATE: {
                DateFormat dateFormat = (DateFormat)dataField.elaboration();
                if (dataField.littleEndian()) {
                    return dateFormat.longToCalendar(bitInputStream.readIntegerLE(dataField.size()).longValue());
                }
                return dateFormat.longToCalendar(bitInputStream.readInteger(dataField.size()).longValue());
            }
            case COLOR: {
                ColorFormat colorFormat = (ColorFormat)dataField.elaboration();
                BigInteger bigInteger = dataField.littleEndian() ? bitInputStream.readUnsignedIntegerLE(dataField.size()) : bitInputStream.readUnsignedInteger(dataField.size());
                Number[] numberArray = new Number[colorFormat.channelCount()];
                int n = 0;
                for (int i = colorFormat.channelCount() - 1; i >= 0; --i) {
                    numberArray[i] = bigInteger.shiftRight(n).and(BigInteger.ONE.shiftLeft(colorFormat.channelWidth(i)).subtract(BigInteger.ONE));
                    n += colorFormat.channelWidth(i);
                }
                return colorFormat.toRGBAFloatArray(colorFormat.toFloatArray(numberArray));
            }
            case FILLER: {
                bitInputStream.skipBits(dataField.size());
                return null;
            }
            case MAGIC: {
                BigInteger bigInteger;
                BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(dataField.size()).subtract(BigInteger.ONE);
                BigInteger bigInteger3 = ((BigInteger)dataField.elaboration()).and(bigInteger2);
                BigInteger bigInteger4 = bigInteger = dataField.littleEndian() ? bitInputStream.readUnsignedIntegerLE(dataField.size()) : bitInputStream.readUnsignedInteger(dataField.size());
                if (bigInteger.compareTo(bigInteger3) != 0) {
                    throw new IOException("Magic numbers do not match");
                }
                return null;
            }
            case ALIGN: {
                while (!bitInputStream.atBitBoundary(dataField.size())) {
                    bitInputStream.skipBit();
                }
                return null;
            }
            case BINARY: {
                if (dataField.count() != null) {
                    int n = dataField.count().evaluate(mapStack, bitInputStream, l);
                    byte[] byArray = new byte[n];
                    bitInputStream.readFully(byArray);
                    return byArray;
                }
                return new byte[0];
            }
            case STRUCT: {
                List list = (List)dataField.elaboration();
                UnpackResult unpackResult = DataReader.unpack(list, mapStack, bitInputStream, l, bl);
                return bl ? unpackResult.named : unpackResult.listed;
            }
            case OFFSET: {
                if (dataField.count() != null) {
                    int n = dataField.count().evaluate(mapStack, bitInputStream, l);
                    bitInputStream.reset();
                    bitInputStream.skipBytes(n);
                }
                return null;
            }
        }
        throw new RuntimeException("Unknown data type: " + dataField.type().toString());
    }

    private static class UnpackResult {
        public List<Object> listed = new ArrayList<Object>();
        public Map<String, Object> named = new HashMap<String, Object>();

        private UnpackResult() {
        }
    }
}

