/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.format;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.ast.XNOperator;
import com.kreative.openxion.format.FSExpression;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBoolean;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMReference;
import com.kreative.openxion.xom.type.XOMBooleanType;
import com.kreative.openxion.xom.type.XOMComplexType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import com.kreative.openxion.xom.type.XOMReferenceType;
import java.math.BigInteger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSUnaryExpression
implements FSExpression {
    private XNOperator op;
    private FSExpression arg;

    public FSUnaryExpression(XNOperator xNOperator, FSExpression fSExpression) {
        this.op = xNOperator;
        this.arg = fSExpression;
    }

    @Override
    public XOMVariant evaluate(XNContext xNContext, List<? extends XOMVariant> list) {
        switch (this.op) {
            case NOT: {
                XOMVariant xOMVariant = this.arg.evaluate(xNContext, list);
                boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                return bl ? XOMBoolean.FALSE : XOMBoolean.TRUE;
            }
            case UNARY_SUBTRACT: {
                XOMVariant xOMVariant = this.arg.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMInteger) {
                    return ((XOMInteger)xOMVariant).negate();
                }
                if (xOMVariant instanceof XOMNumber) {
                    return ((XOMNumber)xOMVariant).negate();
                }
                if (xOMVariant instanceof XOMComplex) {
                    return ((XOMComplex)xOMVariant).negate();
                }
                if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                    XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    return xOMInteger.negate();
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    return xOMNumber.negate();
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    return xOMComplex.negate();
                }
                throw new XOMMorphError("number");
            }
            case BIT_NOT: {
                XOMVariant xOMVariant = this.arg.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                if (bigInteger == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.not());
            }
            case REFERENCE_TO: {
                return new XOMReference(this.arg.evaluate(xNContext, list));
            }
            case REFERENT_OF: {
                XOMVariant xOMVariant = this.arg.evaluate(xNContext, list);
                return XOMReferenceType.instance.makeInstanceFrom(xNContext, xOMVariant).dereference(true);
            }
        }
        throw new XNScriptError("Can't understand this");
    }
}

