/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.io.XNIOMethod;
import com.kreative.openxion.io.XNIOStream;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.type.XOMBinaryType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BinaryIOMethod
implements XNIOMethod {
    public static final BinaryIOMethod instance = new BinaryIOMethod();

    public boolean worksWith(String string) {
        return string.trim().toLowerCase().equalsIgnoreCase("binary");
    }

    public void open(XNContext xNContext, XNIOStream xNIOStream, String string) {
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65536];
            while ((n = xNIOStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant) {
        try {
            int n;
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!XIONUtil.binaryEndsWith(byteArrayOutputStream.toByteArray(), byArray) && (n = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, int n) {
        try {
            byte[] byArray = new byte[n];
            int n2 = xNIOStream.read(byArray);
            if (n2 < 0) {
                n2 = 0;
            }
            byArray = XIONUtil.binarySubstring(byArray, 0, n2);
            return new XOMBinary(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, int n, XOMVariant xOMVariant) {
        try {
            int n2;
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (byteArrayOutputStream.size() < n && !XIONUtil.binaryEndsWith(byteArrayOutputStream.toByteArray(), byArray) && (n2 = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n2);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l) {
        try {
            int n;
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65536];
            while ((n = xNIOStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, XOMVariant xOMVariant) {
        try {
            int n;
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!XIONUtil.binaryEndsWith(byteArrayOutputStream.toByteArray(), byArray) && (n = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, int n) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = new byte[n];
            int n2 = xNIOStream.read(byArray);
            if (n2 < 0) {
                n2 = 0;
            }
            byArray = XIONUtil.binarySubstring(byArray, 0, n2);
            return new XOMBinary(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, int n, XOMVariant xOMVariant) {
        try {
            int n2;
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (byteArrayOutputStream.size() < n && !XIONUtil.binaryEndsWith(byteArrayOutputStream.toByteArray(), byArray) && (n2 = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n2);
            }
            return new XOMBinary(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public void write(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant) {
        try {
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            xNIOStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to write");
        }
    }

    public void write(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant, long l) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
            xNIOStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to write");
        }
    }

    public void truncate(XNContext xNContext, XNIOStream xNIOStream) {
        try {
            xNIOStream.setLength(xNIOStream.getFilePointer());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to truncate");
        }
    }

    public void truncate(XNContext xNContext, XNIOStream xNIOStream, long l) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.setLength(l);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to truncate");
        }
    }

    public void close(XNContext xNContext, XNIOStream xNIOStream) {
    }
}

