/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.io.XNIOMethod;
import com.kreative.openxion.io.XNIOStream;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class TextIOMethod
implements XNIOMethod {
    public static final TextIOMethod instance = new TextIOMethod();
    private Map<XNIOStream, String> encodings = new HashMap<XNIOStream, String>();

    public boolean worksWith(String string) {
        if (string.trim().toLowerCase().equalsIgnoreCase("text")) {
            return true;
        }
        try {
            new String(new byte[0], string.trim());
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public void open(XNContext xNContext, XNIOStream xNIOStream, String string) {
        if ((string = string.trim()).equalsIgnoreCase("text")) {
            string = xNContext.getTextEncoding().trim();
        }
        this.encodings.put(xNIOStream, string);
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream) {
        try {
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                int n;
                String string2;
                if ((string2 = new String(byteArrayOutputStream.toByteArray(), string)).endsWith("\r")) {
                    int n2;
                    n = xNIOStream.lookahead();
                    if (n < 0) break;
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream2.write(n);
                    String string3 = new String(byteArrayOutputStream2.toByteArray(), string);
                    if (!string3.endsWith("\r\n") || (n2 = xNIOStream.read()) < 0) break;
                    byteArrayOutputStream.write(n2);
                    break;
                }
                if (string2.endsWith("\n") || string2.endsWith("\u2028") || string2.endsWith("\u2029") || (n = xNIOStream.read()) < 0) break;
                byteArrayOutputStream.write(n);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant) {
        try {
            int n;
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            String string2 = xOMVariant.toTextString(xNContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!new String(byteArrayOutputStream.toByteArray(), string).endsWith(string2) && (n = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, int n) {
        try {
            byte[] byArray = new byte[n];
            int n2 = xNIOStream.read(byArray);
            if (n2 < 0) {
                n2 = 0;
            }
            byArray = XIONUtil.binarySubstring(byArray, 0, n2);
            return new XOMString(new String(byArray, this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding()));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, int n, XOMVariant xOMVariant) {
        try {
            int n2;
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            String string2 = xOMVariant.toTextString(xNContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (byteArrayOutputStream.size() < n && !new String(byteArrayOutputStream.toByteArray(), string).endsWith(string2) && (n2 = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n2);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                int n;
                String string2;
                if ((string2 = new String(byteArrayOutputStream.toByteArray(), string)).endsWith("\r")) {
                    int n2;
                    n = xNIOStream.lookahead();
                    if (n < 0) break;
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream2.write(n);
                    String string3 = new String(byteArrayOutputStream2.toByteArray(), string);
                    if (!string3.endsWith("\r\n") || (n2 = xNIOStream.read()) < 0) break;
                    byteArrayOutputStream.write(n2);
                    break;
                }
                if (string2.endsWith("\n") || string2.endsWith("\u2028") || string2.endsWith("\u2029") || (n = xNIOStream.read()) < 0) break;
                byteArrayOutputStream.write(n);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, XOMVariant xOMVariant) {
        try {
            int n;
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            String string2 = xOMVariant.toTextString(xNContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!new String(byteArrayOutputStream.toByteArray(), string).endsWith(string2) && (n = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, int n) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = new byte[n];
            int n2 = xNIOStream.read(byArray);
            if (n2 < 0) {
                n2 = 0;
            }
            byArray = XIONUtil.binarySubstring(byArray, 0, n2);
            return new XOMString(new String(byArray, this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding()));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public XOMVariant read(XNContext xNContext, XNIOStream xNIOStream, long l, int n, XOMVariant xOMVariant) {
        try {
            int n2;
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            String string = this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding();
            String string2 = xOMVariant.toTextString(xNContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (byteArrayOutputStream.size() < n && !new String(byteArrayOutputStream.toByteArray(), string).endsWith(string2) && (n2 = xNIOStream.read()) >= 0) {
                byteArrayOutputStream.write(n2);
            }
            return new XOMString(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to read");
        }
    }

    public void write(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant) {
        try {
            byte[] byArray = xOMVariant.toTextString(xNContext).getBytes(this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding());
            xNIOStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to write");
        }
    }

    public void write(XNContext xNContext, XNIOStream xNIOStream, XOMVariant xOMVariant, long l) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.seek(l);
            byte[] byArray = xOMVariant.toTextString(xNContext).getBytes(this.encodings.containsKey(xNIOStream) ? this.encodings.get(xNIOStream) : xNContext.getTextEncoding());
            xNIOStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to write");
        }
    }

    public void truncate(XNContext xNContext, XNIOStream xNIOStream) {
        try {
            xNIOStream.setLength(xNIOStream.getFilePointer());
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to truncate");
        }
    }

    public void truncate(XNContext xNContext, XNIOStream xNIOStream, long l) {
        try {
            if (l < 0L) {
                l += xNIOStream.length();
            }
            xNIOStream.setLength(l);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Failed to truncate");
        }
    }

    public void close(XNContext xNContext, XNIOStream xNIOStream) {
        this.encodings.remove(xNIOStream);
    }
}

