/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.io.XNIOStreamInfo;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMFile;
import com.kreative.openxion.xom.inst.XOMURL;
import com.kreative.openxion.xom.type.XOMFileType;
import com.kreative.openxion.xom.type.XOMURLType;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class XNIOStreamInfoMap {
    private Map<Object, XNIOStreamInfo> streamInfo = new HashMap<Object, XNIOStreamInfo>();

    public XNIOStreamInfo getFileStreamInfo(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.streamInfo.containsKey(xOMVariant)) {
            return this.streamInfo.get(xOMVariant);
        }
        XOMFile xOMFile = XOMFileType.instance.makeInstanceFrom(xNContext, xOMVariant);
        if (this.streamInfo.containsKey(xOMFile)) {
            return this.streamInfo.get(xOMFile);
        }
        File file = xOMFile.toFile().getAbsoluteFile();
        if (this.streamInfo.containsKey(file)) {
            return this.streamInfo.get(file);
        }
        String string = file.getAbsolutePath();
        if (this.streamInfo.containsKey(string)) {
            return this.streamInfo.get(string);
        }
        return null;
    }

    public XNIOStreamInfo getURLStreamInfo(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.streamInfo.containsKey(xOMVariant)) {
            return this.streamInfo.get(xOMVariant);
        }
        XOMURL xOMURL = (XOMURL)XOMURLType.instance.makeInstanceFrom(xNContext, xOMVariant);
        if (this.streamInfo.containsKey(xOMURL)) {
            return this.streamInfo.get(xOMURL);
        }
        URL uRL = xOMURL.toURL();
        if (this.streamInfo.containsKey(uRL)) {
            return this.streamInfo.get(uRL);
        }
        String string = uRL.toString();
        if (this.streamInfo.containsKey(string)) {
            return this.streamInfo.get(string);
        }
        return null;
    }

    public void setFileStreamInfo(XNContext xNContext, XOMVariant xOMVariant, XNIOStreamInfo xNIOStreamInfo) {
        this.streamInfo.put(xOMVariant, xNIOStreamInfo);
        XOMFile xOMFile = XOMFileType.instance.makeInstanceFrom(xNContext, xOMVariant);
        this.streamInfo.put(xOMFile, xNIOStreamInfo);
        File file = xOMFile.toFile().getAbsoluteFile();
        this.streamInfo.put(file, xNIOStreamInfo);
        String string = file.getAbsolutePath();
        this.streamInfo.put(string, xNIOStreamInfo);
    }

    public void setURLStreamInfo(XNContext xNContext, XOMVariant xOMVariant, XNIOStreamInfo xNIOStreamInfo) {
        this.streamInfo.put(xOMVariant, xNIOStreamInfo);
        XOMURL xOMURL = (XOMURL)XOMURLType.instance.makeInstanceFrom(xNContext, xOMVariant);
        this.streamInfo.put(xOMURL, xNIOStreamInfo);
        URL uRL = xOMURL.toURL();
        this.streamInfo.put(uRL, xNIOStreamInfo);
        String string = uRL.toString();
        this.streamInfo.put(string, xNIOStreamInfo);
    }

    public void removeStreamInfo(XNIOStreamInfo xNIOStreamInfo) {
        Vector<Object> vector = new Vector<Object>();
        for (Map.Entry<Object, XNIOStreamInfo> entry : this.streamInfo.entrySet()) {
            if (entry.getValue() != xNIOStreamInfo) continue;
            vector.add(entry.getKey());
        }
        for (Map.Entry<Object, XNIOStreamInfo> entry : vector) {
            this.streamInfo.remove(entry);
        }
    }
}

