/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.io.XNIOManager;
import com.kreative.openxion.io.XNIOMethod;
import com.kreative.openxion.io.XNIOStreamInfo;
import com.kreative.openxion.io.XNIOStreamInfoMap;
import com.kreative.openxion.io.XNURLConnectionIOStream;
import com.kreative.openxion.util.BareBonesBrowserLaunch;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMURL;
import com.kreative.openxion.xom.type.XOMURLType;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class XOMURLIOManager
implements XNIOManager {
    public static final XOMURLIOManager instance = new XOMURLIOManager();
    private XNIOStreamInfoMap sim = new XNIOStreamInfoMap();

    public boolean worksWith(XNContext xNContext, XOMVariant xOMVariant) {
        return XOMURLType.instance.canMakeInstanceFrom(xNContext, xOMVariant);
    }

    public void open(XNContext xNContext, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.BROWSER_LAUNCH, "Operation", "Open", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow open URL");
        }
        try {
            XOMURL xOMURL = (XOMURL)XOMURLType.instance.makeInstanceFrom(xNContext, xOMVariant);
            URL uRL = xOMURL.toURL();
            String string = uRL.toString();
            BareBonesBrowserLaunch.openURL(string);
        }
        catch (Exception exception) {
            throw new XNScriptError(exception, "Can't open that URL");
        }
    }

    public void open(XNContext xNContext, XOMVariant xOMVariant, XNIOMethod xNIOMethod, String string) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Open", "Object", xOMVariant.toLanguageString(), "Method", xNIOMethod.getClass().getSimpleName(), "Type", string)) {
            throw new XNScriptError("Security settings do not allow open URL");
        }
        try {
            XOMURL xOMURL = (XOMURL)XOMURLType.instance.makeInstanceFrom(xNContext, xOMVariant);
            URL uRL = xOMURL.toURL();
            String string2 = uRL.toString();
            if (this.sim.getURLStreamInfo(xNContext, xOMVariant) != null) {
                throw new XNScriptError("URL \"" + string2 + "\" is already open");
            }
            URLConnection uRLConnection = uRL.openConnection();
            XNURLConnectionIOStream xNURLConnectionIOStream = new XNURLConnectionIOStream(uRLConnection);
            XNIOStreamInfo xNIOStreamInfo = new XNIOStreamInfo(xNURLConnectionIOStream, xNIOMethod);
            this.sim.setURLStreamInfo(xNContext, xOMVariant, xNIOStreamInfo);
            xNIOStreamInfo.open(xNContext, string);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Can't open that URL");
        }
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, int n) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, n);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, int n, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, n, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, l);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, l, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, int n) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, l, n);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, int n, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        return xNIOStreamInfo.read(xNContext, l, n, xOMVariant2);
    }

    public void write(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Write", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow write to URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        xNIOStreamInfo.write(xNContext, xOMVariant2);
    }

    public void write(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2, long l) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Write", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow write to URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        xNIOStreamInfo.write(xNContext, xOMVariant2, l);
    }

    public void truncate(XNContext xNContext, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Truncate", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow truncate URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        xNIOStreamInfo.truncate(xNContext);
    }

    public void truncate(XNContext xNContext, XOMVariant xOMVariant, long l) {
        if (!xNContext.allow(XNSecurityKey.INTERNET_ACCESS, "Operation", "Truncate", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow truncate URL");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        xNIOStreamInfo.truncate(xNContext, l);
    }

    public void close(XNContext xNContext, XOMVariant xOMVariant) {
        XNIOStreamInfo xNIOStreamInfo = this.sim.getURLStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("URL not open");
        }
        xNIOStreamInfo.close(xNContext);
        this.sim.removeStreamInfo(xNIOStreamInfo);
    }
}

