/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HalfFloat
extends Number
implements Comparable<HalfFloat> {
    private static final long serialVersionUID = 1L;
    private float f;
    public static final HalfFloat MAX_VALUE = HalfFloat.intBitsToHalfFloat(31743);
    public static final HalfFloat MIN_VALUE = HalfFloat.intBitsToHalfFloat(64511);
    public static final HalfFloat NaN = HalfFloat.intBitsToHalfFloat(Short.MAX_VALUE);
    public static final HalfFloat NEGATIVE_INFINITY = HalfFloat.intBitsToHalfFloat(64512);
    public static final HalfFloat POSITIVE_INFINITY = HalfFloat.intBitsToHalfFloat(31744);
    public static final int SIZE = 16;
    public static final Class<HalfFloat> TYPE = HalfFloat.class;
    private static final int emax = 31;
    private static final int bias = 15;
    private static final int mantMask = 1023;
    private static final int mantMsbMask = 512;
    private static final int expMask = 31744;
    private static final int signMask = 32768;

    public HalfFloat(float f) {
        this.f = f;
    }

    public HalfFloat(double d) {
        this.f = (float)d;
    }

    public HalfFloat(String string) {
        this.f = new Float(string).floatValue();
    }

    public static HalfFloat intBitsToHalfFloat(int n) {
        int n2 = (n & 0x8000) >>> 15;
        int n3 = (n & 0x7C00) >>> 10;
        int n4 = n & 0x3FF;
        int n5 = n2 << 31;
        if (n3 == 0) {
            if (n4 != 0) {
                int n6 = 113;
                int n7 = n4 << 13;
                while ((n7 & 0x800000) == 0) {
                    n7 <<= 1;
                    --n6;
                }
                n5 |= (n6 & 0xFF) << 23;
                n5 |= n7 & 0x7FFFFF;
            }
        } else if (n3 == 31) {
            n5 |= 0x7F800000;
            n5 |= (n4 & 0x200) << 13;
            n5 |= n4 & 0x1FF;
        } else {
            int n8 = n3 - 15 + 127;
            int n9 = n4 << 13;
            n5 |= (n8 & 0xFF) << 23;
            n5 |= n9 & 0x7FFFFF;
        }
        return new HalfFloat(Float.intBitsToFloat(n5));
    }

    public static int halfFloatToIntBits(HalfFloat halfFloat) {
        int n = Float.floatToIntBits(halfFloat.f);
        return HalfFloat.halfFloatToXIntBits(n);
    }

    public static int halfFloatToRawIntBits(HalfFloat halfFloat) {
        int n = Float.floatToRawIntBits(halfFloat.f);
        return HalfFloat.halfFloatToXIntBits(n);
    }

    private static int halfFloatToXIntBits(int n) {
        int n2 = (n & Integer.MIN_VALUE) >>> 31;
        int n3 = (n & 0x7F800000) >>> 23;
        int n4 = n & 0x7FFFFF;
        int n5 = n2 << 15;
        if (n3 != 0) {
            if (n3 == 255) {
                n5 |= 0x7C00;
                n5 |= (n4 & 0x400000) >>> 13;
                n5 |= n4 & 0x1FF;
            } else {
                int n6 = n3 - 127 + 15;
                int n7 = n4 >>> 13;
                if (n6 >= 31) {
                    n5 |= 0x7C00;
                } else if (n6 <= 0) {
                    n7 |= 0x400;
                    n5 |= (n7 >>>= 1 - n6) & 0x3FF;
                } else {
                    n5 |= n6 << 10 & 0x7C00;
                    n5 |= n7 & 0x3FF;
                }
            }
        }
        return n5;
    }

    @Override
    public byte byteValue() {
        return (byte)this.f;
    }

    public static int compare(HalfFloat halfFloat, HalfFloat halfFloat2) {
        return Float.compare(halfFloat.f, halfFloat2.f);
    }

    @Override
    public int compareTo(HalfFloat halfFloat) {
        return Float.compare(this.f, halfFloat.f);
    }

    @Override
    public double doubleValue() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (object instanceof HalfFloat) {
            return this.f == ((HalfFloat)object).f;
        }
        if (object instanceof Number) {
            return this.f == ((Number)object).floatValue();
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this.f;
    }

    public int hashCode() {
        return Float.valueOf(this.f).hashCode();
    }

    @Override
    public int intValue() {
        return (int)this.f;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.f);
    }

    public static boolean isInfinite(HalfFloat halfFloat) {
        return Float.isInfinite(halfFloat.f);
    }

    public boolean isNaN() {
        return Float.isNaN(this.f);
    }

    public static boolean isNaN(HalfFloat halfFloat) {
        return Float.isNaN(halfFloat.f);
    }

    @Override
    public long longValue() {
        return (long)this.f;
    }

    public HalfFloat parseHalfFloat(String string) {
        return new HalfFloat(Float.parseFloat(string));
    }

    @Override
    public short shortValue() {
        return (short)this.f;
    }

    public static String toHexString(HalfFloat halfFloat) {
        return Float.toHexString(halfFloat.f);
    }

    public String toString() {
        return Float.toString(this.f);
    }

    public static String toString(HalfFloat halfFloat) {
        return Float.toString(halfFloat.f);
    }

    public static HalfFloat valueOf(HalfFloat halfFloat) {
        return halfFloat;
    }

    public static HalfFloat valueOf(String string) {
        return new HalfFloat(string);
    }
}

