/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;

public class XNNumberFormat {
    private static final long serialVersionUID = 1L;
    private String pattern;
    private DecimalFormat nonExpFormat;
    private DecimalFormat expFormat;
    private boolean expFormatUsesQuote;
    private boolean expLimitSet;
    private int minExp;
    private int maxExp;
    private BigDecimal bdmin;
    private BigDecimal bdmax;
    private BigInteger bimin;
    private BigInteger bimax;
    private double dmin;
    private double dmax;

    public XNNumberFormat(String string) {
        if (string == null || string.trim().length() == 0) {
            this.pattern = "0.######";
            this.nonExpFormat = new DecimalFormat("0.######");
            this.expFormat = new DecimalFormat("0.######");
            this.expFormatUsesQuote = false;
            this.expLimitSet = false;
            this.minExp = 0;
            this.maxExp = 0;
        } else {
            this.pattern = string.trim();
            this.expFormatUsesQuote = false;
            this.expLimitSet = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer4 = new StringBuffer();
            int n = 0;
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                block2 : switch (n) {
                    case 0: {
                        switch (c) {
                            case '#': 
                            case '%': 
                            case '.': 
                            case '0': 
                            case '\u00a4': 
                            case '\u2030': {
                                stringBuffer.append(c);
                                stringBuffer2.append(c);
                                break;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                stringBuffer.append('0');
                                stringBuffer2.append('0');
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                stringBuffer2.append('E');
                                this.expFormatUsesQuote = false;
                                n = 1;
                                break;
                            }
                            case '\'': {
                                stringBuffer2.append('E');
                                this.expFormatUsesQuote = true;
                                n = 1;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                stringBuffer2.append('0');
                                break;
                            }
                            case '<': {
                                n = 2;
                                break;
                            }
                            case '>': {
                                n = 3;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.expLimitSet = true;
                                stringBuffer3.append(c);
                                break;
                            }
                            case '<': {
                                n = 2;
                                break;
                            }
                            case '>': {
                                n = 3;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (c) {
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.expLimitSet = true;
                                stringBuffer4.append(c);
                                break block2;
                            }
                            case '<': {
                                n = 2;
                                break block2;
                            }
                            case '>': {
                                n = 3;
                            }
                        }
                    }
                }
                c = stringCharacterIterator.next();
            }
            this.nonExpFormat = new DecimalFormat(stringBuffer.toString());
            this.expFormat = new DecimalFormat(stringBuffer2.toString());
            try {
                this.minExp = Integer.parseInt(stringBuffer3.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.minExp = 0;
            }
            try {
                this.maxExp = Integer.parseInt(stringBuffer4.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.maxExp = 0;
            }
        }
        this.bdmin = BigDecimal.valueOf(1L, -(this.minExp + 1));
        this.bdmax = BigDecimal.valueOf(1L, -this.maxExp);
        this.bimin = this.minExp + 1 < 0 ? BigInteger.ZERO : BigInteger.TEN.pow(this.minExp + 1);
        this.bimax = this.maxExp < 0 ? BigInteger.ZERO : BigInteger.TEN.pow(this.maxExp);
        this.dmin = Math.pow(10.0, this.minExp + 1);
        this.dmax = Math.pow(10.0, this.maxExp);
    }

    public String pattern() {
        return this.pattern;
    }

    public String format(Number number) {
        if (number == null) {
            return "NAN";
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            String string = this.expLimitSet ? (bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? this.nonExpFormat.format(bigDecimal) : (bigDecimal.compareTo(this.bdmin.negate()) > 0 && bigDecimal.compareTo(this.bdmin) < 0 ? this.expFormat.format(bigDecimal) : (bigDecimal.compareTo(this.bdmax.negate()) <= 0 || bigDecimal.compareTo(this.bdmax) >= 0 ? this.expFormat.format(bigDecimal) : this.nonExpFormat.format(bigDecimal)))) : this.expFormat.format(bigDecimal);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            String string = this.expLimitSet ? (bigInteger.compareTo(BigInteger.ZERO) == 0 ? this.nonExpFormat.format(bigInteger) : (bigInteger.compareTo(this.bimin.negate()) > 0 && bigInteger.compareTo(this.bimin) < 0 ? this.expFormat.format(bigInteger) : (bigInteger.compareTo(this.bimax.negate()) <= 0 || bigInteger.compareTo(this.bimax) >= 0 ? this.expFormat.format(bigInteger) : this.nonExpFormat.format(bigInteger)))) : this.expFormat.format(bigInteger);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        if (number instanceof Double) {
            double d = (Double)number;
            if (Double.isNaN(d)) {
                return "NAN";
            }
            if (Double.isInfinite(d)) {
                return d < 0.0 ? "-INF" : "INF";
            }
            String string = this.expLimitSet ? (d == 0.0 ? this.nonExpFormat.format(d) : (d > -this.dmin && d < this.dmin ? this.expFormat.format(d) : (d <= -this.dmax || d >= this.dmax ? this.expFormat.format(d) : this.nonExpFormat.format(d)))) : this.expFormat.format(d);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        if (number instanceof Float) {
            float f = ((Float)number).floatValue();
            if (Float.isNaN(f)) {
                return "NAN";
            }
            if (Float.isInfinite(f)) {
                return f < 0.0f ? "-INF" : "INF";
            }
            String string = this.expLimitSet ? (f == 0.0f ? this.nonExpFormat.format(f) : ((double)f > -this.dmin && (double)f < this.dmin ? this.expFormat.format(f) : ((double)f <= -this.dmax || (double)f >= this.dmax ? this.expFormat.format(f) : this.nonExpFormat.format(f)))) : this.expFormat.format(f);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        if (number instanceof Long) {
            long l = (Long)number;
            String string = this.expLimitSet ? (l == 0L ? this.nonExpFormat.format(l) : ((double)l > -this.dmin && (double)l < this.dmin ? this.expFormat.format(l) : ((double)l <= -this.dmax || (double)l >= this.dmax ? this.expFormat.format(l) : this.nonExpFormat.format(l)))) : this.expFormat.format(l);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        if (number instanceof Integer) {
            int n = (Integer)number;
            String string = this.expLimitSet ? (n == 0 ? this.nonExpFormat.format(n) : ((double)n > -this.dmin && (double)n < this.dmin ? this.expFormat.format(n) : ((double)n <= -this.dmax || (double)n >= this.dmax ? this.expFormat.format(n) : this.nonExpFormat.format(n)))) : this.expFormat.format(n);
            if (this.expFormatUsesQuote) {
                string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
            }
            return string.replace(",", ".");
        }
        double d = number.doubleValue();
        if (Double.isNaN(d)) {
            return "NAN";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-INF" : "INF";
        }
        String string = this.expLimitSet ? (d == 0.0 ? this.nonExpFormat.format(d) : (d > -this.dmin && d < this.dmin ? this.expFormat.format(d) : (d <= -this.dmax || d >= this.dmax ? this.expFormat.format(d) : this.nonExpFormat.format(d)))) : this.expFormat.format(d);
        if (this.expFormatUsesQuote) {
            string = string.replace("E-", "''").replace("E+", "'").replace("E", "'");
        }
        return string.replace(",", ".");
    }

    public BigDecimal parseBigDecimal(String string) {
        string = string.trim().replace("''", "E-").replace("'", "E+");
        return new BigDecimal(string);
    }

    public BigInteger parseBigInteger(String string) {
        string = string.trim().replace("''", "E-").replace("'", "E+");
        return new BigDecimal(string).toBigIntegerExact();
    }

    public double parseDouble(String string) {
        if ((string = string.trim()).equalsIgnoreCase("nan")) {
            return Double.NaN;
        }
        if (string.equalsIgnoreCase("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        return new BigDecimal(string).doubleValue();
    }

    public double parseFloat(String string) {
        if ((string = string.trim()).equalsIgnoreCase("nan")) {
            return Double.NaN;
        }
        if (string.equalsIgnoreCase("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        return new BigDecimal(string).floatValue();
    }
}

