/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMDataType;
import com.kreative.openxion.xom.XOMVariable;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMStringType;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMVariableMap {
    private Map<CIString, XOMDataType<? extends XOMVariant>> types = new LinkedHashMap<CIString, XOMDataType<? extends XOMVariant>>();
    private Map<CIString, XOMVariant> values = new LinkedHashMap<CIString, XOMVariant>();

    public XOMVariable declareVariable(XNContext xNContext, String string) {
        CIString cIString = new CIString(string);
        this.types.put(cIString, XOMStringType.instance);
        this.values.put(cIString, XOMString.EMPTY_STRING);
        return new XOMVariable(this, string);
    }

    public XOMVariable declareVariable(XNContext xNContext, String string, XOMDataType<? extends XOMVariant> xOMDataType) {
        CIString cIString = new CIString(string);
        this.types.put(cIString, xOMDataType);
        this.values.put(cIString, xOMDataType.makeInstanceFrom(xNContext, XOMEmpty.EMPTY));
        return new XOMVariable(this, string);
    }

    public XOMVariable declareVariable(XNContext xNContext, String string, XOMVariant xOMVariant) {
        CIString cIString = new CIString(string);
        this.types.put(cIString, XOMStringType.instance);
        this.values.put(cIString, new XOMString(xOMVariant.toTextString(xNContext)));
        return new XOMVariable(this, string);
    }

    public XOMVariable declareVariable(XNContext xNContext, String string, XOMDataType<? extends XOMVariant> xOMDataType, XOMVariant xOMVariant) {
        CIString cIString = new CIString(string);
        this.types.put(cIString, xOMDataType);
        this.values.put(cIString, xOMDataType.makeInstanceFrom(xNContext, xOMVariant));
        return new XOMVariable(this, string);
    }

    public boolean isVariableDeclared(XNContext xNContext, String string) {
        CIString cIString = new CIString(string);
        return this.types.containsKey(cIString) || this.values.containsKey(cIString);
    }

    public XOMVariant getVariable(XNContext xNContext, String string) {
        CIString cIString = new CIString(string);
        return this.values.containsKey(cIString) ? this.values.get(cIString) : null;
    }

    public void setVariable(XNContext xNContext, String string, XOMVariant xOMVariant) {
        CIString cIString = new CIString(string);
        if (!this.types.containsKey(cIString)) {
            this.types.put(cIString, XOMStringType.instance);
        }
        this.values.put(cIString, this.types.get(cIString).makeInstanceFrom(xNContext, xOMVariant.asPrimitive(xNContext)));
    }

    public void prependVariable(XNContext xNContext, String string, XOMVariant xOMVariant) {
        CIString cIString = new CIString(string);
        if (!this.types.containsKey(cIString)) {
            this.types.put(cIString, XOMStringType.instance);
        }
        if (!this.values.containsKey(cIString)) {
            this.values.put(cIString, XOMEmpty.EMPTY);
        }
        this.values.put(cIString, this.types.get(cIString).makeInstanceFrom(xNContext, xOMVariant.asPrimitive(xNContext), this.values.get(cIString)));
    }

    public void appendVariable(XNContext xNContext, String string, XOMVariant xOMVariant) {
        CIString cIString = new CIString(string);
        if (!this.types.containsKey(cIString)) {
            this.types.put(cIString, XOMStringType.instance);
        }
        if (!this.values.containsKey(cIString)) {
            this.values.put(cIString, XOMEmpty.EMPTY);
        }
        this.values.put(cIString, this.types.get(cIString).makeInstanceFrom(xNContext, this.values.get(cIString), xOMVariant.asPrimitive(xNContext)));
    }

    public void merge(XOMVariableMap xOMVariableMap) {
        this.types.putAll(xOMVariableMap.types);
        this.values.putAll(xOMVariableMap.values);
    }

    private static final class CIString {
        private String s;

        public CIString(String string) {
            this.s = string;
        }

        public String toString() {
            return this.s;
        }

        public int hashCode() {
            return this.s.toLowerCase().hashCode();
        }

        public boolean equals(Object object) {
            return this.s.equalsIgnoreCase(object.toString());
        }
    }
}

