/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.util.XNDateFormat;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMDate
extends XOMValue {
    private static final long serialVersionUID = 1L;
    private XNDateFormat theFormat;
    private GregorianCalendar theDate;

    public XOMDate() {
        this.theFormat = XNDateFormat.SHORT_DATE;
        this.theDate = new GregorianCalendar();
    }

    public XOMDate(XNDateFormat xNDateFormat) {
        this.theFormat = xNDateFormat;
        this.theDate = new GregorianCalendar();
    }

    public XOMDate(GregorianCalendar gregorianCalendar) {
        this.theFormat = XNDateFormat.SHORT_DATE;
        this.theDate = gregorianCalendar;
    }

    public XOMDate(Date date) {
        this.theFormat = XNDateFormat.SHORT_DATE;
        this.theDate = new GregorianCalendar();
        this.theDate.setTime(date);
    }

    public XOMDate(XNDateFormat xNDateFormat, GregorianCalendar gregorianCalendar) {
        this.theFormat = xNDateFormat;
        this.theDate = gregorianCalendar;
    }

    public XOMDate(XNDateFormat xNDateFormat, Date date) {
        this.theFormat = xNDateFormat;
        this.theDate = new GregorianCalendar();
        this.theDate.setTime(date);
    }

    public XOMDate(String string) {
        this.theDate = new GregorianCalendar();
        Date date = null;
        ParsePosition parsePosition = new ParsePosition(0);
        List<XNDateFormat> list = XNDateFormat.allForName("datetime");
        for (XNDateFormat xNDateFormat : list) {
            date = xNDateFormat.toJavaDateFormat().parse(string, parsePosition);
            if (date == null || string.substring(parsePosition.getIndex()).trim().length() != 0) continue;
            this.theDate.setTime(date);
            this.theFormat = xNDateFormat;
            return;
        }
        throw new XOMMorphError("date");
    }

    public XOMDate dateEquivalent() {
        return new XOMDate(this.theFormat.dateEquivalent(), this.theDate);
    }

    public XOMDate timeEquivalent() {
        return new XOMDate(this.theFormat.timeEquivalent(), this.theDate);
    }

    public GregorianCalendar toCalendar() {
        return this.theDate;
    }

    public Date toDate() {
        return this.theDate.getTime();
    }

    @Override
    public String toLanguageString() {
        if (this.theFormat == null || this.theDate == null) {
            return "\"\"";
        }
        return XIONUtil.quote(this.theFormat.toJavaDateFormat().format(this.theDate.getTime()));
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.theFormat == null || this.theDate == null) {
            return "";
        }
        return this.theFormat.toJavaDateFormat().format(this.theDate.getTime());
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.theFormat.hashCode() ^ this.theDate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMDate) {
            XOMDate xOMDate = (XOMDate)object;
            return this.theFormat == xOMDate.theFormat && this.theDate.equals(xOMDate.theDate);
        }
        return false;
    }
}

