/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMComparator;
import com.kreative.openxion.xom.XOMContainer;
import com.kreative.openxion.xom.XOMListContainer;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMListChunk
extends XOMContainer
implements XOMListContainer {
    private static final long serialVersionUID = 1L;
    private XOMVariant parent;
    private int startIndex;
    private int endIndex;
    private boolean singular;

    public XOMListChunk(XOMVariant xOMVariant, int n) {
        this.parent = xOMVariant;
        this.startIndex = n;
        this.endIndex = n;
        this.singular = true;
    }

    public XOMListChunk(XOMVariant xOMVariant, int n, int n2) {
        this.parent = xOMVariant;
        this.startIndex = n;
        this.endIndex = n2;
        this.singular = false;
    }

    public boolean hasParent() {
        return true;
    }

    public XOMVariant getParent() {
        return this.parent;
    }

    private ListChunkInfo getChunkInfo(XNContext xNContext, boolean bl, boolean bl2) {
        ArrayList<? extends XOMVariant> arrayList;
        int n;
        Object object;
        List<? extends XOMVariant> list;
        if (bl || bl2) {
            this.parent = this.parent.asContainer(xNContext, false);
            list = this.parent.getContents(xNContext).toPrimitiveList(xNContext);
        } else {
            list = this.parent.canGetContents(xNContext) ? this.parent.getContents(xNContext).toPrimitiveList(xNContext) : this.parent.toPrimitiveList(xNContext);
        }
        int[] nArray = XIONUtil.index(1, list.size(), this.startIndex, this.endIndex);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (bl && n2 > list.size() || bl2 && n3 > list.size()) {
            object = new Vector();
            n = (bl && bl2 ? Math.max(n2, n3) : (bl ? n2 - 1 : (bl2 ? n3 : list.size()))) - list.size();
            while (n-- > 0) {
                object.add(XOMEmpty.EMPTY);
            }
            arrayList = new ArrayList<XOMVariant>();
            arrayList.addAll(list);
            arrayList.addAll((Collection<? extends XOMVariant>)object);
            this.parent.putAfterContents(xNContext, new XOMList((Collection<? extends XOMVariant>)object));
            list = arrayList;
        }
        if (bl && n2 < 1 || bl2 && n3 < 1) {
            object = new Vector();
            n = 1 - (bl && bl2 ? Math.min(n2, n3) : (bl ? n2 : (bl2 ? n3 + 1 : 1)));
            while (n-- > 0) {
                object.add(XOMEmpty.EMPTY);
                ++n2;
                ++n3;
            }
            arrayList = new ArrayList();
            arrayList.addAll((Collection<? extends XOMVariant>)object);
            arrayList.addAll(list);
            this.parent.putBeforeContents(xNContext, new XOMList((Collection<? extends XOMVariant>)object));
            list = arrayList;
        }
        object = new ListChunkInfo();
        ((ListChunkInfo)object).parentContent = list;
        ((ListChunkInfo)object).chunkCount = list.size();
        ((ListChunkInfo)object).startChunkIndex = n2;
        ((ListChunkInfo)object).endChunkIndex = n3;
        ((ListChunkInfo)object).startElementIndex = n2 - 1;
        ((ListChunkInfo)object).endElementIndex = n3;
        if (((ListChunkInfo)object).startElementIndex < 0) {
            ((ListChunkInfo)object).startElementIndex = 0;
        } else if (((ListChunkInfo)object).startElementIndex > list.size()) {
            ((ListChunkInfo)object).startElementIndex = list.size();
        }
        if (((ListChunkInfo)object).endElementIndex < 0) {
            ((ListChunkInfo)object).endElementIndex = 0;
        } else if (((ListChunkInfo)object).endElementIndex > list.size()) {
            ((ListChunkInfo)object).endElementIndex = list.size();
        }
        if (((ListChunkInfo)object).startElementIndex > ((ListChunkInfo)object).endElementIndex) {
            ((ListChunkInfo)object).endElementIndex = ((ListChunkInfo)object).startElementIndex;
        }
        return object;
    }

    @Override
    public boolean canDelete(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canDeleteList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void delete(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canDeleteList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            xOMListContainer.deleteList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canDeleteList(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canDeleteList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void deleteList(XNContext xNContext, int n, int n2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canDeleteList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.deleteList(xNContext, n3, n4);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n6 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n6, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canGetContents(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getContents(XNContext xNContext) {
        if (this.singular) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            if (listChunkInfo.startElementIndex >= 0 && listChunkInfo.startElementIndex < listChunkInfo.parentContent.size() && listChunkInfo.endElementIndex > 0 && listChunkInfo.endElementIndex <= listChunkInfo.parentContent.size()) {
                return listChunkInfo.parentContent.get(listChunkInfo.startElementIndex);
            }
            return XOMEmpty.EMPTY;
        }
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canGetList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            return xOMListContainer.getList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex);
        }
        ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
        return new XOMList(listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.endElementIndex));
    }

    @Override
    public boolean canGetList(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getList(XNContext xNContext, int n, int n2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canGetList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            return xOMListContainer.getList(xNContext, n3, n4);
        }
        ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
        int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
        int n6 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
        return new XOMList(listChunkInfo.parentContent.subList(n5, n6));
    }

    @Override
    public boolean canPutContents(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            xOMListContainer.putIntoList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putIntoContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            xOMListContainer.putBeforeList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            xOMListContainer.putAfterList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.endElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putAfterContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            xOMListContainer.putIntoList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putIntoContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            xOMListContainer.putBeforeList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            xOMListContainer.putAfterList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.endElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putAfterContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public boolean canPutList(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putIntoList(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n6 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n6, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putIntoContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putBeforeList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putBeforeList(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n5, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putAfterList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putAfterList(xNContext, n3, n4, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n5, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.putAfterContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putIntoList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putIntoList(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, true);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n6 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n6, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putIntoContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putBeforeList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putBeforeList(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, true, false);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n5, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putAfterList(XNContext xNContext, int n, int n2, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canPutList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.putAfterList(xNContext, n3, n4, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, true);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n5, listChunkInfo.chunkCount);
            Vector<XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list);
            vector.add(xOMVariant.asPrimitive(xNContext));
            vector.addAll(list2);
            this.parent.putIntoContents(xNContext, new XOMList(vector), string, xOMVariant2);
        } else {
            super.putAfterContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public boolean canSortContents(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSortList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void sortContents(XNContext xNContext, XOMComparator xOMComparator) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSortList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            xOMListContainer.sortList(xNContext, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMComparator);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, listChunkInfo.startElementIndex);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.endElementIndex);
            List<? extends XOMVariant> list3 = listChunkInfo.parentContent.subList(listChunkInfo.endElementIndex, listChunkInfo.chunkCount);
            Vector<? extends XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list2);
            Collections.sort(vector, xOMComparator);
            vector.addAll(0, list);
            vector.addAll(list3);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.sortContents(xNContext, xOMComparator);
        }
    }

    @Override
    public boolean canSortList(XNContext xNContext) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSortList(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void sortList(XNContext xNContext, int n, int n2, XOMComparator xOMComparator) {
        if (this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSortList(xNContext)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.sortList(xNContext, n3, n4, xOMComparator);
        } else if (this.parent.canPutContents(xNContext)) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n5 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n6 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            List<? extends XOMVariant> list = listChunkInfo.parentContent.subList(0, n5);
            List<? extends XOMVariant> list2 = listChunkInfo.parentContent.subList(n5, n6);
            List<? extends XOMVariant> list3 = listChunkInfo.parentContent.subList(n6, listChunkInfo.chunkCount);
            Vector<? extends XOMVariant> vector = new Vector<XOMVariant>();
            vector.addAll(list2);
            Collections.sort(vector, xOMComparator);
            vector.addAll(0, list);
            vector.addAll(list3);
            this.parent.putIntoContents(xNContext, new XOMList(vector));
        } else {
            super.sortContents(xNContext, xOMComparator);
        }
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return string.equalsIgnoreCase("number") || this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canGetListProperty(xNContext, string);
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (string.equalsIgnoreCase("number")) {
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            return new XOMInteger(listChunkInfo.endChunkIndex - listChunkInfo.startChunkIndex + 1);
        }
        if (this.canGetProperty(xNContext, string)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            return xOMListContainer.getListProperty(xNContext, xNModifier, string, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canGetListProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canGetListProperty(xNContext, string);
    }

    @Override
    public XOMVariant getListProperty(XNContext xNContext, XNModifier xNModifier, String string, int n, int n2) {
        if (this.canGetListProperty(xNContext, string)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            return xOMListContainer.getListProperty(xNContext, xNModifier, string, n3, n4);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canSetProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSetListProperty(xNContext, string);
    }

    @Override
    public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        if (this.canSetProperty(xNContext, string)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            xOMListContainer.setListProperty(xNContext, string, listChunkInfo.startElementIndex, listChunkInfo.endElementIndex, xOMVariant);
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public boolean canSetListProperty(XNContext xNContext, String string) {
        return this.parent instanceof XOMListContainer && ((XOMListContainer)((Object)this.parent)).canSetListProperty(xNContext, string);
    }

    @Override
    public void setListProperty(XNContext xNContext, String string, int n, int n2, XOMVariant xOMVariant) {
        if (this.canSetProperty(xNContext, string)) {
            XOMListContainer xOMListContainer = (XOMListContainer)((Object)this.parent);
            ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
            int n3 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n));
            int n4 = Math.max(listChunkInfo.startElementIndex, Math.min(listChunkInfo.endElementIndex, listChunkInfo.startElementIndex + n2));
            xOMListContainer.setListProperty(xNContext, string, n3, n4, xOMVariant);
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public String toLanguageString() {
        if (this.startIndex == this.endIndex) {
            return "element " + this.startIndex + " of " + this.parent.toLanguageString();
        }
        return "elements " + this.startIndex + " through " + this.endIndex + " of " + this.parent.toLanguageString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return this.getContents(xNContext).toTextString(xNContext);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
        return Collections.unmodifiableList(listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.endElementIndex));
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        ListChunkInfo listChunkInfo = this.getChunkInfo(xNContext, false, false);
        ArrayList<XOMVariant> arrayList = new ArrayList<XOMVariant>();
        for (XOMVariant xOMVariant : listChunkInfo.parentContent.subList(listChunkInfo.startElementIndex, listChunkInfo.endElementIndex)) {
            arrayList.add(xOMVariant.asPrimitive(xNContext));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode() ^ this.startIndex ^ this.endIndex;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMListChunk) {
            XOMListChunk xOMListChunk = (XOMListChunk)object;
            return this.parent.equals(xOMListChunk.parent) && this.startIndex == xOMListChunk.startIndex && this.endIndex == xOMListChunk.endIndex;
        }
        return false;
    }

    private static class ListChunkInfo {
        public List<? extends XOMVariant> parentContent;
        public int chunkCount;
        public int startChunkIndex;
        public int endChunkIndex;
        public int startElementIndex;
        public int endElementIndex;

        private ListChunkInfo() {
        }
    }
}

