/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMPoint;
import java.awt.Rectangle;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMRectangle
extends XOMValue {
    private static final long serialVersionUID = 1L;
    private BigInteger left;
    private BigInteger top;
    private BigInteger right;
    private BigInteger bottom;

    public XOMRectangle(int n, int n2, int n3, int n4) {
        this.left = BigInteger.valueOf(n);
        this.top = BigInteger.valueOf(n2);
        this.right = BigInteger.valueOf(n3);
        this.bottom = BigInteger.valueOf(n4);
    }

    public XOMRectangle(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.left = bigInteger;
        this.top = bigInteger2;
        this.right = bigInteger3;
        this.bottom = bigInteger4;
    }

    public XOMRectangle(Rectangle rectangle) {
        this.left = BigInteger.valueOf(rectangle.x);
        this.top = BigInteger.valueOf(rectangle.y);
        this.right = BigInteger.valueOf(rectangle.x + rectangle.width);
        this.bottom = BigInteger.valueOf(rectangle.y + rectangle.height);
    }

    public BigInteger left() {
        return this.left;
    }

    public BigInteger top() {
        return this.top;
    }

    public BigInteger right() {
        return this.right;
    }

    public BigInteger bottom() {
        return this.bottom;
    }

    public XOMPoint topLeft() {
        return new XOMPoint(this.left, this.top);
    }

    public XOMPoint topRight() {
        return new XOMPoint(this.right, this.top);
    }

    public XOMPoint bottomLeft() {
        return new XOMPoint(this.left, this.bottom);
    }

    public XOMPoint bottomRight() {
        return new XOMPoint(this.right, this.bottom);
    }

    public XOMPoint center() {
        return new XOMPoint(this.left.add(this.right).shiftLeft(1), this.top.add(this.bottom).shiftLeft(1));
    }

    public BigInteger width() {
        return this.right.subtract(this.left);
    }

    public BigInteger height() {
        return this.bottom.subtract(this.top);
    }

    public boolean contains(XOMPoint xOMPoint) {
        return xOMPoint.x().compareTo(this.left) >= 0 && xOMPoint.x().compareTo(this.right) < 0 && xOMPoint.y().compareTo(this.top) >= 0 && xOMPoint.y().compareTo(this.bottom) < 0;
    }

    public boolean contains(XOMRectangle xOMRectangle) {
        return xOMRectangle.left.compareTo(this.right) < 0 && xOMRectangle.right.compareTo(this.left) >= 0 && xOMRectangle.top.compareTo(this.bottom) < 0 && xOMRectangle.bottom.compareTo(this.top) >= 0;
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return string.equalsIgnoreCase("top") || string.equalsIgnoreCase("left") || string.equalsIgnoreCase("right") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("topLeft") || string.equalsIgnoreCase("topRight") || string.equalsIgnoreCase("botLeft") || string.equalsIgnoreCase("bottomLeft") || string.equalsIgnoreCase("botRight") || string.equalsIgnoreCase("bottomRight") || string.equalsIgnoreCase("loc") || string.equalsIgnoreCase("location") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("width") || string.equalsIgnoreCase("height");
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (string.equalsIgnoreCase("top")) {
            return new XOMInteger(this.top);
        }
        if (string.equalsIgnoreCase("left")) {
            return new XOMInteger(this.left);
        }
        if (string.equalsIgnoreCase("right")) {
            return new XOMInteger(this.right);
        }
        if (string.equalsIgnoreCase("bottom")) {
            return new XOMInteger(this.bottom);
        }
        if (string.equalsIgnoreCase("topLeft")) {
            return new XOMPoint(this.left, this.top);
        }
        if (string.equalsIgnoreCase("topRight")) {
            return new XOMPoint(this.right, this.top);
        }
        if (string.equalsIgnoreCase("botLeft") || string.equalsIgnoreCase("bottomLeft")) {
            return new XOMPoint(this.left, this.bottom);
        }
        if (string.equalsIgnoreCase("botRight") || string.equalsIgnoreCase("bottomRight")) {
            return new XOMPoint(this.right, this.bottom);
        }
        if (string.equalsIgnoreCase("loc") || string.equalsIgnoreCase("location") || string.equalsIgnoreCase("center")) {
            return new XOMPoint(this.left.add(this.right).shiftLeft(1), this.top.add(this.bottom).shiftLeft(1));
        }
        if (string.equalsIgnoreCase("width")) {
            return new XOMInteger(this.right.subtract(this.left));
        }
        if (string.equalsIgnoreCase("height")) {
            return new XOMInteger(this.bottom.subtract(this.top));
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.left.intValue(), this.top.intValue(), this.right.subtract(this.left).intValue(), this.bottom.subtract(this.top).intValue());
    }

    @Override
    public String toLanguageString() {
        return "\"" + (this.left == null ? "0" : this.left.toString()) + "," + (this.top == null ? "0" : this.top.toString()) + "," + (this.right == null ? "0" : this.right.toString()) + "," + (this.bottom == null ? "0" : this.bottom.toString()) + "\"";
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return (this.left == null ? "0" : this.left.toString()) + "," + (this.top == null ? "0" : this.top.toString()) + "," + (this.right == null ? "0" : this.right.toString()) + "," + (this.bottom == null ? "0" : this.bottom.toString());
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.left.hashCode() ^ this.top.hashCode() ^ this.right.hashCode() ^ this.bottom.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMRectangle) {
            XOMRectangle xOMRectangle = (XOMRectangle)object;
            return this.left.compareTo(xOMRectangle.left) == 0 && this.top.compareTo(xOMRectangle.top) == 0 && this.right.compareTo(xOMRectangle.right) == 0 && this.bottom.compareTo(xOMRectangle.bottom) == 0;
        }
        return false;
    }
}

