/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.type;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMPrimitiveDataType;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.type.XOMListType;
import java.text.StringCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMBinaryType
extends XOMPrimitiveDataType<XOMBinary> {
    private static final long serialVersionUID = 1L;
    public static final XOMBinaryType instance = new XOMBinaryType();
    public static final XOMListType listInstance = new XOMListType("binaries", 0, instance);

    private XOMBinaryType() {
        super("binary", 0, XOMBinary.class);
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext) {
        return true;
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant) {
        return false;
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, String string) {
        if (string.length() % 2 != 0) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    @Override
    protected XOMBinary makeInstanceFromImpl(XNContext xNContext) {
        return XOMBinary.EMPTY_BINARY;
    }

    @Override
    protected XOMBinary makeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant) {
        throw new XOMMorphError(this.typeName);
    }

    @Override
    protected XOMBinary makeInstanceFromImpl(XNContext xNContext, String string) {
        if (string.length() % 2 != 0) {
            throw new XOMMorphError(this.typeName);
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        boolean bl = true;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c >= '0' && c <= '9') {
                if (bl) {
                    byArray[n] = (byte)(c - 48 << 4 & 0xF0);
                    bl = false;
                } else {
                    int n2 = n++;
                    byArray[n2] = (byte)(byArray[n2] | (byte)(c - 48 & 0xF));
                    bl = true;
                }
            } else if (c >= 'A' && c <= 'F') {
                if (bl) {
                    byArray[n] = (byte)(c - 65 + 10 << 4 & 0xF0);
                    bl = false;
                } else {
                    int n3 = n++;
                    byArray[n3] = (byte)(byArray[n3] | (byte)(c - 65 + 10 & 0xF));
                    bl = true;
                }
            } else if (c >= 'a' && c <= 'f') {
                if (bl) {
                    byArray[n] = (byte)(c - 97 + 10 << 4 & 0xF0);
                    bl = false;
                } else {
                    int n4 = n++;
                    byArray[n4] = (byte)(byArray[n4] | (byte)(c - 97 + 10 & 0xF));
                    bl = true;
                }
            } else {
                throw new XOMMorphError(this.typeName);
            }
            c = stringCharacterIterator.next();
        }
        return new XOMBinary(byArray);
    }
}

