/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.type;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMGetError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMFile;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.type.XOMFSDataType;
import com.kreative.openxion.xom.type.XOMListType;
import java.io.File;
import java.util.Vector;

public class XOMDiskType
extends XOMFSDataType {
    private static final long serialVersionUID = 1L;
    public static final XOMDiskType instance = new XOMDiskType();
    public static final XOMListType listInstance = new XOMListType("disks", 148, instance);

    private XOMDiskType() {
        super("disk", 74);
    }

    public boolean canGetMassInstance(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisks");
    }

    public XOMVariant getMassInstance(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisks")) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        File[] fileArray = File.listRoots();
        Vector<XOMFile> vector = new Vector<XOMFile>();
        for (File file : fileArray) {
            vector.add(new XOMFile(file));
        }
        return new XOMList(vector);
    }

    public boolean canGetInstanceByIndex(XNContext xNContext, int n) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "Index", Integer.toString(n))) {
            return false;
        }
        File[] fileArray = File.listRoots();
        n = XIONUtil.index(1, fileArray.length, n, n)[0];
        return n >= 1 && n <= fileArray.length;
    }

    public boolean canGetInstanceByIndex(XNContext xNContext, int n, int n2) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "StartIndex", Integer.toString(n), "EndIndex", Integer.toString(n2));
    }

    public boolean canGetInstanceByName(XNContext xNContext, String string) {
        File[] fileArray;
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "Name", string)) {
            return false;
        }
        for (File file : fileArray = File.listRoots()) {
            if (!file.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public XOMVariant getInstanceByIndex(XNContext xNContext, int n) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "Index", Integer.toString(n))) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        File[] fileArray = File.listRoots();
        n = XIONUtil.index(1, fileArray.length, n, n)[0];
        if (n >= 1 && n <= fileArray.length) {
            return new XOMFile(fileArray[n - 1]);
        }
        throw new XOMGetError(this.typeName, n, n);
    }

    public XOMVariant getInstanceByIndex(XNContext xNContext, int n, int n2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "StartIndex", Integer.toString(n), "EndIndex", Integer.toString(n2))) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        File[] fileArray = File.listRoots();
        int[] nArray = XIONUtil.index(1, fileArray.length, n, n2);
        if (nArray[0] < 1) {
            nArray[0] = 1;
        } else if (nArray[0] > fileArray.length) {
            nArray[0] = fileArray.length;
        }
        if (nArray[1] < 1) {
            nArray[1] = 1;
        } else if (nArray[1] > fileArray.length) {
            nArray[1] = fileArray.length;
        }
        Vector<XOMFile> vector = new Vector<XOMFile>();
        for (int i = nArray[0] - 1; i < nArray[1]; ++i) {
            vector.add(new XOMFile(fileArray[i]));
        }
        return new XOMList(vector);
    }

    public XOMVariant getInstanceByName(XNContext xNContext, String string) {
        File[] fileArray;
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetDisk", "Name", string)) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        for (File file : fileArray = File.listRoots()) {
            if (!file.getName().equalsIgnoreCase(string)) continue;
            return new XOMFile(file);
        }
        throw new XOMGetError(this.typeName, string);
    }

    protected boolean accept(XOMFile xOMFile) {
        return xOMFile.isDisk();
    }
}

