/**
 * Mikhmon Light theme for Highcharts JS
 * @author Laksamadi Guko
 */

light = {
	colors: ["#20a8d8", "#f86c6b"],
	chart: {
		backgroundColor: '#FFFFFF',
		borderColor: '#FFFFFF',
		borderWidth: 1,
		className: 'light-cart',
		plotBackgroundColor: '#FFFFFF',
		plotBorderColor: '#c1c1c1',
		plotBorderWidth: 1,
		height: '300px'
	},
	title: {
		style: {
			color: '#3E3E3E',
			font: 'bold 14px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
		}
	},
	subtitle: {
		style: {
			color: '#3E3E3E',
			font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
		}
	},
	xAxis: {
		gridLineColor: '#c1c1c1',
		gridLineWidth: 1,
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},

		lineColor: '#c1c1c1',
		tickColor: '#c1c1c1',
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'

			}
		}
	},
	yAxis: {
		gridLineColor: '#c1c1c1',
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},
		lineColor: '#c1c1c1',
		minorTickInterval: null,
		tickColor: '#c1c1c1',
		tickWidth: 1,
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
			}
		}
	},
	plotOptions: {
		series: {
			fillOpacity: 0.1
		}
	},
	tooltip: {
		backgroundColor: 'rgba(254, 254, 254, 0.75)',
		style: {
			color: '#3E3E3E'
		}
	},
	legend: {
		itemStyle: {
			font: '9pt Trebuchet MS, Verdana, sans-serif',
			color: '#3E3E3E'
		},
		itemHoverStyle: {
			color: '#20a8d8'
		},
		itemHiddenStyle: {
			color: '#E9EBEE'
		}
	},
	credits: {
		enabled: 0,
	}

};

dark = {
	colors: ["#20a8d8", "#f86c6b"],
	chart: {
		backgroundColor: '#3a4149',
		borderColor: '#3a4149',
		borderWidth: 1,
		className: 'dark-chart',
		plotBackgroundColor: '#3a4149',
		plotBorderColor: '#2f353a',
		plotBorderWidth: 1,
		height: '300px'
	},
	title: {
		style: {
			color: '#f3f4f5',
			font: 'bold 14px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
		}
	},
	subtitle: {
		style: {
			color: '#f3f4f5',
			font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
		}
	},
	xAxis: {
		gridLineColor: '#2f353a',
		gridLineWidth: 1,
		labels: {
			style: {
				color: '#f3f4f5'
			}
		},
		lineColor: '#2f353a',
		tickColor: '#2f353a',
		title: {
			style: {
				color: '#f3f4f5',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'

			}
		}
	},
	yAxis: {
		gridLineColor: '#2f353a',
		labels: {
			style: {
				color: '#f3f4f5'
			}
		},
		lineColor: '#2f353a',
		minorTickInterval: null,
		tickColor: '#2f353a',
		tickWidth: 1,
		title: {
			style: {
				color: '#f3f4f5',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
			}
		}
	},
	plotOptions: {
		series: {
			fillOpacity: 0.1
		}
	},
	tooltip: {
		backgroundColor: 'rgba(58, 65, 73, 0.75)',
		style: {
			color: '#f3f4f5'
		}
	},
	legend: {
		itemStyle: {
			font: '9pt Trebuchet MS, Verdana, sans-serif',
			color: '#f3f4f5'
		},
		itemHoverStyle: {
			color: '#20a8d8'
		},
		itemHiddenStyle: {
			color: '#2F353A'
		}
	},
	credits: {
		enabled: 0,
	}

};


blue = {
	colors: ["#20a8d8", "#f86c6b"],
	chart: {
		backgroundColor: '#FFFFFF',
		borderColor: '#FFFFFF',
		borderWidth: 1,
		className: 'light-cart',
		plotBackgroundColor: '#FFFFFF',
		plotBorderColor: '#008BC9',
		plotBorderWidth: 1,
		height: '300px'
	},
	title: {
		style: {
			color: '#3E3E3E',
			font: 'bold 14px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
		}
	},
	subtitle: {
		style: {
			color: '#3E3E3E',
			font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
		}
	},
	xAxis: {
		gridLineColor: '#008BC9',
		gridLineWidth: 1,
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},

		lineColor: '#008BC9',
		tickColor: '#008BC9',
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'

			}
		}
	},
	yAxis: {
		gridLineColor: '#008BC9',
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},
		lineColor: '#008BC9',
		minorTickInterval: null,
		tickColor: '#008BC9',
		tickWidth: 1,
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
			}
		}
	},
	plotOptions: {
		series: {
			fillOpacity: 0.1
		}
	},
	tooltip: {
		backgroundColor: 'rgba(254, 254, 254, 0.75)',
		style: {
			color: '#3E3E3E'
		}
	},
	legend: {
		itemStyle: {
			font: '9pt Trebuchet MS, Verdana, sans-serif',
			color: '#3E3E3E'
		},
		itemHoverStyle: {
			color: '#20a8d8'
		},
		itemHiddenStyle: {
			color: '#E9EBEE'
		}
	},
	credits: {
		enabled: 0,
	}

};


green = {
	colors: ["#20a8d8", "#f86c6b"],
	chart: {
		backgroundColor: '#FFFFFF',
		borderColor: '#FFFFFF',
		borderWidth: 1,
		className: 'light-cart',
		plotBackgroundColor: '#FFFFFF',
		plotBorderColor: '#4dbd74',
		plotBorderWidth: 1,
		height: '300px'
	},
	title: {
		style: {
			color: '#3E3E3E',
			font: 'bold 14px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
		}
	},
	subtitle: {
		style: {
			color: '#3E3E3E',
			font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
		}
	},
	xAxis: {
		gridLineColor: '#4dbd74',
		gridLineWidth: 1,
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},

		lineColor: '#4dbd74',
		tickColor: '#4dbd74',
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'

			}
		}
	},
	yAxis: {
		gridLineColor: '#4dbd74',
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},
		lineColor: '#4dbd74',
		minorTickInterval: null,
		tickColor: '#4dbd74',
		tickWidth: 1,
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
			}
		}
	},
	plotOptions: {
		series: {
			fillOpacity: 0.1
		}
	},
	tooltip: {
		backgroundColor: 'rgba(254, 254, 254, 0.75)',
		style: {
			color: '#3E3E3E'
		}
	},
	legend: {
		itemStyle: {
			font: '9pt Trebuchet MS, Verdana, sans-serif',
			color: '#3E3E3E'
		},
		itemHoverStyle: {
			color: '#20a8d8'
		},
		itemHiddenStyle: {
			color: '#E9EBEE'
		}
	},
	credits: {
		enabled: 0,
	}

};

pink = {
	colors: ["#20a8d8", "#f86c6b"],
	chart: {
		backgroundColor: 'rgb(255, 230, 241)',
		borderColor: 'rgb(255, 230, 241)',
		borderWidth: 1,
		className: 'light-cart',
		plotBackgroundColor: 'rgb(255, 230, 241)',
		plotBorderColor: '#F670AD',
		plotBorderWidth: 1,
		height: '300px'
	},
	title: {
		style: {
			color: '#3E3E3E',
			font: 'bold 14px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
		}
	},
	subtitle: {
		style: {
			color: '#3E3E3E',
			font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
		}
	},
	xAxis: {
		gridLineColor: '#F670AD',
		gridLineWidth: 1,
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},

		lineColor: '#F670AD',
		tickColor: '#F670AD',
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'

			}
		}
	},
	yAxis: {
		gridLineColor: '#F670AD',
		labels: {
			style: {
				color: '#3E3E3E'
			}
		},
		lineColor: '#F670AD',
		minorTickInterval: null,
		tickColor: '#F670AD',
		tickWidth: 1,
		title: {
			style: {
				color: '#3E3E3E',
				fontWeight: 'bold',
				fontSize: '12px',
				fontFamily: 'bold 16px "Trebuchet MS", Verdana, sans-serif, Roboto,"Seggoe UI"'
			}
		}
	},
	plotOptions: {
		series: {
			fillOpacity: 0.1
		}
	},
	tooltip: {
		backgroundColor: 'rgb(253, 223, 237, 0.75)',
		style: {
			color: '#3E3E3E'
		}
	},
	legend: {
		itemStyle: {
			font: '9pt Trebuchet MS, Verdana, sans-serif',
			color: '#3E3E3E'
		},
		itemHoverStyle: {
			color: '#20a8d8'
		},
		itemHiddenStyle: {
			color: '#E9EBEE'
		}
	},
	credits: {
		enabled: 0,
	}

};
// Apply the theme
// var highchartsOptions = Highcharts.setOptions(dark);

function setHCTheme(theme){
    if(theme == "dark"){
        Highcharts.setOptions(dark);
    }
}

// setHCTheme('dark')