local MAJOR_VERSION = "Spell 1.1"
local MINOR_VERSION = tonumber(string.sub("$Revision: 2327 $", 12, -3))

if BabbleLib and BabbleLib.versions[MAJOR_VERSION] and BabbleLib.versions[MAJOR_VERSION].minor >= MINOR_VERSION then
	return
end

local locale = GetLocale and GetLocale() or "enUS"
if locale ~= "frFR" and locale ~= "deDE" and locale ~= "zhCN" then
	locale = "enUS"
end

local initSpells, spells
-- these spells functions were auto-generated, thus the incredible lack of readibility
if locale == "enUS" then
	function initSpells()
		spells = {
			AMPLIFY_CURSE="Amplify Curse",CORRUPTION="Corruption",CURSE_OF_AGONY="Curse of Agony",CURSE_OF_DOOM="Curse of Doom",CURSE_OF_DOOM_EFFECT="Curse of Doom Effect",CURSE_OF_EXHAUSTION="Curse of Exhaustion",CURSE_OF_IDIOCY="Curse of Idiocy",CURSE_OF_RECKLESSNESS="Curse of Recklessness",CURSE_OF_SHADOW="Curse of Shadow",CURSE_OF_THE_ELEMENTS="Curse of the Elements",CURSE_OF_TONGUES="Curse of Tongues",CURSE_OF_WEAKNESS="Curse of Weakness",DARK_PACT="Dark Pact",DEATH_COIL="Death Coil",DRAIN_LIFE="Drain Life",DRAIN_MANA="Drain Mana",DRAIN_SOUL="Drain Soul",FEAR="Fear",FEL_CONCENTRATION="Fel Concentration",GRIM_REACH="Grim Reach",HOWL_OF_TERROR="Howl of Terror",IMPROVED_CORRUPTION="Improved Corruption",IMPROVED_CURSE_OF_AGONY="Improved Curse of Agony",IMPROVED_CURSE_OF_EXHAUSTION="Improved Curse of Exhaustion",IMPROVED_CURSE_OF_WEAKNESS="Improved Curse of Weakness",IMPROVED_DRAIN_LIFE="Improved Drain Life",IMPROVED_DRAIN_MANA="Improved Drain Mana",IMPROVED_DRAIN_SOUL="Improved Drain Soul",IMPROVED_LIFE_TAP="Improved Life Tap",LIFE_TAP="Life Tap",NIGHTFALL="Nightfall",SHADOW_MASTERY="Shadow Mastery",SIPHON_LIFE="Siphon Life",SUPPRESSION="Suppression",AMPLIFY_MAGIC="Amplify Magic",ARCANE_BRILLIANCE="Arcane Brilliance",ARCANE_CONCENTRATION="Arcane Concentration",ARCANE_EXPLOSION="Arcane Explosion",ARCANE_FOCUS="Arcane Focus",ARCANE_INSTABILITY="Arcane Instability",ARCANE_INTELLECT="Arcane Intellect",ARCANE_MEDITATION="Arcane Meditation",ARCANE_MIND="Arcane Mind",ARCANE_MISSILES="Arcane Missiles",ARCANE_POWER="Arcane Power",ARCANE_SUBTLETY="Arcane Subtlety",BLINK="Blink",CLEARCASTING="Clearcasting",CONJURE_FOOD="Conjure Food",CONJURE_MANA_AGATE="Conjure Mana Agate",CONJURE_MANA_CITRINE="Conjure Mana Citrine",CONJURE_MANA_JADE="Conjure Mana Jade",CONJURE_MANA_RUBY="Conjure Mana Ruby",CONJURE_WATER="Conjure Water",COUNTERSPELL="Counterspell",DAMPEN_MAGIC="Dampen Magic",DETECT_MAGIC="Detect Magic",EVOCATION="Evocation",IMPROVED_ARCANE_EXPLOSION="Improved Arcane Explosion",IMPROVED_ARCANE_MISSILES="Improved Arcane Missiles",IMPROVED_COUNTERSPELL="Improved Counterspell",IMPROVED_DAMPEN_MAGIC="Improved Dampen Magic",IMPROVED_MANA_SHIELD="Improved Mana Shield",MAGE_ARMOR="Mage Armor",MANA_SHIELD="Mana Shield",POLYMORPH="Polymorph",PORTAL_DARNASSUS="Portal: Darnassus",PORTAL_IRONFORGE="Portal: Ironforge",PORTAL_ORGRIMMAR="Portal: Orgrimmar",PORTAL_STORMWIND="Portal: Stormwind",PORTAL_THUNDER_BLUFF="Portal: Thunder Bluff",PORTAL_UNDERCITY="Portal: Undercity",PRESENCE_OF_MIND="Presence of Mind",REMOVE_LESSER_CURSE="Remove Lesser Curse",SLOW_FALL="Slow Fall",TELEPORT_DARNASSUS="Teleport: Darnassus",TELEPORT_IRONFORGE="Teleport: Ironforge",TELEPORT_ORGRIMMAR="Teleport: Orgrimmar",TELEPORT_STORMWIND="Teleport: Stormwind",TELEPORT_THUNDER_BLUFF="Teleport: Thunder Bluff",TELEPORT_UNDERCITY="Teleport: Undercity",WAND_SPECIALIZATION="Wand Specialization",ANGER_MANAGEMENT="Anger Management",AXE_SPECIALIZATION="Axe Specialization",BATTLE_STANCE="Battle Stance",BATTLE_STANCE_PASSIVE="Battle Stance Passive",CHARGE="Charge",CHARGE_RAGE_BONUS_EFFECT="Charge Rage Bonus Effect",DEEP_WOUNDS="Deep Wounds",DEFLECTION="Deflection",HAMSTRING="Hamstring",HEROIC_STRIKE="Heroic Strike",IMPALE="Impale",IMPROVED_CHARGE="Improved Charge",IMPROVED_HAMSTRING="Improved Hamstring",IMPROVED_HEROIC_STRIKE="Improved Heroic Strike",IMPROVED_OVERPOWER="Improved Overpower",IMPROVED_PUMMEL="Improved Pummel",IMPROVED_REND="Improved Rend",IMPROVED_THUNDER_CLAP="Improved Thunder Clap",LONG_DAZE="Long Daze",MACE_SPECIALIZATION="Mace Specialization",MACE_STUN_EFFECT="Mace Stun Effect",MOCKING_BLOW="Mocking Blow",MORTAL_STRIKE="Mortal Strike",OVERPOWER="Overpower",POLEARM_SPECIALIZATION="Polearm Specialization",REND="Rend",RETALIATION="Retaliation",SWEEPING_STRIKES="Sweeping Strikes",SWORD_SPECIALIZATION="Sword Specialization",TACTICAL_MASTERY="Tactical Mastery",THUNDER_CLAP="Thunder Clap",TWO_HANDED_WEAPON_SPECIALIZATION="Two-Handed Weapon Specialization",AMBUSH="Ambush",CHEAP_SHOT="Cheap Shot",COLD_BLOOD="Cold Blood",EVISCERATE="Eviscerate",EXPOSE_ARMOR="Expose Armor",GARROTE="Garrote",IMPROVED_DEADLY_POISON="Improved Deadly Poison",IMPROVED_EVISCERATE="Improved Eviscerate",IMPROVED_EXPOSE_ARMOR="Improved Expose Armor",IMPROVED_INSTANT_POISON="Improved Instant Poison",IMPROVED_KIDNEY_SHOT="Improved Kidney Shot",IMPROVED_SLICE_AND_DICE="Improved Slice and Dice",KIDNEY_SHOT="Kidney Shot",LETHALITY="Lethality",MALICE="Malice",MURDER="Murder",RELENTLESS_STRIKES="Relentless Strikes",REMORSELESS_ATTACKS="Remorseless Attacks",RUPTURE="Rupture",RUTHLESSNESS="Ruthlessness",SEAL_FATE="Seal Fate",SLICE_AND_DICE="Slice and Dice",VIGOR="Vigor",VILE_POISONS="Vile Poisons",ONE_HANDED_AXES="One-Handed Axes",BARKSKIN="Barkskin",BARKSKIN_EFFECT="Barkskin Effect",ENTANGLING_ROOTS="Entangling Roots",FAERIE_FIRE="Faerie Fire",HIBERNATE="Hibernate",HURRICANE="Hurricane",IMPROVED_ENTANGLING_ROOTS="Improved Entangling Roots",IMPROVED_MOONFIRE="Improved Moonfire",IMPROVED_NATURES_GRASP="Improved Nature's Grasp",IMPROVED_STARFIRE="Improved Starfire",IMPROVED_THORNS="Improved Thorns",IMPROVED_WRATH="Improved Wrath",MOONFIRE="Moonfire",MOONFURY="Moonfury",MOONGLOW="Moonglow",MOONKIN_AURA="Moonkin Aura",MOONKIN_FORM="Moonkin Form",NATURAL_SHAPESHIFTER="Natural Shapeshifter",NATURAL_WEAPONS="Natural Weapons",NATURES_GRACE="Nature's Grace",NATURES_GRASP="Nature's Grasp",NATURES_REACH="Nature's Reach",OMEN_OF_CLARITY="Omen of Clarity",SOOTHE_ANIMAL="Soothe Animal",STARFIRE="Starfire",TELEPORT_MOONGLADE="Teleport: Moonglade",THORNS="Thorns",VENGEANCE="Vengeance",WRATH="Wrath",ASPECT_OF_THE_BEAST="Aspect of the Beast",ASPECT_OF_THE_CHEETAH="Aspect of the Cheetah",ASPECT_OF_THE_HAWK="Aspect of the Hawk",ASPECT_OF_THE_MONKEY="Aspect of the Monkey",ASPECT_OF_THE_PACK="Aspect of the Pack",ASPECT_OF_THE_WILD="Aspect of the Wild",BEAST_LORE="Beast Lore",BESTIAL_DISCIPLINE="Bestial Discipline",BESTIAL_SWIFTNESS="Bestial Swiftness",BESTIAL_WRATH="Bestial Wrath",CALL_PET="Call Pet",DISMISS_PET="Dismiss Pet",EAGLE_EYE="Eagle Eye",ENDURANCE_TRAINING="Endurance Training",EYES_OF_THE_BEAST="Eyes of the Beast",FEED_PET="Feed Pet",FEROCITY="Ferocity",FRENZY="Frenzy",IMPROVED_ASPECT_OF_THE_HAWK="Improved Aspect of the Hawk",IMPROVED_ASPECT_OF_THE_MONKEY="Improved Aspect of the Monkey",IMPROVED_EYES_OF_THE_BEAST="Improved Eyes of the Beast",IMPROVED_MEND_PET="Improved Mend Pet",IMPROVED_REVIVE_PET="Improved Revive Pet",INTIMIDATION="Intimidation",MEND_PET="Mend Pet",PATHFINDING="Pathfinding",REVIVE_PET="Revive Pet",SCARE_BEAST="Scare Beast",SPIRIT_BOND="Spirit Bond",TAME_BEAST="Tame Beast",THICK_HIDE="Thick Hide",TRANQUILIZING_SHOT="Tranquilizing Shot",UNLEASHED_FURY="Unleashed Fury",ARCANE_RESISTANCE="Arcane Resistance",BEAST_TRAINING="Beast Training",BITE="Bite",CLAW="Claw",COBRA_REFLEXES="Cobra Reflexes",COWER="Cower",DASH="Dash",DIVE="Dive",FIRE_RESISTANCE="Fire Resistance",FROST_RESISTANCE="Frost Resistance",FURIOUS_HOWL="Furious Howl",GREAT_STAMINA="Great Stamina",GROWL="Growl",HARASS="Harass",LIGHTNING_BREATH="Lightning Breath",NATURAL_ARMOR="Natural Armor",NATURE_RESISTANCE="Nature Resistance",PROWL="Prowl",SCORPID_POISON="Scorpid Poison",SCREECH="Screech",SHADOW_RESISTANCE="Shadow Resistance",SHELL_SHIELD="Shell Shield",THUNDERSTOMP="Thunderstomp",BOWS="Bows",SHOOT_BOW="Shoot Bow",CLOTH="Cloth",ADRENALINE_RUSH="Adrenaline Rush",AGGRESSION="Aggression",BACKSTAB="Backstab",BLADE_FLURRY="Blade Flurry",DAGGER_SPECIALIZATION="Dagger Specialization",DUAL_WIELD_SPECIALIZATION="Dual Wield Specialization",EVASION="Evasion",FEINT="Feint",FIST_WEAPON_SPECIALIZATION="Fist Weapon Specialization",GOUGE="Gouge",IMPROVED_BACKSTAB="Improved Backstab",IMPROVED_EVASION="Improved Evasion",IMPROVED_GOUGE="Improved Gouge",IMPROVED_KICK="Improved Kick",IMPROVED_SINISTER_STRIKE="Improved Sinister Strike",IMPROVED_SPRINT="Improved Sprint",KICK="Kick",LIGHTNING_REFLEXES="Lightning Reflexes",PRECISION="Precision",RIPOSTE="Riposte",ROGUE_PASSIVE="Rogue Passive",SINISTER_STRIKE="Sinister Strike",SPRINT="Sprint",THROWING_WEAPON_SPECIALIZATION="Throwing Weapon Specialization",CROSSBOWS="Crossbows",SHOOT_CROSSBOW="Shoot Crossbow",DAGGERS="Daggers",BLOCK="Block",DEFENSE="Defense",DEFENSIVE_STATE="Defensive State",DEFENSIVE_STATE_2="Defensive State 2",DODGE="Dodge",PARRY="Parry",SPELLDEFENSE="SPELLDEFENSE",BANISH="Banish",CREATE_FIRESTONE="Create Firestone",CREATE_HEALTHSTONE="Create Healthstone",CREATE_SOULSTONE="Create Soulstone",CREATE_SPELLSTONE="Create Spellstone",DEMON_ARMOR="Demon Armor",DEMON_SKIN="Demon Skin",DEMONIC_EMBRACE="Demonic Embrace",DEMONIC_SACRIFICE="Demonic Sacrifice",DETECT_GREATER_INVISIBILITY="Detect Greater Invisibility",DETECT_INVISIBILITY="Detect Invisibility",DETECT_LESSER_INVISIBILITY="Detect Lesser Invisibility",ENSLAVE_DEMON="Enslave Demon",EYE_OF_KILROGG="Eye of Kilrogg",FEL_DOMINATION="Fel Domination",FEL_INTELLECT="Fel Intellect",FEL_STAMINA="Fel Stamina",HEALTH_FUNNEL="Health Funnel",IMPROVED_ENSLAVE_DEMON="Improved Enslave Demon",IMPROVED_FIRESTONE="Improved Firestone",IMPROVED_HEALTH_FUNNEL="Improved Health Funnel",IMPROVED_HEALTHSTONE="Improved Healthstone",IMPROVED_IMP="Improved Imp",IMPROVED_SPELLSTONE="Improved Spellstone",IMPROVED_SUCCUBUS="Improved Succubus",IMPROVED_VOIDWALKER="Improved Voidwalker",INFERNO="Inferno",MASTER_DEMONOLOGIST="Master Demonologist",MASTER_SUMMONER="Master Summoner",RITUAL_OF_DOOM="Ritual of Doom",RITUAL_OF_DOOM_EFFECT="Ritual of Doom Effect",RITUAL_OF_SUMMONING="Ritual of Summoning",SENSE_DEMONS="Sense Demons",SHADOW_WARD="Shadow Ward",SOUL_LINK="Soul Link",SUMMON_DREADSTEED="Summon Dreadsteed",SUMMON_FELHUNTER="Summon Felhunter",SUMMON_FELSTEED="Summon Felsteed",SUMMON_IMP="Summon Imp",SUMMON_SUCCUBUS="Summon Succubus",SUMMON_VOIDWALKER="Summon Voidwalker",UNENDING_BREATH="Unending Breath",UNHOLY_POWER="Unholy Power",AFTERMATH="Aftermath",BANE="Bane",CATACLYSM="Cataclysm",CONFLAGRATE="Conflagrate",DESTRUCTIVE_REACH="Destructive Reach",DEVASTATION="Devastation",
			EMBERSTORM="Emberstorm",HELLFIRE="Hellfire",HELLFIRE_EFFECT="Hellfire Effect",IMMOLATE="Immolate",IMPROVED_FIREBOLT="Improved Firebolt",IMPROVED_IMMOLATE="Improved Immolate",IMPROVED_LASH_OF_PAIN="Improved Lash of Pain",IMPROVED_SEARING_PAIN="Improved Searing Pain",IMPROVED_SHADOW_BOLT="Improved Shadow Bolt",INTENSITY="Intensity",PYROCLASM="Pyroclasm",RAIN_OF_FIRE="Rain of Fire",RUIN="Ruin",SEARING_PAIN="Searing Pain",SHADOW_BOLT="Shadow Bolt",SHADOWBURN="Shadowburn",SOUL_FIRE="Soul Fire",DISPEL_MAGIC="Dispel Magic",DIVINE_SPIRIT="Divine Spirit",ELUNES_GRACE="Elune's Grace",FEEDBACK="Feedback",FOCUSED_CASTING="Focused Casting",FORCE_OF_WILL="Force of Will",IMPROVED_INNER_FIRE="Improved Inner Fire",IMPROVED_MANA_BURN="Improved Mana Burn",IMPROVED_POWER_WORD_FORTITUDE="Improved Power Word: Fortitude",IMPROVED_POWER_WORD_SHIELD="Improved Power Word: Shield",INNER_FIRE="Inner Fire",INNER_FOCUS="Inner Focus",LEVITATE="Levitate",MANA_BURN="Mana Burn",MARTYRDOM="Martyrdom",MEDITATION="Meditation",MENTAL_AGILITY="Mental Agility",MENTAL_STRENGTH="Mental Strength",POWER_INFUSION="Power Infusion",POWER_WORD_FORTITUDE="Power Word: Fortitude",POWER_WORD_SHIELD="Power Word: Shield",PRAYER_OF_FORTITUDE="Prayer of Fortitude",PRAYER_OF_SPIRIT="Prayer of Spirit",SHACKLE_UNDEAD="Shackle Undead",SILENT_RESOLVE="Silent Resolve",STARSHARDS="Starshards",UNBREAKABLE_WILL="Unbreakable Will",DUAL_WIELD="Dual Wield",FIND_TREASURE="Find Treasure",GUN_SPECIALIZATION="Gun Specialization",STONEFORM="Stoneform",CALL_OF_FLAME="Call of Flame",CALL_OF_THUNDER="Call of Thunder",CHAIN_LIGHTNING="Chain Lightning",CONCUSSION="Concussion",CONVECTION="Convection",EARTH_SHOCK="Earth Shock",EARTHBIND_TOTEM="Earthbind Totem",ELEMENTAL_FOCUS="Elemental Focus",ELEMENTAL_FURY="Elemental Fury",ELEMENTAL_MASTERY="Elemental Mastery",FIRE_NOVA_TOTEM="Fire Nova Totem",FLAME_SHOCK="Flame Shock",FROST_SHOCK="Frost Shock",IMPROVED_CHAIN_LIGHTNING="Improved Chain Lightning",IMPROVED_FIRE_NOVA_TOTEM="Improved Fire Nova Totem",IMPROVED_LIGHTNING_BOLT="Improved Lightning Bolt",IMPROVED_MAGMA_TOTEM="Improved Magma Totem",IMPROVED_SEARING_TOTEM="Improved Searing Totem",IMPROVED_STONECLAW_TOTEM="Improved Stoneclaw Totem",LIGHTNING_BOLT="Lightning Bolt",LIGHTNING_MASTERY="Lightning Mastery",MAGMA_TOTEM="Magma Totem",PURGE="Purge",REVERBERATION="Reverberation",SEARING_TOTEM="Searing Totem",STONECLAW_TOTEM="Stoneclaw Totem",ANCESTRAL_KNOWLEDGE="Ancestral Knowledge",ANTICIPATION="Anticipation",ASTRAL_RECALL="Astral Recall",FAR_SIGHT="Far Sight",FIRE_RESISTANCE_TOTEM="Fire Resistance Totem",FLAMETONGUE_TOTEM="Flametongue Totem",FLAMETONGUE_WEAPON="Flametongue Weapon",FLURRY="Flurry",FROST_RESISTANCE_TOTEM="Frost Resistance Totem",FROSTBRAND_WEAPON="Frostbrand Weapon",GHOST_WOLF="Ghost Wolf",GRACE_OF_AIR_TOTEM="Grace of Air Totem",GROUNDING_TOTEM="Grounding Totem",IMPROVED_FLAMETONGUE_WEAPON="Improved Flametongue Weapon",IMPROVED_FROSTBRAND_WEAPON="Improved Frostbrand Weapon",IMPROVED_GHOST_WOLF="Improved Ghost Wolf",IMPROVED_GRACE_OF_AIR_TOTEM="Improved Grace of Air Totem",IMPROVED_GROUNDING_TOTEM="Improved Grounding Totem",IMPROVED_LIGHTNING_SHIELD="Improved Lightning Shield",IMPROVED_ROCKBITER_WEAPON="Improved Rockbiter Weapon",IMPROVED_STONESKIN_TOTEM="Improved Stoneskin Totem",IMPROVED_STRENGTH_OF_EARTH_TOTEM="Improved Strength of Earth Totem",IMPROVED_WINDFURY_WEAPON="Improved Windfury Weapon",LIGHTNING_SHIELD="Lightning Shield",NATURE_RESISTANCE_TOTEM="Nature Resistance Totem",ROCKBITER_WEAPON="Rockbiter Weapon",SENTRY_TOTEM="Sentry Totem",SHIELD_SPECIALIZATION="Shield Specialization",STONESKIN_TOTEM="Stoneskin Totem",STORMSTRIKE="Stormstrike",STRENGTH_OF_EARTH_TOTEM="Strength of Earth Totem",THUNDERING_STRIKES="Thundering Strikes",TOUGHNESS="Toughness",TWO_HANDED_AXES_AND_MACES="Two-Handed Axes and Maces",WATER_BREATHING="Water Breathing",WATER_WALKING="Water Walking",WINDFURY_TOTEM="Windfury Totem",WINDFURY_WEAPON="Windfury Weapon",WINDWALL_TOTEM="Windwall Totem",AQUATIC_FORM="Aquatic Form",BASH="Bash",BEAR_FORM="Bear Form",BLOOD_FRENZY="Blood Frenzy",BRUTAL_IMPACT="Brutal Impact",CAT_FORM="Cat Form",CHALLENGING_ROAR="Challenging Roar",DEMORALIZING_ROAR="Demoralizing Roar",DIRE_BEAR_FORM="Dire Bear Form",ENRAGE="Enrage",FELINE_GRACE="Feline Grace",FELINE_SWIFTNESS="Feline Swiftness",FERAL_AGGRESSION="Feral Aggression",FERAL_CHARGE="Feral Charge",FERAL_INSTINCT="Feral Instinct",FEROCIOUS_BITE="Ferocious Bite",FRENZIED_REGENERATION="Frenzied Regeneration",HEART_OF_THE_WILD="Heart of the Wild",IMPROVED_SHRED="Improved Shred",LEADER_OF_THE_PACK="Leader of the Pack",MANGLE="Mangle",MAUL="Maul",POUNCE="Pounce",POUNCE_BLEED="Pounce Bleed",PREDATORY_STRIKES="Predatory Strikes",PRIMAL_FURY="Primal Fury",RAKE="Rake",RAVAGE="Ravage",RIP="Rip",SAVAGE_FURY="Savage Fury",SHARPENED_CLAWS="Sharpened Claws",SHRED="Shred",SWIPE="Swipe",TIGERS_FURY="Tiger's Fury",TRACK_HUMANOIDS="Track Humanoids",TRAVEL_FORM="Travel Form",BLAST_WAVE="Blast Wave",BURNING_SOUL="Burning Soul",COMBUSTION="Combustion",CRITICAL_MASS="Critical Mass",FELFIRE="Felfire",FIRE_BLAST="Fire Blast",FIRE_POWER="Fire Power",FIRE_VULNERABILITY="Fire Vulnerability",FIRE_WARD="Fire Ward",FIREBALL="Fireball",FLAME_THROWING="Flame Throwing",FLAMESTRIKE="Flamestrike",IGNITE="Ignite",IMPACT="Impact",IMPROVED_FIRE_BLAST="Improved Fire Blast",IMPROVED_FIRE_WARD="Improved Fire Ward",IMPROVED_FIREBALL="Improved Fireball",IMPROVED_FLAMESTRIKE="Improved Flamestrike",IMPROVED_SCORCH="Improved Scorch",INCINERATE="Incinerate",PYROBLAST="Pyroblast",SCORCH="Scorch",FISHING="Fishing",FISHING_POLES="Fishing Poles",FIST_WEAPONS="Fist Weapons",ARCTIC_REACH="Arctic Reach",BLIZZARD="Blizzard",CHILLED="Chilled",COLD_SNAP="Cold Snap",CONE_OF_COLD="Cone of Cold",FROST_ARMOR="Frost Armor",FROST_CHANNELING="Frost Channeling",FROST_NOVA="Frost Nova",FROST_WARD="Frost Ward",FROSTBITE="Frostbite",FROSTBOLT="Frostbolt",ICE_ARMOR="Ice Armor",ICE_BARRIER="Ice Barrier",ICE_BLOCK="Ice Block",ICE_SHARDS="Ice Shards",IMPROVED_BLIZZARD="Improved Blizzard",IMPROVED_CONE_OF_COLD="Improved Cone of Cold",IMPROVED_FROST_NOVA="Improved Frost Nova",IMPROVED_FROST_WARD="Improved Frost Ward",IMPROVED_FROSTBOLT="Improved Frostbolt",PERMAFROST="Permafrost",PIERCING_ICE="Piercing Ice",SHATTER="Shatter",WINTERS_CHILL="Winter's Chill",BATTLE_SHOUT="Battle Shout",BERSERKER_RAGE="Berserker Rage",BERSERKER_STANCE="Berserker Stance",BERSERKER_STANCE_PASSIVE="Berserker Stance Passive",BLOOD_CRAZE="Blood Craze",BLOODTHIRST="Bloodthirst",BOOMING_VOICE="Booming Voice",CHALLENGING_SHOUT="Challenging Shout",CLEAVE="Cleave",CRUELTY="Cruelty",DEATH_WISH="Death Wish",DEMORALIZING_SHOUT="Demoralizing Shout",EXECUTE="Execute",IMPROVED_BATTLE_SHOUT="Improved Battle Shout",IMPROVED_BERSERKER_RAGE="Improved Berserker Rage",IMPROVED_CHALLENGING_SHOUT="Improved Challenging Shout",IMPROVED_CLEAVE="Improved Cleave",IMPROVED_DEMORALIZING_SHOUT="Improved Demoralizing Shout",IMPROVED_EXECUTE="Improved Execute",IMPROVED_INTERCEPT="Improved Intercept",IMPROVED_INTIMIDATING_SHOUT="Improved Intimidating Shout",IMPROVED_SLAM="Improved Slam",INTERCEPT="Intercept",INTIMIDATING_SHOUT="Intimidating Shout",PIERCING_HOWL="Piercing Howl",PUMMEL="Pummel",RECKLESSNESS="Recklessness",SLAM="Slam",UNBRIDLED_WRATH="Unbridled Wrath",UNBRIDLED_WRATH_EFFECT="Unbridled Wrath Effect",WHIRLWIND="Whirlwind",ATTACK="Attack",ATTACKING="Attacking",CLOSING="Closing",DETECT="Detect",DUEL="Duel",FETISH="Fetish",GENERIC="Generic",GROVEL="Grovel",HONORLESS_TARGET="Honorless Target",LIBRAM="Libram",OPENING="Opening",OPENING___NO_TEXT="Opening - No Text",REMOVE_INSIGNIA="Remove Insignia",STUCK="Stuck",TOTEM="Totem",GUNS="Guns",SHOOT_GUN="Shoot Gun",ABOLISH_DISEASE="Abolish Disease",BLESSED_RECOVERY="Blessed Recovery",CURE_DISEASE="Cure Disease",DESPERATE_PRAYER="Desperate Prayer",DIVINE_FURY="Divine Fury",FEAR_WARD="Fear Ward",FLASH_HEAL="Flash Heal",GREATER_HEAL="Greater Heal",HEAL="Heal",HEALING_FOCUS="Healing Focus",HOLY_FIRE="Holy Fire",HOLY_NOVA="Holy Nova",HOLY_REACH="Holy Reach",HOLY_SPECIALIZATION="Holy Specialization",IMPROVED_HEALING="Improved Healing",IMPROVED_PRAYER_OF_HEALING="Improved Prayer of Healing",IMPROVED_RENEW="Improved Renew",INSPIRATION="Inspiration",LESSER_HEAL="Lesser Heal",LIGHTWELL="Lightwell",LIGHTWELL_RENEW="Lightwell Renew",PRAYER_OF_HEALING="Prayer of Healing",RENEW="Renew",RESURRECTION="Resurrection",SEARING_LIGHT="Searing Light",SMITE="Smite",SPELL_WARDING="Spell Warding",SPIRIT_OF_REDEMPTION="Spirit of Redemption",SPIRITUAL_GUIDANCE="Spiritual Guidance",SPIRITUAL_HEALING="Spiritual Healing",BLESSING_OF_LIGHT="Blessing of Light",BLESSING_OF_WISDOM="Blessing of Wisdom",CLEANSE="Cleanse",CONSECRATION="Consecration",DIVINE_FAVOR="Divine Favor",DIVINE_INTELLECT="Divine Intellect",DIVINE_STRENGTH="Divine Strength",EXORCISM="Exorcism",FLASH_OF_LIGHT="Flash of Light",GREATER_BLESSING_OF_LIGHT="Greater Blessing of Light",GREATER_BLESSING_OF_WISDOM="Greater Blessing of Wisdom",HAMMER_OF_WRATH="Hammer of Wrath",HEALING_LIGHT="Healing Light",HOLY_LIGHT="Holy Light",HOLY_POWER="Holy Power",HOLY_SHOCK="Holy Shock",HOLY_WRATH="Holy Wrath",ILLUMINATION="Illumination",IMPROVED_BLESSING_OF_WISDOM="Improved Blessing of Wisdom",IMPROVED_FLASH_OF_LIGHT="Improved Flash of Light",IMPROVED_LAY_ON_HANDS="Improved Lay on Hands",IMPROVED_SEAL_OF_RIGHTEOUSNESS="Improved Seal of Righteousness",JUDGEMENT_OF_LIGHT="Judgement of Light",JUDGEMENT_OF_RIGHTEOUSNESS="Judgement of Righteousness",JUDGEMENT_OF_WISDOM="Judgement of Wisdom",LASTING_JUDGEMENT="Lasting Judgement",LAY_ON_HANDS="Lay on Hands",PURIFY="Purify",REDEMPTION="Redemption",SEAL_OF_LIGHT="Seal of Light",SEAL_OF_RIGHTEOUSNESS="Seal of Righteousness",SEAL_OF_WISDOM="Seal of Wisdom",SENSE_UNDEAD="Sense Undead",SPIRITUAL_FOCUS="Spiritual Focus",SUMMON_CHARGER="Summon Charger",SUMMON_WARHORSE="Summon Warhorse",TURN_UNDEAD="Turn Undead",UNYIELDING_FAITH="Unyielding Faith",HORSE_RIDING="Horse Riding",KODO_RIDING="Kodo Riding",LEATHER="Leather",PICK_LOCK="Pick Lock",
			ONE_HANDED_MACES="One-Handed Maces",MAIL="Mail",AIMED_SHOT="Aimed Shot",ARCANE_SHOT="Arcane Shot",AUTO_SHOT="Auto Shot",BARRAGE="Barrage",BLACK_ARROW="Black Arrow",CONCUSSIVE_SHOT="Concussive Shot",DISTRACTING_SHOT="Distracting Shot",EFFICIENCY="Efficiency",FLARE="Flare",HAWK_EYE="Hawk Eye",HUNTERS_MARK="Hunter's Mark",IMPROVED_ARCANE_SHOT="Improved Arcane Shot",IMPROVED_CONCUSSIVE_SHOT="Improved Concussive Shot",IMPROVED_HUNTERS_MARK="Improved Hunter's Mark",IMPROVED_SCORPID_STING="Improved Scorpid Sting",IMPROVED_SERPENT_STING="Improved Serpent Sting",LETHAL_SHOTS="Lethal Shots",MORTAL_SHOTS="Mortal Shots",MULTI_SHOT="Multi-Shot",RANGED_WEAPON_SPECIALIZATION="Ranged Weapon Specialization",RAPID_FIRE="Rapid Fire",SCATTER_SHOT="Scatter Shot",SCORPID_STING="Scorpid Sting",SERPENT_STING="Serpent Sting",TRUESHOT_AURA="Trueshot Aura",VIPER_STING="Viper Sting",VOLLEY="Volley",MECHANOSTRIDER_PILOTING="Mechanostrider Piloting",QUICKNESS="Quickness",SHADOWMELD="Shadowmeld",SHADOWMELD_PASSIVE="Shadowmeld Passive",WISP_SPIRIT="Wisp Spirit",BLOOD_FURY="Blood Fury",COMMAND="Command",HARDINESS="Hardiness",TAMED_PET_PASSIVE="Tamed Pet Passive",ACTIVATE_MG_TURRET="Activate MG Turret",FLAMETHROWER="Flamethrower",DEVOUR_MAGIC="Devour Magic",DEVOUR_MAGIC_EFFECT="Devour Magic Effect",PARANOIA="Paranoia",SPELL_LOCK="Spell Lock",TAINTED_BLOOD="Tainted Blood",PET_AGGRESSION="Pet Aggression",PET_HARDINESS="Pet Hardiness",PET_RECOVERY="Pet Recovery",PET_RESISTANCE="Pet Resistance",BLOOD_PACT="Blood Pact",FIRE_SHIELD="Fire Shield",FIREBOLT="Firebolt",PHASE_SHIFT="Phase Shift",LASH_OF_PAIN="Lash of Pain",LESSER_INVISIBILITY="Lesser Invisibility",SEDUCTION="Seduction",SOOTHING_KISS="Soothing Kiss",CONSUME_SHADOWS="Consume Shadows",SACRIFICE="Sacrifice",SUFFERING="Suffering",TORMENT="Torment",PLATE_MAIL="Plate Mail",BLINDING_POWDER="Blinding Powder",CRIPPLING_POISON="Crippling Poison",CRIPPLING_POISON_II="Crippling Poison II",DEADLY_POISON="Deadly Poison",DEADLY_POISON_II="Deadly Poison II",DEADLY_POISON_III="Deadly Poison III",DEADLY_POISON_IV="Deadly Poison IV",DEADLY_POISON_V="Deadly Poison V",INSTANT_POISON="Instant Poison",INSTANT_POISON_II="Instant Poison II",INSTANT_POISON_III="Instant Poison III",INSTANT_POISON_IV="Instant Poison IV",INSTANT_POISON_V="Instant Poison V",INSTANT_POISON_VI="Instant Poison VI",MIND_NUMBING_POISON="Mind-numbing Poison",MIND_NUMBING_POISON_II="Mind-numbing Poison II",MIND_NUMBING_POISON_III="Mind-numbing Poison III",POISONS="Poisons",WOUND_POISON="Wound Poison",WOUND_POISON_II="Wound Poison II",WOUND_POISON_III="Wound Poison III",WOUND_POISON_IV="Wound Poison IV",POLEARMS="Polearms",BLOODRAGE="Bloodrage",CONCUSSION_BLOW="Concussion Blow",DEFENSIVE_STANCE="Defensive Stance",DEFENSIVE_STANCE_PASSIVE="Defensive Stance Passive",DEFIANCE="Defiance",DISARM="Disarm",IMPROVED_BLOODRAGE="Improved Bloodrage",IMPROVED_DISARM="Improved Disarm",IMPROVED_REVENGE="Improved Revenge",IMPROVED_SHIELD_BASH="Improved Shield Bash",IMPROVED_SHIELD_BLOCK="Improved Shield Block",IMPROVED_SHIELD_WALL="Improved Shield Wall",IMPROVED_SUNDER_ARMOR="Improved Sunder Armor",IMPROVED_TAUNT="Improved Taunt",IRON_WILL="Iron Will",LAST_STAND="Last Stand",ONE_HANDED_WEAPON_SPECIALIZATION="One-Handed Weapon Specialization",REVENGE="Revenge",REVENGE_STUN="Revenge Stun",SHIELD_BASH="Shield Bash",SHIELD_BLOCK="Shield Block",SHIELD_SLAM="Shield Slam",SHIELD_WALL="Shield Wall",SUNDER_ARMOR="Sunder Armor",TAUNT="Taunt",BLESSING_OF_FREEDOM="Blessing of Freedom",BLESSING_OF_KINGS="Blessing of Kings",BLESSING_OF_PROTECTION="Blessing of Protection",BLESSING_OF_SACRIFICE="Blessing of Sacrifice",BLESSING_OF_SALVATION="Blessing of Salvation",BLESSING_OF_SANCTUARY="Blessing of Sanctuary",CONCENTRATION_AURA="Concentration Aura",DEVOTION_AURA="Devotion Aura",DIVINE_INTERVENTION="Divine Intervention",DIVINE_PROTECTION="Divine Protection",DIVINE_SHIELD="Divine Shield",FIRE_RESISTANCE_AURA="Fire Resistance Aura",FROST_RESISTANCE_AURA="Frost Resistance Aura",GREATER_BLESSING_OF_KINGS="Greater Blessing of Kings",GREATER_BLESSING_OF_SALVATION="Greater Blessing of Salvation",GREATER_BLESSING_OF_SANCTUARY="Greater Blessing of Sanctuary",GUARDIANS_FAVOR="Guardian's Favor",HAMMER_OF_JUSTICE="Hammer of Justice",HOLY_SHIELD="Holy Shield",IMPROVED_CONCENTRATION_AURA="Improved Concentration Aura",IMPROVED_DEVOTION_AURA="Improved Devotion Aura",IMPROVED_HAMMER_OF_JUSTICE="Improved Hammer of Justice",IMPROVED_RIGHTEOUS_FURY="Improved Righteous Fury",JUDGEMENT_OF_JUSTICE="Judgement of Justice",RECKONING="Reckoning",REDOUBT="Redoubt",RIGHTEOUS_FURY="Righteous Fury",SEAL_OF_JUSTICE="Seal of Justice",SHADOW_RESISTANCE_AURA="Shadow Resistance Aura",ENGINEERING_SPECIALIZATION="Engineering Specialization",ESCAPE_ARTIST="Escape Artist",EXPANSIVE_MIND="Expansive Mind",DIPLOMACY="Diplomacy",PERCEPTION="Perception",THE_HUMAN_SPIRIT="The Human Spirit",BEAST_SLAYING="Beast Slaying",BERSERKING="Berserking",BOW_SPECIALIZATION="Bow Specialization",REGENERATION="Regeneration",THROWING_SPECIALIZATION="Throwing Specialization",CANNIBALIZE="Cannibalize",UNDERWATER_BREATHING="Underwater Breathing",WILL_OF_THE_FORSAKEN="Will of the Forsaken",RAM_RIDING="Ram Riding",RAPTOR_RIDING="Raptor Riding",ANCESTRAL_HEALING="Ancestral Healing",ANCESTRAL_SPIRIT="Ancestral Spirit",CHAIN_HEAL="Chain Heal",COMBAT_ENDURANCE="Combat Endurance",CURE_POISON="Cure Poison",DISEASE_CLEANSING_TOTEM="Disease Cleansing Totem",EVENTIDE="Eventide",HEALING_STREAM_TOTEM="Healing Stream Totem",HEALING_WAVE="Healing Wave",IMPROVED_CHAIN_HEAL="Improved Chain Heal",IMPROVED_HEALING_STREAM_TOTEM="Improved Healing Stream Totem",IMPROVED_HEALING_WAVE="Improved Healing Wave",IMPROVED_LESSER_HEALING_WAVE="Improved Lesser Healing Wave",IMPROVED_MANA_SPRING_TOTEM="Improved Mana Spring Totem",IMPROVED_REINCARNATION="Improved Reincarnation",LESSER_HEALING_WAVE="Lesser Healing Wave",MANA_SPRING_TOTEM="Mana Spring Totem",MANA_TIDE_TOTEM="Mana Tide Totem",NATURES_SWIFTNESS="Nature's Swiftness",POISON_CLEANSING_TOTEM="Poison Cleansing Totem",PURIFICATION="Purification",REINCARNATION="Reincarnation",TIDAL_FOCUS="Tidal Focus",TIDAL_MASTERY="Tidal Mastery",TOTEMIC_FOCUS="Totemic Focus",TRANQUIL_AIR_TOTEM="Tranquil Air Totem",TREMOR_TOTEM="Tremor Totem",ABOLISH_POISON="Abolish Poison",ABOLISH_POISON_EFFECT="Abolish Poison Effect",FUROR="Furor",GIFT_OF_NATURE="Gift of Nature",GIFT_OF_THE_WILD="Gift of the Wild",HEALING_TOUCH="Healing Touch",IMPROVED_ENRAGE="Improved Enrage",IMPROVED_HEALING_TOUCH="Improved Healing Touch",IMPROVED_MARK_OF_THE_WILD="Improved Mark of the Wild",IMPROVED_REGROWTH="Improved Regrowth",IMPROVED_REJUVENATION="Improved Rejuvenation",IMPROVED_TRANQUILITY="Improved Tranquility",INNERVATE="Innervate",INSECT_SWARM="Insect Swarm",MARK_OF_THE_WILD="Mark of the Wild",NATURES_FOCUS="Nature's Focus",REBIRTH="Rebirth",REFLECTION="Reflection",REGROWTH="Regrowth",REJUVENATION="Rejuvenation",REMOVE_CURSE="Remove Curse",SUBTLETY="Subtlety",TRANQUIL_SPIRIT="Tranquil Spirit",TRANQUILITY="Tranquility",BENEDICTION="Benediction",BLESSING_OF_MIGHT="Blessing of Might",CONVICTION="Conviction",EYE_FOR_AN_EYE="Eye for an Eye",GREATER_BLESSING_OF_MIGHT="Greater Blessing of Might",IMPROVED_BLESSING_OF_MIGHT="Improved Blessing of Might",IMPROVED_JUDGEMENT="Improved Judgement",IMPROVED_RETRIBUTION_AURA="Improved Retribution Aura",IMPROVED_SEAL_OF_THE_CRUSADER="Improved Seal of the Crusader",JUDGEMENT="Judgement",JUDGEMENT_OF_COMMAND="Judgement of Command",JUDGEMENT_OF_THE_CRUSADER="Judgement of the Crusader",PURSUIT_OF_JUSTICE="Pursuit of Justice",REPENTANCE="Repentance",RETRIBUTION_AURA="Retribution Aura",SANCTITY_AURA="Sanctity Aura",SEAL_OF_COMMAND="Seal of Command",SEAL_OF_THE_CRUSADER="Seal of the Crusader",VINDICATION="Vindication",BLACKOUT="Blackout",DARKNESS="Darkness",DEVOURING_PLAGUE="Devouring Plague",FADE="Fade",HEX_OF_WEAKNESS="Hex of Weakness",IMPROVED_FADE="Improved Fade",IMPROVED_MIND_BLAST="Improved Mind Blast",IMPROVED_PSYCHIC_SCREAM="Improved Psychic Scream",IMPROVED_SHADOW_WORD_PAIN="Improved Shadow Word: Pain",IMPROVED_VAMPIRIC_EMBRACE="Improved Vampiric Embrace",MIND_BLAST="Mind Blast",MIND_CONTROL="Mind Control",MIND_FLAY="Mind Flay",MIND_SOOTHE="Mind Soothe",MIND_VISION="Mind Vision",PRAYER_OF_SHADOW_PROTECTION="Prayer of Shadow Protection",PSYCHIC_SCREAM="Psychic Scream",SHADOW_AFFINITY="Shadow Affinity",SHADOW_FOCUS="Shadow Focus",SHADOW_PROTECTION="Shadow Protection",SHADOW_REACH="Shadow Reach",SHADOW_WEAVING="Shadow Weaving",SHADOW_WORD_PAIN="Shadow Word: Pain",SHADOWFORM="Shadowform",SHADOWGUARD="Shadowguard",SILENCE="Silence",SPIRIT_TAP="Spirit Tap",TOUCH_OF_WEAKNESS="Touch of Weakness",VAMPIRIC_EMBRACE="Vampiric Embrace",SHIELD="Shield",STAVES="Staves",BLIND="Blind",CAMOUFLAGE="Camouflage",DETECT_TRAPS="Detect Traps",DISARM_TRAP="Disarm Trap",DISTRACT="Distract",ELUSIVENESS="Elusiveness",GHOSTLY_STRIKE="Ghostly Strike",HEMORRHAGE="Hemorrhage",IMPROVED_AMBUSH="Improved Ambush",IMPROVED_CHEAP_SHOT="Improved Cheap Shot",IMPROVED_DISTRACT="Improved Distract",IMPROVED_GARROTE="Improved Garrote",IMPROVED_RUPTURE="Improved Rupture",IMPROVED_SAP="Improved Sap",IMPROVED_VANISH="Improved Vanish",INITIATIVE="Initiative",MASTER_OF_DECEPTION="Master of Deception",OPPORTUNITY="Opportunity",PICK_POCKET="Pick Pocket",PREMEDITATION="Premeditation",PREPARATION="Preparation",RAPID_CONCEALMENT="Rapid Concealment",SAFE_FALL="Safe Fall",SAP="Sap",SETUP="Setup",STEALTH="Stealth",VANISH="Vanish",VANISHED="Vanished",BASIC_CAMPFIRE="Basic Campfire",BRIGHT_CAMPFIRE="Bright Campfire",CLEVER_TRAPS="Clever Traps",COUNTERATTACK="Counterattack",DETERRENCE="Deterrence",DISENGAGE="Disengage",ENTRAPMENT="Entrapment",EXPLOSIVE_TRAP="Explosive Trap",EXPLOSIVE_TRAP_EFFECT="Explosive Trap Effect",FEIGN_DEATH="Feign Death",FREEZING_TRAP="Freezing Trap",FROST_TRAP="Frost Trap",HUMANOID_SLAYING="Humanoid Slaying",IMMOLATION_TRAP="Immolation Trap",IMMOLATION_TRAP_EFFECT="Immolation Trap Effect",IMPROVED_FEIGN_DEATH="Improved Feign Death",
			IMPROVED_WING_CLIP="Improved Wing Clip",KILLER_INSTINCT="Killer Instinct",MELEE_SPECIALIZATION="Melee Specialization",MONGOOSE_BITE="Mongoose Bite",MONSTER_SLAYING="Monster Slaying",RAPTOR_STRIKE="Raptor Strike",READINESS="Readiness",SAVAGE_STRIKES="Savage Strikes",SUREFOOTED="Surefooted",SURVIVALIST="Survivalist",TRACK_BEASTS="Track Beasts",TRACK_DEMONS="Track Demons",TRACK_DRAGONKIN="Track Dragonkin",TRACK_ELEMENTALS="Track Elementals",TRACK_GIANTS="Track Giants",TRACK_HIDDEN="Track Hidden",TRACK_UNDEAD="Track Undead",TRAP_MASTERY="Trap Mastery",WING_CLIP="Wing Clip",WYVERN_STING="Wyvern Sting",ONE_HANDED_SWORDS="One-Handed Swords",CULTIVATION="Cultivation",ENDURANCE="Endurance",WAR_STOMP="War Stomp",THROW="Throw",THROWN="Thrown",TIGER_RIDING="Tiger Riding",TWO_HANDED_AXES="Two-Handed Axes",TWO_HANDED_MACES="Two-Handed Maces",TWO_HANDED_SWORDS="Two-Handed Swords",UNARMED="Unarmed",UNDEAD_HORSEMANSHIP="Undead Horsemanship",SHOOT="Shoot",WANDS="Wands",WOLF_RIDING="Wolf Riding",
			BLACKSMITHING="Blacksmithing",ARMORSMITH="Armorsmith",WEAPONSMITH="Weaponsmith",ALCHEMY="Alchemy",ENCHANTING="Enchanting",DISENCHANT="Disenchant",ENGINEERING="Engineering",FIND_HERBS="Find Herbs",HERB_GATHERING="Herb Gathering",LEATHERWORKING="Leatherworking",DRAGONSCALE_LEATHERWORKING="Dragonscale Leatherworking",ELEMENTAL_LEATHERWORKING="Elemental Leatherworking",TRIBAL_LEATHERWORKING="Tribal Leatherworking",FIND_MINERALS="Find Minerals",MINING="Mining",SMELTING="Smelting",SKINNING="Skinning",SOULSTONE_RESURRECTION="Soulstone Resurrection",FOOD="Food",DRINK="Drink",ENRICHED_MANNA_BISCUIT="Enriched Manna Biscuit"
		}
	end
elseif locale == "deDE" then
	function initSpells()
		spells = {
			AMPLIFY_CURSE="Fluch verst\195\164rken",CORRUPTION="Verderbnis",CURSE_OF_AGONY="Fluch der Pein",CURSE_OF_DOOM="Fluch der Verdammnis",CURSE_OF_DOOM_EFFECT="Fluch der Verdammnis'-Effekt",CURSE_OF_EXHAUSTION="Fluch der Ersch\195\182pfung",CURSE_OF_IDIOCY="Fluch der Torheit",CURSE_OF_RECKLESSNESS="Fluch der Tollk\195\188hnheit",CURSE_OF_SHADOW="Schattenfluch",CURSE_OF_THE_ELEMENTS="Fluch der Elemente",CURSE_OF_TONGUES="Fluch der Sprachen",CURSE_OF_WEAKNESS="Fluch der Schw\195\164che",DARK_PACT="Dunkler Pakt",DEATH_COIL="Todesmantel",DRAIN_LIFE="Blutsauger",DRAIN_MANA="Mana entziehen",DRAIN_SOUL="Seelendieb",FEAR="Furcht",FEL_CONCENTRATION="Teufelskonzentration",GRIM_REACH="Grimmige Reichweite",HOWL_OF_TERROR="Schreckgeheul",IMPROVED_CORRUPTION="Verbesserte Verderbnis",IMPROVED_CURSE_OF_AGONY="Verbesserter Fluch der Pein",IMPROVED_CURSE_OF_EXHAUSTION="Verbesserter Fluch der Ersch\195\182pfung",IMPROVED_CURSE_OF_WEAKNESS="Verbesserter Fluch der Schw\195\164che",IMPROVED_DRAIN_LIFE="Verbesserter Blutsauger",IMPROVED_DRAIN_MANA="Verbessertes Mana entziehen",IMPROVED_DRAIN_SOUL="Verbesserter Seelendieb",IMPROVED_LIFE_TAP="Verbesserter Aderlass",LIFE_TAP="Aderlass",NIGHTFALL="Einbruch der Nacht",SHADOW_MASTERY="Schattenbeherrschung",SIPHON_LIFE="Lebensentzug",SUPPRESSION="Unterdr\195\188ckung",AMPLIFY_MAGIC="Magie verst\195\164rken",ARCANE_BRILLIANCE="Arkane Brillanz",ARCANE_CONCENTRATION="Arkane Konzentration",ARCANE_EXPLOSION="Arkane Explosion",ARCANE_FOCUS="Arkaner Fokus",ARCANE_INSTABILITY="Arkane Instabilit\195\164t",ARCANE_INTELLECT="Arkane Intelligenz",ARCANE_MEDITATION="Arkane Meditation",ARCANE_MIND="Arkaner Geist",ARCANE_MISSILES="Arkane Geschosse",ARCANE_POWER="Arkane Macht",ARCANE_SUBTLETY="Arkanes Feingef\195\188hl",BLINK="Blinzeln",CLEARCASTING="Freizaubern",CONJURE_FOOD="Essen herbeizaubern",CONJURE_MANA_AGATE="Mana-Achat herbeizaubern",CONJURE_MANA_CITRINE="Mana-Citrin herbeizaubern",CONJURE_MANA_JADE="Mana-Jadestein herbeizaubern",CONJURE_MANA_RUBY="Mana-Rubin herbeizaubern",CONJURE_WATER="Wasser herbeizaubern",COUNTERSPELL="Gegenzauber",DAMPEN_MAGIC="Magied\195\164mpfer",DETECT_MAGIC="Magie entdecken",EVOCATION="Hervorrufung",IMPROVED_ARCANE_EXPLOSION="Verbesserte Arkane Explosion",IMPROVED_ARCANE_MISSILES="Verbesserte arkane Geschosse",IMPROVED_COUNTERSPELL="Verbesserter Gegenzauber",IMPROVED_DAMPEN_MAGIC="Verbesserter Magied\195\164mpfer",IMPROVED_MANA_SHIELD="Verbesserter Manaschild",MAGE_ARMOR="Magische R\195\188stung",MANA_SHIELD="Manaschild",POLYMORPH="Verwandlung",PORTAL_DARNASSUS="Portal: Darnassus",PORTAL_IRONFORGE="Portal: Ironforge",PORTAL_ORGRIMMAR="Portal: Orgrimmar",PORTAL_STORMWIND="Portal: Stormwind",PORTAL_THUNDER_BLUFF="Portal: Thunder Bluff",PORTAL_UNDERCITY="Portal: Undercity",PRESENCE_OF_MIND="Geistesgegenwart",REMOVE_LESSER_CURSE="Geringen Fluch aufheben",SLOW_FALL="Langsamer Fall",TELEPORT_DARNASSUS="Teleportieren: Darnassus",TELEPORT_IRONFORGE="Teleportieren: Ironforge",TELEPORT_ORGRIMMAR="Teleportieren: Orgrimmar",TELEPORT_STORMWIND="Teleportieren: Stormwind",TELEPORT_THUNDER_BLUFF="Teleportieren: Thunder Bluff",TELEPORT_UNDERCITY="Teleportieren: Undercity",WAND_SPECIALIZATION="Zauberstab-Spezialisierung",ANGER_MANAGEMENT="Aggressionskontrolle",AXE_SPECIALIZATION="Axt-Spezialisierung",BATTLE_STANCE="Kampfhaltung",BATTLE_STANCE_PASSIVE="Kampfhaltung Passiv",CHARGE="Sturmangriff",CHARGE_RAGE_BONUS_EFFECT="Wut-Aufladung-Bonus-Effekt",DEEP_WOUNDS="Tiefe Wunden",DEFLECTION="Abwehr",HAMSTRING="Kniesehne",HEROIC_STRIKE="Heldenhafter Sto\195\159",IMPALE="Durchbohren",IMPROVED_CHARGE="Verbesserter Sturmangriff",IMPROVED_HAMSTRING="Verbesserte Kniesehne",IMPROVED_HEROIC_STRIKE="Verbesserter Heldenhafter Sto\195\159",IMPROVED_OVERPOWER="Verbessertes \195\156berw\195\164ltigen",IMPROVED_PUMMEL="Verbessertes Zuschlagen",IMPROVED_REND="Verbessertes Verwunden",IMPROVED_THUNDER_CLAP="Verbesserter Donnerknall",LONG_DAZE="Lange Benommenheit",MACE_SPECIALIZATION="Streitkolben-Spezialisierung",MACE_STUN_EFFECT="Streitkolbenbet\195\164ubung-Effekt",MOCKING_BLOW="Sp\195\182ttischer Schlag",MORTAL_STRIKE="T\195\182dlicher Sto\195\159",OVERPOWER="\195\156berw\195\164ltigen",POLEARM_SPECIALIZATION="Stangenwaffen-Spezialisierung",REND="Verwunden",RETALIATION="Gegenschlag",SWEEPING_STRIKES="Weitreichende St\195\182\195\159e",SWORD_SPECIALIZATION="Schwert-Spezialisierung",TACTICAL_MASTERY="Taktiker",THUNDER_CLAP="Donnerknall",TWO_HANDED_WEAPON_SPECIALIZATION="Zweihandwaffen-Spezialisierung",AMBUSH="Hinterhalt",CHEAP_SHOT="Fieser Trick",COLD_BLOOD="Kaltbl\195\188tigkeit",EVISCERATE="Ausweiden",EXPOSE_ARMOR="R\195\188stung schw\195\164chen",GARROTE="Erdrosseln",IMPROVED_DEADLY_POISON="Verbessertes t\195\182dliches Gift",IMPROVED_EVISCERATE="Verbessertes Ausweiden",IMPROVED_EXPOSE_ARMOR="Verbessertes R\195\188stung schw\195\164chen",IMPROVED_INSTANT_POISON="Verbessertes sofort wirkendes Gift",IMPROVED_KIDNEY_SHOT="Verbesserter Nierenhieb",IMPROVED_SLICE_AND_DICE="Verbessertes Zerh\195\164ckseln",KIDNEY_SHOT="Nierenhieb",LETHALITY="T\195\182dlichkeit",MALICE="T\195\188cke",MURDER="Mord",RELENTLESS_STRIKES="Unerbittliche St\195\182\195\159e",REMORSELESS_ATTACKS="Gnadenlose Angriffe",RUPTURE="Blutung",RUTHLESSNESS="Skrupellosigkeit",SEAL_FATE="Schicksal besiegeln",SLICE_AND_DICE="Zerh\195\164ckseln",VIGOR="Lebenskraft",VILE_POISONS="\195\156ble Gifte",ONE_HANDED_AXES="Einhand\195\164xte",BARKSKIN="Baumrinde",BARKSKIN_EFFECT="Baumrindeneffekt",ENTANGLING_ROOTS="Wucherwurzeln",FAERIE_FIRE="Feenfeuer",HIBERNATE="Winterschlaf",HURRICANE="Hurrikan",IMPROVED_ENTANGLING_ROOTS="Verbesserte Wucherwurzeln",IMPROVED_MOONFIRE="Verbessertes Mondfeuer",IMPROVED_NATURES_GRASP="Verbesserter Griff der Natur",IMPROVED_STARFIRE="Verbessertes Sternenfeuer",IMPROVED_THORNS="Verbesserte Dornen",IMPROVED_WRATH="Verbesserter Zorn",MOONFIRE="Mondfeuer",MOONFURY="Mondfuror",MOONGLOW="Mondschein",MOONKIN_AURA="Aura des Moonkin",MOONKIN_FORM="Moonkingestalt",NATURAL_SHAPESHIFTER="Schnellwandlung",NATURAL_WEAPONS="Waffenbalance",NATURES_GRACE="Anmut der Natur",NATURES_GRASP="Griff der Natur",NATURES_REACH="Reichweite der Natur",OMEN_OF_CLARITY="Omen der Klarsicht",SOOTHE_ANIMAL="Tier bes\195\164nftigen",STARFIRE="Sternenfeuer",TELEPORT_MOONGLADE="Teleportieren: Moonglade",THORNS="Dornen",VENGEANCE="Rache",WRATH="Zorn",ASPECT_OF_THE_BEAST="Aspekt des Wildtiers",ASPECT_OF_THE_CHEETAH="Aspekt des Geparden",ASPECT_OF_THE_HAWK="Aspekt des Falken",ASPECT_OF_THE_MONKEY="Aspekt des Affen",ASPECT_OF_THE_PACK="Aspekt des Rudels",ASPECT_OF_THE_WILD="Aspekt der Wildnis",BEAST_LORE="Wildtierkunde",BESTIAL_DISCIPLINE="Wildtierdisziplin",BESTIAL_SWIFTNESS="Erh\195\182hte Tiergeschwindigkeit",BESTIAL_WRATH="Zorn des Wildtiers",CALL_PET="Tier rufen",DISMISS_PET="Tier freigeben",EAGLE_EYE="Adlerauge",ENDURANCE_TRAINING="Belastbarkeit-Ausbildung",EYES_OF_THE_BEAST="Augen des Wildtiers",FEED_PET="Tier f\195\188ttern",FEROCITY="Wildheit",FRENZY="Raserei",IMPROVED_ASPECT_OF_THE_HAWK="Verbesserter Aspekt des Falken",IMPROVED_ASPECT_OF_THE_MONKEY="Verbesserter Aspekt des Affen",IMPROVED_EYES_OF_THE_BEAST="Verbesserte Augen des Wildtiers",IMPROVED_MEND_PET="Verbessertes Tier heilen",IMPROVED_REVIVE_PET="Verbessertes Tier wiederbeleben",INTIMIDATION="Einsch\195\188chterung",MEND_PET="Tier heilen",PATHFINDING="Orientierung",REVIVE_PET="Tier wiederbeleben",SCARE_BEAST="Wildtier \195\164ngstigen",SPIRIT_BOND="Geistbande",TAME_BEAST="Wildtier z\195\164hmen",THICK_HIDE="Dickes Fell",TRANQUILIZING_SHOT="Einlullender Schuss",UNLEASHED_FURY="Entfesselter Zorn",ARCANE_RESISTANCE="Arkanwiderstand",BEAST_TRAINING="Wildtierausbildung",BITE="Bei\195\159en",CLAW="Klaue",COBRA_REFLEXES="Kobrareflexe",COWER="Ducken",DASH="Spurt",DIVE="Sturzflug",FIRE_RESISTANCE="Feuerwiderstand",FROST_RESISTANCE="Frostwiderstand",FURIOUS_HOWL="Wutgeheul",GREAT_STAMINA="Gro\195\159e Ausdauer",GROWL="Knurren",HARASS="Bel\195\164stigen",LIGHTNING_BREATH="Blitzschlagatem",NATURAL_ARMOR="Nat\195\188rliche R\195\188stung",NATURE_RESISTANCE="Naturwiderstand",PROWL="Schleichen",SCORPID_POISON="Skorpidgift",SCREECH="Schrei",SHADOW_RESISTANCE="Schattenwiderstand",SHELL_SHIELD="Panzerschild",THUNDERSTOMP="Donnerstampfer",BOWS="Bogen",SHOOT_BOW="Bogenschuss",CLOTH="Stoff",ADRENALINE_RUSH="Adrenalinrausch",AGGRESSION="Aggression",BACKSTAB="Meucheln",BLADE_FLURRY="Klingenwirbel",DAGGER_SPECIALIZATION="Dolch-Spezialisierung",DUAL_WIELD_SPECIALIZATION="Beidh\195\164ndigkeits-Spezialisierung",EVASION="Entrinnen",FEINT="Finte",FIST_WEAPON_SPECIALIZATION="Faustwaffen-Spezialisierung",GOUGE="Solarplexus",IMPROVED_BACKSTAB="Verbessertes Meucheln",IMPROVED_EVASION="Verbessertes Entrinnen",IMPROVED_GOUGE="Verbesserter Solarplexus",IMPROVED_KICK="Verbesserter Tritt",IMPROVED_SINISTER_STRIKE="Verbesserter Finsterer Sto\195\159",IMPROVED_SPRINT="Verbessertes Sprinten",KICK="Tritt",LIGHTNING_REFLEXES="Blitzartige Reflexe",PRECISION="Pr\195\164zision",RIPOSTE="Riposte",ROGUE_PASSIVE="Schurke Passiv",SINISTER_STRIKE="Finsterer Sto\195\159",SPRINT="Sprinten",THROWING_WEAPON_SPECIALIZATION="Wurfwaffen-Spezialisierung",CROSSBOWS="Armbr\195\188ste",SHOOT_CROSSBOW="Armbrust abschie\195\159en",DAGGERS="Dolche",BLOCK="Blocken",DEFENSE="Verteidigung",DEFENSIVE_STATE="Verteidigungsstatus",DEFENSIVE_STATE_2="Verteidigungsstatus 2",DODGE="Ausweichen",PARRY="Parieren",SPELLDEFENSE="ZAUBERVERTEIDIGUNG",BANISH="Verbannen",CREATE_FIRESTONE="Feuerstein herstellen",CREATE_HEALTHSTONE="Gesundheitsstein herstellen",CREATE_SOULSTONE="Seelenstein herstellen",CREATE_SPELLSTONE="Zauberstein herstellen",DEMON_ARMOR="D\195\164monenr\195\188stung",DEMON_SKIN="D\195\164monenhaut",DEMONIC_EMBRACE="D\195\164monische Umarmung",DEMONIC_SACRIFICE="D\195\164monische Opferung",DETECT_GREATER_INVISIBILITY="Gro\195\159e Unsichtbarkeit entdecken",DETECT_INVISIBILITY="Unsichtbarkeit entdecken",DETECT_LESSER_INVISIBILITY="Geringe Unsichtbarkeit entdecken",ENSLAVE_DEMON="D\195\164monensklave",EYE_OF_KILROGG="Auge von Kilrogg",FEL_DOMINATION="Teufelsbeherrschung",FEL_INTELLECT="Teufelsintelligenz",FEL_STAMINA="Teufelsausdauer",HEALTH_FUNNEL="Lebenslinie",IMPROVED_ENSLAVE_DEMON="Verbesserter D\195\164monensklave",IMPROVED_FIRESTONE="Verbesserter Feuerstein",IMPROVED_HEALTH_FUNNEL="Verbesserte Lebenslinie",IMPROVED_HEALTHSTONE="Verbesserter Gesundheitsstein",IMPROVED_IMP="Verbesserter Wichtel",IMPROVED_SPELLSTONE="Verbesserter Zauberstein",IMPROVED_SUCCUBUS="Verbesserter Sukkubus",
			IMPROVED_VOIDWALKER="Verbesserter Leerwandler",INFERNO="Inferno",MASTER_DEMONOLOGIST="Meister der D\195\164monologie",MASTER_SUMMONER="Meister der Beschw\195\182rung",RITUAL_OF_DOOM="Ritual der Verdammnis",RITUAL_OF_DOOM_EFFECT="Ritual der Verdammnis'-Effekt",RITUAL_OF_SUMMONING="Ritual der Beschw\195\182rung",SENSE_DEMONS="D\195\164monen sp\195\188ren",SHADOW_WARD="Schattenzauberschutz",SOUL_LINK="Seelenverbindung",SUMMON_DREADSTEED="Schreckensross herbeirufen",SUMMON_FELHUNTER="Teufelsj\195\164ger beschw\195\182ren",SUMMON_FELSTEED="Teufelsross beschw\195\182ren",SUMMON_IMP="Wichtel beschw\195\182ren",SUMMON_SUCCUBUS="Sukkubus beschw\195\182ren",SUMMON_VOIDWALKER="Leerwandler beschw\195\182ren",UNENDING_BREATH="Unendlicher Atem",UNHOLY_POWER="Unheilige Macht",AFTERMATH="Nachwirkung",BANE="Dunkle Macht",CATACLYSM="Katastrophe",CONFLAGRATE="Feuersbrunst",DESTRUCTIVE_REACH="Zerst\195\182rerische Reichweite",DEVASTATION="Verw\195\188stung",EMBERSTORM="Glutsturm",HELLFIRE="H\195\182llenfeuer",HELLFIRE_EFFECT="H\195\182llenfeuer - Effekt",IMMOLATE="Feuerbrand",IMPROVED_FIREBOLT="Verbesserter Feuerblitz",IMPROVED_IMMOLATE="Verbesserter Feuerbrand",IMPROVED_LASH_OF_PAIN="Verbesserte Schmerzenspeitsche",IMPROVED_SEARING_PAIN="Verbesserter Sengender Schmerz",IMPROVED_SHADOW_BOLT="Verbesserter Schattenblitz",INTENSITY="Intensit\195\164t",PYROCLASM="Feuerschwall",RAIN_OF_FIRE="Feuerregen",RUIN="Verderben",SEARING_PAIN="Sengender Schmerz",SHADOW_BOLT="Schattenblitz",SHADOWBURN="Schattenbrand",SOUL_FIRE="Seelenfeuer",DISPEL_MAGIC="Magiebannung",DIVINE_SPIRIT="G\195\182ttlicher Willen",ELUNES_GRACE="Elunes Anmut",FEEDBACK="R\195\188ckkopplung",FOCUSED_CASTING="Fokussiertes Zauberwirken",FORCE_OF_WILL="Macht des Willens",IMPROVED_INNER_FIRE="Verbessertes Inneres Feuer",IMPROVED_MANA_BURN="Verbesserter Manabrand",IMPROVED_POWER_WORD_FORTITUDE="Verbessertes Machtwort: Seelenst\195\164rke",IMPROVED_POWER_WORD_SHIELD="Verbessertes Machtwort: Schild",INNER_FIRE="Inneres Feuer",INNER_FOCUS="Innerer Fokus",LEVITATE="Levitieren",MANA_BURN="Manabrand",MARTYRDOM="M\195\164rtyrertum",MEDITATION="Meditation",MENTAL_AGILITY="Mentale Beweglichkeit",MENTAL_STRENGTH="Mentale St\195\164rke",POWER_INFUSION="Seele der Macht",POWER_WORD_FORTITUDE="Machtwort: Seelenst\195\164rke",POWER_WORD_SHIELD="Machtwort: Schild",PRAYER_OF_FORTITUDE="Gebet der Seelenst\195\164rke",PRAYER_OF_SPIRIT="Gebet der Willenskraft",SHACKLE_UNDEAD="Untote fesseln",SILENT_RESOLVE="Schweigsame Entschlossenheit",STARSHARDS="Sternensplitter",UNBREAKABLE_WILL="Unbezwingbarer Wille",DUAL_WIELD="Beidh\195\164ndigkeit",FIND_TREASURE="Schatzsucher",GUN_SPECIALIZATION="Schusswaffenspezialisierung",STONEFORM="Steingestalt",CALL_OF_FLAME="Ruf der Flamme",CALL_OF_THUNDER="Ruf des Donners",CHAIN_LIGHTNING="Kettenblitzschlag",CONCUSSION="Ersch\195\188tterung",CONVECTION="Konvektion",EARTH_SHOCK="Erdschock",EARTHBIND_TOTEM="Totem der Erdbindung",ELEMENTAL_FOCUS="Elementarfokus",ELEMENTAL_FURY="Elementarfuror",ELEMENTAL_MASTERY="Elementarbeherrschung",FIRE_NOVA_TOTEM="Totem der Feuernova",FLAME_SHOCK="Flammenschock",FROST_SHOCK="Frostschock",IMPROVED_CHAIN_LIGHTNING="Verbesserter Kettenblitzschlag",IMPROVED_FIRE_NOVA_TOTEM="Verbessertes Totem der Feuernova",IMPROVED_LIGHTNING_BOLT="Verbesserter Blitzschlag",IMPROVED_MAGMA_TOTEM="Verbessertes Totem der gl\195\188henden Magma",IMPROVED_SEARING_TOTEM="Verbessertes Totem der Verbrennung",IMPROVED_STONECLAW_TOTEM="Verbessertes Totem der Steinklaue",LIGHTNING_BOLT="Blitzschlag",LIGHTNING_MASTERY="Blitzschlagbeherrschung",MAGMA_TOTEM="Totem der gl\195\188henden Magma",PURGE="Reinigen",REVERBERATION="Nachklingen",SEARING_TOTEM="Totem der Verbrennung",STONECLAW_TOTEM="Totem der Steinklaue",ANCESTRAL_KNOWLEDGE="Wissen der Ahnen",ANTICIPATION="Vorahnung",ASTRAL_RECALL="Astraler R\195\188ckruf",FAR_SIGHT="Fernsicht",FIRE_RESISTANCE_TOTEM="Totem des Feuerwiderstands",FLAMETONGUE_TOTEM="Totem der Flammenzunge",FLAMETONGUE_WEAPON="Waffe der Flammenzunge",FLURRY="Schlaghagel",FROST_RESISTANCE_TOTEM="Totem des Frostwiderstands",FROSTBRAND_WEAPON="Waffe des Frostbrands",GHOST_WOLF="Geisterwolf",GRACE_OF_AIR_TOTEM="Totem der luftgleichen Anmut",GROUNDING_TOTEM="Totem der Erdung",IMPROVED_FLAMETONGUE_WEAPON="Verbesserte Waffe der Flammenzunge",IMPROVED_FROSTBRAND_WEAPON="Verbesserte Waffe des Frostbrands",IMPROVED_GHOST_WOLF="Verbesserter Geisterwolf",IMPROVED_GRACE_OF_AIR_TOTEM="Verbessertes Totem der luftgleichen Anmut",IMPROVED_GROUNDING_TOTEM="Verbessertes Totem der Erdung",IMPROVED_LIGHTNING_SHIELD="Verbesserter Blitzschlag-Schild",IMPROVED_ROCKBITER_WEAPON="Verbesserte Felsbei\195\159erwaffe",IMPROVED_STONESKIN_TOTEM="Verbessertes Totem der Steinhaut",IMPROVED_STRENGTH_OF_EARTH_TOTEM="Verbessertes Totem der Erdst\195\164rke",IMPROVED_WINDFURY_WEAPON="Verbesserte Waffe des Windfurors",LIGHTNING_SHIELD="Blitzschlagschild",NATURE_RESISTANCE_TOTEM="Totem des Naturwiderstands",ROCKBITER_WEAPON="Felsbei\195\159erwaffe",SENTRY_TOTEM="Totem des Wachens",SHIELD_SPECIALIZATION="Schild-Spezialisierung",STONESKIN_TOTEM="Totem der Steinhaut",STORMSTRIKE="Sturmschlag",STRENGTH_OF_EARTH_TOTEM="Totem der Erdst\195\164rke",THUNDERING_STRIKES="Donnernde St\195\182\195\159e",TOUGHNESS="Z\195\164higkeit",TWO_HANDED_AXES_AND_MACES="Zweihand\195\164xte und -Streitkolben",WATER_BREATHING="Wasseratmung",WATER_WALKING="Wasserwandeln",WINDFURY_TOTEM="Totem des Windzorns",WINDFURY_WEAPON="Waffe des Windfurors",WINDWALL_TOTEM="Totem der Windmauer",AQUATIC_FORM="Wassergestalt",BASH="Hieb",BEAR_FORM="B\195\164rengestalt",BLOOD_FRENZY="Blutraserei",BRUTAL_IMPACT="Brutaler Hieb",CAT_FORM="Katzengestalt",CHALLENGING_ROAR="Herausforderndes Gebr\195\188ll",DEMORALIZING_ROAR="Demoralisierendes Gebr\195\188ll",DIRE_BEAR_FORM="Terrorb\195\164rengestalt",ENRAGE="Wutanfall",FELINE_GRACE="Katzenhafte Anmut",FELINE_SWIFTNESS="Katzenhafte Schnelligkeit",FERAL_AGGRESSION="Wilde Aggression",FERAL_CHARGE="Wilde Attacke",FERAL_INSTINCT="Instinkt der Wildnis",FEROCIOUS_BITE="Wilder Biss",FRENZIED_REGENERATION="Rasende Regeneration",HEART_OF_THE_WILD="Herz der Wildnis",IMPROVED_SHRED="Verbessertes Schreddern",LEADER_OF_THE_PACK="Rudelf\195\188hrer",MANGLE="Fleddern",MAUL="Zermalmen",POUNCE="Anspringen",POUNCE_BLEED="Anspringblutung",PREDATORY_STRIKES="Raubtierschl\195\164ge",PRIMAL_FURY="Urfuror",RAKE="Krallenhieb",RAVAGE="Verheeren",RIP="Zerfetzen",SAVAGE_FURY="Ungez\195\164hmte Wut",SHARPENED_CLAWS="Gesch\195\164rfte Klauen",SHRED="Schreddern",SWIPE="Prankenhieb",TIGERS_FURY="Tigerfuror",TRACK_HUMANOIDS="Humanoide aufsp\195\188ren",TRAVEL_FORM="Reisegestalt",BLAST_WAVE="Druckwelle",BURNING_SOUL="Brennende Seele",COMBUSTION="Verbrennung",CRITICAL_MASS="Kritische Masse",FELFIRE="Teufelsfeuer",FIRE_BLAST="Feuerschlag",FIRE_POWER="Feuermacht",FIRE_VULNERABILITY="Feuerverwundbarkeit",FIRE_WARD="Feuerzauberschutz",FIREBALL="Feuerball",FLAME_THROWING="Flammenwerfen",FLAMESTRIKE="Flammensto\195\159",IGNITE="Entz\195\188nden",IMPACT="Einschlag",IMPROVED_FIRE_BLAST="Verbesserter Feuerschlag",IMPROVED_FIRE_WARD="Verbesserter Feuerzauberschutz",IMPROVED_FIREBALL="Verbesserter Feuerball",IMPROVED_FLAMESTRIKE="Verbesserter Flammensto\195\159",IMPROVED_SCORCH="Verbessertes Versengen",INCINERATE="Verbrennen",PYROBLAST="Pyroschlag",SCORCH="Versengen",FISHING="Angeln",FISHING_POLES="Angeln",FIST_WEAPONS="Faustwaffen",ARCTIC_REACH="Arktische Reichweite",BLIZZARD="Blizzard",CHILLED="K\195\164lte",COLD_SNAP="K\195\164lteeinbruch",CONE_OF_COLD="K\195\164ltekegel",FROST_ARMOR="Frostr\195\188stung",FROST_CHANNELING="Frost-Kanalisierung",FROST_NOVA="Frostnova",FROST_WARD="Frostzauberschutz",FROSTBITE="Erfrierung",FROSTBOLT="Frostblitz",ICE_ARMOR="Eisr\195\188stung",ICE_BARRIER="Eis-Barriere",ICE_BLOCK="Eisblock",ICE_SHARDS="Eissplitter",IMPROVED_BLIZZARD="Verbesserter Blizzard",IMPROVED_CONE_OF_COLD="Verbesserter K\195\164ltekegel",IMPROVED_FROST_NOVA="Verbesserte Frostnova",IMPROVED_FROST_WARD="Verbesserter Frostzauberschutz",IMPROVED_FROSTBOLT="Verbesserter Frostblitz",PERMAFROST="Dauerfrost",PIERCING_ICE="Stechendes Eis",SHATTER="Zertr\195\188mmern",WINTERS_CHILL="Winterk\195\164lte",BATTLE_SHOUT="Schlachtruf",BERSERKER_RAGE="Berserkerwut",BERSERKER_STANCE="Berserkerhaltung",BERSERKER_STANCE_PASSIVE="Berserkerhaltung - Passiv",BLOOD_CRAZE="Blutwahnsinn",BLOODTHIRST="Blutdurst",BOOMING_VOICE="Donnernde Stimme",CHALLENGING_SHOUT="Herausforderungsruf",CLEAVE="Spalten",CRUELTY="Grausamkeit",DEATH_WISH="Todeswunsch",DEMORALIZING_SHOUT="Demoralisierungsruf",EXECUTE="Hinrichten",IMPROVED_BATTLE_SHOUT="Verbesserter Schlachtruf",IMPROVED_BERSERKER_RAGE="Verbesserte Berserkerwut",IMPROVED_CHALLENGING_SHOUT="Verbesserter Herausforderungsruf",IMPROVED_CLEAVE="Verbessertes Spalten",IMPROVED_DEMORALIZING_SHOUT="Verbesserter Demoralisierender Ruf",IMPROVED_EXECUTE="Verbessertes Hinrichten",IMPROVED_INTERCEPT="Verbessertes Abfangen",IMPROVED_INTIMIDATING_SHOUT="Verbesserter Drohruf",IMPROVED_SLAM="Verbessertes Zerschmettern",INTERCEPT="Abfangen",INTIMIDATING_SHOUT="Drohruf",PIERCING_HOWL="Durchdringendes Heulen",PUMMEL="Zuschlagen",RECKLESSNESS="Tollk\195\188hnheit",SLAM="Zerschmettern",UNBRIDLED_WRATH="Entfesselter Zorn",UNBRIDLED_WRATH_EFFECT="Entfesselter Zorn'-Effekt",WHIRLWIND="Wirbelwind",ATTACK="Angreifen",ATTACKING="Angreifen",CLOSING="Schlie\195\159en",DETECT="Entdecken",DUEL="Duell",FETISH="Fetisch",GENERIC="Allgemein",GROVEL="Kriechen",HONORLESS_TARGET="Ehrenloses Ziel",LIBRAM="Buchband",OPENING="\195\150ffnen",OPENING___NO_TEXT="\195\150ffnen - Kein Text",REMOVE_INSIGNIA="Abzeichen entfernen",STUCK="Feststecken",TOTEM="Totem",GUNS="Schusswaffen",SHOOT_GUN="Schusswaffe abfeuern",ABOLISH_DISEASE="Krankheit aufheben",BLESSED_RECOVERY="Gesegnete Erholung",CURE_DISEASE="Krankheit heilen",DESPERATE_PRAYER="Verzweifeltes Gebet",DIVINE_FURY="G\195\182ttlicher Furor",FEAR_WARD="Furchtzauberschutz",FLASH_HEAL="Blitzheilung",GREATER_HEAL="Gro\195\159e Heilung",HEAL="Heilen",HEALING_FOCUS="Heilfokus",HOLY_FIRE="Heiliges Feuer",HOLY_NOVA="Heilige Nova",HOLY_REACH="Heilige Reichweite",HOLY_SPECIALIZATION="Macht des Glaubens",IMPROVED_HEALING="Verbesserte Heilung",IMPROVED_PRAYER_OF_HEALING="Verbessertes Gebet der Heilung",IMPROVED_RENEW="Verbesserte Erneuerung",INSPIRATION="Inspiration",LESSER_HEAL="Geringes Heilen",LIGHTWELL="Brunnen des Lichts",LIGHTWELL_RENEW="Erneuerung des Lichtbrunnens",PRAYER_OF_HEALING="Gebet der Heilung",RENEW="Erneuerung",
			RESURRECTION="Auferstehung",SEARING_LIGHT="Sengendes Licht",SMITE="G\195\182ttliche Pein",SPELL_WARDING="Zauberschutz",SPIRIT_OF_REDEMPTION="Geist der Erl\195\182sung",SPIRITUAL_GUIDANCE="Geistige F\195\188hrung",SPIRITUAL_HEALING="Spirituelle Heilung",BLESSING_OF_LIGHT="Segen des Lichts",BLESSING_OF_WISDOM="Segen der Weisheit",CLEANSE="Reinigung des Glaubens",CONSECRATION="Weihe",DIVINE_FAVOR="G\195\182ttliche Gunst",DIVINE_INTELLECT="G\195\182ttliche Weisheit",DIVINE_STRENGTH="G\195\182ttliche St\195\164rke",EXORCISM="Exorzismus",FLASH_OF_LIGHT="Lichtblitz",GREATER_BLESSING_OF_LIGHT="Gro\195\159er Segen des Lichts",GREATER_BLESSING_OF_WISDOM="Gro\195\159er Segen der Weisheit",HAMMER_OF_WRATH="Hammer des Zorns",HEALING_LIGHT="Heilendes Licht",HOLY_LIGHT="Heiliges Licht",HOLY_POWER="Heilige Macht",HOLY_SHOCK="Heiliger Schock",HOLY_WRATH="Heiliger Zorn",ILLUMINATION="Illumination",IMPROVED_BLESSING_OF_WISDOM="Verbesserter Segen der Weisheit",IMPROVED_FLASH_OF_LIGHT="Verbesserter Lichtblitz",IMPROVED_LAY_ON_HANDS="Verbesserte Handauflegung",IMPROVED_SEAL_OF_RIGHTEOUSNESS="Verbessertes Siegel der Rechtschaffenheit",JUDGEMENT_OF_LIGHT="Richturteil des Lichts",JUDGEMENT_OF_RIGHTEOUSNESS="Richturteil der Rechtschaffenheit",JUDGEMENT_OF_WISDOM="Richturteil der Weisheit",LASTING_JUDGEMENT="Dauerhaftes Richturteil",LAY_ON_HANDS="Handauflegung",PURIFY="L\195\164utern",REDEMPTION="Erl\195\182sung",SEAL_OF_LIGHT="Siegel des Lichts",SEAL_OF_RIGHTEOUSNESS="Siegel der Rechtschaffenheit",SEAL_OF_WISDOM="Siegel der Weisheit",SENSE_UNDEAD="Untote sp\195\188ren",SPIRITUAL_FOCUS="Spiritueller Fokus",SUMMON_CHARGER="Streitross beschw\195\182ren",SUMMON_WARHORSE="Schlachtross beschw\195\182ren",TURN_UNDEAD="Untote vertreiben",UNYIELDING_FAITH="Unumst\195\182\195\159licher Glaube",HORSE_RIDING="Pferdreiten",KODO_RIDING="Kodoreiten",LEATHER="Leder",PICK_LOCK="Schloss knacken",ONE_HANDED_MACES="Einhandstreitkolben",MAIL="Panzer",AIMED_SHOT="Gezielter Schuss",ARCANE_SHOT="Arkaner Schuss",AUTO_SHOT="Autom. Schuss",BARRAGE="Sperrfeuer",BLACK_ARROW="Schwarzer Pfeil",CONCUSSIVE_SHOT="Ersch\195\188tternder Schuss",DISTRACTING_SHOT="Ablenkender Schuss",EFFICIENCY="Effizienz",FLARE="Leuchtfeuer",HAWK_EYE="Falkenauge",HUNTERS_MARK="Mal des J\195\164gers",IMPROVED_ARCANE_SHOT="Verbesserter Arkaner Schuss",IMPROVED_CONCUSSIVE_SHOT="Verbesserter Ersch\195\188tternder Schuss",IMPROVED_HUNTERS_MARK="Verbessertes Mal des J\195\164gers",IMPROVED_SCORPID_STING="Verbesserter Skorpidstich",IMPROVED_SERPENT_STING="Verbesserter Schlangenbiss",LETHAL_SHOTS="T\195\182dliche Sch\195\188sse",MORTAL_SHOTS="Todbringende Sch\195\188sse",MULTI_SHOT="Mehrfachschuss",RANGED_WEAPON_SPECIALIZATION="Distanzwaffen-Spezialisierung",RAPID_FIRE="Schnellfeuer",SCATTER_SHOT="Streuschuss",SCORPID_STING="Skorpidstich",SERPENT_STING="Schlangenbiss",TRUESHOT_AURA="Aura des Volltreffers",VIPER_STING="Vipernbiss",VOLLEY="Salve",MECHANOSTRIDER_PILOTING="Roboschreiter-Lenken",QUICKNESS="Schnelligkeit",SHADOWMELD="Schattenhaftigkeit",SHADOWMELD_PASSIVE="Schattenmimik Passiv",WISP_SPIRIT="Irrwisch-Geist",BLOOD_FURY="Kochendes Blut",COMMAND="Befehlsgewalt",HARDINESS="Z\195\164higkeit",TAMED_PET_PASSIVE="Gez\195\164hmtes Tier - Passiv",ACTIVATE_MG_TURRET="MG-Turm aktivieren",FLAMETHROWER="Flammenwerfer",DEVOUR_MAGIC="Magie verschlingen",DEVOUR_MAGIC_EFFECT="Magie verschlingen' - Effekt",PARANOIA="Paranoia",SPELL_LOCK="Zaubersperre",TAINTED_BLOOD="Besudeltes Blut",PET_AGGRESSION="Tieraggression",PET_HARDINESS="Tier-Widerstandskraft",PET_RECOVERY="Tiererholung",PET_RESISTANCE="Tier-Widerstand",BLOOD_PACT="Blutpakt",FIRE_SHIELD="Feuerschild",FIREBOLT="Feuerblitz",PHASE_SHIFT="Phasenverschiebung",LASH_OF_PAIN="Schmerzenspeitsche",LESSER_INVISIBILITY="Geringe Unsichtbarkeit",SEDUCTION="Verf\195\188hrung",SOOTHING_KISS="Bes\195\164nftigender Kuss",CONSUME_SHADOWS="Schatten verzehren",SACRIFICE="Opferung",SUFFERING="Leiden",TORMENT="Qual",PLATE_MAIL="Plattenpanzer",BLINDING_POWDER="Blendungspulver",CRIPPLING_POISON="Verkr\195\188ppelndes Gift",CRIPPLING_POISON_II="Verkr\195\188ppelndes Gift II",DEADLY_POISON="T\195\182dliches Gift",DEADLY_POISON_II="T\195\182dliches Gift II",DEADLY_POISON_III="T\195\182dliches Gift III",DEADLY_POISON_IV="T\195\182dliches Gift IV",DEADLY_POISON_V="T\195\182dliches Gift V",INSTANT_POISON="Sofort wirkendes Gift",INSTANT_POISON_II="Sofort wirkendes Gift II",INSTANT_POISON_III="Sofort wirkendes Gift III",INSTANT_POISON_IV="Sofort wirkendes Gift IV",INSTANT_POISON_V="Sofort wirkendes Gift V",INSTANT_POISON_VI="Sofort wirkendes Gift VI",MIND_NUMBING_POISON="Gedankenbenebelndes Gift",MIND_NUMBING_POISON_II="Gedankenbenebelndes Gift II",MIND_NUMBING_POISON_III="Gedankenbenebelndes Gift III",POISONS="Gifte",WOUND_POISON="Wundgift",WOUND_POISON_II="Wundgift II",WOUND_POISON_III="Wundgift III",WOUND_POISON_IV="Wundgift IV",POLEARMS="Stangenwaffen",BLOODRAGE="Blutrausch",CONCUSSION_BLOW="Ersch\195\188tternder Schlag",DEFENSIVE_STANCE="Verteidigungshaltung",DEFENSIVE_STANCE_PASSIVE="Verteidigungshaltung - Passiv",DEFIANCE="Trotz",DISARM="Entwaffnen",IMPROVED_BLOODRAGE="Verbesserter Blutrausch",IMPROVED_DISARM="Verbessertes Entwaffnen",IMPROVED_REVENGE="Verbesserte Rache",IMPROVED_SHIELD_BASH="Verbesserter Schildhieb",IMPROVED_SHIELD_BLOCK="Verbesserter Schildblock",IMPROVED_SHIELD_WALL="Verbesserter Schildwall",IMPROVED_SUNDER_ARMOR="Verbessertes R\195\188stung zerrei\195\159en",IMPROVED_TAUNT="Verbesserter Spott",IRON_WILL="Eiserner Wille",LAST_STAND="Letztes Gefecht",ONE_HANDED_WEAPON_SPECIALIZATION="Einhandwaffen-Spezialisierung",REVENGE="Rache",REVENGE_STUN="Rachebet\195\164ubung",SHIELD_BASH="Schildhieb",SHIELD_BLOCK="Schildblock",SHIELD_SLAM="Schildschlag",SHIELD_WALL="Schildwall",SUNDER_ARMOR="R\195\188stung zerrei\195\159en",TAUNT="Spott",BLESSING_OF_FREEDOM="Segen der Freiheit",BLESSING_OF_KINGS="Segen der K\195\182nige",BLESSING_OF_PROTECTION="Segen des Schutzes",BLESSING_OF_SACRIFICE="Segen der Opferung",BLESSING_OF_SALVATION="Segen der Rettung",BLESSING_OF_SANCTUARY="Segen des Refugiums",CONCENTRATION_AURA="Aura der Konzentration",DEVOTION_AURA="Aura der Hingabe",DIVINE_INTERVENTION="G\195\182ttliches Eingreifen",DIVINE_PROTECTION="G\195\182ttlicher Schutz",DIVINE_SHIELD="Gottesschild",FIRE_RESISTANCE_AURA="Aura des Feuerwiderstands",FROST_RESISTANCE_AURA="Aura des Frostwiderstands",GREATER_BLESSING_OF_KINGS="Gro\195\159er Segen der K\195\182nige",GREATER_BLESSING_OF_SALVATION="Gro\195\159er Segen der Rettung",GREATER_BLESSING_OF_SANCTUARY="Gro\195\159er Segen des Refugiums",GUARDIANS_FAVOR="Gunst des H\195\188ters",HAMMER_OF_JUSTICE="Hammer der Gerechtigkeit",HOLY_SHIELD="Heiliger Schild",IMPROVED_CONCENTRATION_AURA="Verbesserte Aura der Konzentration",IMPROVED_DEVOTION_AURA="Verbesserte Aura der Hingabe",IMPROVED_HAMMER_OF_JUSTICE="Verbesserter Hammer der Gerechtigkeit",IMPROVED_RIGHTEOUS_FURY="Verbesserter Zorn der Gerechtigkeit",JUDGEMENT_OF_JUSTICE="Richturteil der Gerechtigkeit",RECKONING="Abrechnung",REDOUBT="Verschanzen",RIGHTEOUS_FURY="Zorn der Gerechtigkeit",SEAL_OF_JUSTICE="Siegel der Gerechtigkeit",SHADOW_RESISTANCE_AURA="Aura des Schattenwiderstands",ENGINEERING_SPECIALIZATION="Technologist",ESCAPE_ARTIST="Entfesselungsk\195\188nstler",EXPANSIVE_MIND="Wacher Geist",DIPLOMACY="Diplomatie",PERCEPTION="Wachsamkeit",THE_HUMAN_SPIRIT="Unbeugsamkeit",BEAST_SLAYING="Wildtierschl\195\164chter",BERSERKING="Berserker",BOW_SPECIALIZATION="Bogenspezialisierung",REGENERATION="Regeneration",THROWING_SPECIALIZATION="Wurfwaffen-Spezialisierung",CANNIBALIZE="Kannibalismus",UNDERWATER_BREATHING="Unterwasseratmung",WILL_OF_THE_FORSAKEN="Wille der Verlassenen",RAM_RIDING="Widderreiten",RAPTOR_RIDING="Raptorreiten",ANCESTRAL_HEALING="Heilung der Ahnen",ANCESTRAL_SPIRIT="Geist der Ahnen",CHAIN_HEAL="Kettenheilung",COMBAT_ENDURANCE="Durchhalteverm\195\182gen des K\195\164mpfers",CURE_POISON="Vergiftung heilen",DISEASE_CLEANSING_TOTEM="Totem der Krankheitsreinigung",EVENTIDE="Abendzeit",HEALING_STREAM_TOTEM="Totem des heilenden Flusses",HEALING_WAVE="Welle der Heilung",IMPROVED_CHAIN_HEAL="Verbesserte Kettenheilung",IMPROVED_HEALING_STREAM_TOTEM="Verbessertes Totem des heilenden Flusses",IMPROVED_HEALING_WAVE="Verbesserte Welle der Heilung",IMPROVED_LESSER_HEALING_WAVE="Verbesserte Geringe Welle der Heilung",IMPROVED_MANA_SPRING_TOTEM="Verbessertes Totem der Manaquelle",IMPROVED_REINCARNATION="Verbesserte Reinkarnation",LESSER_HEALING_WAVE="Geringe Welle der Heilung",MANA_SPRING_TOTEM="Totem der Manaquelle",MANA_TIDE_TOTEM="Totem der Manaflut",NATURES_SWIFTNESS="Schnelligkeit der Natur",POISON_CLEANSING_TOTEM="Totem der Giftreinigung",PURIFICATION="L\195\164uterung",REINCARNATION="Reinkarnation",TIDAL_FOCUS="Gezeitenfokus",TIDAL_MASTERY="Gezeitenbeherrschung",TOTEMIC_FOCUS="Totemfokus",TRANQUIL_AIR_TOTEM="Totem der beruhigenden Winde",TREMOR_TOTEM="Totem des Erdsto\195\159es",ABOLISH_POISON="Vergiftung aufheben",ABOLISH_POISON_EFFECT="Vergiftung aufheben - Effekt",FUROR="Ingrimm",GIFT_OF_NATURE="Geschenk der Natur",GIFT_OF_THE_WILD="Gabe der Wildnis",HEALING_TOUCH="Heilende Ber\195\188hrung",IMPROVED_ENRAGE="Verbesserter Wutanfall",IMPROVED_HEALING_TOUCH="Verbesserte Heilende Ber\195\188hrung",IMPROVED_MARK_OF_THE_WILD="Verbessertes Mal der Wildnis",IMPROVED_REGROWTH="Verbessertes Nachwachsen",IMPROVED_REJUVENATION="Verbesserte Verj\195\188ngung",IMPROVED_TRANQUILITY="Verbesserte Gelassenheit",INNERVATE="Anregen",INSECT_SWARM="Insektenschwarm",MARK_OF_THE_WILD="Mal der Wildnis",NATURES_FOCUS="Naturfokus",REBIRTH="Wiedergeburt",REFLECTION="Reflexion",REGROWTH="Nachwachsen",REJUVENATION="Verj\195\188ngung",REMOVE_CURSE="Fluch aufheben",SUBTLETY="Feingef\195\188hl",TRANQUIL_SPIRIT="Gelassener Geist",TRANQUILITY="Gelassenheit",BENEDICTION="Segnung",BLESSING_OF_MIGHT="Segen der Macht",CONVICTION="\195\156berzeugung",EYE_FOR_AN_EYE="Auge um Auge",GREATER_BLESSING_OF_MIGHT="Gro\195\159er Segen der Macht",IMPROVED_BLESSING_OF_MIGHT="Verbesserter Segen der Macht",IMPROVED_JUDGEMENT="Verbessertes Richturteil",IMPROVED_RETRIBUTION_AURA="Verbesserte Aura der Vergeltung",IMPROVED_SEAL_OF_THE_CRUSADER="Verbessertes Siegel des Kreuzfahrers",JUDGEMENT="Richturteil",JUDGEMENT_OF_COMMAND="Richturteil des Befehls",JUDGEMENT_OF_THE_CRUSADER="Richturteil des Kreuzfahrers",PURSUIT_OF_JUSTICE="Streben nach Gerechtigkeit",REPENTANCE="Bu\195\159e",RETRIBUTION_AURA="Aura der Vergeltung",
			SANCTITY_AURA="Aura der Heiligkeit",SEAL_OF_COMMAND="Siegel des Befehls",SEAL_OF_THE_CRUSADER="Siegel des Kreuzfahrers",VINDICATION="Rechtschaffene Schw\195\164chung",BLACKOUT="Blackout",DARKNESS="Dunkelheit",DEVOURING_PLAGUE="Verschlingende Seuche",FADE="Verblassen",HEX_OF_WEAKNESS="Verhexung der Schw\195\164che",IMPROVED_FADE="Verbessertes Verblassen",IMPROVED_MIND_BLAST="Verbesserter Gedankenschlag",IMPROVED_PSYCHIC_SCREAM="Verbesserter Psychischer Schrei",IMPROVED_SHADOW_WORD_PAIN="Verbessertes Schattenwort: Schmerz",IMPROVED_VAMPIRIC_EMBRACE="Verbesserte Vampirumarmung",MIND_BLAST="Gedankenschlag",MIND_CONTROL="Gedankenkontrolle",MIND_FLAY="Gedankenschinden",MIND_SOOTHE="Gedankenbes\195\164nftigung",MIND_VISION="Gedankensicht",PRAYER_OF_SHADOW_PROTECTION="Gebet des Schattenschutzes",PSYCHIC_SCREAM="Psychischer Schrei",SHADOW_AFFINITY="Schattenaffinit\195\164t",SHADOW_FOCUS="Schattenfokus",SHADOW_PROTECTION="Schattenschutz",SHADOW_REACH="Schattenreichweite",SHADOW_WEAVING="Schattenwirken",SHADOW_WORD_PAIN="Schattenwort: Schmerz",SHADOWFORM="Schattengestalt",SHADOWGUARD="Schattenschild",SILENCE="Stille",SPIRIT_TAP="Willensentzug",TOUCH_OF_WEAKNESS="Ber\195\188hrung der Schw\195\164che",VAMPIRIC_EMBRACE="Vampirumarmung",SHIELD="Schild",STAVES="St\195\164be",BLIND="Blenden",CAMOUFLAGE="Tarnung",DETECT_TRAPS="Fallen entdecken",DISARM_TRAP="Falle entsch\195\164rfen",DISTRACT="Ablenken",ELUSIVENESS="Fl\195\188chtigkeit",GHOSTLY_STRIKE="Geisterhafter Sto\195\159",HEMORRHAGE="Blutsturz",IMPROVED_AMBUSH="Verbesserter Hinterhalt",IMPROVED_CHEAP_SHOT="Verbesserter Fieser Trick",IMPROVED_DISTRACT="Verbessertes Ablenken",IMPROVED_GARROTE="Verbessertes Erdrosseln",IMPROVED_RUPTURE="Verbesserte Blutung",IMPROVED_SAP="Verbesserte Kopfnuss",IMPROVED_VANISH="Verbessertes Verschwinden",INITIATIVE="Initiative",MASTER_OF_DECEPTION="Meister der T\195\164uschung",OPPORTUNITY="G\195\188nstige Gelegenheit",PICK_POCKET="Taschendiebstahl",PREMEDITATION="Konzentration",PREPARATION="Vorbereitung",RAPID_CONCEALMENT="Schnelles Verstecken",SAFE_FALL="Sicheres Fallen",SAP="Kopfnuss",SETUP="Reinlegen",STEALTH="Verstohlenheit",VANISH="Verschwinden",VANISHED="Verschwunden",BASIC_CAMPFIRE="Einfaches Lagerfeuer",BRIGHT_CAMPFIRE="Helles Lagerfeuer",CLEVER_TRAPS="Falleneffizienz",COUNTERATTACK="Gegenangriff",DETERRENCE="Abschreckung",DISENGAGE="R\195\188ckzug",ENTRAPMENT="Einfangen",EXPLOSIVE_TRAP="Sprengfalle",EXPLOSIVE_TRAP_EFFECT="Sprengfalle'-Effekt",FEIGN_DEATH="Totstellen",FREEZING_TRAP="Eisk\195\164ltefalle",FROST_TRAP="Frostfalle",HUMANOID_SLAYING="Humanoident\195\182ten",IMMOLATION_TRAP="Feuerbrandfalle",IMMOLATION_TRAP_EFFECT="Feuerbrandfalle",IMPROVED_FEIGN_DEATH="Verbessertes Totstellen",IMPROVED_WING_CLIP="Verbessertes Zurechtstutzen",KILLER_INSTINCT="T\195\182tungstrieb",MELEE_SPECIALIZATION="Nahkampf-Spezialisierung",MONGOOSE_BITE="Mungobiss",MONSTER_SLAYING="Monstert\195\182ten",RAPTOR_STRIKE="Raptorsto\195\159",READINESS="Bereitschaft",SAVAGE_STRIKES="Wilde Schl\195\164ge",SUREFOOTED="Sicherer Stand",SURVIVALIST="\195\156berlebensk\195\188nstler",TRACK_BEASTS="Wildtiere aufsp\195\188ren",TRACK_DEMONS="D\195\164monen aufsp\195\188ren",TRACK_DRAGONKIN="Drachkin aufsp\195\188ren",TRACK_ELEMENTALS="Elementare aufsp\195\188ren",TRACK_GIANTS="Riesen aufsp\195\188ren",TRACK_HIDDEN="Verborgenes aufsp\195\188ren",TRACK_UNDEAD="Untote aufsp\195\188ren",TRAP_MASTERY="Fallenbeherrschung",WING_CLIP="Zurechtstutzen",WYVERN_STING="Stich des Fl\195\188geldrachen",ONE_HANDED_SWORDS="Einhandschwerter",CULTIVATION="Gr\195\188ner Daumen",ENDURANCE="Durchhalteverm\195\182gen",WAR_STOMP="Kriegsdonner",THROW="Werfen",THROWN="Wurfwaffe",TIGER_RIDING="Tigerreiten",TWO_HANDED_AXES="Zweihand\195\164xte",TWO_HANDED_MACES="Zweihandstreitkolben",TWO_HANDED_SWORDS="Zweihandschwerter",UNARMED="Unbewaffnet",UNDEAD_HORSEMANSHIP="Untotenreitkunst",SHOOT="Schie\195\159en",WANDS="Zauberst\195\164be",WOLF_RIDING="Wolfreiten",
			BLACKSMITHING="Schmiedekunst",ARMORSMITH="R\195\188stungsschmied",WEAPONSMITH="Waffenschmied",ALCHEMY="Alchimie",ENCHANTING="Verzauberkunst",DISENCHANT="Entzaubern",ENGINEERING="Ingenieurskunst",FIND_HERBS="Kr\195\164utersuche",HERB_GATHERING="Kr\195\164utersammeln",LEATHERWORKInG="Lederverarbeitung",DRAGONSCALE_LEATHERWORKING="Drachenschuppenlederverarbeitung",ELEMENTAL_LEATHERWORKING="Elementarlederverarbeitung",TRIBAL_LEATHERWORKING="Stammeslederverarbeitung",FIND_MINERALS="Mineraliensuche",MINING="Bergbau",SMELTING="Verh\195\188ttung",SKINNING="K\195\188rschnerei",SOULSTONE_RESURRECTION="Seelenstein-Auferstehung",FOOD="Essen",DRINK="Trinken",ENRICHED_MANNA_BISCUIT="Angereicherter Manakeks"
		}
	end
elseif locale == "frFR" then
	function initSpells()
		spells = {
			AMPLIFY_CURSE="Mal\195\169diction amplifi\195\169e",CORRUPTION="Corruption",CURSE_OF_AGONY="Mal\195\169diction d'agonie",CURSE_OF_DOOM="Mal\195\169diction funeste",CURSE_OF_DOOM_EFFECT="Effet Mal\195\169diction funeste",CURSE_OF_EXHAUSTION="Mal\195\169diction de fatigue",CURSE_OF_IDIOCY="Mal\195\169diction d'idiotie",CURSE_OF_RECKLESSNESS="Mal\195\169diction de t\195\169m\195\169rit\195\169",CURSE_OF_SHADOW="Mal\195\169diction de l'ombre",CURSE_OF_THE_ELEMENTS="Mal\195\169diction des \195\169l\195\169ments",CURSE_OF_TONGUES="Mal\195\169diction des langages",CURSE_OF_WEAKNESS="Mal\195\169diction de faiblesse",DARK_PACT="Pacte noir",DEATH_COIL="Voile mortel",DRAIN_LIFE="Drain de vie",DRAIN_MANA="Drain de mana",DRAIN_SOUL="Siphon d'\195\162me",FEAR="Peur",FEL_CONCENTRATION="Concentration corrompue",GRIM_REACH="Allonge sinistre",HOWL_OF_TERROR="Hurlement de terreur",IMPROVED_CORRUPTION="Corruption am\195\169lior\195\169e",IMPROVED_CURSE_OF_AGONY="Mal\195\169diction d'agonie am\195\169lior\195\169e",IMPROVED_CURSE_OF_EXHAUSTION="Mal\195\169diction de fatigue am\195\169lior\195\169e",IMPROVED_CURSE_OF_WEAKNESS="Mal\195\169diction de faiblesse am\195\169lior\195\169e",IMPROVED_DRAIN_LIFE="Drain de vie am\195\169lior\195\169",IMPROVED_DRAIN_MANA="Drain de mana am\195\169lior\195\169",IMPROVED_DRAIN_SOUL="Siphon d'\195\162me am\195\169lior\195\169",IMPROVED_LIFE_TAP="Connexion am\195\169lior\195\169e",LIFE_TAP="Connexion",NIGHTFALL="Cr\195\169puscule",SHADOW_MASTERY="Ma\195\174trise de l'ombre",SIPHON_LIFE="Siphon de vie",SUPPRESSION="Suppression",AMPLIFY_MAGIC="Amplification de la magie",ARCANE_BRILLIANCE="Illumination des arcanes",ARCANE_CONCENTRATION="Concentration des arcanes",ARCANE_EXPLOSION="Explosion des arcanes",ARCANE_FOCUS="Focalisation des arcanes",ARCANE_INSTABILITY="Instabilit\195\169 des arcanes",ARCANE_INTELLECT="Intelligence des arcanes",ARCANE_MEDITATION="M\195\169ditation des arcanes",ARCANE_MIND="Esprit des arcanes",ARCANE_MISSILES="Projectiles des arcanes",ARCANE_POWER="Pouvoir des arcanes",ARCANE_SUBTLETY="Subtilit\195\169 des arcanes",BLINK="Transfert",CLEARCASTING="Id\195\169es claires",CONJURE_FOOD="Invocation de nourriture",CONJURE_MANA_AGATE="Invocation d'une agate de mana",CONJURE_MANA_CITRINE="Invocation d'une citrine de mana",CONJURE_MANA_JADE="Invocation d'une jade de mana",CONJURE_MANA_RUBY="Invocation d'un rubis de mana",CONJURE_WATER="Invocation d'eau",COUNTERSPELL="Contresort",DAMPEN_MAGIC="Att\195\169nuation de la magie",DETECT_MAGIC="D\195\169tection de la magie",EVOCATION="Evocation",IMPROVED_ARCANE_EXPLOSION="Explosion des arcanes am\195\169lior\195\169e",IMPROVED_ARCANE_MISSILES="Projectiles des arcanes am\195\169lior\195\169s",IMPROVED_COUNTERSPELL="Contresort am\195\169lior\195\169",IMPROVED_DAMPEN_MAGIC="Att\195\169nuation de la magie am\195\169lior\195\169e",IMPROVED_MANA_SHIELD="Bouclier de mana am\195\169lior\195\169",MAGE_ARMOR="Armure du mage",MANA_SHIELD="Bouclier de mana",POLYMORPH="M\195\169tamorphose",PORTAL_DARNASSUS="Portail : Darnassus",PORTAL_IRONFORGE="Portail : Ironforge",PORTAL_ORGRIMMAR="Portail : Orgrimmar",PORTAL_STORMWIND="Portail\194\160: Stormwind",PORTAL_THUNDER_BLUFF="Portail : Thunder Bluff",PORTAL_UNDERCITY="Portail : Undercity",PRESENCE_OF_MIND="Pr\195\169sence spirituelle",REMOVE_LESSER_CURSE="D\195\169livrance de la mal\195\169diction mineure",SLOW_FALL="Chute lente",TELEPORT_DARNASSUS="T\195\169l\195\169portation\194\160: Darnassus",TELEPORT_IRONFORGE="T\195\169l\195\169portation\194\160: Ironforge",TELEPORT_ORGRIMMAR="T\195\169l\195\169portation\194\160: Orgrimmar",TELEPORT_STORMWIND="T\195\169l\195\169portation\194\160: Stormwind",TELEPORT_THUNDER_BLUFF="T\195\169l\195\169portation\194\160: Thunder Bluff",TELEPORT_UNDERCITY="T\195\169l\195\169portation\194\160: Undercity",WAND_SPECIALIZATION="Sp\195\169cialisation Baguette",ANGER_MANAGEMENT="Ma\195\174trise de la Rage",AXE_SPECIALIZATION="Sp\195\169cialisation Hache",BATTLE_STANCE="Posture de combat",BATTLE_STANCE_PASSIVE="Posture de combat",CHARGE="Charge",CHARGE_RAGE_BONUS_EFFECT="Effet Bonus de Rage de la Charge",DEEP_WOUNDS="Blessures profondes",DEFLECTION="D\195\169viation",HAMSTRING="Brise-genou",HEROIC_STRIKE="Frappe h\195\169ro\195\175que",IMPALE="Empaler",IMPROVED_CHARGE="Charge am\195\169lior\195\169e",IMPROVED_HAMSTRING="Brise-genou am\195\169lior\195\169",IMPROVED_HEROIC_STRIKE="Frappe h\195\169ro\195\175que am\195\169lior\195\169e",IMPROVED_OVERPOWER="Fulgurance am\195\169lior\195\169e",IMPROVED_PUMMEL="Vol\195\169e de coups am\195\169lior\195\169e",IMPROVED_REND="Pourfendre am\195\169lior\195\169",IMPROVED_THUNDER_CLAP="Coup de tonnerre am\195\169lior\195\169",LONG_DAZE="H\195\169b\195\169tement prolong\195\169",MACE_SPECIALIZATION="Sp\195\169cialisation Masse",MACE_STUN_EFFECT="Effet \195\169tourdissant de la masse",MOCKING_BLOW="Coup railleur",MORTAL_STRIKE="Frappe mortelle",OVERPOWER="Fulgurance",POLEARM_SPECIALIZATION="Sp\195\169cialisation Arme d'hast",REND="Pourfendre",RETALIATION="Repr\195\169sailles",SWEEPING_STRIKES="Attaques circulaires",SWORD_SPECIALIZATION="Sp\195\169cialisation Ep\195\169e",TACTICAL_MASTERY="Ma\195\174trise tactique",THUNDER_CLAP="Coup de tonnerre",TWO_HANDED_WEAPON_SPECIALIZATION="Sp\195\169cialisation Arme 2M",AMBUSH="Embuscade",CHEAP_SHOT="Coup bas",COLD_BLOOD="Sang froid",EVISCERATE="Evisc\195\169ration",EXPOSE_ARMOR="Exposer l'armure",GARROTE="Garrot",IMPROVED_DEADLY_POISON="Poison mortel am\195\169lior\195\169",IMPROVED_EVISCERATE="Evisc\195\169ration am\195\169lior\195\169e",IMPROVED_EXPOSE_ARMOR="Exposer l'armure am\195\169lior\195\169",IMPROVED_INSTANT_POISON="Poison instantan\195\169 am\195\169lior\195\169",IMPROVED_KIDNEY_SHOT="Aiguillon perfide am\195\169lior\195\169",IMPROVED_SLICE_AND_DICE="D\195\169biter am\195\169lior\195\169",KIDNEY_SHOT="Aiguillon perfide",LETHALITY="Mortalit\195\169",MALICE="Malice",MURDER="Meurtre",RELENTLESS_STRIKES="Frappes implacables",REMORSELESS_ATTACKS="Attaques impitoyables",RUPTURE="Rupture",RUTHLESSNESS="N\195\169m\195\169sis",SEAL_FATE="Scelle le destin",SLICE_AND_DICE="D\195\169biter",VIGOR="Vigueur",VILE_POISONS="Poisons abominables",ONE_HANDED_AXES="Haches \195\160 une main",BARKSKIN="Ecorce",BARKSKIN_EFFECT="Effet Ecorce",ENTANGLING_ROOTS="Sarments",FAERIE_FIRE="Lucioles",HIBERNATE="Hibernation",HURRICANE="Ouragan",IMPROVED_ENTANGLING_ROOTS="Sarments am\195\169lior\195\169s",IMPROVED_MOONFIRE="Eclat lunaire am\195\169lior\195\169",IMPROVED_NATURES_GRASP="Emprise de la nature am\195\169lior\195\169e",IMPROVED_STARFIRE="Feu stellaire am\195\169lior\195\169",IMPROVED_THORNS="Epines am\195\169lior\195\169es",IMPROVED_WRATH="Col\195\168re am\195\169lior\195\169e",MOONFIRE="Eclat lunaire",MOONFURY="Fureur lunaire",MOONGLOW="Lueur de la lune",MOONKIN_AURA="Aura de s\195\169l\195\169nien",MOONKIN_FORM="Forme de s\195\169l\195\169nien",NATURAL_SHAPESHIFTER="Changeforme naturel",NATURAL_WEAPONS="Armes naturelles",NATURES_GRACE="Gr\195\162ce de la nature",NATURES_GRASP="Emprise de la nature",NATURES_REACH="Allonge de la Nature",OMEN_OF_CLARITY="Augure de clart\195\169",SOOTHE_ANIMAL="Apaiser les animaux",STARFIRE="Feu stellaire",TELEPORT_MOONGLADE="T\195\169l\195\169portation\194\160: Reflet-de-Lune",THORNS="Epines",VENGEANCE="Vengeance",WRATH="Col\195\168re",ASPECT_OF_THE_BEAST="Aspect de la b\195\170te",ASPECT_OF_THE_CHEETAH="Aspect du gu\195\169pard",ASPECT_OF_THE_HAWK="Aspect du faucon",ASPECT_OF_THE_MONKEY="Aspect du singe",ASPECT_OF_THE_PACK="Aspect de la meute",ASPECT_OF_THE_WILD="Aspect de la nature",BEAST_LORE="Connaissance des b\195\170tes",BESTIAL_DISCIPLINE="Discipline bestiale",BESTIAL_SWIFTNESS="Rapidit\195\169 bestiale",BESTIAL_WRATH="Courroux bestial",CALL_PET="Appel du familier",DISMISS_PET="Renvoyer le familier",EAGLE_EYE="Oeil d'aigle",ENDURANCE_TRAINING="Entra\195\174nement \195\160 l'Endurance",EYES_OF_THE_BEAST="Oeil de la b\195\170te",FEED_PET="Nourrir le familier",FEROCITY="Ferocit\195\169",FRENZY="Fr\195\169n\195\169sie",IMPROVED_ASPECT_OF_THE_HAWK="Aspect du faucon am\195\169lior\195\169",IMPROVED_ASPECT_OF_THE_MONKEY="Aspect du singe am\195\169lior\195\169",IMPROVED_EYES_OF_THE_BEAST="Oeil de la b\195\170te am\195\169lior\195\169",IMPROVED_MEND_PET="Gu\195\169rison du familier am\195\169lior\195\169e",IMPROVED_REVIVE_PET="Ressusciter le familier am\195\169lior\195\169",INTIMIDATION="Intimidation",MEND_PET="Gu\195\169rison du familier",PATHFINDING="Science des chemins",REVIVE_PET="Ressusciter le familier",SCARE_BEAST="Effrayer une b\195\170te",SPIRIT_BOND="Engagement spirituel",TAME_BEAST="Dompte une b\195\170te",THICK_HIDE="Peau \195\169paisse",TRANQUILIZING_SHOT="Tir tranquillisant",UNLEASHED_FURY="Fureur lib\195\169r\195\169e",ARCANE_RESISTANCE="R\195\169sistance aux Arcanes",BEAST_TRAINING="Apprivoisement",BITE="Morsure",CLAW="Griffe",COBRA_REFLEXES="R\195\169flexes du cobra",COWER="D\195\169robade",DASH="C\195\169l\195\169rit\195\169",DIVE="Plongeon",FIRE_RESISTANCE="R\195\169sistance au Feu",FROST_RESISTANCE="R\195\169sistance au Givre",FURIOUS_HOWL="Hurlement furieux",GREAT_STAMINA="Endurance sup\195\169rieure",GROWL="Grondement",HARASS="Harc\195\168lement",LIGHTNING_BREATH="Souffle de foudre",NATURAL_ARMOR="Armure naturelle",NATURE_RESISTANCE="R\195\169sistance \195\160 la Nature",PROWL="R\195\180der",SCORPID_POISON="Poison de scorpide",SCREECH="Hurlement",SHADOW_RESISTANCE="R\195\169sistance \195\160 l'Ombre",SHELL_SHIELD="Carapace bouclier",THUNDERSTOMP="Grondeterre",BOWS="Arcs",SHOOT_BOW="Tir \195\160 l'arc",CLOTH="Tissu",ADRENALINE_RUSH="Pouss\195\169e d'adr\195\169naline",AGGRESSION="Agressivit\195\169",BACKSTAB="Attaque sournoise",BLADE_FLURRY="D\195\169luge de lames",DAGGER_SPECIALIZATION="Sp\195\169cialisation Dague",DUAL_WIELD_SPECIALIZATION="Sp\195\169cialisation Ambidextrie",EVASION="Evasion",FEINT="Feinte",FIST_WEAPON_SPECIALIZATION="Sp\195\169cialisation Arme de pugilat",GOUGE="Suriner",IMPROVED_BACKSTAB="Attaque sournoise am\195\169lior\195\169e",IMPROVED_EVASION="Evasion am\195\169lior\195\169e",IMPROVED_GOUGE="Suriner am\195\169lior\195\169",IMPROVED_KICK="Coup de pied am\195\169lior\195\169",IMPROVED_SINISTER_STRIKE="Attaque pernicieuse am\195\169lior\195\169e",IMPROVED_SPRINT="Sprint am\195\169lior\195\169",KICK="Coup de pied",LIGHTNING_REFLEXES="R\195\169flexes \195\169clairs",PRECISION="Pr\195\169cision",RIPOSTE="Riposte",ROGUE_PASSIVE="Voleur",SINISTER_STRIKE="Attaque pernicieuse",SPRINT="Sprint",THROWING_WEAPON_SPECIALIZATION="Sp\195\169cialisation Armes de jet",CROSSBOWS="Arbal\195\168tes",SHOOT_CROSSBOW="Tir \195\160 l\226\128\153arbal\195\168te",DAGGERS="Dagues",BLOCK="Bloquer",DEFENSE="D\195\169fense",DEFENSIVE_STATE="Posture d\195\169fensive",DEFENSIVE_STATE_2="Posture d\195\169fensive 2",DODGE="Esquiver",PARRY="Parade",SPELLDEFENSE="DEFENSECONTRELESSORTS",BANISH="Bannir",CREATE_FIRESTONE="Cr\195\169ation de Pierre de feu",CREATE_HEALTHSTONE="Cr\195\169ation de Pierre de soins",CREATE_SOULSTONE="Cr\195\169ation de Pierre d'\195\162me",CREATE_SPELLSTONE="Cr\195\169ation de Pierre de sort",DEMON_ARMOR="Armure d\195\169moniaque",DEMON_SKIN="Peau de d\195\169mon",DEMONIC_EMBRACE="Baiser d\195\169moniaque",DEMONIC_SACRIFICE="Sacrifice d\195\169moniaque",DETECT_GREATER_INVISIBILITY="D\195\169tection de l'invisibilit\195\169 sup\195\169rieure",DETECT_INVISIBILITY="D\195\169tection de l'invisibilit\195\169",DETECT_LESSER_INVISIBILITY="D\195\169tection de l'invisibilit\195\169 inf\195\169rieure",ENSLAVE_DEMON="Asservir d\195\169mon",EYE_OF_KILROGG="Oeil de Kilrogg",FEL_DOMINATION="Domination corrompue",FEL_INTELLECT="Intelligence corrompue",FEL_STAMINA="Endurance corrompue",HEALTH_FUNNEL="Captation de vie",IMPROVED_ENSLAVE_DEMON="Asservir d\195\169mon am\195\169lior\195\169",
			IMPROVED_FIRESTONE="Pierre de feu am\195\169lior\195\169e",IMPROVED_HEALTH_FUNNEL="Captation de vie am\195\169lior\195\169e",IMPROVED_HEALTHSTONE="Pierre de soins am\195\169lior\195\169e",IMPROVED_IMP="Diablotin am\195\169lior\195\169",IMPROVED_SPELLSTONE="Pierre de sort am\195\169lior\195\169e",IMPROVED_SUCCUBUS="Succube am\195\169lior\195\169e",IMPROVED_VOIDWALKER="Marcheur du Vide am\195\169lior\195\169",INFERNO="Inferno",MASTER_DEMONOLOGIST="Ma\195\174tre d\195\169monologue",MASTER_SUMMONER="Ma\195\174tre invocateur",RITUAL_OF_DOOM="Rituel de mal\195\169diction",RITUAL_OF_DOOM_EFFECT="Effet Rituel de mal\195\169diction",RITUAL_OF_SUMMONING="Rituel d'invocation",SENSE_DEMONS="D\195\169tection des d\195\169mons",SHADOW_WARD="Gardien de l'ombre",SOUL_LINK="Lien spirituel",SUMMON_DREADSTEED="Invocation d'un Destrier de l'Effroi",SUMMON_FELHUNTER="Invocation d'un chasseur corrompu",SUMMON_FELSTEED="Invocation d'un palefroi corrompu",SUMMON_IMP="Invocation d'un diablotin",SUMMON_SUCCUBUS="Invocation d'une succube",SUMMON_VOIDWALKER="Invocation d'un marcheur du Vide",UNENDING_BREATH="Respiration interminable",UNHOLY_POWER="Puissance impie",AFTERMATH="Cons\195\169quences",BANE="Fl\195\169au",CATACLYSM="Cataclysme",CONFLAGRATE="Conflagration",DESTRUCTIVE_REACH="Allonge de destruction",DEVASTATION="D\195\169vastation",EMBERSTORM="Temp\195\170te ardente",HELLFIRE="Flammes infernales",HELLFIRE_EFFECT="Effet Flammes infernales",IMMOLATE="Immolation",IMPROVED_FIREBOLT="Eclair de feu am\195\169lior\195\169",IMPROVED_IMMOLATE="Immolation am\195\169lior\195\169e",IMPROVED_LASH_OF_PAIN="Fouet de la douleur am\195\169lior\195\169",IMPROVED_SEARING_PAIN="Douleur br\195\187lante am\195\169lior\195\169e",IMPROVED_SHADOW_BOLT="Trait de l'ombre am\195\169lior\195\169",INTENSITY="Intensit\195\169",PYROCLASM="Pyroclasme",RAIN_OF_FIRE="Pluie de feu",RUIN="Ruine",SEARING_PAIN="Douleur br\195\187lante",SHADOW_BOLT="Trait de l'ombre",SHADOWBURN="Br\195\187lure de l'ombre",SOUL_FIRE="Feu de l'\195\162me",DISPEL_MAGIC="Dissipation de la magie",DIVINE_SPIRIT="Esprit divin",ELUNES_GRACE="Gr\195\162ce d'Elune",FEEDBACK="R\195\169action",FOCUSED_CASTING="Incantation focalis\195\169e",FORCE_OF_WILL="Force de volont\195\169",IMPROVED_INNER_FIRE="Feu int\195\169rieur am\195\169lior\195\169",IMPROVED_MANA_BURN="Br\195\187lure de mana am\195\169lior\195\169e",IMPROVED_POWER_WORD_FORTITUDE="Mot de pouvoir : Robustesse am\195\169lior\195\169",IMPROVED_POWER_WORD_SHIELD="Mot de pouvoir : Bouclier am\195\169lior\195\169",INNER_FIRE="Feu int\195\169rieur",INNER_FOCUS="Focalisation am\195\169lior\195\169e",LEVITATE="L\195\169vitation",MANA_BURN="Br\195\187lure de mana",MARTYRDOM="Martyre",MEDITATION="M\195\169ditation",MENTAL_AGILITY="Sagacit\195\169",MENTAL_STRENGTH="Force mentale",POWER_INFUSION="Infusion de puissance",POWER_WORD_FORTITUDE="Mot de pouvoir : Robustesse",POWER_WORD_SHIELD="Mot de pouvoir : Bouclier",PRAYER_OF_FORTITUDE="Pri\195\168re de robustesse",PRAYER_OF_SPIRIT="Pri\195\168re d'Esprit",SHACKLE_UNDEAD="Entraves des morts-vivants",SILENT_RESOLVE="R\195\169solution silencieuse",STARSHARDS="Eclats stellaires",UNBREAKABLE_WILL="Volont\195\169 inflexible",DUAL_WIELD="Ambidextrie",FIND_TREASURE="D\195\169couverte de tr\195\169sors",GUN_SPECIALIZATION="Sp\195\169cialisation Armes \195\160 feu",STONEFORM="Forme de pierre",CALL_OF_FLAME="Appel des flammes",CALL_OF_THUNDER="Appel de la foudre",CHAIN_LIGHTNING="Cha\195\174ne d'\195\169clairs",CONCUSSION="Commotion",CONVECTION="Convection",EARTH_SHOCK="Horion de terre",EARTHBIND_TOTEM="Totem de lien terrestre",ELEMENTAL_FOCUS="Focalisation \195\169l\195\169mentaire",ELEMENTAL_FURY="Fureur \195\169l\195\169mentaire",ELEMENTAL_MASTERY="Ma\195\174trise \195\169l\195\169mentaire",FIRE_NOVA_TOTEM="Totem Nova de feu",FLAME_SHOCK="Horion de flammes",FROST_SHOCK="Horion de givre",IMPROVED_CHAIN_LIGHTNING="Cha\195\174ne d'\195\169clairs am\195\169lior\195\169e",IMPROVED_FIRE_NOVA_TOTEM="Totem Nova de feu am\195\169lior\195\169",IMPROVED_LIGHTNING_BOLT="Eclair am\195\169lior\195\169",IMPROVED_MAGMA_TOTEM="Totem de Magma am\195\169lior\195\169",IMPROVED_SEARING_TOTEM="Totem incendiaire am\195\169lior\195\169",IMPROVED_STONECLAW_TOTEM="Totem de Griffes de pierre am\195\169lior\195\169",LIGHTNING_BOLT="Eclair",LIGHTNING_MASTERY="Ma\195\174trise de la foudre",MAGMA_TOTEM="Totem de Magma",PURGE="Expiation",REVERBERATION="R\195\169verb\195\169ration",SEARING_TOTEM="Totem incendiaire",STONECLAW_TOTEM="Totem de Griffes de pierre",ANCESTRAL_KNOWLEDGE="Connaissance ancestrale",ANTICIPATION="Anticipation",ASTRAL_RECALL="Rappel astral",FAR_SIGHT="Double vue",FIRE_RESISTANCE_TOTEM="Totem de r\195\169sistance au feu",FLAMETONGUE_TOTEM="Totem Langue de feu",FLAMETONGUE_WEAPON="Arme Langue de feu",FLURRY="Rafale",FROST_RESISTANCE_TOTEM="Totem de r\195\169sistance au Givre",FROSTBRAND_WEAPON="Arme de givre",GHOST_WOLF="Loup fant\195\180me",GRACE_OF_AIR_TOTEM="Totem de Gr\195\162ce a\195\169rienne",GROUNDING_TOTEM="Totem de Gl\195\168be",IMPROVED_FLAMETONGUE_WEAPON="Arme Langue de feu am\195\169lior\195\169e",IMPROVED_FROSTBRAND_WEAPON="Arme de givre am\195\169lior\195\169e",IMPROVED_GHOST_WOLF="Loup fant\195\180me am\195\169lior\195\169",IMPROVED_GRACE_OF_AIR_TOTEM="Totem de Gr\195\162ce a\195\169rienne am\195\169lior\195\169",IMPROVED_GROUNDING_TOTEM="Totem de Gl\195\168be am\195\169lior\195\169",IMPROVED_LIGHTNING_SHIELD="Bouclier de foudre am\195\169lior\195\169",IMPROVED_ROCKBITER_WEAPON="Arme Croque-roc am\195\169lior\195\169e",IMPROVED_STONESKIN_TOTEM="Totem de Peau de pierre am\195\169lior\195\169",IMPROVED_STRENGTH_OF_EARTH_TOTEM="Totem de Force de la Terre am\195\169lior\195\169",IMPROVED_WINDFURY_WEAPON="Arme Furie-des-vents am\195\169lior\195\169e",LIGHTNING_SHIELD="Bouclier de foudre",NATURE_RESISTANCE_TOTEM="Totem de r\195\169sistance \195\160 la Nature",ROCKBITER_WEAPON="Arme Croque-roc",SENTRY_TOTEM="Totem Sentinelle",SHIELD_SPECIALIZATION="Sp\195\169cialisation Bouclier",STONESKIN_TOTEM="Totem de Peau de pierre",STORMSTRIKE="Courroux naturel",STRENGTH_OF_EARTH_TOTEM="Totem de Force de la Terre",THUNDERING_STRIKES="Frappe foudroyante",TOUGHNESS="R\195\169sistance",TWO_HANDED_AXES_AND_MACES="Haches et masses \195\160 deux mains",WATER_BREATHING="Respiration aquatique",WATER_WALKING="Marcher sur l\226\128\153eau",WINDFURY_TOTEM="Totem Furie-des-vents",WINDFURY_WEAPON="Arme Furie-des-vents",WINDWALL_TOTEM="Totem de Mur des vents",AQUATIC_FORM="Forme aquatique",BASH="Sonner",BEAR_FORM="Forme d'ours",BLOOD_FRENZY="Fr\195\169n\195\169sie sanglante",BRUTAL_IMPACT="Impact brutal",CAT_FORM="Forme de f\195\169lin",CHALLENGING_ROAR="Rugissement provocateur",DEMORALIZING_ROAR="Rugissement d\195\169moralisant",DIRE_BEAR_FORM="Forme d'ours redoutable",ENRAGE="Enrager",FELINE_GRACE="Gr\195\162ce f\195\169line",FELINE_SWIFTNESS="C\195\169l\195\169rit\195\169 f\195\169line",FERAL_AGGRESSION="Agressivit\195\169 farouche",FERAL_CHARGE="Charge farouche",FERAL_INSTINCT="Instinct farouche",FEROCIOUS_BITE="Morsure f\195\169roce",FRENZIED_REGENERATION="R\195\169g\195\169n\195\169ration fr\195\169n\195\169tique",HEART_OF_THE_WILD="C\197\147ur de fauve",IMPROVED_SHRED="Lambeau am\195\169lior\195\169",LEADER_OF_THE_PACK="Chef de la meute",MANGLE="Mutilation",MAUL="Mutiler",POUNCE="Traquenard",POUNCE_BLEED="Traquenard sanglant",PREDATORY_STRIKES="Frappes de pr\195\169dateur",PRIMAL_FURY="Fureur primitive",RAKE="Griffure",RAVAGE="Ravage",RIP="D\195\169chirure",SAVAGE_FURY="Furie sauvage",SHARPENED_CLAWS="Griffes aiguis\195\169es",SHRED="Lambeau",SWIPE="Balayage",TIGERS_FURY="Fureur du tigre",TRACK_HUMANOIDS="Pistage des humano\195\175des",TRAVEL_FORM="Forme de voyage",BLAST_WAVE="Vague explosive",BURNING_SOUL="Ame ardente",COMBUSTION="Combustion",CRITICAL_MASS="Masse critique",FELFIRE="Gangrefeu",FIRE_BLAST="Trait de feu",FIRE_POWER="Puissance du feu",FIRE_VULNERABILITY="Vuln\195\169rabilit\195\169 au Feu",FIRE_WARD="Gardien de feu",FIREBALL="Boule de feu",FLAME_THROWING="Jet de flammes",FLAMESTRIKE="Choc de flammes",IGNITE="Enflammer",IMPACT="Impact",IMPROVED_FIRE_BLAST="Trait de feu am\195\169lior\195\169",IMPROVED_FIRE_WARD="Gardien de feu am\195\169lior\195\169",IMPROVED_FIREBALL="Boule de feu am\195\169lior\195\169e",IMPROVED_FLAMESTRIKE="Choc de flammes am\195\169lior\195\169",IMPROVED_SCORCH="Br\195\187lure am\195\169lior\195\169e",INCINERATE="Incin\195\169rer",PYROBLAST="Explosion pyrotechnique",SCORCH="Br\195\187lure",FISHING="P\195\170che",FISHING_POLES="Cannes \195\160 p\195\170che",FIST_WEAPONS="Armes de pugilat",ARCTIC_REACH="Allonge arctique",BLIZZARD="Blizzard",CHILLED="Transi",COLD_SNAP="Morsure de glace",CONE_OF_COLD="C\195\180ne de froid",FROST_ARMOR="Armure de givre",FROST_CHANNELING="Canalisation du givre",FROST_NOVA="Nova de givre",FROST_WARD="Gardien de givre",FROSTBITE="Morsure du givre",FROSTBOLT="Eclair de givre",ICE_ARMOR="Armure de glace",ICE_BARRIER="Barri\195\168re de glace",ICE_BLOCK="Parade de glace",ICE_SHARDS="Eclats de glace",IMPROVED_BLIZZARD="Blizzard am\195\169lior\195\169",IMPROVED_CONE_OF_COLD="C\195\180ne de froid am\195\169lior\195\169",IMPROVED_FROST_NOVA="Nova de givre am\195\169lior\195\169e",IMPROVED_FROST_WARD="Gardien de givre am\195\169lior\195\169",IMPROVED_FROSTBOLT="Eclair de givre am\195\169lior\195\169",PERMAFROST="Gel prolong\195\169",PIERCING_ICE="Glace per\195\167ante",SHATTER="Fracasser",WINTERS_CHILL="Froid hivernal",BATTLE_SHOUT="Cri de guerre",BERSERKER_RAGE="Rage berserker",BERSERKER_STANCE="Posture berserker",BERSERKER_STANCE_PASSIVE="Posture berserker",BLOOD_CRAZE="Folie sanguinaire",BLOODTHIRST="Sanguinaire",BOOMING_VOICE="Voix tonitruante",CHALLENGING_SHOUT="Cri de d\195\169fi",CLEAVE="Encha\195\174nement",CRUELTY="Cruaut\195\169",DEATH_WISH="Souhait mortel",DEMORALIZING_SHOUT="Cri d\195\169moralisant",EXECUTE="Ex\195\169cution",IMPROVED_BATTLE_SHOUT="Cri de guerre am\195\169lior\195\169",IMPROVED_BERSERKER_RAGE="Rage berserker am\195\169lior\195\169e",IMPROVED_CHALLENGING_SHOUT="Cri de d\195\169fi am\195\169lior\195\169",IMPROVED_CLEAVE="Encha\195\174nement am\195\169lior\195\169",IMPROVED_DEMORALIZING_SHOUT="Cri d\195\169moralisant am\195\169lior\195\169",IMPROVED_EXECUTE="Ex\195\169cution am\195\169lior\195\169e",IMPROVED_INTERCEPT="Interception am\195\169lior\195\169e",IMPROVED_INTIMIDATING_SHOUT="Cri d\226\128\153intimidation am\195\169lior\195\169",IMPROVED_SLAM="Heurtoir am\195\169lior\195\169",INTERCEPT="Interception",INTIMIDATING_SHOUT="Cri d\226\128\153intimidation",PIERCING_HOWL="Hurlement per\195\167ant",PUMMEL="Vol\195\169e de coups",RECKLESSNESS="T\195\169m\195\169rit\195\169",SLAM="Heurtoir",UNBRIDLED_WRATH="Col\195\168re d\195\169cha\195\174n\195\169e",UNBRIDLED_WRATH_EFFECT="Effet Col\195\168re d\195\169cha\195\174n\195\169e",WHIRLWIND="Tourbillon",ATTACK="Attaque",ATTACKING="Attaque",CLOSING="Fermeture",DETECT="D\195\169tection",DUEL="Duel",FETISH="F\195\169tiche",GENERIC="G\195\169n\195\169rique",GROVEL="Ramper",HONORLESS_TARGET="Cible sans honneur",LIBRAM="Libram",OPENING="Ouverture",OPENING___NO_TEXT="Ouverture - pas de texte",REMOVE_INSIGNIA="Enlever l'insigne",STUCK="Bloqu\195\169",TOTEM="Totem",GUNS="Armes \195\160 feu",SHOOT_GUN="Tir avec une arme \195\160 feu",ABOLISH_DISEASE="Abolir maladie",BLESSED_RECOVERY="R\195\169tablissement b\195\169ni",CURE_DISEASE="Gu\195\169rison des maladies",DESPERATE_PRAYER="Pri\195\168re du d\195\169sespoir",DIVINE_FURY="Fureur divine",FEAR_WARD="Gardien de peur",FLASH_HEAL="Soins rapides",GREATER_HEAL="Soins sup\195\169rieurs",HEAL="Soins",HEALING_FOCUS="Focalisation des soins",HOLY_FIRE="Flammes sacr\195\169es",HOLY_NOVA="Nova sacr\195\169e",HOLY_REACH="Allonge du Sacr\195\169",
			HOLY_SPECIALIZATION="Sp\195\169cialisation",IMPROVED_HEALING="Soin am\195\169lior\195\169",IMPROVED_PRAYER_OF_HEALING="Pri\195\168re de soins am\195\169lior\195\169e",IMPROVED_RENEW="R\195\169novation am\195\169lior\195\169e",INSPIRATION="Inspiration",LESSER_HEAL="Soins inf\195\169rieurs",LIGHTWELL="Puits de lumi\195\168re",LIGHTWELL_RENEW="R\195\169novation du Puits de lumi\195\168re",PRAYER_OF_HEALING="Pri\195\168re de soins",RENEW="R\195\169novation",RESURRECTION="R\195\169surrection",SEARING_LIGHT="Lumi\195\168re incendiaire",SMITE="Ch\195\162timent",SPELL_WARDING="Protection contre les sorts",SPIRIT_OF_REDEMPTION="Esprit de r\195\169demption",SPIRITUAL_GUIDANCE="Direction spirituelle",SPIRITUAL_HEALING="Soins spirituels",BLESSING_OF_LIGHT="B\195\169n\195\169diction de lumi\195\168re",BLESSING_OF_WISDOM="B\195\169n\195\169diction de sagesse",CLEANSE="Epuration",CONSECRATION="Cons\195\169cration",DIVINE_FAVOR="Faveur divine",DIVINE_INTELLECT="Intelligence divine",DIVINE_STRENGTH="Force divine",EXORCISM="Exorcisme",FLASH_OF_LIGHT="Eclair lumineux",GREATER_BLESSING_OF_LIGHT="B\195\169n\195\169diction de lumi\195\168re sup\195\169rieure",GREATER_BLESSING_OF_WISDOM="B\195\169n\195\169diction de sagesse sup\195\169rieure",HAMMER_OF_WRATH="Marteau de courroux",HEALING_LIGHT="Lumi\195\168re gu\195\169risseuse",HOLY_LIGHT="Lumi\195\168re sacr\195\169e",HOLY_POWER="Puissance sacr\195\169e",HOLY_SHOCK="Horion sacr\195\169",HOLY_WRATH="Col\195\168re divine",ILLUMINATION="Illumination",IMPROVED_BLESSING_OF_WISDOM="B\195\169n\195\169diction de sagesse am\195\169lior\195\169e",IMPROVED_FLASH_OF_LIGHT="Eclair lumineux am\195\169lior\195\169",IMPROVED_LAY_ON_HANDS="Imposition des mains am\195\169lior\195\169e",IMPROVED_SEAL_OF_RIGHTEOUSNESS="Sceau de pi\195\169t\195\169 am\195\169lior\195\169",JUDGEMENT_OF_LIGHT="Jugement de lumi\195\168re",JUDGEMENT_OF_RIGHTEOUSNESS="Jugement de pi\195\169t\195\169",JUDGEMENT_OF_WISDOM="Jugement de sagesse",LASTING_JUDGEMENT="Jugement durable",LAY_ON_HANDS="Imposition des mains",PURIFY="Purification",REDEMPTION="R\195\169demption",SEAL_OF_LIGHT="Sceau de lumi\195\168re",SEAL_OF_RIGHTEOUSNESS="Sceau de pi\195\169t\195\169",SEAL_OF_WISDOM="Sceau de sagesse",SENSE_UNDEAD="D\195\169tection des morts-vivants",SPIRITUAL_FOCUS="Focalisation spirituelle",SUMMON_CHARGER="Invocation de destrier",SUMMON_WARHORSE="Invocation d'un cheval de guerre",TURN_UNDEAD="Renvoi des morts-vivants",UNYIELDING_FAITH="Foi inflexible",HORSE_RIDING="Equitation",KODO_RIDING="Monte de kodo",LEATHER="Cuir",PICK_LOCK="Crochetage",ONE_HANDED_MACES="Masses \195\160 une main",MAIL="Mailles",AIMED_SHOT="Vis\195\169e",ARCANE_SHOT="Tir des arcanes",AUTO_SHOT="Tir automatique",BARRAGE="Barrage",BLACK_ARROW="Fl\195\168che noire",CONCUSSIVE_SHOT="Trait de choc",DISTRACTING_SHOT="Trait provocateur",EFFICIENCY="Efficacit\195\169",FLARE="Fus\195\169e \195\169clairante",HAWK_EYE="Oeil de faucon",HUNTERS_MARK="Marque du chasseur",IMPROVED_ARCANE_SHOT="Tir des arcanes am\195\169lior\195\169",IMPROVED_CONCUSSIVE_SHOT="Trait de choc am\195\169lior\195\169",IMPROVED_HUNTERS_MARK="Marque du chasseur am\195\169lior\195\169e",IMPROVED_SCORPID_STING="Piq\195\187re de scorpide am\195\169lior\195\169e",IMPROVED_SERPENT_STING="Morsure de serpent am\195\169lior\195\169e",LETHAL_SHOTS="Coups fatals",MORTAL_SHOTS="Coups mortels",MULTI_SHOT="Fl\195\168ches multiples",RANGED_WEAPON_SPECIALIZATION="Sp\195\169cialisation Armes \195\160 distance",RAPID_FIRE="Tir rapide",SCATTER_SHOT="Fl\195\168che de dispersion",SCORPID_STING="Piq\195\187re de scorpide",SERPENT_STING="Morsure de serpent",TRUESHOT_AURA="Aura de pr\195\169cision",VIPER_STING="Morsure de vip\195\168re",VOLLEY="Salve",MECHANOSTRIDER_PILOTING="Pilotage de m\195\169canotrotteur",QUICKNESS="Rapidit\195\169",SHADOWMELD="Camouflage dans l'ombre",SHADOWMELD_PASSIVE="Camouflage dans l'ombre",WISP_SPIRIT="Esprit feu follet",BLOOD_FURY="Fureur sanguinaire",COMMAND="Commande",HARDINESS="Solidit\195\169",TAMED_PET_PASSIVE="Familier dompt\195\169",ACTIVATE_MG_TURRET="Activation de la tourelle de mitrailleuse",FLAMETHROWER="Lance-flammes",DEVOUR_MAGIC="Festin magique",DEVOUR_MAGIC_EFFECT="Effet festin magique",PARANOIA="Parano\195\175a",SPELL_LOCK="Verrou magique",TAINTED_BLOOD="Corruption sanguine",PET_AGGRESSION="Agressivit\195\169 du familier",PET_HARDINESS="Robustesse du familier",PET_RECOVERY="R\195\169tablissement du familier",PET_RESISTANCE="R\195\169sistance du familier",BLOOD_PACT="Pacte de sang",FIRE_SHIELD="Bouclier de feu",FIREBOLT="Eclair de feu",PHASE_SHIFT="Changement de phase",LASH_OF_PAIN="Fouet de la douleur",LESSER_INVISIBILITY="Invisibilit\195\169 inf\195\169rieure",SEDUCTION="S\195\169duction",SOOTHING_KISS="Baiser apaisant",CONSUME_SHADOWS="Consumer les ombres",SACRIFICE="Sacrifice",SUFFERING="Souffrance",TORMENT="Tourment",PLATE_MAIL="Armure en plaques",BLINDING_POWDER="Poudre aveuglante",CRIPPLING_POISON="Poison affaiblissant",CRIPPLING_POISON_II="Poison affaiblissant II",DEADLY_POISON="Poison mortel",DEADLY_POISON_II="Poison mortel II",DEADLY_POISON_III="Poison mortel III",DEADLY_POISON_IV="Poison mortel IV",DEADLY_POISON_V="Poison mortel V",INSTANT_POISON="Poison instantan\195\169",INSTANT_POISON_II="Poison instantan\195\169 II",INSTANT_POISON_III="Poison instantan\195\169 III",INSTANT_POISON_IV="Poison instantan\195\169 IV",INSTANT_POISON_V="Poison instantan\195\169 V",INSTANT_POISON_VI="Poison instantan\195\169 VI",MIND_NUMBING_POISON="Poison de distraction mentale",MIND_NUMBING_POISON_II="Poison de distraction mentale II",MIND_NUMBING_POISON_III="Poison de distraction mentale III",POISONS="Poisons",WOUND_POISON="Poison douloureux",WOUND_POISON_II="Poison douloureux II",WOUND_POISON_III="Poison douloureux III",WOUND_POISON_IV="Poison douloureux IV",POLEARMS="Armes d'hast",BLOODRAGE="Rage sanguinaire",CONCUSSION_BLOW="Bourrasque",DEFENSIVE_STANCE="Posture d\195\169fensive",DEFENSIVE_STANCE_PASSIVE="Posture d\195\169fensive",DEFIANCE="D\195\169fi",DISARM="D\195\169sarmement",IMPROVED_BLOODRAGE="Rage sanguinaire am\195\169lior\195\169e",IMPROVED_DISARM="D\195\169sarmement am\195\169lior\195\169",IMPROVED_REVENGE="Vengeance am\195\169lior\195\169e",IMPROVED_SHIELD_BASH="Coup de bouclier am\195\169lior\195\169",IMPROVED_SHIELD_BLOCK="Ma\195\174trise du blocage am\195\169lior\195\169e",IMPROVED_SHIELD_WALL="Mur protecteur am\195\169lior\195\169",IMPROVED_SUNDER_ARMOR="Fracasser armure am\195\169lior\195\169",IMPROVED_TAUNT="Provocation am\195\169lior\195\169e",IRON_WILL="Volont\195\169 de fer",LAST_STAND="Dernier rempart",ONE_HANDED_WEAPON_SPECIALIZATION="Sp\195\169cialisation Arme 1M",REVENGE="Vengeance",REVENGE_STUN="Etourdissement vengeur",SHIELD_BASH="Coup de bouclier",SHIELD_BLOCK="Ma\195\174trise du blocage",SHIELD_SLAM="Heurt de bouclier",SHIELD_WALL="Mur protecteur",SUNDER_ARMOR="Fracasser armure",TAUNT="Provocation",BLESSING_OF_FREEDOM="B\195\169n\195\169diction de libert\195\169",BLESSING_OF_KINGS="B\195\169n\195\169diction des rois",BLESSING_OF_PROTECTION="B\195\169n\195\169diction de protection",BLESSING_OF_SACRIFICE="B\195\169n\195\169diction de sacrifice",BLESSING_OF_SALVATION="B\195\169n\195\169diction de salut",BLESSING_OF_SANCTUARY="B\195\169n\195\169diction du sanctuaire",CONCENTRATION_AURA="Aura de concentration",DEVOTION_AURA="Aura de d\195\169votion",DIVINE_INTERVENTION="Intervention divine",DIVINE_PROTECTION="Protection divine",DIVINE_SHIELD="Bouclier divin",FIRE_RESISTANCE_AURA="Aura de r\195\169sistance au Feu",FROST_RESISTANCE_AURA="Aura de r\195\169sistance au Givre",GREATER_BLESSING_OF_KINGS="B\195\169n\195\169diction des rois sup\195\169rieure",GREATER_BLESSING_OF_SALVATION="B\195\169n\195\169diction de salut sup\195\169rieure",GREATER_BLESSING_OF_SANCTUARY="B\195\169n\195\169diction du sanctuaire sup\195\169rieure",GUARDIANS_FAVOR="Faveur du Gardien",HAMMER_OF_JUSTICE="Marteau de la justice",HOLY_SHIELD="Bouclier sacr\195\169",IMPROVED_CONCENTRATION_AURA="Aura de concentration am\195\169lior\195\169e",IMPROVED_DEVOTION_AURA="Aura de d\195\169votion am\195\169lior\195\169e",IMPROVED_HAMMER_OF_JUSTICE="Marteau de la justice am\195\169lior\195\169",IMPROVED_RIGHTEOUS_FURY="Fureur vertueuse am\195\169lior\195\169e",JUDGEMENT_OF_JUSTICE="Jugement de justice",RECKONING="R\195\169tribution",REDOUBT="Redoute",RIGHTEOUS_FURY="Fureur vertueuse",SEAL_OF_JUSTICE="Sceau de justice",SHADOW_RESISTANCE_AURA="Aura de r\195\169sistance \195\160 l'Ombre",ENGINEERING_SPECIALIZATION="Sp\195\169cialisation",ESCAPE_ARTIST="Ma\195\174tre de l'\195\169vasion",EXPANSIVE_MIND="Pens\195\169e expansive",DIPLOMACY="Diplomatie",PERCEPTION="Perception",THE_HUMAN_SPIRIT="L'esprit humain",BEAST_SLAYING="Tueur de b\195\170tes",BERSERKING="Berserker",BOW_SPECIALIZATION="Sp\195\169cialisation Arc",REGENERATION="R\195\169g\195\169n\195\169ration",THROWING_SPECIALIZATION="Sp\195\169cialisation Armes de jet",CANNIBALIZE="Cannibalisme",UNDERWATER_BREATHING="Respiration aquatique",WILL_OF_THE_FORSAKEN="Volont\195\169 des R\195\169prouv\195\169s",RAM_RIDING="Monte de b\195\169lier",RAPTOR_RIDING="Monte de raptor",ANCESTRAL_HEALING="Gu\195\169rison des anciens",ANCESTRAL_SPIRIT="Esprit ancestral",CHAIN_HEAL="Salve de gu\195\169rison",COMBAT_ENDURANCE="Endurance de combat",CURE_POISON="Gu\195\169rison du poison",DISEASE_CLEANSING_TOTEM="Totem de Purification des maladies",EVENTIDE="Tomb\195\169e du jour",HEALING_STREAM_TOTEM="Totem gu\195\169risseur",HEALING_WAVE="Vague de soins",IMPROVED_CHAIN_HEAL="Salve de gu\195\169rison am\195\169lior\195\169e",IMPROVED_HEALING_STREAM_TOTEM="Totem gu\195\169risseur am\195\169lior\195\169",IMPROVED_HEALING_WAVE="Vague de soins am\195\169lior\195\169e",IMPROVED_LESSER_HEALING_WAVE="Vague de soins inf\195\169rieurs am\195\169lior\195\169e",IMPROVED_MANA_SPRING_TOTEM="Totem Fontaine de mana am\195\169lior\195\169",IMPROVED_REINCARNATION="R\195\169incarnation am\195\169lior\195\169e",LESSER_HEALING_WAVE="Vague de soins inf\195\169rieurs",MANA_SPRING_TOTEM="Totem Fontaine de mana",MANA_TIDE_TOTEM="Totem de Vague de mana",NATURES_SWIFTNESS="Rapidit\195\169 de la nature",POISON_CLEANSING_TOTEM="Totem de Purification du poison",PURIFICATION="Purification",REINCARNATION="R\195\169incarnation",TIDAL_FOCUS="Focalisation des flots",TIDAL_MASTERY="Ma\195\174trise des flots",TOTEMIC_FOCUS="Focalisation tot\195\169mique",TRANQUIL_AIR_TOTEM="Totem de Tranquillit\195\169 de l'air",TREMOR_TOTEM="Totem de S\195\169isme",ABOLISH_POISON="Abolir le poison",ABOLISH_POISON_EFFECT="Effet Abolir le poison",FUROR="Fureur",GIFT_OF_NATURE="Don de la Nature",GIFT_OF_THE_WILD="Don du fauve",HEALING_TOUCH="Toucher gu\195\169risseur",IMPROVED_ENRAGE="Enrager am\195\169lior\195\169",IMPROVED_HEALING_TOUCH="Toucher gu\195\169risseur am\195\169lior\195\169",IMPROVED_MARK_OF_THE_WILD="Marque du fauve am\195\169lior\195\169e",IMPROVED_REGROWTH="R\195\169tablissement am\195\169lior\195\169",IMPROVED_REJUVENATION="R\195\169cup\195\169ration am\195\169lior\195\169e",IMPROVED_TRANQUILITY="Tranquillit\195\169 am\195\169lior\195\169e",INNERVATE="Innervation",INSECT_SWARM="Essaim d'insectes",MARK_OF_THE_WILD="Marque du fauve",NATURES_FOCUS="Focalisation de la nature",REBIRTH="Renaissance",REFLECTION="Renvoi",REGROWTH="R\195\169tablissement",REJUVENATION="R\195\169cup\195\169ration",REMOVE_CURSE="D\195\169livrance de la mal\195\169diction",SUBTLETY="Discr\195\169tion",TRANQUIL_SPIRIT="Tranquillit\195\169 de l'esprit",TRANQUILITY="Tranquillit\195\169",BENEDICTION="B\195\169n\195\169diction",BLESSING_OF_MIGHT="B\195\169n\195\169diction de puissance",CONVICTION="Conviction",EYE_FOR_AN_EYE="Oeil pour oeil",
			GREATER_BLESSING_OF_MIGHT="B\195\169n\195\169diction de puissance sup\195\169rieure",IMPROVED_BLESSING_OF_MIGHT="B\195\169n\195\169diction de puissance am\195\169lior\195\169e",IMPROVED_JUDGEMENT="Jugement am\195\169lior\195\169",IMPROVED_RETRIBUTION_AURA="Aura de vindicte am\195\169lior\195\169e",IMPROVED_SEAL_OF_THE_CRUSADER="Sceau du Crois\195\169 am\195\169lior\195\169",JUDGEMENT="Jugement",JUDGEMENT_OF_COMMAND="Jugement d'autorit\195\169",JUDGEMENT_OF_THE_CRUSADER="Jugement du Crois\195\169",PURSUIT_OF_JUSTICE="Poursuite de la justice",REPENTANCE="Repentir",RETRIBUTION_AURA="Aura de vindicte",SANCTITY_AURA="Aura de saintet\195\169",SEAL_OF_COMMAND="Sceau d'autorit\195\169",SEAL_OF_THE_CRUSADER="Sceau du Crois\195\169",VINDICATION="Justification",BLACKOUT="Aveuglement",DARKNESS="T\195\169n\195\168bres",DEVOURING_PLAGUE="Peste d\195\169vorante",FADE="Oubli",HEX_OF_WEAKNESS="Mal\195\169fice de faiblesse",IMPROVED_FADE="Oubli am\195\169lior\195\169",IMPROVED_MIND_BLAST="Attaque mentale am\195\169lior\195\169e",IMPROVED_PSYCHIC_SCREAM="Cri psychique am\195\169lior\195\169",IMPROVED_SHADOW_WORD_PAIN="Mot de l'ombre : Douleur am\195\169lior\195\169",IMPROVED_VAMPIRIC_EMBRACE="Etreinte vampirique am\195\169lior\195\169e",MIND_BLAST="Attaque mentale",MIND_CONTROL="Contr\195\180le mental",MIND_FLAY="Fouet mental",MIND_SOOTHE="Apaisement",MIND_VISION="Vision t\195\169l\195\169pathique",PRAYER_OF_SHADOW_PROTECTION="Pri\195\168re de protection contre l'Ombre",PSYCHIC_SCREAM="Cri psychique",SHADOW_AFFINITY="Affinit\195\169 avec l'ombre",SHADOW_FOCUS="Focalisation de l'ombre",SHADOW_PROTECTION="Protection contre l'Ombre",SHADOW_REACH="Allonge de l'Ombre",SHADOW_WEAVING="Tissage de l'ombre",SHADOW_WORD_PAIN="Mot de l'ombre\194\160: Douleur",SHADOWFORM="Forme d'Ombre",SHADOWGUARD="Garde de l'ombre",SILENCE="Silence",SPIRIT_TAP="Connexion spirituelle",TOUCH_OF_WEAKNESS="Toucher de faiblesse",VAMPIRIC_EMBRACE="Etreinte vampirique",SHIELD="Bouclier",STAVES="B\195\162tons",BLIND="C\195\169cit\195\169",CAMOUFLAGE="Dissimulation",DETECT_TRAPS="D\195\169tection des pi\195\168ges",DISARM_TRAP="D\195\169sarmement de pi\195\168ge",DISTRACT="Distraction",ELUSIVENESS="Insaisissable",GHOSTLY_STRIKE="Frappe fantomatique",HEMORRHAGE="H\195\169morragie",IMPROVED_AMBUSH="Embuscade am\195\169lior\195\169e",IMPROVED_CHEAP_SHOT="Coup bas am\195\169lior\195\169",IMPROVED_DISTRACT="Distraction am\195\169lior\195\169e",IMPROVED_GARROTE="Garrot am\195\169lior\195\169",IMPROVED_RUPTURE="Rupture am\195\169lior\195\169e",IMPROVED_SAP="Assommer am\195\169lior\195\169",IMPROVED_VANISH="Disparition am\195\169lior\195\169e",INITIATIVE="Initiative",MASTER_OF_DECEPTION="Ma\195\174tre des illusions",OPPORTUNITY="Opportunit\195\169",PICK_POCKET="Vol \195\160 la tire",PREMEDITATION="Pr\195\169m\195\169ditation",PREPARATION="Pr\195\169paration",RAPID_CONCEALMENT="Dissimulation rapide",SAFE_FALL="Chute amortie",SAP="Assommer",SETUP="Pr\195\169paratifs",STEALTH="Camouflage",VANISH="Disparition",VANISHED="Invisible",BASIC_CAMPFIRE="Feu de camp basique",BRIGHT_CAMPFIRE="Feu de camp \195\169clatant",CLEVER_TRAPS="Pi\195\168ges astucieux",COUNTERATTACK="Contre-attaque",DETERRENCE="Dissuasion",DISENGAGE="D\195\169sengagement",ENTRAPMENT="Pi\195\168ge",EXPLOSIVE_TRAP="Pi\195\168ge explosif",EXPLOSIVE_TRAP_EFFECT="Effet Pi\195\168ge explosif",FEIGN_DEATH="Feindre la mort",FREEZING_TRAP="Pi\195\168ge givrant",FROST_TRAP="Pi\195\168ge de givre",HUMANOID_SLAYING="Tueur d'humano\195\175des",IMMOLATION_TRAP="Pi\195\168ge d'Immolation",IMMOLATION_TRAP_EFFECT="Effet Pi\195\168ge immolation",IMPROVED_FEIGN_DEATH="Feindre la mort am\195\169lior\195\169",IMPROVED_WING_CLIP="Coupure d'ailes am\195\169lior\195\169e",KILLER_INSTINCT="Instinct du tueur",MELEE_SPECIALIZATION="Sp\195\169cialisation M\195\170l\195\169e",MONGOOSE_BITE="Morsure de la mangouste",MONSTER_SLAYING="Tueur de monstres",RAPTOR_STRIKE="Attaque du raptor",READINESS="Promptitude",SAVAGE_STRIKES="Frappes sauvages",SUREFOOTED="Pied s\195\187r",SURVIVALIST="Survivant",TRACK_BEASTS="Pistage des b\195\170tes",TRACK_DEMONS="Pistage des d\195\169mons",TRACK_DRAGONKIN="Pistage des draconiens",TRACK_ELEMENTALS="Pistage des \195\169l\195\169mentaires",TRACK_GIANTS="Pistage des g\195\169ants",TRACK_HIDDEN="Pistage des camoufl\195\169s",TRACK_UNDEAD="Pistage des morts-vivants",TRAP_MASTERY="Ma\195\174trise des pi\195\168ges",WING_CLIP="Coupure d'ailes",WYVERN_STING="Piq\195\187re de wyverne",ONE_HANDED_SWORDS="Ep\195\169es \195\160 une main",CULTIVATION="Culture",ENDURANCE="Endurance",WAR_STOMP="Choc martial",THROW="Lancer",THROWN="Armes de jet",TIGER_RIDING="Monte de tigre",TWO_HANDED_AXES="Haches \195\160 deux mains",TWO_HANDED_MACES="Masses \195\160 deux mains",TWO_HANDED_SWORDS="Ep\195\169es \195\160 deux mains",UNARMED="Mains nues",UNDEAD_HORSEMANSHIP="Monte de cheval squelette",SHOOT="Tir",WANDS="Baguettes",WOLF_RIDING="Monte de loup",
			BLACKSMITHING="Forge",ARMORSMITH="Fabricant d'armures",WEAPONSMITH="Fabricant d'armes",ALCHEMY="Alchimie",ENCHANTING="Enchantement",DISENCHANT="D\195\169senchanter",ENGINEERING="Ing\195\169nieur",FIND_HERBS="D\195\169couverte d'herbes",HERB_GATHERING="Cueillette",LEATHERWORKING="Travail du cuir",DRAGONSCALE_LEATHERWORKING="Travail du cuir d'\195\169cailles de dragon",ELEMENTAL_LEATHERWORKING="Travail du cuir \195\169l\195\169mentaire",TRIBAL_LEATHERWORKING="Travail du cuir tribal",FIND_MINERALS="D\195\169couverte de gisements",MINING="Minage",SMELTING="Fondre",SKINNING="D\195\169pe\195\167age",SOULSTONE_RESURRECTION="R\195\169surrection de pierre d'\195\162me",FOOD="Nourriture",DRINK="Boisson",ENRICHED_MANNA_BISCUIT="Biscuit enrichi en manne"
		}
	end
elseif locale == "zhCN" then
	function initSpells()
		spells = {
			AMPLIFY_CURSE="\232\175\133\229\146\146\229\162\158\229\185\133",CORRUPTION="\232\133\191\232\154\128\230\156\175",CURSE_OF_AGONY="\231\151\155\232\139\166\232\175\133\229\146\146",CURSE_OF_DOOM="\229\142\132\232\191\191\232\175\133\229\146\146",CURSE_OF_DOOM_EFFECT="\229\142\132\232\191\191\232\175\133\229\146\146\230\149\136\230\158\156",CURSE_OF_EXHAUSTION="\231\150\178\229\138\179\232\175\133\229\146\146",CURSE_OF_IDIOCY="\231\151\180\229\145\134\232\175\133\229\146\146",CURSE_OF_RECKLESSNESS="\233\178\191\232\142\189\232\175\133\229\146\146",CURSE_OF_SHADOW="\230\154\151\229\189\177\232\175\133\229\146\146",CURSE_OF_THE_ELEMENTS="\229\133\131\231\180\160\232\175\133\229\146\146",CURSE_OF_TONGUES="\232\175\173\232\168\128\232\175\133\229\146\146",CURSE_OF_WEAKNESS="\232\153\154\229\188\177\232\175\133\229\146\146",DARK_PACT="\233\187\145\230\154\151\229\165\145\231\186\166",DEATH_COIL="\230\173\187\228\186\161\231\188\160\231\187\149",DRAIN_LIFE="\229\191\184\229\191\150\231\148\159\229\145\189",DRAIN_MANA="\229\191\184\229\191\150\230\179\149\229\138\155",DRAIN_SOUL="\229\191\184\229\191\150\231\191\181\233\173\130",FEAR="\230\191\191\230\131\167\230\156\175",FEL_CONCENTRATION="\230\191\182\233\173\148\228\184\147\230\179\168",GRIM_REACH="\230\151\160\230\131\133\229\187\182\228\188\184",HOWL_OF_TERROR="\230\191\191\230\131\167\229\154\142\229\191\171",IMPROVED_CORRUPTION="\229\188\186\229\140\150\232\133\191\232\154\128\230\156\175",IMPROVED_CURSE_OF_AGONY="\229\188\186\229\140\150\231\151\155\232\139\166\232\175\133\229\146\146",IMPROVED_CURSE_OF_EXHAUSTION="\229\188\186\229\140\150\231\150\178\229\138\179\232\175\133\229\146\146",IMPROVED_CURSE_OF_WEAKNESS="\229\188\186\229\140\150\232\153\154\229\188\177\232\175\133\229\146\146",IMPROVED_DRAIN_LIFE="\229\188\186\229\140\150\229\191\184\229\191\150\231\148\159\229\145\189",IMPROVED_DRAIN_MANA="\229\188\186\229\140\150\229\191\184\229\191\150\230\179\149\229\138\155",IMPROVED_DRAIN_SOUL="\229\188\186\229\140\150\229\191\184\229\191\150\231\191\181\233\173\130",IMPROVED_LIFE_TAP="\229\188\186\229\140\150\231\148\159\229\145\189\229\136\134\230\181\191",LIFE_TAP="\231\148\159\229\145\189\229\136\134\230\181\191",NIGHTFALL="\229\164\156\229\185\149",SHADOW_MASTERY="\230\154\151\229\189\177\230\142\140\230\191\161",SIPHON_LIFE="\231\148\159\229\145\189\232\153\185\229\191\184",SUPPRESSION="\233\149\135\229\142\139",AMPLIFY_MAGIC="\233\173\148\230\179\149\229\162\158\230\149\136",ARCANE_BRILLIANCE="\229\165\165\230\156\175\229\133\137\232\190\137",ARCANE_CONCENTRATION="\229\165\165\230\156\175\228\184\147\230\179\168",ARCANE_EXPLOSION="\233\173\148\231\136\134\230\156\175",ARCANE_FOCUS="\229\165\165\230\156\175\233\155\134\228\184\173",ARCANE_INSTABILITY="\229\165\165\230\156\175\229\162\158\230\149\136",ARCANE_INTELLECT="\229\165\165\230\156\175\230\153\186\230\133\167",ARCANE_MEDITATION="\229\165\165\230\156\175\229\134\165\230\131\179",ARCANE_MIND="\229\165\165\230\156\175\229\191\131\230\153\186",ARCANE_MISSILES="\229\165\165\230\156\175\233\163\158\229\188\185",ARCANE_POWER="\229\165\165\230\156\175\229\188\186\229\140\150",ARCANE_SUBTLETY="\229\165\165\230\156\175\231\178\190\229\166\153",BLINK="\233\151\170\231\142\176\230\156\175",CLEARCASTING="\232\138\130\232\131\189\230\150\189\230\179\149",CONJURE_FOOD="\233\128\160\233\163\159\230\156\175",CONJURE_MANA_AGATE="\229\136\182\233\128\160\233\173\148\230\179\149\231\142\155\231\145\153",CONJURE_MANA_CITRINE="\229\136\182\233\128\160\233\173\148\230\179\149\233\187\132\230\176\180\230\153\182",CONJURE_MANA_JADE="\229\136\182\233\128\160\233\173\148\230\179\149\231\191\161\231\191\160",CONJURE_MANA_RUBY="\229\136\182\233\128\160\233\173\148\230\179\149\231\186\162\229\174\191\231\159\179",CONJURE_WATER="\233\128\160\230\176\180\230\156\175",COUNTERSPELL="\230\179\149\230\156\175\229\191\191\229\136\182",DAMPEN_MAGIC="\233\173\148\230\179\149\230\138\145\229\136\182",DETECT_MAGIC="\228\190\166\230\181\139\233\173\148\230\179\149",EVOCATION="\229\148\164\233\134\146",IMPROVED_ARCANE_EXPLOSION="\229\188\186\229\140\150\233\173\148\231\136\134\230\156\175",IMPROVED_ARCANE_MISSILES="\229\188\186\229\140\150\229\165\165\230\156\175\233\163\158\229\188\185",IMPROVED_COUNTERSPELL="\229\188\186\229\140\150\230\179\149\230\156\175\229\191\191\229\136\182",IMPROVED_DAMPEN_MAGIC="\229\188\186\229\140\150\233\173\148\230\179\149\230\138\145\229\136\182",IMPROVED_MANA_SHIELD="\229\188\186\229\140\150\230\179\149\229\138\155\230\138\164\231\155\190",MAGE_ARMOR="\233\173\148\231\148\178\230\156\175",MANA_SHIELD="\230\179\149\229\138\155\230\138\164\231\155\190",POLYMORPH="\229\191\152\229\189\162\230\156\175",PORTAL_DARNASSUS="\228\188\160\233\128\191\233\151\168\239\188\154\232\190\190\231\186\179\232\139\191\230\150\175",PORTAL_IRONFORGE="\228\188\160\233\128\191\233\151\168\239\188\154\233\147\191\231\130\137\229\160\161",PORTAL_ORGRIMMAR="\228\188\160\233\128\191\233\151\168\239\188\154\229\165\165\230\160\188\231\145\158\231\142\155",PORTAL_STORMWIND="\228\188\160\233\128\191\233\151\168\239\188\154\230\154\180\233\163\142\229\159\142",PORTAL_THUNDER_BLUFF="\228\188\160\233\128\191\233\151\168\239\188\154\233\155\183\233\156\134\229\180\150",PORTAL_UNDERCITY="\228\188\160\233\128\191\233\151\168\239\188\154\229\185\189\230\154\151\229\159\142",PRESENCE_OF_MIND="\230\176\148\229\174\154\231\165\158\233\151\178",REMOVE_LESSER_CURSE="\232\167\163\233\153\164\230\172\161\231\186\167\232\175\133\229\146\146",SLOW_FALL="\231\188\147\232\191\189\230\156\175",TELEPORT_DARNASSUS="\228\188\160\233\128\191\239\188\154\232\190\190\231\186\179\232\139\191\230\150\175",TELEPORT_IRONFORGE="\228\188\160\233\128\191\239\188\154\233\147\191\231\130\137\229\160\161",TELEPORT_ORGRIMMAR="\228\188\160\233\128\191\239\188\154\229\165\165\230\160\188\231\145\158\231\142\155",TELEPORT_STORMWIND="\228\188\160\233\128\191\239\188\154\230\154\180\233\163\142\229\159\142",TELEPORT_THUNDER_BLUFF="\228\188\160\233\128\191\239\188\154\233\155\183\233\156\134\229\180\150",TELEPORT_UNDERCITY="\228\188\160\233\128\191\239\188\154\229\185\189\230\154\151\229\159\142",WAND_SPECIALIZATION="\233\173\148\230\191\150\228\184\147\231\178\190",ANGER_MANAGEMENT="\230\132\164\230\128\146\230\142\140\230\142\167",AXE_SPECIALIZATION="\230\150\167\228\184\147\231\178\190",BATTLE_STANCE="\230\136\152\230\150\151\229\167\191\230\128\191",BATTLE_STANCE_PASSIVE="Battle Stance Passive",CHARGE="\229\134\178\233\148\139",CHARGE_RAGE_BONUS_EFFECT="Charge Rage Bonus Effect",DEEP_WOUNDS="\233\135\191\228\188\164",DEFLECTION="\229\191\191\230\150\156",HAMSTRING="\230\150\173\231\173\139",HEROIC_STRIKE="\232\139\177\229\139\135\230\137\147\229\135\187",IMPALE="\231\169\191\229\136\186",IMPROVED_CHARGE="\229\188\186\229\140\150\229\134\178\233\148\139",IMPROVED_HAMSTRING="\229\188\186\229\140\150\230\150\173\231\173\139",IMPROVED_HEROIC_STRIKE="\229\188\186\229\140\150\232\139\177\229\139\135\230\137\147\229\135\187",IMPROVED_OVERPOWER="\229\188\186\229\140\150\229\142\139\229\136\182",IMPROVED_PUMMEL="\229\188\186\229\140\150\230\139\179\229\135\187",IMPROVED_REND="\229\188\186\229\140\150\230\146\149\232\163\130",IMPROVED_THUNDER_CLAP="\229\188\186\229\140\150\233\155\183\233\156\134\228\184\128\229\135\187",LONG_DAZE="\233\149\191\230\151\182\233\151\180\231\156\169\230\153\149",MACE_SPECIALIZATION="\233\148\164\231\177\187\230\173\166\229\153\168\228\184\147\231\178\190",MACE_STUN_EFFECT="\233\148\164\229\135\187\230\152\191\232\191\183\230\149\136\230\158\156",MOCKING_BLOW="\230\131\169\230\136\146\231\151\155\229\135\187",MORTAL_STRIKE="\232\135\180\230\173\187\230\137\147\229\135\187",OVERPOWER="\229\142\139\229\136\182",POLEARM_SPECIALIZATION="\233\149\191\230\159\132\230\173\166\229\153\168\228\184\147\231\178\190",REND="\230\146\149\232\163\130",RETALIATION="\229\191\191\229\135\187\233\163\142\230\154\180",SWEEPING_STRIKES="\230\168\170\230\137\171\230\148\187\229\135\187",SWORD_SPECIALIZATION="\229\137\145\231\177\187\230\173\166\229\153\168\228\184\147\231\178\190",TACTICAL_MASTERY="\230\136\152\230\156\175\230\142\140\230\191\161",THUNDER_CLAP="\233\155\183\233\156\134\228\184\128\229\135\187",TWO_HANDED_WEAPON_SPECIALIZATION="\229\191\140\230\137\139\230\173\166\229\153\168\228\184\147\231\178\190",AMBUSH="\228\188\191\229\135\187",CHEAP_SHOT="\229\191\183\232\162\173",COLD_BLOOD="\229\134\183\232\161\128",EVISCERATE="\229\137\148\233\170\168",EXPOSE_ARMOR="\231\160\180\231\148\178",GARROTE="\231\187\158\229\150\137",IMPROVED_DEADLY_POISON="\229\188\186\229\140\150\232\135\180\229\145\189\230\175\146\232\191\175",IMPROVED_EVISCERATE="\229\188\186\229\140\150\229\137\148\233\170\168",IMPROVED_EXPOSE_ARMOR="\229\188\186\229\140\150\231\160\180\231\148\178",IMPROVED_INSTANT_POISON="\229\188\186\229\140\150\233\128\159\230\149\136\230\175\146\232\191\175",IMPROVED_KIDNEY_SHOT="\229\188\186\229\140\150\232\130\190\229\135\187",IMPROVED_SLICE_AND_DICE="\229\188\186\229\140\150\229\136\135\229\137\178",KIDNEY_SHOT="\232\130\190\229\135\187",LETHALITY="\232\135\180\229\145\189\229\191\183\232\162\173",MALICE="\230\191\182\230\132\191",MURDER="\232\176\139\230\191\128",RELENTLESS_STRIKES="\230\151\160\230\131\133\230\137\147\229\135\187",REMORSELESS_ATTACKS="\229\134\183\233\133\183\230\148\187\229\135\187",RUPTURE="\229\137\178\232\163\130",RUTHLESSNESS="\230\151\160\230\131\133",SEAL_FATE="\229\176\191\229\191\176\229\145\189\232\191\191",SLICE_AND_DICE="\229\136\135\229\137\178",VIGOR="\231\178\190\229\138\155",VILE_POISONS="\230\191\182\230\128\167\230\175\146\232\191\175",ONE_HANDED_AXES="\229\191\149\230\137\139\230\150\167",BARKSKIN="\230\160\145\231\154\174\230\156\175",BARKSKIN_EFFECT="Barkskin Effect",ENTANGLING_ROOTS="\231\186\160\231\188\160\230\160\185\233\161\187",FAERIE_FIRE="\231\178\190\231\191\181\228\185\139\231\191\171",HIBERNATE="\228\188\145\231\156\160",HURRICANE="\233\163\147\233\163\142",IMPROVED_ENTANGLING_ROOTS="\229\188\186\229\140\150\231\186\160\231\188\160\230\160\185\233\161\187",IMPROVED_MOONFIRE="\229\188\186\229\140\150\230\156\136\231\191\171\230\156\175",IMPROVED_NATURES_GRASP="\229\188\186\229\140\150\232\135\170\231\132\182\228\185\139\230\191\161",IMPROVED_STARFIRE="\229\188\186\229\140\150\230\152\159\231\191\171\230\156\175",IMPROVED_THORNS="\229\188\186\229\140\150\232\191\134\230\163\152\230\156\175",IMPROVED_WRATH="\229\188\186\229\140\150\230\132\164\230\128\146",MOONFIRE="\230\156\136\231\191\171\230\156\175",MOONFURY="\230\156\136\230\128\146",MOONGLOW="\230\156\136\229\133\137",MOONKIN_AURA="\230\158\173\229\133\189\229\133\137\231\142\175",MOONKIN_FORM="\230\158\173\229\133\189\229\189\162\230\128\191\239\188\136\232\162\171\229\138\168\239\188\137",NATURAL_SHAPESHIFTER="\232\135\170\231\132\182\229\191\152\229\189\162",NATURAL_WEAPONS="\230\173\166\229\153\168\229\185\179\232\161\161",NATURES_GRACE="\232\135\170\231\132\182\228\185\139\232\181\191",NATURES_GRASP="\232\135\170\231\132\182\228\185\139\230\191\161",NATURES_REACH="\232\135\170\231\132\182\229\187\182\228\188\184",OMEN_OF_CLARITY="\230\184\133\230\153\176\233\162\132\229\133\134",SOOTHE_ANIMAL="\229\174\137\230\138\154\229\138\168\231\137\169",STARFIRE="\230\152\159\231\191\171\230\156\175",TELEPORT_MOONGLADE="\228\188\160\233\128\191\239\188\154\230\156\136\229\133\137\230\158\151\229\156\176",THORNS="\232\191\134\230\163\152\230\156\175",VENGEANCE="\229\164\191\228\187\135",WRATH="\230\132\164\230\128\146",ASPECT_OF_THE_BEAST="\233\135\142\229\133\189\229\174\136\230\138\164",ASPECT_OF_THE_CHEETAH="\231\140\142\232\177\185\229\174\136\230\138\164",ASPECT_OF_THE_HAWK="\233\155\132\233\185\176\229\174\136\230\138\164",ASPECT_OF_THE_MONKEY="\231\191\181\231\140\180\229\174\136\230\138\164",ASPECT_OF_THE_PACK="\232\177\185\231\190\164\229\174\136\230\138\164",ASPECT_OF_THE_WILD="\233\135\142\230\128\167\229\174\136\230\138\164",BEAST_LORE="\233\135\142\229\133\189\231\159\165\232\175\134",BESTIAL_DISCIPLINE="\233\135\142\229\133\189\230\136\146\229\190\139",BESTIAL_SWIFTNESS="\233\135\142\229\133\189\232\191\133\230\191\183",BESTIAL_WRATH="\231\139\130\233\135\142\230\128\146\231\191\171",CALL_PET="\229\191\172\229\148\164\229\174\160\231\137\169",DISMISS_PET="\232\167\163\230\149\163\233\135\142\229\133\189",EAGLE_EYE="\233\185\176\231\156\188\230\156\175",ENDURANCE_TRAINING="\232\128\191\228\185\133\232\174\173\231\187\131",EYES_OF_THE_BEAST="\233\135\142\229\133\189\228\185\139\231\156\188",FEED_PET="\229\150\130\229\133\187\229\174\160\231\137\169",FEROCITY="\229\135\182\230\154\180",FRENZY="\231\139\130\228\185\177",IMPROVED_ASPECT_OF_THE_HAWK="\229\188\186\229\140\150\233\155\132\233\185\176\229\174\136\230\138\164",IMPROVED_ASPECT_OF_THE_MONKEY="\229\188\186\229\140\150\231\191\181\231\140\180\229\174\136\230\138\164",IMPROVED_EYES_OF_THE_BEAST="\229\188\186\229\140\150\233\135\142\229\133\189\228\185\139\231\156\188",IMPROVED_MEND_PET="\229\188\186\229\140\150\230\178\187\231\150\151\229\174\160\231\137\169",IMPROVED_REVIVE_PET="\229\188\186\229\140\150\229\164\191\230\180\187\229\174\160\231\137\169",INTIMIDATION="\232\131\191\232\191\171",MEND_PET="\230\178\187\231\150\151\229\174\160\231\137\169",PATHFINDING="\229\175\187\232\183\175",REVIVE_PET="\229\164\191\230\180\187\229\174\160\231\137\169",SCARE_BEAST="\230\191\191\229\191\147\233\135\142\229\133\189",SPIRIT_BOND="\231\191\181\233\173\130\232\191\148\231\187\147",TAME_BEAST="\233\169\175\230\156\191\233\135\142\229\133\189",THICK_HIDE="\229\142\154\231\154\174",TRANQUILIZING_SHOT="\229\174\191\231\165\158\229\176\132\229\135\187",UNLEASHED_FURY="\231\139\130\230\128\146\233\135\138\230\148\190",ARCANE_RESISTANCE="\229\165\165\230\156\175\230\138\151\230\128\167",BEAST_TRAINING="\232\174\173\231\187\131\233\135\142\229\133\189",BITE="\230\146\149\229\146\172",CLAW="\231\136\170\229\135\187",COWER="\231\149\191\231\188\169",DASH="\231\170\191\232\191\155",DIVE="\228\191\175\229\134\178",FIRE_RESISTANCE="\231\191\171\231\132\176\230\138\151\230\128\167",FROST_RESISTANCE="\229\134\176\233\156\156\230\138\151\230\128\167",FURIOUS_HOWL="\231\139\130\230\128\146\228\185\139\229\154\142",GREAT_STAMINA="\230\140\191\228\185\133\232\128\191\229\138\155",GROWL="\228\189\142\229\191\188",HARASS="\228\190\181\230\137\176",LIGHTNING_BREATH="\233\151\170\231\148\181\229\191\191\230\191\175",NATURAL_ARMOR="\232\135\170\231\132\182\230\138\164\231\148\178",NATURE_RESISTANCE="\232\135\170\231\132\182\230\138\151\230\128\167",PROWL="\230\189\156\228\188\191",SCORPID_POISON="\232\191\142\230\175\146",SCREECH="\229\176\150\229\149\184",SHADOW_RESISTANCE="\230\154\151\229\189\177\230\138\151\230\128\167",BOWS="\229\188\147",SHOOT_BOW="\229\188\147\229\176\132\229\135\187",CLOTH="\229\184\131\231\148\178",ADRENALINE_RUSH="\229\134\178\229\138\168",AGGRESSION="\228\190\181\231\149\165",BACKSTAB="\232\131\140\229\136\186",BLADE_FLURRY="\229\137\145\229\136\131\228\185\177\232\136\158",DAGGER_SPECIALIZATION="\229\140\149\233\166\150\228\184\147\231\178\190",DUAL_WIELD_SPECIALIZATION="\229\191\140\230\173\166\229\153\168\228\184\147\231\178\190",EVASION="\233\151\170\233\191\191",FEINT="\228\189\175\230\148\187",FIST_WEAPON_SPECIALIZATION="\230\139\179\229\165\151\228\184\147\231\178\190",GOUGE="\229\135\191\229\135\187",IMPROVED_BACKSTAB="\229\188\186\229\140\150\232\131\140\229\136\186",IMPROVED_EVASION="\229\188\186\229\140\150\233\151\170\233\191\191",IMPROVED_GOUGE="\229\188\186\229\140\150\229\135\191\229\135\187",IMPROVED_KICK="\229\188\186\229\140\150\232\132\154\232\184\162",IMPROVED_SINISTER_STRIKE="\229\188\186\229\140\150\233\130\170\230\191\182\230\148\187\229\135\187",IMPROVED_SPRINT="\229\188\186\229\140\150\231\150\190\232\183\145",KICK="\232\132\154\232\184\162",LIGHTNING_REFLEXES="\233\151\170\231\148\181\229\191\191\229\176\132",PRECISION="\231\178\190\231\161\174",RIPOSTE="\232\191\152\229\135\187",ROGUE_PASSIVE="Rogue Passive",SINISTER_STRIKE="\233\130\170\230\191\182\230\148\187\229\135\187",SPRINT="\231\150\190\232\183\145",THROWING_WEAPON_SPECIALIZATION="\230\138\149\230\142\183\230\173\166\229\153\168\228\184\147\231\178\190",CROSSBOWS="\229\188\169",SHOOT_CROSSBOW="\229\188\169\229\176\132\229\135\187",DAGGERS="\229\140\149\233\166\150",BLOCK="\230\160\188\230\140\161",DEFENSE="\233\152\178\229\190\161",DEFENSIVE_STATE="Defensive State",DEFENSIVE_STATE_2="Defensive State 2",DODGE="\232\186\178\233\151\170",PARRY="\230\139\155\230\158\182",SPELLDEFENSE="SPELLDEFENSE",BANISH="\230\148\190\233\128\191\230\156\175",CREATE_FIRESTONE="\229\136\182\233\128\160\231\191\171\231\132\176\231\159\179",CREATE_HEALTHSTONE="\229\136\182\233\128\160\230\178\187\231\150\151\231\159\179",CREATE_SOULSTONE="\229\136\182\233\128\160\230\158\191\230\149\136\231\191\181\233\173\130\231\159\179",CREATE_SPELLSTONE="\229\136\182\233\128\160\229\188\186\230\149\136\230\179\149\230\156\175\231\159\179",DEMON_ARMOR="\233\173\148\231\148\178\230\156\175",DEMON_SKIN="\230\191\182\233\173\148\231\154\174\232\130\164",DEMONIC_EMBRACE="\230\191\182\233\173\148\228\185\139\230\139\165",DEMONIC_SACRIFICE="\230\191\182\233\173\148\231\137\186\231\137\178",DETECT_GREATER_INVISIBILITY="\228\190\166\230\181\139\229\188\186\230\149\136\233\154\191\229\189\162",DETECT_INVISIBILITY="\228\190\166\230\181\139\233\154\191\229\189\162",DETECT_LESSER_INVISIBILITY="\228\190\166\230\181\139\230\172\161\231\186\167\233\154\191\229\189\162",ENSLAVE_DEMON="\229\165\180\229\189\185\230\191\182\233\173\148",EYE_OF_KILROGG="\229\159\186\229\176\148\231\189\151\230\160\188\228\185\139\231\156\188",FEL_DOMINATION="\230\191\182\233\173\148\230\148\175\233\133\191",FEL_INTELLECT="\230\191\182\233\173\148\230\153\186\229\138\155",FEL_STAMINA="\230\191\182\233\173\148\232\128\191\229\138\155",HEALTH_FUNNEL="\231\148\159\229\145\189\233\128\154\233\191\147",IMPROVED_ENSLAVE_DEMON="\229\188\186\229\140\150\229\165\180\229\189\185\230\191\182\233\173\148",IMPROVED_FIRESTONE="\229\188\186\229\140\150\231\191\171\231\132\176\231\159\179",IMPROVED_HEALTH_FUNNEL="\229\188\186\229\140\150\231\148\159\229\145\189\233\128\154\233\191\147",IMPROVED_HEALTHSTONE="\229\188\186\229\140\150\230\178\187\231\150\151\231\159\179",IMPROVED_IMP="\229\188\186\229\140\150\229\176\191\233\172\188",IMPROVED_SPELLSTONE="\229\188\186\229\140\150\230\179\149\230\156\175\231\159\179",IMPROVED_SUCCUBUS="\229\188\186\229\140\150\233\173\133\233\173\148",IMPROVED_VOIDWALKER="\229\188\186\229\140\150\232\153\154\231\169\186\232\161\140\232\128\133",INFERNO="\229\156\176\231\139\177\231\191\171",MASTER_DEMONOLOGIST="\230\191\182\233\173\148\229\173\166\232\175\134\229\164\167\229\184\136",MASTER_SUMMONER="\229\191\172\229\148\164\229\164\167\229\184\136",RITUAL_OF_DOOM="\230\156\171\230\151\165\228\187\170\229\188\191",RITUAL_OF_DOOM_EFFECT="\230\156\171\230\151\165\228\187\170\229\188\191\230\149\136\230\158\156",RITUAL_OF_SUMMONING="\229\191\172\229\148\164\228\187\170\229\188\191",SENSE_DEMONS="\230\132\159\231\159\165\230\191\182\233\173\148",SHADOW_WARD="\233\152\178\230\138\164\230\154\151\229\189\177\231\187\147\231\149\140",SOUL_LINK="\231\191\181\233\173\130\233\147\190\230\142\165",SUMMON_DREADSTEED="\229\191\172\229\148\164\230\191\191\230\131\167\230\136\152\233\169\172",SUMMON_FELHUNTER="\229\191\172\229\148\164\229\156\176\231\139\177\231\140\142\231\138\172",SUMMON_FELSTEED="\229\191\172\229\148\164\229\156\176\231\139\177\230\136\152\233\169\172",SUMMON_IMP="\229\191\172\229\148\164\229\176\191\233\172\188",SUMMON_SUCCUBUS="\229\191\172\229\148\164\233\173\133\233\173\148",SUMMON_VOIDWALKER="\229\191\172\229\148\164\232\153\154\231\169\186\232\161\140\232\128\133",UNENDING_BREATH="\233\173\148\230\191\175\230\156\175",UNHOLY_POWER="\233\130\170\230\191\182\229\188\186\229\140\150",AFTERMATH="\230\184\133\231\174\151",BANE="\231\191\190\231\165\184",CATACLYSM="\231\191\190\229\191\152",CONFLAGRATE="\231\135\131\231\131\167",DESTRUCTIVE_REACH="\230\175\191\231\191\173\229\187\182\228\188\184",DEVASTATION="\231\160\180\229\191\191",EMBERSTORM="\231\191\165\231\191\128\233\163\142\230\154\180",HELLFIRE="\229\156\176\231\139\177\231\131\136\231\132\176",HELLFIRE_EFFECT="\229\156\176\231\139\177\231\131\136\231\132\176\230\149\136\230\158\156",IMMOLATE="\231\140\174\231\165\173",IMPROVED_FIREBOLT="\229\188\186\229\140\150\231\191\171\231\132\176\231\174\173",IMPROVED_IMMOLATE="\229\188\186\229\140\150\231\140\174\231\165\173",IMPROVED_LASH_OF_PAIN="\229\188\186\229\140\150\229\137\167\231\151\155\233\158\173\231\172\158",IMPROVED_SEARING_PAIN="\229\188\186\229\140\150\231\191\188\231\131\173\228\185\139\231\151\155",IMPROVED_SHADOW_BOLT="\229\188\186\229\140\150\230\154\151\229\189\177\231\174\173",INTENSITY="\229\188\186\231\131\136",PYROCLASM="\231\191\171\231\132\176\229\134\178\230\146\158",RAIN_OF_FIRE="\231\191\171\231\132\176\228\185\139\233\155\168",RUIN="\230\175\191\231\191\173",SEARING_PAIN="\231\191\188\231\131\173\228\185\139\231\151\155",SHADOW_BOLT="\230\154\151\229\189\177\231\174\173",SHADOWBURN="\230\154\151\229\189\177\231\191\188\231\131\167",SOUL_FIRE="\231\191\181\233\173\130\228\185\139\231\191\171",DISPEL_MAGIC="\233\169\177\230\149\163\233\173\148\230\179\149",DIVINE_SPIRIT="\231\165\158\229\156\163\228\185\139\231\191\181",ELUNES_GRACE="\232\137\190\233\156\178\230\191\169\231\154\132\232\181\191\231\166\191",FEEDBACK="\229\155\158\233\166\136",FOCUSED_CASTING="\228\184\147\230\179\168\230\150\189\230\179\149",FORCE_OF_WILL="\230\132\191\229\191\151\228\185\139\229\138\155",IMPROVED_INNER_FIRE="\229\188\186\229\140\150\229\191\131\231\191\181\228\185\139\231\191\171",IMPROVED_MANA_BURN="\229\188\186\229\140\150\230\179\149\229\138\155\231\135\131\231\131\167",IMPROVED_POWER_WORD_FORTITUDE="\229\188\186\229\140\150\231\156\159\232\168\128\230\156\175\239\188\154\233\159\167",IMPROVED_POWER_WORD_SHIELD="\229\188\186\229\140\150\231\156\159\232\168\128\230\156\175\239\188\154\231\155\190",INNER_FIRE="\229\191\131\231\191\181\228\185\139\231\191\171",INNER_FOCUS="\229\191\131\231\191\181\228\184\147\230\179\168",LEVITATE="\230\188\130\230\181\174\230\156\175",MANA_BURN="\230\179\149\229\138\155\231\135\131\231\131\167",MARTYRDOM="\230\174\137\233\154\190",MEDITATION="\229\134\165\230\131\179",MENTAL_AGILITY="\231\178\190\231\165\158\230\149\191\233\148\191",MENTAL_STRENGTH="\229\191\131\231\191\181\228\185\139\229\138\155",POWER_INFUSION="zzOLDSpell - Reuse 10060",POWER_WORD_FORTITUDE="\231\156\159\232\168\128\230\156\175\239\188\154\233\159\167",POWER_WORD_SHIELD="\231\156\159\232\168\128\230\156\175\239\188\154\231\155\190",PRAYER_OF_FORTITUDE="\229\191\154\233\159\167\231\165\183\232\168\128",SHACKLE_UNDEAD="\230\191\159\231\188\154\228\186\161\231\191\181",SILENT_RESOLVE="\230\151\160\229\163\176\230\182\136\233\128\128",STARSHARDS="\230\152\159\232\190\176\231\162\142\231\137\135",UNBREAKABLE_WILL="\229\191\154\229\174\154\230\132\191\229\191\151",DUAL_WIELD="\229\191\140\230\173\166\229\153\168",FIND_TREASURE="\229\175\187\230\137\190\232\180\162\229\174\191",GUN_SPECIALIZATION="\230\158\170\230\162\176\228\184\147\231\178\190",STONEFORM="\231\159\179\229\131\191\229\189\162\230\128\191",CALL_OF_FLAME="\231\131\136\231\132\176\229\191\172\229\148\164",CALL_OF_THUNDER="\233\155\183\233\156\134\229\191\172\229\148\164",CHAIN_LIGHTNING="\233\151\170\231\148\181\233\147\190",CONCUSSION="\233\156\135\232\191\161",CONVECTION="\228\188\160\229\175\188",EARTH_SHOCK="\229\156\176\233\156\135\230\156\175",EARTHBIND_TOTEM="\229\156\176\231\188\154\229\155\190\232\133\190",ELEMENTAL_FOCUS="\229\133\131\231\180\160\233\155\134\228\184\173",ELEMENTAL_FURY="\229\133\131\231\180\160\228\185\139\230\128\146",ELEMENTAL_MASTERY="\229\133\131\231\180\160\230\142\140\230\191\161",FIRE_NOVA_TOTEM="\231\191\171\231\132\176\230\150\176\230\152\159\229\155\190\232\133\190",FLAME_SHOCK="\231\131\136\231\132\176\233\156\135\229\135\187",FROST_SHOCK="\229\134\176\233\156\156\233\156\135\229\135\187",IMPROVED_CHAIN_LIGHTNING="\229\188\186\229\140\150\233\151\170\231\148\181\233\147\190",IMPROVED_FIRE_NOVA_TOTEM="\229\188\186\229\140\150\231\191\171\231\132\176\230\150\176\230\152\159\229\155\190\232\133\190",IMPROVED_LIGHTNING_BOLT="\229\188\186\229\140\150\233\151\170\231\148\181\231\174\173",IMPROVED_MAGMA_TOTEM="\229\188\186\229\140\150\231\134\148\229\178\169\229\155\190\232\133\190",IMPROVED_SEARING_TOTEM="\229\188\186\229\140\150\231\191\188\231\131\173\229\155\190\232\133\190",IMPROVED_STONECLAW_TOTEM="\229\188\186\229\140\150\231\159\179\231\136\170\229\155\190\232\133\190",LIGHTNING_BOLT="\233\151\170\231\148\181\231\174\173",LIGHTNING_MASTERY="\233\151\170\231\148\181\230\142\140\230\191\161",MAGMA_TOTEM="\231\134\148\229\178\169\229\155\190\232\133\190",PURGE="\229\135\128\229\140\150\230\156\175",REVERBERATION="\229\155\158\229\147\191",SEARING_TOTEM="\231\191\188\231\131\173\229\155\190\232\133\190",STONECLAW_TOTEM="\231\159\179\231\136\170\229\155\190\232\133\190",ANCESTRAL_KNOWLEDGE="\229\133\136\231\165\150\231\159\165\232\175\134",ANTICIPATION="\233\162\132\231\159\165",ASTRAL_RECALL="\230\152\159\231\149\140\228\188\160\233\128\191",FAR_SIGHT="\232\167\134\231\149\140\230\156\175",FIRE_RESISTANCE_TOTEM="\230\138\151\231\191\171\229\155\190\232\133\190",FLAMETONGUE_TOTEM="\231\191\171\232\136\140\229\155\190\232\133\190",FLAMETONGUE_WEAPON="\231\191\171\232\136\140\230\173\166\229\153\168",FLURRY="\228\185\177\232\136\158",FROST_RESISTANCE_TOTEM="\230\138\151\229\175\146\229\155\190\232\133\190",FROSTBRAND_WEAPON="\229\134\176\229\176\191\230\173\166\229\153\168",GHOST_WOLF="\229\185\189\233\173\130\228\185\139\231\139\188",GRACE_OF_AIR_TOTEM="\233\163\142\228\185\139\228\188\152\233\155\133\229\155\190\232\133\190",GROUNDING_TOTEM="\230\160\185\229\159\186\229\155\190\232\133\190",IMPROVED_FLAMETONGUE_WEAPON="\229\188\186\229\140\150\231\191\171\232\136\140\230\173\166\229\153\168",IMPROVED_FROSTBRAND_WEAPON="\229\188\186\229\140\150\229\134\176\229\176\191\230\173\166\229\153\168",IMPROVED_GHOST_WOLF="\229\188\186\229\140\150\229\185\189\233\173\130\228\185\139\231\139\188",IMPROVED_GRACE_OF_AIR_TOTEM="\229\188\186\229\140\150\233\163\142\228\185\139\228\188\152\233\155\133\229\155\190\232\133\190",IMPROVED_GROUNDING_TOTEM="\229\188\186\229\140\150\230\160\185\229\159\186\229\155\190\232\133\190",IMPROVED_LIGHTNING_SHIELD="\229\188\186\229\140\150\233\151\170\231\148\181\228\185\139\231\155\190",IMPROVED_ROCKBITER_WEAPON="\229\188\186\229\140\150\231\159\179\229\140\150\230\173\166\229\153\168",IMPROVED_STONESKIN_TOTEM="\229\188\186\229\140\150\231\159\179\232\130\164\229\155\190\232\133\190",IMPROVED_STRENGTH_OF_EARTH_TOTEM="\229\188\186\229\140\150\229\164\167\229\156\176\228\185\139\229\138\155\229\155\190\232\133\190",IMPROVED_WINDFURY_WEAPON="\229\188\186\229\140\150\233\163\142\230\128\146\230\173\166\229\153\168",LIGHTNING_SHIELD="\233\151\170\231\148\181\228\185\139\231\155\190",NATURE_RESISTANCE_TOTEM="\232\135\170\231\132\182\230\138\151\230\128\167\229\155\190\232\133\190",ROCKBITER_WEAPON="\231\159\179\229\140\150\230\173\166\229\153\168",SENTRY_TOTEM="\229\178\151\229\147\168\229\155\190\232\133\190",SHIELD_SPECIALIZATION="\231\155\190\231\137\140\228\184\147\231\178\190",STONESKIN_TOTEM="\231\159\179\232\130\164\229\155\190\232\133\190",STORMSTRIKE="\233\163\142\230\154\180\230\137\147\229\135\187",STRENGTH_OF_EARTH_TOTEM="\229\164\167\229\156\176\228\185\139\229\138\155\229\155\190\232\133\190",THUNDERING_STRIKES="\233\155\183\233\184\163\231\140\155\229\135\187",TOUGHNESS="\229\191\154\233\159\167",TWO_HANDED_AXES_AND_MACES="\229\191\140\230\137\139\230\150\167\229\146\140\233\148\164",WATER_BREATHING="\230\176\180\228\184\139\229\145\188\229\191\184",WATER_WALKING="\230\176\180\228\184\138\232\161\140\232\181\176",WINDFURY_TOTEM="\233\163\142\230\128\146\229\155\190\232\133\190",WINDFURY_WEAPON="\233\163\142\230\128\146\230\173\166\229\153\168",WINDWALL_TOTEM="\233\163\142\229\162\153\229\155\190\232\133\190",AQUATIC_FORM="\230\176\180\230\160\150\229\189\162\230\128\191\239\188\136\232\162\171\229\138\168\239\188\137",BASH="\233\135\191\229\135\187",BEAR_FORM="Bear Form",BLOOD_FRENZY="\232\161\128\228\185\139\231\139\130\230\154\180",BRUTAL_IMPACT="\233\135\142\232\155\174\229\134\178\230\146\158",CAT_FORM="Cat Form",CHALLENGING_ROAR="\230\140\145\230\136\152\229\146\134\229\147\174",DEMORALIZING_ROAR="\230\140\171\229\191\151\229\146\134\229\147\174",DIRE_BEAR_FORM="Dire Bear Form",ENRAGE="\231\139\130\230\128\146",FELINE_GRACE="\232\177\185\228\185\139\228\188\152\233\155\133",FELINE_SWIFTNESS="\232\177\185\228\185\139\232\191\133\230\191\183",FERAL_AGGRESSION="\233\135\142\230\128\167\228\190\181\231\149\165",FERAL_CHARGE="\233\135\142\230\128\167\229\134\178\233\148\139",FERAL_INSTINCT="\233\135\142\230\128\167\230\156\172\232\131\189",FEROCIOUS_BITE="\229\135\182\231\140\155\230\146\149\229\146\172",FRENZIED_REGENERATION="\231\139\130\230\154\180\229\155\158\229\164\191",HEART_OF_THE_WILD="\233\135\142\230\128\167\228\185\139\229\191\131",IMPROVED_SHRED="\229\188\186\229\140\150\230\146\149\231\162\142",
			LEADER_OF_THE_PACK="\229\133\189\231\190\164\233\162\134\232\162\150",MANGLE="\229\137\178\231\162\142",MAUL="\230\167\140\229\135\187",POUNCE="\231\170\191\232\162\173",POUNCE_BLEED="\232\161\128\232\162\173",PREDATORY_STRIKES="\231\140\155\229\133\189\230\148\187\229\135\187",PRIMAL_FURY="\229\142\159\229\167\139\231\139\130\230\128\146",RAKE="\230\137\171\229\135\187",RAVAGE="\230\175\191\231\191\173",RIP="\230\146\149\230\137\175",SAVAGE_FURY="\233\135\142\232\155\174\230\154\180\230\128\146",SHARPENED_CLAWS="\233\148\139\229\136\169\229\133\189\231\136\170",SHRED="\230\146\149\231\162\142",SWIPE="\230\140\165\229\135\187",TIGERS_FURY="\231\140\155\232\153\142\228\185\139\230\128\146",TRACK_HUMANOIDS="\232\191\189\232\184\170\228\186\186\229\158\139\231\148\159\231\137\169",TRAVEL_FORM="\230\151\133\232\161\140\229\189\162\230\128\191",BLAST_WAVE="\229\134\178\229\135\187\230\179\162",BURNING_SOUL="\231\135\131\231\131\167\228\185\139\233\173\130",COMBUSTION="\231\135\131\231\131\167",CRITICAL_MASS="\231\191\171\231\132\176\233\135\191\229\135\187",FELFIRE="\233\173\148\231\191\171",FIRE_BLAST="\231\191\171\231\132\176\229\134\178\229\135\187",FIRE_POWER="\231\191\171\231\132\176\229\188\186\229\140\150",FIRE_VULNERABILITY="\231\151\155\232\139\166\232\175\133\229\146\146",FIRE_WARD="\233\152\178\230\138\164\231\191\171\231\132\176\231\187\147\231\149\140",FIREBALL="\231\191\171\231\191\131\230\156\175",FLAME_THROWING="\231\131\136\231\132\176\230\138\149\230\142\183",FLAMESTRIKE="\231\131\136\231\132\176\233\163\142\230\154\180",IGNITE="\231\130\185\231\135\131",IMPACT="\229\134\178\229\135\187",IMPROVED_FIRE_BLAST="\229\188\186\229\140\150\231\191\171\231\132\176\229\134\178\229\135\187",IMPROVED_FIRE_WARD="\229\188\186\229\140\150\233\152\178\230\138\164\231\191\171\231\132\176\231\187\147\231\149\140",IMPROVED_FIREBALL="\229\188\186\229\140\150\231\191\171\231\191\131\230\156\175",IMPROVED_FLAMESTRIKE="\229\188\186\229\140\150\231\131\136\231\132\176\233\163\142\230\154\180",IMPROVED_SCORCH="\229\188\186\229\140\150\231\191\188\231\131\167",INCINERATE="\231\131\167\229\176\189",PYROBLAST="\231\130\142\231\136\134\230\156\175",SCORCH="\231\191\188\231\131\167",FISHING="\233\146\147\233\177\188",FISHING_POLES="\233\177\188\231\171\191",FIST_WEAPONS="\230\139\179\229\165\151",ARCTIC_REACH="\230\158\191\229\175\146\229\187\182\228\188\184",BLIZZARD="\230\154\180\233\163\142\233\155\170",CHILLED="\229\134\176\229\134\187",COLD_SNAP="\230\128\165\233\128\159\229\134\183\229\191\180",CONE_OF_COLD="\229\134\176\233\148\165\230\156\175",FROST_ARMOR="\233\156\156\231\148\178\230\156\175",FROST_CHANNELING="\229\134\176\233\156\156\229\175\188\232\131\189",FROST_NOVA="\229\134\176\233\156\156\230\150\176\230\152\159",FROST_WARD="\233\152\178\230\138\164\229\134\176\233\156\156\231\187\147\231\149\140",FROSTBITE="\233\156\156\229\175\146\229\136\186\233\170\168",FROSTBOLT="\229\175\146\229\134\176\231\174\173",ICE_ARMOR="\229\134\176\231\148\178\230\156\175",ICE_BARRIER="\229\175\146\229\134\176\230\138\164\228\189\147",ICE_BLOCK="\229\175\146\229\134\176\229\177\191\233\154\156",ICE_SHARDS="\229\175\146\229\134\176\231\162\142\231\137\135",IMPROVED_BLIZZARD="\229\188\186\229\140\150\230\154\180\233\163\142\233\155\170",IMPROVED_CONE_OF_COLD="\229\188\186\229\140\150\229\134\176\233\148\165\230\156\175",IMPROVED_FROST_NOVA="\229\188\186\229\140\150\229\134\176\233\156\156\230\150\176\230\152\159",IMPROVED_FROST_WARD="\229\188\186\229\140\150\233\152\178\230\138\164\229\134\176\233\156\156\231\187\147\231\149\140",IMPROVED_FROSTBOLT="\229\188\186\229\140\150\229\175\146\229\134\176\231\174\173",PERMAFROST="\230\158\191\229\175\146\229\134\176\233\156\156",PIERCING_ICE="\229\136\186\233\170\168\229\175\146\229\134\176",SHATTER="\231\162\142\229\134\176",WINTERS_CHILL="\230\183\177\229\134\172\228\185\139\229\175\146",BATTLE_SHOUT="\230\136\152\230\150\151\230\128\146\229\191\188",BERSERKER_RAGE="\231\139\130\230\154\180\228\185\139\230\128\146",BERSERKER_STANCE="\231\139\130\230\154\180\229\167\191\230\128\191",BERSERKER_STANCE_PASSIVE="\231\139\130\230\154\180\229\167\191\230\128\191\239\188\136\232\162\171\229\138\168\239\188\137",BLOOD_CRAZE="\232\161\128\228\185\139\231\139\130\231\131\173",BLOODTHIRST="\229\151\156\232\161\128",BOOMING_VOICE="\233\156\135\232\128\179\229\151\147\233\159\179",CHALLENGING_SHOUT="\230\140\145\230\136\152\230\128\146\229\191\188",CLEAVE="\233\161\186\229\138\136\230\150\169",CRUELTY="\230\174\139\229\191\191",DEATH_WISH="\230\173\187\228\186\161\228\185\139\230\132\191",DEMORALIZING_SHOUT="\230\140\171\229\191\151\230\128\146\229\191\188",EXECUTE="\230\150\169\230\191\128",IMPROVED_BATTLE_SHOUT="\229\188\186\229\140\150\230\136\152\230\150\151\230\128\146\229\191\188",IMPROVED_BERSERKER_RAGE="\229\188\186\229\140\150\231\139\130\230\154\180\228\185\139\230\128\146",IMPROVED_CHALLENGING_SHOUT="\229\188\186\229\140\150\230\140\145\230\136\152\230\128\146\229\191\188",IMPROVED_CLEAVE="\229\188\186\229\140\150\233\161\186\229\138\136\230\150\169",IMPROVED_DEMORALIZING_SHOUT="\229\188\186\229\140\150\230\140\171\229\191\151\230\128\146\229\191\188",IMPROVED_EXECUTE="\229\188\186\229\140\150\230\150\169\230\191\128",IMPROVED_INTERCEPT="\229\188\186\229\140\150\230\139\166\230\136\170",IMPROVED_INTIMIDATING_SHOUT="\229\188\186\229\140\150\231\160\180\232\131\134\230\128\146\229\191\188",IMPROVED_SLAM="\229\188\186\229\140\150\231\140\155\229\135\187",INTERCEPT="\230\139\166\230\136\170",INTIMIDATING_SHOUT="\231\160\180\232\131\134\230\128\146\229\191\188",PIERCING_HOWL="\229\136\186\232\128\179\230\128\146\229\191\188",PUMMEL="\230\139\179\229\135\187",RECKLESSNESS="\233\178\191\232\142\189",SLAM="\231\140\155\229\135\187",UNBRIDLED_WRATH="\230\128\146\228\184\191\229\191\175\233\191\191",UNBRIDLED_WRATH_EFFECT="\230\128\146\228\184\191\229\191\175\233\191\191\230\149\136\230\158\156",WHIRLWIND="\230\151\139\233\163\142\230\150\169",ATTACK="\230\148\187\229\135\187",ATTACKING="\230\148\187\229\135\187",CLOSING="\229\133\179\233\151\173",DETECT="\228\190\166\230\181\139",DUEL="\229\134\179\230\150\151",GENERIC="Generic",GROVEL="\229\140\191\229\140\191",HONORLESS_TARGET="\230\151\160\232\191\163\232\170\137\231\155\174\230\160\135",OPENING="\230\137\147\229\188\128",OPENING___NO_TEXT="Opening - No Text",REMOVE_INSIGNIA="\232\167\163\233\153\164\229\190\189\232\174\176",STUCK="\229\191\161\230\173\187",GUNS="\230\158\170\230\162\176",SHOOT_GUN="\230\158\170\230\162\176\229\176\132\229\135\187",ABOLISH_DISEASE="\233\169\177\233\153\164\231\150\190\231\151\133",CURE_DISEASE="\231\165\155\231\151\133\230\156\175",DESPERATE_PRAYER="\231\187\191\230\156\155\231\165\183\232\168\128",DIVINE_FURY="\231\165\158\229\156\163\228\185\139\230\128\146",FEAR_WARD="\233\152\178\230\138\164\230\191\191\230\131\167\231\187\147\231\149\140",FLASH_HEAL="\229\191\171\233\128\159\230\178\187\231\150\151",GREATER_HEAL="\229\188\186\230\149\136\230\178\187\231\150\151\230\156\175",HEAL="\230\178\187\231\150\151\230\156\175",HEALING_FOCUS="\229\188\186\229\140\150\229\191\171\233\128\159\230\178\187\231\150\151",HOLY_FIRE="\231\165\158\229\156\163\228\185\139\231\191\171",HOLY_NOVA="\231\165\158\229\156\163\230\150\176\230\152\159",HOLY_SPECIALIZATION="\231\165\158\229\156\163\228\184\147\231\178\190",IMPROVED_HEALING="\229\188\186\229\140\150\230\178\187\231\150\151\230\156\175",IMPROVED_PRAYER_OF_HEALING="\229\188\186\229\140\150\230\178\187\231\150\151\231\165\183\232\168\128",IMPROVED_RENEW="\229\188\186\229\140\150\230\191\162\229\164\191",INSPIRATION="\231\191\181\230\132\159",LESSER_HEAL="\230\172\161\231\186\167\230\178\187\231\150\151\230\156\175",LIGHTWELL="zzOLDSpell - Reuse 724",LIGHTWELL_RENEW="zzOLDSpell - Reuse 7001",PRAYER_OF_HEALING="\230\178\187\231\150\151\231\165\183\232\168\128",RENEW="\230\191\162\229\164\191",RESURRECTION="\229\164\191\230\180\187\230\156\175",SEARING_LIGHT="\229\188\186\229\140\150\230\131\169\229\135\187",SMITE="\230\131\169\229\135\187",SPIRIT_OF_REDEMPTION="\230\149\145\232\181\142\228\185\139\233\173\130",SPIRITUAL_GUIDANCE="\229\190\174\229\166\153",SPIRITUAL_HEALING="\231\178\190\231\165\158\230\178\187\231\150\151",BLESSING_OF_LIGHT="\229\133\137\230\152\142\231\165\191\231\166\191",BLESSING_OF_WISDOM="\230\153\186\230\133\167\231\165\191\231\166\191",CLEANSE="\230\184\133\230\180\191\230\156\175",DIVINE_FAVOR="\231\165\158\230\191\169\230\156\175",DIVINE_INTELLECT="\231\165\158\229\156\163\230\153\186\230\133\167",DIVINE_STRENGTH="\231\165\158\229\156\163\228\185\139\229\138\155",EXORCISM="\233\169\177\233\130\170\230\156\175",FLASH_OF_LIGHT="\229\156\163\229\133\137\233\151\170\231\142\176",HAMMER_OF_WRATH="\230\132\164\230\128\146\228\185\139\233\148\164",HEALING_LIGHT="\229\188\186\229\140\150\229\156\163\229\133\137\230\156\175",HOLY_LIGHT="\229\156\163\229\133\137\230\156\175",HOLY_POWER="\231\165\158\229\156\163\229\188\186\229\140\150",HOLY_SHOCK="\231\165\158\229\156\163\233\156\135\229\135\187",HOLY_WRATH="\231\165\158\229\156\163\230\132\164\230\128\146",ILLUMINATION="\229\191\175\229\191\145",IMPROVED_BLESSING_OF_WISDOM="\229\188\186\229\140\150\230\153\186\230\133\167\231\165\191\231\166\191",IMPROVED_FLASH_OF_LIGHT="\229\188\186\229\140\150\229\156\163\229\133\137\233\151\170\231\142\176",IMPROVED_LAY_ON_HANDS="\229\188\186\229\140\150\229\156\163\231\150\151\230\156\175",IMPROVED_SEAL_OF_RIGHTEOUSNESS="\229\188\186\229\140\150\230\173\163\228\185\137\229\156\163\229\191\176",JUDGEMENT_OF_LIGHT="\229\156\163\229\133\137\229\174\161\229\136\164",JUDGEMENT_OF_RIGHTEOUSNESS="\230\173\163\228\185\137\229\156\163\229\191\176",JUDGEMENT_OF_WISDOM="\230\153\186\230\133\167\229\174\161\229\136\164",LASTING_JUDGEMENT="\229\188\186\229\140\150\229\133\137\230\152\142\229\156\163\229\191\176",LAY_ON_HANDS="\229\156\163\231\150\151\230\156\175",PURIFY="\231\186\175\229\135\128\230\156\175",REDEMPTION="\230\149\145\232\181\142",SEAL_OF_LIGHT="\229\133\137\230\152\142\229\156\163\229\191\176",SEAL_OF_RIGHTEOUSNESS="\230\173\163\228\185\137\229\156\163\229\191\176",SEAL_OF_WISDOM="\230\153\186\230\133\167\229\156\163\229\191\176",SENSE_UNDEAD="\230\132\159\231\159\165\228\186\161\231\191\181",SPIRITUAL_FOCUS="\231\178\190\231\165\158\233\155\134\228\184\173",SUMMON_CHARGER="\229\191\172\229\148\164\230\136\152\233\169\172",SUMMON_WARHORSE="\229\191\172\229\148\164\229\134\155\233\169\172",TURN_UNDEAD="\232\182\133\229\186\166\228\186\161\231\191\181",UNYIELDING_FAITH="zzOLDSpell - Reuse",HORSE_RIDING="\233\170\145\230\156\175\239\188\154\233\169\172",KODO_RIDING="\233\170\145\230\156\175\239\188\154\231\167\145\229\164\154\229\133\189",LEATHER="\231\154\174\233\191\169",PICK_LOCK="\229\188\128\233\148\191",ONE_HANDED_MACES="\229\191\149\230\137\139\233\148\164",MAIL="\233\148\191\231\148\178",AIMED_SHOT="\231\158\132\229\135\134\229\176\132\229\135\187",ARCANE_SHOT="\229\165\165\230\156\175\229\176\132\229\135\187",AUTO_SHOT="\232\135\170\229\138\168\229\176\132\229\135\187",BARRAGE="\229\188\185\229\185\149",BLACK_ARROW="\233\187\145\231\174\173",CONCUSSIVE_SHOT="\233\156\135\232\191\161\229\176\132\229\135\187",DISTRACTING_SHOT="\230\137\176\228\185\177\229\176\132\229\135\187",EFFICIENCY="\230\149\136\231\142\135",FLARE="\231\133\167\230\152\142\229\188\185",HAWK_EYE="\233\185\176\231\156\188",HUNTERS_MARK="\231\140\142\228\186\186\229\191\176\232\174\176",IMPROVED_ARCANE_SHOT="\229\188\186\229\140\150\229\165\165\230\156\175\229\176\132\229\135\187",IMPROVED_CONCUSSIVE_SHOT="\229\188\186\229\140\150\233\156\135\232\191\161\229\176\132\229\135\187",IMPROVED_HUNTERS_MARK="\229\188\186\229\140\150\231\140\142\228\186\186\229\191\176\232\174\176",IMPROVED_SCORPID_STING="\229\188\186\229\140\150\230\175\146\232\191\142\233\146\137\229\136\186",IMPROVED_SERPENT_STING="\229\188\186\229\140\150\230\175\146\232\155\135\233\146\137\229\136\186",LETHAL_SHOTS="\229\164\186\229\145\189\229\176\132\229\135\187",MORTAL_SHOTS="\232\135\180\230\173\187\229\176\132\229\135\187",MULTI_SHOT="\229\164\154\233\135\191\229\176\132\229\135\187",RANGED_WEAPON_SPECIALIZATION="\232\191\156\231\168\139\230\173\166\229\153\168\228\184\147\231\178\190",RAPID_FIRE="\230\128\165\233\128\159\229\176\132\229\135\187",SCATTER_SHOT="\233\169\177\230\149\163\229\176\132\229\135\187",SCORPID_STING="\230\175\146\232\191\142\233\146\137\229\136\186",SERPENT_STING="\230\175\146\232\155\135\233\146\137\229\136\186",TRUESHOT_AURA="\229\188\186\229\135\187\229\133\137\231\142\175",VIPER_STING="\232\191\176\232\155\135\233\146\137\229\136\186",VOLLEY="\228\185\177\229\176\132",MECHANOSTRIDER_PILOTING="\233\170\145\230\156\175\239\188\154\230\156\186\230\162\176\233\153\134\232\161\140\233\184\159",QUICKNESS="\232\191\133\230\191\183",SHADOWMELD="\229\189\177\233\191\191",SHADOWMELD_PASSIVE="\229\189\177\233\191\191",WISP_SPIRIT="\231\178\190\231\191\181\228\185\139\233\173\130",BLOOD_FURY="\232\161\128\230\128\167\231\139\130\230\154\180",COMMAND="\229\145\189\228\187\164",HARDINESS="\229\191\154\233\159\167",TAMED_PET_PASSIVE="Tamed Pet Passive",ACTIVATE_MG_TURRET="\229\191\145\229\176\132MGs",FLAMETHROWER="\229\191\145\229\176\132\231\191\171\231\132\176\229\150\183\229\176\132\229\153\168",DEVOUR_MAGIC="\229\191\158\229\153\172\233\173\148\230\179\149",DEVOUR_MAGIC_EFFECT="\229\191\158\229\153\172\233\173\148\230\179\149\230\149\136\230\158\156",PARANOIA="\229\164\154\231\150\145",SPELL_LOCK="\230\179\149\230\156\175\229\176\191\233\148\191",TAINTED_BLOOD="\232\133\191\229\191\191\228\185\139\232\161\128",PET_AGGRESSION="\229\174\160\231\137\169\229\165\189\230\150\151",PET_HARDINESS="\229\174\160\231\137\169\232\128\191\228\185\133",PET_RECOVERY="\229\174\160\231\137\169\230\191\162\229\164\191",PET_RESISTANCE="\229\174\160\231\137\169\230\138\151\233\173\148",BLOOD_PACT="\232\161\128\228\185\139\229\165\145\229\191\176",FIRE_SHIELD="\231\191\171\231\132\176\228\185\139\231\155\190",FIREBOLT="\231\191\171\231\132\176\231\174\173",PHASE_SHIFT="\231\155\184\228\189\191\229\191\152\230\191\162",LASH_OF_PAIN="\229\137\167\231\151\155\233\158\173\231\172\158",LESSER_INVISIBILITY="\230\172\161\231\186\167\233\154\191\229\189\162\230\156\175",SEDUCTION="\232\175\177\230\131\145",SOOTHING_KISS="\229\174\137\230\138\154\228\185\139\229\191\187",CONSUME_SHADOWS="\229\191\158\229\153\172\230\154\151\229\189\177",SACRIFICE="\231\137\186\231\137\178",SUFFERING="\229\191\151\233\154\190",TORMENT="\230\138\152\231\163\168",PLATE_MAIL="\230\191\191\231\148\178",BLINDING_POWDER="\232\135\180\231\155\178\231\178\137",CRIPPLING_POISON="\232\135\180\230\174\139\230\175\146\232\191\175",CRIPPLING_POISON_II="\232\135\180\230\174\139\230\175\146\232\191\175 II",DEADLY_POISON="\232\135\180\229\145\189\230\175\146\232\191\175",DEADLY_POISON_II="\232\135\180\229\145\189\230\175\146\232\191\175 II",DEADLY_POISON_III="\232\135\180\229\145\189\230\175\146\232\191\175 III",DEADLY_POISON_IV="\232\135\180\229\145\189\230\175\146\232\191\175 IV",INSTANT_POISON="\233\128\159\230\149\136\230\175\146\232\191\175",INSTANT_POISON_II="\233\128\159\230\149\136\230\175\146\232\191\175 II",INSTANT_POISON_III="\233\128\159\230\149\136\230\175\146\232\191\175 III",INSTANT_POISON_IV="\233\128\159\230\149\136\230\175\146\232\191\175 IV",INSTANT_POISON_V="\233\128\159\230\149\136\230\175\146\232\191\175 V",INSTANT_POISON_VI="\233\128\159\230\149\136\230\175\146\232\191\175 VI",MIND_NUMBING_POISON="\233\186\187\231\151\185\230\175\146\232\191\175",MIND_NUMBING_POISON_II="\233\186\187\231\151\185\230\175\146\232\191\175 II",MIND_NUMBING_POISON_III="\233\186\187\231\151\185\230\175\146\232\191\175 III",POISONS="\230\175\146\232\191\175",WOUND_POISON="\232\135\180\228\188\164\230\175\146\232\191\175",WOUND_POISON_II="\232\135\180\228\188\164\230\175\146\232\191\175 II",WOUND_POISON_III="\232\135\180\228\188\164\230\175\146\232\191\175 III",WOUND_POISON_IV="\232\135\180\228\188\164\230\175\146\232\191\175 IV",POLEARMS="\233\149\191\230\159\132\230\173\166\229\153\168",BLOODRAGE="\232\161\128\230\128\167\231\139\130\230\154\180",CONCUSSION_BLOW="\233\156\135\232\191\161\231\140\155\229\135\187",DEFENSIVE_STANCE="\233\152\178\229\190\161\229\167\191\230\128\191",DEFENSIVE_STANCE_PASSIVE="Defensive Stance Passive",DEFIANCE="\230\140\145\232\161\133",DISARM="\231\188\180\230\162\176",IMPROVED_BLOODRAGE="\229\188\186\229\140\150\232\161\128\230\128\167\231\139\130\230\154\180",IMPROVED_DISARM="\229\188\186\229\140\150\231\188\180\230\162\176",IMPROVED_REVENGE="\229\188\186\229\140\150\229\164\191\228\187\135",IMPROVED_SHIELD_BASH="\229\188\186\229\140\150\231\155\190\229\135\187",IMPROVED_SHIELD_BLOCK="\229\188\186\229\140\150\231\155\190\231\137\140\230\160\188\230\140\161",IMPROVED_SHIELD_WALL="\229\188\186\229\140\150\231\155\190\229\162\153",IMPROVED_SUNDER_ARMOR="\229\188\186\229\140\150\231\160\180\231\148\178\230\148\187\229\135\187",IMPROVED_TAUNT="\229\188\186\229\140\150\229\152\178\232\174\189",IRON_WILL="\233\146\162\233\147\191\230\132\191\229\191\151",LAST_STAND="\231\160\180\233\135\156\230\178\137\232\136\159",ONE_HANDED_WEAPON_SPECIALIZATION="\229\191\149\230\137\139\230\173\166\229\153\168\228\184\147\231\178\190",REVENGE="\229\164\191\228\187\135",REVENGE_STUN="\229\164\191\228\187\135\230\152\191\232\191\183",SHIELD_BASH="\231\155\190\229\135\187",SHIELD_BLOCK="\231\155\190\231\137\140\230\160\188\230\140\161",SHIELD_SLAM="\231\155\190\231\137\140\231\140\155\229\135\187",SHIELD_WALL="\231\155\190\229\162\153",SUNDER_ARMOR="\231\160\180\231\148\178\230\148\187\229\135\187",TAUNT="\229\152\178\232\174\189",BLESSING_OF_FREEDOM="\232\135\170\231\148\177\231\165\191\231\166\191",BLESSING_OF_KINGS="\231\142\139\232\128\133\231\165\191\231\166\191",BLESSING_OF_PROTECTION="\228\191\191\230\138\164\231\165\191\231\166\191",BLESSING_OF_SACRIFICE="\231\137\186\231\137\178\231\165\191\231\166\191",BLESSING_OF_SALVATION="\230\139\175\230\149\145\231\165\191\231\166\191",BLESSING_OF_SANCTUARY="\229\186\135\230\138\164\231\165\191\231\166\191",CONCENTRATION_AURA="\228\184\147\230\179\168\229\133\137\231\142\175",DEVOTION_AURA="\232\153\148\232\175\154\229\133\137\231\142\175",DIVINE_INTERVENTION="\231\165\158\229\156\163\229\185\178\230\182\137",DIVINE_PROTECTION="\229\156\163\228\189\145\230\156\175",DIVINE_SHIELD="\229\156\163\231\155\190\230\156\175",FIRE_RESISTANCE_AURA="\231\191\171\231\132\176\230\138\151\230\128\167\229\133\137\231\142\175",FROST_RESISTANCE_AURA="\229\134\176\233\156\156\230\138\151\230\128\167\229\133\137\231\142\175",GUARDIANS_FAVOR="\229\188\186\229\140\150\228\191\191\230\138\164\231\165\191\231\166\191",HAMMER_OF_JUSTICE="\229\136\182\232\163\191\228\185\139\233\148\164",HOLY_SHIELD="\231\165\158\229\156\163\228\185\139\231\155\190",IMPROVED_CONCENTRATION_AURA="\229\188\186\229\140\150\228\184\147\230\179\168\229\133\137\231\142\175",IMPROVED_DEVOTION_AURA="\229\188\186\229\140\150\232\153\148\232\175\154\229\133\137\231\142\175",IMPROVED_HAMMER_OF_JUSTICE="\229\188\186\229\140\150\229\133\172\230\173\163\229\156\163\229\191\176",IMPROVED_RIGHTEOUS_FURY="\229\188\186\229\140\150\230\132\164\230\128\146\229\156\163\229\191\176",JUDGEMENT_OF_JUSTICE="\230\173\163\228\185\137\229\174\161\229\136\164",RECKONING="\230\184\133\231\174\151",REDOUBT="\231\155\190\231\137\140\229\163\191\229\158\146",SEAL_OF_JUSTICE="\229\133\172\230\173\163\229\156\163\229\191\176",SHADOW_RESISTANCE_AURA="\230\154\151\229\189\177\230\138\151\230\128\167\229\133\137\231\142\175",ENGINEERING_SPECIALIZATION="\229\183\165\231\168\139\229\173\166\228\184\147\231\178\190",ESCAPE_ARTIST="\233\128\131\229\145\189\228\184\147\229\174\182",EXPANSIVE_MIND="\229\188\128\233\152\148\230\128\191\231\187\180",DIPLOMACY="\229\164\150\228\186\164",PERCEPTION="\230\132\159\231\159\165",THE_HUMAN_SPIRIT="\228\186\186\231\177\187\231\178\190\233\173\130",BEAST_SLAYING="\233\135\142\229\133\189\230\191\128\230\137\139",BERSERKING="\231\139\130\230\154\180",REGENERATION="\229\134\191\231\148\159",THROWING_SPECIALIZATION="\230\138\149\230\142\183\228\184\147\231\178\190",CANNIBALIZE="\233\163\159\229\176\184",UNDERWATER_BREATHING="\230\176\180\228\184\139\229\145\188\229\191\184",WILL_OF_THE_FORSAKEN="\228\186\161\231\191\181\230\132\191\229\191\151",RAM_RIDING="\233\170\145\230\156\175\239\188\154\231\190\138",RAPTOR_RIDING="\233\170\145\230\156\175\239\188\154\232\191\133\231\140\155\233\190\153",ANCESTRAL_HEALING="\229\133\136\231\165\150\230\178\187\231\150\151",ANCESTRAL_SPIRIT="\229\133\136\231\165\150\228\185\139\233\173\130",CHAIN_HEAL="\230\178\187\231\150\151\233\147\190",COMBAT_ENDURANCE="\228\189\156\230\136\152\230\140\191\228\185\133",CURE_POISON="\230\182\136\230\175\146\230\156\175",DISEASE_CLEANSING_TOTEM="\231\165\155\231\151\133\229\155\190\232\133\190",EVENTIDE="\233\187\132\230\152\191",HEALING_STREAM_TOTEM="\230\178\187\231\150\151\228\185\139\230\179\137\229\155\190\232\133\190",HEALING_WAVE="\230\178\187\231\150\151\230\179\162",IMPROVED_CHAIN_HEAL="\229\188\186\229\140\150\230\178\187\231\150\151\233\147\190",IMPROVED_HEALING_STREAM_TOTEM="\229\188\186\229\140\150\230\178\187\231\150\151\228\185\139\230\179\137\229\155\190\232\133\190",IMPROVED_HEALING_WAVE="\229\188\186\229\140\150\230\178\187\231\150\151\230\179\162",IMPROVED_LESSER_HEALING_WAVE="\229\188\186\229\140\150\230\172\161\231\186\167\230\178\187\231\150\151\230\179\162",IMPROVED_MANA_SPRING_TOTEM="\229\188\186\229\140\150\230\179\149\229\138\155\228\185\139\230\179\137\229\155\190\232\133\190",IMPROVED_REINCARNATION="\229\188\186\229\140\150\229\164\191\231\148\159",LESSER_HEALING_WAVE="\230\172\161\231\186\167\230\178\187\231\150\151\230\179\162",MANA_SPRING_TOTEM="\230\179\149\229\138\155\228\185\139\230\179\137\229\155\190\232\133\190",MANA_TIDE_TOTEM="\230\179\149\229\138\155\228\185\139\230\189\174\229\155\190\232\133\190",NATURES_SWIFTNESS="\232\135\170\231\132\182\232\191\133\230\191\183",POISON_CLEANSING_TOTEM="\230\184\133\230\175\146\229\155\190\232\133\190",PURIFICATION="\229\135\128\229\140\150",REINCARNATION="\229\164\191\231\148\159",TIDAL_FOCUS="\230\189\174\230\177\191\233\155\134\228\184\173",TIDAL_MASTERY="\230\189\174\230\177\191\230\142\140\230\191\161",TOTEMIC_FOCUS="\229\155\190\232\133\190\233\155\134\228\184\173",TREMOR_TOTEM="\230\136\152\230\160\151\229\155\190\232\133\190",ABOLISH_POISON="\233\169\177\230\175\146\230\156\175",ABOLISH_POISON_EFFECT="\233\169\177\230\175\146\230\156\175\230\149\136\230\158\156",FUROR="\230\191\128\230\128\146",GIFT_OF_NATURE="\232\135\170\231\132\182\232\181\191\231\166\191",GIFT_OF_THE_WILD="\233\135\142\230\128\167\232\181\191\231\166\191",HEALING_TOUCH="\230\178\187\231\150\151\228\185\139\232\167\166",IMPROVED_ENRAGE="\229\188\186\229\140\150\231\139\130\230\128\146",IMPROVED_HEALING_TOUCH="\229\188\186\229\140\150\230\178\187\231\150\151\228\185\139\232\167\166",IMPROVED_MARK_OF_THE_WILD="\229\188\186\229\140\150\233\135\142\230\128\167\229\191\176\232\174\176",IMPROVED_REGROWTH="\229\188\186\229\140\150\230\132\136\229\191\136",IMPROVED_REJUVENATION="\229\188\186\229\140\150\229\155\158\230\152\165\230\156\175",IMPROVED_TRANQUILITY="\229\188\186\229\140\150\229\174\191\233\191\153",INNERVATE="\230\191\128\230\180\187",INSECT_SWARM="\232\153\171\231\190\164",MARK_OF_THE_WILD="\233\135\142\230\128\167\229\191\176\232\174\176",NATURES_FOCUS="\232\135\170\231\132\182\233\155\134\228\184\173",REBIRTH="\229\164\191\231\148\159",REFLECTION="\229\191\191\229\176\132",REGROWTH="\230\132\136\229\191\136",REJUVENATION="\229\155\158\230\152\165\230\156\175",REMOVE_CURSE="\232\167\163\233\153\164\232\175\133\229\146\146",SUBTLETY="\229\190\174\229\166\153",TRANQUIL_SPIRIT="\229\174\191\233\191\153\228\185\139\233\173\130",TRANQUILITY="\229\174\191\233\191\153",BENEDICTION="\231\165\136\231\166\191",BLESSING_OF_MIGHT="\229\138\155\233\135\191\231\165\191\231\166\191",CONVICTION="\229\174\154\231\189\170",EYE_FOR_AN_EYE="zzOLDSpell - Reuse",IMPROVED_BLESSING_OF_MIGHT="\229\188\186\229\140\150\229\138\155\233\135\191\231\165\191\231\166\191",IMPROVED_RETRIBUTION_AURA="\229\188\186\229\140\150\230\131\169\231\189\154\229\133\137\231\142\175",IMPROVED_SEAL_OF_THE_CRUSADER="\229\188\186\229\140\150\229\191\191\229\173\151\229\134\155\229\156\163\229\191\176",JUDGEMENT="\229\174\161\229\136\164",JUDGEMENT_OF_COMMAND="\229\145\189\228\187\164\229\174\161\229\136\164",JUDGEMENT_OF_THE_CRUSADER="\229\191\191\229\173\151\229\134\155\229\174\161\229\136\164",REPENTANCE="\229\191\191\230\130\148",RETRIBUTION_AURA="\230\131\169\231\189\154\229\133\137\231\142\175",SANCTITY_AURA="\229\156\163\230\180\191\229\133\137\231\142\175",SEAL_OF_COMMAND="\229\145\189\228\187\164\229\156\163\229\191\176",SEAL_OF_THE_CRUSADER="\229\191\191\229\173\151\229\134\155\229\156\163\229\191\176",VINDICATION="Eagle Scout",BLACKOUT="\230\152\191\233\152\153",DARKNESS="\233\187\145\230\154\151",DEVOURING_PLAGUE="\229\153\172\231\191\181\231\152\159\231\150\171",FADE="\230\184\191\233\154\191\230\156\175",HEX_OF_WEAKNESS="\232\153\154\229\188\177\229\166\150\230\156\175",IMPROVED_FADE="\229\188\186\229\140\150\230\184\191\233\154\191\230\156\175",IMPROVED_MIND_BLAST="\229\188\186\229\140\150\229\191\131\231\191\181\233\156\135\231\136\134",IMPROVED_PSYCHIC_SCREAM="\229\188\186\229\140\150\229\191\131\231\191\181\229\176\150\229\149\184",IMPROVED_SHADOW_WORD_PAIN="\229\188\186\229\140\150\230\154\151\232\168\128\230\156\175\239\188\154\231\151\155",MIND_BLAST="\229\191\131\231\191\181\233\156\135\231\136\134",MIND_CONTROL="\231\178\190\231\165\158\230\142\167\229\136\182",MIND_FLAY="\231\178\190\231\165\158\233\158\173\231\172\158",MIND_SOOTHE="\229\174\137\230\138\154\229\191\131\231\191\181",MIND_VISION="\229\191\131\231\191\181\232\167\134\231\149\140",PSYCHIC_SCREAM="\229\191\131\231\191\181\229\176\150\229\149\184",SHADOW_AFFINITY="\230\154\151\229\189\177\228\186\178\229\146\140",SHADOW_FOCUS="\230\154\151\229\189\177\233\155\134\228\184\173",SHADOW_PROTECTION="\233\152\178\230\138\164\230\154\151\229\189\177",SHADOW_REACH="\230\154\151\229\189\177\229\187\182\228\188\184",SHADOW_WEAVING="\230\154\151\229\189\177\228\185\139\230\179\162",SHADOW_WORD_PAIN="\230\154\151\232\168\128\230\156\175\239\188\154\231\151\155",SHADOWFORM="\230\154\151\229\189\177\229\189\162\230\128\191",SHADOWGUARD="\230\154\151\229\189\177\229\174\136\229\191\171",SILENCE="\230\178\137\233\187\152",SPIRIT_TAP="\231\178\190\231\165\158\229\136\134\230\181\191",TOUCH_OF_WEAKNESS="\232\153\154\229\188\177\228\185\139\232\167\166",VAMPIRIC_EMBRACE="\229\191\184\232\161\128\233\172\188\231\154\132\230\139\165\230\138\177",SHIELD="\231\155\190\231\137\140",STAVES="\230\179\149\230\191\150",BLIND="\232\135\180\231\155\178",CAMOUFLAGE="\228\188\170\232\163\133",DETECT_TRAPS="\228\190\166\230\181\139\233\153\183\233\152\177",DISARM_TRAP="\232\167\163\233\153\164\233\153\183\233\152\177",DISTRACT="\230\137\176\228\185\177",ELUSIVENESS="\233\163\152\229\191\189\228\184\191\229\174\154",GHOSTLY_STRIKE="\233\172\188\233\173\133\230\148\187\229\135\187",HEMORRHAGE="\229\135\186\232\161\128",IMPROVED_AMBUSH="\229\188\186\229\140\150\228\188\191\229\135\187",IMPROVED_CHEAP_SHOT="\229\188\186\229\140\150\229\191\183\232\162\173",IMPROVED_DISTRACT="\229\188\186\229\140\150\230\137\176\228\185\177",IMPROVED_GARROTE="\229\188\186\229\140\150\231\187\158\229\150\137",IMPROVED_RUPTURE="\229\188\186\229\140\150\229\137\178\232\163\130",IMPROVED_SAP="\229\188\186\229\140\150\233\151\183\230\163\191",IMPROVED_VANISH="\229\188\186\229\140\150\230\182\136\229\164\177",INITIATIVE="\229\133\136\229\191\145\229\136\182\228\186\186",MASTER_OF_DECEPTION="\230\172\186\232\175\136\233\171\152\230\137\139",OPPORTUNITY="\228\188\186\230\156\186\232\128\140\229\138\168",PICK_POCKET="\229\191\183\231\170\131",PREMEDITATION="\233\162\132\232\176\139",PREPARATION="\228\188\186\230\156\186\229\190\133\229\191\145",RAPID_CONCEALMENT="\232\191\133\233\128\159\233\154\191\232\148\189",SAFE_FALL="\229\174\137\229\133\168\233\153\191\232\191\189",SAP="\233\151\183\230\163\191",SETUP="\232\176\131\230\149\180",STEALTH="\230\189\156\232\161\140",VANISH="\230\182\136\229\164\177",VANISHED="\230\182\136\229\164\177",BASIC_CAMPFIRE="\229\159\186\231\161\128\232\191\165\231\191\171",BRIGHT_CAMPFIRE="\230\152\142\228\186\174\231\175\191\231\191\171",CLEVER_TRAPS="\231\191\181\229\183\167\233\153\183\233\152\177",COUNTERATTACK="\229\191\191\229\135\187",DETERRENCE="\229\168\191\230\133\145",DISENGAGE="\233\128\131\232\132\177",ENTRAPMENT="\232\175\177\230\191\149",EXPLOSIVE_TRAP="\231\136\134\231\130\184\233\153\183\233\152\177",EXPLOSIVE_TRAP_EFFECT="\231\136\134\231\130\184\233\153\183\233\152\177\230\149\136\230\158\156",
			FEIGN_DEATH="\229\191\135\230\173\187",FREEZING_TRAP="\229\134\176\229\134\187\233\153\183\233\152\177",FROST_TRAP="\229\134\176\233\156\156\233\153\183\233\152\177",HUMANOID_SLAYING="\228\186\186\229\158\139\231\148\159\231\137\169\230\191\128\230\137\139",IMMOLATION_TRAP="\231\140\174\231\165\173\233\153\183\233\152\177",IMMOLATION_TRAP_EFFECT="\231\140\174\231\165\173\233\153\183\233\152\177\230\149\136\230\158\156",IMPROVED_FEIGN_DEATH="\229\188\186\229\140\150\229\191\135\230\173\187",IMPROVED_WING_CLIP="\229\188\186\229\140\150\230\145\148\231\187\138",KILLER_INSTINCT="\230\191\128\230\136\174\230\156\172\232\131\189",MELEE_SPECIALIZATION="\232\191\145\230\136\152\228\184\147\231\178\190",MONGOOSE_BITE="\231\140\171\233\188\172\230\146\149\229\146\172",MONSTER_SLAYING="\230\128\170\231\137\169\230\191\128\230\137\139",RAPTOR_STRIKE="\231\140\155\231\166\189\228\184\128\229\135\187",READINESS="\229\135\134\229\164\135\229\176\177\231\187\170",SAVAGE_STRIKES="\233\135\142\232\155\174\230\137\147\229\135\187",SUREFOOTED="\231\168\179\229\155\186",SURVIVALIST="\231\148\159\229\173\152\228\184\147\229\174\182",TRACK_BEASTS="\232\191\189\232\184\170\233\135\142\229\133\189",TRACK_DEMONS="\232\191\189\232\184\170\230\191\182\233\173\148",TRACK_DRAGONKIN="\232\191\189\232\184\170\233\190\153\231\177\187",TRACK_ELEMENTALS="\232\191\189\232\184\170\229\133\131\231\180\160\231\148\159\231\137\169",TRACK_GIANTS="\232\191\189\232\184\170\229\183\168\228\186\186",TRACK_HIDDEN="\232\191\189\232\184\170\233\154\191\232\151\191\231\148\159\231\137\169",TRACK_UNDEAD="\232\191\189\232\184\170\228\186\161\231\191\181",TRAP_MASTERY="\233\153\183\233\152\177\230\142\140\230\191\161",WING_CLIP="\230\145\148\231\187\138",WYVERN_STING="\231\191\188\233\190\153\233\146\137\229\136\186",ONE_HANDED_SWORDS="\229\191\149\230\137\139\229\137\145",CULTIVATION="\230\160\189\229\159\185",ENDURANCE="\232\128\191\228\185\133",WAR_STOMP="\230\136\152\228\186\137\232\183\181\232\184\191",THROW="\230\138\149\230\142\183",THROWN="\230\138\149\230\142\183",TIGER_RIDING="\233\170\145\230\156\175\239\188\154\232\177\185",TWO_HANDED_AXES="\229\191\140\230\137\139\230\150\167",TWO_HANDED_MACES="\229\191\140\230\137\139\233\148\164",TWO_HANDED_SWORDS="\229\191\140\230\137\139\229\137\145",UNARMED="\229\190\146\230\137\139",UNDEAD_HORSEMANSHIP="\233\170\145\230\156\175\239\188\154\233\170\184\233\170\168\230\136\152\233\169\172",SHOOT="\229\176\132\229\135\187",WANDS="\233\173\148\230\191\150",WOLF_RIDING="\233\170\145\230\156\175\239\188\154\231\139\188",
			BLACKSMITHING="\233\148\187\233\128\160",ARMORSMITH="\230\138\164\231\148\178\233\148\187\233\128\160\229\184\136",WEAPONSMITH="\230\173\166\229\153\168\233\148\187\233\128\160\229\184\136",ALCHEMY="\231\130\188\233\135\145\230\156\175",ENCHANTING="\233\153\132\233\173\148",DISENCHANT="\229\136\134\232\167\163",ENGINEERING="\229\183\165\231\168\139\229\173\166",FIND_HERBS="\229\175\187\230\137\190\239\191\189?\239\191\189\239\191\189?\239\191\189",HERB_GATHERING="\233\135\135\233\155\134\239\191\189?\239\191\189\239\191\189?\239\191\189",LEATHERWORKING="\229\136\182\231\154\174",DRAGONSCALE_LEATHERWORKING="\233\190\153\233\179\158\229\136\182\231\154\174",ELEMENTAL_LEATHERWORKING="\229\133\131\231\180\160\229\136\182\231\154\174",TRIBAL_LEATHERWORKING="\233\131\168\239\191\189?\229\136\182\231\154\174",FIND_MINERALS="\229\175\187\230\137\190\231\159\191\231\137\169",MINING="\233\135\135\231\159\191",SMELTING="\231\134\148\231\130\188",SKINNING="\229\137\165\231\154\174",
			COBRA_REFLEXES="Cobra Reflexes",SHELL_SHIELD="Shell Shield",THUNDERSTOMP="Thunderstomp",PRAYER_OF_SPIRIT="Prayer of Spirit",FETISH="Fetish",LIBRAM="Libram",TOTEM="Totem",BLESSED_RECOVERY="Blessed Recovery",HOLY_REACH="Holy Reach",SPELL_WARDING="Spell Warding",CONSECRATION="Consecration",GREATER_BLESSING_OF_LIGHT="Greater Blessing of Light",GREATER_BLESSING_OF_WISDOM="Greater Blessing of Wisdom",DEADLY_POISON_V="Deadly Poison V",GREATER_BLESSING_OF_KINGS="Greater Blessing of Kings",GREATER_BLESSING_OF_SALVATION="Greater Blessing of Salvation",GREATER_BLESSING_OF_SANCTUARY="Greater Blessing of Sanctuary",RIGHTEOUS_FURY="Righteous Fury",BOW_SPECIALIZATION="Bow Specialization",TRANQUIL_AIR_TOTEM="Tranquil Air Totem",GREATER_BLESSING_OF_MIGHT="Greater Blessing of Might",IMPROVED_JUDGEMENT="Improved Judgement",PURSUIT_OF_JUSTICE="Pursuit of Justice",IMPROVED_VAMPIRIC_EMBRACE="Improved Vampiric Embrace",PRAYER_OF_SHADOW_PROTECTION="Prayer of Shadow Protection",SOULSTONE_RESURRECTION="Soulstone Resurrection",FOOD="Food",DRINK="Drink",ENRICHED_MANNA_BISCUIT="�?��?�的魔法点心"
		}
	end
end

-------------IRIEL'S-STUB-CODE--------------
local stub = {};

-- Instance replacement method, replace contents of old with that of new
function stub:ReplaceInstance(old, new)
   for k,v in pairs(old) do old[k]=nil; end
   for k,v in pairs(new) do old[k]=v; end
end

-- Get a new copy of the stub
function stub:NewStub()
  local newStub = {};
  self:ReplaceInstance(newStub, self);
  newStub.lastVersion = '';
  newStub.versions = {};
  return newStub;
end

-- Get instance version
function stub:GetInstance(version)
   if (not version) then version = self.lastVersion; end
   local versionData = self.versions[version];
   if (not versionData) then
      message("Cannot find library instance with version '" 
              .. version .. "'");
      return;
   end
   return versionData.instance;
end

-- Register new instance
function stub:Register(newInstance)
   local version,minor = newInstance:GetLibraryVersion();
   self.lastVersion = version;
   local versionData = self.versions[version];
   if (not versionData) then
      -- This one is new!
      versionData = { instance = newInstance,
         minor = minor,
         old = {} 
      };
      self.versions[version] = versionData;
      newInstance:LibActivate(self);
      return newInstance;
   end
   if (minor <= versionData.minor) then
      -- This one is already obsolete
      if (newInstance.LibDiscard) then
         newInstance:LibDiscard();
      end
      return versionData.instance;
   end
   -- This is an update
   local oldInstance = versionData.instance;
   local oldList = versionData.old;
   versionData.instance = newInstance;
   versionData.minor = minor;
   local skipCopy = newInstance:LibActivate(self, oldInstance, oldList);
   table.insert(oldList, oldInstance);
   if (not skipCopy) then
      for i, old in ipairs(oldList) do
         self:ReplaceInstance(old, newInstance);
      end
   end
   return newInstance;
end

-- Bind stub to global scope if it's not already there
if (not BabbleLib) then
   BabbleLib = stub:NewStub();
end

-- Nil stub for garbage collection
stub = nil;
-----------END-IRIEL'S-STUB-CODE------------

local function initSpellIcons()
	-- automatically generated, so messy
	spellIcons = {
		ABOLISH_DISEASE="Spell_Nature_NullifyDisease",ABOLISH_POISON="Spell_Nature_NullifyPoison_02",ABOLISH_POISON_EFFECT="Spell_Nature_NullifyPoison_02",ACTIVATE_MG_TURRET="INV_Weapon_Rifle_10",ADRENALINE_RUSH="Spell_Shadow_ShadowWordDominate",AFTERMATH="Spell_Fire_Fire",AGGRESSION="Ability_Racial_Avatar",AIMED_SHOT="INV_Spear_07",AMBUSH="Ability_Rogue_Ambush",AMPLIFY_CURSE="Spell_Shadow_Contagion",AMPLIFY_MAGIC="Spell_Holy_FlashHeal",ANCESTRAL_HEALING="Spell_Nature_UndyingStrength",ANCESTRAL_KNOWLEDGE="Spell_Shadow_GrimWard",ANCESTRAL_SPIRIT="Spell_Nature_Regenerate",ANGER_MANAGEMENT="Spell_Holy_BlessingOfStamina",ANTICIPATION="Spell_Nature_MirrorImage",AQUATIC_FORM="Ability_Druid_AquaticForm",ARCANE_BRILLIANCE="Spell_Holy_ArcaneIntellect",ARCANE_CONCENTRATION="Spell_Shadow_ManaBurn",ARCANE_EXPLOSION="Spell_Nature_WispSplode",ARCANE_FOCUS="Spell_Holy_Devotion",ARCANE_INSTABILITY="Spell_Shadow_Teleport",ARCANE_INTELLECT="Spell_Holy_MagicalSentry",ARCANE_MEDITATION="Spell_Shadow_SiphonMana",ARCANE_MIND="Spell_Shadow_Charm",ARCANE_MISSILES="Spell_Nature_StarFall",ARCANE_POWER="Spell_Nature_Lightning",ARCANE_RESISTANCE="Spell_Nature_StarFall",ARCANE_SHOT="Ability_ImpalingBolt",ARCANE_SUBTLETY="Spell_Holy_DispelMagic",ARCTIC_REACH="Spell_Shadow_DarkRitual",ASPECT_OF_THE_BEAST="Ability_Mount_PinkTiger",ASPECT_OF_THE_CHEETAH="Ability_Mount_JungleTiger",ASPECT_OF_THE_HAWK="Spell_Nature_RavenForm",ASPECT_OF_THE_MONKEY="Ability_Hunter_AspectOfTheMonkey",ASPECT_OF_THE_PACK="Ability_Mount_WhiteTiger",ASPECT_OF_THE_WILD="Spell_Nature_ProtectionformNature",ASTRAL_RECALL="Spell_Nature_AstralRecal",ATTACK="Temp",ATTACKING="Temp",AUTO_SHOT="Ability_Whirlwind",AXE_SPECIALIZATION="INV_Axe_06",BACKSTAB="Ability_BackStab",BANE="Spell_Shadow_DeathPact",BANISH="Spell_Shadow_Cripple",BARKSKIN="Spell_Nature_StoneClawTotem",BARKSKIN_EFFECT="Spell_Nature_StoneClawTotem",BARRAGE="Ability_UpgradeMoonGlaive",BASH="Ability_Druid_Bash",BASIC_CAMPFIRE="Spell_Fire_Fire",BATTLE_SHOUT="Ability_Warrior_BattleShout",BATTLE_STANCE="Ability_Warrior_OffensiveStance",BATTLE_STANCE_PASSIVE="Ability_Warrior_OffensiveStance",BEAR_FORM="Ability_Racial_BearForm",BEAST_LORE="Ability_Physical_Taunt",BEAST_SLAYING="INV_Misc_Pelt_Bear_Ruin_02",BEAST_TRAINING="Ability_Hunter_BeastCall02",BENEDICTION="Spell_Frost_WindWalkOn",BERSERKER_RAGE="Spell_Nature_AncestralGuardian",BERSERKER_STANCE="Ability_Racial_Avatar",BERSERKER_STANCE_PASSIVE="Ability_Racial_Avatar",BERSERKING="Racial_Troll_Berserk",BESTIAL_DISCIPLINE="Spell_Nature_AbolishMagic",BESTIAL_SWIFTNESS="Ability_Druid_Dash",BESTIAL_WRATH="Ability_Druid_FerociousBite",BITE="Ability_Racial_Cannibalize",BLACKOUT="Spell_Shadow_GatherShadows",BLACK_ARROW="Ability_TheBlackArrow",BLADE_FLURRY="Ability_Warrior_PunishingBlow",BLAST_WAVE="Spell_Holy_Excorcism_02",BLESSED_RECOVERY="Spell_Holy_BlessedRecovery",BLESSING_OF_FREEDOM="Spell_Holy_SealOfValor",BLESSING_OF_KINGS="Spell_Magic_MageArmor",BLESSING_OF_LIGHT="Spell_Holy_PrayerOfHealing02",BLESSING_OF_MIGHT="Spell_Holy_FistOfJustice",BLESSING_OF_PROTECTION="Spell_Holy_SealOfProtection",BLESSING_OF_SACRIFICE="Spell_Holy_SealOfSacrifice",BLESSING_OF_SALVATION="Spell_Holy_SealOfSalvation",BLESSING_OF_SANCTUARY="Spell_Nature_LightningShield",BLESSING_OF_WISDOM="Spell_Holy_SealOfWisdom",BLIND="Spell_Shadow_MindSteal",BLINDING_POWDER="INV_Misc_Ammo_Gunpowder_02",BLINK="Spell_Arcane_Blink",BLIZZARD="Spell_Frost_IceStorm",BLOCK="Ability_Defend",BLOODRAGE="Ability_Racial_BloodRage",BLOODTHIRST="Spell_Nature_BloodLust",BLOOD_CRAZE="Spell_Shadow_SummonImp",BLOOD_FRENZY="Ability_GhoulFrenzy",BLOOD_FURY="Racial_Orc_BerserkerStrength",BLOOD_PACT="Spell_Shadow_BloodBoil",BOOMING_VOICE="Spell_Nature_Purge",BOWS="INV_Weapon_Bow_05",BOW_SPECIALIZATION="INV_Weapon_Bow_12",BRIGHT_CAMPFIRE="Spell_Fire_Fire",BRUTAL_IMPACT="Ability_Druid_Bash",BURNING_SOUL="Spell_Fire_Fire",CALL_OF_FLAME="Spell_Fire_Immolation",CALL_OF_THUNDER="Spell_Nature_CallStorm",CALL_PET="Ability_Hunter_BeastCall",CAMOUFLAGE="Ability_Stealth",CANNIBALIZE="Ability_Racial_Cannibalize",CATACLYSM="Spell_Fire_WindsofWoe",CAT_FORM="Ability_Druid_CatForm",CHAIN_HEAL="Spell_Nature_HealingWaveGreater",CHAIN_LIGHTNING="Spell_Nature_ChainLightning",CHALLENGING_ROAR="Ability_Druid_ChallangingRoar",CHALLENGING_SHOUT="Ability_BullRush",CHARGE="Ability_Warrior_Charge",CHARGE_RAGE_BONUS_EFFECT="Ability_Warrior_Charge",CHEAP_SHOT="Ability_CheapShot",CHILLED="Spell_Frost_IceStorm",CLAW="Ability_Druid_Rake",CLEANSE="Spell_Holy_Renew",CLEARCASTING="Spell_Shadow_ManaBurn",CLEAVE="Ability_Warrior_Cleave",CLEVER_TRAPS="Spell_Nature_TimeStop",CLOSING="Temp",CLOTH="INV_Chest_Cloth_21",COBRA_REFLEXES="Spell_Nature_GuardianWard",COLD_BLOOD="Spell_Ice_Lament",COLD_SNAP="Spell_Frost_WizardMark",COMBAT_ENDURANCE="Spell_Nature_AncestralGuardian",COMBUSTION="Spell_Fire_SealOfFire",COMMAND="Ability_Warrior_WarCry",CONCENTRATION_AURA="Spell_Holy_MindSooth",CONCUSSION="Spell_Fire_Fireball",CONCUSSION_BLOW="Ability_ThunderBolt",CONCUSSIVE_SHOT="Spell_Frost_Stun",CONE_OF_COLD="Spell_Frost_Glacier",CONFLAGRATE="Spell_Fire_Fireball",CONJURE_FOOD="INV_Misc_Food_10",CONJURE_MANA_AGATE="INV_Misc_Gem_Emerald_01",CONJURE_MANA_CITRINE="INV_Misc_Gem_Opal_01",CONJURE_MANA_JADE="INV_Misc_Gem_Emerald_02",CONJURE_MANA_RUBY="INV_Misc_Gem_Ruby_01",CONJURE_WATER="INV_Drink_06",CONSECRATION="Spell_Holy_InnerFire",CONSUME_SHADOWS="Spell_Shadow_AntiShadow",CONVECTION="Spell_Nature_WispSplode",CONVICTION="Spell_Holy_RetributionAura",CORRUPTION="Spell_Shadow_AbominationExplosion",COUNTERATTACK="Ability_Warrior_Challange",COUNTERSPELL="Spell_Frost_IceShock",COWER="Ability_Druid_Cower",CREATE_FIRESTONE="INV_Ammo_FireTar",CREATE_HEALTHSTONE="INV_Stone_04",CREATE_SOULSTONE="Spell_Shadow_SoulGem",CREATE_SPELLSTONE="INV_Misc_Gem_Sapphire_01",CRIPPLING_POISON="Ability_PoisonSting",CRIPPLING_POISON_II="Ability_PoisonSting",CRITICAL_MASS="Spell_Nature_WispHeal",CROSSBOWS="INV_Weapon_Crossbow_01",CRUELTY="Ability_Rogue_Eviscerate",CULTIVATION="INV_Misc_Flower_01",CURE_DISEASE="Spell_Holy_NullifyDisease",CURE_POISON="Spell_Nature_NullifyPoison",CURSE_OF_AGONY="Spell_Shadow_CurseOfSargeras",CURSE_OF_DOOM="Spell_Shadow_AuraOfDarkness",CURSE_OF_DOOM_EFFECT="Spell_Shadow_AuraOfDarkness",CURSE_OF_EXHAUSTION="Spell_Shadow_GrimWard",CURSE_OF_IDIOCY="Spell_Shadow_MindRot",CURSE_OF_RECKLESSNESS="Spell_Shadow_UnholyStrength",CURSE_OF_SHADOW="Spell_Shadow_CurseOfAchimonde",CURSE_OF_THE_ELEMENTS="Spell_Shadow_ChillTouch",CURSE_OF_TONGUES="Spell_Shadow_CurseOfTounges",CURSE_OF_WEAKNESS="Spell_Shadow_CurseOfMannoroth",DAGGERS="Ability_SteelMelee",DAGGER_SPECIALIZATION="INV_Weapon_ShortBlade_05",DAMPEN_MAGIC="Spell_Nature_AbolishMagic",DARKNESS="Spell_Shadow_Twilight",DARK_PACT="Spell_Shadow_DarkRitual",DASH="Ability_Druid_Dash",DEADLY_POISON="Ability_Rogue_DualWeild",DEADLY_POISON_II="Ability_Rogue_DualWeild",DEADLY_POISON_III="Ability_Rogue_DualWeild",DEADLY_POISON_IV="Ability_Rogue_DualWeild",DEADLY_POISON_V="Ability_Rogue_DualWeild",DEATH_COIL="Spell_Shadow_DeathCoil",DEATH_WISH="Spell_Shadow_DeathPact",DEEP_WOUNDS="Ability_BackStab",DEFENSE="Ability_Racial_ShadowMeld",DEFENSIVE_STANCE="Ability_Warrior_DefensiveStance",DEFENSIVE_STANCE_PASSIVE="Ability_Warrior_DefensiveStance",DEFENSIVE_STATE="Ability_Defend",DEFENSIVE_STATE_2="Ability_Defend",DEFIANCE="Ability_Warrior_InnerRage",DEFLECTION="Ability_Parry",DEMONIC_EMBRACE="Spell_Shadow_Metamorphosis",DEMONIC_SACRIFICE="Spell_Shadow_PsychicScream",DEMON_ARMOR="Spell_Shadow_RagingScream",DEMON_SKIN="Spell_Shadow_RagingScream",DEMORALIZING_ROAR="Ability_Druid_DemoralizingRoar",DEMORALIZING_SHOUT="Ability_Warrior_WarCry",DESPERATE_PRAYER="Spell_Holy_Restoration",DESTRUCTIVE_REACH="Spell_Shadow_CorpseExplode",DETECT="Ability_Hibernation",DETECT_GREATER_INVISIBILITY="Spell_Shadow_DetectInvisibility",DETECT_INVISIBILITY="Spell_Shadow_DetectInvisibility",DETECT_LESSER_INVISIBILITY="Spell_Shadow_DetectLesserInvisibility",DETECT_MAGIC="Spell_Holy_Dizzy",DETECT_TRAPS="Ability_Spy",DETERRENCE="Ability_Whirlwind",DEVASTATION="Spell_Fire_FlameShock",DEVOTION_AURA="Spell_Holy_DevotionAura",DEVOURING_PLAGUE="Spell_Shadow_BlackPlague",DEVOUR_MAGIC="Spell_Nature_Purge",DEVOUR_MAGIC_EFFECT="Spell_Nature_Purge",DIPLOMACY="INV_Misc_Note_02",DIRE_BEAR_FORM="Ability_Racial_BearForm",DISARM="Ability_Warrior_Disarm",DISARM_TRAP="Spell_Shadow_GrimWard",DISEASE_CLEANSING_TOTEM="Spell_Nature_DiseaseCleansingTotem",DISENGAGE="Ability_Rogue_Feint",DISMISS_PET="Spell_Nature_SpiritWolf",DISPEL_MAGIC="Spell_Holy_DispelMagic",DISTRACT="Ability_Rogue_Distract",DISTRACTING_SHOT="Spell_Arcane_Blink",DIVE="Spell_Shadow_BurningSpirit",DIVINE_FAVOR="Spell_Holy_Heal",DIVINE_FURY="Spell_Holy_SealOfWrath",DIVINE_INTELLECT="Spell_Nature_Sleep",DIVINE_INTERVENTION="Spell_Nature_TimeStop",DIVINE_PROTECTION="Spell_Holy_Restoration",DIVINE_SHIELD="Spell_Holy_DivineIntervention",DIVINE_SPIRIT="Spell_Holy_DivineSpirit",DIVINE_STRENGTH="Ability_GolemThunderClap",DODGE="Spell_Nature_Invisibilty",DRAIN_LIFE="Spell_Shadow_LifeDrain02",DRAIN_MANA="Spell_Shadow_SiphonMana",DRAIN_SOUL="Spell_Shadow_Haunting",DUAL_WIELD="Ability_DualWield",DUAL_WIELD_SPECIALIZATION="Ability_DualWield",DUEL="Temp",EAGLE_EYE="Ability_Hunter_EagleEye",EARTHBIND_TOTEM="Spell_Nature_StrengthOfEarthTotem02",EARTH_SHOCK="Spell_Nature_EarthShock",EFFICIENCY="Spell_Frost_WizardMark",ELEMENTAL_FOCUS="Spell_Shadow_ManaBurn",ELEMENTAL_FURY="Spell_Fire_Volcano",ELEMENTAL_MASTERY="Spell_Nature_WispHeal",ELUNES_GRACE="Spell_Holy_ElunesGrace",ELUSIVENESS="Spell_Magic_LesserInvisibilty",EMBERSTORM="Spell_Fire_SelfDestruct",ENDURANCE="Spell_Nature_UnyeildingStamina",ENDURANCE_TRAINING="Spell_Nature_Reincarnation",ENGINEERING_SPECIALIZATION="INV_Misc_Gear_01",ENRAGE="Ability_Druid_Enrage",ENSLAVE_DEMON="Spell_Shadow_EnslaveDemon",ENTANGLING_ROOTS="Spell_Nature_StrangleVines",ENTRAPMENT="Spell_Nature_StrangleVines",ESCAPE_ARTIST="Ability_Rogue_Trip",EVASION="Spell_Shadow_ShadowWard",EVENTIDE="Spell_Frost_Stun",
		EVISCERATE="Ability_Rogue_Eviscerate",EVOCATION="Spell_Nature_Purge",EXECUTE="INV_Sword_48",EXORCISM="Spell_Holy_Excorcism_02",EXPANSIVE_MIND="INV_Enchant_EssenceEternalLarge",EXPLOSIVE_TRAP="Spell_Fire_SelfDestruct",EXPLOSIVE_TRAP_EFFECT="Spell_Fire_SelfDestruct",EXPOSE_ARMOR="Ability_Warrior_Riposte",EYES_OF_THE_BEAST="Ability_EyeOfTheOwl",EYE_FOR_AN_EYE="Spell_Holy_EyeforanEye",EYE_OF_KILROGG="Spell_Shadow_EvilEye",FADE="Spell_Magic_LesserInvisibilty",FAERIE_FIRE="Spell_Nature_FaerieFire",FAR_SIGHT="Spell_Nature_FarSight",FEAR="Spell_Shadow_Possession",FEAR_WARD="Spell_Holy_Excorcism",FEEDBACK="Spell_Shadow_RitualOfSacrifice",FEED_PET="Ability_Hunter_BeastTraining",FEIGN_DEATH="Ability_Rogue_FeignDeath",FEINT="Ability_Rogue_Feint",FELFIRE="Spell_Fire_Fireball",FELINE_GRACE="INV_Feather_01",FELINE_SWIFTNESS="Spell_Nature_SpiritWolf",FEL_CONCENTRATION="Spell_Shadow_FingerOfDeath",FEL_DOMINATION="Spell_Nature_RemoveCurse",FEL_INTELLECT="Spell_Holy_MagicalSentry",FEL_STAMINA="Spell_Shadow_AntiShadow",FERAL_AGGRESSION="Ability_Druid_DemoralizingRoar",FERAL_CHARGE="Ability_Hunter_Pet_Bear",FERAL_INSTINCT="Ability_Ambush",FEROCIOUS_BITE="Ability_Druid_FerociousBite",FEROCITY="INV_Misc_MonsterClaw_04",FETISH="INV_Misc_Horn_01",FIND_TREASURE="Racial_Dwarf_FindTreasure",FIREBALL="Spell_Fire_FlameBolt",FIREBOLT="Spell_Fire_FireBolt",FIRE_BLAST="Spell_Fire_Fireball",FIRE_NOVA_TOTEM="Spell_Fire_SealOfFire",FIRE_POWER="Spell_Fire_Immolation",FIRE_RESISTANCE="Spell_Fire_FireArmor",FIRE_RESISTANCE_AURA="Spell_Fire_SealOfFire",FIRE_RESISTANCE_TOTEM="Spell_FireResistanceTotem_01",FIRE_SHIELD="Spell_Fire_FireArmor",FIRE_VULNERABILITY="Spell_Fire_SoulBurn",FIRE_WARD="Spell_Fire_FireArmor",FISHING="Trade_Fishing",FISHING_POLES="Trade_Fishing",FIST_WEAPONS="INV_Gauntlets_04",FIST_WEAPON_SPECIALIZATION="INV_Gauntlets_04",FLAMESTRIKE="Spell_Fire_SelfDestruct",FLAMETHROWER="Spell_Fire_Incinerate",FLAMETONGUE_TOTEM="Spell_Nature_GuardianWard",FLAMETONGUE_WEAPON="Spell_Fire_FlameTounge",FLAME_SHOCK="Spell_Fire_FlameShock",FLAME_THROWING="Spell_Fire_Flare",FLARE="Spell_Fire_Flare",FLASH_HEAL="Spell_Holy_FlashHeal",FLASH_OF_LIGHT="Spell_Holy_FlashHeal",FLURRY="Ability_GhoulFrenzy",FOCUSED_CASTING="Spell_Arcane_Blink",FORCE_OF_WILL="Spell_Nature_SlowingTotem",FREEZING_TRAP="Spell_Frost_ChainsOfIce",FRENZIED_REGENERATION="Ability_BullRush",FRENZY="INV_Misc_MonsterClaw_03",FROSTBITE="Spell_Frost_FrostArmor",FROSTBOLT="Spell_Frost_FrostBolt02",FROSTBRAND_WEAPON="Spell_Frost_FrostBrand",FROST_ARMOR="Spell_Frost_FrostArmor02",FROST_CHANNELING="Spell_Frost_Stun",FROST_NOVA="Spell_Frost_FrostNova",FROST_RESISTANCE="Spell_Frost_FrostWard",FROST_RESISTANCE_AURA="Spell_Frost_WizardMark",FROST_RESISTANCE_TOTEM="Spell_FrostResistanceTotem_01",FROST_SHOCK="Spell_Frost_FrostShock",FROST_TRAP="Spell_Frost_FreezingBreath",FROST_WARD="Spell_Frost_FrostWard",FURIOUS_HOWL="Ability_Hunter_Pet_Wolf",FUROR="Spell_Holy_BlessingOfStamina",GARROTE="Ability_Rogue_Garrote",GENERIC="INV_Shield_09",GHOSTLY_STRIKE="Spell_Shadow_Curse",GHOST_WOLF="Spell_Nature_SpiritWolf",GIFT_OF_NATURE="Spell_Nature_ProtectionformNature",GIFT_OF_THE_WILD="Spell_Nature_Regeneration",GOUGE="Ability_Gouge",GRACE_OF_AIR_TOTEM="Spell_Nature_InvisibilityTotem",GREATER_BLESSING_OF_KINGS="Spell_Magic_GreaterBlessingofKings",GREATER_BLESSING_OF_LIGHT="Spell_Holy_GreaterBlessingofLight",GREATER_BLESSING_OF_MIGHT="Spell_Holy_GreaterBlessingofKings",GREATER_BLESSING_OF_SALVATION="Spell_Holy_GreaterBlessingofSalvation",GREATER_BLESSING_OF_SANCTUARY="Spell_Holy_GreaterBlessingofSanctuary",GREATER_BLESSING_OF_WISDOM="Spell_Holy_GreaterBlessingofWisdom",GREATER_HEAL="Spell_Holy_GreaterHeal",GREAT_STAMINA="Spell_Nature_UnyeildingStamina",GRIM_REACH="Spell_Shadow_CallofBone",GROUNDING_TOTEM="Spell_Nature_GroundingTotem",GROVEL="Temp",GROWL="Ability_Physical_Taunt",GUARDIANS_FAVOR="Spell_Holy_SealOfProtection",GUNS="INV_Weapon_Rifle_01",GUN_SPECIALIZATION="INV_Musket_03",HAMMER_OF_JUSTICE="Spell_Holy_SealOfMight",HAMMER_OF_WRATH="Ability_ThunderClap",HAMSTRING="Ability_ShockWave",HARASS="Ability_Hunter_Harass",HARDINESS="INV_Helmet_23",HAWK_EYE="Ability_TownWatch",HEAL="Spell_Holy_Heal",HEALING_FOCUS="Spell_Holy_HealingFocus",HEALING_LIGHT="Spell_Holy_HolyBolt",HEALING_STREAM_TOTEM="INV_Spear_04",HEALING_TOUCH="Spell_Nature_HealingTouch",HEALING_WAVE="Spell_Nature_MagicImmunity",HEALTH_FUNNEL="Spell_Shadow_LifeDrain",HEART_OF_THE_WILD="Spell_Holy_BlessingOfAgility",HELLFIRE="Spell_Fire_Incinerate",HELLFIRE_EFFECT="Spell_Fire_Incinerate",HEMORRHAGE="Spell_Shadow_LifeDrain",HEROIC_STRIKE="Ability_Rogue_Ambush",HEX_OF_WEAKNESS="Spell_Shadow_FingerOfDeath",HIBERNATE="Spell_Nature_Sleep",HOLY_FIRE="Spell_Holy_SearingLight",HOLY_LIGHT="Spell_Holy_HolyBolt",HOLY_NOVA="Spell_Holy_HolyNova",HOLY_POWER="Spell_Holy_Power",HOLY_REACH="Spell_Holy_Purify",HOLY_SHIELD="Spell_Holy_BlessingOfProtection",HOLY_SHOCK="Spell_Holy_SearingLight",HOLY_SPECIALIZATION="Spell_Holy_SealOfSalvation",HOLY_WRATH="Spell_Holy_Excorcism",HONORLESS_TARGET="Spell_Magic_LesserInvisibilty",HORSE_RIDING="Spell_Nature_Swiftness",HOWL_OF_TERROR="Spell_Shadow_DeathScream",HUMANOID_SLAYING="Spell_Holy_PrayerOfHealing",HUNTERS_MARK="Ability_Hunter_SniperShot",HURRICANE="Spell_Nature_Cyclone",ICE_ARMOR="Spell_Frost_FrostArmor02",ICE_BARRIER="Spell_Ice_Lament",ICE_BLOCK="Spell_Frost_Frost",ICE_SHARDS="Spell_Frost_IceShard",IGNITE="Spell_Fire_Incinerate",ILLUMINATION="Spell_Holy_GreaterHeal",IMMOLATE="Spell_Fire_Immolation",IMMOLATION_TRAP="Spell_Fire_FlameShock",IMMOLATION_TRAP_EFFECT="Spell_Fire_FlameShock",IMPACT="Spell_Fire_MeteorStorm",IMPALE="Ability_SearingArrow",IMPROVED_AMBUSH="Ability_Rogue_Ambush",IMPROVED_ARCANE_EXPLOSION="Spell_Nature_WispSplode",IMPROVED_ARCANE_MISSILES="Spell_Nature_StarFall",IMPROVED_ARCANE_SHOT="Ability_ImpalingBolt",IMPROVED_ASPECT_OF_THE_HAWK="Spell_Nature_RavenForm",IMPROVED_ASPECT_OF_THE_MONKEY="Ability_Hunter_AspectOfTheMonkey",IMPROVED_BACKSTAB="Ability_BackStab",IMPROVED_BATTLE_SHOUT="Ability_Warrior_BattleShout",IMPROVED_BERSERKER_RAGE="Spell_Nature_AncestralGuardian",IMPROVED_BLESSING_OF_MIGHT="Spell_Holy_FistOfJustice",IMPROVED_BLESSING_OF_WISDOM="Spell_Holy_SealOfWisdom",IMPROVED_BLIZZARD="Spell_Frost_IceStorm",IMPROVED_BLOODRAGE="Ability_Racial_BloodRage",IMPROVED_CHAIN_HEAL="Spell_Nature_HealingWaveGreater",IMPROVED_CHAIN_LIGHTNING="Spell_Nature_ChainLightning",IMPROVED_CHALLENGING_SHOUT="Ability_Warrior_Challange",IMPROVED_CHARGE="Ability_Warrior_Charge",IMPROVED_CHEAP_SHOT="Ability_CheapShot",IMPROVED_CLEAVE="Ability_Warrior_Cleave",IMPROVED_CONCENTRATION_AURA="Spell_Holy_MindSooth",IMPROVED_CONCUSSIVE_SHOT="Spell_Frost_Stun",IMPROVED_CONE_OF_COLD="Spell_Frost_Glacier",IMPROVED_CORRUPTION="Spell_Shadow_AbominationExplosion",IMPROVED_COUNTERSPELL="Spell_Frost_IceShock",IMPROVED_CURSE_OF_AGONY="Spell_Shadow_CurseOfSargeras",IMPROVED_CURSE_OF_EXHAUSTION="Spell_Shadow_GrimWard",IMPROVED_CURSE_OF_WEAKNESS="Spell_Shadow_CurseOfMannoroth",IMPROVED_DAMPEN_MAGIC="Spell_Nature_AbolishMagic",IMPROVED_DEADLY_POISON="Ability_Rogue_DualWeild",IMPROVED_DEMORALIZING_SHOUT="Ability_Warrior_WarCry",IMPROVED_DEVOTION_AURA="Spell_Holy_DevotionAura",IMPROVED_DISARM="Ability_Warrior_Disarm",IMPROVED_DISTRACT="Ability_Rogue_Distract",IMPROVED_DRAIN_LIFE="Spell_Shadow_LifeDrain02",IMPROVED_DRAIN_MANA="Spell_Shadow_SiphonMana",IMPROVED_DRAIN_SOUL="Spell_Shadow_Haunting",IMPROVED_ENRAGE="Ability_Druid_Enrage",IMPROVED_ENSLAVE_DEMON="Spell_Shadow_EnslaveDemon",IMPROVED_ENTANGLING_ROOTS="Spell_Nature_StrangleVines",IMPROVED_EVASION="Spell_Shadow_ShadowWard",IMPROVED_EVISCERATE="Ability_Rogue_Eviscerate",IMPROVED_EXECUTE="INV_Sword_48",IMPROVED_EXPOSE_ARMOR="Ability_Warrior_Riposte",IMPROVED_EYES_OF_THE_BEAST="Ability_EyeOfTheOwl",IMPROVED_FADE="Spell_Magic_LesserInvisibilty",IMPROVED_FEIGN_DEATH="Ability_Rogue_FeignDeath",IMPROVED_FIREBALL="Spell_Fire_FlameBolt",IMPROVED_FIREBOLT="Spell_Fire_FireBolt",IMPROVED_FIRESTONE="INV_Ammo_FireTar",IMPROVED_FIRE_BLAST="Spell_Fire_Fireball",IMPROVED_FIRE_NOVA_TOTEM="Spell_Fire_SealOfFire",IMPROVED_FIRE_WARD="Spell_Fire_FireArmor",IMPROVED_FLAMESTRIKE="Spell_Fire_SelfDestruct",IMPROVED_FLAMETONGUE_WEAPON="Spell_Fire_FlameTounge",IMPROVED_FLASH_OF_LIGHT="Spell_Holy_FlashHeal",IMPROVED_FROSTBOLT="Spell_Frost_FrostBolt02",IMPROVED_FROSTBRAND_WEAPON="Spell_Frost_FrostBrand",IMPROVED_FROST_NOVA="Spell_Frost_FreezingBreath",IMPROVED_FROST_WARD="Spell_Frost_FrostWard",IMPROVED_GARROTE="Ability_Rogue_Garrote",IMPROVED_GHOST_WOLF="Spell_Nature_SpiritWolf",IMPROVED_GOUGE="Ability_Gouge",IMPROVED_GRACE_OF_AIR_TOTEM="Spell_Nature_InvisibilityTotem",IMPROVED_GROUNDING_TOTEM="Spell_Nature_GroundingTotem",IMPROVED_HAMMER_OF_JUSTICE="Spell_Holy_SealOfMight",IMPROVED_HAMSTRING="Ability_ShockWave",IMPROVED_HEALING="Spell_Holy_Heal02",IMPROVED_HEALING_STREAM_TOTEM="INV_Spear_04",IMPROVED_HEALING_TOUCH="Spell_Nature_HealingTouch",IMPROVED_HEALING_WAVE="Spell_Nature_MagicImmunity",IMPROVED_HEALTHSTONE="INV_Stone_04",IMPROVED_HEALTH_FUNNEL="Spell_Shadow_LifeDrain",IMPROVED_HEROIC_STRIKE="Ability_Rogue_Ambush",IMPROVED_HUNTERS_MARK="Ability_Hunter_SniperShot",IMPROVED_IMMOLATE="Spell_Fire_Immolation",IMPROVED_IMP="Spell_Shadow_SummonImp",IMPROVED_INNER_FIRE="Spell_Holy_InnerFire",IMPROVED_INSTANT_POISON="Ability_Poisons",IMPROVED_INTERCEPT="Ability_Rogue_Sprint",IMPROVED_INTIMIDATING_SHOUT="Ability_GolemThunderClap",IMPROVED_JUDGEMENT="Spell_Holy_RighteousFury",IMPROVED_KICK="Ability_Kick",IMPROVED_KIDNEY_SHOT="Ability_Rogue_KidneyShot",IMPROVED_LASH_OF_PAIN="Spell_Shadow_Curse",IMPROVED_LAY_ON_HANDS="Spell_Holy_LayOnHands",IMPROVED_LESSER_HEALING_WAVE="Spell_Nature_HealingWaveLesser",IMPROVED_LIFE_TAP="Spell_Shadow_BurningSpirit",IMPROVED_LIGHTNING_BOLT="Spell_Nature_Lightning",IMPROVED_LIGHTNING_SHIELD="Spell_Nature_LightningShield",IMPROVED_MAGMA_TOTEM="Spell_Fire_SelfDestruct",IMPROVED_MANA_BURN="Spell_Shadow_ManaBurn",IMPROVED_MANA_SHIELD="Spell_Shadow_DetectLesserInvisibility",
		IMPROVED_MANA_SPRING_TOTEM="Spell_Nature_ManaRegenTotem",IMPROVED_MARK_OF_THE_WILD="Spell_Nature_Regeneration",IMPROVED_MEND_PET="Ability_Hunter_MendPet",IMPROVED_MIND_BLAST="Spell_Shadow_UnholyFrenzy",IMPROVED_MOONFIRE="Spell_Nature_StarFall",IMPROVED_NATURES_GRASP="Spell_Nature_NaturesWrath",IMPROVED_OVERPOWER="INV_Sword_05",IMPROVED_POWER_WORD_FORTITUDE="Spell_Holy_WordFortitude",IMPROVED_POWER_WORD_SHIELD="Spell_Holy_PowerWordShield",IMPROVED_PRAYER_OF_HEALING="Spell_Holy_PrayerOfHealing02",IMPROVED_PSYCHIC_SCREAM="Spell_Shadow_PsychicScream",IMPROVED_PUMMEL="INV_Gauntlets_04",IMPROVED_REGROWTH="Spell_Nature_ResistNature",IMPROVED_REINCARNATION="Spell_Nature_Reincarnation",IMPROVED_REJUVENATION="Spell_Nature_Rejuvenation",IMPROVED_REND="Ability_Gouge",IMPROVED_RENEW="Spell_Holy_Renew",IMPROVED_RETRIBUTION_AURA="Spell_Holy_AuraOfLight",IMPROVED_REVENGE="Ability_Warrior_Revenge",IMPROVED_REVIVE_PET="Ability_Hunter_BeastSoothe",IMPROVED_RIGHTEOUS_FURY="Spell_Holy_SealOfFury",IMPROVED_ROCKBITER_WEAPON="Spell_Nature_RockBiter",IMPROVED_RUPTURE="Ability_Rogue_Rupture",IMPROVED_SAP="Ability_Sap",IMPROVED_SCORCH="Spell_Fire_SoulBurn",IMPROVED_SCORPID_STING="Ability_Hunter_CriticalShot",IMPROVED_SEAL_OF_RIGHTEOUSNESS="Ability_ThunderBolt",IMPROVED_SEAL_OF_THE_CRUSADER="Spell_Holy_HolySmite",IMPROVED_SEARING_PAIN="Spell_Fire_SoulBurn",IMPROVED_SEARING_TOTEM="Spell_Fire_SearingTotem",IMPROVED_SERPENT_STING="Ability_Hunter_Quickshot",IMPROVED_SHADOW_BOLT="Spell_Shadow_ShadowBolt",IMPROVED_SHADOW_WORD_PAIN="Spell_Shadow_ShadowWordPain",IMPROVED_SHIELD_BASH="Ability_Warrior_ShieldBash",IMPROVED_SHIELD_BLOCK="Ability_Defend",IMPROVED_SHIELD_WALL="Ability_Warrior_ShieldWall",IMPROVED_SHRED="Spell_Shadow_VampiricAura",IMPROVED_SINISTER_STRIKE="Spell_Shadow_RitualOfSacrifice",IMPROVED_SLAM="Ability_Warrior_DecisiveStrike",IMPROVED_SLICE_AND_DICE="Ability_Rogue_SliceDice",IMPROVED_SPELLSTONE="INV_Misc_Gem_Sapphire_01",IMPROVED_SPRINT="Ability_Rogue_Sprint",IMPROVED_STARFIRE="Spell_Arcane_StarFire",IMPROVED_STONECLAW_TOTEM="Spell_Nature_StoneClawTotem",IMPROVED_STONESKIN_TOTEM="Spell_Nature_StoneSkinTotem",IMPROVED_STRENGTH_OF_EARTH_TOTEM="Spell_Nature_EarthBindTotem",IMPROVED_SUCCUBUS="Spell_Shadow_SummonSuccubus",IMPROVED_SUNDER_ARMOR="Ability_Warrior_Sunder",IMPROVED_TAUNT="Spell_Nature_Reincarnation",IMPROVED_THORNS="Spell_Nature_Thorns",IMPROVED_THUNDER_CLAP="Ability_ThunderClap",IMPROVED_TRANQUILITY="Spell_Nature_Tranquility",IMPROVED_VAMPIRIC_EMBRACE="Spell_Shadow_ImprovedVampiricEmbrace",IMPROVED_VANISH="Ability_Vanish",IMPROVED_VOIDWALKER="Spell_Shadow_SummonVoidWalker",IMPROVED_WINDFURY_WEAPON="Spell_Nature_Cyclone",IMPROVED_WING_CLIP="Ability_Rogue_Trip",IMPROVED_WRATH="Spell_Nature_AbolishMagic",INCINERATE="Spell_Fire_FlameShock",INFERNO="Spell_Shadow_SummonInfernal",INITIATIVE="Spell_Shadow_Fumble",INNERVATE="Spell_Nature_Lightning",INNER_FIRE="Spell_Holy_InnerFire",INNER_FOCUS="Spell_Frost_WindWalkOn",INSECT_SWARM="Spell_Nature_InsectSwarm",INSPIRATION="Spell_Holy_LayOnHands",INSTANT_POISON="Ability_Poisons",INSTANT_POISON_II="Ability_Poisons",INSTANT_POISON_III="Ability_Poisons",INSTANT_POISON_IV="Ability_Poisons",INSTANT_POISON_V="Ability_Poisons",INSTANT_POISON_VI="Ability_Poisons",INTENSITY="Spell_Fire_LavaSpawn",INTERCEPT="Ability_Rogue_Sprint",INTIMIDATING_SHOUT="Ability_GolemThunderClap",INTIMIDATION="Ability_Devour",IRON_WILL="Spell_Magic_MageArmor",JUDGEMENT="Spell_Holy_RighteousFury",JUDGEMENT_OF_COMMAND="Ability_Warrior_InnerRage",JUDGEMENT_OF_JUSTICE="Spell_Holy_SealOfWrath",JUDGEMENT_OF_LIGHT="Spell_Holy_HealingAura",JUDGEMENT_OF_RIGHTEOUSNESS="Ability_ThunderBolt",JUDGEMENT_OF_THE_CRUSADER="Spell_Holy_HolySmite",JUDGEMENT_OF_WISDOM="Spell_Holy_RighteousnessAura",KICK="Ability_Kick",KIDNEY_SHOT="Ability_Rogue_KidneyShot",KILLER_INSTINCT="Spell_Holy_BlessingOfStamina",KODO_RIDING="Spell_Nature_Swiftness",LASH_OF_PAIN="Spell_Shadow_Curse",LASTING_JUDGEMENT="Spell_Holy_HealingAura",LAST_STAND="Spell_Holy_AshesToAshes",LAY_ON_HANDS="Spell_Holy_LayOnHands",LEADER_OF_THE_PACK="Spell_Nature_UnyeildingStamina",LEATHER="INV_Chest_Leather_09",LESSER_HEAL="Spell_Holy_LesserHeal",LESSER_HEALING_WAVE="Spell_Nature_HealingWaveLesser",LESSER_INVISIBILITY="Spell_Magic_LesserInvisibilty",LETHALITY="Ability_CriticalStrike",LETHAL_SHOTS="Ability_SearingArrow",LEVITATE="Spell_Holy_LayOnHands",LIBRAM="INV_Misc_Book_11",LIFE_TAP="Spell_Shadow_BurningSpirit",LIGHTNING_BOLT="Spell_Nature_Lightning",LIGHTNING_BREATH="Spell_Nature_Lightning",LIGHTNING_MASTERY="Spell_Lightning_LightningBolt01",LIGHTNING_REFLEXES="Spell_Nature_Invisibilty",LIGHTNING_SHIELD="Spell_Nature_LightningShield",LIGHTWELL="Spell_Holy_SummonLightwell",LIGHTWELL_RENEW="Spell_Holy_SummonLightwell",LONG_DAZE="Spell_Frost_Stun",MACE_SPECIALIZATION="INV_Mace_01",MACE_STUN_EFFECT="Spell_Frost_Stun",MAGE_ARMOR="Spell_MageArmor",MAGMA_TOTEM="Spell_Fire_SelfDestruct",MAIL="INV_Chest_Chain_05",MALICE="Ability_Racial_BloodRage",MANA_BURN="Spell_Shadow_ManaBurn",MANA_SHIELD="Spell_Shadow_DetectLesserInvisibility",MANA_SPRING_TOTEM="Spell_Nature_ManaRegenTotem",MANA_TIDE_TOTEM="Spell_Frost_SummonWaterElemental",MANGLE="Ability_Druid_Mangle.tga",MARK_OF_THE_WILD="Spell_Nature_Regeneration",MARTYRDOM="Spell_Nature_Tranquility",MASTER_DEMONOLOGIST="Spell_Shadow_ShadowPact",MASTER_OF_DECEPTION="Spell_Shadow_Charm",MASTER_SUMMONER="Spell_Shadow_ImpPhaseShift",MAUL="Ability_Druid_Maul",MECHANOSTRIDER_PILOTING="Spell_Nature_Swiftness",MEDITATION="Spell_Nature_Sleep",MELEE_SPECIALIZATION="INV_Axe_02",MEND_PET="Ability_Hunter_MendPet",MENTAL_AGILITY="Ability_Hibernation",MENTAL_STRENGTH="Spell_Nature_EnchantArmor",MIND_BLAST="Spell_Shadow_UnholyFrenzy",MIND_CONTROL="Spell_Shadow_ShadowWordDominate",MIND_FLAY="Spell_Shadow_SiphonMana",MIND_NUMBING_POISON="Spell_Nature_NullifyDisease",MIND_NUMBING_POISON_II="Spell_Nature_NullifyDisease",MIND_NUMBING_POISON_III="Spell_Nature_NullifyDisease",MIND_SOOTHE="Spell_Holy_MindSooth",MIND_VISION="Spell_Holy_MindVision",MOCKING_BLOW="Ability_Warrior_PunishingBlow",MONGOOSE_BITE="Ability_Hunter_SwiftStrike",MONSTER_SLAYING="INV_Misc_Head_Dragon_Black",MOONFIRE="Spell_Nature_StarFall",MOONFURY="Spell_Nature_MoonGlow",MOONGLOW="Spell_Nature_Sentinal",MOONKIN_AURA="Spell_Nature_MoonGlow",MOONKIN_FORM="Spell_Nature_ForceOfNature",MORTAL_SHOTS="Ability_PierceDamage",MORTAL_STRIKE="Ability_Warrior_SavageBlow",MULTI_SHOT="Ability_UpgradeMoonGlaive",MURDER="Spell_Shadow_DeathScream",NATURAL_ARMOR="Spell_Nature_SpiritArmor",NATURAL_SHAPESHIFTER="Spell_Nature_WispSplode",NATURAL_WEAPONS="INV_Staff_01",NATURES_FOCUS="Spell_Nature_HealingWaveGreater",NATURES_GRACE="Spell_Nature_NaturesBlessing",NATURES_GRASP="Spell_Nature_NaturesWrath",NATURES_REACH="Spell_Nature_NatureTouchGrow",NATURES_SWIFTNESS="Spell_Nature_RavenForm",NATURE_RESISTANCE="Spell_Nature_ResistNature",NATURE_RESISTANCE_TOTEM="Spell_Nature_NatureResistanceTotem",NIGHTFALL="Spell_Shadow_Twilight",OMEN_OF_CLARITY="Spell_Nature_CrystalBall",ONE_HANDED_AXES="INV_Axe_01",ONE_HANDED_MACES="INV_Mace_01",ONE_HANDED_SWORDS="Ability_MeleeDamage",ONE_HANDED_WEAPON_SPECIALIZATION="INV_Sword_20",OPENING="Temp",OPENING___NO_TEXT="Temp",OPPORTUNITY="Ability_Warrior_WarCry",OVERPOWER="Ability_MeleeDamage",PARANOIA="Spell_Shadow_AuraOfDarkness",PARRY="Ability_Parry",PATHFINDING="Ability_Mount_JungleTiger",PERCEPTION="Spell_Nature_Sleep",PERMAFROST="Spell_Frost_Wisp",PET_AGGRESSION="Ability_Druid_Maul",PET_HARDINESS="Ability_BullRush",PET_RECOVERY="Ability_Hibernation",PET_RESISTANCE="Spell_Holy_BlessingOfAgility",PHASE_SHIFT="Spell_Shadow_ImpPhaseShift",PICK_LOCK="Spell_Nature_MoonKey",PICK_POCKET="INV_Misc_Bag_11",PIERCING_HOWL="Spell_Shadow_DeathScream",PIERCING_ICE="Spell_Frost_Frostbolt",PLATE_MAIL="INV_Chest_Plate01",POISONS="Trade_BrewPoison",POISON_CLEANSING_TOTEM="Spell_Nature_PoisonCleansingTotem",POLEARMS="INV_Spear_06",POLEARM_SPECIALIZATION="INV_Weapon_Halbard_01",POLYMORPH="Spell_Nature_Polymorph",PORTAL_DARNASSUS="Spell_Arcane_PortalDarnassus",PORTAL_IRONFORGE="Spell_Arcane_PortalIronForge",PORTAL_ORGRIMMAR="Spell_Arcane_PortalOrgrimmar",PORTAL_STORMWIND="Spell_Arcane_PortalStormWind",PORTAL_THUNDER_BLUFF="Spell_Arcane_PortalThunderBluff",PORTAL_UNDERCITY="Spell_Arcane_PortalUnderCity",POUNCE="Ability_Druid_SupriseAttack",POUNCE_BLEED="Ability_Druid_SupriseAttack",POWER_INFUSION="Spell_Holy_PowerInfusion",POWER_WORD_FORTITUDE="Spell_Holy_WordFortitude",POWER_WORD_SHIELD="Spell_Holy_PowerWordShield",PRAYER_OF_FORTITUDE="Spell_Holy_PrayerOfFortitude",PRAYER_OF_HEALING="Spell_Holy_PrayerOfHealing02",PRAYER_OF_SHADOW_PROTECTION="Spell_Holy_PrayerofShadowProtection",PRAYER_OF_SPIRIT="Spell_Holy_PrayerofSpirit",PRECISION="Ability_Marksmanship",PREDATORY_STRIKES="Ability_Hunter_Pet_Cat",PREMEDITATION="Spell_Shadow_Possession",PREPARATION="Spell_Shadow_AntiShadow",PRESENCE_OF_MIND="Spell_Nature_EnchantArmor",PRIMAL_FURY="Ability_Racial_Cannibalize",PROWL="Ability_Druid_SupriseAttack",PSYCHIC_SCREAM="Spell_Shadow_PsychicScream",PUMMEL="INV_Gauntlets_04",PURGE="Spell_Nature_Purge",PURIFICATION="Spell_Frost_WizardMark",PURIFY="Spell_Holy_Purify",PURSUIT_OF_JUSTICE="Spell_Holy_PersuitofJustice",PYROBLAST="Spell_Fire_Fireball02",PYROCLASM="Spell_Fire_Volcano",QUICKNESS="Ability_Racial_ShadowMeld",RAIN_OF_FIRE="Spell_Shadow_RainOfFire",RAKE="Ability_Druid_Disembowel",RAM_RIDING="Spell_Nature_Swiftness",RANGED_WEAPON_SPECIALIZATION="INV_Weapon_Rifle_06",RAPID_CONCEALMENT="Ability_Ambush",RAPID_FIRE="Ability_Hunter_RunningShot",RAPTOR_RIDING="Spell_Nature_Swiftness",RAPTOR_STRIKE="Ability_MeleeDamage",RAVAGE="Ability_Druid_Ravage",READINESS="Spell_Nature_Sleep",REBIRTH="Spell_Nature_Reincarnation",RECKLESSNESS="Ability_CriticalStrike",RECKONING="Spell_Holy_BlessingOfStrength",REDEMPTION="Spell_Holy_Resurrection",REDOUBT="Ability_Defend",REFLECTION="Spell_Frost_WindWalkOn",REGENERATION="Spell_Nature_Regenerate",REGROWTH="Spell_Nature_ResistNature",REINCARNATION="Spell_Nature_Reincarnation",
		REJUVENATION="Spell_Nature_Rejuvenation",RELENTLESS_STRIKES="Ability_Warrior_DecisiveStrike",REMORSELESS_ATTACKS="Ability_FiegnDead",REMOVE_CURSE="Spell_Holy_RemoveCurse",REMOVE_INSIGNIA="Temp",REMOVE_LESSER_CURSE="Spell_Nature_RemoveCurse",REND="Ability_Gouge",RENEW="Spell_Holy_Renew",REPENTANCE="Spell_Holy_PrayerOfHealing",RESURRECTION="Spell_Holy_Resurrection",RETALIATION="Ability_Warrior_Challange",RETRIBUTION_AURA="Spell_Holy_AuraOfLight",REVENGE="Ability_Warrior_Revenge",REVENGE_STUN="Ability_Warrior_Revenge",REVERBERATION="Spell_Frost_FrostWard",REVIVE_PET="Ability_Hunter_BeastSoothe",RIGHTEOUS_FURY="Spell_Holy_SealOfFury",RIP="Ability_GhoulFrenzy",RIPOSTE="Ability_Warrior_Challange",RITUAL_OF_DOOM="Spell_Shadow_AntiMagicShell",RITUAL_OF_DOOM_EFFECT="Spell_Arcane_PortalDarnassus",RITUAL_OF_SUMMONING="Spell_Shadow_Twilight",ROCKBITER_WEAPON="Spell_Nature_RockBiter",ROGUE_PASSIVE="Ability_Stealth",RUIN="Spell_Shadow_ShadowWordPain",RUPTURE="Ability_Rogue_Rupture",RUTHLESSNESS="Ability_Druid_Disembowel",SACRIFICE="Spell_Shadow_SacrificialShield",SAFE_FALL="INV_Feather_01",SANCTITY_AURA="Spell_Holy_MindVision",SAP="Ability_Sap",SAVAGE_FURY="Ability_Druid_Ravage",SAVAGE_STRIKES="Ability_Racial_BloodRage",SCARE_BEAST="Ability_Druid_Cower",SCATTER_SHOT="Ability_GolemStormBolt",SCORCH="Spell_Fire_SoulBurn",SCORPID_POISON="Ability_PoisonSting",SCORPID_STING="Ability_Hunter_CriticalShot",SCREECH="Ability_Hunter_Pet_Bat",SEAL_FATE="Spell_Shadow_ChillTouch",SEAL_OF_COMMAND="Ability_Warrior_InnerRage",SEAL_OF_JUSTICE="Spell_Holy_SealOfWrath",SEAL_OF_LIGHT="Spell_Holy_HealingAura",SEAL_OF_RIGHTEOUSNESS="Ability_ThunderBolt",SEAL_OF_THE_CRUSADER="Spell_Holy_HolySmite",SEAL_OF_WISDOM="Spell_Holy_RighteousnessAura",SEARING_LIGHT="Spell_Holy_SearingLightPriest",SEARING_PAIN="Spell_Fire_SoulBurn",SEARING_TOTEM="Spell_Fire_SearingTotem",SEDUCTION="Spell_Shadow_MindSteal",SENSE_DEMONS="Spell_Shadow_Metamorphosis",SENSE_UNDEAD="Spell_Holy_SenseUndead",SENTRY_TOTEM="Spell_Nature_RemoveCurse",SERPENT_STING="Ability_Hunter_Quickshot",SETUP="Spell_Nature_MirrorImage",SHACKLE_UNDEAD="Spell_Nature_Slow",SHADOWBURN="Spell_Shadow_ScourgeBuild",SHADOWFORM="Spell_Shadow_Shadowform",SHADOWGUARD="Spell_Nature_LightningShield",SHADOWMELD="Ability_Ambush",SHADOWMELD_PASSIVE="Ability_Ambush",SHADOW_AFFINITY="Spell_Shadow_ShadowWard",SHADOW_BOLT="Spell_Shadow_ShadowBolt",SHADOW_FOCUS="Spell_Shadow_BurningSpirit",SHADOW_MASTERY="Spell_Shadow_ShadeTrueSight",SHADOW_PROTECTION="Spell_Shadow_AntiShadow",SHADOW_REACH="Spell_Shadow_ChillTouch",SHADOW_RESISTANCE="Spell_Shadow_AntiShadow",SHADOW_RESISTANCE_AURA="Spell_Shadow_SealOfKings",SHADOW_WARD="Spell_Shadow_AntiShadow",SHADOW_WEAVING="Spell_Shadow_BlackPlague",SHADOW_WORD_PAIN="Spell_Shadow_ShadowWordPain",SHARPENED_CLAWS="INV_Misc_MonsterClaw_04",SHATTER="Spell_Frost_FrostShock",SHELL_SHIELD="Ability_Hunter_Pet_Turtle",SHIELD="INV_Shield_04",SHIELD_BASH="Ability_Warrior_ShieldBash",SHIELD_BLOCK="Ability_Defend",SHIELD_SLAM="INV_Shield_05",SHIELD_SPECIALIZATION="INV_Shield_06",SHIELD_WALL="Ability_Warrior_ShieldWall",SHOOT="Ability_ShootWand",SHOOT_BOW="Ability_Marksmanship",SHOOT_CROSSBOW="Ability_Marksmanship",SHOOT_GUN="Ability_Marksmanship",SHRED="Spell_Shadow_VampiricAura",SILENCE="Spell_Shadow_ImpPhaseShift",SILENT_RESOLVE="Spell_Nature_ManaRegenTotem",SINISTER_STRIKE="Spell_Shadow_RitualOfSacrifice",SIPHON_LIFE="Spell_Shadow_Requiem",SLAM="Ability_Warrior_DecisiveStrike",SLICE_AND_DICE="Ability_Rogue_SliceDice",SLOW_FALL="Spell_Magic_FeatherFall",SMITE="Spell_Holy_HolySmite",SOOTHE_ANIMAL="Ability_Hunter_BeastSoothe",SOOTHING_KISS="Spell_Shadow_SoothingKiss",SOUL_FIRE="Spell_Fire_Fireball02",SOUL_LINK="Spell_Shadow_GatherShadows",SPELLDEFENSE="Temp",SPELL_LOCK="Spell_Shadow_MindRot",SPELL_WARDING="Spell_Holy_SpellWarding",SPIRITUAL_FOCUS="Spell_Arcane_Blink",SPIRITUAL_GUIDANCE="Spell_Holy_SpiritualGuidence",SPIRITUAL_HEALING="Spell_Nature_MoonGlow",SPIRIT_BOND="Ability_Druid_DemoralizingRoar",SPIRIT_OF_REDEMPTION="INV_Enchant_EssenceEternalLarge",SPIRIT_TAP="Spell_Shadow_Requiem",SPRINT="Ability_Rogue_Sprint",STARFIRE="Spell_Arcane_StarFire",STARSHARDS="Spell_Arcane_StarFire",STAVES="INV_Staff_08",STEALTH="Ability_Stealth",STONECLAW_TOTEM="Spell_Nature_StoneClawTotem",STONEFORM="Spell_Shadow_UnholyStrength",STONESKIN_TOTEM="Spell_Nature_StoneSkinTotem",STORMSTRIKE="Spell_Holy_SealOfMight",STRENGTH_OF_EARTH_TOTEM="Spell_Nature_EarthBindTotem",STUCK="Spell_Shadow_Teleport",SUBTLETY="Ability_EyeOfTheOwl",SUFFERING="Spell_Shadow_BlackPlague",SUMMON_CHARGER="Ability_Mount_Charger",SUMMON_DREADSTEED="Ability_Mount_Dreadsteed",SUMMON_FELHUNTER="Spell_Shadow_SummonFelHunter",SUMMON_FELSTEED="Spell_Nature_Swiftness",SUMMON_IMP="Spell_Shadow_SummonImp",SUMMON_SUCCUBUS="Spell_Shadow_SummonSuccubus",SUMMON_VOIDWALKER="Spell_Shadow_SummonVoidWalker",SUMMON_WARHORSE="Spell_Nature_Swiftness",SUNDER_ARMOR="Ability_Warrior_Sunder",SUPPRESSION="Spell_Shadow_UnsummonBuilding",SUREFOOTED="Ability_Kick",SURVIVALIST="Spell_Shadow_Twilight",SWEEPING_STRIKES="Ability_Rogue_SliceDice",SWIPE="INV_Misc_MonsterClaw_03",SWORD_SPECIALIZATION="INV_Sword_27",TACTICAL_MASTERY="Spell_Nature_EnchantArmor",TAINTED_BLOOD="Spell_Shadow_LifeDrain",TAMED_PET_PASSIVE="Ability_Mount_PinkTiger",TAME_BEAST="Ability_Hunter_BeastTaming",TAUNT="Spell_Nature_Reincarnation",TELEPORT_DARNASSUS="Spell_Arcane_TeleportDarnassus",TELEPORT_IRONFORGE="Spell_Arcane_TeleportIronForge",TELEPORT_MOONGLADE="Spell_Arcane_TeleportMoonglade",TELEPORT_ORGRIMMAR="Spell_Arcane_TeleportOrgrimmar",TELEPORT_STORMWIND="Spell_Arcane_TeleportStormWind",TELEPORT_THUNDER_BLUFF="Spell_Arcane_TeleportThunderBluff",TELEPORT_UNDERCITY="Spell_Arcane_TeleportUnderCity",THE_HUMAN_SPIRIT="INV_Enchant_ShardBrilliantSmall",THICK_HIDE="INV_Misc_Pelt_Bear_03",THORNS="Spell_Nature_Thorns",THROW="Ability_Throw",THROWING_SPECIALIZATION="INV_ThrowingAxe_03",THROWING_WEAPON_SPECIALIZATION="INV_ThrowingKnife_01",THROWN="INV_ThrowingKnife_02",THUNDERING_STRIKES="Ability_ThunderBolt",THUNDERSTOMP="Ability_Hunter_Pet_Gorilla",THUNDER_CLAP="Spell_Nature_ThunderClap",TIDAL_FOCUS="Spell_Frost_ManaRecharge",TIDAL_MASTERY="Spell_Nature_Tranquility",TIGERS_FURY="Ability_Mount_JungleTiger",TIGER_RIDING="Spell_Nature_Swiftness",TORMENT="Spell_Shadow_GatherShadows",TOTEM="Spell_Nature_StoneClawTotem",TOTEMIC_FOCUS="Spell_Nature_MoonGlow",TOUCH_OF_WEAKNESS="Spell_Shadow_DeadofNight",TOUGHNESS="Spell_Holy_Devotion",TRACK_BEASTS="Ability_Tracking",TRACK_DEMONS="Spell_Shadow_SummonFelHunter",TRACK_DRAGONKIN="INV_Misc_Head_Dragon_01",TRACK_ELEMENTALS="Spell_Frost_SummonWaterElemental",TRACK_GIANTS="Ability_Racial_Avatar",TRACK_HIDDEN="Ability_Stealth",TRACK_HUMANOIDS="Ability_Tracking",TRACK_UNDEAD="Spell_Shadow_DarkSummoning",TRANQUILITY="Spell_Nature_Tranquility",TRANQUILIZING_SHOT="Spell_Nature_Drowsy",TRANQUIL_AIR_TOTEM="Spell_Nature_Brilliance",TRANQUIL_SPIRIT="Spell_Holy_ElunesGrace",TRAP_MASTERY="Ability_Ensnare",TRAVEL_FORM="Ability_Druid_TravelForm",TREMOR_TOTEM="Spell_Nature_TremorTotem",TRUESHOT_AURA="Ability_TrueShot",TURN_UNDEAD="Spell_Holy_TurnUndead",TWO_HANDED_AXES="INV_Axe_04",TWO_HANDED_AXES_AND_MACES="INV_Axe_10",TWO_HANDED_MACES="INV_Mace_04",TWO_HANDED_SWORDS="Ability_MeleeDamage",TWO_HANDED_WEAPON_SPECIALIZATION="INV_Axe_09",UNARMED="Ability_GolemThunderClap",UNBREAKABLE_WILL="Spell_Magic_MageArmor",UNBRIDLED_WRATH="Spell_Nature_StoneClawTotem",UNBRIDLED_WRATH_EFFECT="Spell_Nature_StoneClawTotem",UNDEAD_HORSEMANSHIP="Spell_Nature_Swiftness",UNDERWATER_BREATHING="Spell_Shadow_DemonBreath",UNENDING_BREATH="Spell_Shadow_DemonBreath",UNHOLY_POWER="Spell_Shadow_ShadowWordDominate",UNLEASHED_FURY="Ability_BullRush",UNYIELDING_FAITH="Spell_Holy_UnyieldingFaith",VAMPIRIC_EMBRACE="Spell_Shadow_UnsummonBuilding",VANISH="Ability_Vanish",VANISHED="Ability_Vanish",VENGEANCE="Spell_Nature_Purge",VIGOR="Spell_Nature_EarthBindTotem",VILE_POISONS="Ability_Rogue_FeignDeath",VINDICATION="Spell_Holy_Vindication",VIPER_STING="Ability_Hunter_AimedShot",VOLLEY="Ability_Marksmanship",WANDS="Ability_ShootWand",WAND_SPECIALIZATION="INV_Wand_01",WAR_STOMP="Ability_WarStomp",WATER_BREATHING="Spell_Shadow_DemonBreath",WATER_WALKING="Spell_Frost_WindWalkOn",WHIRLWIND="Ability_Whirlwind",WILL_OF_THE_FORSAKEN="Spell_Shadow_RaiseDead",WINDFURY_TOTEM="Spell_Nature_Windfury",WINDFURY_WEAPON="Spell_Nature_Cyclone",WINDWALL_TOTEM="Spell_Nature_EarthBind",WING_CLIP="Ability_Rogue_Trip",WINTERS_CHILL="Spell_Frost_ChillingBlast",WISP_SPIRIT="Spell_Nature_WispSplode",WOLF_RIDING="Spell_Nature_Swiftness",WOUND_POISON="INV_Misc_Herb_16",WOUND_POISON_II="INV_Misc_Herb_16",WOUND_POISON_III="INV_Misc_Herb_16",WOUND_POISON_IV="INV_Misc_Herb_16",WRATH="Spell_Nature_AbolishMagic",WYVERN_STING="INV_Spear_02",WEAKENED_SOUL="Spell_Holy_AshesToAshes",SOULSTONE_RESURRECTION="INV_Misc_Orb_04",
	}
	initSpellIcons = nil
end

local lib = {}
local localSpells

function lib:GetEnglish(spell)
	return localSpells[spell] or spell
end

function lib:GetLocalized(spell)
	return spells[spell] or spell
end

function lib:GetIterator()
	return pairs(spells)
end

function lib:GetReverseIterator()
	return pairs(localSpells)
end

function lib:HasSpell(spell)
	return (spells[spell] or localSpells[spell]) and true or false
end

function lib:GetSpellIcon(spell)
	local icon = spellIcons[self:GetEnglish(spell)]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function lib:GetLibraryVersion()
	return MAJOR_VERSION, MINOR_VERSION
end

function lib:LibActivate(stub, oldLib, oldList)
	initSpells()
	initSpellIcons()
	initSpells = nil
	initSpellIcons = nil
	
	localSpells = {}
	for english, localized in pairs(spells) do
		if string.sub(english, -4) == "_ALT" then
			localSpells[localized] = string.sub(english, 0, -5)
		elseif string.sub(english, -5, -2) == "_ALT" then
			localSpells[localized] = string.sub(english, 0, -6)
		else
			localSpells[localized] = english
		end
	end
end

function lib:LibDeactivate()
	spells, localSpells, initSpells, initSpellIcons = nil
end

BabbleLib:Register(lib)
lib = nil
