-- FuBar_Kui-Nameplates  by laytya
------------------------------------------------------------
KNPFu = 		AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0")
local KNPFu = KNPFu

--Fubar plugin settings
KNPFu.version = "1.0"
KNPFu.date = "29/06/2018"
KNPFu.hasIcon = "Interface\\AddOns\\FuBar_KuiNameplates\\icon"
KNPFu.canHideText = true
KNPFu.hasNoColor = true
KNPFu.clickableTooltip = false
KNPFu.cannotDetachTooltip = true
KNPFu.hideWithoutStandby = false
KNPFu.profileCode = true

KNPFu.defaultPosition = "RIGHT";
KNPFu.defaultMinimapPosition = 235;

-- localization Lib
local L = 		AceLibrary("AceLocale-2.2"):new("FuBar_Kui-Nameplates"); 

-- tool tip Lib
local tablet = 	AceLibrary("Tablet-2.0")

local AceConfigDialog = LibStub('AceConfigDialog-3.0')


function KNPFu:OnInitialize()
	-- Activate menu options to hide icon/text by activating "AceDB-2.0" DB
	self:RegisterDB("FuBar_KuiNameplatesDB")
end


-- Menu Items
KNPFu.OnMenuRequest = {
	type = 'group',
	args = {
		options = {
			type = "toggle",
			name = L["Kui-Nameplates"],
			desc = L["Open Kui-Nameplates Options"],
			get = function() return AceConfigDialog.OpenFrames[kuinameplates] ~= nil end,
			set = (function() 
						if AceConfigDialog.OpenFrames[kuinameplates] ~= nil then
							AceConfigDialog:Close('kuinameplates')
						else
							AceConfigDialog:Open('kuinameplates')
						end 
				  end),
		},
	}
}


function KNPFu:OnTextUpdate()
	self:SetText(L["Kui-Nameplates"])
end


-- keep self updated when activated?
function KNPFu:OnEnable()
	self:Update();
end

-- tool tip
function KNPFu:OnTooltipUpdate()
	local cat = tablet:AddCategory('columns', 1)
	cat:AddLine(
		'text', L["TOOLTIP_NOTE"],
		'size', 12
	)
	tablet:SetTitle(L["TOOLTIP_NAME"])
	tablet:SetHint(L["TOOLTIP_HINT1"])
end

-- when Clicked do this
function KNPFu:OnClick()
	if AceConfigDialog.OpenFrames[kuinameplates] ~= nil then
		AceConfigDialog:Close('kuinameplates')
	else
		AceConfigDialog:Open('kuinameplates')
	end
end
