ReloadUIfu = 		AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0")
local ReloadUIfu = ReloadUIfu

--Fubar plugin settings
ReloadUIfu.version = "0.1.0"
ReloadUIfu.date = "21.03.2017"
ReloadUIfu.hasIcon = true
ReloadUIfu.canHideText = true
ReloadUIfu.hasNoColor = true
ReloadUIfu.clickableTooltip = false
ReloadUIfu.cannotDetachTooltip = true
ReloadUIfu.hideWithoutStandby = false
ReloadUIfu.profileCode = true

ReloadUIfu.defaultPosition = "RIGHT";
ReloadUIfu.defaultMinimapPosition = 200;

-- localization Lib
local L = 		AceLibrary("AceLocale-2.2"):new("ReloadUIfu"); 

-- tool tip Lib
local tablet = 	AceLibrary("Tablet-2.0")




function ReloadUIfu:OnInitialize()
	-- Activate menu options to hide icon/text by activating "AceDB-2.0" DB
	self:RegisterDB("FuBar_ReloadUIDB")
end


-- Menu Items
ReloadUIfu.OnMenuRequest = {
	type = 'group',
	args = {
		reloadui = {
			type = "execute",
			name = L["Reload UI"],
			desc = L["Reload WOW Interface."],
			func = function() ReloadUI() end,
		},

	}
}


function ReloadUIfu:OnTextUpdate()
	self:SetText(L["Reload UI"])
end


-- keep self updated when activated?
function ReloadUIfu:OnEnable()
	self:Update();
end


-- tool tip
function ReloadUIfu:OnTooltipUpdate()
	tablet:SetTitle(L["TOOLTIP_NAME"])
	tablet:SetHint(L["TOOLTIP_HINT1"])
end

-- when Clicked do this
function ReloadUIfu:OnClick()
	ReloadUI()
end
