local dewdrop = DewdropLib:GetInstance('1.0')
local tablet = TabletLib:GetInstance('1.0')
local toonSaveKey = ''

SkillsPlusFu = FuBarPlugin:GetInstance("1.2"):new({
	name          = SkillsPlusFuLocals.NAME,
	description   = SkillsPlusFuLocals.DESCRIPTION,
	version       = "1.2."..string.sub("$Revision: 0 $", 12, -3),
	releaseDate   = string.sub("$Date: 2006-09-03 08:00 +0100 (Sun, 03 September 2006) $", 8, 17),
	aceCompatible = 103,
--	fuCompatible  = 102,
	author        = "Jayhawk",
	email         = "jaydehawk@gmail.com",
	category      = "others",
	db            = AceDatabase:new("SkillsPlusFuDB"),
	defaults      = {
                         -- flags
                         showBooleanSkills = false,
                         -- lists
                         toonSave = {},
                        },
	charDefaults  = { hidden = {} },
--	cmd           = AceChatCmd:new(SkillsPlusFuLocals.COMMANDS, SkillsPlusFuLocals.CMD_OPTIONS),
	loc           = SkillsPlusFuLocals,
	hasIcon       = "Interface\\Icons\\Trade_Engineering",
	clickableTooltip = true,
})

-- methods

function SkillsPlusFu:IsShowingBooleanSkills()
	return self.data.showBooleanSkills
end

function SkillsPlusFu:ToggleShowingBooleanSkills()
	self.data.showBooleanSkills = not self.data.showBooleanSkills
	self:UpdateTooltip()
	return self.data.showBooleanSkills
end

function SkillsPlusFu:Initialize()

     self.labelName = self.loc.FUBAR_LABEL

	self.ICON_ALCHEMY = "Interface\\Icons\\Trade_Alchemy"
	self.ICON_BLACKSMITHING = "Interface\\Icons\\Trade_Blacksmithing"
	self.ICON_COOKING = "Interface\\Icons\\INV_Misc_Food_15"
	self.ICON_DISENCHANTING = "Interface\\Icons\\Spell_Holy_RemoveCurse"
	self.ICON_ENCHANTING = "Interface\\Icons\\Trade_Engraving"
	self.ICON_ENGINEERING = "Interface\\Icons\\Trade_Engineering"
	self.ICON_FIRSTAID = "Interface\\Icons\\Spell_Holy_SealOfSacrifice"
	self.ICON_FISHING = "Interface\\Icons\\Trade_Fishing"
	self.ICON_LEATHERWORKING = "Interface\\Icons\\Trade_Leatherworking"
	self.ICON_LOCKPICKING = "Interface\\Icons\\INV_Misc_Key_03"
	self.ICON_POISONS = "Interface\\Icons\\Trade_BrewPoison"
	self.ICON_SMELTING = "Interface\\Icons\\Trade_Mining"
	self.ICON_TAILORING = "Interface\\Icons\\Trade_Tailoring"
	
	self.skillList = {}
end

function SkillsPlusFu:Enable()
    -- skills management
	self:RegisterEvent("SKILL_LINES_CHANGED","Update")
	self:RegisterEvent("PLAYER_LEVEL_UP","Update") 
   -- variables
    toonSaveKey = GetCVar('realmName')..'|'..UnitName('player')
     self:UpdateToonInfo()

end

-- toon management

function SkillsPlusFu:UpdateToonInfo()
    if (self.data.toonSave[toonSaveKey] == nil) then
        self.data.toonSave[toonSaveKey] = {}
    end
    if (self.labelName == SkillsPlusFuLocals.FUBAR_LABEL) and
       (self.data.toonSave[toonSaveKey].LastUsed ~= nil) then
        self.labelName = self.data.toonSave[toonSaveKey].LastUsed
    else
        self.data.toonSave[toonSaveKey].LastUsed = self.labelName
    end
end

-- skills maangement
function SkillsPlusFu:IsProfession(skillName)
        if (skillName == self.loc.SKILL_ALCHEMY) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_ALCHEMY,
	        	'func', function() CastSpellByName(self.loc.SKILL_ALCHEMY)
                                   self:UpdateText(self.loc.SKILL_ALCHEMY,self.ICON_ALCHEMY)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_BLACKSMITHING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_BLACKSMITHING,
	        	'func', function() CastSpellByName(self.loc.SKILL_BLACKSMITHING)
                                   self:UpdateText(self.loc.SKILL_BLACKSMITHING,self.ICON_BLACKSMITHING)
                         end,
      			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_COOKING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_COOKING,
	        	'func', function() CastSpellByName(self.loc.SKILL_COOKING)
                                   self:UpdateText(self.loc.SKILL_COOKING,self.ICON_COOKING)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_ENCHANTING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_DISENCHANTING,
	        	'func', function() CastSpellByName(self.loc.SKILL_DISENCHANTING)
                                   self:UpdateText(self.loc.SKILL_DISENCHANTING,self.ICON_DISENCHANTING)
                        end,
       			'arg1', self
                )
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_ENCHANTING,
	        	'func', function() CastSpellByName(self.loc.SKILL_ENCHANTING)
                                   self:UpdateText(self.loc.SKILL_ENCHANTING,self.ICON_ENCHANTING)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_ENGINEERING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_ENGINEERING,
	        	'func', function() CastSpellByName(self.loc.SKILL_ENGINEERING)
                                   self:UpdateText(self.loc.SKILL_ENGINEERING,self.ICON_ENGINEERING)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_FIRSTAID) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_FIRSTAID,
	        	'func', function() CastSpellByName(self.loc.SKILL_FIRSTAID)
                                   self:UpdateText(self.loc.SKILL_FIRSTAID,self.ICON_FIRSTAID)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_FISHING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_FISHING,
	        	'func', function() CastSpellByName(self.loc.SKILL_FISHING)
                                   self:UpdateText(self.loc.SKILL_FISHING,self.ICON_FISHING)
                         end,
      			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_LEATHERWORKING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_LEATHERWORKING,
	        	'func', function() CastSpellByName(self.loc.SKILL_LEATHERWORKING)
                                   self:UpdateText(self.loc.SKILL_LEATHERWORKING,self.ICON_LEATHERWORKING)
                         end,
      			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_LOCKPICKING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_LOCKPICKING,
	        	'func', function() CastSpellByName(self.loc.SKILL_PICKLOCK)
                                   self:UpdateText(self.loc.SKILL_PICKLOCK,self.ICON_LOCKPICKING)
                         end,
      			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_MINING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_SMELTING,
	        	'func', function() CastSpellByName(self.loc.SKILL_SMELTING)
                                   self:UpdateText(self.loc.SKILL_SMELTING,self.ICON_SMELTING)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_POISONS) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_POISONS,
	        	'func', function() CastSpellByName(self.loc.SKILL_POISONS)
                                   self:UpdateText(self.loc.SKILL_POISONS,self.ICON_POISONS)
                        end,
       			'arg1', self
                )
        end
        if (skillName == self.loc.SKILL_TAILORING) then
       		dewdrop:AddLine(
        		'text', self.loc.SKILL_TAILORING,
	        	'func', function() CastSpellByName(self.loc.SKILL_TAILORING)
                                   self:UpdateText(self.loc.SKILL_TAILORING,self.ICON_TAILORING)
                        end,
       			'arg1', self
                )
        end
end

function SkillsPlusFu:MenuSettings(level, value)
	if level == 1 then
        	for _,category in self.skillList do
	        	if category.nonBooleanSkills > 0 then
        		        for _,skill in category.skills do
                                        self:IsProfession(skill.name)
                                end
                        end
                end
       		if (GetNumSkillLines() > 0) then dewdrop:AddLine() end
		dewdrop:AddLine(
			'text', self.loc.MENU_SHOW_BOOLEAN_SKILLS,
			'func', 'ToggleShowingBooleanSkills',
			'arg1', self,
			'checked', self:IsShowingBooleanSkills()
		)
	end
end

function SkillsPlusFu:UpdateData()
	local skillIndex = 0
	local skillList = {}
	local headerIndex = 0
	
	local numSkills = GetNumSkillLines()
	
	for skillIndex=1, numSkills do
		local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDesc = GetSkillLineInfo(skillIndex)
		
		if isHeader then
			headerIndex = headerIndex + 1
			table.insert(skillList, {category=skillName, skills={}, nonBooleanSkills = 0})
		else
			if skillMaxRank > 1 then skillList[headerIndex].nonBooleanSkills = skillList[headerIndex].nonBooleanSkills + 1 end
			table.insert(skillList[headerIndex].skills, {name = skillName,  rank = skillRank,  maxrank = skillMaxRank, rankbonus = skillModifier})
		end
	end
	self.skillList = skillList
end

function SkillsPlusFu:UpdateText(newLabel,newIcon)
    if newIcon ~= nil then self:SetIcon(newIcon) end
    if newLabel ~= nil then
       self.labelName = newLabel
       self:UpdateToonInfo()
    end
    self:SetText(self.labelName)
	dewdrop:Close()
end

function SkillsPlusFu:UpdateTooltip()
	tablet:SetHint(self.loc.TOOLTIP_HINT)
	
	for _,category in self.skillList do
		if category.nonBooleanSkills > 0 or self:IsShowingBooleanSkills() then
			local cat = tablet:AddCategory(
				'id', category.category, 'columns', 2,
				'text', category.category,
				'func', 'ToggleCategory', 'arg1', self, 'arg2', category.category,
				'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
				'showWithoutChildren', true,
				'checked', true, 'hasCheck', true, 'checkIcon', self.charData.hidden[category.category] and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)
			if not self.charData.hidden[category.category] then
				for _,skill in category.skills do
					if skill.maxrank > 1 then
						local rank = skill.rank
						if skill.rankbonus > 0  then
							rank = rank.."(+"..skill.rankbonus..")"
						end
						rank = rank.."/"..skill.maxrank
						local r,g,b = FuBarUtils.GetThresholdColor((skill.rank+(skill.rankbonus or 0)) / skill.maxrank)
						cat:AddLine(
							'text', skill.name, 'text2', rank, 
							'text2R', r, 'text2G', g, 'text2B', b)
					elseif self:IsShowingBooleanSkills() then
						cat:AddLine('text', skill.name)
					end
				end
			end
		end
	end
end

function SkillsPlusFu:OnClick()
        if self.labelName == self.loc.FUBAR_LABEL then
                ToggleCharacter("SkillFrame")
        else
        	CastSpellByName(self.labelName)
        end

end

function SkillsPlusFu:ToggleCategory(id, button)
	if self.charData.hidden[id] then
		self.charData.hidden[id] = false
	else
		self.charData.hidden[id] = true
	end
	-- Refresh in place
	self:UpdateTooltip()
end

SkillsPlusFu:RegisterForLoad()
