--[[
	Name: Babble-Spell-2.2
	Revision: $Rev: 25188 $
	Author(s): ckknight (ckknight@gmail.com)
	Website: http://ckknight.wowinterface.com/
	Documentation: http://wiki.wowace.com/index.php/Babble-Spell-2.2
	SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Spell-2.2
	Description: A library to provide localizations for spells.
	Dependencies: AceLibrary, AceLocale-2.2
]]

local MAJOR_VERSION = "Babble-Spell-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 25188 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleSpell = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleSpell:EnableDebugging()

BabbleSpell:RegisterTranslations("enUS", function()
    return {
		["Abolish Disease"] = true,
		["Abolish Poison Effect"] = true,
		["Abolish Poison"] = true,
		["Acid Breath"] = true,
		["Acid of Hakkar"] = true,
		["Acid Spit"] = true,
		["Acid Splash"] = true,
		["Activate MG Turret"] = true,
		["Adrenaline Rush"] = true,
		["Aftermath"] = true,
		["Aggression"] = true,
		["Aimed Shot"] = true,
		["Alchemy"] = true,
		["Ambush"] = true,
		["Amplify Curse"] = true,
		["Amplify Damage"] = true,
		["Amplify Flames"] = true,
		["Amplify Magic"] = true,
		["Ancestral Fortitude"] = true,
		["Ancestral Healing"] = true,
		["Ancestral Knowledge"] = true,
		["Ancestral Spirit"] = true,
		["Anesthetic Poison"] = true,
		["Anger Management"] = true,
		["Anguish"] = true,
		["Anticipation"] = true,
		["Aqua Jet"] = true,
		["Aquatic Form"] = true,
		["Arcane Blast"] = true,
		["Arcane Bolt"] = true,
		["Arcane Brilliance"] = true,
		["Arcane Concentration"] = true,
		["Arcane Explosion"] = true,
		["Arcane Focus"] = true,
		["Arcane Instability"] = true,
		["Arcane Intellect"] = true,
		["Arcane Meditation"] = true,
		["Arcane Mind"] = true,
		["Arcane Missiles"] = true,
		["Arcane Potency"] = true,
		["Arcane Power"] = true,
		["Arcane Resistance"] = true,
		["Arcane Shot"] = true,
		["Arcane Subtlety"] = true,
		["Arcane Weakness"] = true,
		["Arcing Smash"] = true,
		["Arctic Reach"] = true,
		["Armorsmith"] = true,
		["Arugal's Curse"] = true,
		["Arugal's Gift"] = true,
		["Ascendance"]=true,
		["Aspect of Arlokk"] = true,
		["Aspect of Jeklik"] = true,
		["Aspect of Mar'li"] = true,
		["Aspect of the Beast"] = true,
		["Aspect of the Cheetah"] = true,
		["Aspect of the Hawk"] = true,
		["Aspect of the Monkey"] = true,
		["Aspect of the Pack"] = true,
		["Aspect of the Viper"] = true,
		["Aspect of the Wild"] = true,
		["Aspect of Venoxis"] = true,
		["Astral Recall"] = true,
		["Attack"] = true,
		["Attacking"] = true,
		["Aura of Command"] = true,
		["Aural Shock"] = true,
		["Auto Shot"] = true,
		["Avenger's Shield"] = true,
		["Avenging Wrath"] = true,
		["Avoidance"] = true,
		["Axe Flurry"] = true,
		["Axe Specialization"] = true,
		["Axe Toss"] = true,
		["Backhand"] = true,
		["Backlash"] = true,
		["Backstab"] = true,
		["Bane"] = true,
		["Baneful Poison"] = true,
		["Banish"] = true,
		["Banshee Curse"] = true,
		["Banshee Shriek"] = true,
		["Barbed Sting"] = true,
		["Barkskin Effect"] = true,
		["Barkskin"] = true,
		["Barrage"] = true,
		["Bash"] = true,
		["Basic Campfire"] = true,
		["Battle Shout"] = true,
		["Battle Stance Passive"] = true,
		["Battle Stance"] = true,
		["Bear Form"] = true,
		["Beast Lore"] = true,
		["Beast Slaying"] = true,
		["Beast Training"] = true,
		["Befuddlement"] = true,
		["Benediction"] = true,
		["Berserker Charge"] = true,
		["Berserker Rage"] = true,
		["Berserker Stance Passive"] = true,
		["Berserker Stance"] = true,
		["Berserking"] = true,
		["Bestial Discipline"] = true,
		["Bestial Swiftness"] = true,
		["Bestial Wrath"] = true,
		["Biletoad Infection"] = true,
		["Binding Heal"] = true,
		["Bite"] = true,
		["Black Arrow"] = true,
		["Blackout"] = true,
		["Blacksmithing"] = true,
		["Blade Flurry"] = true,
		["Blast Wave"] = true,
		["Blaze"] = true,
		["Blazing Speed"] = true,
		["Blessed Recovery"] = true,
		["Blessing of Blackfathom"] = true,
		["Blessing of Freedom"] = true,
		["Blessing of Kings"] = true,
		["Blessing of Light"] = true,
		["Blessing of Might"] = true,
		["Blessing of Protection"] = true,
		["Blessing of Sacrifice"] = true,
		["Blessing of Salvation"] = true,
		["Blessing of Sanctuary"] = true,
		["Blessing of Shahram"] = true,
		["Blessing of Wisdom"] = true,
		["Blind"] = true,
		["Blinding Powder"] = true,
		["Blink"] = true,
		["Blizzard"] = true,
		["Block"] = true,
		["Blood Craze"] = true,
		["Blood Frenzy"] = true,
		["Blood Funnel"] = true,
		["Blood Fury"] = true,
		["Blood Leech"] = true,
		["Blood Pact"] = true,
		["Blood Siphon"] = true,
		["Blood Tap"] = true,
		["Bloodlust"] = true,
		["Bloodrage"] = true,
		["Bloodthirst"] = true,
		["Bomb"] = true,
		["Booming Voice"] = true,
		["Boulder"] = true,
		["Bow Specialization"] = true,
		["Bows"] = true,
		["Brain Wash"] = true,
		["Bright Campfire"] = true,
		["Brutal Impact"] = true,
		["Burning Adrenaline"] = true,
		["Burning Soul"] = true,
		["Burning Wish"] = true,
		["Butcher Drain"] = true,
		["Call of Flame"] = true,
		["Call of the Grave"] = true,
		["Call of Thunder"] = true,
		["Call Pet"] = true,
		["Camouflage"] = true,
		["Cannibalize"] = true,
		["Cat Form"] = true,
		["Cataclysm"] = true,
		["Cause Insanity"] = true,
		["Chain Bolt"] = true,
		["Chain Burn"] = true,
		["Chain Heal"] = true,
		["Chain Lightning"] = true,
		["Chained Bolt"] = true,
		["Chains of Ice"] = true,
		["Challenging Roar"] = true,
		["Challenging Shout"] = true,
		["Charge Rage Bonus Effect"] = true,
		["Charge Stun"] = true,
		["Charge"] = true,
		["Cheap Shot"] = true,
		["Chilled"] = true,
		["Chilling Touch"] = true,
		["Chromatic Infusion"]=true,
		["Circle of Healing"] = true,
		["Claw"] = true,
		["Cleanse Nova"] = true,
		["Cleanse"] = true,
		["Clearcasting"] = true,
		["Cleave"] = true,
		["Clever Traps"] = true,
		["Cloak of Shadows"] = true,
		["Closing"] = true,
		["Cloth"] = true,
		["Coarse Sharpening Stone"] = true,
		["Cobra Reflexes"] = true,
		["Cold Blood"] = true,
		["Cold Snap"] = true,
		["Combat Endurance"] = true,
		["Combustion"] = true,
		["Command"] = true,
		["Commanding Shout"] = true,
		["Concentration Aura"] = true,
		["Concussion Blow"] = true,
		["Concussion"] = true,
		["Concussive Shot"] = true,
		["Cone of Cold"] = true,
		["Conflagrate"] = true,
		["Conjure Food"] = true,
		["Conjure Mana Agate"] = true,
		["Conjure Mana Citrine"] = true,
		["Conjure Mana Jade"] = true,
		["Conjure Mana Ruby"] = true,
		["Conjure Water"] = true,
		["Consecrated Sharpening Stone"] = true,
		["Consecration"] = true,
		["Consume Magic"] = true,
		["Consume Shadows"] = true,
		["Consuming Shadows"] = true,
		["Convection"] = true,
		["Conviction"] = true,
		["Cooking"] = true,
		["Corrosive Acid Breath"] = true,
		["Corrosive Ooze"] = true,
		["Corrosive Poison"] = true,
		["Corrupted Blood"] = true,
		["Corruption"] = true,
		["Counterattack"] = true,
		["Counterspell - Silenced"] = true,
		["Counterspell"] = true,
		["Cower"] = true,
		["Create Firestone (Greater)"] = true,
		["Create Firestone (Lesser)"] = true,
		["Create Firestone (Major)"] = true,
		["Create Firestone"] = true,
		["Create Healthstone (Greater)"] = true,
		["Create Healthstone (Lesser)"] = true,
		["Create Healthstone (Major)"] = true,
		["Create Healthstone (Minor)"] = true,
		["Create Healthstone"] = true,
		["Create Soulstone (Greater)"] = true,
		["Create Soulstone (Lesser)"] = true,
		["Create Soulstone (Major)"] = true,
		["Create Soulstone (Minor)"] = true,
		["Create Soulstone"] = true,
		["Create Spellstone (Greater)"] = true,
		["Create Spellstone (Major)"] = true,
		["Create Spellstone (Master)"] = true,
		["Create Spellstone"] = true,
		["Creeper Venom"] = true,
		["Cripple"] = true,
		["Crippling Poison II"] = true,
		["Crippling Poison"] = true,
		["Critical Mass"] = true,
		["Crossbows"] = true,
		["Crowd Pummel"] = true,
		["Cruelty"] = true,
		["Crusader Aura"] = true,
		["Crusader Strike"] = true,
		["Crusader's Wrath"]=true,
		["Crystal Charge"] = true,
		["Crystal Force"] = true,
		["Crystal Restore"] = true,
		["Crystal Spire"] = true,
		["Crystal Ward"] = true,
		["Crystal Yield"] = true,
		["Crystalline Slumber"] = true,
		["Cultivation"] = true,
		["Cure Disease"] = true,
		["Cure Poison"] = true,
		["Curse of Agony"] = true,
		["Curse of Blood"] = true,
		["Curse of Doom Effect"] = true,
		["Curse of Doom"] = true,
		["Curse of Exhaustion"] = true,
		["Curse of Idiocy"] = true,
		["Curse of Recklessness"] = true,
		["Curse of Shadow"] = true,
		["Curse of the Deadwood"]=true,
		["Curse of the Elemental Lord"] = true,
		["Curse of the Elements"] = true,
		["Curse of Tongues"] = true,
		["Curse of Tuten'kash"] = true,
		["Curse of Weakness"] = true,
		["Cursed Blood"] = true,
		["Cyclone"] = true,
		["Dagger Specialization"] = true,
		["Daggers"] = true,
		["Dampen Magic"] = true,
		["Dark Iron Bomb"] = true,
		["Dark Offering"] = true,
		["Dark Pact"] = true,
		["Darkness"] = true,
		["Dash"] = true,
		["Dazed"] = true,
		["Deadly Poison II"] = true,
		["Deadly Poison III"] = true,
		["Deadly Poison IV"] = true,
		["Deadly Poison V"] = true,
		["Deadly Poison"] = true,
		["Deadly Throw"] = true,
		["Death Coil"] = true,
		["Death Wish"] = true,
		["Deep Sleep"] = true,
		["Deep Slumber"] = true,
		["Deep Wounds"] = true,
		["Defense"] = true,
		["Defensive Stance Passive"] = true,
		["Defensive Stance"] = true,
		["Defensive State 2"] = true,
		["Defensive State"] = true,
		["Defiance"] = true,
		["Deflection"] = true,
		["Delusions of Jin'do"] = true,
		["Demon Armor"] = true,
		["Demon Skin"] = true,
		["Demonic Embrace"] = true,
		["Demonic Frenzy"] = true,
		["Demonic Sacrifice"] = true,
		["Demoralizing Roar"] = true,
		["Demoralizing Shout"] = true,
		["Dense Sharpening Stone"] = true,
		["Desperate Prayer"] = true,
		["Destructive Reach"] = true,
		["Detect Greater Invisibility"] = true,
		["Detect Invisibility"] = true,
		["Detect Lesser Invisibility"] = true,
		["Detect Magic"] = true,
		["Detect Traps"] = true,
		["Detect"] = true,
		["Deterrence"] = true,
		["Detonation"] = true,
		["Devastate"] = true,
		["Devastation"] = true,
		["Devotion Aura"] = true,
		["Devour Magic Effect"] = true,
		["Devour Magic"] = true,
		["Devouring Plague"] = true,
		["Diamond Flask"] = true,
		["Diplomacy"] = true,
		["Dire Bear Form"] = true,
		["Dire Growl"] = true,
		["Disarm Trap"] = true,
		["Disarm"] = true,
		["Disease Cleansing Totem"] = true,
		["Disease Cloud"] = true,
		["Diseased Shot"] = true,
		["Diseased Spit"] = true,
		["Disenchant"] = true,
		["Disengage"] = true,
		["Disjunction"] = true,
		["Dismiss Pet"] = true,
		["Dispel Magic"] = true,
		["Distract"] = true,
		["Distracting Pain"] = true,
		["Distracting Shot"] = true,
		["Dive"] = true,
		["Divine Favor"] = true,
		["Divine Fury"] = true,
		["Divine Illumination"] = true,
		["Divine Intellect"] = true,
		["Divine Intervention"] = true,
		["Divine Protection"] = true,
		["Divine Shield"] = true,
		["Divine Spirit"] = true,
		["Divine Strength"] = true,
		["Diving Sweep"] = true,
		["Dodge"] = true,
		["Dominate Mind"] = true,
		["Dragon's Breath"] = true,
		["Dragonscale Leatherworking"] = true,
		["Drain Life"] = true,
		["Drain Mana"] = true,
		["Drain Soul"] = true,
		["Dredge Sickness"] = true,
		["Drink"] = true,
		["Druid's Slumber"] = true,
		["Dual Wield Specialization"] = true,
		["Dual Wield"] = true,
		["Duel"] = true,
		["Dust Field"] = true,
		["Eagle Eye"] = true,
		["Earth Elemental Totem"] = true,
		["Earth Shield"] = true,
		["Earth Shock"] = true,
		["Earthbind Totem"] = true,
		["Earthborer Acid"] = true,
		["Earthgrab"] = true,
		["Efficiency"] = true,
		["Electric Discharge"] = true,
		["Electrified Net"] = true,
		["Elemental Focus"] = true,
		["Elemental Fury"] = true,
		["Elemental Leatherworking"] = true,
		["Elemental Mastery"] = true,
		["Elemental Precision"] = true,
		["Elemental Sharpening Stone"] = true,
		["Elune's Grace"] = true,
		["Elusiveness"] = true,
		["Emberstorm"] = true,
		["Enamored Water Spirit"] = true,
		["Enchanting"] = true,
		["Endurance Training"] = true,
		["Endurance"] = true,
		["Engineering Specialization"] = true,
		["Engineering"] = true,
		["Enrage"] = true,
		["Enriched Manna Biscuit"] = true,
		["Enslave Demon"] = true,
		["Entangling Roots"] = true,
		["Entrapment"] = true,
		["Enveloping Web"] = true,
		["Enveloping Webs"] = true,
		["Enveloping Winds"] = true,
		["Envenom"] = true,
		["Ephemeral Power"]=true,
		["Escape Artist"] = true,
		["Essence of Sapphiron"]=true,
		["Evasion"] = true,
		["Eventide"] = true,
		["Eviscerate"] = true,
		["Evocation"] = true,
		["Execute"] = true,
		["Exorcism"] = true,
		["Expansive Mind"] = true,
		["Exploding Shot"] = true,
		["Exploit Weakness"] = true,
		["Explosive Shot"] = true,
		["Explosive Trap Effect"] = true,
		["Explosive Trap"] = true,
		["Expose Armor"] = true,
		["Expose Weakness"] = true,
		["Eye for an Eye"] = true,
		["Eye of Kilrogg"] = true,
		["Eyes of the Beast"] = true,
		["Fade"] = true,
		["Faerie Fire (Feral)"] = true,
		["Faerie Fire"] = true,
		["Far Sight"] = true,
		["Fatal Bite"] = true,
		["Fear Ward"] = true,
		["Fear"] = true,
		["Feed Pet"] = true,
		["Feedback"] = true,
		["Feign Death"] = true,
		["Feint"] = true,
		["Fel Armor"] = true,
		["Fel Concentration"] = true,
		["Fel Domination"] = true,
		["Fel Intellect"] = true,
		["Fel Stamina"] = true,
		["Fel Stomp"] = true,
		["Felfire"] = true,
		["Feline Grace"] = true,
		["Feline Swiftness"] = true,
		["Feral Aggression"] = true,
		["Feral Charge"] = true,
		["Feral Instinct"] = true,
		["Ferocious Bite"] = true,
		["Ferocity"] = true,
		["Fetish"] = true,
		["Fevered Plague"] = true,
		["Fiery Burst"] = true,
		["Find Herbs"] = true,
		["Find Minerals"] = true,
		["Find Treasure"] = true,
		["Fire Blast"] = true,
		["Fire Elemental Totem"] = true,
		["Fire Nova Totem"] = true,
		["Fire Nova"] = true,
		["Fire Power"] = true,
		["Fire Resistance Aura"] = true,
		["Fire Resistance Totem"] = true,
		["Fire Resistance"] = true,
		["Fire Shield Effect II"] = true,
		["Fire Shield Effect III"] = true,
		["Fire Shield Effect IV"] = true,
		["Fire Shield Effect"] = true,
		["Fire Shield"] = true,
		["Fire Storm"] = true,
		["Fire Vulnerability"] = true,
		["Fire Ward"] = true,
		["Fire Weakness"] = true,
		["Fireball Volley"] = true,
		["Fireball"] = true,
		["Firebolt"] = true,
		["First Aid"] = true,
		["Fishing Poles"] = true,
		["Fishing"] = true,
		["Fist of Ragnaros"] = true,
		["Fist Weapon Specialization"] = true,
		["Fist Weapons"] = true,
		["Flame Buffet"] = true,
		["Flame Cannon"] = true,
		["Flame Lash"] = true,
		["Flame Shock"] = true,
		["Flame Spike"] = true,
		["Flame Spray"] = true,
		["Flame Throwing"] = true,
		["Flames of Shahram"] = true,
		["Flamestrike"] = true,
		["Flamethrower"] = true,
		["Flametongue Totem"] = true,
		["Flametongue Weapon"] = true,
		["Flare"] = true,
		["Flash Bomb"] = true,
		["Flash Heal"] = true,
		["Flash of Light"] = true,
		["Flight Form"] = true,
		["Flurry"] = true,
		["Focused Casting"] = true,
		["Focused Mind"] = true,
		["Food"] = true,
		["Forbearance"] = true,
		["Force of Nature"] = true,
		["Force of Will"] = true,
		["Force Punch"] = true,
		["Force Reactive Disk"] = true,
		["Forked Lightning"] = true,
		["Forsaken Skills"] = true,
		["Frailty"] = true,
		["Freeze Solid"] = true,
		["Freezing Trap Effect"] = true,
		["Freezing Trap"] = true,
		["Frenzied Regeneration"] = true,
		["Frenzy"] = true,
		["Frost Armor"] = true,
		["Frost Breath"] = true,
		["Frost Channeling"] = true,
		["Frost Nova"] = true,
		["Frost Resistance Aura"] = true,
		["Frost Resistance Totem"] = true,
		["Frost Resistance"] = true,
		["Frost Shock"] = true,
		["Frost Shot"] = true,
		["Frost Trap Aura"] = true,
		["Frost Trap"] = true,
		["Frost Ward"] = true,
		["Frost Warding"] = true,
		["Frost Weakness"] = true,
		["Frostbite"] = true,
		["Frostbolt Volley"] = true,
		["Frostbolt"] = true,
		["Frostbrand Weapon"] = true,
		["Furious Howl"] = true,
		["Furor"] = true,
		["Fury of Ragnaros"] = true,
		["Gahz'ranka Slam"] = true,
		["Gahz'rilla Slam"] = true,
		["Garrote"] = true,
		["Gehennas' Curse"]=true,
		["Generic"] = true,
		["Ghost Wolf"] = true,
		["Ghostly Strike"] = true,
		["Gift of Life"] = true,
		["Gift of Nature"] = true,
		["Gift of the Wild"] = true,
		["Goblin Dragon Gun"] = true,
		["Goblin Sapper Charge"] = true,
		["Gouge"] = true,
		["Grace of Air Totem"] = true,
		["Grasping Vines"] = true,
		["Great Stamina"] = true,
		["Greater Blessing of Kings"] = true,
		["Greater Blessing of Light"] = true,
		["Greater Blessing of Might"] = true,
		["Greater Blessing of Salvation"] = true,
		["Greater Blessing of Sanctuary"] = true,
		["Greater Blessing of Wisdom"] = true,
		["Greater Heal"] = true,
		["Grim Reach"] = true,
		["Ground Tremor"] = true,
		["Grounding Totem"] = true,
		["Grovel"] = true,
		["Growl"] = true,
		["Guardian's Favor"] = true,
		["Guillotine"] = true,
		["Gun Specialization"] = true,
		["Guns"] = true,
		["Hail Storm"] = true,
		["Hammer of Justice"] = true,
		["Hammer of Wrath"] = true,
		["Hamstring"] = true,
		["Harass"] = true,
		["Hardiness"] = true,
		["Haunting Spirits"] = true,
		["Hawk Eye"] = true,
		["Head Crack"] = true,
		["Heal"] = true,
		["Healing Circle"] = true,
		["Healing Focus"] = true,
		["Healing Light"] = true,
		["Healing of the Ages"]=true,
		["Healing Stream Totem"] = true,
		["Healing Touch"] = true,
		["Healing Wave"] = true,
		["Healing Way"] = true,
		["Health Funnel"] = true,
		["Heart of the Wild"] = true,
		["Heavy Sharpening Stone"] = true,
		["Hellfire Effect"] = true,
		["Hellfire"] = true,
		["Hemorrhage"] = true,
		["Herb Gathering"] = true,
		["Herbalism"] = true,
		["Heroic Strike"] = true,
		["Heroism"] = true,
		["Hex of Jammal'an"] = true,
		["Hex of Weakness"] = true,
		["Hex"] = true,
		["Hibernate"] = true,
		["Holy Fire"] = true,
		["Holy Light"] = true,
		["Holy Nova"] = true,
		["Holy Power"] = true,
		["Holy Reach"] = true,
		["Holy Shield"] = true,
		["Holy Shock"] = true,
		["Holy Smite"] = true,
		["Holy Specialization"] = true,
		["Holy Strength"] = true,
		["Holy Strike"] = true,
		["Holy Wrath"] = true,
		["Honorless Target"] = true,
		["Hooked Net"] = true,
		["Horse Riding"] = true,
		["Howl of Terror"] = true,
		["Humanoid Slaying"] = true,
		["Hunter's Mark"] = true,
		["Hurricane"] = true,
		["Ice Armor"] = true,
		["Ice Barrier"] = true,
		["Ice Blast"] = true,
		["Ice Block"] = true,
		["Ice Lance"] = true,
		["Ice Nova"] = true,
		["Ice Shards"] = true,
		["Icicle"] = true,
		["Ignite"] = true,
		["Illumination"] = true,
		["Immolate"] = true,
		["Immolation Trap Effect"] = true,
		["Immolation Trap"] = true,
		["Impact"] = true,
		["Impale"] = true,
		["Improved Ambush"] = true,
		["Improved Arcane Explosion"] = true,
		["Improved Arcane Missiles"] = true,
		["Improved Arcane Shot"] = true,
		["Improved Aspect of the Hawk"] = true,
		["Improved Aspect of the Monkey"] = true,
		["Improved Backstab"] = true,
		["Improved Battle Shout"] = true,
		["Improved Berserker Rage"] = true,
		["Improved Blessing of Might"] = true,
		["Improved Blessing of Wisdom"] = true,
		["Improved Blizzard"] = true,
		["Improved Bloodrage"] = true,
		["Improved Chain Heal"] = true,
		["Improved Chain Lightning"] = true,
		["Improved Challenging Shout"] = true,
		["Improved Charge"] = true,
		["Improved Cheap Shot"] = true,
		["Improved Cleave"] = true,
		["Improved Concentration Aura"] = true,
		["Improved Concussive Shot"] = true,
		["Improved Cone of Cold"] = true,
		["Improved Corruption"] = true,
		["Improved Counterspell"] = true,
		["Improved Curse of Agony"] = true,
		["Improved Curse of Exhaustion"] = true,
		["Improved Curse of Weakness"] = true,
		["Improved Dampen Magic"] = true,
		["Improved Deadly Poison"] = true,
		["Improved Demoralizing Shout"] = true,
		["Improved Devotion Aura"] = true,
		["Improved Disarm"] = true,
		["Improved Distract"] = true,
		["Improved Drain Life"] = true,
		["Improved Drain Mana"] = true,
		["Improved Drain Soul"] = true,
		["Improved Enrage"] = true,
		["Improved Enslave Demon"] = true,
		["Improved Entangling Roots"] = true,
		["Improved Evasion"] = true,
		["Improved Eviscerate"] = true,
		["Improved Execute"] = true,
		["Improved Expose Armor"] = true,
		["Improved Eyes of the Beast"] = true,
		["Improved Fade"] = true,
		["Improved Feign Death"] = true,
		["Improved Fire Blast"] = true,
		["Improved Fire Nova Totem"] = true,
		["Improved Fire Ward"] = true,
		["Improved Fireball"] = true,
		["Improved Firebolt"] = true,
		["Improved Firestone"] = true,
		["Improved Flamestrike"] = true,
		["Improved Flametongue Weapon"] = true,
		["Improved Flash of Light"] = true,
		["Improved Frost Nova"] = true,
		["Improved Frost Ward"] = true,
		["Improved Frostbolt"] = true,
		["Improved Frostbrand Weapon"] = true,
		["Improved Garrote"] = true,
		["Improved Ghost Wolf"] = true,
		["Improved Gouge"] = true,
		["Improved Grace of Air Totem"] = true,
		["Improved Grounding Totem"] = true,
		["Improved Hammer of Justice"] = true,
		["Improved Hamstring"] = true,
		["Improved Healing Stream Totem"] = true,
		["Improved Healing Touch"] = true,
		["Improved Healing Wave"] = true,
		["Improved Healing"] = true,
		["Improved Health Funnel"] = true,
		["Improved Healthstone"] = true,
		["Improved Heroic Strike"] = true,
		["Improved Hunter's Mark"] = true,
		["Improved Immolate"] = true,
		["Improved Imp"] = true,
		["Improved Inner Fire"] = true,
		["Improved Instant Poison"] = true,
		["Improved Intercept"] = true,
		["Improved Intimidating Shout"] = true,
		["Improved Judgement"] = true,
		["Improved Kick"] = true,
		["Improved Kidney Shot"] = true,
		["Improved Lash of Pain"] = true,
		["Improved Lay on Hands"] = true,
		["Improved Lesser Healing Wave"] = true,
		["Improved Life Tap"] = true,
		["Improved Lightning Bolt"] = true,
		["Improved Lightning Shield"] = true,
		["Improved Magma Totem"] = true,
		["Improved Mana Burn"] = true,
		["Improved Mana Shield"] = true,
		["Improved Mana Spring Totem"] = true,
		["Improved Mark of the Wild"] = true,
		["Improved Mend Pet"] = true,
		["Improved Mind Blast"] = true,
		["Improved Moonfire"] = true,
		["Improved Nature's Grasp"] = true,
		["Improved Overpower"] = true,
		["Improved Power Word: Fortitude"] = true,
		["Improved Power Word: Shield"] = true,
		["Improved Prayer of Healing"] = true,
		["Improved Psychic Scream"] = true,
		["Improved Pummel"] = true,
		["Improved Regrowth"] = true,
		["Improved Reincarnation"] = true,
		["Improved Rejuvenation"] = true,
		["Improved Rend"] = true,
		["Improved Renew"] = true,
		["Improved Retribution Aura"] = true,
		["Improved Revenge"] = true,
		["Improved Revive Pet"] = true,
		["Improved Righteous Fury"] = true,
		["Improved Rockbiter Weapon"] = true,
		["Improved Rupture"] = true,
		["Improved Sap"] = true,
		["Improved Scorch"] = true,
		["Improved Scorpid Sting"] = true,
		["Improved Seal of Righteousness"] = true,
		["Improved Seal of the Crusader"] = true,
		["Improved Searing Pain"] = true,
		["Improved Searing Totem"] = true,
		["Improved Serpent Sting"] = true,
		["Improved Shadow Bolt"] = true,
		["Improved Shadow Word: Pain"] = true,
		["Improved Shield Bash"] = true,
		["Improved Shield Block"] = true,
		["Improved Shield Wall"] = true,
		["Improved Shred"] = true,
		["Improved Sinister Strike"] = true,
		["Improved Slam"] = true,
		["Improved Slice and Dice"] = true,
		["Improved Spellstone"] = true,
		["Improved Sprint"] = true,
		["Improved Starfire"] = true,
		["Improved Stoneclaw Totem"] = true,
		["Improved Stoneskin Totem"] = true,
		["Improved Strength of Earth Totem"] = true,
		["Improved Succubus"] = true,
		["Improved Sunder Armor"] = true,
		["Improved Taunt"] = true,
		["Improved Thorns"] = true,
		["Improved Thunder Clap"] = true,
		["Improved Tranquility"] = true,
		["Improved Vampiric Embrace"] = true,
		["Improved Vanish"] = true,
		["Improved Voidwalker"] = true,
		["Improved Windfury Weapon"] = true,
		["Improved Wing Clip"] = true,
		["Improved Wrath"] = true,
		["Incinerate"] = true,
		["Infected Bite"] = true,
		["Infected Wound"] = true,
		["Inferno Shell"] = true,
		["Inferno"] = true,
		["Initiative"] = true,
		["Inner Fire"] = true,
		["Inner Focus"] = true,
		["Innervate"] = true,
		["Insect Swarm"] = true,
		["Inspiration"] = true,
		["Instant Poison II"] = true,
		["Instant Poison III"] = true,
		["Instant Poison IV"] = true,
		["Instant Poison V"] = true,
		["Instant Poison VI"] = true,
		["Instant Poison"] = true,
		["Intensity"] = true,
		["Intercept Stun"] = true,
		["Intercept"] = true,
		["Intervene"] = true,
		["Intimidating Roar"] = true,
		["Intimidating Shout"] = true,
		["Intimidation"] = true,
		["Intoxicating Venom"] = true,
		["Invisibility"] = true,
		["Iron Will"] = true,
		["Jewelcrafting"] = true,
		["Judgement of Command"] = true,
		["Judgement of Justice"] = true,
		["Judgement of Light"] = true,
		["Judgement of Righteousness"] = true,
		["Judgement of the Crusader"] = true,
		["Judgement of Wisdom"] = true,
		["Judgement"] = true,
		["Kick - Silenced"] = true,
		["Kick"] = true,
		["Kidney Shot"] = true,
		["Kill Command"] = true,
		["Killer Instinct"] = true,
		["Knock Away"] = true,
		["Knockdown"] = true,
		["Kodo Riding"] = true,
		["Lacerate"] =  true,
		["Lacerate"] = true,
		["Larva Goo"] = true,
		["Lash of Pain"] = true,
		["Lash"] = true,
		["Last Stand"] = true,
		["Lasting Judgement"] = true,
		["Lava Spout Totem"] = true,
		["Lay on Hands"] = true,
		["Leader of the Pack"] = true,
		["Leather"] = true,
		["Leatherworking"] = true,
		["Leech Poison"] = true,
		["Lesser Heal"] = true,
		["Lesser Healing Wave"] = true,
		["Lesser Invisibility"] = true,
		["Lethal Shots"] = true,
		["Lethality"] = true,
		["Levitate"] = true,
		["Libram"] = true,
		["Lich Slap"] = true,
		["Life Tap"] = true,
		["Lifebloom"] = true,
		["Lifegiving Gem"] = true,
		["Lightning Blast"] = true,
		["Lightning Bolt"] = true,
		["Lightning Breath"] = true,
		["Lightning Cloud"] = true,
		["Lightning Mastery"] = true,
		["Lightning Reflexes"] = true,
		["Lightning Shield"] = true,
		["Lightning Wave"] = true,
		["Lightwell Renew"] = true,
		["Lightwell"] = true,
		["Lizard Bolt"] = true,
		["Localized Toxin"] = true,
		["Lockpicking"] = true,
		["Long Daze"] = true,
		["Mace Specialization"] = true,
		["Mace Stun Effect"] = true,
		["Machine Gun"] = true,
		["Mage Armor"] = true,
		["Magic Attunement"] = true,
		["Magma Splash"] = true,
		["Magma Totem"] = true,
		["Mail"] = true,
		["Maim"] = true,
		["Malice"] = true,
		["Mana Burn"] = true,
		["Mana Feed"] = true,
		["Mana Shield"] = true,
		["Mana Spring Totem"] = true,
		["Mana Tide Totem"] = true,
		["Mangle (Bear)"] = true,
		["Mangle (Cat)"] = true,
		["Mangle"] = true,
		["Mark of Arlokk"] = true,
		["Mark of the Wild"] = true,
		["Martyrdom"] = true,
		["Mass Dispel"] = true,
		["Master Demonologist"] = true,
		["Master of Deception"] = true,
		["Master of Elements"] = true,
		["Master Summoner"] = true,
		["Maul"] = true,
		["Mechanostrider Piloting"] = true,
		["Meditation"] = true,
		["Megavolt"] = true,
		["Melee Specialization"] = true,
		["Melt Ore"] = true,
		["Mend Pet"] = true,
		["Mental Agility"] = true,
		["Mental Strength"] = true,
		["Mighty Blow"] = true,
		["Mind Blast"] = true,
		["Mind Control"] = true,
		["Mind Flay"] = true,
		["Mind Soothe"] = true,
		["Mind Tremor"] = true,
		["Mind Vision"] = true,
		["Mind-numbing Poison II"] = true,
		["Mind-numbing Poison III"] = true,
		["Mind-numbing Poison"] = true,
		["Mining"] = true,
		["Misdirection"] = true,
		["Mocking Blow"] = true,
		["Molten Armor"] = true,
		["Molten Blast"] = true,
		["Molten Metal"] = true,
		["Mongoose Bite"] = true,
		["Monster Slaying"] = true,
		["Moonfire"] = true,
		["Moonfury"] = true,
		["Moonglow"] = true,
		["Moonkin Aura"] = true,
		["Moonkin Form"] = true,
		["Mortal Cleave"] = true,
		["Mortal Shots"] = true,
		["Mortal Strike"] = true,
		["Mortal Wound"]=true,
		["Multi-Shot"] = true,
		["Murder"] = true,
		["Mutilate"] = true,
		["Naralex's Nightmare"] = true,
		["Natural Armor"] = true,
		["Natural Shapeshifter"] = true,
		["Natural Weapons"] = true,
		["Nature Aligned"] = true,
		["Nature Resistance Totem"] = true,
		["Nature Resistance"] = true,
		["Nature Weakness"] = true,
		["Nature's Focus"] = true,
		["Nature's Grace"] = true,
		["Nature's Grasp"] = true,
		["Nature's Reach"] = true,
		["Nature's Swiftness"] = true,
		["Necrotic Poison"]=true,
		["Negative Charge"] = true,
		["Net"] = true,
		["Nightfall"] = true,
		["Noxious Catalyst"] = true,
		["Noxious Cloud"] = true,
		["Omen of Clarity"] = true,
		["One-Handed Axes"] = true,
		["One-Handed Maces"] = true,
		["One-Handed Swords"] = true,
		["One-Handed Weapon Specialization"] = true,
		["Opening - No Text"] = true,
		["Opening"] = true,
		["Opportunity"] = true,
		["Overpower"] = true,
		["Pacify"] = true,
		["Pain Suppression"] = true,
		["Paralyzing Poison"] = true,
		["Paranoia"] = true,
		["Parasitic Serpent"] = true,
		["Parry"] = true,
		["Pathfinding"] = true,
		["Perception"] = true,
		["Permafrost"] = true,
		["Pet Aggression"] = true,
		["Pet Hardiness"] = true,
		["Pet Recovery"] = true,
		["Pet Resistance"] = true,
		["Petrify"] = true,
		["Phase Shift"] = true,
		["Pick Lock"] = true,
		["Pick Pocket"] = true,
		["Pierce Armor"] = true,
		["Piercing Howl"] = true,
		["Piercing Ice"] = true,
		["Piercing Shadow"] = true,
		["Piercing Shot"] = true,
		["Plague Cloud"] = true,
		["Plate Mail"] = true,
		["Poison Bolt Volley"] = true,
		["Poison Bolt"] = true,
		["Poison Cleansing Totem"] = true,
		["Poison Cloud"] = true,
		["Poison Shock"] = true,
		["Poison"] = true,
		["Poisoned Harpoon"] = true,
		["Poisoned Shot"] = true,
		["Poisonous Blood"] = true,
		["Poisons"] = true,
		["Polearm Specialization"] = true,
		["Polearms"] = true,
		["Polymorph"] = true,
		["Polymorph: Pig"] = true, 
		["Polymorph: Turtle"] = true,
		["Portal: Darnassus"] = true,
		["Portal: Ironforge"] = true,
		["Portal: Orgrimmar"] = true,
		["Portal: Stormwind"] = true,
		["Portal: Thunder Bluff"] = true,
		["Portal: Undercity"] = true,
		["Positive Charge"] = true,
		["Pounce Bleed"] = true,
		["Pounce"] = true,
		["Power Infusion"] = true,
		["Power Word: Fortitude"] = true,
		["Power Word: Shield"] = true,
		["Prayer Beads Blessing"]=true,
		["Prayer of Fortitude"] = true,
		["Prayer of Healing"] = true,
		["Prayer of Mending"] = true,
		["Prayer of Shadow Protection"] = true,
		["Prayer of Spirit"] = true,
		["Precision"] = true,
		["Predatory Strikes"] = true,
		["Premeditation"] = true,
		["Preparation"] = true,
		["Presence of Mind"] = true,
		["Primal Fury"] = true,
		["Prowl"] = true,
		["Psychic Scream"] = true,
		["Pummel"] = true,
		["Puncture"] = true,
		["Purge"] = true,
		["Purification"] = true,
		["Purify"] = true,
		["Pursuit of Justice"] = true,
		["Putrid Breath"] = true,
		["Putrid Enzyme"] = true,
		["Pyroblast"] = true,
		["Pyroclasm"] = true,
		["Quick Shots"] = true,
		["Quickness"] = true,
		["Radiation Bolt"] = true,
		["Radiation Cloud"] = true,
		["Radiation Poisoning"] = true,
		["Radiation"] = true,
		["Rain of Fire"] = true,
		["Rake"] = true,
		["Ram Riding"] = true,
		["Rampage"] = true,
		["Ranged Weapon Specialization"] = true,
		["Rapid Concealment"] = true,
		["Rapid Fire"] = true,
		["Raptor Riding"] = true,
		["Raptor Strike"] = true,
		["Ravage"] = true,
		["Ravenous Claw"] = true,
		["Readiness"] = true,
		["Rebirth"] = true,
		["Rebuild"] = true,
		["Recently Bandaged"] = true,
		["Reckless Charge"] = true,
		["Recklessness"] = true,
		["Reckoning"] = true,
		["Recombobulate"] = true,
		["Redemption"] = true,
		["Redoubt"] = true,
		["Reflection"] = true,
		["Regeneration"] = true,
		["Regrowth"] = true,
		["Reincarnation"] = true,
		["Rejuvenation"] = true,
		["Relentless Strikes"] = true,
		["Remorseless Attacks"] = true,
		["Remorseless"] = true,
		["Remove Curse"] = true,
		["Remove Insignia"] = true,
		["Remove Lesser Curse"] = true,
		["Rend"] = true,
		["Renew"] = true,
		["Repentance"] = true,
		["Repulsive Gaze"] = true,
		["Restorative Totems"] = true,
		["Resurrection"] = true,
		["Retaliation"] = true,
		["Retribution Aura"] = true,
		["Revenge Stun"] = true,
		["Revenge"] = true,
		["Reverberation"] = true,
		["Revive Pet"] = true,
		["Rhahk'Zor Slam"] = true,
		["Ribbon of Souls"] = true,
		["Righteous Defense"] = true,
		["Righteous Fury"] = true,
		["Rip"] = true,
		["Riposte"] = true,
		["Ritual of Doom Effect"] = true,
		["Ritual of Doom"] = true,
		["Ritual of Souls"] = true,
		["Ritual of Summoning"] = true,
		["Rockbiter Weapon"] = true,
		["Rogue Passive"] = true,
		["Rough Sharpening Stone"] = true,
		["Ruin"] = true,
		["Rupture"] = true,
		["Ruthlessness"] = true,
		["Sacrifice"] = true,
		["Safe Fall"] = true,
		["Sanctity Aura"] = true,
		["Sap"] = true,
		["Savage Fury"] = true,
		["Savage Strikes"] = true,
		["Scare Beast"] = true,
		["Scatter Shot"] = true,
		["Scorch"] = true,
		["Scorpid Poison"] = true,
		["Scorpid Sting"] = true,
		["Screams of the Past"] = true,
		["Screech"] = true,
		["Seal Fate"] = true,
		["Seal of Blood"] = true,
		["Seal of Command"] = true,
		["Seal of Justice"] = true,
		["Seal of Light"] = true,
		["Seal of Reckoning"] = true,
		["Seal of Righteousness"] = true,
		["Seal of the Crusader"] = true,
		["Seal of Vengeance"] = true,
		["Seal of Wisdom"] = true,
		["Searing Light"] = true,
		["Searing Pain"] = true,
		["Searing Totem"] = true,
		["Second Wind"] = true,
		["Seduction"] = true,
		["Seed of Corruption"] = true,
		["Sense Demons"] = true,
		["Sense Undead"] = true,
		["Sentry Totem"] = true,
		["Serpent Sting"] = true,
		["Setup"] = true,
		["Shackle Undead"] = true,
		["Shadow Affinity"] = true,
		["Shadow Bolt Volley"] = true,
		["Shadow Bolt"] = true,
		["Shadow Focus"] = true,
		["Shadow Mastery"] = true,
		["Shadow Protection"] = true,
		["Shadow Reach"] = true,
		["Shadow Resistance Aura"] = true,
		["Shadow Resistance"] = true,
		["Shadow Shock"] = true,
		["Shadow Trance"] = true,
		["Shadow Vulnerability"] = true,
		["Shadow Ward"] = true,
		["Shadow Weakness"] = true,
		["Shadow Weaving"] = true,
		["Shadow Word: Death"] = true,
		["Shadow Word: Pain"] = true,
		["Shadowburn"] = true,
		["Shadowfiend"] = true,
		["Shadowform"] = true,
		["Shadowfury"] = true,
		["Shadowguard"] = true,
		["Shadowmeld Passive"] = true,
		["Shadowmeld"] = true,
		["Shadowstep"] = true,
		["Shamanistic Rage"] = true,
		["Sharpened Claws"] = true,
		["Shatter"] = true,
		["Sheep"] = true,
		["Shell Shield"] = true,
		["Shield Bash - Silenced"] = true,
		["Shield Bash"] = true,
		["Shield Block"] = true,
		["Shield Slam"] = true,
		["Shield Specialization"] = true,
		["Shield Wall"] = true,
		["Shield"] = true,
		["Shiv"] = true,
		["Shock"] = true,
		["Shoot Bow"] = true,
		["Shoot Crossbow"] = true,
		["Shoot Gun"] = true,
		["Shoot"] = true,
		["Shred"] = true,
		["Shrink"] = true,
		["Silence"] = true,
		["Silencing Shot"] = true,
		["Silent Resolve"] = true,
		["Sinister Strike"] = true,
		["Siphon Life"] = true,
		["Skinning"] = true,
		["Skull Crack"] = true,
		["Slam"] = true,
		["Sleep"] = true,
		["Slice and Dice"] = true,
		["Slow Fall"] = true,
		["Slow"] = true,
		["Slowing Poison"] = true,
		["Smelting"] = true,
		["Smite Slam"] = true,
		["Smite Stomp"] = true,
		["Smite"] = true,
		["Smoke Bomb"] = true,
		["Snake Trap"] = true,
		["Snap Kick"] = true,
		["Solid Sharpening Stone"] = true,
		["Sonic Burst"] = true,
		["Soothe Animal"] = true,
		["Soothing Kiss"] = true,
		["Soul Bite"] = true,
		["Soul Drain"] = true,
		["Soul Fire"] = true,
		["Soul Link"] = true,
		["Soul Siphon"] = true,
		["Soul Tap"] = true,
		["Soulshatter"] = true,
		["Soulstone Resurrection"] = true,
		["Spell Lock"] = true,
		["Spell Reflection"] = true,
		["Spell Warding"] = true,
		["Spellsteal"] = true,
		["Spirit Bond"] = true,
		["Spirit Burst"] = true,
		["Spirit of Redemption"] = true,
		["Spirit Tap"] = true,
		["Spiritual Attunement"] = true,
		["Spiritual Focus"] = true,
		["Spiritual Guidance"] = true,
		["Spiritual Healing"] = true,
		["Spit"] = true,
		["Spore Cloud"] = true,
		["Sprint"] = true,
		["Stance Mastery"] = true,
		["Starfire Stun"] = true,
		["Starfire"] = true,
		["Starshards"] = true,
		["Staves"] = true,
		["Steady Shot"] = true,
		["Stealth"] = true,
		["Stoneclaw Totem"] = true,
		["Stoneform"] = true,
		["Stoneskin Totem"] = true,
		["Stormstrike"] = true,
		["Strength of Earth Totem"] = true,
		["Strike"] = true,
		["Stuck"] = true,
		["Stun"] = true,
		["Subtlety"] = true,
		["Suffering"] = true,
		["Summon Charger"] = true,
		["Summon Dreadsteed"] = true,
		["Summon Felguard"] = true,
		["Summon Felhunter"] = true,
		["Summon Felsteed"] = true,
		["Summon Imp"] = true,
		["Summon Spawn of Bael'Gar"] = true,
		["Summon Succubus"] = true,
		["Summon Voidwalker"] = true,
		["Summon Warhorse"] = true,
		["Summon Water Elemental"] = true,
		["Sunder Armor"] = true,
		["Suppression"] = true,
		["Surefooted"] = true,
		["Survivalist"] = true,
		["Sweeping Slam"] = true,
		["Sweeping Strikes"] = true,
		["Swiftmend"] = true,
		["Swipe"] = true,
		["Swoop"] = true,
		["Sword Specialization"] = true,
		["Tactical Mastery"] = true,
		["Tailoring"] = true,
		["Tainted Blood"] = true,
		["Tame Beast"] = true,
		["Tamed Pet Passive"] = true,
		["Taunt"] = true,
		["Teleport: Darnassus"] = true,
		["Teleport: Ironforge"] = true,
		["Teleport: Moonglade"] = true,
		["Teleport: Orgrimmar"] = true,
		["Teleport: Stormwind"] = true,
		["Teleport: Thunder Bluff"] = true,
		["Teleport: Undercity"] = true,
		["Tendon Rip"] = true,
		["Tendon Slice"] = true,
		["Terrify"] = true,
		["Terrifying Screech"] = true,
		["The Beast Within"] = true,
		["The Eye of the Dead"]=true,
		["The Furious Storm"]=true,
		["The Human Spirit"] = true,
		["Thick Hide"] = true,
		["Thorn Volley"] = true,
		["Thorns"] = true,
		["Thousand Blades"] = true,
		["Threatening Gaze"] = true,
		["Throw Axe"] = true,
		["Throw Dynamite"] = true,
		["Throw Liquid Fire"] = true,
		["Throw Wrench"] = true,
		["Throw"] = true,
		["Throwing Specialization"] = true,
		["Throwing Weapon Specialization"] = true,
		["Thrown"] = true,
		["Thunder Clap"] = true,
		["Thunderclap"] = true,
		["Thunderfury"] = true,
		["Thundering Strikes"] = true,
		["Thundershock"] = true,
		["Thunderstomp"] = true,
		["Tidal Focus"] = true,
		["Tidal Mastery"] = true,
		["Tiger Riding"] = true,
		["Tiger's Fury"] = true,
		["Torment"] = true,
		["Totem of Wrath"] = true,
		["Totem"] = true,
		["Totemic Focus"] = true,
		["Touch of Weakness"] = true,
		["Toughness"] = true,
		["Toxic Saliva"] = true,
		["Toxic Spit"] = true,
		["Toxic Volley"] = true,
		["Traces of Silithyst"] = true,
		["Track Beasts"] = true,
		["Track Demons"] = true,
		["Track Dragonkin"] = true,
		["Track Elementals"] = true,
		["Track Giants"] = true,
		["Track Hidden"] = true,
		["Track Humanoids"] = true,
		["Track Undead"] = true,
		["Trample"] = true,
		["Tranquil Air Totem"] = true,
		["Tranquil Spirit"] = true,
		["Tranquility"] = true,
		["Tranquilizing Poison"] = true,
		["Tranquilizing Shot"] = true,
		["Trap Mastery"] = true,
		["Travel Form"] = true,
		["Tree of Life"] = true,
		["Tremor Totem"] = true,
		["Tribal Leatherworking"] = true,
		["Trueshot Aura"] = true,
		["Turn Undead"] = true,
		["Twisted Tranquility"] = true,
		["Two-Handed Axes and Maces"] = true,
		["Two-Handed Axes"] = true,
		["Two-Handed Maces"] = true,
		["Two-Handed Swords"] = true,
		["Two-Handed Weapon Specialization"] = true,
		["Unarmed"] = true,
		["Unbreakable Will"] = true,
		["Unbridled Wrath Effect"] = true,
		["Unbridled Wrath"] = true,
		["Undead Horsemanship"] = true,
		["Underwater Breathing"] = true,
		["Unending Breath"] = true,
		["Unholy Frenzy"] = true,
		["Unholy Power"] = true,
		["Unleashed Fury"] = true,
		["Unleashed Rage"] = true,
		["Unstable Affliction"] = true,
		["Unstable Concoction"] = true,
		["Unstable Power"]=true,
		["Unyielding Faith"] = true,
		["Uppercut"] = true,
		["Vampiric Embrace"] = true,
		["Vampiric Touch"] = true,
		["Vanish"] = true,
		["Vanished"] = true,
		["Veil of Shadow"] = true,
		["Vengeance"] = true,
		["Venom Spit"] = true,
		["Venom Sting"] = true,
		["Venomhide Poison"] = true,
		["Vicious Rend"] = true,
		["Victory Rush"] = true,
		["Vigor"] = true,
		["Vile Poisons"] = true,
		["Vindication"] = true,
		["Viper Sting"] = true,
		["Virulent Poison"] = true,
		["Void Bolt"] = true,
		["Volley"] = true,
		["Walking Bomb Effect"] = true,
		["Wand Specialization"] = true,
		["Wandering Plague"] = true,
		["Wands"] = true,
		["War Stomp"] = true,
		["Water Breathing"] = true,
		["Water Shield"] = true,
		["Water Walking"] = true,
		["Water"] = true,
		["Waterbolt"] =	true,
		["Wavering Will"] = true,
		["Weakened Soul"] = true,
		["Weaponsmith"] = true,
		["Web Explosion"] = true,
		["Web Spin"] = true,
		["Web Spray"] = true,
		["Web"] = true,
		["Whirling Barrage"] = true,
		["Whirling Trip"] = true,
		["Whirlwind"] = true,
		["Wide Slash"] = true,
		["Will of Hakkar"] = true,
		["Will of the Forsaken"] = true,
		["Windfury Totem"] = true,
		["Windfury Weapon"] = true,
		["Windsor's Frenzy"] = true,
		["Windwall Totem"] = true,
		["Wing Clip"] = true,
		["Wing Flap"] = true,
		["Winter's Chill"] = true,
		["Wisp Spirit"] = true,
		["Wolf Riding"] = true,
		["Wound Poison II"] = true,
		["Wound Poison III"] = true,
		["Wound Poison IV"] = true,
		["Wound Poison"] = true,
		["Wrath of Air Totem"] = true,
		["Wrath"] = true,
		["Wyvern Sting"] = true,
	}
end)

BabbleSpell:RegisterTranslations("ruRU", function()
	return {
		["Abolish Disease"] = "Устранение болезни",
		["Abolish Poison Effect"] = "Эффект устранения яда",
		["Abolish Poison"] = "Устранение яда",
		["Acid Breath"] = "Кислотное дыхание",
		["Acid of Hakkar"] = "Кислота Хаккара",
		["Acid Spit"] = "Кислотный плевок",
		["Acid Splash"] = "Всплеск кислоты",
		["Activate MG Turret"] = "Активация гномской турели",
		["Adrenaline Rush"] = "Выброс адреналина",
		["Aftermath"] = "Последствия",
		["Aggression"] = "Агрессивность",
		["Aimed Shot"] = "Прицельный выстрел",
		["Alchemy"] = "Алхимия",
		["Ambush"] = "Внезапный удар",
		["Amplify Curse"] = "Усиление проклятия",
		["Amplify Damage"] = "Усиленный урон",
		["Amplify Flames"] = "Усиленное пламя",
		["Amplify Magic"] = "Усиление магии",
		["Ancestral Fortitude"] = "Стойкость предков",
		["Ancestral Healing"] = "Исцеление предков",
		["Ancestral Knowledge"] = "Знания предков",
		["Ancestral Spirit"] = "Дух предков",
		["Anesthetic Poison"] = "Anesthetic Poison", -- old
		["Anger Management"] = "Управление злостью",
		["Anguish"] = "Anguish", -- old
		["Anticipation"] = "Предчувствие",
		["Aqua Jet"] = "Водные струи",
		["Aquatic Form"] = "Водный облик",
		["Arcane Blast"] = "Чародейская вспышка",
		["Arcane Bolt"] = "Чародейская стрела",
		["Arcane Brilliance"] = "Чародейская гениальность",
		["Arcane Concentration"] = "Чародейская сосредоточенность",
		["Arcane Explosion"] = "Чародейский взрыв",
		["Arcane Focus"] = "Средоточие чар",
		["Arcane Instability"] = "Магическая нестабильность",
		["Arcane Intellect"] = "Чародейский интеллект",
		["Arcane Meditation"] = "Чародейская медитация",
		["Arcane Mind"] = "Чародейский ум",
		["Arcane Missiles"] = "Чародейские стрелы",
		["Arcane Potency"] = "Чародейское могущество",
		["Arcane Power"] = "Мощь тайной магии",
		["Arcane Resistance"] = "Сопротивление тайной магии",
		["Arcane Shot"] = "Чародейский выстрел",
		["Arcane Subtlety"] = "Искусные чары",
		["Arcane Weakness"] = "Чародейская слабость",
		["Arcing Smash"] = "Удар по дуге",
		["Arctic Reach"] = "Предел льда",
		["Armorsmith"] = "Бронник",
		["Arugal's Curse"] = "Проклятие Аругала",
		["Arugal's Gift"] = "Дар Аругала",
		["Ascendance"] = "Господство",
		["Aspect of Arlokk"] = "Аспект Арлокк",
		["Aspect of Jeklik"] = "Аспект Джеклик",
		["Aspect of Mar'li"] = "Аспект Мар'ли",
		["Aspect of the Beast"] = "Дух зверя",
		["Aspect of the Cheetah"] = "Дух гепарда",
		["Aspect of the Hawk"] = "Дух ястреба",
		["Aspect of the Monkey"] = "Дух обезьяны",
		["Aspect of the Pack"] = "Дух стаи",
		["Aspect of the Viper"] = "Aspect of the Viper", -- old
		["Aspect of the Wild"] = "Дух дикой природы",
		["Aspect of Venoxis"] = "Аспект Веноксиса",
		["Astral Recall"] = "Астральное возвращение",
		["Attack"] = "Атака",
		["Attacking"] = "Нападение",
		["Aura of Command"] = "Аура повиновения",
		["Aural Shock"] = "Удар ауры",
		["Auto Shot"] = "Автоматическая стрельба",
		["Avenger's Shield"] = "Avenger's Shield", -- old
		["Avenging Wrath"] = "Avenging Wrath", -- old
		["Avoidance"] = "Избежание",
		["Avoidance"] = "Избежание", 
		["Axe Flurry"] = "Шквал топора",
		["Axe Specialization"] = "Специализация на владении топорами",
		["Axe Toss"] = "Метание топора",
		["Backlash"] = "Backlash", -- old
		["Backstab"] = "Удар в спину",
		["Bane"] = "Погибель",
		["Baneful Poison"] = "Гибельный яд",
		["Banish"] = "Изгнание",
		["Banshee Curse"] = "Проклятие банши",
		["Banshee Shriek"] = "Визг банши",
		["Barbed Sting"] = "Колючее жало",
		["Barkskin Effect"] = "Эффект дубовой кожи",
		["Barkskin"] = "Дубовая кожа",
		["Barrage"] = "Заградительный огонь",
		["Bash"] = "Оглушить",
		["Basic Campfire"] = "Обычный костер",
		["Battle Shout"] = "Боевой крик",
		["Battle Stance Passive"] = "Боевая стойка - постоянное действие",
		["Battle Stance"] = "Боевая стойка",
		["Bear Form"] = "Облик медведя",
		["Beast Lore"] = "Знание зверя",
		["Beast Slaying"] = "Убийство животных",
		["Beast Training"] = "Дрессировка",
		["Befuddlement"] = "Одурманивание",
		["Benediction"] = "Благодарение",
		["Berserker Charge"] = "Атака берсерка",
		["Berserker Rage"] = "Ярость берсерка",
		["Berserker Stance Passive"] = "Стойка берсерка - постоянное действие",
		["Berserker Stance"] = "Стойка берсерка",
		["Berserking"] = "Берсерк",
		["Bestial Discipline"] = "Беспрекословное послушание",
		["Bestial Swiftness"] = "Звериная стремительность",
		["Bestial Wrath"] = "Звериный гнев",
		["Biletoad Infection"] = "Зараза Желчной жабы",
		["Binding Heal"] = "Binding Heal", -- old
		["Bite"] = "Укус",
		["Black Arrow"] = "Черная стрела",
		["Blackout"] = "Затмение",
		["Blacksmithing"] = "Кузнечное дело",
		["Blade Flurry"] = "Шквал клинков",
		["Blast Wave"] = "Взрывная волна",
		["Blaze"] = "Пламень",
		["Blazing Speed"] = "Blazing Speed", -- old
		["Blessed Recovery"] = "Благословленное восстановление",
		["Blessing of Blackfathom"] = "Благословение Непроглядной Пучины",
		["Blessing of Freedom"] = "Благословение свободы",
		["Blessing of Kings"] = "Благословение королей",
		["Blessing of Light"] = "Благословение Света",
		["Blessing of Might"] = "Благословение могущества",
		["Blessing of Protection"] = "Благословение защиты",
		["Blessing of Sacrifice"] = "Благословение жертвенности",
		["Blessing of Salvation"] = "Благословение спасения",
		["Blessing of Sanctuary"] = "Благословение неприкосновенности",
		["Blessing of Shahram"] = "Благословение Шахрама",
		["Blessing of Wisdom"] = "Благословение мудрости",
		["Blind"] = "Ослепление",
		["Blinding Powder"] = "Ослепляющий порошек",
		["Blink"] = "Скачок",
		["Blizzard"] = "Снежная буря",
		["Block"] = "Блок",
		["Blood Craze"] = "Мания крови",
		["Blood Frenzy"] = "Кровавое бешенство",
		["Blood Funnel"] = "Кровавая воронка",
		["Blood Fury"] = "Кровавое неистовство",
		["Blood Leech"] = "Пиявка-кровосос",
		["Blood Pact"] = "Кровавый союз",
		["Blood Siphon"] = "Кровавый насос",
		["Blood Tap"] = "Кровоотвод",
		["Bloodlust"] = "Жажда крови", 
		["Bloodrage"] = "Кровавая ярость",
		["Bloodthirst"] = "Жажда крови",
		["Bomb"] = "Бомба",
		["Booming Voice"] = "Луженая глотка",
		["Boulder"] = "Валун",
		["Bow Specialization"] = "Специализация на владение луком",
		["Bows"] = "Луки",
		["Brain Wash"] = "Зомбирование",
		["Bright Campfire"] = "Яркий костер",
		["Brutal Impact"] = "Жестокий удар",
		["Burning Adrenaline"] = "Горящий адреналин",
		["Burning Soul"] = "Пылающая душа",
		["Burning Wish"] = "Горящее желание",
		["Butcher Drain"] = "Мясник-кровосос",
		["Call of Flame"] = "Зов пламени",
		["Call of the Grave"] = "Зов могилы",
		["Call of Thunder"] = "Зов грома",
		["Call Pet"] = "Призыв питомца",
		["Camouflage"] = "Камуфляж",
		["Cannibalize"] = "Каннибализм",
		["Cat Form"] = "Облик кошки",
		["Cataclysm"] = "Катаклизм",
		["Cause Insanity"] = "Насылание безумия",
		["Chain Bolt"] = "Цепной удар",
		["Chain Burn"] = "Цепной ожог",
		["Chain Heal"] = "Цепное исцеление", 
		["Chain Lightning"] = "Цепная молния",
		["Chained Bolt"] = "Звенья молний",
		["Chains of Ice"] = "Ледяные оковы",
		["Challenging Roar"] = "Вызывающий рев",
		["Challenging Shout"] = "Вызывающий крик",
		["Charge Rage Bonus Effect"] = "Ярость атаки - дополнительный положительный эффект",
		["Charge Stun"] = "Атака-оглушение",
		["Charge"] = "Рывок",
		["Cheap Shot"] = "Подлый трюк",
		["Chilled"] = "Окоченение",
		["Chilling Touch"] = "Леденящее прикосновение",
		["Chromatic Infusion"] = "Цветной настой",
		["Circle of Healing"] = "Circle of Healing", -- old
		["Claw"] = "Цапнуть",
		["Cleanse Nova"] = "Кольцо очищения",
		["Cleanse"] = "Очищение",
		["Clearcasting"] = "Ясность мысли",
		["Cleave"] = "Рассекающий удар",
		["Clever Traps"] = "Хитрые ловушки",
		["Cloak of Shadows"] = "Cloak of Shadows", -- old
		["Closing"] = "Закрытие",
		["Cloth"] = "Ткань",
		["Coarse Sharpening Stone"] = "Зернистое точило",
		["Cobra Reflexes"] = "Рефлексы кобры",
		["Cold Blood"] = "Хладнокровие",
		["Cold Snap"] = "Холодная хватка",
		["Combat Endurance"] = "Выносливость в бою",
		["Combustion"] = "Возгорание",
		["Command"] = "Властность",
		["Commanding Shout"] = "Командирский крик", 
		["Concentration Aura"] = "Аура сосредоточенности",
		["Concussion Blow"] = "Оглушающий удар",
		["Concussion"] = "Сотрясение мозга",
		["Concussive Shot"] = "Контузящий выстрел",
		["Cone of Cold"] = "Конус холода",
		["Conflagrate"] = "Поджигание",
		["Conjure Food"] = "Сотворение пищи",
		["Conjure Mana Agate"] = "Сотворение агата маны",
		["Conjure Mana Citrine"] = "Сотворение цитрина маны",
		["Conjure Mana Jade"] = "Сотворение нефрита маны",
		["Conjure Mana Ruby"] = "Сотворение рубина маны",
		["Conjure Water"] = "Сотворение воды",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone", -- old
		["Consecration"] = "Освящение",
		["Consume Magic"] = "Consume Magic", -- old
		["Consume Shadows"] = "Поглощение теней",
		["Consuming Shadows"] = "Поглощающие тени",
		["Convection"] = "Конвекция",
		["Conviction"] = "Приговор",
		["Cooking"] = "Кулинария",
		["Corrosive Acid Breath"] = "Дыхание разъедающей кислоты",
		["Corrosive Ooze"] = "Разъедающая слизь",
		["Corrosive Poison"] = "Разъедающий яд",
		["Corrupted Blood"] = "Порченая кровь",
		["Corruption"] = "Порча",
		["Counterattack"] = "Контратака",
		["Counterspell - Silenced"] = "Антимагия - немота",
		["Counterspell"] = "Антимагия",
		["Cower"] = "Попятиться",
		["Create Firestone (Greater)"] = "Создание камня огня (большого)",
		["Create Firestone (Lesser)"] = "Создание камня огня (малого)",
		["Create Firestone (Major)"] = "Создание камня огня (крупного)",
		["Create Firestone"] = "Создание камня огня",
		["Create Healthstone (Greater)"] = "Создание камня здоровья (большого)",
		["Create Healthstone (Lesser)"] = "Создание камня здоровья (малого)",
		["Create Healthstone (Major)"] = "Создание камня здоровья (крупного)",
		["Create Healthstone (Minor)"] = "Создание камня здоровья (крошечного)",
		["Create Healthstone"] = "Создание камня здоровья",
		["Create Soulstone (Greater)"] = "Создание камня души (большого)",
		["Create Soulstone (Lesser)"] = "Создание камня души (малого)",
		["Create Soulstone (Major)"] = "Создание камня души (крупного)",
		["Create Soulstone (Minor)"] = "Создание камня души (крошечного)",
		["Create Soulstone"] = "Создание камня души",
		["Create Spellstone (Greater)"] = "Создание камня чар (большого)",
		["Create Spellstone (Major)"] = "Создание камня чар (крупного)",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)", -- old
		["Create Spellstone"] = "Создание камня чар",
		["Creeper Venom"] = "Яд паучьего монстра",
		["Cripple"] = "Увечье",
		["Crippling Poison II"] = "Калечащий яд II",
		["Crippling Poison"] = "Калечащий яд",
		["Critical Mass"] = "Критическая масса",
		["Crossbows"] = "Арбалеты",
		["Crowd Pummel"] = "Раздача зуботычин",
		["Cruelty"] = "Безжалостность",
		["Crusader Aura"] = "Crusader Aura", -- old
		["Crusader Strike"] = "Удар воина Света",
		["Crusader's Wrath"] = "Гнев рыцаря Света",
		["Crystal Charge"] = "Обжигающий кристалл",
		["Crystal Force"] = "Кристалл силы духа",
		["Crystal Restore"] = "Кристалл восстановления",
		["Crystal Spire"] = "Кристальная спираль",
		["Crystal Ward"] = "Кристалл-хранитель",
		["Crystal Yield"] = "Кристалл-губитель",
		["Crystalline Slumber"] = "Хрустальный сон",
		["Cultivation"] = "Проращивание",
		["Cure Disease"] = "Излечение болезни",
		["Cure Poison"] = "Выведение яда",
		["Curse of Agony"] = "Проклятие агонии",
		["Curse of Blood"] = "Проклятие крови",
		["Curse of Doom Effect"] = "Проклятие рока - воздействие",
		["Curse of Doom"] = "Проклятие рока",
		["Curse of Exhaustion"] = "Проклятие изнеможения",
		["Curse of Idiocy"] = "Проклятие маразма",
		["Curse of Recklessness"] = "Проклятие безрассудства",
		["Curse of Shadow"] = "Проклятие Тьмы",
		["Curse of the Deadwood"] = "Проклятие Мертвого Леса",
		["Curse of the Elemental Lord"] = "Проклятие Повелителя элементалей",
		["Curse of the Elements"] = "Проклятие стихий",
		["Curse of Tongues"] = "Проклятие косноязычия",
		["Curse of Tuten'kash"] = "Проклятие Тутен'каш",
		["Curse of Weakness"] = "Проклятие слабости",
		["Cursed Blood"] = "Проклятая кровь",
		["Cyclone"] = "Циклон", 
		["Dagger Specialization"] = "Специализация на кинжалах",
		["Daggers"] = "Кинжалы",
		["Dampen Magic"] = "Ослабление магии",
		["Dark Iron Bomb"] = "Бомба из черного железа",
		["Dark Offering"] = "Темное приношение",
		["Dark Pact"] = "Темный союз",
		["Darkness"] = "Мрак",
		["Dash"] = "Порыв",
		["Dazed"] = "Головокружение",
		["Deadly Poison II"] = "Смертельный яд II",
		["Deadly Poison III"] = "Смертельный яд III",
		["Deadly Poison IV"] = "Смертельный яд IV",
		["Deadly Poison V"] = "Смертельный яд V",
		["Deadly Poison"] = "Смертельный яд",
		["Deadly Throw"] = "Deadly Throw", -- old
		["Death Coil"] = "Лик смерти",
		["Death Wish"] = "Жажда смерти",
		["Deep Sleep"] = "Глубокий сон",
		["Deep Slumber"] = "Глубокая дремота",
		["Deep Wounds"] = "Глубокие раны", 
		["Defense"] = "Защита",
		["Defensive Stance Passive"] = "Оборонительная стойка - пассивная",
		["Defensive Stance"] = "Оборонительная стойка",
		["Defensive State 2"] = "Состояние защиты 2",
		["Defensive State"] = "Оборонительная стойка",
		["Defiance"] = "Неукротимость",
		["Deflection"] = "Отражение",
		["Delusions of Jin'do"] = "Иллюзии Джин'до",
		["Demon Armor"] = "Демонический доспех",
		["Demon Skin"] = "Шкура демона",
		["Demonic Embrace"] = "Демоническое облачение",
		["Demonic Frenzy"] = "Демоническое бешенство",
		["Demonic Sacrifice"] = "Демоническое жертвоприношение",
		["Demoralizing Roar"] = "Устрашающий рев",
		["Demoralizing Shout"] = "Деморализующий крик",
		["Dense Sharpening Stone"] = "Массивное точило",
		["Desperate Prayer"] = "Молитва отчаяния",
		["Destructive Reach"] = "Предел разрушения",
		["Detect Greater Invisibility"] = "Обнаружение большой невидимости",
		["Detect Invisibility"] = "Обнаружение невидимости",
		["Detect Lesser Invisibility"] = "Обнаружение простой невидимости",
		["Detect Magic"] = "Распознавание магии",
		["Detect Traps"] = "Обнаружение ловушек",
		["Detect"] = "Обнаружение",
		["Deterrence"] = "Сдерживание",
		["Detonation"] = "Мгновенный взрыв",
		["Devastate"] = "Разрушение",
		["Devastation"] = "Опустошение",
		["Devotion Aura"] = "Аура благочестия",
		["Devour Magic Effect"] = "Поглощение магического эффекта",
		["Devour Magic"] = "Пожирание магии",
		["Devouring Plague"] = "Всепожирающая чума",
		["Diamond Flask"] = "Алмазный настой",
		["Diplomacy"] = "Дипломатия",
		["Dire Bear Form"] = "Облик лютого медведя",
		["Dire Growl"] = "Лютый рык",
		["Disarm Trap"] = "Обезвреживание ловушки",
		["Disarm"] = "Разоружение",
		["Disease Cleansing Totem"] = "Тотем очищения от болезней",
		["Disease Cloud"] = "Болезнетворное облако",
		["Diseased Shot"] = "Заразный выстрел",
		["Diseased Spit"] = "Болезнетворный плевок",
		["Disenchant"] = "Распыление",
		["Disengage"] = "Отрыв",
		["Disjunction"] = "Разъединение",
		["Dismiss Pet"] = "Прогнать питомца",
		["Dispel Magic"] = "Рассеивание заклинаний",
		["Distract"] = "Отвлечение",
		["Distracting Pain"] = "Отупляющая боль",
		["Distracting Shot"] = "Отвлекающий выстрел",
		["Dive"] = "Пикирование",
		["Divine Favor"] = "Божественное одобрение",
		["Divine Fury"] = "Божественное неистовство",
		["Divine Illumination"] = "Divine Illumination", -- old
		["Divine Intellect"] = "Божественный интеллект",
		["Divine Intervention"] = "Божественное вмешательство",
		["Divine Protection"] = "Божественная защита",
		["Divine Shield"] = "Божественный щит",
		["Divine Spirit"] = "Божественный дух",
		["Divine Strength"] = "Божественная сила",
		["Diving Sweep"] = "Глубокое сбивание",
		["Dodge"] = "Уклонение",
		["Dominate Mind"] = "Господство над разумом",
		["Dragon's Breath"] = "Dragon's Breath", -- old
		["Dragonscale Leatherworking"] = "Кожевничество: чешуя драконов",
		["Drain Life"] = "Похищение жизни",
		["Drain Mana"] = "Похищение маны",
		["Drain Soul"] = "Похищение души",
		["Dredge Sickness"] = "Илистая топь",
		["Drink"] = "Питье",
		["Druid's Slumber"] = "Друидская дремота",
		["Dual Wield Specialization"] = "Специализация на бое двумя оружиями",
		["Dual Wield"] = "Бой двумя оружиями",
		["Duel"] = "Дуэль",
		["Dust Field"] = "Пылевое поле",
		["Eagle Eye"] = "Орлиный глаз",
		["Earth Elemental Totem"] = "Earth Elemental Totem", -- old
		["Earth Shield"] = "Earth Shield", -- old
		["Earth Shock"] = "Земной шок",
		["Earthbind Totem"] = "Тотем оков земли",
		["Earthborer Acid"] = "Кислота землееда",
		["Earthgrab"] = "Хватка земли",
		["Efficiency"] = "Эффективность",
		["Electric Discharge"] = "Электрический разряд",
		["Electrified Net"] = "Электрическая сеть",
		["Elemental Focus"] = "Средоточие стихий",
		["Elemental Fury"] = "Неистовство стихий",
		["Elemental Leatherworking"] = "Кожевничество: сила стихий",
		["Elemental Mastery"] = "Покорение стихий",
		["Elemental Precision"] = "Точность",
		["Elemental Sharpening Stone"] = "Точило стихий",
		["Elune's Grace"] = "Благодать Элуны",
		["Elusiveness"] = "Неуловимость",
		["Emberstorm"] = "Бушующее пламя",
		["Enamored Water Spirit"] = "Enamored Water Spirit", -- old
		["Enchanting"] = "Наложение чар",
		["Endurance Training"] = "Тренировка стойкости",
		["Endurance"] = "Закалка",
		["Engineering Specialization"] = "Специализация на инженерном деле",
		["Engineering"] = "Инженерное дело",
		["Enrage"] = "Исступление",
		["Enriched Manna Biscuit"] = "Витаминизированное печенье из манны",
		["Enslave Demon"] = "Порабощение демона",
		["Entangling Roots"] = "Гнев деревьев",
		["Entrapment"] = "Удержание",
		["Enveloping Web"] = "Опутывающая сеть",
		["Enveloping Webs"] = "Опутывающие сети",
		["Enveloping Winds"] = "Вихрь",
		["Envenom"] = "Envenom", -- old
		["Ephemeral Power"] = "Эфемерная Власть",
		["Escape Artist"] = "Мастер побега",
		["Essence of Sapphiron"] = "Сущность Сапфирона",
		["Evasion"] = "Ускользание",
		["Eventide"] = "Eventide", -- old
		["Eviscerate"] = "Потрошение",
		["Evocation"] = "Прилив сил",
		["Execute"] = "Казнь",
		["Exorcism"] = "Экзорцизм",
		["Expansive Mind"] = "Пытливый ум",
		["Exploding Shot"] = "Разрывной патрон",
		["Exploit Weakness"] = "Обнаружить слабое место",
		["Explosive Shot"] = "Разрывной выстрел",
		["Explosive Trap Effect"] = "Эффект взрывной ловушки",
		["Explosive Trap"] = "Взрывная ловушка",
		["Expose Armor"] = "Ослабление доспеха",
		["Expose Weakness"] = "Выявление слабости",
		["Eye for an Eye"] = "Око за око",
		["Eye of Kilrogg"] = "Око Килрогга",
		["Eyes of the Beast"] = "Звериный глаз",
		["Fade"] = "Уход в тень",
		["Faerie Fire (Feral)"] = "Волшебный огонь (зверь)",
		["Faerie Fire"] = "Волшебный огонь",
		["Far Sight"] = "Дальнее зрение",
		["Fatal Bite"] = "Смертельный укус",
		["Fear Ward"] = "Защита от страха",
		["Fear"] = "Страх",
		["Feed Pet"] = "Кормление питомца",
		["Feedback"] = "Ответная реакция",
		["Feign Death"] = "Притвориться мертвым",
		["Feint"] = "Ложный выпад",
		["Fel Armor"] = "Fel Armor", -- old
		["Fel Concentration"] = "Сосредоточение Скверны",
		["Fel Domination"] = "Господство Скверны",
		["Fel Intellect"] = "Интеллект скверны",
		["Fel Stamina"] = "Выносливость скверны",
		["Fel Stomp"] = "Поступь Скверны",
		["Felfire"] = "Огонь Скверны",
		["Feline Grace"] = "Кошачья грация",
		["Feline Swiftness"] = "Звериная скорость",
		["Feral Aggression"] = "Звериная агрессия",
		["Feral Charge"] = "Звериная атака",
		["Feral Instinct"] = "Животный инстинкт",
		["Ferocious Bite"] = "Свирепый укус",
		["Ferocity"] = "Свирепость",
		["Fetish"] = "Фетиш",
		["Fevered Plague"] = "Моровая лихорадка",
		["Fiery Burst"] = "Выброс огня",
		["Find Herbs"] = "Поиск трав",
		["Find Minerals"] = "Поиск минералов",
		["Find Treasure"] = "Поиск сокровищ",
		["Fire Blast"] = "Огненный взрыв",
		["Fire Elemental Totem"] = "Fire Elemental Totem", -- old
		["Fire Nova Totem"] = "Тотем кольца огня",
		["Fire Nova"] = "Кольцо огня",
		["Fire Power"] = "Огненная мощь",
		["Fire Resistance Aura"] = "Аура сопротивления огню",
		["Fire Resistance Totem"] = "Тотем защиты от огня",
		["Fire Resistance"] = "Сопротивление огню",
		["Fire Shield Effect II"] = "Эффект Огненного щита II",
		["Fire Shield Effect III"] = "Эффект Огненного щита III",
		["Fire Shield Effect IV"] = "Эффект Огненного щита IV",
		["Fire Shield Effect"] = "Эффект Огненного щита",
		["Fire Shield"] = "Огненный щит",
		["Fire Storm"] = "Огненная буря",
		["Fire Vulnerability"] = "Уязвимость к огню",
		["Fire Ward"] = "Защита от огня",
		["Fire Weakness"] = "Слабость перед Огнем",
		["Fireball Volley"] = "Град огненных шаров",
		["Fireball"] = "Огненный шар",
		["Firebolt"] = "Огненная стрела",
		["First Aid"] = "Первая помощь",
		["Fishing Poles"] = "Удочки",
		["Fishing"] = "Рыбная ловля",
		["Fist of Ragnaros"] = "Кулак Рагнароса",
		["Fist Weapon Specialization"] = "Специализация на кистевом оружии",
		["Fist Weapons"] = "Кистевые оружия",
		["Flame Buffet"] = "Удар пламени",
		["Flame Cannon"] = "Пламенная пушка",
		["Flame Lash"] = "Пламенный кнут",
		["Flame Shock"] = "Огненный шок",
		["Flame Spike"] = "Пламенный шип",
		["Flame Spray"] = "Брызги пламени",
		["Flame Throwing"] = "Метание пламени",
		["Flames of Shahram"] = "Пламя Шахрама",
		["Flamestrike"] = "Огненный столб",
		["Flamethrower"] = "Огнемет",
		["Flametongue Totem"] = "Тотем языка пламени",
		["Flametongue Weapon"] = "Оружие языка пламени",
		["Flare"] = "Осветительная ракета",
		["Flash Bomb"] = "Световая бомба",
		["Flash Heal"] = "Быстрое исцеление",
		["Flash of Light"] = "Вспышка Света",
		["Flight Form"] = "Flight Form", -- old
		["Flurry"] = "Шквал",
		["Focused Casting"] = "Средоточие заклинаний",
		["Focused Mind"] = "Сосредоточенный разум",
		["Food"] = "Пища",
		["Forbearance"] = "Воздержанность",
		["Force of Nature"] = "Сила Природы", 
		["Force of Will"] = "Амулет Сильной Воли",
		["Force Punch"] = "Мощный толчок",
		["Force Reactive Disk"] = "Реактивный диск",
		["Forked Lightning"] = "Раздвоенная молния",
		["Forsaken Skills"] = "Утраченные навыки",
		["Frailty"] = "Немощь",
		["Freeze Solid"] = "Полная заморозка",
		["Freezing Trap Effect"] = "Эффект замораживающей ловушки",
		["Freezing Trap"] = "Замораживающая ловушка",
		["Frenzied Regeneration"] = "Неистовое восстановление",
		["Frenzy"] = "Исступление",
		["Frost Armor"] = "Морозный доспех",
		["Frost Breath"] = "Ледяное дыхание",
		["Frost Channeling"] = "Поток льда",
		["Frost Nova"] = "Кольцо льда",
		["Frost Resistance Aura"] = "Аура сопротивления магии льда",
		["Frost Resistance Totem"] = "Тотем защиты от магии льда",
		["Frost Resistance"] = "Сопротивление магии льда",
		["Frost Shock"] = "Ледяной шок",
		["Frost Shot"] = "Ледяной выстрел",
		["Frost Trap Aura"] = "Аура ледяной ловушки", 
		["Frost Trap"] = "Ледяная ловушка",
		["Frost Ward"] = "Защита от магии льда",
		["Frost Warding"] = "Защита от льда",
		["Frost Weakness"] = "Уязвимость ко льду",
		["Frostbite"] = "Обморожение",
		["Frostbolt Volley"] = "Залп ледяных стрел",
		["Frostbolt"] = "Ледяная стрела",
		["Frostbrand Weapon"] = "Оружие ледяного клейма",
		["Furious Howl"] = "Неистовый вой",
		["Furor"] = "Свирепость",
		["Fury of Ragnaros"] = "Неистовство Рагнароса",
		["Gahz'ranka Slam"] = "Хлопушка Газ'ранки",
		["Gahz'rilla Slam"] = "Хлопушка Газ'риллы",
		["Garrote"] = "Гаррота",
		["Gehennas' Curse"] = "Проклятие Гееннаса",
		["Generic"] = "Стандартный",
		["Ghost Wolf"] = "Призрачный волк",
		["Ghostly Strike"] = "Призрачный удар",
		["Gift of Life"] = "Дар жизни",
		["Gift of Nature"] = "Дар природы",
		["Gift of the Wild"] = "Дар дикой природы",
		["Goblin Dragon Gun"] = "Гоблинское драконье ружье",
		["Goblin Sapper Charge"] = "Гоблинская мина",
		["Gouge"] = "Парализующий удар",
		["Grace of Air Totem"] = "Тотем легкости воздуха",
		["Grasping Vines"] = "Хваткие лозы",
		["Great Stamina"] = "Повышенная выносливость",
		["Greater Blessing of Kings"] = "Великое благословение королей",
		["Greater Blessing of Light"] = "Великое благословение Света",
		["Greater Blessing of Might"] = "Великое благословение могущества",
		["Greater Blessing of Salvation"] = "Великое благословение спасения",
		["Greater Blessing of Sanctuary"] = "Великое благословение неприкосновенности",
		["Greater Blessing of Wisdom"] = "Великое благословение мудрости",
		["Greater Heal"] = "Великое исцеление",
		["Grim Reach"] = "Предел мрака",
		["Ground Tremor"] = "Дрожание земли",
		["Grounding Totem"] = "Тотем заземления",
		["Grovel"] = "Ползание",
		["Growl"] = "Рык",
		["Guardian's Favor"] = "Помощь стража",
		["Guillotine"] = "Гильотина",
		["Gun Specialization"] = "Специализация на огнестрельном оружии",
		["Guns"] = "Ружья",
		["Hail Storm"] = "Град",
		["Hammer of Justice"] = "Молот правосудия",
		["Hammer of Wrath"] = "Молот гнева",
		["Hamstring"] = "Подрезать сухожилия",
		["Harass"] = "Преследование",
		["Hardiness"] = "Твердость",
		["Haunting Spirits"] = "Блуждающие духи",
		["Hawk Eye"] = "Глаз ястреба",
		["Head Crack"] = "Трещина в черепе",
		["Heal"] = "Исцеление",
		["Healing Circle"] = "Целебный круг",
		["Healing Focus"] = "Средоточие исцеления",
		["Healing Light"] = "Исцеляющий Свет",
		["Healing of the Ages"] = "Исцеление Эпох",
		["Healing Stream Totem"] = "Тотем исцеляющего потока",
		["Healing Touch"] = "Целительное прикосновение",
		["Healing Wave"] = "Волна исцеления",
		["Healing Way"] = "Путь исцеления",
		["Health Funnel"] = "Канал здоровья",
		["Heart of the Wild"] = "Сердце дикой природы",
		["Heavy Sharpening Stone"] = "Тяжелое точило",
		["Hellfire Effect"] = "Эффект Адского Пламени",
		["Hellfire"] = "Адское Пламя",
		["Hemorrhage"] = "Кровоизлияние",
		["Herb Gathering"] = "Сбор трав",
		["Herbalism"] = "Травничество",
		["Heroic Strike"] = "Удар героя",
		["Heroism"] = "Героизм",
		["Hex of Jammal'an"] = "Проклятие Джаммал'ана",
		["Hex of Weakness"] = "Обессиливающий сглаз",
		["Hex"] = "Сглаз",
		["Hibernate"] = "Спячка",
		["Holy Fire"] = "Священный огонь",
		["Holy Light"] = "Свет небес",
		["Holy Nova"] = "Кольцо света",
		["Holy Power"] = "Священная сила",
		["Holy Reach"] = "Предел сил Света",
		["Holy Shield"] = "Щит небес",
		["Holy Shock"] = "Шок небес",
		["Holy Smite"] = "Божественная кара",
		["Holy Specialization"] = "Специализация на светлой магии",
		["Holy Strength"] = "Священная сила",
		["Holy Strike"] = "Священный удар",
		["Holy Wrath"] = "Гнев небес",
		["Honorless Target"] = "Бесславная цель",
		["Hooked Net"] = "Сеть с крючьями",
		["Horse Riding"] = "Верховая езда: конь",
		["Howl of Terror"] = "Вой ужаса",
		["Humanoid Slaying"] = "Убийство гуманоидов",
		["Hunter's Mark"] = "Метка охотника",
		["Hurricane"] = "Гроза",
		["Ice Armor"] = "Ледяной доспех",
		["Ice Barrier"] = "Ледяная преграда",
		["Ice Blast"] = "Ледяной взрыв",
		["Ice Block"] = "Ледяная глыба",
		["Ice Lance"] = "Ice Lance", -- old
		["Ice Nova"] = "Кольцо мороза",
		["Ice Shards"] = "Ледяные осколки",
		["Icicle"] = "Сосулька",
		["Ignite"] = "Воспламенение",
		["Illumination"] = "Свечение",
		["Immolate"] = "Жертвенный огонь",
		["Immolation Trap Effect"] = "Эффект обжигающей ловушки",
		["Immolation Trap"] = "Обжигающая ловушка",
		["Impact"] = "Сотрясение",
		["Impale"] = "Прокалывание",
		["Improved Ambush"] = "Улучшенный внезапный удар",
		["Improved Arcane Explosion"] = "Улучшенный чародейский взрыв",
		["Improved Arcane Missiles"] = "Улучшенные чародейские стрелы",
		["Improved Arcane Shot"] = "Улучшенный чародейский выстрел",
		["Improved Aspect of the Hawk"] = "Сильный дух ястреба",
		["Improved Aspect of the Monkey"] = "Сильный дух обезьяны",
		["Improved Backstab"] = "Улучшенный удар в спину",
		["Improved Battle Shout"] = "Улучшенный боевой крик",
		["Improved Berserker Rage"] = "Улучшенная ярость берсерка",
		["Improved Blessing of Might"] = "Улучшенное благословение могущества",
		["Improved Blessing of Wisdom"] = "Улучшенное благословение мудрости",
		["Improved Blizzard"] = "Свирепая снежная буря",
		["Improved Bloodrage"] = "Улучшенная кровавая ярость",
		["Improved Chain Heal"] = "Улучшенное цепное исцеление",
		["Improved Chain Lightning"] = "Улучшенная цепная молния",
		["Improved Challenging Shout"] = "Улучшенный вызывающий крик",
		["Improved Charge"] = "Улучшенный рывок",
		["Improved Cheap Shot"] = "Improved Cheap Shot", -- old
		["Improved Cleave"] = "Улучшенный рассекающий удар",
		["Improved Concentration Aura"] = "Улучшенная аура сосредоточенности",
		["Improved Concussive Shot"] = "Улучшенный контузящий выстрел",
		["Improved Cone of Cold"] = "Улучшенный конус холода",
		["Improved Corruption"] = "Улучшенная порча",
		["Improved Counterspell"] = "Улучшенная Антимагия",
		["Improved Curse of Agony"] = "Улучшенное проклятие агонии",
		["Improved Curse of Exhaustion"] = "Улучшенное проклятие изнеможения",
		["Improved Curse of Weakness"] = "Гнетущее проклятие слабости",
		["Improved Dampen Magic"] = "Improved Dampen Magic", -- old
		["Improved Deadly Poison"] = "Улучшенный смертельный яд",
		["Improved Demoralizing Shout"] = "Улучшенный деморализующий крик",
		["Improved Devotion Aura"] = "Улучшенная аура благочестия",
		["Improved Disarm"] = "Улучшенное разоружение",
		["Improved Distract"] = "Улучшенное отвлечение",
		["Improved Drain Life"] = "Улучшенное похищение жизни",
		["Improved Drain Mana"] = "Улучшенное похищение маны",
		["Improved Drain Soul"] = "Улучшенное похищение души",
		["Improved Enrage"] = "Улучшенное исступление",
		["Improved Enslave Demon"] = "Улучшенное порабощение демона",
		["Improved Entangling Roots"] = "Улучшенный гнев деревьев",
		["Improved Evasion"] = "Improved Evasion", -- old
		["Improved Eviscerate"] = "Жестокое потрошение",
		["Improved Execute"] = "Улучшенная казнь",
		["Improved Expose Armor"] = "Сильное ослабление доспеха",
		["Improved Eyes of the Beast"] = "Улучшенный звериный глаз",
		["Improved Fade"] = "Улучшенный \"Уход в тень\"",
		["Improved Feign Death"] = "Улучшенная способность \"Притвориться мертвым\"",
		["Improved Fire Blast"] = "Улучшенный огненный взрыв",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem", -- old
		["Improved Fire Ward"] = "Улучшенная защита от огня",
		["Improved Fireball"] = "Улучшенный огненный шар",
		["Improved Firebolt"] = "Улучшенная огненная стрела",
		["Improved Firestone"] = "Улучшенный камень огня",
		["Improved Flamestrike"] = "Улучшенный огненный столб",
		["Improved Flametongue Weapon"] = "Улучшенное оружие языка пламени",
		["Improved Flash of Light"] = "Улучшенная вспышка света",
		["Improved Frost Nova"] = "Улучшенное кольцо льда",
		["Improved Frost Ward"] = "Улучшенная защита от магии льда",
		["Improved Frostbolt"] = "Улучшенная ледяная стрела",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon", -- old
		["Improved Garrote"] = "Improved Garrote", -- old
		["Improved Ghost Wolf"] = "Улучшенный призрачный волк",
		["Improved Gouge"] = "Улучшенный парализующий удар",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem", -- old
		["Improved Grounding Totem"] = "Improved Grounding Totem", -- old
		["Improved Hammer of Justice"] = "Улучшенный молот правосудия",
		["Improved Hamstring"] = "Улучшенное подрезание сухожилий",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem", -- old
		["Improved Healing Touch"] = "Улучшенное целительное прикосновение",
		["Improved Healing Wave"] = "Улучшенная волна исцеления",
		["Improved Healing"] = "Улучшенное исцеление",
		["Improved Health Funnel"] = "Широкий канал здоровья",
		["Improved Healthstone"] = "Улучшенный камень здоровья",
		["Improved Heroic Strike"] = "Улучшенный удар героя",
		["Improved Hunter's Mark"] = "Улучшенная метка охотника",
		["Improved Immolate"] = "Жаркий жертвенный огонь",
		["Improved Imp"] = "Улучшенный бес",
		["Improved Inner Fire"] = "Улучшенный внутренний огонь",
		["Improved Instant Poison"] = "Improved Instant Poison", -- old
		["Improved Intercept"] = "Улучшенный перехват",
		["Improved Intimidating Shout"] = "Улучшенный устрашающий крик",
		["Improved Judgement"] = "Беспристрастное правосудие",
		["Improved Kick"] = "Улучшенный пинок",
		["Improved Kidney Shot"] = "Улучшенный удар по почкам",
		["Improved Lash of Pain"] = "Улучшенный всплеск боли",
		["Improved Lay on Hands"] = "Улучшенное возложение рук",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave", -- old
		["Improved Life Tap"] = "Улучшенный жизнеотвод",
		["Improved Lightning Bolt"] = "Улучшенная молния",
		["Improved Lightning Shield"] = "Улучшенный щит молний",
		["Improved Magma Totem"] = "Улучшенный тотем магмы",
		["Improved Mana Burn"] = "Улучшенное сожжение маны",
		["Improved Mana Shield"] = "Улучшенный щит маны",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem", -- old
		["Improved Mark of the Wild"] = "Улучшенный знак дикой природы",
		["Improved Mend Pet"] = "Улучшенное лечение питомца",
		["Improved Mind Blast"] = "Улучшенный взрыв разума",
		["Improved Moonfire"] = "Улучшенный лунный огонь",
		["Improved Nature's Grasp"] = "Улучшенная хватка природы",
		["Improved Overpower"] = "Безусловное превосходство",
		["Improved Power Word: Fortitude"] = "Улучшенное слово силы: Стойкость",
		["Improved Power Word: Shield"] = "Улучшенное слово силы: Щит",
		["Improved Prayer of Healing"] = "Улучшенная молитва исцеления",
		["Improved Psychic Scream"] = "Улучшенный ментальный крик",
		["Improved Pummel"] = "Улучшенная зуботычина",
		["Improved Regrowth"] = "Улучшенное восстановление",
		["Improved Reincarnation"] = "Улучшенное перерождение",
		["Improved Rejuvenation"] = "Улучшенное омоложение",
		["Improved Rend"] = "Улучшенное кровопускание",
		["Improved Renew"] = "Улучшенное обновление",
		["Improved Retribution Aura"] = "Улучшенная аура воздаяния",
		["Improved Revenge"] = "Улучшенный реванш",
		["Improved Revive Pet"] = "Улучшенное воскрешение питомца",
		["Improved Righteous Fury"] = "Улучшенное праведное неистовство",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon", -- old
		["Improved Rupture"] = "Улучшенная рваная рана",
		["Improved Sap"] = "Улучшенное ошеломление",
		["Improved Scorch"] = "Улучшенный ожог",
		["Improved Scorpid Sting"] = "Смертельный укус скорпида",
		["Improved Seal of Righteousness"] = "Улучшенная печать праведности",
		["Improved Seal of the Crusader"] = "Улучшенная печать воина Света",
		["Improved Searing Pain"] = "Непереносимая жгучая боль",
		["Improved Searing Totem"] = "Improved Searing Totem", -- old
		["Improved Serpent Sting"] = "Смертельный укус змеи",
		["Improved Shadow Bolt"] = "Улучшенная стрела Тьмы",
		["Improved Shadow Word: Pain"] = "Улучшенное слово Тьмы: Боль",
		["Improved Shield Bash"] = "Улучшенный удар щитом",
		["Improved Shield Block"] = "Улучшенный блок щитом",
		["Improved Shield Wall"] = "Улучшенная глухая оборона",
		["Improved Shred"] = "Растерзать противника",
		["Improved Sinister Strike"] = "Улучшенный коварный удар",
		["Improved Slam"] = "Умелый мощный удар",
		["Improved Slice and Dice"] = "Жестокая мясорубка",
		["Improved Spellstone"] = "Улучшенный камень чар",
		["Improved Sprint"] = "Улучшенный спринт",
		["Improved Starfire"] = "Улучшенный звездный огонь",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem", -- old
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem", -- old
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem", -- old
		["Improved Succubus"] = "Всевластный суккуб",
		["Improved Sunder Armor"] = "Улучшенный раскол брони",
		["Improved Taunt"] = "Улучшенная провокация",
		["Improved Thorns"] = "Улучшенные шипы",
		["Improved Thunder Clap"] = "Улучшенный удар грома",
		["Improved Tranquility"] = "Улучшенное спокойствие",
		["Improved Vampiric Embrace"] = "Крепкие объятия вампира",
		["Improved Vanish"] = "Улучшенное исчезновение",
		["Improved Voidwalker"] = "Улучшенный демон Бездны",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon", -- old
		["Improved Wing Clip"] = "Безжалостно подрезать крылья",
		["Improved Wrath"] = "Улучшенный гнев",
		["Incinerate"] = "Испепеление",
		["Infected Bite"] = "Заразный укус",
		["Infected Wound"] = "Зараженная рана",
		["Inferno Shell"] = "Инфернальный снаряд",
		["Inferno"] = "Инфернал",
		["Initiative"] = "Инициатива",
		["Inner Fire"] = "Внутренний огонь",
		["Inner Focus"] = "Внутреннее сосредоточение",
		["Innervate"] = "Озарение",
		["Insect Swarm"] = "Рой насекомых",
		["Inspiration"] = "Вдохновение",
		["Instant Poison II"] = "Быстродействующий яд II",
		["Instant Poison III"] = "Быстродействующий яд III",
		["Instant Poison IV"] = "Быстродействующий яд IV",
		["Instant Poison V"] = "Быстродействующий яд V",
		["Instant Poison VI"] = "Быстродействующий яд VI",
		["Instant Poison"] = "Быстродействующий яд",
		["Intensity"] = "Напряжение",
		["Intercept Stun"] = "Перехват - оглушение",
		["Intercept"] = "Перехват",
		["Intervene"] = "Intervene", -- old
		["Intimidating Roar"] = "Устрашающий рев",
		["Intimidating Shout"] = "Устрашающий крик",
		["Intimidation"] = "Устрашение",
		["Intoxicating Venom"] = "Пьяный яд",
		["Invisibility"] = "Невидимость",
		["Iron Will"] = "Железная воля",
		["Jewelcrafting"] = "Jewelcrafting", -- old
		["Judgement of Command"] = "Правосудие повиновения",
		["Judgement of Justice"] = "Правосудие справедливости",
		["Judgement of Light"] = "Правосудие света",
		["Judgement of Righteousness"] = "Правосудие праведности",
		["Judgement of the Crusader"] = "Правосудие воина света",
		["Judgement of Wisdom"] = "Правосудие мудрости",
		["Judgement"] = "Правосудие",
		["Kick - Silenced"] = "Пинок - немота", 
		["Kick"] = "Пинок",
		["Kidney Shot"] = "Удар по почкам",
		["Kill Command"] = "Kill Command", -- old
		["Killer Instinct"] = "Инстинкт убийцы",
		["Knock Away"] = "Отталкивание",
		["Knockdown"] = "Сбивание с ног",
		["Kodo Riding"] = "Верховая езда: кодо",
		["Lacerate"] = "Растерзать", 
		["Larva Goo"] = "Личиночный студень",
		["Lash of Pain"] = "Всплеск боли",
		["Lash"] = "Кнут",
		["Last Stand"] = "Ни шагу назад",
		["Lasting Judgement"] = "Длительное правосудие",
		["Lava Spout Totem"] = "Тотем лавы",
		["Lay on Hands"] = "Возложение рук",
		["Leader of the Pack"] = "Вожак стаи",
		["Leather"] = "Кожа",
		["Leatherworking"] = "Кожевничество",
		["Leech Poison"] = "Яд пиявки",
		["Lesser Heal"] = "Малое исцеление",
		["Lesser Healing Wave"] = "Малая волна исцеления",
		["Lesser Invisibility"] = "Простая невидимость",
		["Lethal Shots"] = "Стрельба на поражение",
		["Lethality"] = "Смертоносность",
		["Levitate"] = "Левитация",
		["Libram"] = "Манускрипт",
		["Lich Slap"] = "Удар лича",
		["Life Tap"] = "Жизнеотвод",
		["Lifebloom"] = "Lifebloom", -- old
		["Lifegiving Gem"] = "Животворный камень",
		["Lightning Blast"] = "Вспышка молнии",
		["Lightning Bolt"] = "Молния",
		["Lightning Breath"] = "Грозовое дыхание",
		["Lightning Cloud"] = "Грозовая туча",
		["Lightning Mastery"] = "Покорение молнии",
		["Lightning Reflexes"] = "Молниеносная реакция",
		["Lightning Shield"] = "Щит молний",
		["Lightning Wave"] = "Грозовая волна",
		["Lightwell Renew"] = "Обновление колодца Света",
		["Lightwell"] = "Колодец Света",
		["Lizard Bolt"] = "Ящеричья молния",
		["Localized Toxin"] = "Сосредоточенный яд",
		["Lockpicking"] = "Вскрытие замков", 
		["Long Daze"] = "Долгое оцепенение",
		["Mace Specialization"] = "Специализация на дробящем оружии",
		["Mace Stun Effect"] = "Эффект оглушения дробящего оружия",
		["Machine Gun"] = "Пулемет",
		["Mage Armor"] = "Магический доспех",
		["Magic Attunement"] = "Магическое созвучие",
		["Magma Splash"] = "Выплеск магмы",
		["Magma Totem"] = "Тотем магмы",
		["Mail"] = "Кольчужные доспехи",
		["Maim"] = "Maim", -- old
		["Malice"] = "Злоба",
		["Mana Burn"] = "Сожжение маны",
		["Mana Feed"] = "Манакорм",
		["Mana Shield"] = "Щит маны",
		["Mana Spring Totem"] = "Тотем источника маны",
		["Mana Tide Totem"] = "Тотем прилива маны",
		["Mangle (Bear)"] = "Mangle (Bear)", -- old
		["Mangle (Cat)"] = "Mangle (Cat)", -- old
		["Mangle"] = "Нанесение увечья",
		["Mark of Arlokk"] = "Метка Арлокк",
		["Mark of the Wild"] = "Знак дикой природы",
		["Martyrdom"] = "Мученичество",
		["Mass Dispel"] = "Массовое рассеивание",
		["Master Demonologist"] = "Мастер-демонолог",
		["Master of Deception"] = "Мастер маскировки",
		["Master of Elements"] = "Повелитель Стихий",
		["Master Summoner"] = "Мастер призыва",
		["Maul"] = "Трепка",
		["Mechanostrider Piloting"] = "Водитель механодолгонога",
		["Meditation"] = "Медитация",
		["Megavolt"] = "Мегавольт",
		["Melee Specialization"] = "Специализация на ближнем бое",
		["Melt Ore"] = "Жидкая руда",
		["Mend Pet"] = "Лечение питомца",
		["Mental Agility"] = "Подвижность мысли",
		["Mental Strength"] = "Сила мысли",
		["Mighty Blow"] = "Могучий удар",
		["Mind Blast"] = "Взрыв разума",
		["Mind Control"] = "Контроль над разумом",
		["Mind Flay"] = "Пытка разума",
		["Mind Soothe"] = "Усмирение",
		["Mind Tremor"] = "Мысленная дрожь",
		["Mind Vision"] = "Внутреннее зрение",
		["Mind-numbing Poison II"] = "Дурманящий яд II",
		["Mind-numbing Poison III"] = "Дурманящий яд III",
		["Mind-numbing Poison"] = "Дурманящий яд",
		["Mining"] = "Горное дело",
		["Misdirection"] = "Misdirection", -- old
		["Mocking Blow"] = "Дразнящий удар",
		["Molten Armor"] = "Molten Armor", -- old
		["Molten Blast"] = "Всплеск лавы",
		["Molten Metal"] = "Расплавленный металл",
		["Mongoose Bite"] = "Укус мангуста",
		["Monster Slaying"] = "Убийство монстров",
		["Moonfire"] = "Лунный огонь",
		["Moonfury"] = "Лунное неистовство",
		["Moonglow"] = "Лунное сияние",
		["Moonkin Aura"] = "Аура лунного совуха",
		["Moonkin Form"] = "Облик лунного совуха",
		["Mortal Cleave"] = "Смертельный раскол",
		["Mortal Shots"] = "Смертоносные выстрелы",
		["Mortal Strike"] = "Смертельный удар",
		["Mortal Wound"] = "Смертоносная рана",
		["Multi-Shot"] = "Залп",
		["Murder"] = "Убийство",
		["Mutilate"] = "Mutilate", -- old
		["Naralex's Nightmare"] = "Кошмар Наралекса",
		["Natural Armor"] = "Природная броня",
		["Natural Shapeshifter"] = "Прирожденный оборотень",
		["Natural Weapons"] = "Оружие природы",
		["Nature Aligned"] = "Упорядочение Природы",
		["Nature Resistance Totem"] = "Тотем защиты от сил природы",
		["Nature Resistance"] = "Сопротивление силам природы",
		["Nature Weakness"] = "Природная слабость",
		["Nature's Focus"] = "Средоточие Природы",
		["Nature's Grace"] = "Благоволение природы",
		["Nature's Grasp"] = "Хватка природы",
		["Nature's Reach"] = "Предел сил Природы",
		["Nature's Swiftness"] = "Природная стремительность",
		["Necrotic Poison"] = "Некротический яд",
		["Negative Charge"] = "Отрицательный заряд",
		["Net"] = "Сеть",
		["Nightfall"] = "Сумерки",
		["Noxious Catalyst"] = "Ядовитый катализатор",
		["Noxious Cloud"] = "Пагубное облако",
		["Omen of Clarity"] = "Знамение ясности",
		["One-Handed Axes"] = "Одноручные топоры",
		["One-Handed Maces"] = "Одноручное дробящее оружие",
		["One-Handed Swords"] = "Одноручные мечи",
		["One-Handed Weapon Specialization"] = "Специализация на одноручном оружии",
		["Opening - No Text"] = "Открытие - без текста",
		["Opening"] = "Открытие",
		["Opportunity"] = "Правильный момент",
		["Overpower"] = "Превосходство",
		["Pacify"] = "Умиротворение",
		["Pain Suppression"] = "Pain Suppression", -- old
		["Paralyzing Poison"] = "Парализующий яд",
		["Paranoia"] = "Паранойя",
		["Parasitic Serpent"] = "Паразитирующий змей",
		["Parry"] = "Парирование",
		["Pathfinding"] = "Знание троп",
		["Perception"] = "Внимательность",
		["Permafrost"] = "Вечная мерзлота",
		["Pet Aggression"] = "Агрессия питомца",
		["Pet Hardiness"] = "Стойкость питомца",
		["Pet Recovery"] = "Восстановление питомца",
		["Pet Resistance"] = "Стойкость питомца",
		["Petrify"] = "Обращение в камень",
		["Phase Shift"] = "Бегство в астрал",
		["Pick Lock"] = "Взлом замка",
		["Pick Pocket"] = "Обшаривание карманов",
		["Pierce Armor"] = "Пронзенная броня",
		["Piercing Howl"] = "Пронзительный вой",
		["Piercing Ice"] = "Пронзающий лед",
		["Piercing Shadow"] = "Пронзающая тень",
		["Piercing Shot"] = "Пронзающий выстрел",
		["Plague Cloud"] = "Чумное облако",
		["Plate Mail"] = "Латы",
		["Poison Bolt Volley"] = "Ядовитый град",
		["Poison Bolt"] = "Ядовитый удар",
		["Poison Cleansing Totem"] = "Тотем противоядия",
		["Poison Cloud"] = "Ядовитое облако",
		["Poison Shock"] = "Ядовитый шок",
		["Poison"] = "Яд",
		["Poisoned Harpoon"] = "Ядовитый гарпун",
		["Poisoned Shot"] = "Ядовитый выстрел",
		["Poisonous Blood"] = "Ядовитая кровь",
		["Poisons"] = "Яды",
		["Polearm Specialization"] = "Специализация на древковом оружии",
		["Polearms"] = "Древковое оружие",
		["Polymorph"] = "Превращение",
		["Polymorph: Pig"] = "Превращение: свинья", 
		["Polymorph: Turtle"] = "Превращение: черепаха",
		["Portal: Darnassus"] = "Портал: Дарнас",
		["Portal: Ironforge"] = "Портал в Стальгорн",
		["Portal: Orgrimmar"] = "Портал в Оргриммар",
		["Portal: Stormwind"] = "Портал в Штормград",
		["Portal: Thunder Bluff"] = "Портал в Громовой Утес",
		["Portal: Undercity"] = "Портал в Подгород",
		["Positive Charge"] = "Положительный заряд",
		["Pounce Bleed"] = "Кровоточащая рана",
		["Pounce"] = "Наскок",
		["Power Infusion"] = "Придание сил",
		["Power Word: Fortitude"] = "Слово силы: Стойкость",
		["Power Word: Shield"] = "Слово силы: Щит",
		["Prayer Beads Blessing"] = "Благословение четок",
		["Prayer of Fortitude"] = "Молитва стойкости",
		["Prayer of Healing"] = "Молитва исцеления",
		["Prayer of Mending"] = "Prayer of Mending", -- old
		["Prayer of Shadow Protection"] = "Молитва защиты от темной магии",
		["Prayer of Spirit"] = "Молитва духа",
		["Precision"] = "Точность",
		["Predatory Strikes"] = "Удары хищника",
		["Premeditation"] = "Умысел",
		["Preparation"] = "Подготовка",
		["Presence of Mind"] = "Величие разума",
		["Primal Fury"] = "Изначальное неистовство",
		["Prowl"] = "Крадущийся зверь",
		["Psychic Scream"] = "Ментальный крик",
		["Pummel"] = "Зуботычина",
		["Puncture"] = "Прокол",
		["Purge"] = "Развеяние магии",
		["Purification"] = "Чистота",
		["Purify"] = "Омовение",
		["Pursuit of Justice"] = "Погоня за справедливостью",
		["Putrid Breath"] = "Гнилостное дыхание",
		["Putrid Enzyme"] = "Вызов зачумленного воителя и создания",
		["Pyroblast"] = "Огненная глыба",
		["Pyroclasm"] = "Огнесдвиг",
		["Quick Shots"] = "Скорострельность",
		["Quickness"] = "Расторопность",
		["Radiation Bolt"] = "Радиационный удар",
		["Radiation Cloud"] = "Радиоактивное облако",
		["Radiation Poisoning"]= "Радиационное заражение",
		["Radiation"] = "Радиация",
		["Rain of Fire"] = "Огненный ливень",
		["Rake"] = "Глубокая рана",
		["Ram Riding"] = "Верховая езда: баран",
		["Rampage"] = "Буйство",
		["Ranged Weapon Specialization"] = "Специализация на оружии дальнего боя",
		["Rapid Concealment"] = "Rapid Concealment", -- old
		["Rapid Fire"] = "Быстрая стрельба",
		["Raptor Riding"] = "Верховая езда: ящер",
		["Raptor Strike"] = "Удар ящера",
		["Ravage"] = "Накинуться",
		["Ravenous Claw"] = "Хищный коготь",
		["Readiness"] = "Готовность",
		["Rebirth"] = "Возрождение",
		["Rebuild"] = "Починка",
		["Recently Bandaged"] = "Раны перевязаны",
		["Reckless Charge"] = "Безрассудная атака",
		["Recklessness"] = "Безрассудство",
		["Reckoning"] = "Расплата",
		["Recombobulate"] = "Перенаправление",
		["Redemption"] = "Искупление",
		["Redoubt"] = "Оплот",
		["Reflection"] = "Отражение",
		["Regeneration"] = "Регенерация",
		["Regrowth"] = "Восстановление",
		["Reincarnation"] = "Перерождение",
		["Rejuvenation"] = "Омоложение",
		["Relentless Strikes"] = "Неослабевающие удары",
		["Remorseless Attacks"] = "Беспощадные атаки",
		["Remorseless"] = "Беспощадность",
		["Remove Curse"] = "Снятие проклятия",
		["Remove Insignia"] = "Удаление знака отличия",
		["Remove Lesser Curse"] = "Снятие малого проклятия",
		["Rend"] = "Кровопускание",
		["Renew"] = "Обновление",
		["Repentance"] = "Покаяние",
		["Repulsive Gaze"] = "Угрожающий взгляд",
		["Restorative Totems"] = "Восстанавливающие тотемы",
		["Resurrection"] = "Воскрешение",
		["Retaliation"] = "Возмездие",
		["Retribution Aura"] = "Аура воздаяния",
		["Revenge Stun"] = "Реванш - оглушение",
		["Revenge"] = "Реванш",
		["Reverberation"] = "Отзвук",
		["Revive Pet"] = "Воскрешение питомца",
		["Rhahk'Zor Slam"] = "Удар Рак-Зора",
		["Ribbon of Souls"] = "Лента душ",
		["Righteous Defense"] = "Righteous Defense", -- old
		["Righteous Fury"] = "Праведное неистовство",
		["Rip"] = "Разорвать",
		["Riposte"] = "Ответный удар",
		["Ritual of Doom Effect"] = "Эффект Ритуала Рока",
		["Ritual of Doom"] = "Ритуал Рока",
		["Ritual of Souls"] = "Ritual of Souls", -- old
		["Ritual of Summoning"] = "Ритуал призыва",
		["Rockbiter Weapon"] = "Оружие Камнедробителя",
		["Rogue Passive"] = "Разбойник - бездействие",
		["Rough Sharpening Stone"] = "Грубое точило",
		["Ruin"] = "Разгром",
		["Rupture"] = "Рваная рана",
		["Ruthlessness"] = "Жестокость",
		["Sacrifice"] = "Жертвоприношение",
		["Safe Fall"] = "Безопасное падение",
		["Sanctity Aura"] = "Аура святости",
		["Sap"] = "Ошеломление",
		["Savage Fury"] = "Бешеное неистовство",
		["Savage Strikes"] = "Беспощадные удары",
		["Scare Beast"] = "Отпугивание зверя",
		["Scatter Shot"] = "Дезориентирующий выстрел",
		["Scorch"] = "Ожог",
		["Scorpid Poison"] = "Яд скорпида",
		["Scorpid Sting"] = "Укус скорпида",
		["Screams of the Past"] = "Вопли прошлого",
		["Screech"] = "Визг",
		["Seal Fate"] = "Печать судьбы",
		["Seal of Blood"] = "Seal of Blood", -- old
		["Seal of Command"] = "Печать повиновения",
		["Seal of Justice"] = "Печать справедливости",
		["Seal of Light"] = "Печать Света",
		["Seal of Reckoning"] = "Печать расплаты",
		["Seal of Righteousness"] = "Печать праведности",
		["Seal of the Crusader"] = "Печать воина Света",
		["Seal of Vengeance"] = "Seal of Vengeance", -- old
		["Seal of Wisdom"] = "Печать мудрости",
		["Searing Light"] = "Опаляющий свет",
		["Searing Pain"] = "Жгучая боль",
		["Searing Totem"] = "Опаляющий тотем",
		["Second Wind"] = "Второе дыхание",
		["Seduction"] = "Соблазн",
		["Seed of Corruption"] = "Seed of Corruption", -- old
		["Sense Demons"] = "Чутье на демонов",
		["Sense Undead"] = "Чутье на нежить",
		["Sentry Totem"] = "Сторожевой тотем",
		["Serpent Sting"] = "Укус змеи",
		["Setup"] = "Выучка",
		["Shackle Undead"] = "Сковывание нежити",
		["Shadow Affinity"] = "Единение с Тьмой",
		["Shadow Bolt Volley"] = "Залп стрел Тьмы",
		["Shadow Bolt"] = "Стрела Тьмы",
		["Shadow Focus"] = "Средоточие Тьмы",
		["Shadow Mastery"] = "Власть над Тенями",
		["Shadow Protection"] = "Защита от темной магии",
		["Shadow Reach"] = "Предел Тьмы",
		["Shadow Resistance Aura"] = "Аура сопротивления темной магии",
		["Shadow Resistance"] = "Сопротивление темной магии",
		["Shadow Shock"] = "Удар Тени",
		["Shadow Trance"] = "Теневой транс",
		["Shadow Vulnerability"] = "Уязвимость к Тьме",
		["Shadow Ward"] = "Защита от темной магии",
		["Shadow Weakness"] = "Теневая слабость",
		["Shadow Weaving"] = "Плетение Тьмы",
		["Shadow Word: Death"] = "Shadow Word: Death", -- old
		["Shadow Word: Pain"] = "Слово Тьмы: Боль",
		["Shadowburn"] = "Ожог Тьмы",
		["Shadowfiend"] = "Shadowfiend", -- old
		["Shadowform"] = "Облик Тьмы",
		["Shadowfury"] = "Shadowfury", -- old
		["Shadowguard"] = "Страж Тьмы",
		["Shadowmeld Passive"] = "Слиться с тенью - постоянное действие",
		["Shadowmeld"] = "Слиться с тенью",
		["Shadowstep"] = "Shadowstep", -- old
		["Shamanistic Rage"] = "Shamanistic Rage", -- old
		["Sharpened Claws"] = "Острые когти",
		["Shatter"] = "Обледенение",
		["Sheep"] = "Sheep", -- old
		["Shell Shield"] = "Панцирный щит",
		["Shield Bash - Silenced"] = "Удар щитом - немота", 
		["Shield Bash"] = "Удар щитом",
		["Shield Block"] = "Блок щитом",
		["Shield Slam"] = "Мощный удар щитом",
		["Shield Specialization"] = "Специализация на щитах",
		["Shield Wall"] = "Глухая оборона",
		["Shield"] = "Щит",
		["Shiv"] = "Shiv", -- old
		["Shock"] = "Шок",
		["Shoot Bow"] = "Выстрел из лука",
		["Shoot Crossbow"] = "Выстрел с арбалета",
		["Shoot Gun"] = "Выстрел с огнестрельного оружия",
		["Shoot"] = "Выстрел",
		["Shred"] = "Полоснуть",
		["Shrink"] = "Уменьшение",
		["Silence"] = "Безмолвие",
		["Silencing Shot"] = "Глушащий выстрел", 
		["Silent Resolve"] = "Молчаливая решимость",
		["Sinister Strike"] = "Коварный удар",
		["Siphon Life"] = "Вытягивание жизни",
		["Skinning"] = "Снятие шкур",
		["Skull Crack"] = "Сокрушение черепа",
		["Slam"] = "Мощный удар",
		["Sleep"] = "Сон",
		["Slice and Dice"] = "Мясорубка",
		["Slow Fall"] = "Замедленное падение",
		["Slow"] = "Замедление",
		["Slowing Poison"] = "Замедляющий яд",
		["Smelting"] = "Выплавка металлов",
		["Smite Slam"] = "Кара, Мощный удар",
		["Smite Stomp"] = "Кара, Топот",
		["Smite"] = "Кара",
		["Smoke Bomb"] = "Дымовая шашка",
		["Snake Trap"] = "Snake Trap", -- old
		["Snap Kick"] = "Ловкий пинок",
		["Solid Sharpening Stone"] = "Твердое точило",
		["Sonic Burst"] = "Грохот",
		["Soothe Animal"] = "Умиротворение животного",
		["Soothing Kiss"] = "Успокаивающий поцелуй",
		["Soul Bite"] = "Душевный укус",
		["Soul Drain"] = "Истощение души",
		["Soul Fire"] = "Ожог души",
		["Soul Link"] = "Связка души",
		["Soul Siphon"] = "Вытягивание души",
		["Soul Tap"] = "Высасывание души",
		["Soulshatter"] = "Soulshatter", -- old
		["Soulstone Resurrection"] = "Воскрешение камнем души",
		["Spell Lock"] = "Запрет чар",
		["Spell Reflection"] = "Отражение заклинания",
		["Spell Warding"] = "Защита от заклинаний",
		["Spellsteal"] = "Spellsteal", -- old
		["Spirit Bond"] = "Узы духа",
		["Spirit Burst"] = "Импульс духа",
		["Spirit of Redemption"] = "Дух воздаяния",
		["Spirit Tap"] = "Захват духа",
		["Spiritual Attunement"] = "Spiritual Attunement", -- old
		["Spiritual Focus"] = "Средоточие духа",
		["Spiritual Guidance"] = "Духовное направление",
		["Spiritual Healing"] = "Духовное исцеление",
		["Spit"] = "Плевок",
		["Spore Cloud"] = "Споровое облако",
		["Sprint"] = "Спринт",
		["Stance Mastery"] = "Stance Mastery", -- old
		["Starfire Stun"] = "Звездный огонь - оглушение", 
		["Starfire"] = "Звездный огонь",
		["Starshards"] = "Звездные осколки",
		["Staves"] = "Посохи",
		["Steady Shot"] = "Steady Shot", -- old
		["Stealth"] = "Незаметность",
		["Stoneclaw Totem"] = "Тотем каменного когтя",
		["Stoneform"] = "Каменная форма",
		["Stoneskin Totem"] = "Тотем каменной кожи",
		["Stormstrike"] = "Удар бури",
		["Strength of Earth Totem"] = "Тотем силы земли",
		["Strike"] = "Разящий удар",
		["Stuck"] = "Застревание",
		["Stun"] = "Оглушение",
		["Subtlety"] = "Скрытность",
		["Suffering"] = "Муки",
		["Summon Charger"] = "Призыв скакуна",
		["Summon Dreadsteed"] = "Призыв коня погибели",
		["Summon Felguard"] = "Summon Felguard", -- old
		["Summon Felhunter"] = "Призыв охотника Скверны",
		["Summon Felsteed"] = "Призывание коня Скверны",
		["Summon Imp"] = "Призыв беса",
		["Summon Spawn of Bael'Gar"] = "Вызов порождения Бейл'Гора",
		["Summon Succubus"] = "Призыв суккуба",
		["Summon Voidwalker"] = "Призыв демона Бездны",
		["Summon Warhorse"] = "Призыв боевого коня",
		["Summon Water Elemental"] = "Призыв элементаля воды", 
		["Sunder Armor"] = "Раскол брони",
		["Suppression"] = "Подавление",
		["Surefooted"] = "Верный шаг",
		["Survivalist"] = "Остаться в живых",
		["Sweeping Slam"] = "Сбивающий удар",
		["Sweeping Strikes"] = "Размашистые удары",
		["Swiftmend"] = "Быстрое восстановление",
		["Swipe"] = "Размах",
		["Swoop"] = "Налет",
		["Sword Specialization"] = "Специализация на владении мечами",
		["Tactical Mastery"] = "Тактическое превосходство",
		["Tailoring"] = "Портняжное дело",
		["Tainted Blood"] = "Порченая кровь",
		["Tame Beast"] = "Приручение зверя",
		["Tamed Pet Passive"] = "Прирученный питомец, постоянное действие",
		["Taunt"] = "Провокация",
		["Teleport: Darnassus"] = "Телепортация: Дарнас",
		["Teleport: Ironforge"] = "Телепортация: Стальгорн",
		["Teleport: Moonglade"] = "Телепортация: Лунная поляна",
		["Teleport: Orgrimmar"] = "Телепортация: Оргриммар",
		["Teleport: Stormwind"] = "Телепортация: Штормград",
		["Teleport: Thunder Bluff"] = "Телепортация: Громовой Утес",
		["Teleport: Undercity"] = "Телепортация: Подгород",
		["Tendon Rip"] = "Повреждение сухожилий",
		["Tendon Slice"] = "Разрыв сухожилий",
		["Terrify"] = "Запугивание",
		["Terrifying Screech"] = "Ужасающий визг",
		["The Beast Within"] = "The Beast Within", -- old
		["The Eye of the Dead"] = "Глаз Мертвого",
		["The Furious Storm"] = "Яростный шторм",
		["The Human Spirit"] = "Человеческий дух",
		["Thick Hide"] = "Плотная шкура",
		["Thorn Volley"] = "Град шипов",
		["Thorns"] = "Шипы",
		["Thousand Blades"] = "Тысяча Клинков",
		["Threatening Gaze"] = "Угрожающий взгляд",
		["Throw Axe"] = "Бросок топора",
		["Throw Dynamite"] = "Бросок динамита",
		["Throw Liquid Fire"] = "Бросок жидкого огня",
		["Throw Wrench"] = "Бросок гаечного ключа",
		["Throw"] = "Бросок",
		["Throwing Specialization"] = "Специализация на метательном оружии",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization", -- old
		["Thrown"] = "Метательное",
		["Thunder Clap"] = "Удар грома",
		["Thunderclap"] = "Удар грома",
		["Thunderfury"] = "Неистовство бури",
		["Thundering Strikes"] = "Грохочущие удары",
		["Thundershock"] = "Громовой удар",
		["Thunderstomp"] = "Грохочущие шаги",
		["Tidal Focus"] = "Средоточие приливов",
		["Tidal Mastery"] = "Повелитель приливов",
		["Tiger Riding"] = "Верховая езда: тигр",
		["Tiger's Fury"] = "Тигриное неистовство",
		["Torment"] = "Мучение",
		["Totem of Wrath"] = "Totem of Wrath", -- old
		["Totem"] = "Тотем",
		["Totemic Focus"] = "Тотемное средоточие",
		["Touch of Weakness"] = "Прикосновение слабости",
		["Toughness"] = "Крепость",
		["Toxic Saliva"] = "Ядовитая слюна",
		["Toxic Spit"] = "Токсичный плевок",
		["Toxic Volley"] = "Отравляющий град",
		["Traces of Silithyst"] = "Следы Силитиста",
		["Track Beasts"] = "Выслеживание животных",
		["Track Demons"] = "Выслеживание демонов",
		["Track Dragonkin"] = "Выслеживание драконов",
		["Track Elementals"] = "Выслеживание элементалей",
		["Track Giants"] = "Выслеживание великанов",
		["Track Hidden"] = "Выслеживание скрытого",
		["Track Humanoids"] = "Выслеживание гуманоидов",
		["Track Undead"] = "Выслеживание нежити",
		["Trample"] = "Тяжелый шаг",
		["Tranquil Air Totem"] = "Тотем безветрия",
		["Tranquil Spirit"] = "Мирный дух",
		["Tranquility"] = "Спокойствие",
		["Tranquilizing Poison"] = "Успокоительный яд",
		["Tranquilizing Shot"] = "Усмиряющий выстрел",
		["Trap Mastery"] = "Мастер установки ловушек",
		["Travel Form"] = "Походный облик",
		["Tree of Life"] = "Tree of Life", -- old
		["Tremor Totem"] = "Тотем трепета",
		["Tribal Leatherworking"] = "Кожевничество: традиции предков",
		["Trueshot Aura"] = "Аура меткого выстрела",
		["Turn Undead"] = "Изгнание нежити",
		["Twisted Tranquility"] = "Искаженное спокойствие",
		["Two-Handed Axes and Maces"] = "Двуручные топоры и дробящее",
		["Two-Handed Axes"] = "Двуручные топоры",
		["Two-Handed Maces"] = "Двуручное дробящее оружие",
		["Two-Handed Swords"] = "Двуручные мечи",
		["Two-Handed Weapon Specialization"] = "Специализация на двуручном оружии",
		["Unarmed"] = "Рукопашный бой",
		["Unbreakable Will"] = "Непреклонная воля",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect", -- old
		["Unbridled Wrath"] = "Необузданный гнев",
		["Undead Horsemanship"] = "Верховая езда нежити",
		["Underwater Breathing"] = "Подводное дыхание",
		["Unending Breath"] = "Бесконечное дыхание",
		["Unholy Frenzy"] = "Нечестивое бешенство",
		["Unholy Power"] = "Нечестивая сила",
		["Unleashed Fury"] = "Неудержимое неистовство",
		["Unleashed Rage"] = "Высвобожденная ярость",
		["Unleashed Rage"] = "Высвобожденная ярость", 
		["Unstable Affliction"] = "Unstable Affliction", -- old
		["Unstable Power"] = "Изменчивая сила",
		["Unyielding Faith"] = "Непоколебимая вера",
		["Uppercut"] = "Апперкот",
		["Vampiric Embrace"] = "Объятия вампира",
		["Vampiric Touch"] = "Vampiric Touch", -- old
		["Vanish"] = "Исчезновение",
		["Vanished"] = "Исчезнувший",
		["Veil of Shadow"] = "Пелена Тени",
		["Vengeance"] = "Отмщение",
		["Venom Spit"] = "Отравляющий плевок",
		["Venom Sting"] = "Ядовитое жало",
		["Venomhide Poison"] = "Яд равазавра",
		["Vicious Rend"] = "Жестокий рывок",
		["Victory Rush"] = "Victory Rush", -- old
		["Vigor"] = "Неутомимость",
		["Vile Poisons"] = "Тлетворные яды",
		["Vindication"] = "Оправдание",
		["Viper Sting"] = "Укус гадюки",
		["Virulent Poison"] = "Жестокий яд",
		["Void Bolt"] = "Молния Бездны",
		["Volley"] = "Град стрел",
		["Walking Bomb Effect"] = "Эффект движущейся бомбы",
		["Wand Specialization"] = "Специализация на владении жезлами",
		["Wandering Plague"] = "Бродячая чума",
		["Wands"] = "Жезлы",
		["War Stomp"] = "Громовая поступь",
		["Water Breathing"] = "Подводное дыхание",
		["Water Shield"] = "Водный щит",
		["Water Walking"] = "Хождение по воде",
		["Water"] = "Вода",
		["Waterbolt"] =	"Waterbolt", -- old
		["Wavering Will"] = "Нерешительность",
		["Weakened Soul"] = "Ослабленная душа",
		["Weaponsmith"] = "Оружейник",
		["Web Explosion"] = "Паутинный взрыв",
		["Web Spin"] = "Кружение паутины",
		["Web Spray"] = "Летящая паутина",
		["Web"] = "Сеть",
		["Whirling Barrage"] = "Крутящийся заряд",
		["Whirling Trip"] = "Крутящийся пробег",
		["Whirlwind"] = "Вихрь",
		["Wide Slash"] = "Широкий взмах",
		["Will of Hakkar"] = "Воля Хаккара",
		["Will of the Forsaken"] = "Воля Отрекшихся",
		["Windfury Totem"] = "Тотем неистовства ветра",
		["Windfury Weapon"] = "Оружие неистовства ветра",
		["Windsor's Frenzy"] = "Бешенство Виндзора",
		["Windwall Totem"] = "Тотем стены ветра",
		["Wing Clip"] = "Подрезать крылья",
		["Wing Flap"] = "Взмах крыла",
		["Winter's Chill"] = "Зимняя стужа",
		["Wisp Spirit"] = "Дух огонька",
		["Wolf Riding"] = "Верховая езда: волк",
		["Wound Poison II"] = "Нейтрализующий яд II",
		["Wound Poison III"] = "Нейтрализующий яд III",
		["Wound Poison IV"] = "Нейтрализующий яд IV",
		["Wound Poison"] = "Нейтрализующий яд",
		["Wrath of Air Totem"] = "Wrath of Air Totem", -- old
		["Wrath"] = "Гнев",
		["Wyvern Sting"] = "Укус виверны",
	}
end)

BabbleSpell:RegisterTranslations("deDE", function()
	return {
		["Abolish Disease"] = "Krankheit aufheben",
		["Abolish Poison Effect"] = "Vergiftung aufheben - Effekt",
		["Abolish Poison"] = "Vergiftung aufheben",
		["Acid Breath"] = "S\195\164ureatem",
		["Acid of Hakkar"] = "S\195\164ure von Hakkar",
		["Acid Spit"] = "S\195\164urespucke",
		["Acid Splash"] = "S\195\164urespritzer",
		["Activate MG Turret"] = "MG-Turm aktivieren",
		["Adrenaline Rush"] = "Adrenalinrausch",
		["Aftermath"] = "Nachwirkung",
		["Aggression"] = "Aggression",
		["Aimed Shot"] = "Gezielter Schuss",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Hinterhalt",
		["Amplify Curse"] = "Fluch verst\195\164rken",
		["Amplify Damage"] = "Schaden verst\195\164ken",
		["Amplify Flames"] = "Flammen verst\195\164rken",
		["Amplify Magic"] = "Magie verst\195\164rken",
		["Ancestral Healing"] = "Heilung der Ahnen",
		["Ancestral Knowledge"] = "Wissen der Ahnen",
		["Ancestral Spirit"] = "Geist der Ahnen",
		["Anesthetic Poison"] = "Anesthetic Poison",  --  Need to translated
		["Anger Management"] = "Aggressionskontrolle",
		["Anguish"] = "Anguish",  --  Need to translated
		["Anticipation"] = "Vorahnung",
		["Aqua Jet"] = "Wasserstrahl",
		["Aquatic Form"] = "Wassergestalt",
		["Arcane Blast"] = "Arcane Blast",  --  Need to translated
		["Arcane Bolt"] = "Arkanblitz",
		["Arcane Brilliance"] = "Arkane Brillanz",
		["Arcane Concentration"] = "Arkane Konzentration",
		["Arcane Explosion"] = "Arkane Explosion",
		["Arcane Focus"] = "Arkaner Fokus",
		["Arcane Instability"] = "Arkane Instabilit\195\164t",
		["Arcane Intellect"] = "Arkane Intelligenz",
		["Arcane Meditation"] = "Arkane Meditation",
		["Arcane Mind"] = "Arkaner Geist",
		["Arcane Missiles"] = "Arkane Geschosse",
		["Arcane Potency"] = "Arcane Potency",
		["Arcane Power"] = "Arkane Macht",
		["Arcane Resistance"] = "Arkanwiderstand",
		["Arcane Shot"] = "Arkaner Schuss",
		["Arcane Subtlety"] = "Arkanes Feingef\195\188hl",
		["Arcing Smash"] = "Bogenzerkracher",
		["Arctic Reach"] = "Arktische Reichweite",
		["Armorsmith"] = "R\195\188stungsschmied",
		["Arugal's Curse"] = "Arugals Fluch",
		["Arugal's Gift"] = "Arugals Gabe",
		["Aspect of Arlokk"] = "Aspekt von Arlokk",
		["Aspect of Jeklik"] = "Aspekt von Jeklik",
		["Aspect of Mar'li"] = "Aspekt von Mar'li",
		["Aspect of the Beast"] = "Aspekt des Wildtiers",
		["Aspect of the Cheetah"] = "Aspekt des Geparden",
		["Aspect of the Hawk"] = "Aspekt des Falken",
		["Aspect of the Monkey"] = "Aspekt des Affen",
		["Aspect of the Pack"] = "Aspekt des Rudels",
		["Aspect of the Viper"] = "Aspect of the Viper",  --  Need to translated
		["Aspect of the Wild"] = "Aspekt der Wildnis",
		["Aspect of Venoxis"] = "Aspekt von Venoxis",
		["Astral Recall"] = "Astraler R\195\188ckruf",
		["Attack"] = "Angreifen",
		["Attacking"] = "Angreifen",
		["Aura of Command"] = "Aura des Befehls",
		["Aural Shock"] = "Auraschock",
		["Auto Shot"] = "Autom. Schuss",
		["Avenger's Shield"] = "Avenger's Shield",  --  Need to translated
		["Avenging Wrath"] = "Avenging Wrath",  --  Need to translated
		["Axe Flurry"] = "Axtwirbel",
		["Axe Specialization"] = "Axt-Spezialisierung",
		["Axe Toss"] = "Axtwurf",
		["Backhand"] = "R\195\188ckhand",
		["Backlash"] = "Backlash",  --  Need to translated
		["Backstab"] = "Meucheln",
		["Bane"] = "Dunkle Macht",
		["Baneful Poison"] = "Erbarmungsloses Gift",
		["Banish"] = "Verbannen",
		["Banshee Curse"] = "Bansheefluch",
		["Banshee Shriek"] = "Bansheeschrei",
		["Barbed Sting"] = "Stachelstich",
		["Barkskin Effect"] = "Baumrindeneffekt",
		["Barkskin"] = "Baumrinde",
		["Barrage"] = "Sperrfeuer",
		["Bash"] = "Hieb",
		["Basic Campfire"] = "Einfaches Lagerfeuer",
		["Battle Shout"] = "Schlachtruf",
		["Battle Stance Passive"] = "Kampfhaltung Passiv",
		["Battle Stance"] = "Kampfhaltung",
		["Bear Form"] = "B\195\164rengestalt",
		["Beast Lore"] = "Wildtierkunde",
		["Beast Slaying"] = "Wildtierschl\195\164chter",
		["Beast Training"] = "Wildtierausbildung",
		["Befuddlement"] = "Verwirrtheit",
		["Benediction"] = "Segnung",
		["Berserker Charge"] = "Berserkeransturm",
		["Berserker Rage"] = "Berserkerwut",
		["Berserker Stance Passive"] = "Berserkerhaltung - Passiv",
		["Berserker Stance"] = "Berserkerhaltung",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Wildtierdisziplin",
		["Bestial Swiftness"] = "Erh\195\182hte Tiergeschwindigkeit",
		["Bestial Wrath"] = "Zorn des Wildtiers",
		["Biletoad Infection"] = "Gallkr\195\182ten-Infektion",
		["Binding Heal"] = "Binding Heal",  --  Need to translated
		["Bite"] = "Bei\195\159en",
		["Black Arrow"] = "Schwarzer Pfeil",
		["Blackout"] = "Blackout",
		["Blacksmithing"] = "Schmiedekunst",
		["Blade Flurry"] = "Klingenwirbel",
		["Blast Wave"] = "Druckwelle",
		["Blaze"] = "Feuermeer",
		["Blazing Speed"] = "Blazing Speed",  --  Need to translated
		["Blessed Recovery"] = "Gesegnete Erholung",
		["Blessing of Blackfathom"] = "Segen der Tiefschwarzen Grotte",
		["Blessing of Freedom"] = "Segen der Freiheit",
		["Blessing of Kings"] = "Segen der K\195\182nige",
		["Blessing of Light"] = "Segen des Lichts",
		["Blessing of Might"] = "Segen der Macht",
		["Blessing of Protection"] = "Segen des Schutzes",
		["Blessing of Sacrifice"] = "Segen der Opferung",
		["Blessing of Salvation"] = "Segen der Rettung",
		["Blessing of Sanctuary"] = "Segen des Refugiums",
		["Blessing of Shahram"] = "Segen von Shahram",
		["Blessing of Wisdom"] = "Segen der Weisheit",
		["Blind"] = "Blenden",
		["Blinding Powder"] = "Blendungspulver",
		["Blink"] = "Blinzeln",
		["Blizzard"] = "Blizzard",
		["Block"] = "Blocken",
		["Blood Craze"] = "Blutwahnsinn",
		["Blood Frenzy"] = "Blutraserei",
		["Blood Funnel"] = "Blutrichter",
		["Blood Fury"] = "Kochendes Blut",
		["Blood Leech"] = "Blutegel",
		["Blood Pact"] = "Blutpakt",
		["Blood Siphon"] = "Bluttrinker",
		["Blood Tap"] = "Blutwandlung",
		["Bloodrage"] = "Blutrausch",
		["Bloodthirst"] = "Blutdurst",
		["Bomb"] = "Bombe",
		["Booming Voice"] = "Donnernde Stimme",
		["Boulder"] = "Brocken",
		["Bow Specialization"] = "Bogenspezialisierung",
		["Bows"] = "Bogen",
		["Brain Wash"] = "Gehirnw\195\164sche",
		["Bright Campfire"] = "Helles Lagerfeuer",
		["Brutal Impact"] = "Brutaler Hieb",
		["Burning Adrenaline"] = "Burning Adrenaline",
		["Burning Soul"] = "Brennende Seele",
		["Burning Wish"] = "Burning Wish",
		["Butcher Drain"] = "Schl\195\164chtersauger",
		["Call of Flame"] = "Ruf der Flamme",
		["Call of the Grave"] = "Ruf des Grabes",
		["Call of Thunder"] = "Ruf des Donners",
		["Call Pet"] = "Tier rufen",
		["Camouflage"] = "Tarnung",
		["Cannibalize"] = "Kannibalismus",
		["Cat Form"] = "Katzengestalt",
		["Cataclysm"] = "Katastrophe",
		["Cause Insanity"] = "Wahnsinn verursachen",
		["Chain Bolt"] = "Kettenblitzschlag",
		["Chain Burn"] = "Kettenbrand",
		["Chain Heal"] = "Kettenheilung",
		["Chain Lightning"] = "Kettenblitzschlag",
		["Chained Bolt"] = "Kettenblitzschlag",
		["Chains of Ice"] = "Eisketten",
		["Challenging Roar"] = "Herausforderndes Gebr\195\188ll",
		["Challenging Shout"] = "Herausforderungsruf",
		["Charge Rage Bonus Effect"] = "Wut-Aufladung-Bonus-Effekt",
		["Charge Stun"] = "Sturmangriff \(Bet\195\164ubung\)",
		["Charge"] = "Sturmangriff",
		["Cheap Shot"] = "Fieser Trick",
		["Chilled"] = "K\195\164lte",
		["Chilling Touch"] = "Eiskalte Ber\195\188hrung",
		["Circle of Healing"] = "Circle of Healing",  --  Need to translated
		["Claw"] = "Klaue",
		["Cleanse Nova"] = "Reinigende Nova",
		["Cleanse"] = "Reinigung des Glaubens",
		["Clearcasting"] = "Freizaubern",
		["Cleave"] = "Spalten",
		["Clever Traps"] = "Falleneffizienz",
		["Cloak of Shadows"] = "Cloak of Shadows",  --  Need to translated
		["Closing"] = "Schlie\195\159en",
		["Cloth"] = "Stoff",
		["Cobra Reflexes"] = "Kobrareflexe",
		["Cold Blood"] = "Kaltbl\195\188tigkeit",
		["Cold Snap"] = "K\195\164lteeinbruch",
		["Combat Endurance"] = "Durchhalteverm\195\182gen des K\195\164mpfers",
		["Combustion"] = "Verbrennung",
		["Command"] = "Befehlsgewalt",
		["Concentration Aura"] = "Aura der Konzentration",
		["Concussion Blow"] = "Ersch\195\188tternder Schlag",
		["Concussion"] = "Ersch\195\188tterung",
		["Concussive Shot"] = "Ersch\195\188tternder Schuss",
		["Cone of Cold"] = "K\195\164ltekegel",
		["Conflagrate"] = "Feuersbrunst",
		["Conjure Food"] = "Essen herbeizaubern",
		["Conjure Mana Agate"] = "Mana-Achat herbeizaubern",
		["Conjure Mana Citrine"] = "Mana-Citrin herbeizaubern",
		["Conjure Mana Jade"] = "Mana-Jadestein herbeizaubern",
		["Conjure Mana Ruby"] = "Mana-Rubin herbeizaubern",
		["Conjure Water"] = "Wasser herbeizaubern",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone",  --  Need to translated
		["Consecration"] = "Weihe",
		["Consume Magic"] = "Consume Magic",  --  Need to translated
		["Consume Shadows"] = "Schatten verzehren",
		["Consuming Shadows"] = "Verzehrende Schatten",
		["Convection"] = "Konvektion",
		["Conviction"] = "\195\156berzeugung",
		["Cooking"] = "Kochkunst",
		["Corrosive Acid Breath"] = "\195\132tzender S\195\164ureatem",
		["Corrosive Ooze"] = "\195\132tzender Schlamm",
		["Corrosive Poison"] = "\195\132tzgift",
		["Corrupted Blood"] = "Verderbtes Blut",
		["Corruption"] = "Verderbnis",
		["Counterattack"] = "Gegenangriff",
		["Counterspell"] = "Gegenzauber",
		["Cower"] = "Ducken",
		["Create Firestone"] = "Feuerstein herstellen",
		["Create Healthstone"] = "Gesundheitsstein herstellen",
		["Create Soulstone"] = "Seelenstein herstellen",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)",  --  Need to translated
		["Create Spellstone"] = "Zauberstein herstellen",
		["Creeper Venom"] = "Krabblergift",
		["Cripple"] = "Verkr\195\188ppeln",
		["Crippling Poison II"] = "Verkr\195\188ppelndes Gift II",
		["Crippling Poison"] = "Verkr\195\188ppelndes Gift",
		["Critical Mass"] = "Kritische Masse",
		["Crossbows"] = "Armbr\195\188ste",
		["Crowd Pummel"] = "Meute verpr\195\188geln",
		["Cruelty"] = "Grausamkeit",
		["Crusader Aura"] = "Crusader Aura",  --  Need to translated
		["Crusader Strike"] = "Kreuzfahrersto\195\159",
		["Crystal Charge"] = "Kristallsprengladung",
		["Crystal Force"] = "Kristallkraft",
		["Crystal Restore"] = "Kristallflicker",
		["Crystal Spire"] = "Kristallspitze",
		["Crystal Ward"] = "Kristallbarriere",
		["Crystal Yield"] = "Kristallschw\195\164cher",
		["Crystalline Slumber"] = "Kristallener Schlummer",
		["Cultivation"] = "Gr\195\188ner Daumen",
		["Cure Disease"] = "Krankheit heilen",
		["Cure Poison"] = "Vergiftung heilen",
		["Curse of Agony"] = "Fluch der Pein",
		["Curse of Blood"] = "Blutfluch",
		["Curse of Doom Effect"] = "Fluch der Verdammnis'-Effekt",
		["Curse of Doom"] = "Fluch der Verdammnis",
		["Curse of Exhaustion"] = "Fluch der Ersch\195\182pfung",
		["Curse of Idiocy"] = "Fluch der Torheit",
		["Curse of Recklessness"] = "Fluch der Tollk\195\188hnheit",
		["Curse of Shadow"] = "Schattenfluch",
		["Curse of the Elemental Lord"] = "Fluch des Elementarlords",
		["Curse of the Elements"] = "Fluch der Elemente",
		["Curse of Tongues"] = "Fluch der Sprachen",
		["Curse of Tuten'kash"] = "Fluch von Tuten'kash",
		["Curse of Weakness"] = "Fluch der Schw\195\164che",
		["Cursed Blood"] = "Verfluchtes Blut",
		["Dagger Specialization"] = "Dolch-Spezialisierung",
		["Daggers"] = "Dolche",
		["Dampen Magic"] = "Magie d\195\164mpfen",
		["Dark Iron Bomb"] = "Dunkeleisenbombe",
		["Dark Offering"] = "Dunkles Angebot",
		["Dark Pact"] = "Dunkler Pakt",
		["Darkness"] = "Dunkelheit",
		["Dash"] = "Spurt",
		["Dazed"] = "Benommen",
		["Deadly Poison II"] = "T\195\182dliches Gift II",
		["Deadly Poison III"] = "T\195\182dliches Gift III",
		["Deadly Poison IV"] = "T\195\182dliches Gift IV",
		["Deadly Poison V"] = "T\195\182dliches Gift V",
		["Deadly Poison"] = "T\195\182dliches Gift",
		["Deadly Throw"] = "Deadly Throw",  --  Need to translated
		["Death Coil"] = "Todesmantel",
		["Death Wish"] = "Todeswunsch",
		["Deep Sleep"] = "Tiefer Schlaf",
		["Deep Slumber"] = "Tiefer Schlummer",
		["Deep Wounds"] = "Tiefe Wunden",
		["Defense"] = "Verteidigung",
		["Defensive Stance Passive"] = "Verteidigungshaltung - Passiv",
		["Defensive Stance"] = "Verteidigungshaltung",
		["Defensive State 2"] = "Verteidigungsstatus 2",
		["Defensive State"] = "Verteidigungsstatus",
		["Defiance"] = "Trotz",
		["Deflection"] = "Abwehr",
		["Delusions of Jin'do"] = "Irrbilder von Jin'do",
		["Demon Armor"] = "D\195\164monenr\195\188stung",
		["Demon Skin"] = "D\195\164monenhaut",
		["Demonic Embrace"] = "D\195\164monische Umarmung",
		["Demonic Sacrifice"] = "D\195\164monische Opferung",
		["Demoralizing Roar"] = "Demoralisierendes Gebr\195\188ll",
		["Demoralizing Shout"] = "Demoralisierungsruf",
		["Desperate Prayer"] = "Verzweifeltes Gebet",
		["Destructive Reach"] = "Zerst\195\182rerische Reichweite",
		["Detect Greater Invisibility"] = "Gro\195\159e Unsichtbarkeit entdecken",
		["Detect Invisibility"] = "Unsichtbarkeit entdecken",
		["Detect Lesser Invisibility"] = "Geringe Unsichtbarkeit entdecken",
		["Detect Magic"] = "Magie entdecken",
		["Detect Traps"] = "Fallen entdecken",
		["Detect"] = "Entdecken",
		["Deterrence"] = "Abschreckung",
		["Detonation"] = "Detonation",
		["Devastation"] = "Verw\195\188stung",
		["Devotion Aura"] = "Aura der Hingabe",
		["Devour Magic Effect"] = "Magie verschlingen' - Effekt",
		["Devour Magic"] = "Magie verschlingen",
		["Devouring Plague"] = "Verschlingende Seuche",
		["Diamond Flask"] = "Diamantenfl\195\164schchen",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Terrorb\195\164rengestalt",
		["Dire Growl"] = "Terrorknurren",
		["Disarm Trap"] = "Falle entsch\195\164rfen",
		["Disarm"] = "Entwaffnen",
		["Disease Cleansing Totem"] = "Totem der Krankheitsreinigung",
		["Disease Cloud"] = "Krankheitswolke",
		["Diseased Shot"] = "Krankheitsschuss",
		["Diseased Spit"] = "Verseuchte Spucke",
		["Disenchant"] = "Entzaubern",
		["Disengage"] = "R\195\188ckzug",
		["Disjunction"] = "Abtrennung",
		["Dismiss Pet"] = "Tier freigeben",
		["Dispel Magic"] = "Magiebannung",
		["Distract"] = "Ablenken",
		["Distracting Pain"] = "Ablenkender Schmerz",
		["Distracting Shot"] = "Ablenkender Schuss",
		["Dive"] = "Sturzflug",
		["Divine Favor"] = "G\195\182ttliche Gunst",
		["Divine Fury"] = "G\195\182ttlicher Furor",
		["Divine Illumination"] = "Divine Illumination",  --  Need to translated
		["Divine Intellect"] = "G\195\182ttliche Weisheit",
		["Divine Intervention"] = "G\195\182ttliches Eingreifen",
		["Divine Protection"] = "G\195\182ttlicher Schutz",
		["Divine Shield"] = "Gottesschild",
		["Divine Spirit"] = "G\195\182ttlicher Willen",
		["Divine Strength"] = "G\195\182ttliche St\195\164rke",
		["Diving Sweep"] = "Tauch-Rundschlag",
		["Dodge"] = "Ausweichen",
		["Dominate Mind"] = "Gedanken beherrschen",
		["Dragon's Breath"] = "Dragon's Breath",  --  Need to translated
		["Dragonscale Leatherworking"] = "Drachenschuppenlederverarbeitung",
		["Drain Life"] = "Blutsauger",
		["Drain Mana"] = "Mana entziehen",
		["Drain Soul"] = "Seelendieb",
		["Dredge Sickness"] = "Baggererkrankung",
		["Drink"] = "Trinken",
		["Druid's Slumber"] = "Druidenschlummer",
		["Dual Wield Specialization"] = "Beidh\195\164ndigkeits-Spezialisierung",
		["Dual Wield"] = "Beidh\195\164ndigkeit",
		["Duel"] = "Duell",
		["Dust Field"] = "Staubfeld",
		["Eagle Eye"] = "Adlerauge",
		["Earth Elemental Totem"] = "Earth Elemental Totem",  --  Need to translated
		["Earth Shield"] = "Earth Shield",  --  Need to translated
		["Earth Shock"] = "Erdschock",
		["Earthbind Totem"] = "Totem der Erdbindung",
		["Earthborer Acid"] = "Erdbohrers\195\164ure",
		["Earthgrab"] = "Erdengriff",
		["Efficiency"] = "Effizienz",
		["Electric Discharge"] = "Elektrische Entladung",
		["Electrified Net"] = "Elektrifiziertes Netz",
		["Elemental Focus"] = "Elementarfokus",
		["Elemental Fury"] = "Elementarfuror",
		["Elemental Leatherworking"] = "Elementarlederverarbeitung",
		["Elemental Mastery"] = "Elementarbeherrschung",
		["Elemental Precision"] = "Elemental Precision",
		["Elune's Grace"] = "Elunes Anmut",
		["Elusiveness"] = "Fl\195\188chtigkeit",
		["Emberstorm"] = "Glutsturm",
		["Enamored Water Spirit"] = "Enamored Water Spirit",  --  Need to translated
		["Enchanting"] = "Verzauberkunst",
		["Endurance Training"] = "Belastbarkeit-Ausbildung",
		["Endurance"] = "Durchhalteverm\195\182gen",
		["Engineering Specialization"] = "Technologist",
		["Engineering"] = "Ingenieurskunst",
		["Enrage"] = "Wutanfall",
		["Enriched Manna Biscuit"] = "Angereicherter Manakeks",
		["Enslave Demon"] = "D\195\164monensklave",
		["Entangling Roots"] = "Wucherwurzeln",
		["Entrapment"] = "Einfangen",
		["Enveloping Web"] = "Einh\195\188llendes Gespinst",
		["Enveloping Webs"] = "Einh\195\188llende Gespinste",
		["Enveloping Winds"] = "Einh\195\188llende Winde",
		["Envenom"] = "Envenom",  --  Need to translated
		["Escape Artist"] = "Entfesselungsk\195\188nstler",
		["Evasion"] = "Entrinnen",
		["Eventide"] = "Eventide",  --  Need to translated
		["Eviscerate"] = "Ausweiden",
		["Evocation"] = "Hervorrufung",
		["Execute"] = "Hinrichten",
		["Exorcism"] = "Exorzismus",
		["Expansive Mind"] = "Wacher Geist",
		["Exploding Shot"] = "Explosivgeschoss",
		["Exploit Weakness"] = "Schw\195\164che ausnutzen",
		["Explosive Shot"] = "Explosivschuss",
		["Explosive Trap Effect"] = "Sprengfalle'-Effekt",
		["Explosive Trap"] = "Sprengfalle",
		["Expose Armor"] = "R\195\188stung schw\195\164chen",
		["Expose Weakness"] = "Schw\195\164che aufdecken",
		["Eye for an Eye"] = "Auge um Auge",
		["Eye of Kilrogg"] = "Auge von Kilrogg",
		["Eyes of the Beast"] = "Augen des Wildtiers",
		["Fade"] = "Verblassen",
		["Faerie Fire (Feral)"] = "Faerie Fire (Feral)",
		["Faerie Fire"] = "Feenfeuer",
		["Far Sight"] = "Fernsicht",
		["Fatal Bite"] = "T\195\182dlicher Biss",
		["Fear Ward"] = "Furchtzauberschutz",
		["Fear"] = "Furcht",
		["Feed Pet"] = "Tier f\195\188ttern",
		["Feedback"] = "R\195\188ckkopplung",
		["Feign Death"] = "Totstellen",
		["Feint"] = "Finte",
		["Fel Armor"] = "Fel Armor",  --  Need to translated
		["Fel Concentration"] = "Teufelskonzentration",
		["Fel Domination"] = "Teufelsbeherrschung",
		["Fel Intellect"] = "Teufelsintelligenz",
		["Fel Stamina"] = "Teufelsausdauer",
		["Fel Stomp"] = "Teufelsstampfen",
		["Felfire"] = "Teufelsfeuer",
		["Feline Grace"] = "Katzenhafte Anmut",
		["Feline Swiftness"] = "Katzenhafte Schnelligkeit",
		["Feral Aggression"] = "Wilde Aggression",
		["Feral Charge"] = "Wilde Attacke",
		["Feral Instinct"] = "Instinkt der Wildnis",
		["Ferocious Bite"] = "Wilder Biss",
		["Ferocity"] = "Wildheit",
		["Fetish"] = "Fetisch",
		["Fevered Plague"] = "Fieberseuche",
		["Fiery Burst"] = "Feuerexplosion",
		["Find Herbs"] = "Kr\195\164utersuche",
		["Find Minerals"] = "Mineraliensuche",
		["Find Treasure"] = "Schatzsucher",
		["Fire Blast"] = "Feuerschlag",
		["Fire Elemental Totem"] = "Fire Elemental Totem",  --  Need to translated
		["Fire Nova Totem"] = "Totem der Feuernova",
		["Fire Nova"] = "Feuernova",
		["Fire Power"] = "Feuermacht",
		["Fire Resistance Aura"] = "Aura des Feuerwiderstands",
		["Fire Resistance Totem"] = "Totem des Feuerwiderstands",
		["Fire Resistance"] = "Feuerwiderstand",
		["Fire Shield Effect II"] = "Feuerschild",
		["Fire Shield Effect III"] = "Feuerschild",
		["Fire Shield Effect IV"] = "Feuerschild",
		["Fire Shield Effect"] = "Feuerschild",
		["Fire Shield"] = "Feuerschild",
		["Fire Storm"] = "Feuersturm",
		["Fire Vulnerability"] = "Feuerverwundbarkeit",
		["Fire Ward"] = "Feuerzauberschutz",
		["Fire Weakness"] = "Fire Weakness",
		["Fireball Volley"] = "Feuerballsalve",
		["Fireball"] = "Feuerball",
		["Firebolt"] = "Feuerblitz",
		["First Aid"] = "Erste Hilfe",
		["Fishing Poles"] = "Angeln",
		["Fishing"] = "Angeln",
		["Fist of Ragnaros"] = "Faust des Ragnaros",
		["Fist Weapon Specialization"] = "Faustwaffen-Spezialisierung",
		["Fist Weapons"] = "Faustwaffen",
		["Flame Buffet"] = "Flammenpuffer",
		["Flame Cannon"] = "Flammenkanone",
		["Flame Lash"] = "Flammenpeitsche",
		["Flame Shock"] = "Flammenschock",
		["Flame Spike"] = "Flammenstachel",
		["Flame Spray"] = "Flammenspr\195\188hen",
		["Flame Throwing"] = "Flammenwerfen",
		["Flames of Shahram"] = "Flammen von Shahram",
		["Flamestrike"] = "Flammensto\195\159",
		["Flamethrower"] = "Flammenwerfer",
		["Flametongue Totem"] = "Totem der Flammenzunge",
		["Flametongue Weapon"] = "Waffe der Flammenzunge",
		["Flare"] = "Leuchtfeuer",
		["Flash Bomb"] = "Blitzbombe",
		["Flash Heal"] = "Blitzheilung",
		["Flash of Light"] = "Lichtblitz",
		["Flight Form"] = "Flight Form",  --  Need to translated
		["Flurry"] = "Schlaghagel",
		["Focused Casting"] = "Fokussiertes Zauberwirken",
		["Focused Mind"] = "Focused Mind",
		["Food"] = "Essen",
		["Forbearance"] = "Vorahnung",
		["Force of Nature"] = "Force of Nature",
		["Force of Will"] = "Macht des Willens",
		["Force Punch"] = "Machthieb",
		["Force Reactive Disk"] = "Machtreaktive Scheibe",
		["Forked Lightning"] = "Gabelblitzschlag",
		["Forsaken Skills"] = "Verlassene F\195\164higkeit",
		["Frailty"] = "Gebrechlichkeit",
		["Freeze Solid"] = "Zu Eis erstarren",
		["Freezing Trap Effect"] = "Eisk?tefalle",
		["Freezing Trap"] = "Eisk\195\164ltefalle",
		["Frenzied Regeneration"] = "Rasende Regeneration",
		["Frenzy"] = "Raserei",
		["Frost Armor"] = "Frostr\195\188stung",
		["Frost Breath"] = "Frostatem",
		["Frost Channeling"] = "Frost-Kanalisierung",
		["Frost Nova"] = "Frostnova",
		["Frost Resistance Aura"] = "Aura des Frostwiderstands",
		["Frost Resistance Totem"] = "Totem des Frostwiderstands",
		["Frost Resistance"] = "Frostwiderstand",
		["Frost Shock"] = "Frostschock",
		["Frost Shot"] = "Frostschuss",
		["Frost Trap Aura"] = "Frost Trap Aura",
		["Frost Trap"] = "Frostfalle",
		["Frost Ward"] = "Frostzauberschutz",
		["Frost Warding"] = "Frost Warding",
		["Frost Weakness"] = "Frost Weakness",
		["Frostbite"] = "Erfrierung",
		["Frostbolt Volley"] = "Frostblitzsalve",
		["Frostbolt"] = "Frostblitz",
		["Frostbrand Weapon"] = "Waffe des Frostbrands",
		["Furious Howl"] = "Wutgeheul",
		["Furor"] = "Furor",
		["Fury of Ragnaros"] = "Furor des Ragnaros",
		["Gahz'ranka Slam"] = "Gahz'rankaschlag",
		["Gahz'rilla Slam"] = "Gahz'rillas Schmetterschlag",
		["Garrote"] = "Erdrosseln",
		["Generic"] = "Allgemein",
		["Ghost Wolf"] = "Geisterwolf",
		["Ghostly Strike"] = "Geisterhafter Sto\195\159",
		["Gift of Life"] = "Geschenk des Lebens",
		["Gift of Nature"] = "Geschenk der Natur",
		["Gift of the Wild"] = "Gabe der Wildnis",
		["Goblin Dragon Gun"] = "Goblindrachengewehr",
		["Goblin Sapper Charge"] = "Goblinpioniersprengladung",
		["Gouge"] = "Solarplexus",
		["Grace of Air Totem"] = "Totem der luftgleichen Anmut",
		["Grasping Vines"] = "Greifende Ranken",
		["Great Stamina"] = "Gro\195\159e Ausdauer",
		["Greater Blessing of Kings"] = "Gro\195\159er Segen der K\195\182nige",
		["Greater Blessing of Light"] = "Gro\195\159er Segen des Lichts",
		["Greater Blessing of Might"] = "Gro\195\159er Segen der Macht",
		["Greater Blessing of Salvation"] = "Gro\195\159er Segen der Rettung",
		["Greater Blessing of Sanctuary"] = "Gro\195\159er Segen des Refugiums",
		["Greater Blessing of Wisdom"] = "Gro\195\159er Segen der Weisheit",
		["Greater Heal"] = "Gro\195\159e Heilung",
		["Grim Reach"] = "Grimmige Reichweite",
		["Ground Tremor"] = "Bebende Erde",
		["Grounding Totem"] = "Totem der Erdung",
		["Grovel"] = "Kriechen",
		["Growl"] = "Knurren",
		["Guardian's Favor"] = "Gunst des H\195\188ters",
		["Guillotine"] = "Guillotine",
		["Gun Specialization"] = "Schusswaffenspezialisierung",
		["Guns"] = "Schusswaffen",
		["Hail Storm"] = "Hagelsturm",
		["Hammer of Justice"] = "Hammer der Gerechtigkeit",
		["Hammer of Wrath"] = "Hammer des Zorns",
		["Hamstring"] = "Kniesehne",
		["Harass"] = "Bel\195\164stigen",
		["Hardiness"] = "Z\195\164higkeit",
		["Haunting Spirits"] = "Spukgeister",
		["Hawk Eye"] = "Falkenauge",
		["Head Crack"] = "Kopfkracher",
		["Heal"] = "Heilen",
		["Healing Circle"] = "Kreis der Heilung",
		["Healing Focus"] = "Heilfokus",
		["Healing Light"] = "Heilendes Licht",
		["Healing Stream Totem"] = "Totem des heilenden Flusses",
		["Healing Touch"] = "Heilende Ber\195\188hrung",
		["Healing Wave"] = "Welle der Heilung",
		["Healing Way"] = "Healing Way",
		["Health Funnel"] = "Lebenslinie",
		["Heart of the Wild"] = "Herz der Wildnis",
		["Hellfire Effect"] = "H\195\182llenfeuer - Effekt",
		["Hellfire"] = "H\195\182llenfeuer",
		["Hemorrhage"] = "Blutsturz",
		["Herbalism"] = "Kr\195\164utersammeln",
		["Heroic Strike"] = "Heldenhafter Sto\195\159",
		["Heroism"] = "Heroism",
		["Hex of Jammal'an"] = "Verhexung von Jammal'an",
		["Hex of Weakness"] = "Verhexung der Schw\195\164che",
		["Hex"] = "Verhexung",
		["Hibernate"] = "Winterschlaf",
		["Holy Fire"] = "Heiliges Feuer",
		["Holy Light"] = "Heiliges Licht",
		["Holy Nova"] = "Heilige Nova",
		["Holy Power"] = "Heilige Macht",
		["Holy Reach"] = "Heilige Reichweite",
		["Holy Shield"] = "Heiliger Schild",
		["Holy Shock"] = "Heiliger Schock",
		["Holy Smite"] = "Heilige Pein",
		["Holy Specialization"] = "Macht des Glaubens",
		["Holy Strength"] = "Heilige St\195\164rke",
		["Holy Strike"] = "Heiliger Sto\195\159",
		["Holy Wrath"] = "Heiliger Zorn",
		["Honorless Target"] = "Ehrenloses Ziel",
		["Hooked Net"] = "Hakennetz",
		["Horse Riding"] = "Pferdreiten",
		["Howl of Terror"] = "Schreckgeheul",
		["Humanoid Slaying"] = "Humanoident\195\182ten",
		["Hunter's Mark"] = "Mal des J\195\164gers",
		["Hurricane"] = "Hurrikan",
		["Ice Armor"] = "Eisr\195\188stung",
		["Ice Barrier"] = "Eis-Barriere",
		["Ice Blast"] = "Eisschlag",
		["Ice Block"] = "Eisblock",
		["Ice Lance"] = "Ice Lance",  --  Need to translated
		["Ice Nova"] = "Eisnova",
		["Ice Shards"] = "Eissplitter",
		["Icicle"] = "Eiszapfen",
		["Ignite"] = "Entz\195\188nden",
		["Illumination"] = "Illumination",
		["Immolate"] = "Feuerbrand",
		["Immolation Trap Effect"] = "Feuerbrandfalle",
		["Immolation Trap"] = "Feuerbrandfalle",
		["Impact"] = "Einschlag",
		["Impale"] = "Durchbohren",
		["Improved Ambush"] = "Verbesserter Hinterhalt",
		["Improved Arcane Explosion"] = "Verbesserte Arkane Explosion",
		["Improved Arcane Missiles"] = "Verbesserte arkane Geschosse",
		["Improved Arcane Shot"] = "Verbesserter Arkaner Schuss",
		["Improved Aspect of the Hawk"] = "Verbesserter Aspekt des Falken",
		["Improved Aspect of the Monkey"] = "Verbesserter Aspekt des Affen",
		["Improved Backstab"] = "Verbessertes Meucheln",
		["Improved Battle Shout"] = "Verbesserter Schlachtruf",
		["Improved Berserker Rage"] = "Verbesserte Berserkerwut",
		["Improved Blessing of Might"] = "Verbesserter Segen der Macht",
		["Improved Blessing of Wisdom"] = "Verbesserter Segen der Weisheit",
		["Improved Blizzard"] = "Verbesserter Blizzard",
		["Improved Bloodrage"] = "Verbesserter Blutrausch",
		["Improved Chain Heal"] = "Verbesserte Kettenheilung",
		["Improved Chain Lightning"] = "Verbesserter Kettenblitzschlag",
		["Improved Challenging Shout"] = "Verbesserter Herausforderungsruf",
		["Improved Charge"] = "Verbesserter Sturmangriff",
		["Improved Cheap Shot"] = "Improved Cheap Shot",  --  Need to translated
		["Improved Cleave"] = "Verbessertes Spalten",
		["Improved Concentration Aura"] = "Verbesserte Aura der Konzentration",
		["Improved Concussive Shot"] = "Verbesserter Ersch\195\188tternder Schuss",
		["Improved Cone of Cold"] = "Verbesserter K\195\164ltekegel",
		["Improved Corruption"] = "Verbesserte Verderbnis",
		["Improved Counterspell"] = "Verbesserter Gegenzauber",
		["Improved Curse of Agony"] = "Verbesserter Fluch der Pein",
		["Improved Curse of Exhaustion"] = "Verbesserter Fluch der Ersch\195\182pfung",
		["Improved Curse of Weakness"] = "Verbesserter Fluch der Schw\195\164che",
		["Improved Dampen Magic"] = "Improved Dampen Magic",  --  Need to translated
		["Improved Deadly Poison"] = "Verbessertes t\195\182dliches Gift",
		["Improved Demoralizing Shout"] = "Verbesserter Demoralisierender Ruf",
		["Improved Devotion Aura"] = "Verbesserte Aura der Hingabe",
		["Improved Disarm"] = "Verbessertes Entwaffnen",
		["Improved Distract"] = "Verbessertes Ablenken",
		["Improved Drain Life"] = "Verbesserter Blutsauger",
		["Improved Drain Mana"] = "Verbessertes Mana entziehen",
		["Improved Drain Soul"] = "Verbesserter Seelendieb",
		["Improved Enrage"] = "Verbesserter Wutanfall",
		["Improved Enslave Demon"] = "Verbesserter D\195\164monensklave",
		["Improved Entangling Roots"] = "Verbesserte Wucherwurzeln",
		["Improved Evasion"] = "Improved Evasion",  --  Need to translated
		["Improved Eviscerate"] = "Verbessertes Ausweiden",
		["Improved Execute"] = "Verbessertes Hinrichten",
		["Improved Expose Armor"] = "Verbessertes R\195\188stung schw\195\164chen",
		["Improved Eyes of the Beast"] = "Verbesserte Augen des Wildtiers",
		["Improved Fade"] = "Verbessertes Verblassen",
		["Improved Feign Death"] = "Verbessertes Totstellen",
		["Improved Fire Blast"] = "Verbesserter Feuerschlag",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem",  --  Need to translated
		["Improved Fire Ward"] = "Verbesserter Feuerzauberschutz",
		["Improved Fireball"] = "Verbesserter Feuerball",
		["Improved Firebolt"] = "Verbesserter Feuerblitz",
		["Improved Firestone"] = "Verbesserter Feuerstein",
		["Improved Flamestrike"] = "Verbesserter Flammensto\195\159",
		["Improved Flametongue Weapon"] = "Verbesserte Waffe der Flammenzunge",
		["Improved Flash of Light"] = "Verbesserter Lichtblitz",
		["Improved Frost Nova"] = "Verbesserte Frostnova",
		["Improved Frost Ward"] = "Verbesserter Frostzauberschutz",
		["Improved Frostbolt"] = "Verbesserter Frostblitz",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon",  --  Need to translated
		["Improved Garrote"] = "Improved Garrote",  --  Need to translated
		["Improved Ghost Wolf"] = "Verbesserter Geisterwolf",
		["Improved Gouge"] = "Verbesserter Solarplexus",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem",  --  Need to translated
		["Improved Grounding Totem"] = "Improved Grounding Totem",  --  Need to translated
		["Improved Hammer of Justice"] = "Verbesserter Hammer der Gerechtigkeit",
		["Improved Hamstring"] = "Verbesserte Kniesehne",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem",  --  Need to translated
		["Improved Healing Touch"] = "Verbesserte Heilende Ber\195\188hrung",
		["Improved Healing Wave"] = "Verbesserte Welle der Heilung",
		["Improved Healing"] = "Verbesserte Heilung",
		["Improved Health Funnel"] = "Verbesserte Lebenslinie",
		["Improved Healthstone"] = "Verbesserter Gesundheitsstein",
		["Improved Heroic Strike"] = "Verbesserter Heldenhafter Sto\195\159",
		["Improved Hunter's Mark"] = "Verbessertes Mal des J\195\164gers",
		["Improved Immolate"] = "Verbesserter Feuerbrand",
		["Improved Imp"] = "Verbesserter Wichtel",
		["Improved Inner Fire"] = "Verbessertes Inneres Feuer",
		["Improved Instant Poison"] = "Improved Instant Poison",  --  Need to translated
		["Improved Intercept"] = "Verbessertes Abfangen",
		["Improved Intimidating Shout"] = "Verbesserter Drohruf",
		["Improved Judgement"] = "Verbessertes Richturteil",
		["Improved Kick"] = "Verbesserter Tritt",
		["Improved Kidney Shot"] = "Verbesserter Nierenhieb",
		["Improved Lash of Pain"] = "Verbesserte Schmerzenspeitsche",
		["Improved Lay on Hands"] = "Verbesserte Handauflegung",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave",  --  Need to translated
		["Improved Life Tap"] = "Verbesserter Aderlass",
		["Improved Lightning Bolt"] = "Verbesserter Blitzschlag",
		["Improved Lightning Shield"] = "Verbesserter Blitzschlag-Schild",
		["Improved Magma Totem"] = "Verbessertes Totem der gl\195\188henden Magma",
		["Improved Mana Burn"] = "Verbesserter Manabrand",
		["Improved Mana Shield"] = "Verbesserter Manaschild",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem",  --  Need to translated
		["Improved Mark of the Wild"] = "Verbessertes Mal der Wildnis",
		["Improved Mend Pet"] = "Verbessertes Tier heilen",
		["Improved Mind Blast"] = "Verbesserter Gedankenschlag",
		["Improved Moonfire"] = "Verbessertes Mondfeuer",
		["Improved Nature's Grasp"] = "Verbesserter Griff der Natur",
		["Improved Overpower"] = "Verbessertes \195\156berw\195\164ltigen",
		["Improved Power Word: Fortitude"] = "Verbessertes Machtwort: Seelenst\195\164rke",
		["Improved Power Word: Shield"] = "Verbessertes Machtwort: Schild",
		["Improved Prayer of Healing"] = "Verbessertes Gebet der Heilung",
		["Improved Psychic Scream"] = "Verbesserter Psychischer Schrei",
		["Improved Pummel"] = "Verbessertes Zuschlagen",
		["Improved Regrowth"] = "Verbessertes Nachwachsen",
		["Improved Reincarnation"] = "Verbesserte Reinkarnation",
		["Improved Rejuvenation"] = "Verbesserte Verj\195\188ngung",
		["Improved Rend"] = "Verbessertes Verwunden",
		["Improved Renew"] = "Verbesserte Erneuerung",
		["Improved Retribution Aura"] = "Verbesserte Aura der Vergeltung",
		["Improved Revenge"] = "Verbesserte Rache",
		["Improved Revive Pet"] = "Verbessertes Tier wiederbeleben",
		["Improved Righteous Fury"] = "Verbesserter Zorn der Gerechtigkeit",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon",  --  Need to translated
		["Improved Rupture"] = "Verbesserte Blutung",
		["Improved Sap"] = "Verbesserte Kopfnuss",
		["Improved Scorch"] = "Verbessertes Versengen",
		["Improved Scorpid Sting"] = "Verbesserter Skorpidstich",
		["Improved Seal of Righteousness"] = "Verbessertes Siegel der Rechtschaffenheit",
		["Improved Seal of the Crusader"] = "Verbessertes Siegel des Kreuzfahrers",
		["Improved Searing Pain"] = "Verbesserter Sengender Schmerz",
		["Improved Searing Totem"] = "Improved Searing Totem",  --  Need to translated
		["Improved Serpent Sting"] = "Verbesserter Schlangenbiss",
		["Improved Shadow Bolt"] = "Verbesserter Schattenblitz",
		["Improved Shadow Word: Pain"] = "Verbessertes Schattenwort: Schmerz",
		["Improved Shield Bash"] = "Verbesserter Schildhieb",
		["Improved Shield Block"] = "Verbesserter Schildblock",
		["Improved Shield Wall"] = "Verbesserter Schildwall",
		["Improved Shred"] = "Verbessertes Schreddern",
		["Improved Sinister Strike"] = "Verbesserter Finsterer Sto\195\159",
		["Improved Slam"] = "Verbessertes Zerschmettern",
		["Improved Slice and Dice"] = "Verbessertes Zerh\195\164ckseln",
		["Improved Spellstone"] = "Verbesserter Zauberstein",
		["Improved Sprint"] = "Verbessertes Sprinten",
		["Improved Starfire"] = "Verbessertes Sternenfeuer",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem",  --  Need to translated
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem",  --  Need to translated
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem",  --  Need to translated
		["Improved Succubus"] = "Verbesserter Sukkubus",
		["Improved Sunder Armor"] = "Verbessertes R\195\188stung zerrei\195\159en",
		["Improved Taunt"] = "Verbesserter Spott",
		["Improved Thorns"] = "Verbesserte Dornen",
		["Improved Thunder Clap"] = "Verbesserter Donnerknall",
		["Improved Tranquility"] = "Verbesserte Gelassenheit",
		["Improved Vampiric Embrace"] = "Verbesserte Vampirumarmung",
		["Improved Vanish"] = "Verbessertes Verschwinden",
		["Improved Voidwalker"] = "Verbesserter Leerwandler",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon",  --  Need to translated
		["Improved Wing Clip"] = "Verbessertes Zurechtstutzen",
		["Improved Wrath"] = "Verbesserter Zorn",
		["Incinerate"] = "Verbrennen",
		["Infected Bite"] = "Infizierter Biss",
		["Infected Wound"] = "Infizierte Wunde",
		["Inferno Shell"] = "Infernoschild",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Inneres Feuer",
		["Inner Focus"] = "Innerer Fokus",
		["Innervate"] = "Anregen",
		["Insect Swarm"] = "Insektenschwarm",
		["Inspiration"] = "Inspiration",
		["Instant Poison II"] = "Sofort wirkendes Gift II",
		["Instant Poison III"] = "Sofort wirkendes Gift III",
		["Instant Poison IV"] = "Sofort wirkendes Gift IV",
		["Instant Poison V"] = "Sofort wirkendes Gift V",
		["Instant Poison VI"] = "Sofort wirkendes Gift VI",
		["Instant Poison"] = "Sofort wirkendes Gift",
		["Intensity"] = "Intensit\195\164t",
		["Intercept Stun"] = "Bet\195\164ubung Abfangen",
		["Intercept"] = "Abfangen",
		["Intervene"] = "Intervene",  --  Need to translated
		["Intimidating Roar"] = "Einsch\195\188chterndes Gebr\195\188ll",
		["Intimidating Shout"] = "Drohruf",
		["Intimidation"] = "Einsch\195\188chterung",
		["Intoxicating Venom"] = "Berauschendes Gift",
		["Invisibility"] = "Invisibility",  --  Need to translated
		["Iron Will"] = "Eiserner Wille",                                -- NEED GERMAN TRANSLATION
		["Jewelcrafting"] = "Jewelcrafting",
		["Judgement of Command"] = "Richturteil des Befehls",
		["Judgement of Justice"] = "Richturteil der Gerechtigkeit",
		["Judgement of Light"] = "Richturteil des Lichts",
		["Judgement of Righteousness"] = "Richturteil der Rechtschaffenheit",
		["Judgement of the Crusader"] = "Richturteil des Kreuzfahrers",
		["Judgement of Wisdom"] = "Richturteil der Weisheit",
		["Judgement"] = "Richturteil",
		["Kick - Silenced"] = "Kick - Silenced",
		["Kick"] = "Tritt",
		["Kidney Shot"] = "Nierenhieb",
		["Kill Command"] = "Kill Command",  --  Need to translated
		["Killer Instinct"] = "T\195\182tungstrieb",
		["Knock Away"] = "Wegschlagen",
		["Knockdown"] = "Niederschlagen",
		["Kodo Riding"] = "Kodoreiten",
		["Lacerate"] = "Lacerate",
		["Lacerate"] = "Lacerate",  --  Need to translated
		["Larva Goo"] = "Larvenglibber",
		["Lash of Pain"] = "Schmerzenspeitsche",
		["Lash"] = "Peitsche",
		["Last Stand"] = "Letztes Gefecht",
		["Lasting Judgement"] = "Dauerhaftes Richturteil",
		["Lava Spout Totem"] = "Totem des Lavaschwalls",
		["Lay on Hands"] = "Handauflegung",
		["Leader of the Pack"] = "Rudelf\195\188hrer",
		["Leather"] = "Leder",
		["Leatherworking"] = "Lederverarbeitung",
		["Leech Poison"] = "Egelgift",
		["Lesser Heal"] = "Geringes Heilen",
		["Lesser Healing Wave"] = "Geringe Welle der Heilung",
		["Lesser Invisibility"] = "Geringe Unsichtbarkeit",
		["Lethal Shots"] = "T\195\182dliche Sch\195\188sse",
		["Lethality"] = "T\195\182dlichkeit",
		["Levitate"] = "Levitieren",
		["Libram"] = "Buchband",
		["Lich Slap"] = "Lichohrfeige",
		["Life Tap"] = "Aderlass",
		["Lifebloom"] = "Lifebloom",  --  Need to translated
		["Lifegiving Gem"] = "Lifegiving Gem",
		["Lightning Blast"] = "Blitzschlag",
		["Lightning Bolt"] = "Blitzschlag",
		["Lightning Breath"] = "Blitzschlagatem",
		["Lightning Cloud"] = "Blitzschlagwolke",
		["Lightning Mastery"] = "Blitzschlagbeherrschung",
		["Lightning Reflexes"] = "Blitzartige Reflexe",
		["Lightning Shield"] = "Blitzschlagschild",
		["Lightning Wave"] = "Blitzschlagwelle",
		["Lightwell Renew"] = "Erneuerung des Lichtbrunnens",
		["Lightwell"] = "Brunnen des Lichts",
		["Lizard Bolt"] = "Echsenblitz",
		["Localized Toxin"] = "L\195\164hmendes Toxin",
		["Lockpicking"] = "Schlossknacken",
		["Long Daze"] = "Lange Benommenheit",
		["Mace Specialization"] = "Streitkolben-Spezialisierung",
		["Mace Stun Effect"] = "Streitkolbenbet\195\164ubung-Effekt",
		["Machine Gun"] = "Maschinengewehr",
		["Mage Armor"] = "Magische R\195\188stung",
		["Magic Attunement"] = "Magic Attunement",
		["Magma Splash"] = "Magmaspritzer",
		["Magma Totem"] = "Totem der gl\195\188henden Magma",
		["Mail"] = "Panzer",
		["Maim"] = "Maim",  --  Need to translated
		["Malice"] = "T\195\188cke",
		["Mana Burn"] = "Manabrand",
		["Mana Feed"] = "Mana Feed",
		["Mana Shield"] = "Manaschild",
		["Mana Spring Totem"] = "Totem der Manaquelle",
		["Mana Tide Totem"] = "Totem der Manaflut",
		["Mangle (Bear)"] = "Mangle (Bear)",  --  Need to translated
		["Mangle (Cat)"] = "Mangle (Cat)",  --  Need to translated
		["Mangle"] = "Fleddern",
		["Mark of Arlokk"] = "Arlokks Mal",
		["Mark of the Wild"] = "Mal der Wildnis",
		["Martyrdom"] = "M\195\164rtyrertum",
		["Mass Dispel"] = "Mass Dispel",
		["Master Demonologist"] = "Meister der D\195\164monologie",
		["Master of Deception"] = "Meister der T\195\164uschung",
		["Master of Elements"] = "Master of Elements",
		["Master Summoner"] = "Meister der Beschw\195\182rung",
		["Maul"] = "Zermalmen",
		["Mechanostrider Piloting"] = "Roboschreiter-Lenken",
		["Meditation"] = "Meditation",
		["Megavolt"] = "Megavolt",
		["Melee Specialization"] = "Nahkampf-Spezialisierung",
		["Melt Ore"] = "Erz schmelzen",
		["Mend Pet"] = "Tier heilen",
		["Mental Agility"] = "Mentale Beweglichkeit",
		["Mental Strength"] = "Mentale St\195\164rke",
		["Mighty Blow"] = "M\195\164chtiger Draufschlag",
		["Mind Blast"] = "Gedankenschlag",
		["Mind Control"] = "Gedankenkontrolle",
		["Mind Flay"] = "Gedankenschinden",
		["Mind Soothe"] = "Gedankenbes\195\164nftigung",
		["Mind Tremor"] = "Gedankenbeben",
		["Mind Vision"] = "Gedankensicht",
		["Mind-numbing Poison II"] = "Gedankenbenebelndes Gift II",
		["Mind-numbing Poison III"] = "Gedankenbenebelndes Gift III",
		["Mind-numbing Poison"] = "Gedankenbenebelndes Gift",
		["Mining"] = "Bergbau",
		["Misdirection"] = "Misdirection",  --  Need to translated
		["Mocking Blow"] = "Sp\195\182ttischer Schlag",
		["Molten Armor"] = "Molten Armor",  --  Need to translated
		["Molten Blast"] = "Geschmolzener Schlag",
		["Molten Metal"] = "Fl\195\188ssiges Metall",
		["Mongoose Bite"] = "Mungobiss",
		["Monster Slaying"] = "Monstert\195\182ten",
		["Moonfire"] = "Mondfeuer",
		["Moonfury"] = "Mondfuror",
		["Moonglow"] = "Mondschein",
		["Moonkin Aura"] = "Aura des Moonkin",
		["Moonkin Form"] = "Moonkingestalt",
		["Mortal Cleave"] = "T\195\182dliches Spalten",
		["Mortal Shots"] = "Todbringende Sch\195\188sse",
		["Mortal Strike"] = "T\195\182dlicher Sto\195\159",
		["Multi-Shot"] = "Mehrfachschuss",
		["Murder"] = "Mord",
		["Mutilate"] = "Mutilate",  --  Need to translated
		["Naralex's Nightmare"] = "Naralex' Alptraum",
		["Natural Armor"] = "Nat\195\188rliche R\195\188stung",
		["Natural Shapeshifter"] = "Schnellwandlung",
		["Natural Weapons"] = "Waffenbalance",
		["Nature Resistance Totem"] = "Totem des Naturwiderstands",
		["Nature Resistance"] = "Naturwiderstand",
		["Nature Weakness"] = "Nature Weakness",
		["Nature's Focus"] = "Naturfokus",
		["Nature's Grace"] = "Anmut der Natur",
		["Nature's Grasp"] = "Griff der Natur",
		["Nature's Reach"] = "Reichweite der Natur",
		["Nature's Swiftness"] = "Schnelligkeit der Natur",
		["Negative Charge"] = "Negative Charge",
		["Net"] = "Netz",
		["Nightfall"] = "Einbruch der Nacht",
		["Noxious Catalyst"] = "Giftiger Katalysator",
		["Noxious Cloud"] = "Giftige Wolke",
		["Omen of Clarity"] = "Omen der Klarsicht",
		["One-Handed Axes"] = "Einhand\195\164xte",
		["One-Handed Maces"] = "Einhandstreitkolben",
		["One-Handed Swords"] = "Einhandschwerter",
		["One-Handed Weapon Specialization"] = "Einhandwaffen-Spezialisierung",
		["Opening - No Text"] = "\195\150ffnen - Kein Text",
		["Opening"] = "\195\150ffnen",
		["Opportunity"] = "G\195\188nstige Gelegenheit",
		["Overpower"] = "\195\156berw\195\164ltigen",
		["Pacify"] = "Befrieden",
		["Pain Suppression"] = "Pain Suppression",  --  Need to translated
		["Paralyzing Poison"] = "L\195\164hmendes Gift",
		["Paranoia"] = "Paranoia",
		["Parasitic Serpent"] = "Schmarotzerschlange",
		["Parry"] = "Parieren",
		["Pathfinding"] = "Orientierung",
		["Perception"] = "Wachsamkeit",
		["Permafrost"] = "Dauerfrost",
		["Pet Aggression"] = "Tieraggression",
		["Pet Hardiness"] = "Tier-Widerstandskraft",
		["Pet Recovery"] = "Tiererholung",
		["Pet Resistance"] = "Tier-Widerstand",
		["Petrify"] = "Versteinern",
		["Phase Shift"] = "Phasenverschiebung",
		["Pick Lock"] = "Schloss knacken",
		["Pick Pocket"] = "Taschendiebstahl",
		["Pierce Armor"] = "R\195\188stung durchstechen",
		["Piercing Howl"] = "Durchdringendes Heulen",
		["Piercing Ice"] = "Stechendes Eis",
		["Piercing Shadow"] = "Stichschatten",
		["Piercing Shot"] = "Stichschuss",
		["Plague Cloud"] = "Seuchenwolke",
		["Plate Mail"] = "Plattenpanzer",
		["Poison Bolt Volley"] = "Giftblitzsalve",
		["Poison Bolt"] = "Giftblitz",
		["Poison Cleansing Totem"] = "Totem der Giftreinigung",
		["Poison Cloud"] = "Giftwolke",
		["Poison Shock"] = "Giftschock",
		["Poison"] = "Gift",
		["Poisoned Harpoon"] = "Vergiftete Harpune",
		["Poisoned Shot"] = "Vergifteter Schuss",
		["Poisonous Blood"] = "Giftiges Blut",
		["Poisons"] = "Gifte",
		["Polearm Specialization"] = "Stangenwaffen-Spezialisierung",
		["Polearms"] = "Stangenwaffen",
		["Polymorph"] = "Verwandlung",
		["Polymorph: Pig"] = "Polymorph: Pig",
		["Polymorph: Turtle"] = "Polymorph: Turtle", 
		["Portal: Darnassus"] = "Portal: Darnassus",
		["Portal: Ironforge"] = "Portal: Ironforge",
		["Portal: Orgrimmar"] = "Portal: Orgrimmar",
		["Portal: Stormwind"] = "Portal: Stormwind",
		["Portal: Thunder Bluff"] = "Portal: Thunder Bluff",
		["Portal: Undercity"] = "Portal: Undercity",
		["Positive Charge"] = "Positive Charge",
		["Pounce Bleed"] = "Anspringblutung",
		["Pounce"] = "Anspringen",
		["Power Infusion"] = "Seele der Macht",
		["Power Word: Fortitude"] = "Machtwort: Seelenst\195\164rke",
		["Power Word: Shield"] = "Machtwort: Schild",
		["Prayer of Fortitude"] = "Gebet der Seelenst\195\164rke",
		["Prayer of Healing"] = "Gebet der Heilung",
		["Prayer of Mending"] = "Prayer of Mending",  --  Need to translated
		["Prayer of Shadow Protection"] = "Gebet des Schattenschutzes",
		["Prayer of Spirit"] = "Gebet der Willenskraft",
		["Precision"] = "Pr\195\164zision",
		["Predatory Strikes"] = "Raubtierschl\195\164ge",
		["Premeditation"] = "Konzentration",
		["Preparation"] = "Vorbereitung",
		["Presence of Mind"] = "Geistesgegenwart",
		["Primal Fury"] = "Urfuror",
		["Prowl"] = "Schleichen",
		["Psychic Scream"] = "Psychischer Schrei",
		["Pummel"] = "Zuschlagen",
		["Puncture"] = "Einstechen",
		["Purge"] = "Reinigen",
		["Purification"] = "L\195\164uterung",
		["Purify"] = "L\195\164utern",
		["Pursuit of Justice"] = "Streben nach Gerechtigkeit",
		["Putrid Breath"] = "Eitriger Atem",
		["Putrid Enzyme"] = "Eitriges Enzym",
		["Pyroblast"] = "Pyroschlag",
		["Pyroclasm"] = "Feuerschwall",
		["Quick Shots"] = "Quick Shots",
		["Quickness"] = "Schnelligkeit",
		["Radiation Bolt"] = "Strahlungsblitz",
		["Radiation Cloud"] = "Strahlungswolke",
		["Radiation"] = "Strahlung",
		["Rain of Fire"] = "Feuerregen",
		["Rake"] = "Krallenhieb",
		["Ram Riding"] = "Widderreiten",
		["Rampage"] = "Toben",
		["Ranged Weapon Specialization"] = "Distanzwaffen-Spezialisierung",
		["Rapid Concealment"] = "Rapid Concealment",  --  Need to translated
		["Rapid Fire"] = "Schnellfeuer",
		["Raptor Riding"] = "Raptorreiten",
		["Raptor Strike"] = "Raptorsto\195\159",
		["Ravage"] = "Verheeren",
		["Ravenous Claw"] = "Gefr\195\164\195\159ige Klaue",
		["Readiness"] = "Bereitschaft",
		["Rebirth"] = "Wiedergeburt",
		["Rebuild"] = "Wiederaufbauen",
		["Recently Bandaged"] = "K\195\188rzlich bandagiert",
		["Reckless Charge"] = "Tollk?nes St?men",
		["Recklessness"] = "Tollk\195\188hnheit",
		["Reckoning"] = "Abrechnung",
		["Recombobulate"] = "Rekombobulieren",
		["Redemption"] = "Erl\195\182sung",
		["Redoubt"] = "Verschanzen",
		["Reflection"] = "Reflexion",
		["Regeneration"] = "Regeneration",
		["Regrowth"] = "Nachwachsen",
		["Reincarnation"] = "Reinkarnation",
		["Rejuvenation"] = "Verj\195\188ngung",
		["Relentless Strikes"] = "Unerbittliche St\195\182\195\159e",
		["Remorseless Attacks"] = "Gnadenlose Angriffe",
		["Remorseless"] = "Remorseless",
		["Remove Curse"] = "Fluch aufheben",
		["Remove Insignia"] = "Abzeichen entfernen",
		["Remove Lesser Curse"] = "Geringen Fluch aufheben",
		["Rend"] = "Verwunden",
		["Renew"] = "Erneuerung",
		["Repentance"] = "Bu\195\159e",
		["Repulsive Gaze"] = "Absto\195\159endes Starren",
		["Restorative Totems"] = "Restorative Totems",
		["Resurrection"] = "Auferstehung",
		["Retaliation"] = "Gegenschlag",
		["Retribution Aura"] = "Aura der Vergeltung",
		["Revenge Stun"] = "Rachebet\195\164ubung",
		["Revenge"] = "Rache",
		["Reverberation"] = "Nachklingen",
		["Revive Pet"] = "Tier wiederbeleben",
		["Rhahk'Zor Slam"] = "Rhahk'Zor-Zerschmettern",
		["Ribbon of Souls"] = "Band der Seelen",
		["Righteous Defense"] = "Righteous Defense",  --  Need to translated
		["Righteous Fury"] = "Zorn der Gerechtigkeit",
		["Rip"] = "Zerfetzen",
		["Riposte"] = "Riposte",
		["Ritual of Doom Effect"] = "Ritual der Verdammnis'-Effekt",
		["Ritual of Doom"] = "Ritual der Verdammnis",
		["Ritual of Souls"] = "Ritual of Souls",  --  Need to translated
		["Ritual of Summoning"] = "Ritual der Beschw\195\182rung",
		["Rockbiter Weapon"] = "Felsbei\195\159erwaffe",
		["Rogue Passive"] = "Schurke Passiv",
		["Ruin"] = "Verderben",
		["Rupture"] = "Blutung",
		["Ruthlessness"] = "Skrupellosigkeit",
		["Sacrifice"] = "Opferung",
		["Safe Fall"] = "Sicheres Fallen",
		["Sanctity Aura"] = "Aura der Heiligkeit",
		["Sap"] = "Kopfnuss",
		["Savage Fury"] = "Ungez\195\164hmte Wut",
		["Savage Strikes"] = "Wilde Schl\195\164ge",
		["Scare Beast"] = "Wildtier \195\164ngstigen",
		["Scatter Shot"] = "Streuschuss",
		["Scorch"] = "Versengen",
		["Scorpid Poison"] = "Skorpidgift",
		["Scorpid Sting"] = "Skorpidstich",
		["Screams of the Past"] = "Kreischen der Vergangenheit",
		["Screech"] = "Schrei",
		["Seal Fate"] = "Schicksal besiegeln",
		["Seal of Blood"] = "Seal of Blood",  --  Need to translated
		["Seal of Command"] = "Siegel des Befehls",
		["Seal of Justice"] = "Siegel der Gerechtigkeit",
		["Seal of Light"] = "Siegel des Lichts",
		["Seal of Reckoning"] = "Siegel der Abrechnung",
		["Seal of Righteousness"] = "Siegel der Rechtschaffenheit",
		["Seal of the Crusader"] = "Siegel des Kreuzfahrers",
		["Seal of Vengeance"] = "Seal of Vengeance",  --  Need to translated
		["Seal of Wisdom"] = "Siegel der Weisheit",
		["Searing Light"] = "Sengendes Licht",
		["Searing Pain"] = "Sengender Schmerz",
		["Searing Totem"] = "Totem der Verbrennung",
		["Second Wind"] = "Second Wind",
		["Seduction"] = "Verf\195\188hrung",
		["Seed of Corruption"] = "Seed of Corruption",  --  Need to translated
		["Sense Demons"] = "D\195\164monen sp\195\188ren",
		["Sense Undead"] = "Untote sp\195\188ren",
		["Sentry Totem"] = "Totem des Wachens",
		["Serpent Sting"] = "Schlangenbiss",
		["Setup"] = "Reinlegen",
		["Shackle Undead"] = "Untote fesseln",
		["Shadow Affinity"] = "Schattenaffinit\195\164t",
		["Shadow Bolt Volley"] = "Schattenblitzsalve",
		["Shadow Bolt"] = "Schattenblitz",
		["Shadow Focus"] = "Schattenfokus",
		["Shadow Mastery"] = "Schattenbeherrschung",
		["Shadow Protection"] = "Schattenschutz",
		["Shadow Reach"] = "Schattenreichweite",
		["Shadow Resistance Aura"] = "Aura des Schattenwiderstands",
		["Shadow Resistance"] = "Schattenwiderstand",
		["Shadow Shock"] = "Schattenschock",
		["Shadow Trance"] = "Schattentrance",
		["Shadow Vulnerability"] = "Shadow Vulnerability",
		["Shadow Ward"] = "Schattenzauberschutz",
		["Shadow Weakness"] = "Shadow Weakness",
		["Shadow Weaving"] = "Schattenwirken",
		["Shadow Word: Death"] = "Shadow Word: Death",  --  Need to translated
		["Shadow Word: Pain"] = "Schattenwort: Schmerz",
		["Shadowburn"] = "Schattenbrand",
		["Shadowfiend"] = "Shadowfiend",  --  Need to translated
		["Shadowform"] = "Schattengestalt",
		["Shadowfury"] = "Shadowfury",  --  Need to translated
		["Shadowguard"] = "Schattenschild",
		["Shadowmeld Passive"] = "Schattenmimik Passiv",
		["Shadowmeld"] = "Schattenhaftigkeit",
		["Shadowstep"] = "Shadowstep",  --  Need to translated
		["Shamanistic Rage"] = "Shamanistic Rage",  --  Need to translated
		["Sharpened Claws"] = "Gesch\195\164rfte Klauen",
		["Shatter"] = "Zertr\195\188mmern",
		["Sheep"] = "Sheep",  --  Need to translated
		["Shell Shield"] = "Panzerschild",
		["Shield Bash - Silenced"] = "Shield Bash - Silenced",
		["Shield Bash"] = "Schildhieb",
		["Shield Block"] = "Schildblock",
		["Shield Slam"] = "Schildschlag",
		["Shield Specialization"] = "Schild-Spezialisierung",
		["Shield Wall"] = "Schildwall",
		["Shield"] = "Schild",
		["Shiv"] = "Shiv",  --  Need to translated
		["Shock"] = "Schock",
		["Shoot Bow"] = "Bogenschuss",
		["Shoot Crossbow"] = "Armbrust abschie\195\159en",
		["Shoot Gun"] = "Schusswaffe abfeuern",
		["Shoot"] = "Schie\195\159en",
		["Shred"] = "Schreddern",
		["Shrink"] = "Schrumpfen",
		["Silence"] = "Stille",
		["Silencing Shot"] = "Silencing Shot",
		["Silent Resolve"] = "Schweigsame Entschlossenheit",
		["Sinister Strike"] = "Finsterer Sto\195\159",
		["Siphon Life"] = "Lebensentzug",
		["Skinning"] = "K\195\188rschnerei",
		["Skull Crack"] = "Sch\195\164delkracher",
		["Slam"] = "Zerschmettern",
		["Sleep"] = "Schlaf",
		["Slice and Dice"] = "Zerh\195\164ckseln",
		["Slow Fall"] = "Langsamer Fall",
		["Slow"] = "Verlangsamen",
		["Slowing Poison"] = "Verlangsamendes Gift",
		["Smelting"] = "Verh\195\188ttung",
		["Smite Slam"] = "Schmetterwurf",
		["Smite Stomp"] = "Peins Stampfen",
		["Smite"] = "G\195\182ttliche Pein",
		["Smoke Bomb"] = "Rauchbombe",
		["Snake Trap"] = "Snake Trap",  --  Need to translated
		["Snap Kick"] = "Schnapptritt",
		["Sonic Burst"] = "Schallexplosion",
		["Soothe Animal"] = "Tier bes\195\164nftigen",
		["Soothing Kiss"] = "Bes\195\164nftigender Kuss",
		["Soul Bite"] = "Seelenbiss",
		["Soul Drain"] = "Seelensauger",
		["Soul Fire"] = "Seelenfeuer",
		["Soul Link"] = "Seelenverbindung",
		["Soul Siphon"] = "Seelenentzug",
		["Soul Tap"] = "Seelenzapfer",
		["Soulshatter"] = "Soulshatter",  --  Need to translated
		["Soulstone Resurrection"] = "Seelenstein-Auferstehung",
		["Spell Lock"] = "Zaubersperre",
		["Spell Reflection"] = "Spell Reflection",
		["Spell Warding"] = "Zauberschutz",
		["Spellsteal"] = "Spellsteal",  --  Need to translated
		["Spirit Bond"] = "Geistbande",
		["Spirit Burst"] = "Geistexplosion",
		["Spirit of Redemption"] = "Geist der Erl\195\182sung",
		["Spirit Tap"] = "Willensentzug",
		["Spiritual Attunement"] = "Spiritual Attunement",  --  Need to translated
		["Spiritual Focus"] = "Spiritueller Fokus",
		["Spiritual Guidance"] = "Geistige F\195\188hrung",
		["Spiritual Healing"] = "Spirituelle Heilung",
		["Spit"] = "Spucken",
		["Spore Cloud"] = "Sporenwolke",
		["Sprint"] = "Sprinten",
		["Stance Mastery"] = "Stance Mastery",  --  Need to translated
		["Starfire Stun"] = "Starfire Stun",
		["Starfire"] = "Sternenfeuer",
		["Starshards"] = "Sternensplitter",
		["Staves"] = "St\195\164be",
		["Steady Shot"] = "Steady Shot",  --  Need to translated
		["Stealth"] = "Verstohlenheit",
		["Stoneclaw Totem"] = "Totem der Steinklaue",
		["Stoneform"] = "Steingestalt",
		["Stoneskin Totem"] = "Totem der Steinhaut",
		["Stormstrike"] = "Sturmschlag",
		["Strength of Earth Totem"] = "Totem der Erdst\195\164rke",
		["Strike"] = "Sto\195\159",
		["Stuck"] = "Feststecken",
		["Stun"] = "Bet\195\164uben",
		["Subtlety"] = "Feingef\195\188hl",
		["Suffering"] = "Leiden",
		["Summon Charger"] = "Streitross beschw\195\182ren",
		["Summon Dreadsteed"] = "Schreckensross herbeirufen",
		["Summon Felguard"] = "Summon Felguard",  --  Need to translated
		["Summon Felhunter"] = "Teufelsj\195\164ger beschw\195\182ren",
		["Summon Felsteed"] = "Teufelsross beschw\195\182ren",
		["Summon Imp"] = "Wichtel beschw\195\182ren",
		["Summon Spawn of Bael'Gar"] = "Brut von Bael'Gar beschw\195\182ren",
		["Summon Succubus"] = "Sukkubus beschw\195\182ren",
		["Summon Voidwalker"] = "Leerwandler beschw\195\182ren",
		["Summon Warhorse"] = "Schlachtross beschw\195\182ren",
		["Summon Water Elemental"] = "Summon Water Elemental",
		["Sunder Armor"] = "R\195\188stung zerrei\195\159en",
		["Suppression"] = "Unterdr\195\188ckung",
		["Surefooted"] = "Sicherer Stand",
		["Survivalist"] = "\195\156berlebensk\195\188nstler",
		["Sweeping Slam"] = "Weitreichendes Zerschmettern",
		["Sweeping Strikes"] = "Weitreichende St\195\182\195\159e",
		["Swiftmend"] = "Rasche Heilung",
		["Swipe"] = "Prankenhieb",
		["Swoop"] = "Sturzflug",
		["Sword Specialization"] = "Schwert-Spezialisierung",
		["Tactical Mastery"] = "Taktiker",
		["Tailoring"] = "Schneiderei",
		["Tainted Blood"] = "Besudeltes Blut",
		["Tame Beast"] = "Wildtier z\195\164hmen",
		["Tamed Pet Passive"] = "Gez\195\164hmtes Tier - Passiv",
		["Taunt"] = "Spott",
		["Teleport: Darnassus"] = "Teleportieren: Darnassus",
		["Teleport: Ironforge"] = "Teleportieren: Ironforge",
		["Teleport: Moonglade"] = "Teleportieren: Moonglade",
		["Teleport: Orgrimmar"] = "Teleportieren: Orgrimmar",
		["Teleport: Stormwind"] = "Teleportieren: Stormwind",
		["Teleport: Thunder Bluff"] = "Teleportieren: Thunder Bluff",
		["Teleport: Undercity"] = "Teleportieren: Undercity",
		["Tendon Rip"] = "Sehnenriss",
		["Tendon Slice"] = "Sehnenschnitt",
		["Terrify"] = "Erschrecken",
		["Terrifying Screech"] = "Schreckliches Kreischen",
		["The Beast Within"] = "The Beast Within",  --  Need to translated
		["The Human Spirit"] = "Unbeugsamkeit",
		["Thick Hide"] = "Dickes Fell",
		["Thorn Volley"] = "Dornensalve",
		["Thorns"] = "Dornen",
		["Thousand Blades"] = "Tausend Klingen",
		["Threatening Gaze"] = "Bedrohlicher Blick",
		["Throw Axe"] = "Axt werfen",
		["Throw Dynamite"] = "Dynamit werfen",
		["Throw Liquid Fire"] = "Fl\195\188ssiges Feuer werfen",
		["Throw Wrench"] = "Schraubenschl\195\188ssel werfen",
		["Throw"] = "Werfen",
		["Throwing Specialization"] = "Wurfwaffen-Spezialisierung",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization",  --  Need to translated
		["Thrown"] = "Wurfwaffe",
		["Thunder Clap"] = "Donnerknall",
		["Thunderclap"] = "Donnerknall",
		["Thunderfury"] = "Zorn der Winde",
		["Thundering Strikes"] = "Donnernde St\195\182\195\159e",
		["Thundershock"] = "Donnerschock",
		["Thunderstomp"] = "Donnerstampfer",
		["Tidal Focus"] = "Gezeitenfokus",
		["Tidal Mastery"] = "Gezeitenbeherrschung",
		["Tiger Riding"] = "Tigerreiten",
		["Tiger's Fury"] = "Tigerfuror",
		["Torment"] = "Qual",
		["Totem of Wrath"] = "Totem of Wrath",  --  Need to translated
		["Totem"] = "Totem",
		["Totemic Focus"] = "Totemfokus",
		["Touch of Weakness"] = "Ber\195\188hrung der Schw\195\164che",
		["Toughness"] = "Z\195\164higkeit",
		["Toxic Saliva"] = "Toxinspeichel",
		["Toxic Spit"] = "Toxinspucke",
		["Toxic Volley"] = "Toxische Salve",
		["Traces of Silithyst"] = "Traces of Silithyst",
		["Track Beasts"] = "Wildtiere aufsp\195\188ren",
		["Track Demons"] = "D\195\164monen aufsp\195\188ren",
		["Track Dragonkin"] = "Drachkin aufsp\195\188ren",
		["Track Elementals"] = "Elementare aufsp\195\188ren",
		["Track Giants"] = "Riesen aufsp\195\188ren",
		["Track Hidden"] = "Verborgenes aufsp\195\188ren",
		["Track Humanoids"] = "Humanoide aufsp\195\188ren",
		["Track Undead"] = "Untote aufsp\195\188ren",
		["Trample"] = "Trampeln",
		["Tranquil Air Totem"] = "Totem der beruhigenden Winde",
		["Tranquil Spirit"] = "Gelassener Geist",
		["Tranquility"] = "Gelassenheit",
		["Tranquilizing Poison"] = "Einlullendes Gift",
		["Tranquilizing Shot"] = "Einlullender Schuss",
		["Trap Mastery"] = "Fallenbeherrschung",
		["Travel Form"] = "Reisegestalt",
		["Tree of Life"] = "Tree of Life",  --  Need to translated
		["Tremor Totem"] = "Totem des Erdsto\195\159es",
		["Tribal Leatherworking"] = "Stammeslederverarbeitung",
		["Trueshot Aura"] = "Aura des Volltreffers",
		["Turn Undead"] = "Untote vertreiben",
		["Twisted Tranquility"] = "Verdrehte Gelassenheit",
		["Two-Handed Axes and Maces"] = "Zweihand\195\164xte und -Streitkolben",
		["Two-Handed Axes"] = "Zweihand\195\164xte",
		["Two-Handed Maces"] = "Zweihandstreitkolben",
		["Two-Handed Swords"] = "Zweihandschwerter",
		["Two-Handed Weapon Specialization"] = "Zweihandwaffen-Spezialisierung",
		["Unarmed"] = "Unbewaffnet",
		["Unbreakable Will"] = "Unbezwingbarer Wille",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect",  --  Need to translated
		["Unbridled Wrath"] = "Entfesselter Zorn",
		["Undead Horsemanship"] = "Untotenreitkunst",
		["Underwater Breathing"] = "Unterwasseratmung",
		["Unending Breath"] = "Unendlicher Atem",
		["Unholy Frenzy"] = "Unheilige Raserei",
		["Unholy Power"] = "Unheilige Macht",
		["Unleashed Fury"] = "Entfesselter Zorn",
		["Unleashed Rage"] = "Unleashed Rage",
		["Unstable Affliction"] = "Unstable Affliction",  --  Need to translated
		["Unstable Concoction"] = "Instabile Substanz",
		["Unyielding Faith"] = "Unumst\195\182\195\159licher Glaube",
		["Uppercut"] = "Aufw\195\164rtshaken",
		["Vampiric Embrace"] = "Vampirumarmung",
		["Vampiric Touch"] = "Vampiric Touch",  --  Need to translated
		["Vanish"] = "Verschwinden",
		["Vanished"] = "Verschwunden",
		["Veil of Shadow"] = "Schattenschleier",
		["Vengeance"] = "Rache",
		["Venom Spit"] = "Giftspucke",
		["Venom Sting"] = "Giftstachel",
		["Venomhide Poison"] = "Gifthautsekret",
		["Vicious Rend"] = "Heimt\195\188ckisches Zerfleischen",
		["Victory Rush"] = "Victory Rush",  --  Need to translated
		["Vigor"] = "Lebenskraft",
		["Vile Poisons"] = "\195\156ble Gifte",
		["Vindication"] = "Rechtschaffene Schw\195\164chung",
		["Viper Sting"] = "Vipernbiss",
		["Virulent Poison"] = "Virulentes Gift",
		["Void Bolt"] = "Leerenblitz",
		["Volley"] = "Salve",
		["Walking Bomb Effect"] = "Detonieren",
		["Wand Specialization"] = "Zauberstab-Spezialisierung",
		["Wandering Plague"] = "Wandernde Seuche",
		["Wands"] = "Zauberst\195\164be",
		["War Stomp"] = "Kriegsdonner",
		["Water Breathing"] = "Wasseratmung",
		["Water Shield"] = "Water Shield",  --  Need to translated
		["Water Walking"] = "Wasserwandeln",
		["Water"] = "Wasser",
		["Waterbolt"] =	"Waterbolt",  --  Need to translated
		["Wavering Will"] = "Wankelmut",
		["Weakened Soul"] = "Geschw\195\164chte Seele",
		["Weaponsmith"] = "Waffenschmied",
		["Web Explosion"] = "Gespinstexplosion",
		["Web Spin"] = "Netzwirbel",
		["Web Spray"] = "Gespinstschauer",
		["Web"] = "Gespinst",
		["Whirling Barrage"] = "Wirbelndes Sperrfeuer",
		["Whirling Trip"] = "Wirbelkick",
		["Whirlwind"] = "Wirbelwind",
		["Wide Slash"] = "Weiter Streich",
		["Will of Hakkar"] = "Wille von Hakkar",
		["Will of the Forsaken"] = "Wille der Verlassenen",
		["Windfury Totem"] = "Totem des Windzorns",
		["Windfury Weapon"] = "Waffe des Windfurors",
		["Windsor's Frenzy"] = "Windsors Raserei",
		["Windwall Totem"] = "Totem der Windmauer",
		["Wing Clip"] = "Zurechtstutzen",
		["Wing Flap"] = "Fl\195\188gelschlag",
		["Winter's Chill"] = "Winterk\195\164lte",
		["Wisp Spirit"] = "Irrwisch-Geist",
		["Wolf Riding"] = "Wolfreiten",
		["Wound Poison II"] = "Wundgift II",
		["Wound Poison III"] = "Wundgift III",
		["Wound Poison IV"] = "Wundgift IV",
		["Wound Poison"] = "Wundgift",
		["Wrath of Air Totem"] = "Wrath of Air Totem",  --  Need to translated
		["Wrath"] = "Zorn",
		["Wyvern Sting"] = "Stich des Fl\195\188geldrachen"
	}
end)

BabbleSpell:RegisterTranslations("frFR", function()
	return {
		["Abolish Disease"] = "Abolir maladie",
		["Abolish Poison Effect"] = "Effet Abolir le poison",
		["Abolish Poison"] = "Abolir le poison",
		["Activate MG Turret"] = "Activation de la tourelle de mitrailleuse",
		["Adrenaline Rush"] = "Pouss\195\169e d'adr\195\169naline",
		["Aftermath"] = "Cons\195\169quences",
		["Aggression"] = "Agressivit\195\169",
		["Aimed Shot"] = "Vis\195\169e",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Embuscade",
		["Amplify Curse"] = "Mal\195\169diction amplifi\195\169e",
		["Amplify Magic"] = "Amplification de la magie",
		["Ancestral Fortitude"] = "Robustesse des anciens",
		["Ancestral Healing"] = "Gu\195\169rison des anciens",
		["Ancestral Knowledge"] = "Connaissance ancestrale",
		["Ancestral Spirit"] = "Esprit ancestral",
		["Anesthetic Poison"] = "Anesthetic Poison",  --  Need to translated
		["Anger Management"] = "Ma\195\174trise de la Rage",
		["Anguish"] = "Anguish",  --  Need to translated
		["Anticipation"] = "Anticipation",
		["Aquatic Form"] = "Forme aquatique",
		["Arcane Blast"] = "Arcane Blast",  --  Need to translated
		["Arcane Brilliance"] = "Illumination des arcanes",
		["Arcane Concentration"] = "Concentration des arcanes",
		["Arcane Explosion"] = "Explosion des arcanes",
		["Arcane Focus"] = "Focalisation des arcanes",
		["Arcane Instability"] = "Instabilit\195\169 des arcanes",
		["Arcane Intellect"] = "Intelligence des arcanes",
		["Arcane Meditation"] = "M\195\169ditation des arcanes",
		["Arcane Mind"] = "Esprit des arcanes",
		["Arcane Missiles"] = "Projectiles des arcanes",
		["Arcane Potency"] = "Toute-puissance des arcanes",
		["Arcane Power"] = "Pouvoir des arcanes",
		["Arcane Resistance"] = "R\195\169sistance aux Arcanes",
		["Arcane Shot"] = "Tir des arcanes",
		["Arcane Subtlety"] = "Subtilit\195\169 des arcanes",
		["Arcane Weakness"] = "Sensibilit\195\169 aux Arcanes",
		["Arctic Reach"] = "Allonge arctique",
		["Armorsmith"] = "Fabricant d'armures",
		["Aspect of the Beast"] = "Aspect de la b\195\170te",
		["Aspect of the Cheetah"] = "Aspect du gu\195\169pard",
		["Aspect of the Hawk"] = "Aspect du faucon",
		["Aspect of the Monkey"] = "Aspect du singe",
		["Aspect of the Pack"] = "Aspect de la meute",
		["Aspect of the Viper"] = "Aspect of the Viper",  --  Need to translated
		["Aspect of the Wild"] = "Aspect de la nature",
		["Astral Recall"] = "Rappel astral",
		["Attack"] = "Attaque",
		["Attacking"] = "Attaque",
		["Auto Shot"] = "Tir automatique",
		["Avenger's Shield"] = "Avenger's Shield",  --  Need to translated
		["Avenging Wrath"] = "Avenging Wrath",  --  Need to translated
		["Avoidance"] = "Evitement",
		["Axe Specialization"] = "Sp\195\169cialisation Hache",
		["Backlash"] = "Backlash",  --  Need to translated
		["Backstab"] = "Attaque sournoise",
		["Bane"] = "Fl\195\169au",
		["Banish"] = "Bannir",
		["Barkskin Effect"] = "Effet Ecorce",
		["Barkskin"] = "Ecorce",
		["Barrage"] = "Barrage",
		["Bash"] = "Sonner",
		["Basic Campfire"] = "Feu de camp basique",
		["Battle Shout"] = "Cri de guerre",
		["Battle Stance Passive"] = "Posture de combat",
		["Battle Stance"] = "Posture de combat",
		["Bear Form"] = "Forme d\226\128\153ours",
		["Beast Lore"] = "Connaissance des b\195\170tes",
		["Beast Slaying"] = "Tueur de b\195\170tes",
		["Beast Training"] = "Apprivoisement",
		["Benediction"] = "B\195\169n\195\169diction",
		["Berserker Rage"] = "Rage berserker",
		["Berserker Stance Passive"] = "Posture berserker",
		["Berserker Stance"] = "Posture berserker",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Discipline bestiale",
		["Bestial Swiftness"] = "Rapidit\195\169 bestiale",
		["Bestial Wrath"] = "Courroux bestial",
		["Binding Heal"] = "Binding Heal",  --  Need to translated
		["Bite"] = "Morsure",
		["Black Arrow"] = "Fl\195\168che noire",
		["Blackout"] = "Aveuglement",
		["Blacksmithing"] = "Forge",
		["Blade Flurry"] = "D\195\169luge de lames",
		["Blast Wave"] = "Vague explosive",
		["Blazing Speed"] = "Blazing Speed",  --  Need to translated
		["Blessed Recovery"] = "R\195\169tablissement b\195\169ni",
		["Blessing of Freedom"] = "B\195\169n\195\169diction de libert\195\169",
		["Blessing of Kings"] = "B\195\169n\195\169diction des rois",
		["Blessing of Light"] = "B\195\169n\195\169diction de lumi\195\168re",
		["Blessing of Might"] = "B\195\169n\195\169diction de puissance",
		["Blessing of Protection"] = "B\195\169n\195\169diction de protection",
		["Blessing of Sacrifice"] = "B\195\169n\195\169diction de sacrifice",
		["Blessing of Salvation"] = "B\195\169n\195\169diction de salut",
		["Blessing of Sanctuary"] = "B\195\169n\195\169diction du sanctuaire",
		["Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse",
		["Blind"] = "C\195\169cit\195\169",
		["Blinding Powder"] = "Poudre aveuglante",
		["Blink"] = "Transfert",
		["Blizzard"] = "Blizzard",
		["Block"] = "Bloquer",
		["Blood Craze"] = "Folie sanguinaire",
		["Blood Frenzy"] = "Fr\195\169n\195\169sie sanglante",
		["Blood Fury"] = "Fureur sanguinaire",
		["Blood Pact"] = "Pacte de sang",
		["Bloodlust"] = "Furie sanguinaire",
		["Bloodrage"] = "Rage sanguinaire",
		["Bloodthirst"] = "Sanguinaire",
		["Booming Voice"] = "Voix tonitruante",
		["Bow Specialization"] = "Sp\195\169cialisation Arc",
		["Bows"] = "Arcs",
		["Bright Campfire"] = "Feu de camp \195\169clatant",
		["Brutal Impact"] = "Impact brutal",
		["Burning Adrenaline"] = "Mont\195\169e d'adrenaline",
		["Burning Soul"] = "Ame ardente",
		["Burning Wish"] = "Burning Wish",
		["Call of Flame"] = "Appel des flammes",
		["Call of Thunder"] = "Appel de la foudre",
		["Call Pet"] = "Appel du familier",
		["Camouflage"] = "Dissimulation",
		["Cannibalize"] = "Cannibalisme",
		["Cat Form"] = "Forme de f\195\169lin",
		["Cataclysm"] = "Cataclysme",
		["Chain Heal"] = "Salve de gu\195\169rison",
		["Chain Lightning"] = "Cha\195\174ne d'\195\169clairs",
		["Challenging Roar"] = "Rugissement provocateur",
		["Challenging Shout"] = "Cri de d\195\169fi",
		["Charge Rage Bonus Effect"] = "Effet Bonus de Rage de la Charge",
		["Charge Stun"] = "Charge \195\169tourdissante",
		["Charge"] = "Charge",
		["Cheap Shot"] = "Coup bas",
		["Chilled"] = "Transi",
		["Circle of Healing"] = "Circle of Healing",  --  Need to translated
		["Claw"] = "Griffe",
		["Cleanse"] = "Epuration",
		["Clearcasting"] = "Id\195\169es claires",
		["Cleave"] = "Encha\195\174nement",
		["Clever Traps"] = "Pi\195\168ges astucieux",
		["Cloak of Shadows"] = "Cloak of Shadows",  --  Need to translated
		["Closing"] = "Fermeture",
		["Cloth"] = "Tissu",
		["Coarse Sharpening Stone"] = "Pierre \195\160 aiguiser grossi\195\168re",
		["Cobra Reflexes"] = "R\195\169flexes du cobra",
		["Cold Blood"] = "Sang froid",
		["Cold Snap"] = "Morsure de glace",
		["Combat Endurance"] = "Endurance de combat",
		["Combustion"] = "Combustion",
		["Command"] = "Commande",
		["Commanding Shout"] = "Cri de commandement",
		["Concentration Aura"] = "Aura de concentration",
		["Concussion Blow"] = "Bourrasque",
		["Concussion"] = "Commotion",
		["Concussive Shot"] = "Trait de choc",
		["Cone of Cold"] = "C\195\180ne de froid",
		["Conflagrate"] = "Conflagration",
		["Conjure Food"] = "Invocation de nourriture",
		["Conjure Mana Agate"] = "Invocation d'une agate de mana",
		["Conjure Mana Citrine"] = "Invocation d'une citrine de mana",
		["Conjure Mana Jade"] = "Invocation d'une jade de mana",
		["Conjure Mana Ruby"] = "Invocation d'un rubis de mana",
		["Conjure Water"] = "Invocation d'eau",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone",  --  Need to translated
		["Consecration"] = "Cons\195\169cration",
		["Consume Magic"] = "Consume Magic",  --  Need to translated
		["Consume Shadows"] = "Consumer les ombres",
		["Convection"] = "Convection",
		["Conviction"] = "Conviction",
		["Cooking"] = "Cuisine",
		["Corruption"] = "Corruption",
		["Counterattack"] = "Contre-attaque",
		["Counterspell - Silenced"] = "Contresort - Silencieux",
		["Counterspell"] = "Contresort",
		["Cower"] = "D\195\169robade",
		["Create Firestone (Greater)"] = "Cr\195\169ation de Pierre de feu (sup\195\169rieure)",
		["Create Firestone (Lesser)"] = "Cr\195\169ation de Pierre de feu (inf\195\169rieure)",
		["Create Firestone (Major)"] = "Cr\195\169ation de Pierre de feu (majeure)",
		["Create Firestone"] = "Cr\195\169ation de Pierre de feu",
		["Create Healthstone (Greater)"] = "Cr\195\169ation de Pierre de soins (sup\195\169rieure)",
		["Create Healthstone (Lesser)"] = "Cr\195\169ation de Pierre de soins (inf\195\169rieure)",
		["Create Healthstone (Major)"] = "Cr\195\169ation de Pierre de soins (majeure)",
		["Create Healthstone (Minor)"] = "Cr\195\169ation de Pierre de soins (mineure)",
		["Create Healthstone"] = "Cr\195\169ation de Pierre de soins",
		["Create Soulstone (Greater)"] = "Cr\195\169ation de Pierre d'\195\162me (sup\195\169rieure)",
		["Create Soulstone (Lesser)"] = "Cr\195\169ation de Pierre d'\195\162me (inf\195\169rieure)",
		["Create Soulstone (Major)"] = "Cr\195\169ation de Pierre d'\195\162me (majeure)",
		["Create Soulstone (Minor)"] = "Cr\195\169ation de Pierre d'\195\162me (mineure)",
		["Create Soulstone"] = "Cr\195\169ation de Pierre d'\195\162me",
		["Create Spellstone (Greater)"] = "Cr\195\169ation de Pierre de sort (sup\195\169rieure)",
		["Create Spellstone (Major)"] = "Cr\195\169ation de Pierre de sort (majeure)",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)",  --  Need to translated
		["Create Spellstone"] = "Cr\195\169ation de Pierre de sort",
		["Crippling Poison II"] = "Poison affaiblissant II",
		["Crippling Poison"] = "Poison affaiblissant",
		["Critical Mass"] = "Masse critique",
		["Crossbows"] = "Arbal\195\168tes",
		["Cruelty"] = "Cruaut\195\169",
		["Crusader Aura"] = "Crusader Aura",  --  Need to translated
		["Crusader Strike"] = "Inquisition",
		["Cultivation"] = "Culture",
		["Cure Disease"] = "Gu\195\169rison des maladies",
		["Cure Poison"] = "Gu\195\169rison du poison",
		["Curse of Agony"] = "Mal\195\169diction d'agonie",
		["Curse of Doom Effect"] = "Effet Mal\195\169diction funeste",
		["Curse of Doom"] = "Mal\195\169diction funeste",
		["Curse of Exhaustion"] = "Mal\195\169diction de fatigue",
		["Curse of Idiocy"] = "Mal\195\169diction d'idiotie",
		["Curse of Recklessness"] = "Mal\195\169diction de t\195\169m\195\169rit\195\169",
		["Curse of Shadow"] = "Mal\195\169diction de l'ombre",
		["Curse of the Elements"] = "Mal\195\169diction des \195\169l\195\169ments",
		["Curse of Tongues"] = "Mal\195\169diction des langages",
		["Curse of Weakness"] = "Mal\195\169diction de faiblesse",
		["Cyclone"] = "Cyclone",
		["Dagger Specialization"] = "Sp\195\169cialisation Dague",
		["Daggers"] = "Dagues",
		["Dampen Magic"] = "Att\195\169nuation de la magie",
		["Dark Pact"] = "Pacte noir",
		["Darkness"] = "T\195\169n\195\168bres",
		["Dash"] = "C\195\169l\195\169rit\195\169",
		["Dazed"] = "H\195\169b\195\169tement",
		["Deadly Poison II"] = "Poison mortel II",
		["Deadly Poison III"] = "Poison mortel III",
		["Deadly Poison IV"] = "Poison mortel IV",
		["Deadly Poison V"] = "Poison mortel V",
		["Deadly Poison"] = "Poison mortel",
		["Deadly Throw"] = "Deadly Throw",  --  Need to translated
		["Death Coil"] = "Voile mortel",
		["Death Wish"] = "Souhait mortel",
		["Deep Wounds"] = "Blessures profondes",
		["Defense"] = "D\195\169fense",
		["Defensive Stance Passive"] = "Posture d\195\169fensive",
		["Defensive Stance"] = "Posture d\195\169fensive",
		["Defensive State 2"] = "Posture d\195\169fensive 2",
		["Defensive State"] = "Posture d\195\169fensive",
		["Defiance"] = "D\195\169fi",
		["Deflection"] = "D\195\169viation",
		["Demon Armor"] = "Armure d\195\169moniaque",
		["Demon Skin"] = "Peau de d\195\169mon",
		["Demonic Embrace"] = "Baiser d\195\169moniaque",
		["Demonic Frenzy"] = "Fr\195\169n\195\169sie d\195\169moniaque",
		["Demonic Sacrifice"] = "Sacrifice d\195\169moniaque",
		["Demoralizing Roar"] = "Rugissement d\195\169moralisant",
		["Demoralizing Shout"] = "Cri d\195\169moralisant",
		["Dense Sharpening Stone"] = "Pierre \195\160 aiguiser dense",
		["Desperate Prayer"] = "Pri\195\168re du d\195\169sespoir",
		["Destructive Reach"] = "Allonge de destruction",
		["Detect Greater Invisibility"] = "D\195\169tection de l'invisibilit\195\169 sup\195\169rieure",
		["Detect Invisibility"] = "D\195\169tection de l'invisibilit\195\169",
		["Detect Lesser Invisibility"] = "D\195\169tection de l'invisibilit\195\169 inf\195\169rieure",
		["Detect Magic"] = "D\195\169tection de la magie",
		["Detect Traps"] = "D\195\169tection des pi\195\168ges",
		["Detect"] = "D\195\169tection",
		["Deterrence"] = "Dissuasion",
		["Devastate"] = "D\195\169vaster",
		["Devastation"] = "D\195\169vastation",
		["Devotion Aura"] = "Aura de d\195\169votion",
		["Devour Magic Effect"] = "Effet festin magique",
		["Devour Magic"] = "Dévorer la magie",
		["Devouring Plague"] = "Peste d\195\169vorante",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Forme d\226\128\153ours redoutable",
		["Disarm Trap"] = "D\195\169sarmement de pi\195\168ge",
		["Disarm"] = "D\195\169sarmement",
		["Disease Cleansing Totem"] = "Totem de Purification des maladies",
		["Disenchant"] = "D\195\169senchanter",
		["Disengage"] = "D\195\169sengagement",
		["Dismiss Pet"] = "Renvoyer le familier",
		["Dispel Magic"] = "Dissipation de la magie",
		["Distract"] = "Distraction",
		["Distracting Shot"] = "Trait provocateur",
		["Dive"] = "Plongeon",
		["Divine Favor"] = "Faveur divine",
		["Divine Fury"] = "Fureur divine",
		["Divine Illumination"] = "Divine Illumination",  --  Need to translated
		["Divine Intellect"] = "Intelligence divine",
		["Divine Intervention"] = "Intervention divine",
		["Divine Protection"] = "Protection divine",
		["Divine Shield"] = "Bouclier divin",
		["Divine Spirit"] = "Esprit divin",
		["Divine Strength"] = "Force divine",
		["Dodge"] = "Esquiver",
		["Dragon's Breath"] = "Dragon's Breath",  --  Need to translated
		["Dragonscale Leatherworking"] = "Travail du cuir d'\195\169cailles de dragon",
		["Drain Life"] = "Drain de vie",
		["Drain Mana"] = "Drain de mana",
		["Drain Soul"] = "Siphon d'\195\162me",
		["Drink"] = "Boisson",
		["Dual Wield Specialization"] = "Sp\195\169cialisation Ambidextrie",
		["Dual Wield"] = "Ambidextrie",
		["Duel"] = "Duel",
		["Eagle Eye"] = "Oeil d'aigle",
		["Earth Elemental Totem"] = "Earth Elemental Totem",  --  Need to translated
		["Earth Shield"] = "Earth Shield",  --  Need to translated
		["Earth Shock"] = "Horion de terre",
		["Earthbind Totem"] = "Totem de lien terrestre",
		["Efficiency"] = "Efficacit\195\169",
		["Elemental Focus"] = "Focalisation \195\169l\195\169mentaire",
		["Elemental Fury"] = "Fureur \195\169l\195\169mentaire",
		["Elemental Leatherworking"] = "Travail du cuir \195\169l\195\169mentaire",
		["Elemental Mastery"] = "Ma\195\174trise \195\169l\195\169mentaire",
		["Elemental Precision"] = "Pr\195\169cision \195\169l\195\169mentaire",
		["Elemental Sharpening Stone"] = "Pierre \195\160 aiguiser \195\169l\195\169mentaire",
		["Elune's Grace"] = "Gr\195\162ce d'Elune",
		["Elusiveness"] = "Insaisissable",
		["Emberstorm"] = "Temp\195\170te ardente",
		["Enamored Water Spirit"] = "Enamored Water Spirit",  --  Need to translated
		["Enchanting"] = "Enchantement",
		["Endurance Training"] = "Entra\195\174nement \195\160 l'Endurance",
		["Endurance"] = "Endurance",
		["Engineering Specialization"] = "Sp\195\169cialisation",
		["Engineering"] = "Ing\195\169nieur",
		["Enrage"] = "Enrager",
		["Enriched Manna Biscuit"] = "Biscuit enrichi en manne",
		["Enslave Demon"] = "Asservir d\195\169mon",
		["Entangling Roots"] = "Sarments",
		["Entrapment"] = "Pi\195\168ge",
		["Envenom"] = "Envenom",  --  Need to translated
		["Escape Artist"] = "Ma\195\174tre de l'\195\169vasion",
		["Evasion"] = "Evasion",
		["Eventide"] = "Eventide",  --  Need to translated
		["Eviscerate"] = "Evisc\195\169ration",
		["Evocation"] = "Evocation",
		["Execute"] = "Ex\195\169cution",
		["Exorcism"] = "Exorcisme",
		["Expansive Mind"] = "Pens\195\169e expansive",
		["Explosive Trap Effect"] = "Effet Pi\195\168ge explosif",
		["Explosive Trap"] = "Pi\195\168ge explosif",
		["Expose Armor"] = "Exposer l'armure",
		["Expose Weakness"] = "Perce-faille",
		["Eye for an Eye"] = "Oeil pour oeil",
		["Eye of Kilrogg"] = "Oeil de Kilrogg",
		["Eyes of the Beast"] = "Oeil de la b\195\170te",
		["Fade"] = "Oubli",
		["Faerie Fire (Feral)"] = "Lucioles (farouche)",
		["Faerie Fire"] = "Lucioles",
		["Far Sight"] = "Double vue",
		["Fear Ward"] = "Gardien de peur",
		["Fear"] = "Peur",
		["Feed Pet"] = "Nourrir le familier",
		["Feedback"] = "R\195\169action",
		["Feign Death"] = "Feindre la mort",
		["Feint"] = "Feinte",
		["Fel Armor"] = "Fel Armor",  --  Need to translated
		["Fel Concentration"] = "Concentration corrompue",
		["Fel Domination"] = "Domination corrompue",
		["Fel Intellect"] = "Intelligence corrompue",
		["Fel Stamina"] = "Endurance corrompue",
		["Felfire"] = "Gangrefeu",
		["Feline Grace"] = "Gr\195\162ce f\195\169line",
		["Feline Swiftness"] = "C\195\169l\195\169rit\195\169 f\195\169line",
		["Feral Aggression"] = "Agressivit\195\169 farouche",
		["Feral Charge"] = "Charge farouche",
		["Feral Instinct"] = "Instinct farouche",
		["Ferocious Bite"] = "Morsure f\195\169roce",
		["Ferocity"] = "Ferocit\195\169",
		["Fetish"] = "F\195\169tiche",
		["Find Herbs"] = "D\195\169couverte d'herbes",
		["Find Minerals"] = "D\195\169couverte de gisements",
		["Find Treasure"] = "D\195\169couverte de tr\195\169sors",
		["Fire Blast"] = "Trait de feu",
		["Fire Elemental Totem"] = "Fire Elemental Totem",  --  Need to translated
		["Fire Nova Totem"] = "Totem Nova de feu",
		["Fire Power"] = "Puissance du feu",
		["Fire Resistance Aura"] = "Aura de r\195\169sistance au Feu",
		["Fire Resistance Totem"] = "Totem de r\195\169sistance au Feu",
		["Fire Resistance"] = "R\195\169sistance au Feu",
		["Fire Shield"] = "Bouclier de feu",
		["Fire Vulnerability"] = "Vuln\195\169rabilit\195\169 au Feu",
		["Fire Ward"] = "Gardien de feu",
		["Fire Weakness"] = "Sensibilit\195\169 au Feu",
		["Fireball"] = "Boule de feu",
		["Firebolt"] = "Eclair de feu",
		["First Aid"] = "Premiers soins",
		["Fishing Poles"] = "Cannes \195\160 p\195\170che",
		["Fishing"] = "P\195\170che",
		["Fist Weapon Specialization"] = "Sp\195\169cialisation Arme de pugilat",
		["Fist Weapons"] = "Armes de pugilat",
		["Flame Shock"] = "Horion de flammes",
		["Flame Throwing"] = "Jet de flammes",
		["Flamestrike"] = "Choc de flammes",
		["Flamethrower"] = "Lance-flammes",
		["Flametongue Totem"] = "Totem Langue de feu",
		["Flametongue Weapon"] = "Arme Langue de feu",
		["Flare"] = "Fus\195\169e \195\169clairante",
		["Flash Heal"] = "Soins rapides",
		["Flash of Light"] = "Eclair lumineux",
		["Flight Form"] = "Flight Form",  --  Need to translated
		["Flurry"] = "Rafale",
		["Focused Casting"] = "Incantation focalis\195\169e",
		["Focused Mind"] = "Esprit focalis\195\169e",
		["Food"] = "Nourriture",
		["Forbearance"] = "Longanimit\195\169",
		["Force of Nature"] = "Force de la nature",
		["Force of Will"] = "Force de volont\195\169",
		["Freezing Trap Effect"] = "Effet Pi\195\168ge givrant",
		["Freezing Trap"] = "Pi\195\168ge givrant",
		["Frenzied Regeneration"] = "R\195\169g\195\169n\195\169ration fr\195\169n\195\169tique",
		["Frenzy"] = "Fr\195\169n\195\169sie",
		["Frost Armor"] = "Armure de givre",
		["Frost Channeling"] = "Canalisation du givre",
		["Frost Nova"] = "Nova de givre",
		["Frost Resistance Aura"] = "Aura de r\195\169sistance au Givre",
		["Frost Resistance Totem"] = "Totem de r\195\169sistance au Givre",
		["Frost Resistance"] = "R\195\169sistance au Givre",
		["Frost Shock"] = "Horion de givre",
		["Frost Trap Aura"] = "Aura Pi\195\168ge de givre",
		["Frost Trap"] = "Pi\195\168ge de givre",
		["Frost Ward"] = "Gardien de givre",
		["Frost Warding"] = "Protection contre le Givre",
		["Frost Weakness"] = "Sensibilit\195\169 au Givre",
		["Frostbite"] = "Morsure du givre",
		["Frostbolt"] = "Eclair de givre",
		["Frostbrand Weapon"] = "Arme de givre",
		["Furious Howl"] = "Hurlement furieux",
		["Furor"] = "Fureur",
		["Garrote"] = "Garrot",
		["Generic"] = "G\195\169n\195\169rique",
		["Ghost Wolf"] = "Loup fant\195\180me",
		["Ghostly Strike"] = "Frappe fantomatique",
		["Gift of Life"] = "Don de vie",
		["Gift of Nature"] = "Don de la Nature",
		["Gift of the Wild"] = "Don du fauve",
		["Gouge"] = "Suriner",
		["Grace of Air Totem"] = "Totem de Gr\195\162ce a\195\169rienne",
		["Great Stamina"] = "Endurance sup\195\169rieure",
		["Greater Blessing of Kings"] = "B\195\169n\195\169diction des rois sup\195\169rieure",
		["Greater Blessing of Light"] = "B\195\169n\195\169diction de lumi\195\168re sup\195\169rieure",
		["Greater Blessing of Might"] = "B\195\169n\195\169diction de puissance sup\195\169rieure",
		["Greater Blessing of Salvation"] = "B\195\169n\195\169diction de salut sup\195\169rieure",
		["Greater Blessing of Sanctuary"] = "B\195\169n\195\169diction du sanctuaire sup\195\169rieure",
		["Greater Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse sup\195\169rieure",
		["Greater Heal"] = "Soins sup\195\169rieurs",
		["Grim Reach"] = "Allonge sinistre",
		["Grounding Totem"] = "Totem de Gl\195\168be",
		["Grovel"] = "Ramper",
		["Growl"] = "Grondement",
		["Guardian's Favor"] = "Faveur du Gardien",
		["Gun Specialization"] = "Sp\195\169cialisation Armes \195\160 feu",
		["Guns"] = "Armes \195\160 feu",
		["Hammer of Justice"] = "Marteau de la justice",
		["Hammer of Wrath"] = "Marteau de courroux",
		["Hamstring"] = "Brise-genou",
		["Harass"] = "Harc\195\168lement",
		["Hardiness"] = "Solidit\195\169",
		["Hawk Eye"] = "Oeil de faucon",
		["Heal"] = "Soins",
		["Healing Focus"] = "Focalisation des soins",
		["Healing Light"] = "Lumi\195\168re gu\195\169risseuse",
		["Healing Stream Totem"] = "Totem gu\195\169risseur",
		["Healing Touch"] = "Toucher gu\195\169risseur",
		["Healing Wave"] = "Vague de soins",
		["Healing Way"] = "Flots de soins",
		["Health Funnel"] = "Captation de vie",
		["Heart of the Wild"] = "C\197\147ur de fauve",
		["Heavy Sharpening Stone"] = "Pierre \195\160 aiguiser lourde",
		["Hellfire Effect"] = "Effet Flammes infernales",
		["Hellfire"] = "Flammes infernales",
		["Hemorrhage"] = "H\195\169morragie",
		["Herb Gathering"] = "Cueillette",
		["Herbalism"] = "Herboristerie",
		["Heroic Strike"] = "Frappe h\195\169ro\195\175que",
		["Heroism"] = "H\195\169ro\195\175sme",
		["Hex of Weakness"] = "Mal\195\169fice de faiblesse",
		["Hibernate"] = "Hibernation",
		["Holy Fire"] = "Flammes sacr\195\169es",
		["Holy Light"] = "Lumi\195\168re sacr\195\169e",
		["Holy Nova"] = "Nova sacr\195\169e",
		["Holy Power"] = "Puissance sacr\195\169e",
		["Holy Reach"] = "Allonge du Sacr\195\169",
		["Holy Shield"] = "Bouclier sacr\195\169",
		["Holy Shock"] = "Horion sacr\195\169",
		["Holy Specialization"] = "Sp\195\169cialisation",
		["Holy Wrath"] = "Col\195\168re divine",
		["Honorless Target"] = "Cible sans honneur",
		["Horse Riding"] = "Equitation",
		["Howl of Terror"] = "Hurlement de terreur",
		["Humanoid Slaying"] = "Tueur d'humano\195\175des",
		["Hunter's Mark"] = "Marque du chasseur",
		["Hurricane"] = "Ouragan",
		["Ice Armor"] = "Armure de glace",
		["Ice Barrier"] = "Barri\195\168re de glace",
		["Ice Block"] = "Parade de glace",
		["Ice Lance"] = "Ice Lance",  --  Need to translated
		["Ice Shards"] = "Eclats de glace",
		["Ignite"] = "Enflammer",
		["Illumination"] = "Illumination",
		["Immolate"] = "Immolation",
		["Immolation Trap Effect"] = "Effet de Pi\195\168ge d'immolation",
		["Immolation Trap"] = "Pi\195\168ge d'Immolation",
		["Impact"] = "Impact",
		["Impale"] = "Empaler",
		["Improved Ambush"] = "Embuscade am\195\169lior\195\169e",
		["Improved Arcane Explosion"] = "Explosion des arcanes am\195\169lior\195\169e",
		["Improved Arcane Missiles"] = "Projectiles des arcanes am\195\169lior\195\169s",
		["Improved Arcane Shot"] = "Tir des arcanes am\195\169lior\195\169",
		["Improved Aspect of the Hawk"] = "Aspect du faucon am\195\169lior\195\169",
		["Improved Aspect of the Monkey"] = "Aspect du singe am\195\169lior\195\169",
		["Improved Backstab"] = "Attaque sournoise am\195\169lior\195\169e",
		["Improved Battle Shout"] = "Cri de guerre am\195\169lior\195\169",
		["Improved Berserker Rage"] = "Rage berserker am\195\169lior\195\169e",
		["Improved Blessing of Might"] = "B\195\169n\195\169diction de puissance am\195\169lior\195\169e",
		["Improved Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse am\195\169lior\195\169e",
		["Improved Blizzard"] = "Blizzard am\195\169lior\195\169",
		["Improved Bloodrage"] = "Rage sanguinaire am\195\169lior\195\169e",
		["Improved Chain Heal"] = "Salve de gu\195\169rison am\195\169lior\195\169e",
		["Improved Chain Lightning"] = "Cha\195\174ne d'\195\169clairs am\195\169lior\195\169e",
		["Improved Challenging Shout"] = "Cri de d\195\169fi am\195\169lior\195\169",
		["Improved Charge"] = "Charge am\195\169lior\195\169e",
		["Improved Cheap Shot"] = "Improved Cheap Shot",  --  Need to translated
		["Improved Cleave"] = "Encha\195\174nement am\195\169lior\195\169",
		["Improved Concentration Aura"] = "Aura de concentration am\195\169lior\195\169e",
		["Improved Concussive Shot"] = "Trait de choc am\195\169lior\195\169",
		["Improved Cone of Cold"] = "C\195\180ne de froid am\195\169lior\195\169",
		["Improved Corruption"] = "Corruption am\195\169lior\195\169e",
		["Improved Counterspell"] = "Contresort am\195\169lior\195\169",
		["Improved Curse of Agony"] = "Mal\195\169diction d'agonie am\195\169lior\195\169e",
		["Improved Curse of Exhaustion"] = "Mal\195\169diction de fatigue am\195\169lior\195\169e",
		["Improved Curse of Weakness"] = "Mal\195\169diction de faiblesse am\195\169lior\195\169e",
		["Improved Dampen Magic"] = "Improved Dampen Magic",  --  Need to translated
		["Improved Deadly Poison"] = "Poison mortel am\195\169lior\195\169",
		["Improved Demoralizing Shout"] = "Cri d\195\169moralisant am\195\169lior\195\169",
		["Improved Devotion Aura"] = "Aura de d\195\169votion am\195\169lior\195\169e",
		["Improved Disarm"] = "D\195\169sarmement am\195\169lior\195\169",
		["Improved Distract"] = "Distraction am\195\169lior\195\169e",
		["Improved Drain Life"] = "Drain de vie am\195\169lior\195\169",
		["Improved Drain Mana"] = "Drain de mana am\195\169lior\195\169",
		["Improved Drain Soul"] = "Siphon d'\195\162me am\195\169lior\195\169",
		["Improved Enrage"] = "Enrager am\195\169lior\195\169",
		["Improved Enslave Demon"] = "Asservir d\195\169mon am\195\169lior\195\169",
		["Improved Entangling Roots"] = "Sarments am\195\169lior\195\169s",
		["Improved Evasion"] = "Improved Evasion",  --  Need to translated
		["Improved Eviscerate"] = "Evisc\195\169ration am\195\169lior\195\169e",
		["Improved Execute"] = "Ex\195\169cution am\195\169lior\195\169e",
		["Improved Expose Armor"] = "Exposer l'armure am\195\169lior\195\169",
		["Improved Eyes of the Beast"] = "Oeil de la b\195\170te am\195\169lior\195\169",
		["Improved Fade"] = "Oubli am\195\169lior\195\169",
		["Improved Feign Death"] = "Feindre la mort am\195\169lior\195\169",
		["Improved Fire Blast"] = "Trait de feu am\195\169lior\195\169",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem",  --  Need to translated
		["Improved Fire Ward"] = "Gardien de feu am\195\169lior\195\169",
		["Improved Fireball"] = "Boule de feu am\195\169lior\195\169e",
		["Improved Firebolt"] = "Eclair de feu am\195\169lior\195\169",
		["Improved Firestone"] = "Pierre de feu am\195\169lior\195\169e",
		["Improved Flamestrike"] = "Choc de flammes am\195\169lior\195\169",
		["Improved Flametongue Weapon"] = "Arme Langue de feu am\195\169lior\195\169e",
		["Improved Flash of Light"] = "Eclair lumineux am\195\169lior\195\169",
		["Improved Frost Nova"] = "Nova de givre am\195\169lior\195\169e",
		["Improved Frost Ward"] = "Gardien de givre am\195\169lior\195\169",
		["Improved Frostbolt"] = "Eclair de givre am\195\169lior\195\169",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon",  --  Need to translated
		["Improved Garrote"] = "Improved Garrote",  --  Need to translated
		["Improved Ghost Wolf"] = "Loup fant\195\180me am\195\169lior\195\169",
		["Improved Gouge"] = "Suriner am\195\169lior\195\169",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem",  --  Need to translated
		["Improved Grounding Totem"] = "Improved Grounding Totem",  --  Need to translated
		["Improved Hammer of Justice"] = "Marteau de la justice am\195\169lior\195\169",
		["Improved Hamstring"] = "Brise-genou am\195\169lior\195\169",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem",  --  Need to translated
		["Improved Healing Touch"] = "Toucher gu\195\169risseur am\195\169lior\195\169",
		["Improved Healing Wave"] = "Vague de soins am\195\169lior\195\169e",
		["Improved Healing"] = "Soin am\195\169lior\195\169",
		["Improved Health Funnel"] = "Captation de vie am\195\169lior\195\169e",
		["Improved Healthstone"] = "Pierre de soins am\195\169lior\195\169e",
		["Improved Heroic Strike"] = "Frappe h\195\169ro\195\175que am\195\169lior\195\169e",
		["Improved Hunter's Mark"] = "Marque du chasseur am\195\169lior\195\169e",
		["Improved Immolate"] = "Immolation am\195\169lior\195\169e",
		["Improved Imp"] = "Diablotin am\195\169lior\195\169",
		["Improved Inner Fire"] = "Feu int\195\169rieur am\195\169lior\195\169",
		["Improved Instant Poison"] = "Improved Instant Poison",  --  Need to translated
		["Improved Intercept"] = "Interception am\195\169lior\195\169e",
		["Improved Intimidating Shout"] = "Cri d\226\128\153intimidation am\195\169lior\195\169",
		["Improved Judgement"] = "Jugement am\195\169lior\195\169",
		["Improved Kick"] = "Coup de pied am\195\169lior\195\169",
		["Improved Kidney Shot"] = "Aiguillon perfide am\195\169lior\195\169",
		["Improved Lash of Pain"] = "Fouet de la douleur am\195\169lior\195\169",
		["Improved Lay on Hands"] = "Imposition des mains am\195\169lior\195\169e",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave",  --  Need to translated
		["Improved Life Tap"] = "Connexion am\195\169lior\195\169e",
		["Improved Lightning Bolt"] = "Eclair am\195\169lior\195\169",
		["Improved Lightning Shield"] = "Bouclier de foudre am\195\169lior\195\169",
		["Improved Magma Totem"] = "Totem de Magma am\195\169lior\195\169",
		["Improved Mana Burn"] = "Br\195\187lure de mana am\195\169lior\195\169e",
		["Improved Mana Shield"] = "Bouclier de mana am\195\169lior\195\169",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem",  --  Need to translated
		["Improved Mark of the Wild"] = "Marque du fauve am\195\169lior\195\169e",
		["Improved Mend Pet"] = "Gu\195\169rison du familier am\195\169lior\195\169e",
		["Improved Mind Blast"] = "Attaque mentale am\195\169lior\195\169e",
		["Improved Moonfire"] = "Eclat lunaire am\195\169lior\195\169",
		["Improved Nature's Grasp"] = "Emprise de la nature am\195\169lior\195\169e",
		["Improved Overpower"] = "Fulgurance am\195\169lior\195\169e",
		["Improved Power Word: Fortitude"] = "Mot de pouvoir : Robustesse am\195\169lior\195\169",
		["Improved Power Word: Shield"] = "Mot de pouvoir : Bouclier am\195\169lior\195\169",
		["Improved Prayer of Healing"] = "Pri\195\168re de soins am\195\169lior\195\169e",
		["Improved Psychic Scream"] = "Cri psychique am\195\169lior\195\169",
		["Improved Pummel"] = "Vol\195\169e de coups am\195\169lior\195\169e",
		["Improved Regrowth"] = "R\195\169tablissement am\195\169lior\195\169",
		["Improved Reincarnation"] = "R\195\169incarnation am\195\169lior\195\169e",
		["Improved Rejuvenation"] = "R\195\169cup\195\169ration am\195\169lior\195\169e",
		["Improved Rend"] = "Pourfendre am\195\169lior\195\169",
		["Improved Renew"] = "R\195\169novation am\195\169lior\195\169e",
		["Improved Retribution Aura"] = "Aura de vindicte am\195\169lior\195\169e",
		["Improved Revenge"] = "Vengeance am\195\169lior\195\169e",
		["Improved Revive Pet"] = "Ressusciter le familier am\195\169lior\195\169",
		["Improved Righteous Fury"] = "Fureur vertueuse am\195\169lior\195\169e",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon",  --  Need to translated
		["Improved Rupture"] = "Rupture am\195\169lior\195\169e",
		["Improved Sap"] = "Assommer am\195\169lior\195\169",
		["Improved Scorch"] = "Br\195\187lure am\195\169lior\195\169e",
		["Improved Scorpid Sting"] = "Piq\195\187re de scorpide am\195\169lior\195\169e",
		["Improved Seal of Righteousness"] = "Sceau de pi\195\169t\195\169 am\195\169lior\195\169",
		["Improved Seal of the Crusader"] = "Sceau du Crois\195\169 am\195\169lior\195\169",
		["Improved Searing Pain"] = "Douleur br\195\187lante am\195\169lior\195\169e",
		["Improved Searing Totem"] = "Improved Searing Totem",  --  Need to translated
		["Improved Serpent Sting"] = "Morsure de serpent am\195\169lior\195\169e",
		["Improved Shadow Bolt"] = "Trait de l'ombre am\195\169lior\195\169",
		["Improved Shadow Word: Pain"] = "Mot de l'ombre : Douleur am\195\169lior\195\169",
		["Improved Shield Bash"] = "Coup de bouclier am\195\169lior\195\169",
		["Improved Shield Block"] = "Ma\195\174trise du blocage am\195\169lior\195\169e",
		["Improved Shield Wall"] = "Mur protecteur am\195\169lior\195\169",
		["Improved Shred"] = "Lambeau am\195\169lior\195\169",
		["Improved Sinister Strike"] = "Attaque pernicieuse am\195\169lior\195\169e",
		["Improved Slam"] = "Heurtoir am\195\169lior\195\169",
		["Improved Slice and Dice"] = "D\195\169biter am\195\169lior\195\169",
		["Improved Spellstone"] = "Pierre de sort am\195\169lior\195\169e",
		["Improved Sprint"] = "Sprint am\195\169lior\195\169",
		["Improved Starfire"] = "Feu stellaire am\195\169lior\195\169",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem",  --  Need to translated
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem",  --  Need to translated
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem",  --  Need to translated
		["Improved Succubus"] = "Succube am\195\169lior\195\169e",
		["Improved Sunder Armor"] = "Fracasser armure am\195\169lior\195\169",
		["Improved Taunt"] = "Provocation am\195\169lior\195\169e",
		["Improved Thorns"] = "Epines am\195\169lior\195\169es",
		["Improved Thunder Clap"] = "Coup de tonnerre am\195\169lior\195\169",
		["Improved Tranquility"] = "Tranquillit\195\169 am\195\169lior\195\169e",
		["Improved Vampiric Embrace"] = "Etreinte vampirique am\195\169lior\195\169e",
		["Improved Vanish"] = "Disparition am\195\169lior\195\169e",
		["Improved Voidwalker"] = "Marcheur du Vide am\195\169lior\195\169",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon",  --  Need to translated
		["Improved Wing Clip"] = "Coupure d'ailes am\195\169lior\195\169e",
		["Improved Wrath"] = "Col\195\168re am\195\169lior\195\169e",
		["Incinerate"] = "Incin\195\169rer",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Feu int\195\169rieur",
		["Inner Focus"] = "Focalisation am\195\169lior\195\169e",
		["Innervate"] = "Innervation",
		["Insect Swarm"] = "Essaim d'insectes",
		["Inspiration"] = "Inspiration",
		["Instant Poison II"] = "Poison instantan\195\169 II",
		["Instant Poison III"] = "Poison instantan\195\169 III",
		["Instant Poison IV"] = "Poison instantan\195\169 IV",
		["Instant Poison V"] = "Poison instantan\195\169 V",
		["Instant Poison VI"] = "Poison instantan\195\169 VI",
		["Instant Poison"] = "Poison instantan\195\169",
		["Intensity"] = "Intensit\195\169",
		["Intercept Stun"] = "Interception \195\169tourdissante",
		["Intercept"] = "Interception",
		["Intervene"] = "Intervene",  --  Need to translated
		["Intimidating Shout"] = "Cri d\226\128\153intimidation",
		["Intimidation"] = "Intimidation",
		["Invisibility"] = "Invisibility",  --  Need to translated
		["Iron Will"] = "Volont\195\169 de fer",
		["Jewelcrafting"] = "Jewelcrafting",
		["Judgement of Command"] = "Jugement d'autorit\195\169",
		["Judgement of Justice"] = "Jugement de justice",
		["Judgement of Light"] = "Jugement de lumi\195\168re",
		["Judgement of Righteousness"] = "Jugement de pi\195\169t\195\169",
		["Judgement of the Crusader"] = "Jugement du Crois\195\169",
		["Judgement of Wisdom"] = "Jugement de sagesse",
		["Judgement"] = "Jugement",
		["Kick - Silenced"] = "Coup de pied - Silencieux",
		["Kick"] = "Coup de pied",
		["Kidney Shot"] = "Aiguillon perfide",
		["Kill Command"] = "Kill Command",  --  Need to translated
		["Killer Instinct"] = "Instinct du tueur",
		["Kodo Riding"] = "Monte de kodo",
		["Lacerate"] = "Lacerate",  --  Need to translated
		["Lacerate"] = "Lac\195\169rer",
		["Lash of Pain"] = "Fouet de la douleur",
		["Last Stand"] = "Dernier rempart",
		["Lasting Judgement"] = "Jugement durable",
		["Lay on Hands"] = "Imposition des mains",
		["Leader of the Pack"] = "Chef de la meute",
		["Leather"] = "Cuir",
		["Leatherworking"] = "Travail du cuir",
		["Lesser Heal"] = "Soins inf\195\169rieurs",
		["Lesser Healing Wave"] = "Vague de soins inf\195\169rieurs",
		["Lesser Invisibility"] = "Invisibilit\195\169 inf\195\169rieure",
		["Lethal Shots"] = "Coups fatals",
		["Lethality"] = "Mortalit\195\169",
		["Levitate"] = "L\195\169vitation",
		["Libram"] = "Libram",
		["Life Tap"] = "Connexion",
		["Lifebloom"] = "Lifebloom",  --  Need to translated
		["Lifegiving Gem"] = "Lifegiving Gem",
		["Lightning Bolt"] = "Eclair",
		["Lightning Breath"] = "Souffle de foudre",
		["Lightning Mastery"] = "Ma\195\174trise de la foudre",
		["Lightning Reflexes"] = "R\195\169flexes \195\169clairs",
		["Lightning Shield"] = "Bouclier de foudre",
		["Lightwell Renew"] = "R\195\169novation du Puits de lumi\195\168re",
		["Lightwell"] = "Puits de lumi\195\168re",
		["Lockpicking"] = "Crochetage",
		["Long Daze"] = "H\195\169b\195\169tement prolong\195\169",
		["Mace Specialization"] = "Sp\195\169cialisation Masse",
		["Mace Stun Effect"] = "Effet \195\169tourdissant de la masse",
		["Mage Armor"] = "Armure du mage",
		["Magic Attunement"] = "Harmonisation de la magie",
		["Magma Totem"] = "Totem de Magma",
		["Mail"] = "Mailles",
		["Maim"] = "Maim",  --  Need to translated
		["Malice"] = "Malice",
		["Mana Burn"] = "Br\195\187lure de mana",
		["Mana Feed"] = "Festin de mana",
		["Mana Shield"] = "Bouclier de mana",
		["Mana Spring Totem"] = "Totem Fontaine de mana",
		["Mana Tide Totem"] = "Totem de Vague de mana",
		["Mangle (Bear)"] = "Mangle (Bear)",  --  Need to translated
		["Mangle (Cat)"] = "Mangle (Cat)",  --  Need to translated
		["Mangle"] = "Mutilation",
		["Mark of the Wild"] = "Marque du fauve",
		["Martyrdom"] = "Martyre",
		["Mass Dispel"] = "Dissipation de masse",
		["Master Demonologist"] = "Ma\195\174tre d\195\169monologue",
		["Master of Deception"] = "Ma\195\174tre des illusions",
		["Master of Elements"] = "Ma\195\174tre des \195\169l\195\169ments",
		["Master Summoner"] = "Ma\195\174tre invocateur",
		["Maul"] = "Mutiler",
		["Mechanostrider Piloting"] = "Pilotage de m\195\169canotrotteur",
		["Meditation"] = "M\195\169ditation",
		["Melee Specialization"] = "Sp\195\169cialisation M\195\170l\195\169e",
		["Mend Pet"] = "Gu\195\169rison du familier",
		["Mental Agility"] = "Sagacit\195\169",
		["Mental Strength"] = "Force mentale",
		["Mind Blast"] = "Attaque mentale",
		["Mind Control"] = "Contr\195\180le mental",
		["Mind Flay"] = "Fouet mental",
		["Mind Soothe"] = "Apaisement",
		["Mind Vision"] = "Vision t\195\169l\195\169pathique",
		["Mind-numbing Poison II"] = "Poison de distraction mentale II",
		["Mind-numbing Poison III"] = "Poison de distraction mentale III",
		["Mind-numbing Poison"] = "Poison de distraction mentale",
		["Mining"] = "Minage",
		["Misdirection"] = "Misdirection",  --  Need to translated
		["Mocking Blow"] = "Coup railleur",
		["Molten Armor"] = "Molten Armor",  --  Need to translated
		["Mongoose Bite"] = "Morsure de la mangouste",
		["Monster Slaying"] = "Tueur de monstres",
		["Moonfire"] = "Eclat lunaire",
		["Moonfury"] = "Fureur lunaire",
		["Moonglow"] = "Lueur de la lune",
		["Moonkin Aura"] = "Aura de s\195\169l\195\169nien",
		["Moonkin Form"] = "Forme de s\195\169l\195\169nien",
		["Mortal Shots"] = "Coups mortels",
		["Mortal Strike"] = "Frappe mortelle",
		["Multi-Shot"] = "Fl\195\168ches multiples",
		["Murder"] = "Meurtre",
		["Mutilate"] = "Mutilate",  --  Need to translated
		["Natural Armor"] = "Armure naturelle",
		["Natural Shapeshifter"] = "Changeforme naturel",
		["Natural Weapons"] = "Armes naturelles",
		["Nature Resistance Totem"] = "Totem de r\195\169sistance \195\160 la Nature",
		["Nature Resistance"] = "R\195\169sistance \195\160 la Nature",
		["Nature Weakness"] = "Sensibilit\195\169 \195\160 la Nature",
		["Nature's Focus"] = "Focalisation de la nature",
		["Nature's Grace"] = "Gr\195\162ce de la nature",
		["Nature's Grasp"] = "Emprise de la nature",
		["Nature's Reach"] = "Allonge de la Nature",
		["Nature's Swiftness"] = "Rapidit\195\169 de la nature",
		["Negative Charge"] = "Charge n\195\169gative",
		["Nightfall"] = "Cr\195\169puscule",
		["Omen of Clarity"] = "Augure de clart\195\169",
		["One-Handed Axes"] = "Haches \195\160 une main",
		["One-Handed Maces"] = "Masses \195\160 une main",
		["One-Handed Swords"] = "Ep\195\169es \195\160 une main",
		["One-Handed Weapon Specialization"] = "Sp\195\169cialisation Arme 1M",
		["Opening - No Text"] = "Ouverture - pas de texte",
		["Opening"] = "Ouverture",
		["Opportunity"] = "Opportunit\195\169",
		["Overpower"] = "Fulgurance",
		["Pain Suppression"] = "Pain Suppression",  --  Need to translated
		["Paranoia"] = "Parano\195\175a",
		["Parry"] = "Parade",
		["Pathfinding"] = "Science des chemins",
		["Perception"] = "Perception",
		["Permafrost"] = "Gel prolong\195\169",
		["Pet Aggression"] = "Agressivit\195\169 du familier",
		["Pet Hardiness"] = "Robustesse du familier",
		["Pet Recovery"] = "R\195\169tablissement du familier",
		["Pet Resistance"] = "R\195\169sistance du familier",
		["Phase Shift"] = "Changement de phase",
		["Pick Lock"] = "Crochetage",
		["Pick Pocket"] = "Vol \195\160 la tire",
		["Piercing Howl"] = "Hurlement per\195\167ant",
		["Piercing Ice"] = "Glace per\195\167ante",
		["Plate Mail"] = "Armure en plaques",
		["Poison Cleansing Totem"] = "Totem de Purification du poison",
		["Poisons"] = "Poisons",
		["Polearm Specialization"] = "Sp\195\169cialisation Arme d'hast",
		["Polearms"] = "Armes d'hast",
		["Polymorph"] = "M\195\169tamorphose",
		["Polymorph: Pig"] = "M\195\169tamorphose: cochon",
		["Polymorph: Turtle"] = "M\195\169tamorphose: Tortue",  -- all other polymorph spells don't have a capital letter before the animal name, to test
		["Portal: Darnassus"] = "Portail : Darnassus",
		["Portal: Ironforge"] = "Portail : Forgefer",
		["Portal: Orgrimmar"] = "Portail : Orgrimmar",
		["Portal: Stormwind"] = "Portail : Hurlevent",
		["Portal: Thunder Bluff"] = "Portail : Pitons du Tonnerre",
		["Portal: Undercity"] = "Portail : Fossoyeuse",
		["Positive Charge"] = "Charge positive",
		["Pounce Bleed"] = "Traquenard sanglant",
		["Pounce"] = "Traquenard",
		["Power Infusion"] = "Infusion de puissance",
		["Power Word: Fortitude"] = "Mot de pouvoir\194\160: Robustesse",
		["Power Word: Shield"] = "Mot de pouvoir\194\160: Bouclier",
		["Prayer of Fortitude"] = "Pri\195\168re de robustesse",
		["Prayer of Healing"] = "Pri\195\168re de soins",
		["Prayer of Mending"] = "Prayer of Mending",  --  Need to translated
		["Prayer of Shadow Protection"] = "Pri\195\168re de protection contre l'Ombre",
		["Prayer of Spirit"] = "Pri\195\168re d'Esprit",
		["Precision"] = "Pr\195\169cision",
		["Predatory Strikes"] = "Frappes de pr\195\169dateur",
		["Premeditation"] = "Pr\195\169m\195\169ditation",
		["Preparation"] = "Pr\195\169paration",
		["Presence of Mind"] = "Pr\195\169sence spirituelle",
		["Primal Fury"] = "Fureur primitive",
		["Prowl"] = "R\195\180der",
		["Psychic Scream"] = "Cri psychique",
		["Pummel"] = "Vol\195\169e de coups",
		["Purge"] = "Expiation",
		["Purification"] = "Purification",
		["Purify"] = "Purification",
		["Pursuit of Justice"] = "Poursuite de la justice",
		["Pyroblast"] = "Explosion pyrotechnique",
		["Pyroclasm"] = "Pyroclasme",
		["Quick Shots"] = "Quick Shots",
		["Quick Shots"] = "Tir rapide",
		["Quickness"] = "Rapidit\195\169",
		["Rain of Fire"] = "Pluie de feu",
		["Rake"] = "Griffure",
		["Ram Riding"] = "Monte de b\195\169lier",
		["Rampage"] = "Saccager",
		["Ranged Weapon Specialization"] = "Sp\195\169cialisation Armes \195\160 distance",
		["Rapid Concealment"] = "Rapid Concealment",  --  Need to translated
		["Rapid Fire"] = "Tir rapide",
		["Raptor Riding"] = "Monte de raptor",
		["Raptor Strike"] = "Attaque du raptor",
		["Ravage"] = "Ravage",
		["Readiness"] = "Promptitude",
		["Rebirth"] = "Renaissance",
		["Reckless Charge"] = "Charge furieuse",
		["Recklessness"] = "T\195\169m\195\169rit\195\169",
		["Reckoning"] = "R\195\169tribution",
		["Redemption"] = "R\195\169demption",
		["Redoubt"] = "Redoute",
		["Reflection"] = "Renvoi",
		["Regeneration"] = "R\195\169g\195\169n\195\169ration",
		["Regrowth"] = "R\195\169tablissement",
		["Reincarnation"] = "R\195\169incarnation",
		["Rejuvenation"] = "R\195\169cup\195\169ration",
		["Relentless Strikes"] = "Frappes implacables",
		["Remorseless Attacks"] = "Attaques impitoyables",
		["Remorseless"] = "Impitoyable",
		["Remove Curse"] = "D\195\169livrance de la mal\195\169diction",
		["Remove Insignia"] = "Enlever l'insigne",
		["Remove Lesser Curse"] = "D\195\169livrance de la mal\195\169diction mineure",
		["Rend"] = "Pourfendre",
		["Renew"] = "R\195\169novation",
		["Repentance"] = "Repentir",
		["Restorative Totems"] = "Totems de restauration",
		["Resurrection"] = "R\195\169surrection",
		["Retaliation"] = "Repr\195\169sailles",
		["Retribution Aura"] = "Aura de vindicte",
		["Revenge Stun"] = "Etourdissement vengeur",
		["Revenge"] = "Vengeance",
		["Reverberation"] = "R\195\169verb\195\169ration",
		["Revive Pet"] = "Ressusciter le familier",
		["Righteous Defense"] = "Righteous Defense",  --  Need to translated
		["Righteous Fury"] = "Fureur vertueuse",
		["Rip"] = "D\195\169chirure",
		["Riposte"] = "Riposte",
		["Ritual of Doom Effect"] = "Effet Rituel de mal\195\169diction",
		["Ritual of Doom"] = "Rituel de mal\195\169diction",
		["Ritual of Souls"] = "Ritual of Souls",  --  Need to translated
		["Ritual of Summoning"] = "Rituel d'invocation",
		["Rockbiter Weapon"] = "Arme Croque-roc",
		["Rogue Passive"] = "Voleur",
		["Rough Sharpening Stone"] = "Pierre \195\160 aiguiser brute",
		["Ruin"] = "Ruine",
		["Rupture"] = "Rupture",
		["Ruthlessness"] = "N\195\169m\195\169sis",
		["Sacrifice"] = "Sacrifice",
		["Safe Fall"] = "Chute amortie",
		["Sanctity Aura"] = "Aura de saintet\195\169",
		["Sap"] = "Assommer",
		["Savage Fury"] = "Furie sauvage",
		["Savage Strikes"] = "Frappes sauvages",
		["Scare Beast"] = "Effrayer une b\195\170te",
		["Scatter Shot"] = "Fl\195\168che de dispersion",
		["Scorch"] = "Br\195\187lure",
		["Scorpid Poison"] = "Poison de scorpide",
		["Scorpid Sting"] = "Piq\195\187re de scorpide",
		["Screech"] = "Hurlement",
		["Seal Fate"] = "Scelle le destin",
		["Seal of Blood"] = "Seal of Blood",  --  Need to translated
		["Seal of Command"] = "Sceau d'autorit\195\169",
		["Seal of Justice"] = "Sceau de justice",
		["Seal of Light"] = "Sceau de lumi\195\168re",
		["Seal of Righteousness"] = "Sceau de pi\195\169t\195\169",
		["Seal of the Crusader"] = "Sceau du Crois\195\169",
		["Seal of Vengeance"] = "Seal of Vengeance",  --  Need to translated
		["Seal of Wisdom"] = "Sceau de sagesse",
		["Searing Light"] = "Lumi\195\168re incendiaire",
		["Searing Pain"] = "Douleur br\195\187lante",
		["Searing Totem"] = "Totem incendiaire",
		["Second Wind"] = "Second souffle",
		["Seduction"] = "S\195\169duction",
		["Seed of Corruption"] = "Seed of Corruption",  --  Need to translated
		["Sense Demons"] = "D\195\169tection des d\195\169mons",
		["Sense Undead"] = "D\195\169tection des morts-vivants",
		["Sentry Totem"] = "Totem Sentinelle",
		["Serpent Sting"] = "Morsure de serpent",
		["Setup"] = "Pr\195\169paratifs",
		["Shackle Undead"] = "Entraves des morts-vivants",
		["Shadow Affinity"] = "Affinit\195\169 avec l'ombre",
		["Shadow Bolt"] = "Trait de l'ombre",
		["Shadow Focus"] = "Focalisation de l'ombre",
		["Shadow Mastery"] = "Ma\195\174trise de l'ombre",
		["Shadow Protection"] = "Protection contre l'Ombre",
		["Shadow Reach"] = "Allonge de l'Ombre",
		["Shadow Resistance Aura"] = "Aura de r\195\169sistance \195\160 l'Ombre",
		["Shadow Resistance"] = "R\195\169sistance \195\160 l'Ombre",
		["Shadow Trance"] = "Transe de l'ombre",
		["Shadow Vulnerability"] = "Vuln\195\169rabilit\195\169 \195\160 l'ombre",
		["Shadow Ward"] = "Gardien de l'ombre",
		["Shadow Weakness"] = "Sensibilit\195\169 \195\160 l'Ombre",
		["Shadow Weaving"] = "Tissage de l'ombre",
		["Shadow Word: Death"] = "Shadow Word: Death",  --  Need to translated
		["Shadow Word: Pain"] = "Mot de l'ombre\194\160: Douleur",
		["Shadowburn"] = "Br\195\187lure de l'ombre",
		["Shadowfiend"] = "Shadowfiend",  --  Need to translated
		["Shadowform"] = "Forme d'Ombre",
		["Shadowfury"] = "Shadowfury",  --  Need to translated
		["Shadowguard"] = "Garde de l'ombre",
		["Shadowmeld Passive"] = "Camouflage dans l'ombre",
		["Shadowmeld"] = "Camouflage dans l'ombre",
		["Shadowstep"] = "Shadowstep",  --  Need to translated
		["Shamanistic Rage"] = "Shamanistic Rage",  --  Need to translated
		["Sharpened Claws"] = "Griffes aiguis\195\169es",
		["Shatter"] = "Fracasser",
		["Sheep"] = "Sheep",  --  Need to translated
		["Shell Shield"] = "Carapace bouclier",
		["Shield Bash - Silenced"] = "Coup de bouclier - silencieux",  -- seems to be the only "- Silenced" not having a Cap letter, will try to test!
		["Shield Bash"] = "Coup de bouclier",
		["Shield Block"] = "Ma\195\174trise du blocage",
		["Shield Slam"] = "Heurt de bouclier",
		["Shield Specialization"] = "Sp\195\169cialisation Bouclier",
		["Shield Wall"] = "Mur protecteur",
		["Shield"] = "Bouclier",
		["Shiv"] = "Shiv",  --  Need to translated
		["Shoot Bow"] = "Tir \195\160 l'arc",
		["Shoot Crossbow"] = "Tir \195\160 l\226\128\153arbal\195\168te",
		["Shoot Gun"] = "Tir avec une arme \195\160 feu",
		["Shoot"] = "Tir",
		["Shred"] = "Lambeau",
		["Silence"] = "Silence",
		["Silencing Shot"] = "Fl\195\168che-ba\195\174llon",
		["Silent Resolve"] = "R\195\169solution silencieuse",
		["Sinister Strike"] = "Attaque pernicieuse",
		["Siphon Life"] = "Siphon de vie",
		["Skinning"] = "D\195\169pe\195\167age",
		["Slam"] = "Heurtoir",
		["Sleep"] = "Sommeil",
		["Slice and Dice"] = "D\195\169biter",
		["Slow Fall"] = "Chute lente",
		["Slow"] = "Lenteur",
		["Smelting"] = "Fondre",
		["Smite"] = "Ch\195\162timent",
		["Snake Trap"] = "Snake Trap",  --  Need to translated
		["Solid Sharpening Stone"] = "Pierre \195\160 aiguiser solide",
		["Soothe Animal"] = "Apaiser les animaux",
		["Soothing Kiss"] = "Baiser apaisant",
		["Soul Fire"] = "Feu de l'\195\162me",
		["Soul Link"] = "Lien spirituel",
		["Soul Siphon"] = "Siphon d'\195\162me",
		["Soulshatter"] = "Soulshatter",  --  Need to translated
		["Soulstone Resurrection"] = "R\195\169surrection de Pierre d'\195\162me",
		["Spell Lock"] = "Verrou magique",
		["Spell Reflection"] = "Renvoi de sort",
		["Spell Warding"] = "Protection contre les sorts",
		["Spellsteal"] = "Spellsteal",  --  Need to translated
		["Spirit Bond"] = "Engagement spirituel",
		["Spirit of Redemption"] = "Esprit de r\195\169demption",
		["Spirit Tap"] = "Connexion spirituelle",
		["Spiritual Attunement"] = "Spiritual Attunement",  --  Need to translated
		["Spiritual Focus"] = "Focalisation spirituelle",
		["Spiritual Guidance"] = "Direction spirituelle",
		["Spiritual Healing"] = "Soins spirituels",
		["Sprint"] = "Sprint",
		["Stance Mastery"] = "Stance Mastery",  --  Need to translated
		["Starfire Stun"] = "Feu stellaire \195\169tourdissant",
		["Starfire"] = "Feu stellaire",
		["Starshards"] = "Eclats stellaires",
		["Staves"] = "B\195\162tons",
		["Steady Shot"] = "Steady Shot",  --  Need to translated
		["Stealth"] = "Camouflage",
		["Stoneclaw Totem"] = "Totem de Griffes de pierre",
		["Stoneform"] = "Forme de pierre",
		["Stoneskin Totem"] = "Totem de Peau de pierre",
		["Stormstrike"] = "Courroux naturel",
		["Strength of Earth Totem"] = "Totem de Force de la Terre",
		["Stuck"] = "Bloqu\195\169",
		["Subtlety"] = "Discr\195\169tion",
		["Suffering"] = "Souffrance",
		["Summon Charger"] = "Invocation de destrier",
		["Summon Dreadsteed"] = "Invocation d'un Destrier de l'Effroi",
		["Summon Felguard"] = "Summon Felguard",  --  Need to translated
		["Summon Felhunter"] = "Invocation d'un chasseur corrompu",
		["Summon Felsteed"] = "Invocation d'un palefroi corrompu",
		["Summon Imp"] = "Invocation d'un diablotin",
		["Summon Succubus"] = "Invocation d'une succube",
		["Summon Voidwalker"] = "Invocation d'un marcheur du Vide",
		["Summon Warhorse"] = "Invocation d'un cheval de guerre",
		["Summon Water Elemental"] = "Invocation d'un \195\169l\195\169mentaire d'eau",
		["Sunder Armor"] = "Fracasser armure",
		["Suppression"] = "Suppression",
		["Surefooted"] = "Pied s\195\187r",
		["Survivalist"] = "Survivant",
		["Sweeping Strikes"] = "Attaques circulaires",
		["Swiftmend"] = "Prompte gu\195\169rison",
		["Swipe"] = "Balayage",
		["Sword Specialization"] = "Sp\195\169cialisation Ep\195\169e",
		["Tactical Mastery"] = "Ma\195\174trise tactique",
		["Tailoring"] = "Couture",
		["Tainted Blood"] = "Corruption sanguine",
		["Tame Beast"] = "Dompte une b\195\170te",
		["Tamed Pet Passive"] = "Familier dompt\195\169",
		["Taunt"] = "Provocation",
		["Teleport: Darnassus"] = "T\195\169l\195\169portation : Darnassus",
		["Teleport: Ironforge"] = "T\195\169l\195\169portation : Forgefer",
		["Teleport: Moonglade"] = "T\195\169l\195\169portation : Reflet-de-Lune",
		["Teleport: Orgrimmar"] = "T\195\169l\195\169portation : Orgrimmar",
		["Teleport: Stormwind"] = "T\195\169l\195\169portation : Hurlevent",
		["Teleport: Thunder Bluff"] = "T\195\169l\195\169portation : Pitons du Tonnerre",
		["Teleport: Undercity"] = "T\195\169l\195\169portation : Fossoyeuse",
		["The Beast Within"] = "The Beast Within",  --  Need to translated
		["The Human Spirit"] = "L'esprit humain",
		["Thick Hide"] = "Peau \195\169paisse",
		["Thorns"] = "Epines",
		["Throw"] = "Lancer",
		["Throwing Specialization"] = "Sp\195\169cialisation Armes de jet",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization",  --  Need to translated
		["Thrown"] = "Armes de jet",
		["Thunder Clap"] = "Coup de tonnerre",
		["Thundering Strikes"] = "Frappe foudroyante",
		["Thunderstomp"] = "Grondeterre",
		["Tidal Focus"] = "Focalisation des flots",
		["Tidal Mastery"] = "Ma\195\174trise des flots",
		["Tiger Riding"] = "Monte de tigre",
		["Tiger's Fury"] = "Fureur du tigre",
		["Torment"] = "Tourment",
		["Totem of Wrath"] = "Totem of Wrath",  --  Need to translated
		["Totem"] = "Totem",
		["Totemic Focus"] = "Focalisation tot\195\169mique",
		["Touch of Weakness"] = "Toucher de faiblesse",
		["Toughness"] = "R\195\169sistance",
		["Traces of Silithyst"] = "Traces de silithyste",
		["Track Beasts"] = "Pistage des b\195\170tes",
		["Track Demons"] = "Pistage des d\195\169mons",
		["Track Dragonkin"] = "Pistage des draconiens",
		["Track Elementals"] = "Pistage des \195\169l\195\169mentaires",
		["Track Giants"] = "Pistage des g\195\169ants",
		["Track Hidden"] = "Pistage des camoufl\195\169s",
		["Track Humanoids"] = "Pistage des humano\195\175des",
		["Track Undead"] = "Pistage des morts-vivants",
		["Tranquil Air Totem"] = "Totem de Tranquillit\195\169 de l'air",
		["Tranquil Spirit"] = "Tranquillit\195\169 de l'esprit",
		["Tranquility"] = "Tranquillit\195\169",
		["Tranquilizing Shot"] = "Tir tranquillisant",
		["Trap Mastery"] = "Ma\195\174trise des pi\195\168ges",
		["Travel Form"] = "Forme de voyage",
		["Tree of Life"] = "Tree of Life",  --  Need to translated
		["Tremor Totem"] = "Totem de S\195\169isme",
		["Tribal Leatherworking"] = "Travail du cuir tribal",
		["Trueshot Aura"] = "Aura de pr\195\169cision",
		["Turn Undead"] = "Renvoi des morts-vivants",
		["Two-Handed Axes and Maces"] = "Haches et masses \195\160 deux mains",
		["Two-Handed Axes"] = "Haches \195\160 deux mains",
		["Two-Handed Maces"] = "Masses \195\160 deux mains",
		["Two-Handed Swords"] = "Ep\195\169es \195\160 deux mains",
		["Two-Handed Weapon Specialization"] = "Sp\195\169cialisation Arme 2M",
		["Unarmed"] = "Mains nues",
		["Unbreakable Will"] = "Volont\195\169 inflexible",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect",  --  Need to translated
		["Unbridled Wrath"] = "Col\195\168re d\195\169cha\195\174n\195\169e",
		["Undead Horsemanship"] = "Monte de cheval squelette",
		["Underwater Breathing"] = "Respiration aquatique",
		["Unending Breath"] = "Respiration interminable",
		["Unholy Power"] = "Puissance impie",
		["Unleashed Fury"] = "Fureur lib\195\169r\195\169e",
		["Unleashed Rage"] = "Rage lib\195\169r\195\169e",
		["Unstable Affliction"] = "Unstable Affliction",  --  Need to translated
		["Unyielding Faith"] = "Foi inflexible",
		["Vampiric Embrace"] = "Etreinte vampirique",
		["Vampiric Touch"] = "Vampiric Touch",  --  Need to translated
		["Vanish"] = "Disparition",
		["Vanished"] = "Invisible",
		["Vengeance"] = "Vengeance",
		["Victory Rush"] = "Victory Rush",  --  Need to translated
		["Vigor"] = "Vigueur",
		["Vile Poisons"] = "Poisons abominables",
		["Vindication"] = "Justification",
		["Viper Sting"] = "Morsure de vip\195\168re",
		["Volley"] = "Salve",
		["Wand Specialization"] = "Sp\195\169cialisation Baguette",
		["Wands"] = "Baguettes",
		["War Stomp"] = "Choc martial",
		["Water Breathing"] = "Respiration aquatique",
		["Water Shield"] = "Water Shield",  --  Need to translated
		["Water Walking"] = "Marcher sur l\226\128\153eau",
		["Waterbolt"] =	"Waterbolt",  --  Need to translated
		["Weakened Soul"] = "Ame affaiblie",
		["Weaponsmith"] = "Fabricant d'armes",
		["Whirlwind"] = "Tourbillon",
		["Will of the Forsaken"] = "Volont\195\169 des R\195\169prouv\195\169s",
		["Windfury Totem"] = "Totem Furie-des-vents",
		["Windfury Weapon"] = "Arme Furie-des-vents",
		["Windwall Totem"] = "Totem de Mur des vents",
		["Wing Clip"] = "Coupure d'ailes",
		["Winter's Chill"] = "Froid hivernal",
		["Wisp Spirit"] = "Esprit feu follet",
		["Wolf Riding"] = "Monte de loup",
		["Wound Poison II"] = "Poison douloureux II",
		["Wound Poison III"] = "Poison douloureux III",
		["Wound Poison IV"] = "Poison douloureux IV",
		["Wound Poison"] = "Poison douloureux",
		["Wrath of Air Totem"] = "Wrath of Air Totem",  --  Need to translated
		["Wrath"] = "Col\195\168re",
		["Wyvern Sting"] = "Piq\195\187re de wyverne",
	}
end)

BabbleSpell:RegisterTranslations("zhCN", function()
	return {
		["Abolish Disease"] = "驱除疾病",
		["Abolish Poison Effect"] = "驱毒术效果",
		["Abolish Poison"] = "驱毒术",
		["Activate MG Turret"] = "速射炮台",
		["Adrenaline Rush"] = "冲动",
		["Aftermath"] = "清算",
		["Aggression"] = "侵略",
		["Aimed Shot"] = "瞄准射击",
		["Alchemy"] = "炼金术",
		["Ambush"] = "伏击",
		["Amplify Curse"] = "诅咒增幅",
		["Amplify Magic"] = "魔法增效",
		["Ancestral Fortitude"] = "先祖坚韧",
		["Ancestral Healing"] = "先祖治疗",
		["Ancestral Knowledge"] = "先祖知识",
		["Ancestral Spirit"] = "先祖之魂",
		["Anesthetic Poison"] = "Anesthetic Poison",  --  Need to translated
		["Anger Management"] = "愤怒掌控",
		["Anguish"] = "Anguish",  --  Need to translated
		["Anticipation"] = "预知",
		["Aquatic Form"] = "水栖形态",
		["Arcane Blast"] = "Arcane Blast",  --  Need to translated
		["Arcane Brilliance"] = "奥术光辉",
		["Arcane Concentration"] = "奥术专注",
		["Arcane Explosion"] = "魔爆术",
		["Arcane Focus"] = "奥术集中",
		["Arcane Instability"] = "奥术增效",
		["Arcane Intellect"] = "奥术智慧",
		["Arcane Meditation"] = "奥术冥想",
		["Arcane Mind"] = "奥术心智",
		["Arcane Missiles"] = "奥术飞弹",
		["Arcane Potency"] = "Arcane Potency",
		["Arcane Power"] = "奥术强化",
		["Arcane Resistance"] = "奥术抗性",
		["Arcane Shot"] = "奥术射击",
		["Arcane Subtlety"] = "奥术精妙",
		["Arcane Weakness"] = "Arcane Weakness",
		["Arctic Reach"] = "极寒延伸",
		["Armorsmith"] = "护甲锻造师",
		["Aspect of the Beast"] = "野兽守护",
		["Aspect of the Cheetah"] = "猎豹守护",
		["Aspect of the Hawk"] = "雄鹰守护",
		["Aspect of the Monkey"] = "灵猴守护",
		["Aspect of the Pack"] = "豹群守护",
		["Aspect of the Viper"] = "Aspect of the Viper",  --  Need to translated
		["Aspect of the Wild"] = "野性守护",
		["Astral Recall"] = "星界传送",
		["Attack"] = "攻击",
		["Attacking"] = "攻击",
		["Auto Shot"] = "自动射击",
		["Avenger's Shield"] = "Avenger's Shield",  --  Need to translated
		["Avenging Wrath"] = "Avenging Wrath",  --  Need to translated
		["Avoidance"] = "Avoidance",
		["Axe Specialization"] = "斧专精",
		["Backlash"] = "Backlash",  --  Need to translated
		["Backstab"] = "背刺",
		["Bane"] = "灾祸",
		["Banish"] = "放逐术",
		["Barkskin Effect"] = "树皮术效果",
		["Barkskin"] = "树皮术",
		["Barrage"] = "弹幕",
		["Bash"] = "重击",
		["Basic Campfire"] = "基础营火",
		["Battle Shout"] = "战斗怒吼",
		["Battle Stance Passive"] = "战斗姿态（被动）",
		["Battle Stance"] = "战斗姿态",
		["Bear Form"] = "熊形态",
		["Beast Lore"] = "野兽知识",
		["Beast Slaying"] = "野兽杀手",
		["Beast Training"] = "训练野兽",
		["Benediction"] = "祈福",
		["Berserker Rage"] = "狂暴之怒",
		["Berserker Stance Passive"] = "狂暴姿态（被动）",
		["Berserker Stance"] = "狂暴姿态",
		["Berserking"] = "狂暴",
		["Bestial Discipline"] = "野兽戒律",
		["Bestial Swiftness"] = "野兽迅捷",
		["Bestial Wrath"] = "狂野怒火",
		["Binding Heal"] = "Binding Heal",  --  Need to translated
		["Bite"] = "撕咬",
		["Black Arrow"] = "黑箭",
		["Blackout"] = "昏阙",
		["Blacksmithing"] = "锻造",
		["Blade Flurry"] = "剑刃乱舞",
		["Blast Wave"] = "冲击波",
		["Blazing Speed"] = "Blazing Speed",  --  Need to translated
		["Blessed Recovery"] = "神恩回复",
		["Blessing of Freedom"] = "自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保护祝福",
		["Blessing of Sacrifice"] = "牺牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇护祝福",
		["Blessing of Wisdom"] = "智慧祝福",
		["Blind"] = "致盲",
		["Blinding Powder"] = "致盲粉",
		["Blink"] = "闪现术",
		["Blizzard"] = "暴风雪",
		["Block"] = "格挡",
		["Blood Craze"] = "血之狂热",
		["Blood Frenzy"] = "血之狂暴",
		["Blood Fury"] = "血性狂暴",
		["Blood Pact"] = "血之契印",
		["Bloodlust"] = "Bloodlust",
		["Bloodrage"] = "血性狂暴",
		["Bloodthirst"] = "残忍",
		["Booming Voice"] = "震耳嗓音",
		["Bow Specialization"] = "弓专精",
		["Bows"] = "弓",
		["Bright Campfire"] = "明亮篝火",
		["Brutal Impact"] = "野蛮冲撞",
		["Burning Adrenaline"] = "Burning Adrenaline",
		["Burning Soul"] = "燃烧之魂",
		["Burning Wish"] = "Burning Wish",
		["Call of Flame"] = "烈焰召唤",
		["Call of Thunder"] = "雷霆召唤",
		["Call Pet"] = "召唤宠物",
		["Camouflage"] = "伪装",
		["Cannibalize"] = "食尸",
		["Cat Form"] = "猎豹形态",
		["Cataclysm"] = "灾变",
		["Chain Heal"] = "治疗链",
		["Chain Lightning"] = "闪电链",
		["Challenging Roar"] = "挑战咆哮",
		["Challenging Shout"] = "挑战怒吼",
		["Charge Rage Bonus Effect"] = "冲锋额外怒气效果",  -- not sure about this one
		["Charge Stun"] = "冲锋击昏",
		["Charge"] = "冲锋",
		["Cheap Shot"] = "偷袭",
		["Chilled"] = "冰冻",
		["Circle of Healing"] = "Circle of Healing",  --  Need to translated
		["Claw"] = "爪击",
		["Cleanse"] = "清洁术",
		["Clearcasting"] = "节能施法",
		["Cleave"] = "顺劈斩",
		["Clever Traps"] = "灵巧陷阱",
		["Cloak of Shadows"] = "Cloak of Shadows",  --  Need to translated
		["Closing"] = "关闭",
		["Cloth"] = "布甲",
		["Coarse Sharpening Stone"] = "粗制磨刀石",
		["Cobra Reflexes"] = "毒蛇反射",
		["Cold Blood"] = "冷血",
		["Cold Snap"] = "急速冷却",
		["Combat Endurance"] = "作战持久",
		["Combustion"] = "燃烧",
		["Command"] = "命令",
		["Commanding Shout"] = "Commanding Shout",
		["Concentration Aura"] = "专注光环",
		["Concussion Blow"] = "震荡猛击",
		["Concussion"] = "震荡",
		["Concussive Shot"] = "震荡射击",
		["Cone of Cold"] = "冰锥术",
		["Conflagrate"] = "燃烧",
		["Conjure Food"] = "造食术",
		["Conjure Mana Agate"] = "制造魔法玛瑙",
		["Conjure Mana Citrine"] = "制造魔法黄水晶",
		["Conjure Mana Jade"] = "制造魔法翡翠",
		["Conjure Mana Ruby"] = "制造魔法红宝石",
		["Conjure Water"] = "造水术",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone",  --  Need to translated
		["Consecration"] = "奉献",
		["Consume Magic"] = "Consume Magic",  --  Need to translated
		["Consume Shadows"] = "吞噬暗影",
		["Convection"] = "传导",
		["Conviction"] = "定罪",
		["Cooking"] = "烹饪",
		["Corruption"] = "腐蚀",
		["Counterattack"] = "反击",
		["Counterspell - Silenced"] = "法术反制 - 沉默",
		["Counterspell"] = "法术反制",
		["Cower"] = "畏缩",
		["Create Firestone (Greater)"] = "制造强效火焰石",
		["Create Firestone (Lesser)"] = "制造次级火焰石",
		["Create Firestone (Major)"] = "制造极效火焰石",
		["Create Firestone"] = "制造火焰石",
		["Create Healthstone (Greater)"] = "制造强效治疗石",
		["Create Healthstone (Lesser)"] = "制造次级治疗石",
		["Create Healthstone (Major)"] = "制造极效治疗石",
		["Create Healthstone (Minor)"] = "制造初级治疗石",
		["Create Healthstone"] = "制造治疗石",
		["Create Soulstone (Greater)"] = "制造强效灵魂石",
		["Create Soulstone (Lesser)"] = "制造次级灵魂石",
		["Create Soulstone (Major)"] = "制造极效灵魂石",
		["Create Soulstone (Minor)"] = "制造初级灵魂石",
		["Create Soulstone"] = "制造灵魂石",
		["Create Spellstone (Greater)"] = "制造强效法术石",
		["Create Spellstone (Major)"] = "制造极效法术石",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)",  --  Need to translated
		["Create Spellstone"] = "制造法术石",
		["Crippling Poison II"] = "致残毒药 II",
		["Crippling Poison"] = "致残毒药",
		["Critical Mass"] = "火焰重击",
		["Crossbows"] = "弩",
		["Cruelty"] = "残忍",
		["Crusader Aura"] = "Crusader Aura",  --  Need to translated
		["Crusader Strike"] = "Crusader Strike",
		["Cultivation"] = "栽培",
		["Cure Disease"] = "祛病术",
		["Cure Poison"] = "消毒术",
		["Curse of Agony"] = "痛苦诅咒",
		["Curse of Doom Effect"] = "厄运诅咒效果",
		["Curse of Doom"] = "厄运诅咒",
		["Curse of Exhaustion"] = "疲劳诅咒",
		["Curse of Idiocy"] = "痴呆诅咒",
		["Curse of Recklessness"] = "鲁莽诅咒",
		["Curse of Shadow"] = "暗影诅咒",
		["Curse of the Elements"] = "元素诅咒",
		["Curse of Tongues"] = "语言诅咒",
		["Curse of Weakness"] = "虚弱诅咒",
		["Cyclone"] = "Cyclone",
		["Dagger Specialization"] = "匕首专精",
		["Daggers"] = "匕首",
		["Dampen Magic"] = "魔法抑制",
		["Dark Pact"] = "黑暗契约",
		["Darkness"] = "黑暗",
		["Dash"] = "急奔",
		["Dazed"] = "Dazed",
		["Deadly Poison II"] = "致命毒药 II",
		["Deadly Poison III"] = "致命毒药 III",
		["Deadly Poison IV"] = "致命毒药 IV",
		["Deadly Poison V"] = "致命毒药 V",
		["Deadly Poison"] = "致命毒药",
		["Deadly Throw"] = "Deadly Throw",  --  Need to translated
		["Death Coil"] = "死亡缠绕",
		["Death Wish"] = "死亡之愿",
		["Deep Wounds"] = "重度伤口",
		["Defense"] = "防御",
		["Defensive Stance Passive"] = "防御姿态（被动）",
		["Defensive Stance"] = "防御姿态",
		["Defensive State 2"] = "防御状态 2",	-- not sure about this one
		["Defensive State"] = "防御状态",	-- and this one
		["Defiance"] = "挑衅",
		["Deflection"] = "偏斜",
		["Demon Armor"] = "魔甲术",
		["Demon Skin"] = "恶魔皮肤",
		["Demonic Embrace"] = "恶魔之拥",
		["Demonic Frenzy"] = "Demonic Frenzy",
		["Demonic Sacrifice"] = "恶魔牺牲",
		["Demoralizing Roar"] = "挫志咆哮",
		["Demoralizing Shout"] = "挫志怒吼",
		["Dense Sharpening Stone"] = "致密磨刀石",
		["Desperate Prayer"] = "绝望祷言",
		["Destructive Reach"] = "毁灭延伸",
		["Detect Greater Invisibility"] = "侦测强效隐形",
		["Detect Invisibility"] = "侦测隐形",
		["Detect Lesser Invisibility"] = "侦测次级隐形",
		["Detect Magic"] = "侦测魔法",
		["Detect Traps"] = "侦测陷阱",
		["Detect"] = "侦测",
		["Deterrence"] = "威慑",
		["Devastate"] = "Devastate",
		["Devastation"] = "毁灭",
		["Devotion Aura"] = "虔诚光环",
		["Devour Magic Effect"] = "吞噬魔法效果",
		["Devour Magic"] = "吞噬魔法",
		["Devouring Plague"] = "噬灵瘟疫",
		["Diplomacy"] = "外交",
		["Dire Bear Form"] = "巨熊形态",
		["Disarm Trap"] = "解除陷阱",
		["Disarm"] = "缴械",
		["Disease Cleansing Totem"] = "祛病图腾",
		["Disenchant"] = "分解",
		["Disengage"] = "逃脱",
		["Dismiss Pet"] = "解散野兽",
		["Dispel Magic"] = "驱散魔法",
		["Distract"] = "扰乱",
		["Distracting Shot"] = "扰乱射击",
		["Dive"] = "俯冲",
		["Divine Favor"] = "神恩术",
		["Divine Fury"] = "神圣之怒",
		["Divine Illumination"] = "Divine Illumination",  --  Need to translated
		["Divine Intellect"] = "神圣智慧",
		["Divine Intervention"] = "神圣干涉",
		["Divine Protection"] = "圣佑术",
		["Divine Shield"] = "圣盾术",
		["Divine Spirit"] = "神圣之灵",
		["Divine Strength"] = "神圣之力",
		["Dodge"] = "躲闪",
		["Dragon's Breath"] = "Dragon's Breath",  --  Need to translated
		["Dragonscale Leatherworking"] = "龙鳞制皮",
		["Drain Life"] = "吸取生命",
		["Drain Mana"] = "吸取法力",
		["Drain Soul"] = "吸取灵魂",
		["Drink"] = "喝水",
		["Dual Wield Specialization"] = "双武器专精",
		["Dual Wield"] = "双武器",
		["Duel"] = "决斗",
		["Eagle Eye"] = "鹰眼术",
		["Earth Elemental Totem"] = "Earth Elemental Totem",  --  Need to translated
		["Earth Shield"] = "Earth Shield",  --  Need to translated
		["Earth Shock"] = "大地震击",
		["Earthbind Totem"] = "地缚图腾",
		["Efficiency"] = "效率",
		["Elemental Focus"] = "元素集中",
		["Elemental Fury"] = "元素之怒",
		["Elemental Leatherworking"] = "元素制皮",
		["Elemental Mastery"] = "元素掌握",
		["Elemental Precision"] = "Elemental Precision",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Elune's Grace"] = "艾露恩的赐福",
		["Elusiveness"] = "飘忽不定",
		["Emberstorm"] = "琥珀风暴",
		["Enamored Water Spirit"] = "Enamored Water Spirit",  --  Need to translated
		["Enchanting"] = "附魔",
		["Endurance Training"] = "耐久训练",
		["Endurance"] = "耐久",
		["Engineering Specialization"] = "工程学专精",
		["Engineering"] = "工程学",
		["Enrage"] = "狂怒",
		["Enriched Manna Biscuit"] = "可口的魔法点心",
		["Enslave Demon"] = "奴役恶魔",
		["Entangling Roots"] = "纠缠根须",
		["Entrapment"] = "诱捕",
		["Envenom"] = "Envenom",  --  Need to translated
		["Escape Artist"] = "逃命专家",
		["Evasion"] = "闪避",
		["Eventide"] = "Eventide",  --  Need to translated
		["Eviscerate"] = "剔骨",
		["Evocation"] = "唤醒",
		["Execute"] = "斩杀",
		["Exorcism"] = "驱邪术",
		["Expansive Mind"] = "开阔思维",
		["Explosive Trap Effect"] = "爆炸陷阱效果",
		["Explosive Trap"] = "爆炸陷阱",
		["Expose Armor"] = "破甲",
		["Expose Weakness"] = "Expose Weakness",
		["Eye for an Eye"] = "以眼还眼",
		["Eye of Kilrogg"] = "基尔罗格之眼",
		["Eyes of the Beast"] = "野兽之眼",
		["Fade"] = "渐隐术",
		["Faerie Fire (Feral)"] = "精灵之火（野性）",
		["Faerie Fire"] = "精灵之火",
		["Far Sight"] = "视界术",
		["Fear Ward"] = "防护恐惧结界",
		["Fear"] = "恐惧术",
		["Feed Pet"] = "喂养宠物",
		["Feedback"] = "回馈",
		["Feign Death"] = "假死",
		["Feint"] = "佯攻",
		["Fel Armor"] = "Fel Armor",  --  Need to translated
		["Fel Concentration"] = "恶魔专注",
		["Fel Domination"] = "恶魔支配",
		["Fel Intellect"] = "恶魔智力",
		["Fel Stamina"] = "恶魔耐力",
		["Felfire"] = "魔火",
		["Feline Grace"] = "豹之优雅",
		["Feline Swiftness"] = "豹之迅捷",
		["Feral Aggression"] = "野性侵略",
		["Feral Charge"] = "野性冲锋",
		["Feral Instinct"] = "野性本能",
		["Ferocious Bite"] = "凶猛撕咬",
		["Ferocity"] = "凶暴",
		["Fetish"] = "神像",
		["Find Herbs"] = "寻找草药",
		["Find Minerals"] = "寻找矿物",
		["Find Treasure"] = "寻找财宝",
		["Fire Blast"] = "火焰冲击",
		["Fire Elemental Totem"] = "Fire Elemental Totem",  --  Need to translated
		["Fire Nova Totem"] = "火焰新星图腾",
		["Fire Power"] = "火焰强化",
		["Fire Resistance Aura"] = "火焰抗性光环",
		["Fire Resistance Totem"] = "抗火图腾",
		["Fire Resistance"] = "火焰抗性",
		["Fire Shield"] = "火焰之盾",
		["Fire Vulnerability"] = "火焰易伤",
		["Fire Ward"] = "防护火焰结界",
		["Fire Weakness"] = "Fire Weakness",
		["Fireball"] = "火球术",
		["Firebolt"] = "火焰箭",
		["First Aid"] = "急救",
		["Fishing Poles"] = "鱼竿",
		["Fishing"] = "钓鱼",
		["Fist Weapon Specialization"] = "拳套专精",
		["Fist Weapons"] = "拳套",
		["Flame Shock"] = "烈焰震击",
		["Flame Throwing"] = "烈焰投掷",
		["Flamestrike"] = "烈焰冲击",
		["Flamethrower"] = "火焰喷射器",
		["Flametongue Totem"] = "火舌图腾",
		["Flametongue Weapon"] = "火舌武器",
		["Flare"] = "照明弹",
		["Flash Heal"] = "快速治疗",
		["Flash of Light"] = "圣光闪现",
		["Flight Form"] = "Flight Form",  --  Need to translated
		["Flurry"] = "乱舞",
		["Focused Casting"] = "专注施法",
		["Focused Mind"] = "Focused Mind",
		["Food"] = "进食",
		["Forbearance"] = "自律",
		["Force of Nature"] = true,
		["Force of Will"] = "意志之力",
		["Freezing Trap Effect"] = "冰冻陷阱效果",
		["Freezing Trap"] = "冰冻陷阱",
		["Frenzied Regeneration"] = "狂暴回复",
		["Frenzy"] = "疯狂",
		["Frost Armor"] = "霜甲术",
		["Frost Channeling"] = "冰霜导能",
		["Frost Nova"] = "冰霜新星",
		["Frost Resistance Aura"] = "冰霜抗性光环",
		["Frost Resistance Totem"] = "抗寒图腾",
		["Frost Resistance"] = "冰霜抗性",
		["Frost Shock"] = "冰霜震击",
		["Frost Trap Aura"] = "冰霜陷阱光环",
		["Frost Trap"] = "冰霜陷阱",
		["Frost Ward"] = "防护冰霜结界",
		["Frost Warding"] = "Frost Warding",
		["Frost Weakness"] = "Frost Weakness",
		["Frostbite"] = "霜寒刺骨",
		["Frostbolt"] = "寒冰箭",
		["Frostbrand Weapon"] = "冰封武器",
		["Furious Howl"] = "狂怒之嚎",
		["Furor"] = "激怒",
		["Garrote"] = "绞喉",
		["Generic"] = "基本",-- not sure about this one
		["Ghost Wolf"] = "幽魂之狼",
		["Ghostly Strike"] = "鬼魅攻击",
		["Gift of Life"] = "Gift of Life",
		["Gift of Nature"] = "自然赐福",
		["Gift of the Wild"] = "野性赐福",
		["Gouge"] = "凿击",
		["Grace of Air Totem"] = "风之优雅图腾",
		["Great Stamina"] = "持久耐力",
		["Greater Blessing of Kings"] = "强效王者祝福",
		["Greater Blessing of Light"] = "强效光明祝福",
		["Greater Blessing of Might"] = "强效力量祝福",
		["Greater Blessing of Salvation"] = "强效拯救祝福",
		["Greater Blessing of Sanctuary"] = "强效庇护祝福",
		["Greater Blessing of Wisdom"] = "强效智慧祝福",
		["Greater Heal"] = "强效治疗术",
		["Grim Reach"] = "无情延伸",
		["Grounding Totem"] = "根基图腾",
		["Grovel"] = "匍匐",
		["Growl"] = "低吼",
		["Guardian's Favor"] = "守护者的宠爱",
		["Gun Specialization"] = "枪械专精",
		["Guns"] = "枪械",
		["Hammer of Justice"] = "制裁之锤",
		["Hammer of Wrath"] = "愤怒之锤",
		["Hamstring"] = "断筋",
		["Harass"] = "侵扰",
		["Hardiness"] = "坚韧",
		["Hawk Eye"] = "鹰眼",
		["Heal"] = "治疗术",
		["Healing Focus"] = "治疗专注",
		["Healing Light"] = "治疗之光",
		["Healing Stream Totem"] = "治疗之泉图腾",
		["Healing Touch"] = "治疗之触",
		["Healing Wave"] = "治疗波",
		["Healing Way"] = "治疗之道",
		["Health Funnel"] = "生命通道",
		["Heart of the Wild"] = "野性之心",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Hellfire Effect"] = "地狱烈焰效果",
		["Hellfire"] = "地狱烈焰",
		["Hemorrhage"] = "出血",
		["Herb Gathering"] = "采集草药",
		["Herbalism"] = "草药学",
		["Heroic Strike"] = "英勇打击",
		["Heroism"] = "Heroism",
		["Hex of Weakness"] = "虚弱妖术",
		["Hibernate"] = "休眠",
		["Holy Fire"] = "神圣之火",
		["Holy Light"] = "圣光术",
		["Holy Nova"] = "神圣新星",
		["Holy Power"] = "神圣强化",
		["Holy Reach"] = "神圣延伸",
		["Holy Shield"] = "神圣之盾",
		["Holy Shock"] = "神圣震击",
		["Holy Specialization"] = "神圣专精",
		["Holy Wrath"] = "神圣愤怒",
		["Honorless Target"] = "无荣誉目标",
		["Horse Riding"] = "骑术：马",
		["Howl of Terror"] = "恐惧嚎叫",
		["Humanoid Slaying"] = "人型生物杀手",
		["Hunter's Mark"] = "猎人印记",
		["Hurricane"] = "飓风",
		["Ice Armor"] = "冰甲术",
		["Ice Barrier"] = "寒冰护体",
		["Ice Block"] = "寒冰屏障",
		["Ice Lance"] = "Ice Lance",  --  Need to translated
		["Ice Shards"] = "寒冰碎片",
		["Ignite"] = "点燃",
		["Illumination"] = "启发",
		["Immolate"] = "献祭",
		["Immolation Trap Effect"] = "献祭陷阱效果",
		["Immolation Trap"] = "献祭陷阱",
		["Impact"] = "冲击",
		["Impale"] = "穿刺",
		["Improved Ambush"] = "强化伏击",
		["Improved Arcane Explosion"] = "强化魔爆术",
		["Improved Arcane Missiles"] = "强化奥术飞弹",
		["Improved Arcane Shot"] = "强化奥术射击",
		["Improved Aspect of the Hawk"] = "强化雄鹰守护",
		["Improved Aspect of the Monkey"] = "强化灵猴守护",
		["Improved Backstab"] = "强化背刺",
		["Improved Battle Shout"] = "强化战斗怒吼",
		["Improved Berserker Rage"] = "强化狂暴之怒",
		["Improved Blessing of Might"] = "强化力量祝福",
		["Improved Blessing of Wisdom"] = "强化智慧祝福",
		["Improved Blizzard"] = "强化暴风雪",
		["Improved Bloodrage"] = "强化血性狂暴",
		["Improved Chain Heal"] = "强化治疗链",
		["Improved Chain Lightning"] = "强化闪电链",
		["Improved Challenging Shout"] = "强化挑战怒吼",
		["Improved Charge"] = "强化冲锋",
		["Improved Cheap Shot"] = "Improved Cheap Shot",  --  Need to translated
		["Improved Cleave"] = "强化顺劈斩",
		["Improved Concentration Aura"] = "强化专注光环",
		["Improved Concussive Shot"] = "强化震荡射击",
		["Improved Cone of Cold"] = "强化冰锥术",
		["Improved Corruption"] = "强化腐蚀术",
		["Improved Counterspell"] = "强化法术反制",
		["Improved Curse of Agony"] = "强化痛苦诅咒",
		["Improved Curse of Exhaustion"] = "强化疲劳诅咒",
		["Improved Curse of Weakness"] = "强化虚弱诅咒",
		["Improved Dampen Magic"] = "Improved Dampen Magic",  --  Need to translated
		["Improved Deadly Poison"] = "强化致命毒药",
		["Improved Demoralizing Shout"] = "强化挫志怒吼",
		["Improved Devotion Aura"] = "强化虔诚光环",
		["Improved Disarm"] = "强化缴械",
		["Improved Distract"] = "强化扰乱",
		["Improved Drain Life"] = "强化吸取生命",
		["Improved Drain Mana"] = "强化吸取法力",
		["Improved Drain Soul"] = "强化吸取灵魂",
		["Improved Enrage"] = "强化狂怒",
		["Improved Enslave Demon"] = "强化奴役恶魔",
		["Improved Entangling Roots"] = "强化纠缠根须",
		["Improved Evasion"] = "Improved Evasion",  --  Need to translated
		["Improved Eviscerate"] = "强化剔骨",
		["Improved Execute"] = "强化斩杀",
		["Improved Expose Armor"] = "强化破甲",
		["Improved Eyes of the Beast"] = "强化野兽之眼",
		["Improved Fade"] = "强化渐隐术",
		["Improved Feign Death"] = "强化假死",
		["Improved Fire Blast"] = "强化火焰冲击",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem",  --  Need to translated
		["Improved Fire Ward"] = "强化防护火焰结界",
		["Improved Fireball"] = "强化火球术",
		["Improved Firebolt"] = "强化火焰箭",
		["Improved Firestone"] = "强化火焰石",
		["Improved Flamestrike"] = "强化烈焰冲击",
		["Improved Flametongue Weapon"] = "强化火舌武器",
		["Improved Flash of Light"] = "强化圣光闪现",
		["Improved Frost Nova"] = "强化冰霜新星",
		["Improved Frost Ward"] = "强化防护冰霜结界",
		["Improved Frostbolt"] = "强化寒冰箭",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon",  --  Need to translated
		["Improved Garrote"] = "Improved Garrote",  --  Need to translated
		["Improved Ghost Wolf"] = "强化幽魂之狼",
		["Improved Gouge"] = "强化凿击",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem",  --  Need to translated
		["Improved Grounding Totem"] = "Improved Grounding Totem",  --  Need to translated
		["Improved Hammer of Justice"] = "强化制裁之锤",
		["Improved Hamstring"] = "强化断筋",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem",  --  Need to translated
		["Improved Healing Touch"] = "强化治疗之触",
		["Improved Healing Wave"] = "强化治疗波",
		["Improved Healing"] = "强化治疗术",
		["Improved Health Funnel"] = "强化生命通道",
		["Improved Healthstone"] = "强化治疗石",
		["Improved Heroic Strike"] = "强化英勇打击",
		["Improved Hunter's Mark"] = "强化猎人印记",
		["Improved Immolate"] = "强化献祭",
		["Improved Imp"] = "强化小鬼",
		["Improved Inner Fire"] = "强化心灵之火",
		["Improved Instant Poison"] = "Improved Instant Poison",  --  Need to translated
		["Improved Intercept"] = "强化拦截",
		["Improved Intimidating Shout"] = "强化破胆怒吼",
		["Improved Judgement"] = "强化审判",
		["Improved Kick"] = "强化脚踢",
		["Improved Kidney Shot"] = "强化肾击",
		["Improved Lash of Pain"] = "强化剧痛鞭笞",
		["Improved Lay on Hands"] = "强化圣疗术",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave",  --  Need to translated
		["Improved Life Tap"] = "强化生命分流",
		["Improved Lightning Bolt"] = "强化闪电箭",
		["Improved Lightning Shield"] = "强化闪电护盾",
		["Improved Magma Totem"] = "强化熔岩图腾",
		["Improved Mana Burn"] = "强化法力燃烧",
		["Improved Mana Shield"] = "强化法力护盾",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem",  --  Need to translated
		["Improved Mark of the Wild"] = "强化野性印记",
		["Improved Mend Pet"] = "强化治疗宠物",
		["Improved Mind Blast"] = "强化心灵震爆",
		["Improved Moonfire"] = "强化月火术",
		["Improved Nature's Grasp"] = "强化自然之握",
		["Improved Overpower"] = "强化压制",
		["Improved Power Word: Fortitude"] = "强化真言术：韧",
		["Improved Power Word: Shield"] = "强化圣言术：盾",
		["Improved Prayer of Healing"] = "强化治疗祷言",
		["Improved Psychic Scream"] = "强化心灵尖啸",
		["Improved Pummel"] = "强化拳击",
		["Improved Regrowth"] = "强化愈合",
		["Improved Reincarnation"] = "强化复生",
		["Improved Rejuvenation"] = "强化回春",
		["Improved Rend"] = "强化撕裂",
		["Improved Renew"] = "强化恢复",
		["Improved Retribution Aura"] = "强化惩罚光环",
		["Improved Revenge"] = "强化复仇",
		["Improved Revive Pet"] = "强化复活宠物",
		["Improved Righteous Fury"] = "强化正义之怒",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon",  --  Need to translated
		["Improved Rupture"] = "强化割裂",
		["Improved Sap"] = "强化闷棍",
		["Improved Scorch"] = "强化灼烧",
		["Improved Scorpid Sting"] = "强化毒蝎钉刺",
		["Improved Seal of Righteousness"] = "强化正义圣印",
		["Improved Seal of the Crusader"] = "强化十字军圣印",
		["Improved Searing Pain"] = "强化灼热之痛",
		["Improved Searing Totem"] = "Improved Searing Totem",  --  Need to translated
		["Improved Serpent Sting"] = "强化毒蛇钉刺",
		["Improved Shadow Bolt"] = "强化暗影箭",
		["Improved Shadow Word: Pain"] = "强化暗言术：痛",
		["Improved Shield Bash"] = "强化盾击",
		["Improved Shield Block"] = "强化盾牌格挡",
		["Improved Shield Wall"] = "强化盾墙",
		["Improved Shred"] = "强化撕碎",
		["Improved Sinister Strike"] = "强化邪恶攻击",
		["Improved Slam"] = "强化猛击",
		["Improved Slice and Dice"] = "强化切割",
		["Improved Spellstone"] = "强化法术石",
		["Improved Sprint"] = "强化疾跑",
		["Improved Starfire"] = "强化星火术",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem",  --  Need to translated
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem",  --  Need to translated
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem",  --  Need to translated
		["Improved Succubus"] = "强化魅魔",
		["Improved Sunder Armor"] = "强化破甲攻击",
		["Improved Taunt"] = "强化嘲讽",
		["Improved Thorns"] = "强化荆棘术",
		["Improved Thunder Clap"] = "强化雷霆一击",
		["Improved Tranquility"] = "强化宁静",
		["Improved Vampiric Embrace"] = "强化吸血鬼的拥抱",
		["Improved Vanish"] = "强化消失",
		["Improved Voidwalker"] = "强化虚空行者",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon",  --  Need to translated
		["Improved Wing Clip"] = "强化摔绊",
		["Improved Wrath"] = "强化愤怒",
		["Incinerate"] = "焚烧",
		["Inferno"] = "地狱火",
		["Initiative"] = "先发制人",
		["Inner Fire"] = "心灵之火",
		["Inner Focus"] = "心灵专注",
		["Innervate"] = "激活",
		["Insect Swarm"] = "虫群",
		["Inspiration"] = "灵感",
		["Instant Poison II"] = "速效毒药 II",
		["Instant Poison III"] = "速效毒药 III",
		["Instant Poison IV"] = "速效毒药 IV",
		["Instant Poison V"] = "速效毒药 V",
		["Instant Poison VI"] = "速效毒药 VI",
		["Instant Poison"] = "速效毒药",
		["Intensity"] = "强烈",
		["Intercept Stun"] = "拦截昏迷",
		["Intercept"] = "拦截",
		["Intervene"] = "Intervene",  --  Need to translated
		["Intimidating Shout"] = "破胆怒吼",
		["Intimidation"] = "胁迫",
		["Invisibility"] = "Invisibility",  --  Need to translated
		["Jewelcrafting"] = "Jewelcrafting",
		["Judgement of Command"] = "命令审判",
		["Judgement of Justice"] = "公正审判",
		["Judgement of Light"] = "光明审判",
		["Judgement of Righteousness"] = "正义审判",
		["Judgement of the Crusader"] = "十字军审判",
		["Judgement of Wisdom"] = "智慧审判",
		["Judgement"] = "审判",
		["Kick - Silenced"] = "脚踢 - 沉默",
		["Kick"] = "脚踢",
		["Kidney Shot"] = "肾击",
		["Kill Command"] = "Kill Command",  --  Need to translated
		["Killer Instinct"] = "杀戮本能",
		["Kodo Riding"] = "骑术：科多兽",
		["Lacerate"] = "Lacerate",
		["Lacerate"] = "Lacerate",  --  Need to translated
		["Lash of Pain"] = "剧痛鞭笞",
		["Last Stand"] = "破釜沉舟",
		["Lasting Judgement"] = "持久审判",
		["Lay on Hands"] = "圣疗术",
		["Leader of the Pack"] = "兽群领袖",
		["Leather"] = "皮甲",
		["Leatherworking"] = "制皮",
		["Lesser Heal"] = "次级治疗术",
		["Lesser Healing Wave"] = "次级治疗波",
		["Lesser Invisibility"] = "次级隐形术",
		["Lethal Shots"] = "夺命射击",
		["Lethality"] = "致命偷袭",
		["Levitate"] = "漂浮",
		["Libram"] = "圣物",
		["Life Tap"] = "生命分流",
		["Lifebloom"] = "Lifebloom",  --  Need to translated
		["Lifegiving Gem"] = "Lifegiving Gem",
		["Lightning Bolt"] = "闪电箭",
		["Lightning Breath"] = "闪电吐息",
		["Lightning Mastery"] = "闪电掌握",
		["Lightning Reflexes"] = "闪电反射",
		["Lightning Shield"] = "闪电护盾",
		["Lightwell Renew"] = "光明之泉回复",
		["Lightwell"] = "光明之泉",
		["Lockpicking"] = "开锁",
		["Long Daze"] = "长时间眩晕",
		["Mace Specialization"] = "锤类武器专精",
		["Mace Stun Effect"] = "锤击昏迷效果",
		["Mage Armor"] = "魔甲术",
		["Magic Attunement"] = "Magic Attunement",	
		["Magma Totem"] = "熔岩图腾",
		["Mail"] = "锁甲",
		["Maim"] = "Maim",  --  Need to translated
		["Malice"] = "恶意",
		["Mana Burn"] = "法力燃烧",
		["Mana Feed"] = "Mana Feed",
		["Mana Shield"] = "法力护盾",
		["Mana Spring Totem"] = "法力之泉图腾",
		["Mana Tide Totem"] = "法力之潮图腾",
		["Mangle (Bear)"] = "Mangle (Bear)",  --  Need to translated
		["Mangle (Cat)"] = "Mangle (Cat)",  --  Need to translated
		["Mangle"] = "割碎",
		["Mark of the Wild"] = "野性印记",
		["Martyrdom"] = "殉难",
		["Mass Dispel"] = "Mass Dispel",
		["Master Demonologist"] = "恶魔学识大师",
		["Master of Deception"] = "欺诈高手",
		["Master of Elements"] = "Master of Elements",
		["Master Summoner"] = "召唤大师",
		["Maul"] = "槌击",
		["Mechanostrider Piloting"] = "骑术：机械陆行鸟",
		["Meditation"] = "冥想",
		["Melee Specialization"] = "近战专精",
		["Mend Pet"] = "治疗宠物",
		["Mental Agility"] = "精神敏锐",
		["Mental Strength"] = "心灵之力",
		["Mind Blast"] = "心灵震爆",
		["Mind Control"] = "精神控制",
		["Mind Flay"] = "精神鞭笞",
		["Mind Soothe"] = "安抚心灵",
		["Mind Vision"] = "心灵视界",
		["Mind-numbing Poison II"] = "麻痹毒药 II",
		["Mind-numbing Poison III"] = "麻痹毒药 III",
		["Mind-numbing Poison"] = "麻痹毒药",
		["Mining"] = "采矿",
		["Misdirection"] = "Misdirection",  --  Need to translated
		["Mocking Blow"] = "惩戒痛击",
		["Molten Armor"] = "Molten Armor",  --  Need to translated
		["Mongoose Bite"] = "猫鼬撕咬",
		["Monster Slaying"] = "怪物杀手",
		["Moonfire"] = "月火术",
		["Moonfury"] = "月怒",
		["Moonglow"] = "月光",
		["Moonkin Aura"] = "枭兽光环",
		["Moonkin Form"] = "枭兽形态",
		["Mortal Shots"] = "致死射击",
		["Mortal Strike"] = "致死打击",
		["Multi-Shot"] = "多重射击",
		["Murder"] = "谋杀",
		["Mutilate"] = "Mutilate",  --  Need to translated
		["Natural Armor"] = "自然护甲",
		["Natural Shapeshifter"] = "自然变形",
		["Natural Weapons"] = "武器平衡",
		["Nature Resistance Totem"] = "自然抗性图腾",
		["Nature Resistance"] = "自然抗性",
		["Nature Weakness"] = "Nature Weakness",
		["Nature's Focus"] = "自然集中",
		["Nature's Grace"] = "自然之赐",
		["Nature's Grasp"] = "自然之握",
		["Nature's Reach"] = "自然延伸",
		["Nature's Swiftness"] = "自然迅捷",
		["Negative Charge"] = "Negative Charge",
		["Nightfall"] = "夜幕",
		["Omen of Clarity"] = "清晰预兆",
		["One-Handed Axes"] = "单手斧",
		["One-Handed Maces"] = "单手锤",
		["One-Handed Swords"] = "单手剑",
		["One-Handed Weapon Specialization"] = "单手武器专精",
		["Opening - No Text"] = "打开 - No Text",	--not sure what this is
		["Opening"] = "打开",
		["Opportunity"] = "伺机而动",
		["Overpower"] = "压制",
		["Pain Suppression"] = "Pain Suppression",  --  Need to translated
		["Paranoia"] = "多疑",
		["Parry"] = "招架",
		["Pathfinding"] = "寻路",
		["Perception"] = "感知",
		["Permafrost"] = "极寒冰霜",
		["Pet Aggression"] = "宠物好斗",
		["Pet Hardiness"] = "宠物耐久",
		["Pet Recovery"] = "宠物恢复",
		["Pet Resistance"] = "宠物抗魔",
		["Phase Shift"] = "相位变换",
		["Pick Lock"] = "开锁",
		["Pick Pocket"] = "偷窃",
		["Piercing Howl"] = "刺耳怒吼",
		["Piercing Ice"] = "刺骨寒冰",
		["Plate Mail"] = "板甲",
		["Poison Cleansing Totem"] = "祛病图腾",
		["Poisons"] = "毒药",
		["Polearm Specialization"] = "长柄武器专精",
		["Polearms"] = "长柄武器",
		["Polymorph"] = "变形术",
		["Polymorph: Pig"] = "变形术：猪",
		["Polymorph: Turtle"] = "变形术：龟",
		["Portal: Darnassus"] = "传送门：达纳苏斯",
		["Portal: Ironforge"] = " 传送门：铁炉堡",
		["Portal: Orgrimmar"] = "传送门：奥格瑞玛",
		["Portal: Stormwind"] = "传送门：暴风城",
		["Portal: Thunder Bluff"] = "传送门：雷霆崖",
		["Portal: Undercity"] = "传送门：幽暗城",
		["Positive Charge"] = "Positive Charge",
		["Pounce Bleed"] = "突袭",
		["Pounce"] = "突袭",
		["Power Infusion"] = "能量灌注",
		["Power Word: Fortitude"] = "真言术：韧",
		["Power Word: Shield"] = "真言术：盾",
		["Prayer of Fortitude"] = "坚韧祷言",
		["Prayer of Healing"] = "治疗祷言",
		["Prayer of Mending"] = "Prayer of Mending",  --  Need to translated
		["Prayer of Shadow Protection"] = "暗影防护祷言",
		["Prayer of Spirit"] = "精神祷言",
		["Precision"] = "精确",
		["Predatory Strikes"] = "猛兽攻击",
		["Premeditation"] = "预谋",
		["Preparation"] = "伺机待发",
		["Presence of Mind"] = "气定神闲",
		["Primal Fury"] = "原始狂怒",
		["Prowl"] = "潜伏",
		["Psychic Scream"] = "心灵尖啸",
		["Pummel"] = "拳击",
		["Purge"] = "净化术",
		["Purification"] = "净化",
		["Purify"] = "纯净术",
		["Pursuit of Justice"] = "正义追击",
		["Pyroblast"] = "炎爆术",
		["Pyroclasm"] = "火焰冲撞",
		["Quick Shots"] = "快速射击",
		["Quick Shots"] = "Quick Shots",
		["Quickness"] = "迅捷",
		["Rain of Fire"] = "火焰之雨",
		["Rake"] = "扫击",
		["Ram Riding"] = " 	骑术：羊",
		["Ranged Weapon Specialization"] = "远程武器专精",
		["Rapid Concealment"] = "Rapid Concealment",  --  Need to translated
		["Rapid Fire"] = "急速射击",
		["Raptor Riding"] = "骑术：迅猛龙",
		["Raptor Strike"] = "猛禽一击",
		["Ravage"] = "毁灭",
		["Readiness"] = "准备就绪",
		["Rebirth"] = "复生",
		["Reckless Charge"] = "无畏冲锋",
		["Recklessness"] = "鲁莽",
		["Reckoning"] = "清算",
		["Redemption"] = "救赎",
		["Redoubt"] = "盾牌壁垒",
		["Reflection"] = "反射",
		["Regeneration"] = "回复",
		["Regrowth"] = "愈合",
		["Reincarnation"] = "复生",
		["Rejuvenation"] = "回春术",
		["Relentless Strikes"] = "无情打击",
		["Remorseless Attacks"] = "冷酷攻击",
		["Remorseless"] = "冷酷",
		["Remove Curse"] = "解除诅咒",
		["Remove Insignia"] = "解除徽记",
		["Remove Lesser Curse"] = "解除次级诅咒",
		["Rend"] = "撕裂",
		["Renew"] = "恢复",
		["Repentance"] = "忏悔",
		["Restorative Totems"] = "Restorative Totems",
		["Resurrection"] = "复活",
		["Retaliation"] = "反击风暴",
		["Retribution Aura"] = "惩罚光环",
		["Revenge Stun"] = "复仇昏迷",
		["Revenge"] = "复仇",
		["Reverberation"] = "回响",
		["Revive Pet"] = "复活宠物",
		["Righteous Defense"] = "Righteous Defense",  --  Need to translated
		["Righteous Fury"] = "正义之怒",
		["Rip"] = "撕扯",
		["Riposte"] = "还击",
		["Ritual of Doom Effect"] = "末日仪式效果",
		["Ritual of Doom"] = "末日仪式",
		["Ritual of Souls"] = "Ritual of Souls",  --  Need to translated
		["Ritual of Summoning"] = "召唤仪式",
		["Rockbiter Weapon"] = "石化武器",
		["Rogue Passive"] = "盗贼被动效果",  -- not sure
		["Rough Sharpening Stone"] = "劣质磨刀石",
		["Ruin"] = "毁灭",
		["Rupture"] = "割裂",
		["Ruthlessness"] = "无情",
		["Sacrifice"] = "牺牲",
		["Safe Fall"] = "安全降落",
		["Sanctity Aura"] = "圣洁光环",
		["Sap"] = "闷棍",
		["Savage Fury"] = "野蛮暴怒",
		["Savage Strikes"] = "野蛮打击",
		["Scare Beast"] = "恐吓野兽",
		["Scatter Shot"] = "驱散射击",
		["Scorch"] = "灼烧",
		["Scorpid Poison"] = "蝎毒",
		["Scorpid Sting"] = "毒蝎钉刺",
		["Screech"] = "尖啸",
		["Seal Fate"] = "封印命运",
		["Seal of Blood"] = "Seal of Blood",  --  Need to translated
		["Seal of Command"] = "命令圣印",
		["Seal of Justice"] = "公正圣印",
		["Seal of Light"] = "光明圣印",
		["Seal of Righteousness"] = "正义圣印",
		["Seal of the Crusader"] = "十字军圣印",
		["Seal of Vengeance"] = "Seal of Vengeance",  --  Need to translated
		["Seal of Wisdom"] = "智慧圣印",
		["Searing Light"] = "灼热之光",
		["Searing Pain"] = "灼热之痛",
		["Searing Totem"] = "灼热图腾",
		["Second Wind"] = "Second Wind",
		["Seduction"] = "诱惑",
		["Seed of Corruption"] = "Seed of Corruption",  --  Need to translated
		["Sense Demons"] = "感知恶魔",
		["Sense Undead"] = "感知亡灵",
		["Sentry Totem"] = "岗哨图腾",
		["Serpent Sting"] = "毒蛇钉刺",
		["Setup"] = "调整",
		["Shackle Undead"] = "束缚亡灵",
		["Shadow Affinity"] = "暗影亲和",
		["Shadow Bolt"] = "暗影箭",
		["Shadow Focus"] = "暗影集中",
		["Shadow Mastery"] = "暗影掌握",
		["Shadow Protection"] = "暗影防护",
		["Shadow Reach"] = "暗影延伸",
		["Shadow Resistance Aura"] = "暗影抗性光环",
		["Shadow Resistance"] = "暗影抗性",
		["Shadow Trance"] = "暗影冥思",
		["Shadow Vulnerability"] = "暗影易伤",
		["Shadow Ward"] = "防护暗影结界",
		["Shadow Weakness"] = "Shadow Weakness",
		["Shadow Weaving"] = "暗影之波",
		["Shadow Word: Death"] = "Shadow Word: Death",  --  Need to translated
		["Shadow Word: Pain"] = "暗言术：痛",
		["Shadowburn"] = "暗影灼烧",
		["Shadowfiend"] = "Shadowfiend",  --  Need to translated
		["Shadowform"] = "暗影形态",
		["Shadowfury"] = "Shadowfury",  --  Need to translated
		["Shadowguard"] = "暗影守卫",
		["Shadowmeld Passive"] = "影遁",
		["Shadowmeld"] = "影遁",
		["Shadowstep"] = "Shadowstep",  --  Need to translated
		["Shamanistic Rage"] = "Shamanistic Rage",  --  Need to translated
		["Sharpened Claws"] = "锋利兽爪",
		["Shatter"] = "碎冰",
		["Sheep"] = "Sheep",  --  Need to translated
		["Shell Shield"] = "甲壳护盾",
		["Shield Bash - Silenced"] = "盾击 - 沉默",
		["Shield Bash"] = "盾击",
		["Shield Block"] = "盾牌格挡",
		["Shield Slam"] = "盾牌猛击",
		["Shield Specialization"] = "盾牌专精",
		["Shield Wall"] = "盾墙",
		["Shield"] = "盾牌",
		["Shiv"] = "Shiv",  --  Need to translated
		["Shoot Bow"] = "弓射击",
		["Shoot Crossbow"] = "弩射击",
		["Shoot Gun"] = "枪械射击",
		["Shoot"] = "射击",
		["Shred"] = "撕碎",
		["Silence"] = "沉默",
		["Silencing Shot"] = "Silencing Shot",
		["Silent Resolve"] = "无声消退",
		["Sinister Strike"] = "邪恶攻击",
		["Siphon Life"] = "生命虹吸",
		["Skinning"] = "剥皮",
		["Slam"] = "猛击",
		["Sleep"] = "沉睡", --not so sure
		["Slice and Dice"] = "切割",
		["Slow Fall"] = "缓落术",
		["Slow"] = "Slow",
		["Smelting"] = "熔炼",
		["Smite"] = "惩击",
		["Snake Trap"] = "Snake Trap",  --  Need to translated
		["Solid Sharpening Stone"] = "坚固的磨刀石",
		["Soothe Animal"] = "安抚动物",
		["Soothing Kiss"] = "安抚之吻",
		["Soul Fire"] = "灵魂之火",
		["Soul Link"] = "灵魂链接",
		["Soul Siphon"] = "灵魂虹吸",
		["Soulshatter"] = "Soulshatter",  --  Need to translated
		["Soulstone Resurrection"] = "灵魂石复活",
		["Spell Lock"] = "法术封锁",
		["Spell Reflection"] = "Spell Reflection",
		["Spell Warding"] = "法术屏障",
		["Spellsteal"] = "Spellsteal",  --  Need to translated
		["Spirit Bond"] = "灵魂连接",
		["Spirit of Redemption"] = "救赎之魂",
		["Spirit Tap"] = "精神分流",
		["Spiritual Attunement"] = "Spiritual Attunement",  --  Need to translated
		["Spiritual Focus"] = "精神集中",
		["Spiritual Guidance"] = "精神指引",
		["Spiritual Healing"] = "精神治疗",
		["Sprint"] = "疾跑",
		["Stance Mastery"] = "Stance Mastery",  --  Need to translated
		["Starfire Stun"] = "星火昏迷",
		["Starfire"] = "星火术",
		["Starshards"] = "星辰碎片",
		["Staves"] = "法杖",
		["Steady Shot"] = "Steady Shot",  --  Need to translated
		["Stealth"] = "潜行",
		["Stoneclaw Totem"] = "石爪图腾",
		["Stoneform"] = "石像形态",
		["Stoneskin Totem"] = "石肤图腾",
		["Stormstrike"] = "风暴打击",
		["Strength of Earth Totem"] = "大地之力图腾",
		["Stuck"] = "卡死",
		["Subtlety"] = "微妙",
		["Suffering"] = "受难",
		["Summon Charger"] = "召唤战马",
		["Summon Dreadsteed"] = "召唤恐惧战马",
		["Summon Felguard"] = "Summon Felguard",  --  Need to translated
		["Summon Felhunter"] = "召唤地狱猎犬",
		["Summon Felsteed"] = "召唤地狱战马",
		["Summon Imp"] = "召唤小鬼",
		["Summon Succubus"] = "召唤魅魔",
		["Summon Voidwalker"] = "召唤虚空行者",
		["Summon Warhorse"] = "召唤军马",
		["Summon Water Elemental"] = "Summon Water Elemental",
		["Sunder Armor"] = "破甲",
		["Suppression"] = "压制",
		["Surefooted"] = "稳固",
		["Survivalist"] = "生存专家",
		["Sweeping Strikes"] = "横扫攻击",
		["Swiftmend"] = "迅捷治愈",
		["Swipe"] = "挥击",
		["Sword Specialization"] = "剑类武器专精",
		["Tactical Mastery"] = "战术掌握",
		["Tailoring"] = "裁缝",
		["Tainted Blood"] = "腐坏之血",
		["Tame Beast"] = "驯服野兽",
		["Tamed Pet Passive"] = "驯服宠物（被动）",
		["Taunt"] = "嘲讽",
		["Teleport: Darnassus"] = "传送：达纳苏斯",
		["Teleport: Ironforge"] = "传送：铁炉堡",
		["Teleport: Moonglade"] = "传送：月光林地",
		["Teleport: Orgrimmar"] = "传送：奥格瑞玛",
		["Teleport: Stormwind"] = "传送：暴风城",
		["Teleport: Thunder Bluff"] = "传送：雷霆崖",
		["Teleport: Undercity"] = "传送：幽暗城",
		["The Beast Within"] = "The Beast Within",  --  Need to translated
		["The Human Spirit"] = "人类精魂",
		["Thick Hide"] = "厚皮",
		["Thorns"] = "荆棘术",
		["Throw"] = "投掷",
		["Throwing Specialization"] = "投掷专精",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization",  --  Need to translated
		["Thrown"] = "投掷",
		["Thunder Clap"] = "雷霆一击",
		["Thundering Strikes"] = "雷鸣猛击",
		["Thunderstomp"] = "雷霆践踏",
		["Tidal Focus"] = "潮汐集中",
		["Tidal Mastery"] = "潮汐掌握",
		["Tiger Riding"] = "骑术：豹",
		["Tiger's Fury"] = "猛虎之怒",
		["Torment"] = "折磨",
		["Totem of Wrath"] = "Totem of Wrath",  --  Need to translated
		["Totem"] = "图腾",
		["Totemic Focus"] = "图腾集中",
		["Touch of Weakness"] = "虚弱之触",
		["Toughness"] = "坚韧",
		["Traces of Silithyst"] = "Traces of Silithyst",
		["Track Beasts"] = "追踪野兽",
		["Track Demons"] = "追踪恶魔",
		["Track Dragonkin"] = "追踪龙类",
		["Track Elementals"] = "追踪元素生物",
		["Track Giants"] = "追踪巨人",
		["Track Hidden"] = "追踪隐藏生物",
		["Track Humanoids"] = "追踪人型生物",
		["Track Undead"] = "追踪亡灵",
		["Tranquil Air Totem"] = "宁静之风图腾",
		["Tranquil Spirit"] = "宁静之魂",
		["Tranquility"] = "宁静",
		["Tranquilizing Shot"] = "宁神射击",
		["Trap Mastery"] = "陷阱掌握",
		["Travel Form"] = "旅行形态",
		["Tree of Life"] = "Tree of Life",  --  Need to translated
		["Tremor Totem"] = "战栗图腾",
		["Tribal Leatherworking"] = "部族制皮",
		["Trueshot Aura"] = "强击光环",
		["Turn Undead"] = "超度亡灵",
		["Two-Handed Axes and Maces"] = "双手斧和锤",
		["Two-Handed Axes"] = "双手斧",
		["Two-Handed Maces"] = "双手锤",
		["Two-Handed Swords"] = "无光泽的双刃刀",
		["Two-Handed Weapon Specialization"] = "双手武器专精",
		["Unarmed"] = "徒手",
		["Unbreakable Will"] = "坚定意志",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect",  --  Need to translated
		["Unbridled Wrath"] = "怒不可遏",
		["Undead Horsemanship"] = "骑术：骸骨战马",
		["Underwater Breathing"] = "水下呼吸",
		["Unending Breath"] = "魔息术",
		["Unholy Power"] = "邪恶强化",
		["Unleashed Fury"] = "狂怒释放",
		["Unleashed Rage"] = "Unleashed Rage",
		["Unstable Affliction"] = "Unstable Affliction",  --  Need to translated
		["Unyielding Faith"] = "不灭信仰",
		["Vampiric Embrace"] = "吸血鬼的拥抱",
		["Vampiric Touch"] = "Vampiric Touch",  --  Need to translated
		["Vanish"] = "消失",
		["Vanished"] = "消失",
		["Vengeance"] = "复仇",
		["Victory Rush"] = "Victory Rush",  --  Need to translated
		["Vigor"] = "精力",
		["Vile Poisons"] = "恶性毒药",
		["Vindication"] = "辩护",
		["Viper Sting"] = "蝰蛇钉刺",
		["Volley"] = "乱射",
		["Wand Specialization"] = "魔杖掌握",
		["Wands"] = "魔杖",
		["War Stomp"] = "战争践踏",
		["Water Breathing"] = "水下呼吸",
		["Water Shield"] = "Water Shield",  --  Need to translated
		["Water Walking"] = "水上行走",
		["Waterbolt"] =	"Waterbolt",  --  Need to translated
		["Weakened Soul"] = "虚弱灵魂",
		["Weaponsmith"] = "武器锻造师",
		["Whirlwind"] = "旋风斩",
		["Will of the Forsaken"] = "亡灵意志",
		["Windfury Totem"] = "风怒图腾",
		["Windfury Weapon"] = "风怒武器",
		["Windwall Totem"] = "风墙图腾",
		["Wing Clip"] = "摔绊",
		["Winter's Chill"] = "深冬之寒",
		["Wisp Spirit"] = "精灵之魂",
		["Wolf Riding"] = "骑术：狼",
		["Wound Poison II"] = "致伤毒药 II",
		["Wound Poison III"] = "致伤毒药 III",
		["Wound Poison IV"] = "致伤毒药 IV",
		["Wound Poison"] = "致伤毒药",
		["Wrath of Air Totem"] = "Wrath of Air Totem",  --  Need to translated
		["Wrath"] = "愤怒",
		["Wyvern Sting"] = "翼龙钉刺",
	}
end)

BabbleSpell:RegisterTranslations("zhTW", function()
	return {
		["Abolish Disease"] = "驅除疾病",
		["Abolish Poison Effect"] = "驅毒術效果",
		["Abolish Poison"] = "驅毒術",
		["Activate MG Turret"] = "發射MGs",
		["Adrenaline Rush"] = "能量刺激",
		["Aftermath"] = "清算",
		["Aggression"] = "侵略",
		["Aimed Shot"] = "瞄準射擊",
		["Alchemy"] = "煉金術",
		["Ambush"] = "伏擊",
		["Amplify Curse"] = "詛咒增幅",
		["Amplify Magic"] = "魔法增效",
		["Ancestral Fortitude"] = "先祖堅韌",
		["Ancestral Healing"] = "先祖治療",
		["Ancestral Knowledge"] = "先祖知識",
		["Ancestral Spirit"] = "先祖之魂",
		["Anesthetic Poison"] = "Anesthetic Poison",  --  Need to translated
		["Anger Management"] = "憤怒掌控",
		["Anguish"] = "Anguish",  --  Need to translated
		["Anticipation"] = "預知",
		["Aquatic Form"] = "水棲形態",
		["Arcane Blast"] = "Arcane Blast",  --  Need to translated
		["Arcane Brilliance"] = "祕法光輝",
		["Arcane Concentration"] = "祕法專注",
		["Arcane Explosion"] = "魔爆術",
		["Arcane Focus"] = "祕法集中",
		["Arcane Instability"] = "祕法增效",
		["Arcane Intellect"] = "祕法智慧",
		["Arcane Meditation"] = "祕法冥想",
		["Arcane Mind"] = "祕法心智",
		["Arcane Missiles"] = "祕法飛彈",
		["Arcane Potency"] = "Arcane Potency",
		["Arcane Power"] = "祕法強化",
		["Arcane Resistance"] = "祕法抗性",
		["Arcane Shot"] = "祕法射擊",
		["Arcane Subtlety"] = "祕法精妙",
		["Arcane Weakness"] = "Arcane Weakness",
		["Arctic Reach"] = "極寒延伸",
		["Armorsmith"] = "護甲鍛造師",
		["Aspect of the Beast"] = "野獸守護",
		["Aspect of the Cheetah"] = "獵豹守護",
		["Aspect of the Hawk"] = "雄鷹守護",
		["Aspect of the Monkey"] = "靈猴守護",
		["Aspect of the Pack"] = "豹群守護",
		["Aspect of the Viper"] = "Aspect of the Viper",  --  Need to translated
		["Aspect of the Wild"] = "野性守護",
		["Astral Recall"] = "星界傳送",
		["Attack"] = "攻擊",
		["Attacking"] = "攻擊",
		["Auto Shot"] = "自動射擊",
		["Avenger's Shield"] = "Avenger's Shield",  --  Need to translated
		["Avenging Wrath"] = "Avenging Wrath",  --  Need to translated
		["Avoidance"] = "Avoidance",
		["Axe Specialization"] = "斧專精",
		["Backlash"] = "Backlash",  --  Need to translated
		["Backstab"] = "背刺",
		["Bane"] = "災禍",
		["Banish"] = "放逐術",
		["Barkskin Effect"] = "樹皮效果",
		["Barkskin"] = "樹皮術",
		["Barrage"] = "彈幕",
		["Bash"] = "重擊",
		["Basic Campfire"] = "基礎篝火",
		["Battle Shout"] = "戰鬥怒吼",
		["Battle Stance Passive"] = "戰鬥姿態（被動）",
		["Battle Stance"] = "戰鬥姿態",
		["Bear Form"] = "熊形態",
		["Beast Lore"] = "野獸知識",
		["Beast Slaying"] = "野獸殺手",
		["Beast Training"] = "訓練野獸",
		["Benediction"] = "祈福",
		["Berserker Rage"] = "狂暴之怒",
		["Berserker Stance Passive"] = "狂暴姿態（被動）",
		["Berserker Stance"] = "狂暴姿態",
		["Berserking"] = "狂暴",
		["Bestial Discipline"] = "野獸戒律",
		["Bestial Swiftness"] = "野獸迅捷",
		["Bestial Wrath"] = "狂野怒火",
		["Binding Heal"] = "Binding Heal",  --  Need to translated
		["Bite"] = "撕咬",
		["Black Arrow"] = "黑箭",
		["Blackout"] = "昏厥",
		["Blacksmithing"] = "鍛造",
		["Blade Flurry"] = "劍刃亂舞",
		["Blast Wave"] = "衝擊波",
		["Blazing Speed"] = "Blazing Speed",  --  Need to translated
		["Blessed Recovery"] = "祝福復元",
		["Blessing of Freedom"] = "自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保護祝福",
		["Blessing of Sacrifice"] = "犧牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇護祝福",
		["Blessing of Wisdom"] = "智慧祝福",
		["Blind"] = "致盲",
		["Blinding Powder"] = "致盲粉",
		["Blink"] = "閃現術",
		["Blizzard"] = "暴風雪",
		["Block"] = "格擋",
		["Blood Craze"] = "血之狂熱",
		["Blood Frenzy"] = "血之狂暴",
		["Blood Fury"] = "血性狂暴",
		["Blood Pact"] = "血之契印",
		["Bloodlust"] = "Bloodlust",
		["Bloodrage"] = "血性狂暴",
		["Bloodthirst"] = "嗜血",
		["Booming Voice"] = "震耳嗓音",
		["Bow Specialization"] = "弓箭專精",
		["Bows"] = "弓",
		["Bright Campfire"] = "明亮篝火",
		["Brutal Impact"] = "野蠻衝撞",
		["Burning Adrenaline"] = "Burning Adrenaline",
		["Burning Soul"] = "燃燒之魂",
		["Burning Wish"] = "Burning Wish",
		["Call of Flame"] = "烈焰召喚",
		["Call of Thunder"] = "雷霆召喚",
		["Call Pet"] = "召喚寵物",
		["Camouflage"] = "偽裝",
		["Cannibalize"] = "食屍",
		["Cat Form"] = "獵豹形態",
		["Cataclysm"] = "災變",
		["Chain Heal"] = "治療鍊",
		["Chain Lightning"] = "閃電鏈",
		["Challenging Roar"] = "挑戰咆哮",
		["Challenging Shout"] = "挑戰怒吼",
		["Charge Rage Bonus Effect"] = "Charge Rage Bonus Effect",
		["Charge Stun"] = "衝鋒擊昏",
		["Charge"] = "衝鋒",
		["Cheap Shot"] = "偷襲",
		["Chilled"] = "冰凍",
		["Circle of Healing"] = "Circle of Healing",  --  Need to translated
		["Claw"] = "爪擊",
		["Cleanse"] = "淨化術",
		["Clearcasting"] = "節能施法",
		["Cleave"] = "順劈斬",
		["Clever Traps"] = "靈巧陷阱",
		["Cloak of Shadows"] = "Cloak of Shadows",  --  Need to translated
		["Closing"] = "關閉",
		["Cloth"] = "布甲",
		["Coarse Sharpening Stone"] = "粗製磨刀石",
		["Cobra Reflexes"] = "毒蛇反射",
		["Cold Blood"] = "冷血",
		["Cold Snap"] = "急速冷卻",
		["Combat Endurance"] = "作戰持久",
		["Combustion"] = "燃燒",
		["Command"] = "命令",
		["Commanding Shout"] = "Commanding Shout",
		["Concentration Aura"] = "專注光環",
		["Concussion Blow"] = "震盪猛擊",
		["Concussion"] = "奉獻",
		["Concussive Shot"] = "震盪射擊",
		["Cone of Cold"] = "冰錐術",
		["Conflagrate"] = "燃燒",
		["Conjure Food"] = "造食術",
		["Conjure Mana Agate"] = "製造魔法瑪瑙",
		["Conjure Mana Citrine"] = "製造魔法黃水晶",
		["Conjure Mana Jade"] = "製造魔法翡翠",
		["Conjure Mana Ruby"] = "製造魔法紅寶石",
		["Conjure Water"] = "造水術",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone",  --  Need to translated
		["Consecration"] = "奉獻",
		["Consume Magic"] = "Consume Magic",  --  Need to translated
		["Consume Shadows"] = "吞噬暗影",
		["Convection"] = "傳導",
		["Conviction"] = "定罪",
		["Cooking"] = "烹飪",
		["Corruption"] = "腐蝕術",
		["Counterattack"] = "反擊",
		["Counterspell - Silenced"] = "法術反制 - 沉默",
		["Counterspell"] = "法術反制",
		["Cower"] = "畏縮",
		["Create Firestone (Greater)"] ="製造強效火焰石",
		["Create Firestone (Lesser)"] ="製造次級火焰石",
		["Create Firestone (Major)"] ="製造極效火焰石",
		["Create Firestone"] = "製造火焰石",
		["Create Healthstone (Greater)"] ="製造強效治療石",
		["Create Healthstone (Lesser)"] ="製造次級治療石",
		["Create Healthstone (Major)"] ="製造極效治療石",
		["Create Healthstone (Minor)"] ="製造初級治療石",
		["Create Healthstone"] = "製造治療石",
		["Create Soulstone (Greater)"] ="製造強效靈魂石",
		["Create Soulstone (Lesser)"] ="製造次級靈魂石",
		["Create Soulstone (Major)"] ="製造極效靈魂石",
		["Create Soulstone (Minor)"] ="製造初級靈魂石",
		["Create Soulstone"] = "製造靈魂石",
		["Create Spellstone (Greater)"] ="製造強效法術石",
		["Create Spellstone (Major)"] ="製造極效法術石",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)",  --  Need to translated
		["Create Spellstone"] = "製造法術石",
		["Crippling Poison II"] = "致殘毒藥 II",
		["Crippling Poison"] = "致殘毒藥",
		["Critical Mass"] = "火焰重擊",
		["Crossbows"] = "弩",
		["Cruelty"] = "殘忍",
		["Crusader Aura"] = "Crusader Aura",  --  Need to translated
		["Crusader Strike"] = "十字軍打擊",
		["Cultivation"] = "栽培",
		["Cure Disease"] = "祛病術",
		["Cure Poison"] = "消毒術",
		["Curse of Agony"] = "痛苦詛咒",
		["Curse of Doom Effect"] = "厄運詛咒效果",
		["Curse of Doom"] = "厄運詛咒",
		["Curse of Exhaustion"] = "疲勞詛咒",
		["Curse of Idiocy"] = "癡呆詛咒",
		["Curse of Recklessness"] = "魯莽詛咒",
		["Curse of Shadow"] = "暗影詛咒",
		["Curse of the Elements"] = "元素詛咒",
		["Curse of Tongues"] = "語言詛咒",
		["Curse of Weakness"] = "虛弱詛咒",
		["Cyclone"] = "颶風術",
		["Dagger Specialization"] = "匕首專精",
		["Daggers"] = "匕首",
		["Dampen Magic"] = "魔法抑制",
		["Dark Pact"] = "黑暗契約",
		["Darkness"] = "黑暗",
		["Dash"] = "急奔",
		["Dazed"] = "Dazed",
		["Deadly Poison II"] = "致命毒藥 II",
		["Deadly Poison III"] = "致命毒藥 III",
		["Deadly Poison IV"] = "致命毒藥 IV",
		["Deadly Poison V"] = "致命毒藥 V",
		["Deadly Poison"] = "致命毒藥",
		["Deadly Throw"] = "Deadly Throw",  --  Need to translated
		["Death Coil"] = "死亡纏繞",
		["Death Wish"] = "死亡之願",
		["Deep Wounds"] = "重傷",
		["Defense"] = "防禦",
		["Defensive Stance Passive"] = "防禦姿態（被動）",
		["Defensive Stance"] = "防禦姿態",
		["Defensive State 2"] = "防禦狀態 2",
		["Defensive State"] = "防禦狀態",
		["Defiance"] = "挑釁",
		["Deflection"] = "偏斜",
		["Demon Armor"] = "魔甲術",
		["Demon Skin"] = "惡魔皮膚",
		["Demonic Embrace"] = "惡魔之擁",
		["Demonic Frenzy"] = "惡魔之狂",
		["Demonic Sacrifice"] = "惡魔犧牲",
		["Demoralizing Roar"] = "挫志咆哮",
		["Demoralizing Shout"] = "挫志怒吼",
		["Dense Sharpening Stone"] = "緻密磨刀石",
		["Desperate Prayer"] = "絕望禱言",
		["Destructive Reach"] = "毀滅延伸",
		["Detect Greater Invisibility"] = "偵測強效隱形",
		["Detect Invisibility"] = "偵測隱形",
		["Detect Lesser Invisibility"] = "偵測次級隱形",
		["Detect Magic"] = "偵測魔法",
		["Detect Traps"] = "偵測陷阱",
		["Detect"] = "偵測",
		["Deterrence"] = "威懾",
		["Devastate"] = "挫敗",
		["Devastation"] = "毀滅",
		["Devotion Aura"] = "虔誠光環",
		["Devour Magic Effect"] = "吞噬魔法效果",
		["Devour Magic"] = "吞噬魔法",
		["Devouring Plague"] = "噬靈瘟疫",
		["Diplomacy"] = "外交",
		["Dire Bear Form"] = "巨熊形態",
		["Disarm Trap"] = "解除陷阱",
		["Disarm"] = "繳械",
		["Disease Cleansing Totem"] = "祛病圖騰",
		["Disenchant"] = "分解",
		["Disengage"] = "逃脫",
		["Dismiss Pet"] = "解散野獸",
		["Dispel Magic"] = "驅散魔法",
		["Distract"] = "擾亂",
		["Distracting Shot"] = "擾亂射擊",
		["Dive"] = "俯衝",
		["Divine Favor"] = "神恩術",
		["Divine Fury"] = "神聖之怒",
		["Divine Illumination"] = "Divine Illumination",  --  Need to translated
		["Divine Intellect"] = "神聖智慧",
		["Divine Intervention"] = "神聖干涉",
		["Divine Protection"] = "聖佑術",
		["Divine Shield"] = "聖盾術",
		["Divine Spirit"] = "神聖之靈",
		["Divine Strength"] = "神聖之力",
		["Dodge"] = "躲閃",
		["Dragon's Breath"] = "Dragon's Breath",  --  Need to translated
		["Dragonscale Leatherworking"] = "龍鱗製皮",
		["Drain Life"] = "吸取生命",
		["Drain Mana"] = "吸取法力",
		["Drain Soul"] = "吸取靈魂",
		["Drink"] = "喝水",
		["Dual Wield Specialization"] = "雙武器專精",
		["Dual Wield"] = "雙武器",
		["Duel"] = "決鬥",
		["Eagle Eye"] = "鷹眼術",
		["Earth Elemental Totem"] = "Earth Elemental Totem",  --  Need to translated
		["Earth Shield"] = "Earth Shield",  --  Need to translated
		["Earth Shock"] = "地震術",
		["Earthbind Totem"] = "地縛圖騰",
		["Efficiency"] = "效率",
		["Elemental Focus"] = "元素集中",
		["Elemental Fury"] = "元素之怒",
		["Elemental Leatherworking"] = "元素製皮",
		["Elemental Mastery"] = "元素專精",
		["Elemental Precision"] = "Elemental Precision",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Elune's Grace"] = "伊露恩的賜福",
		["Elusiveness"] = "飄忽不定",
		["Emberstorm"] = "琥珀風暴",
		["Enamored Water Spirit"] = "Enamored Water Spirit",  --  Need to translated
		["Enchanting"] = "附魔",
		["Endurance Training"] = "耐久訓練",
		["Endurance"] = "耐久",
		["Engineering Specialization"] = "工程學專精",
		["Engineering"] = "工程學",
		["Enrage"] = "狂怒",
		["Enriched Manna Biscuit"] = "可口的魔法點心",
		["Enslave Demon"] = "奴役惡魔",
		["Entangling Roots"] = "糾纏根鬚",
		["Entrapment"] = "誘捕",
		["Envenom"] = "Envenom",  --  Need to translated
		["Escape Artist"] = "逃命專家",
		["Evasion"] = "閃避",
		["Eventide"] = "Eventide",  --  Need to translated
		["Eviscerate"] = "剔骨",
		["Evocation"] = "喚醒",
		["Execute"] = "斬殺",
		["Exorcism"] = "驅邪術",
		["Expansive Mind"] = "開闊思維",
		["Explosive Trap Effect"] = "爆炸陷阱效果",
		["Explosive Trap"] = "爆炸陷阱",
		["Expose Armor"] = "破甲",
		["Expose Weakness"] = "Expose Weakness",
		["Eye for an Eye"] = "以眼還眼",
		["Eye of Kilrogg"] = "基爾羅格之眼",
		["Eyes of the Beast"] = "野獸之眼",
		["Fade"] = "漸隱術",
		["Faerie Fire (Feral)"] = "精靈之火（野性）",
		["Faerie Fire"] = "精靈之火",
		["Far Sight"] = "視界術",
		["Fear Ward"] = "防護恐懼結界",
		["Fear"] = "恐懼術",
		["Feed Pet"] = "餵養寵物",
		["Feedback"] = "回饋",
		["Feign Death"] = "假死",
		["Feint"] = "佯攻",
		["Fel Armor"] = "Fel Armor",  --  Need to translated
		["Fel Concentration"] = "惡魔專注",
		["Fel Domination"] = "惡魔支配",
		["Fel Intellect"] = "惡魔智力",
		["Fel Stamina"] = "惡魔耐力",
		["Felfire"] = "魔火",
		["Feline Grace"] = "豹之優雅",
		["Feline Swiftness"] = "豹之迅捷",
		["Feral Aggression"] = "野性侵略",
		["Feral Charge"] = "野性衝鋒",
		["Feral Instinct"] = "野性本能",
		["Ferocious Bite"] = "兇猛撕咬",
		["Ferocity"] = "兇暴",
		["Fetish"] = "塑像",
		["Find Herbs"] = "尋找草藥",
		["Find Minerals"] = "尋找礦物",
		["Find Treasure"] = "尋找財寶",
		["Fire Blast"] = "火焰衝擊",
		["Fire Elemental Totem"] = "Fire Elemental Totem",  --  Need to translated
		["Fire Nova Totem"] = "火焰新星圖騰",
		["Fire Power"] = "火焰強化",
		["Fire Resistance Aura"] = "火焰抗性光環",
		["Fire Resistance Totem"] = "抗火圖騰",
		["Fire Resistance"] = "火焰抗性",
		["Fire Shield"] = "火焰之盾",
		["Fire Vulnerability"] = "火焰易傷",
		["Fire Ward"] = "防護火焰結界",
		["Fire Weakness"] = "Fire Weakness",
		["Fireball"] = "火球術",
		["Firebolt"] = "火焰箭",
		["First Aid"] = "急救",
		["Fishing Poles"] = "魚竿",
		["Fishing"] = "釣魚",
		["Fist Weapon Specialization"] = "拳套專精",
		["Fist Weapons"] = "拳套",
		["Flame Shock"] = "烈焰震擊",
		["Flame Throwing"] = "烈焰投擲",
		["Flamestrike"] = "烈焰風暴",
		["Flamethrower"] = "火焰噴射器",
		["Flametongue Totem"] = "火舌圖騰",
		["Flametongue Weapon"] = "火舌武器",
		["Flare"] = "照明彈",
		["Flash Heal"] = "快速治療",
		["Flash of Light"] = "聖光閃現",
		["Flight Form"] = "Flight Form",  --  Need to translated
		["Flurry"] = "亂舞",
		["Focused Casting"] = "專注施法",
		["Focused Mind"] = "Focused Mind",
		["Food"] = "進食",
		["Forbearance"] = "自律",
		["Force of Nature"] = "自然之力",
		["Force of Will"] = "意志之力",
		["Freezing Trap Effect"] = "冰凍陷阱效果",
		["Freezing Trap"] = "冰凍陷阱",
		["Frenzied Regeneration"] = "狂暴回復",
		["Frenzy"] = "狂亂",
		["Frost Armor"] = "霜甲術",
		["Frost Channeling"] = "冰霜導能",
		["Frost Nova"] = "Frost Nova",
		["Frost Resistance Aura"] = "冰霜抗性光環",
		["Frost Resistance Totem"] = "抗寒圖騰",
		["Frost Resistance"] = "冰霜抗性",
		["Frost Shock"] = "冰霜震擊",
		["Frost Trap Aura"] = "冰霜陷阱光環",
		["Frost Trap"] = "冰霜陷阱",
		["Frost Ward"] = "防護冰霜結界",
		["Frost Warding"] = "Frost Warding",
		["Frost Weakness"] = "Frost Weakness",
		["Frostbite"] = "霜寒刺骨",
		["Frostbolt"] = "寒冰箭",
		["Frostbrand Weapon"] = "冰封武器",
		["Furious Howl"] = "狂怒之嚎",
		["Furor"] = "激怒",
		["Garrote"] = "絞喉",
		["Generic"] = "Generic",
		["Ghost Wolf"] = "幽魂之狼",
		["Ghostly Strike"] = "鬼魅攻擊",
		["Gift of Life"] = "Gift of Life",
		["Gift of Nature"] = "自然賜福",
		["Gift of the Wild"] = "野性賜福",
		["Gouge"] = "鑿擊",
		["Grace of Air Totem"] = "風之優雅圖騰",
		["Great Stamina"] = "強效耐力",
		["Greater Blessing of Kings"] = "強效王者祝福",
		["Greater Blessing of Light"] = "強效光明祝福",
		["Greater Blessing of Might"] = "強效力量祝福",
		["Greater Blessing of Salvation"] = "強效拯救祝福",
		["Greater Blessing of Sanctuary"] = "強效庇護祝福",
		["Greater Blessing of Wisdom"] = "強效智慧祝福",
		["Greater Heal"] = "強效治療術",
		["Grim Reach"] = "無情延伸",
		["Grounding Totem"] = "根基圖騰",
		["Grovel"] = "匍匐",
		["Growl"] = "低吼",
		["Guardian's Favor"] = "守護者的寵愛",
		["Gun Specialization"] = "槍械專精",
		["Guns"] = "槍械",
		["Hammer of Justice"] = "制裁之錘",
		["Hammer of Wrath"] = "憤怒之錘",
		["Hamstring"] = "斷筋",
		["Harass"] = "侵擾",
		["Hardiness"] = "堅韌",
		["Hawk Eye"] = "鷹眼",
		["Heal"] = "治療術",
		["Healing Focus"] = "專注治療",
		["Healing Light"] = "治療之光",
		["Healing Stream Totem"] = "治療之泉圖騰",
		["Healing Touch"] = "治療之觸",
		["Healing Wave"] = "治療波",
		["Healing Way"] = "治療之路",
		["Health Funnel"] = "生命通道",
		["Heart of the Wild"] = "野性之心",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Hellfire Effect"] = "地獄烈焰效果",
		["Hellfire"] = "地獄烈焰",
		["Hemorrhage"] = "出血",
		["Herb Gathering"] = "採集草藥",
		["Herbalism"] = "草藥學",
		["Heroic Strike"] = "英勇打擊",
		["Heroism"] = "英雄",
		["Hex of Weakness"] = "虛弱妖術",
		["Hibernate"] = "休眠",
		["Holy Fire"] = "神聖之火",
		["Holy Light"] = "聖光術",
		["Holy Nova"] = "神聖新星",
		["Holy Power"] = "神聖強化",
		["Holy Reach"] = "神聖延伸",
		["Holy Shield"] = "神聖之盾",
		["Holy Shock"] = "神聖震擊",
		["Holy Specialization"] = "神聖專精",
		["Holy Wrath"] = "神聖憤怒",
		["Honorless Target"] = "無榮譽目標",
		["Horse Riding"] = "騎術：馬",
		["Howl of Terror"] = "恐懼嚎叫",
		["Humanoid Slaying"] = "人型生物殺手",
		["Hunter's Mark"] = "獵人印記",
		["Hurricane"] = "颶風",
		["Ice Armor"] = "冰甲術",
		["Ice Barrier"] = "寒冰護體",
		["Ice Block"] = "寒冰屏障",
		["Ice Lance"] = "Ice Lance",  --  Need to translated
		["Ice Shards"] = "寒冰碎片",
		["Ignite"] = "點燃",
		["Illumination"] = "啟發",
		["Immolate"] = "獻祭",
		["Immolation Trap Effect"] = "獻祭陷阱效果",
		["Immolation Trap"] = "獻祭陷阱",
		["Impact"] = "衝擊",
		["Impale"] = "穿刺",
		["Improved Ambush"] = "強化伏擊",
		["Improved Arcane Explosion"] = "強化魔爆術",
		["Improved Arcane Missiles"] = "強化祕法飛彈",
		["Improved Arcane Shot"] = "強化祕法射擊",
		["Improved Aspect of the Hawk"] = "強化雄鷹守護",
		["Improved Aspect of the Monkey"] = "強化靈猴守護",
		["Improved Backstab"] = "強化背刺",
		["Improved Battle Shout"] = "強化戰鬥怒吼",
		["Improved Berserker Rage"] = "強化狂暴之怒",
		["Improved Blessing of Might"] = "強化力量祝福",
		["Improved Blessing of Wisdom"] = "強化智慧祝福",
		["Improved Blizzard"] = "強化暴風雪",
		["Improved Bloodrage"] = "強化血性狂暴",
		["Improved Chain Heal"] = "強化治療鍊",
		["Improved Chain Lightning"] = "強化閃電鏈",
		["Improved Challenging Shout"] = "強化挑戰怒吼",
		["Improved Charge"] = "強化衝鋒",
		["Improved Cheap Shot"] = "Improved Cheap Shot",  --  Need to translated
		["Improved Cleave"] = "強化順劈斬",
		["Improved Concentration Aura"] = "強化專注光環",
		["Improved Concussive Shot"] = "強化震盪射擊",
		["Improved Cone of Cold"] = "強化冰錐術",
		["Improved Corruption"] = "強化腐蝕術",
		["Improved Counterspell"] = "強化法術反制",
		["Improved Curse of Agony"] = "強化痛苦詛咒",
		["Improved Curse of Exhaustion"] = "強化疲勞詛咒",
		["Improved Curse of Weakness"] = "強化虛弱詛咒",
		["Improved Dampen Magic"] = "Improved Dampen Magic",  --  Need to translated
		["Improved Deadly Poison"] = "強化致命毒藥",
		["Improved Demoralizing Shout"] = "強化挫志怒吼",
		["Improved Devotion Aura"] = "強化虔誠光環",
		["Improved Disarm"] = "強化繳械",
		["Improved Distract"] = "強化擾亂",
		["Improved Drain Life"] = "強化吸取生命",
		["Improved Drain Mana"] = "強化吸取法力",
		["Improved Drain Soul"] = "強化吸取靈魂",
		["Improved Enrage"] = "強化狂怒",
		["Improved Enslave Demon"] = "強化奴役惡魔",
		["Improved Entangling Roots"] = "強化糾纏根鬚",
		["Improved Evasion"] = "Improved Evasion",  --  Need to translated
		["Improved Eviscerate"] = "強化剔骨",
		["Improved Execute"] = "強化斬殺",
		["Improved Expose Armor"] = "強化破甲",
		["Improved Eyes of the Beast"] = "強化野獸之眼",
		["Improved Fade"] = "強化漸隱術",
		["Improved Feign Death"] = "強化假死",
		["Improved Fire Blast"] = "強化火焰衝擊",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem",  --  Need to translated
		["Improved Fire Ward"] = "強化防護火焰結界",
		["Improved Fireball"] = "強化火球術",
		["Improved Firebolt"] = "強化火焰箭",
		["Improved Firestone"] = "強化火焰石",
		["Improved Flamestrike"] = "強化烈焰風暴",
		["Improved Flametongue Weapon"] = "強化火舌武器",
		["Improved Flash of Light"] = "強化聖光閃現",
		["Improved Frost Nova"] = "強化冰霜新星",
		["Improved Frost Ward"] = "強化防護冰霜結界",
		["Improved Frostbolt"] = "強化寒冰箭",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon",  --  Need to translated
		["Improved Garrote"] = "Improved Garrote",  --  Need to translated
		["Improved Ghost Wolf"] = "強化幽魂之狼",
		["Improved Gouge"] = "強化鑿擊",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem",  --  Need to translated
		["Improved Grounding Totem"] = "Improved Grounding Totem",  --  Need to translated
		["Improved Hammer of Justice"] = "強化裁決之錘",
		["Improved Hamstring"] = "強化斷筋",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem",  --  Need to translated
		["Improved Healing Touch"] = "強化治療之觸",
		["Improved Healing Wave"] = "強化治療波",
		["Improved Healing"] = "強化治療術",
		["Improved Health Funnel"] = "強化生命通道",
		["Improved Healthstone"] = "強化治療石",
		["Improved Heroic Strike"] = "強化英勇打擊",
		["Improved Hunter's Mark"] = "強化獵人印記",
		["Improved Immolate"] = "強化獻祭",
		["Improved Imp"] = "強化小鬼",
		["Improved Inner Fire"] = "強化心靈之火",
		["Improved Instant Poison"] = "Improved Instant Poison",  --  Need to translated
		["Improved Intercept"] = "強化攔截",
		["Improved Intimidating Shout"] = "強化破膽怒吼",
		["Improved Judgement"] = "強化審判",
		["Improved Kick"] = "強化腳踢",
		["Improved Kidney Shot"] = "強化腎擊",
		["Improved Lash of Pain"] = "強化劇痛鞭笞",
		["Improved Lay on Hands"] = "強化聖療術",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave",  --  Need to translated
		["Improved Life Tap"] = "強化生命分流",
		["Improved Lightning Bolt"] = "強化閃電箭",
		["Improved Lightning Shield"] = "強化閃電之盾",
		["Improved Magma Totem"] = "強化熔岩圖騰",
		["Improved Mana Burn"] = "強化法力燃燒",
		["Improved Mana Shield"] = "強化法力護盾",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem",  --  Need to translated
		["Improved Mark of the Wild"] = "強化野性印記",
		["Improved Mend Pet"] = "強化治療寵物",
		["Improved Mind Blast"] = "強化心靈震爆",
		["Improved Moonfire"] = "強化月火術",
		["Improved Nature's Grasp"] = "強化自然之握",
		["Improved Overpower"] = "強化壓制",
		["Improved Power Word: Fortitude"] = "強化真言術：韌",
		["Improved Power Word: Shield"] = "強化真言術：盾",
		["Improved Prayer of Healing"] = "強化治療禱言",
		["Improved Psychic Scream"] = "強化心靈尖嘯",
		["Improved Pummel"] = "強化拳擊",
		["Improved Regrowth"] = "強化癒合",
		["Improved Reincarnation"] = "強化複生",
		["Improved Rejuvenation"] = "強化回春術",
		["Improved Rend"] = "強化撕裂",
		["Improved Renew"] = "強化恢復",
		["Improved Retribution Aura"] = "強化懲罰光環",
		["Improved Revenge"] = "強化復仇",
		["Improved Revive Pet"] = "強化復活寵物",
		["Improved Righteous Fury"] = "強化正義之怒",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon",  --  Need to translated
		["Improved Rupture"] = "強化割裂",
		["Improved Sap"] = "強化悶棍",
		["Improved Scorch"] = "強化灼燒",
		["Improved Scorpid Sting"] = "強化毒蠍釘刺",
		["Improved Seal of Righteousness"] = "強化正義聖印",
		["Improved Seal of the Crusader"] = "強化十字軍聖印",
		["Improved Searing Pain"] = "強化灼熱之痛",
		["Improved Searing Totem"] = "Improved Searing Totem",  --  Need to translated
		["Improved Serpent Sting"] = "強化毒蛇釘刺",
		["Improved Shadow Bolt"] = "強化暗影箭",
		["Improved Shadow Word: Pain"] = "強化暗言術：痛",
		["Improved Shield Bash"] = "強化盾擊",
		["Improved Shield Block"] = "強化盾牌格擋",
		["Improved Shield Wall"] = "強化盾牆",
		["Improved Shred"] = "強化撕碎",
		["Improved Sinister Strike"] = "強化邪惡攻擊",
		["Improved Slam"] = "強化猛擊",
		["Improved Slice and Dice"] = "強化切割",
		["Improved Spellstone"] = "強化法術石",
		["Improved Sprint"] = "強化疾跑",
		["Improved Starfire"] = "強化星火術",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem",  --  Need to translated
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem",  --  Need to translated
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem",  --  Need to translated
		["Improved Succubus"] = "強化魅魔",
		["Improved Sunder Armor"] = "強化破甲攻擊",
		["Improved Taunt"] = "強化嘲諷",
		["Improved Thorns"] = "強化荊棘術",
		["Improved Thunder Clap"] = "強化雷霆一擊",
		["Improved Tranquility"] = "強化寧靜",
		["Improved Vampiric Embrace"] = "強化吸血鬼的擁抱",
		["Improved Vanish"] = "強化消失",
		["Improved Voidwalker"] = "強化虛空行者",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon",  --  Need to translated
		["Improved Wing Clip"] = "強化摔絆",
		["Improved Wrath"] = "強化憤怒",
		["Incinerate"] = "燒盡",
		["Inferno"] = "地獄火",
		["Initiative"] = "先發制人",
		["Inner Fire"] = "心靈之火",
		["Inner Focus"] = "心靈專注",
		["Innervate"] = "啟動",
		["Insect Swarm"] = "蟲群",
		["Inspiration"] = "靈感",
		["Instant Poison II"] = "速效毒藥 II",
		["Instant Poison III"] = "速效毒藥 III",
		["Instant Poison IV"] = "速效毒藥 IV",
		["Instant Poison V"] = "速效毒藥 V",
		["Instant Poison VI"] = "速效毒藥 VI",
		["Instant Poison"] = "速效毒藥",
		["Intensity"] = "強烈",
		["Intercept Stun"] = "攔截昏迷",
		["Intercept"] = "攔截",
		["Intervene"] = "Intervene",  --  Need to translated
		["Intimidating Shout"] = "破膽怒吼",
		["Intimidation"] = "脅迫",
		["Invisibility"] = "Invisibility",  --  Need to translated
		["Iron Will"] = "鋼鐵意志",
		["Jewelcrafting"] = "Jewelcrafting",
		["Judgement of Command"] = "命令審判",
		["Judgement of Justice"] = "正義審判",
		["Judgement of Light"] = "聖光審判",
		["Judgement of Righteousness"] = "正義審判",
		["Judgement of the Crusader"] = "十字軍審判",
		["Judgement of Wisdom"] = "智慧審判",
		["Judgement"] = "審判",
		["Kick - Silenced"] = "腳踢 - 沉默",
		["Kick"] = "腳踢",
		["Kidney Shot"] = "腎擊",
		["Kill Command"] = "Kill Command",  --  Need to translated
		["Killer Instinct"] = "殺戮本能",
		["Kodo Riding"] = "騎術：科多獸",
		["Lacerate"] = "Lacerate",
		["Lacerate"] = "Lacerate",  --  Need to translated
		["Lash of Pain"] = "劇痛鞭笞",
		["Last Stand"] = "破釜沉舟",
		["Lasting Judgement"] = "持久審判",
		["Lay on Hands"] = "聖療術",
		["Leader of the Pack"] = "獸群領袖",
		["Leather"] = "皮革",
		["Leatherworking"] = "製皮",
		["Lesser Heal"] = "次級治療術",
		["Lesser Healing Wave"] = "次級治療波",
		["Lesser Invisibility"] = "次級隱形術",
		["Lethal Shots"] = "奪命射擊",
		["Lethality"] = "致命偷襲",
		["Levitate"] = "漂浮術",
		["Libram"] = "聖契",
		["Life Tap"] = "生命分流",
		["Lifebloom"] = "Lifebloom",  --  Need to translated
		["Lifegiving Gem"] = "Lifegiving Gem",
		["Lightning Bolt"] = "閃電箭",
		["Lightning Breath"] = "閃電吐息",
		["Lightning Mastery"] = "閃電專精",
		["Lightning Reflexes"] = "閃電反射",
		["Lightning Shield"] = "閃電之盾",
		["Lightwell Renew"] = "恢復光束泉",
		["Lightwell"] = "光束泉",
		["Lockpicking"] = "開鎖",
		["Long Daze"] = "長時間眩暈",
		["Mace Specialization"] = "錘類武器專精",
		["Mace Stun Effect"] = "錘擊昏迷效果",
		["Mage Armor"] = "魔甲術",
		["Magic Attunement"] = "Magic Attunement",
		["Magma Totem"] = "熔岩圖騰",
		["Mail"] = "鎖甲",
		["Maim"] = "Maim",  --  Need to translated
		["Malice"] = "惡意",
		["Mana Burn"] = "法力燃燒",
		["Mana Feed"] = "Mana Feed",
		["Mana Shield"] = "法力護盾",
		["Mana Spring Totem"] = "法力之泉圖騰",
		["Mana Tide Totem"] = "法力之潮圖騰",
		["Mangle (Bear)"] = "Mangle (Bear)",  --  Need to translated
		["Mangle (Cat)"] = "Mangle (Cat)",  --  Need to translated
		["Mangle"] = "割碎",
		["Mark of the Wild"] = "野性印記",
		["Martyrdom"] = "殉難",
		["Mass Dispel"] = "Mass Dispel",
		["Master Demonologist"] = "惡魔學識大師",
		["Master of Deception"] = "欺詐大師",
		["Master of Elements"] = "Master of Elements",
		["Master Summoner"] = "召喚大師",
		["Maul"] = "槌擊",
		["Mechanostrider Piloting"] = "騎術：機械陸行鳥",
		["Meditation"] = "冥想",
		["Melee Specialization"] = "近戰專精",
		["Mend Pet"] = "治療寵物",
		["Mental Agility"] = "精神敏銳",
		["Mental Strength"] = "心靈之力",
		["Mind Blast"] = "心靈震爆",
		["Mind Control"] = "精神控制",
		["Mind Flay"] = "精神鞭笞",
		["Mind Soothe"] = "安撫心靈",
		["Mind Vision"] = "心靈視界",
		["Mind-numbing Poison II"] = "麻痹毒藥 II",
		["Mind-numbing Poison III"] = "麻痹毒藥 III",
		["Mind-numbing Poison"] = "麻痹毒藥",
		["Mining"] = "採礦",
		["Misdirection"] = "Misdirection",  --  Need to translated
		["Mocking Blow"] = "懲戒痛擊",
		["Molten Armor"] = "Molten Armor",  --  Need to translated
		["Mongoose Bite"] = "貓鼬撕咬",
		["Monster Slaying"] = "怪物殺手",
		["Moonfire"] = "月火術",
		["Moonfury"] = "月怒",
		["Moonglow"] = "月光",
		["Moonkin Aura"] = "梟獸光環",
		["Moonkin Form"] = "梟獸形態",
		["Mortal Shots"] = "致死射擊",
		["Mortal Strike"] = "致死打擊",
		["Multi-Shot"] = "多重射擊",
		["Murder"] = "謀殺",
		["Mutilate"] = "Mutilate",  --  Need to translated
		["Natural Armor"] = "自然護甲",
		["Natural Shapeshifter"] = "自然變形",
		["Natural Weapons"] = "武器平衡",
		["Nature Resistance Totem"] = "自然抗性圖騰",
		["Nature Resistance"] = "自然抗性",
		["Nature Weakness"] = "Nature Weakness",
		["Nature's Focus"] = "自然集中",
		["Nature's Grace"] = "自然之賜",
		["Nature's Grasp"] = "自然之握",
		["Nature's Reach"] = "自然延伸",
		["Nature's Swiftness"] = "自然迅捷",
		["Negative Charge"] = "Negative Charge",
		["Nightfall"] = "夜幕",
		["Omen of Clarity"] = "清晰預兆",
		["One-Handed Axes"] = "單手斧",
		["One-Handed Maces"] = "單手錘",
		["One-Handed Swords"] = "單手劍",
		["One-Handed Weapon Specialization"] = "單手武器專精",
		["Opening - No Text"] = "Opening - No Text",
		["Opening"] = "打開",
		["Opportunity"] = "伺機而動",
		["Overpower"] = "壓制",
		["Pain Suppression"] = "Pain Suppression",  --  Need to translated
		["Paranoia"] = "多疑",
		["Parry"] = "招架",
		["Pathfinding"] = "尋路",
		["Perception"] = "感知",
		["Permafrost"] = "極寒冰霜",
		["Pet Aggression"] = "寵物好鬥",
		["Pet Hardiness"] = "寵物耐久",
		["Pet Recovery"] = "寵物恢復",
		["Pet Resistance"] = "寵物抗魔",
		["Phase Shift"] = "相位變換",
		["Pick Lock"] = "開鎖",
		["Pick Pocket"] = "偷竊",
		["Piercing Howl"] = "刺耳怒吼",
		["Piercing Ice"] = "刺骨寒冰",
		["Plate Mail"] = "鎧甲",
		["Poison Cleansing Totem"] = "清毒圖騰",
		["Poisons"] = "毒藥",
		["Polearm Specialization"] = "長柄武器專精",
		["Polearms"] = "長柄武器",
		["Polymorph"] = "變形術",
		["Polymorph: Pig"] ="變豬術",
		["Polymorph: Turtle"] ="變龜術",
		["Portal: Darnassus"] = "傳送門：達納蘇斯",
		["Portal: Ironforge"] = "傳送門：鐵爐堡",
		["Portal: Orgrimmar"] = "傳送門：奧格瑪",
		["Portal: Stormwind"] = "傳送門：暴風城",
		["Portal: Thunder Bluff"] = "傳送門：雷霆崖",
		["Portal: Undercity"] = "傳送門：幽暗城",
		["Positive Charge"] = "Positive Charge",
		["Pounce Bleed"] = "血襲",
		["Pounce"] = "突襲",
		["Power Infusion"] = "注入能量",
		["Power Word: Fortitude"] = "真言術：韌",
		["Power Word: Shield"] = "真言術：盾",
		["Prayer of Fortitude"] = "堅韌禱言",
		["Prayer of Healing"] = "治療禱言",
		["Prayer of Mending"] = "Prayer of Mending",  --  Need to translated
		["Prayer of Shadow Protection"] = "暗影防護禱言",
		["Prayer of Spirit"] = "精神禱言",
		["Precision"] = "精確",
		["Predatory Strikes"] = "猛獸攻擊",
		["Premeditation"] = "預謀",
		["Preparation"] = "伺機待發",
		["Presence of Mind"] = "力量的證明",
		["Primal Fury"] = "原始狂怒",
		["Prowl"] = "潛行",
		["Psychic Scream"] = "心靈尖嘯",
		["Pummel"] = "拳擊",
		["Purge"] = "淨化術",
		["Purification"] = "淨化",
		["Purify"] = "純淨術",
		["Pursuit of Justice"] = "正義追擊",
		["Pyroblast"] = "炎爆術",
		["Pyroclasm"] = "火焰衝撞",
		["Quick Shots"] = "快速射擊",
		["Quick Shots"] = "Quick Shots",
		["Quickness"] = "迅捷",
		["Rain of Fire"] = "火焰之雨",
		["Rake"] = "掃擊",
		["Ram Riding"] = "騎術：羊",
		["Ranged Weapon Specialization"] = "遠程武器專精",
		["Rapid Concealment"] = "Rapid Concealment",  --  Need to translated
		["Rapid Fire"] = "急速射擊",
		["Raptor Riding"] = "騎術：迅猛龍",
		["Raptor Strike"] = "猛禽一擊",
		["Ravage"] = "毀滅",
		["Readiness"] = "準備就緒",
		["Rebirth"] = "複生",
		["Reckless Charge"] = "無畏衝鋒",
		["Recklessness"] = "魯莽",
		["Reckoning"] = "清算",
		["Redemption"] = "救贖",
		["Redoubt"] = "盾牌壁壘",
		["Reflection"] = "反射",
		["Regeneration"] = "再生",
		["Regrowth"] = "癒合",
		["Reincarnation"] = "複生效果",
		["Rejuvenation"] = "回春術",
		["Relentless Strikes"] = "無情打擊",
		["Remorseless Attacks"] = "冷酷攻擊",
		["Remorseless"] = "å†·é…·",
		["Remove Curse"] = "解除詛咒",
		["Remove Insignia"] = "解除徽記",
		["Remove Lesser Curse"] = "解除次級詛咒",
		["Rend"] = "撕裂",
		["Renew"] = "恢復",
		["Repentance"] = "懺悔",
		["Restorative Totems"] = "Restorative Totems",
		["Resurrection"] = "復活術",
		["Retaliation"] = "反擊風暴",
		["Retribution Aura"] = "懲罰光環",
		["Revenge Stun"] = "復仇昏迷",
		["Revenge"] = "復仇",
		["Reverberation"] = "迴響",
		["Revive Pet"] = "復活寵物",
		["Righteous Defense"] = "Righteous Defense",  --  Need to translated
		["Righteous Fury"] = "正義之怒",
		["Rip"] = "撕扯",
		["Riposte"] = "還擊",
		["Ritual of Doom Effect"] = "末日儀式效果",
		["Ritual of Doom"] = "末日儀式",
		["Ritual of Souls"] = "Ritual of Souls",  --  Need to translated
		["Ritual of Summoning"] = "召喚儀式",
		["Rockbiter Weapon"] = "石化武器",
		["Rogue Passive"] = "Rogue Passive",
		["Rough Sharpening Stone"] = "劣質磨刀石",
		["Ruin"] = "毀滅",
		["Rupture"] = "割裂",
		["Ruthlessness"] = "無情",
		["Sacrifice"] = "犧牲",
		["Safe Fall"] = "安全降落",
		["Sanctity Aura"] = "聖潔光環",
		["Sap"] = "悶棍",
		["Savage Fury"] = "野蠻暴怒",
		["Savage Strikes"] = "猛烈強擊",
		["Scare Beast"] = "恐嚇野獸",
		["Scatter Shot"] = "驅散射擊",
		["Scorch"] = "灼燒",
		["Scorpid Poison"] = "蠍毒",
		["Scorpid Sting"] = "毒蠍釘刺",
		["Screech"] = "尖嘯",
		["Seal Fate"] = "封印命運",
		["Seal of Blood"] = "Seal of Blood",  --  Need to translated
		["Seal of Command"] = "命令聖印",
		["Seal of Justice"] = "公正聖印",
		["Seal of Light"] = "光明聖印",
		["Seal of Righteousness"] = "正義聖印",
		["Seal of the Crusader"] = "十字軍聖印",
		["Seal of Vengeance"] = "Seal of Vengeance",  --  Need to translated
		["Seal of Wisdom"] = "智慧聖印",
		["Searing Light"] = "灼熱之光",
		["Searing Pain"] = "灼熱之痛",
		["Searing Totem"] = "灼熱圖騰",
		["Second Wind"] = "Second Wind",
		["Seduction"] = "誘惑",
		["Seed of Corruption"] = "Seed of Corruption",  --  Need to translated
		["Sense Demons"] = "感知惡魔",
		["Sense Undead"] = "感知不死生物",
		["Sentry Totem"] = "崗哨圖騰",
		["Serpent Sting"] = "毒蛇釘刺",
		["Setup"] = "調整",
		["Shackle Undead"] = "束縛不死生物",
		["Shadow Affinity"] = "暗影親和",
		["Shadow Bolt"] = "暗影箭",
		["Shadow Focus"] = "暗影集中",
		["Shadow Mastery"] = "暗影專精",
		["Shadow Protection"] = "暗影防護",
		["Shadow Reach"] = "暗影延伸",
		["Shadow Resistance Aura"] = "暗影抗性光環",
		["Shadow Resistance"] = "暗影抗性",
		["Shadow Trance"] = "暗影冥思",
		["Shadow Vulnerability"] = "暗影易傷",
		["Shadow Ward"] = "防護暗影結界",
		["Shadow Weakness"] = "Shadow Weakness",
		["Shadow Weaving"] = "暗影之波",
		["Shadow Word: Death"] = "Shadow Word: Death",  --  Need to translated
		["Shadow Word: Pain"] = "暗言術：痛",
		["Shadowburn"] = "暗影灼燒",
		["Shadowfiend"] = "Shadowfiend",  --  Need to translated
		["Shadowform"] = "暗影形態",
		["Shadowfury"] = "Shadowfury",  --  Need to translated
		["Shadowguard"] = "暗影守衛",
		["Shadowmeld Passive"] = "影遁",
		["Shadowmeld"] = "影遁",
		["Shadowstep"] = "Shadowstep",  --  Need to translated
		["Shamanistic Rage"] = "Shamanistic Rage",  --  Need to translated
		["Sharpened Claws"] = "鋒利獸爪",
		["Shatter"] = "碎冰",
		["Sheep"] = "Sheep",  --  Need to translated
		["Shell Shield"] = "甲殼護盾",
		["Shield Bash - Silenced"] = "盾擊 - 沉默",
		["Shield Bash"] = "盾擊",
		["Shield Block"] = "盾牌格擋",
		["Shield Slam"] = "盾牌猛擊",
		["Shield Specialization"] = "盾牌專精",
		["Shield Wall"] = "盾牆",
		["Shield"] = "盾牌",
		["Shiv"] = "Shiv",  --  Need to translated
		["Shoot Bow"] = "弓射擊",
		["Shoot Crossbow"] = "弩射擊",
		["Shoot Gun"] = "槍械射擊",
		["Shoot"] = "射擊",
		["Shred"] = "撕碎",
		["Silence"] = "沉默",
		["Silencing Shot"] = "Silencing Shot",
		["Silent Resolve"] = "無聲消退",
		["Sinister Strike"] = "邪惡攻擊",
		["Siphon Life"] = "生命虹吸",
		["Skinning"] = "剝皮",
		["Slam"] = "猛擊",
		["Sleep"] = "催眠術",
		["Slice and Dice"] = "切割",
		["Slow Fall"] = "緩落術",
		["Slow"] = "Slow",
		["Smelting"] = "熔煉",
		["Smite"] = "懲擊",
		["Snake Trap"] = "Snake Trap",  --  Need to translated
		["Solid Sharpening Stone"] = "堅固的磨刀石",
		["Soothe Animal"] = "安撫動物",
		["Soothing Kiss"] = "安撫之吻",
		["Soul Fire"] = "靈魂之火",
		["Soul Link"] = "靈魂鏈結",
		["Soul Siphon"] = "靈魂虹吸",
		["Soulshatter"] = "Soulshatter",  --  Need to translated
		["Soulstone Resurrection"] = "靈魂石復活",
		["Spell Lock"] = "法術封鎖",
		["Spell Reflection"] = "Spell Reflection",
		["Spell Warding"] = "法術護衛",
		["Spellsteal"] = "Spellsteal",  --  Need to translated
		["Spirit Bond"] = "靈魂聯結",
		["Spirit of Redemption"] = "救贖之魂",
		["Spirit Tap"] = "精神分流",
		["Spiritual Attunement"] = "Spiritual Attunement",  --  Need to translated
		["Spiritual Focus"] = "精神集中",
		["Spiritual Guidance"] = "精神導引",
		["Spiritual Healing"] = "精神治療",
		["Sprint"] = "疾跑",
		["Stance Mastery"] = "Stance Mastery",  --  Need to translated
		["Starfire Stun"] = "星火昏迷",
		["Starfire"] = "星火術",
		["Starshards"] = "星辰碎片",
		["Staves"] = "法杖",
		["Steady Shot"] = "Steady Shot",  --  Need to translated
		["Stealth"] = "潛行",
		["Stoneclaw Totem"] = "石爪圖騰",
		["Stoneform"] = "石像形態",
		["Stoneskin Totem"] = "石甲圖騰",
		["Stormstrike"] = "風暴打擊",
		["Strength of Earth Totem"] = "大地之力圖騰",
		["Stuck"] = "卡死",
		["Subtlety"] = "微妙",
		["Suffering"] = "受難",
		["Summon Charger"] = "召喚戰馬",
		["Summon Dreadsteed"] = "召喚恐懼戰馬",
		["Summon Felguard"] = "Summon Felguard",  --  Need to translated
		["Summon Felhunter"] = "召喚地獄獵犬",
		["Summon Felsteed"] = "召喚地獄戰馬",
		["Summon Imp"] = "召喚小鬼",
		["Summon Succubus"] = "召喚魅魔",
		["Summon Voidwalker"] = "召喚虛空行者",
		["Summon Warhorse"] = "召喚戰馬",
		["Summon Water Elemental"] = "Summon Water Elemental",
		["Sunder Armor"] = "破甲攻擊",
		["Suppression"] = "鎮壓",
		["Surefooted"] = "穩固",
		["Survivalist"] = "生存技能專家",
		["Sweeping Strikes"] = "橫掃攻擊",
		["Swiftmend"] = "迅癒",
		["Swipe"] = "揮擊",
		["Sword Specialization"] = "劍類武器專精",
		["Tactical Mastery"] = "戰術專精",
		["Tailoring"] = "裁縫",
		["Tainted Blood"] = "腐壞之血",
		["Tame Beast"] = "馴服野獸",
		["Tamed Pet Passive"] = "馴服野獸（被動）",
		["Taunt"] = "嘲諷",
		["Teleport: Darnassus"] = "傳送：達納蘇斯",
		["Teleport: Ironforge"] = "傳送：鐵爐堡",
		["Teleport: Moonglade"] = "傳送：月光林地",
		["Teleport: Orgrimmar"] = "傳送：奧格瑪",
		["Teleport: Stormwind"] = "傳送：暴風城",
		["Teleport: Thunder Bluff"] = "傳送：雷霆崖",
		["Teleport: Undercity"] = "傳送：幽暗城",
		["The Beast Within"] = "The Beast Within",  --  Need to translated
		["The Human Spirit"] = "人類精魂",
		["Thick Hide"] = "厚皮",
		["Thorns"] = "荊棘術",
		["Throw"] = "投擲",
		["Throwing Specialization"] = "投擲專精",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization",  --  Need to translated
		["Thrown"] = "投擲",
		["Thunder Clap"] = "雷霆一擊",
		["Thundering Strikes"] = "雷鳴猛擊",
		["Thunderstomp"] = "雷霆踐踏",
		["Tidal Focus"] = "潮汐集中",
		["Tidal Mastery"] = "潮汐專精",
		["Tiger Riding"] = "騎術：豹",
		["Tiger's Fury"] = "猛虎之怒",
		["Torment"] = "折磨",
		["Totem of Wrath"] = "Totem of Wrath",  --  Need to translated
		["Totem"] = "圖騰",
		["Totemic Focus"] = "圖騰集中",
		["Touch of Weakness"] = "虛弱之觸",
		["Toughness"] = "堅韌",
		["Traces of Silithyst"] = "Traces of Silithyst",
		["Track Beasts"] = "追蹤野獸",
		["Track Demons"] = "追蹤惡魔",
		["Track Dragonkin"] = "追蹤龍類",
		["Track Elementals"] = "追蹤元素生物",
		["Track Giants"] = "追蹤巨人",
		["Track Hidden"] = "追蹤隱藏生物",
		["Track Humanoids"] = "追蹤人型生物",
		["Track Undead"] = "追蹤亡靈",
		["Tranquil Air Totem"] = "寧靜之風圖騰",
		["Tranquil Spirit"] = "寧靜之魂",
		["Tranquility"] = "寧靜",
		["Tranquilizing Shot"] = "寧神射擊",
		["Trap Mastery"] = "陷阱掌握",
		["Travel Form"] = "旅行形態",
		["Tree of Life"] = "Tree of Life",  --  Need to translated
		["Tremor Totem"] = "戰慄圖騰",
		["Tribal Leatherworking"] = "部族製皮",
		["Trueshot Aura"] = "強擊光環",
		["Turn Undead"] = "超渡不死生物",
		["Two-Handed Axes and Maces"] = "雙手斧和錘",
		["Two-Handed Axes"] = "雙手斧",
		["Two-Handed Maces"] = "雙手錘",
		["Two-Handed Swords"] = "雙手劍",
		["Two-Handed Weapon Specialization"] = "雙手武器專精",
		["Unarmed"] = "徒手",
		["Unbreakable Will"] = "堅定意志",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect",  --  Need to translated
		["Unbridled Wrath"] = "怒不可遏",
		["Undead Horsemanship"] = "騎術：骸骨戰馬",
		["Underwater Breathing"] = "水下呼吸",
		["Unending Breath"] = "魔息術",
		["Unholy Power"] = "邪惡強化",
		["Unleashed Fury"] = "狂怒釋放",
		["Unleashed Rage"] = "Unleashed Rage",
		["Unstable Affliction"] = "Unstable Affliction",  --  Need to translated
		["Unyielding Faith"] = "不滅信仰",
		["Vampiric Embrace"] = "吸血鬼的擁抱",
		["Vampiric Touch"] = "Vampiric Touch",  --  Need to translated
		["Vanish"] = "消失",
		["Vanished"] = "消失",
		["Vengeance"] = "復仇",
		["Victory Rush"] = "Victory Rush",  --  Need to translated
		["Vigor"] = "精力",
		["Vile Poisons"] = "惡性毒藥",
		["Vindication"] = "辯護",
		["Viper Sting"] = "蝮蛇釘刺",
		["Volley"] = "亂射",
		["Wand Specialization"] = "魔杖專精",
		["Wands"] = "魔杖",
		["War Stomp"] = "戰爭踐踏",
		["Water Breathing"] = "水下呼吸",
		["Water Shield"] = "Water Shield",  --  Need to translated
		["Water Walking"] = "水上行走",
		["Waterbolt"] =	"Waterbolt",  --  Need to translated
		["Weakened Soul"] = "虛弱靈魂",
		["Weaponsmith"] = "武器鑄造",
		["Whirlwind"] = "旋風斬",
		["Will of the Forsaken"] = "亡靈意志",
		["Windfury Totem"] = "風怒圖騰",
		["Windfury Weapon"] = "風怒武器",
		["Windwall Totem"] = "風牆圖騰",
		["Wing Clip"] = "摔絆",
		["Winter's Chill"] = "深冬之寒",
		["Wisp Spirit"] = "精靈之魂",
		["Wolf Riding"] = "騎術：狼",
		["Wound Poison II"] = "致傷毒藥 II",
		["Wound Poison III"] = "致傷毒藥 III",
		["Wound Poison IV"] = "致傷毒藥 IV",
		["Wound Poison"] = "致傷毒藥",
		["Wrath of Air Totem"] = "Wrath of Air Totem",  --  Need to translated
		["Wrath"] = "憤怒",
		["Wyvern Sting"] = "翼龍釘刺"
	}
end)

BabbleSpell:RegisterTranslations("koKR", function()
	return {
		["Abolish Disease"] = "질병 해제",
		["Abolish Poison Effect"] = "독 해제 효과",
		["Abolish Poison"] = "독 해제",
		["Activate MG Turret"] = "기관포",
		["Adrenaline Rush"] = "아드레날린 촉진",
		["Aftermath"] = "재앙의 여파",
		["Aggression"] = "공격성",
		["Aimed Shot"] = "조준 사격",
		["Alchemy"] = "연금술",
		["Ambush"] = "매복",
		["Amplify Curse"] = "저주 증폭",
		["Amplify Magic"] = "마법 증폭",
		["Ancestral Fortitude"] = "선인의 인내력",
		["Ancestral Healing"] = "선인의 치유력",
		["Ancestral Knowledge"] = "선인의 지혜",
		["Ancestral Spirit"] = "고대의 영혼",
		["Anesthetic Poison"] = "Anesthetic Poison",  --  Need to translated
		["Anger Management"] = "분노 제어",
		["Anguish"] = "Anguish",  --  Need to translated
		["Anticipation"] = "직감",
		["Aquatic Form"] = "바다표범 변신",
		["Arcane Blast"] = "비전 작열",
		["Arcane Blast"] = "Arcane Blast",  --  Need to translated
		["Arcane Brilliance"] = "신비한 총명함",
		["Arcane Concentration"] = "신비한 정신집중",
		["Arcane Explosion"] = "신비한 폭발",
		["Arcane Focus"] = "신비한 집중",
		["Arcane Instability"] = "신비한 불안정성",
		["Arcane Intellect"] = "신비한 지능",
		["Arcane Meditation"] = "신비한 명상",
		["Arcane Mind"] = "신비한 정신",
		["Arcane Missiles"] = "신비한 화살",
		["Arcane Potency"] = "신비한 잠재력",
		["Arcane Power"] = "신비의 마법 강화",
		["Arcane Resistance"] = "비전 저항력",
		["Arcane Shot"] = "신비한 사격",
		["Arcane Subtlety"] = "신비한 미묘함",
		["Arcane Weakness"] = "비전 약점",
		["Arctic Reach"] = "혹한의 손길",
		["Armorsmith"] = "방어구제작",
		["Aspect of the Beast"] = "야수의 상",
		["Aspect of the Cheetah"] = "치타의 상",
		["Aspect of the Hawk"] = "매의 상",
		["Aspect of the Monkey"] = "원숭이의 상",
		["Aspect of the Pack"] = "치타 무리의 상",
		["Aspect of the Viper"] = "Aspect of the Viper",  --  Need to translated
		["Aspect of the Wild"] = "야생의 상",
		["Astral Recall"] = "영혼의 귀환",
		["Attack"] = "공격",
		["Attacking"] = "파괴 중",
		["Auto Shot"] = "자동 사격",
		["Avenger's Shield"] = "Avenger's Shield",  --  Need to translated
		["Avenging Wrath"] = "Avenging Wrath",  --  Need to translated
		["Avoidance"] = "마력 회피",
		["Axe Specialization"] = "도끼류 전문화",
		["Backlash"] = "Backlash",  --  Need to translated
		["Backstab"] = "기습",
		["Bane"] = "파멸",
		["Banish"] = "추방",
		["Barkskin Effect"] = "나무 껍질 효과",    
		["Barkskin"] = "나무 껍질",
		["Barrage"] = "탄막",
		["Bash"] = "강타",
		["Basic Campfire"] = "작은 모닥불",
		["Battle Shout"] = "전투의 외침",
		["Battle Stance Passive"] = "전투 태세",
		["Battle Stance"] = "전투 태세",
		["Bear Form"] = "곰 변신",
		["Beast Lore"] = "야수 연구",
		["Beast Slaying"] = "야수 사냥 전문화",
		["Beast Training"] = "야수 조련",
		["Benediction"] = "축복의 기도",
		["Berserker Rage"] = "광전사의 격노",
		["Berserker Stance Passive"] = "광폭 태세 지속효과",
		["Berserker Stance"] = "광폭 태세",
		["Berserking"] = "광폭화",
		["Bestial Discipline"] = "야수 훈련",
		["Bestial Swiftness"] = "야수의 신속함",
		["Bestial Wrath"] = "야수의 격노",
		["Binding Heal"] = "Binding Heal",  --  Need to translated
		["Bite"] = "물기",
		["Black Arrow"] = "검은 화살",
		["Blackout"] = "의식 상실",
		["Blacksmithing"] = "대장기술",
		["Blade Flurry"] = "폭풍의 칼날",
		["Blast Wave"] = "화염 폭풍",
		["Blazing Speed"] = "Blazing Speed",  --  Need to translated
		["Blessed Recovery"] = "축복받은 회복력",
		["Blessing of Freedom"] = "자유의 축복",
		["Blessing of Kings"] = "왕의 축복",
		["Blessing of Light"] = "빛의 축복",
		["Blessing of Might"] = "힘의 축복",
		["Blessing of Protection"] = "보호의 축복",
		["Blessing of Sacrifice"] = "희생의 축복",
		["Blessing of Salvation"] = "구원의 축복",
		["Blessing of Sanctuary"] = "성역의 축복",
		["Blessing of Wisdom"] = "지혜의 축복",
		["Blind"] = "실명",
		["Blinding Powder"] = "실명 가루",
		["Blink"] = "점멸",
		["Blizzard"] = "눈보라",
		["Block"] = "방어",
		["Blood Craze"] = "피의 광기",
		["Blood Frenzy"] = "피의 광기",
		["Blood Fury"] = "피의 격노",
		["Blood Pact"] = "피의 서약",
		["Bloodlust"] = "피의 욕망",
		["Bloodrage"] = "피의 분노",
		["Bloodthirst"] = "피의 갈증",
		["Booming Voice"] = "우렁찬 음성",
		["Bow Specialization"] = "활류 전문화",
		["Bows"] = "활",
		["Bright Campfire"] = "밝은 모닥불",
		["Brutal Impact"] = "야수의 습격",
		["Burning Adrenaline"] = "불타는 아드레날린",
		["Burning Soul"] = "불타는 영혼",
		["Burning Wish"] = "불타는 소원", 
		["Call of Flame"] = "불꽃의 부름",
		["Call of Thunder"] = "천둥의 부름",
		["Call Pet"] = "야수 부르기",
		["Camouflage"] = "위장술",
		["Cannibalize"] = "시체먹기",
		["Cat Form"] = "표범 변신",
		["Cataclysm"] = "재앙",
		["Chain Heal"] = "연쇄 치유",
		["Chain Lightning"] = "연쇄 번개",
		["Challenging Roar"] = "도전의 포효",
		["Challenging Shout"] = "도전의 외침",
		["Charge Rage Bonus Effect"] = "보너스 분노 충전 효과",
		["Charge Stun"] = "돌진 기절",
		["Charge"] = "돌진",
		["Cheap Shot"] = "비열한 습격",
		["Chilled"] = "빙결",
		["Circle of Healing"] = "Circle of Healing",  --  Need to translated
		["Claw"] = "할퀴기",
		["Cleanse"] = "정화",
		["Clearcasting"] = "정신 집중",
		["Cleave"] = "회전베기",
		["Clever Traps"] = "덫 개량",
		["Cloak of Shadows"] = "Cloak of Shadows",  --  Need to translated
		["Closing"] = "닫는 중",
		["Cloth"] = "천",
		["Coarse Sharpening Stone"] = "일반 숫돌",
		["Cobra Reflexes"] = "코브라의 반사신경",    
		["Cold Blood"] = "냉혈",
		["Cold Snap"] = "매서운 한파",
		["Combat Endurance"] = "전투 지구력",
		["Combustion"] = "발화",
		["Command"] = "지배",
		["Commanding Shout"] = "지휘의 외침",
		["Concentration Aura"] = "집중의 오라",
		["Concussion Blow"] = "충격의 일격",
		["Concussion"] = "촉발",
		["Concussive Shot"] = "충격포",
		["Cone of Cold"] = "냉기 돌풍",
		["Conflagrate"] = "점화",
		["Conjure Food"] = "음식 창조",
		["Conjure Mana Agate"] = "마나 마노 창조",
		["Conjure Mana Citrine"] = "마나 황수정 창조",
		["Conjure Mana Jade"] = "마나 비취 창조",
		["Conjure Mana Ruby"] = "마나 루비 창조",
		["Conjure Water"] = "음료 창조",
		["Consecrated Sharpening Stone"] = "Consecrated Sharpening Stone",  --  Need to translated
		["Consecration"] = "신성화",
		["Consume Magic"] = "Consume Magic",  --  Need to translated
		["Consume Shadows"] = "어둠 흡수",
		["Convection"] = "기의 흐름",
		["Conviction"] = "자각",
		["Cooking"] = "요리",
		["Corruption"] = "부패",
		["Counterattack"] = "역습",
		["Counterspell - Silenced"] = "마법 차단 - 침묵",
		["Counterspell"] = "마법 차단",
		["Cower"] = "웅크리기",
		["Create Firestone (Greater)"] = "화염석 창조 (상급)",
		["Create Firestone (Lesser)"] = "화염석 창조 (하급)",
		["Create Firestone (Major)"] = "화염석 창조 (최상급)",
		["Create Firestone"] = "화염석 창조",
		["Create Healthstone (Greater)"] = "생명석 창조 (상급)",
		["Create Healthstone (Lesser)"] = "생명석 창조 (하급)",
		["Create Healthstone (Major)"] = "생명석 창조 (최상급)",
		["Create Healthstone (Minor)"] = "생명석 창조 (최하급)",
		["Create Healthstone"] = "생명석 창조",
		["Create Soulstone (Greater)"] = "영혼석 창조 (상급)",
		["Create Soulstone (Lesser)"] = "영혼석 창조 (하급)",
		["Create Soulstone (Major)"] = "영혼석 창조 (최상급)",
		["Create Soulstone (Minor)"] = "영혼석 창조 (최하급)",
		["Create Soulstone"] = "영혼석 창조",
		["Create Spellstone (Greater)"] = "주문석 창조 (상급)",
		["Create Spellstone (Major)"] = "주문석 창조 (최상급)",
		["Create Spellstone (Master)"] = "Create Spellstone (Master)",  --  Need to translated
		["Create Spellstone"] = "주문석 창조",
		["Crippling Poison II"] = "신경 마비 독 II",
		["Crippling Poison"] = "신경 마비 독",
		["Critical Mass"] = "화염 결집",
		["Crossbows"] = "석궁",
		["Cruelty"] = "무자비함",
		["Crusader Aura"] = "Crusader Aura",  --  Need to translated
		["Crusader Strike"] = "성전사의 일격",
		["Cultivation"] = "재배",
		["Cure Disease"] = "질병 치료",
		["Cure Poison"] = "해독",
		["Curse of Agony"] = "고통의 저주",
		["Curse of Doom Effect"] = "파멸의 저주 효과",
		["Curse of Doom"] = "파멸의 저주",
		["Curse of Exhaustion"] = "피로의 저주",
		["Curse of Idiocy"] = "무지의 저주",
		["Curse of Recklessness"] = "무모함의 저주",
		["Curse of Shadow"] = "어둠의 저주",
		["Curse of the Elements"] = "원소의 저주",
		["Curse of Tongues"] = "언어의 저주",
		["Curse of Weakness"] = "무력화 저주",
		["Cyclone"] = "회오리바람",
		["Dagger Specialization"] = "단검류 전문화",
		["Daggers"] = "단검",
		["Dampen Magic"] = "마법 감쇠",
		["Dark Pact"] = "암흑의 계약",
		["Darkness"] = "어둠",
		["Dash"] = "질주",
		["Dazed"] = "멍해짐",  
		["Deadly Poison II"] = "맹독 II",
		["Deadly Poison III"] = "맹독 III",
		["Deadly Poison IV"] = "맹독 IV",
		["Deadly Poison V"] = "맹독 V",
		["Deadly Poison"] = "맹독",
		["Deadly Throw"] = "Deadly Throw",  --  Need to translated
		["Death Coil"] = "죽음의 고리",
		["Death Wish"] = "죽음의 소원",
		["Deep Wounds"] = "치명상",
		["Defense"] = "방어",
		["Defensive Stance Passive"] = "방어 태세 지속효과",
		["Defensive Stance"] = "방어 태세",
		["Defensive State 2"] = "방어 상태 2",
		["Defensive State"] = "방어 상태",
		["Defiance"] = "도전",
		["Deflection"] = "재빠른 손놀림",
		["Demon Armor"] = "악마의 갑옷",
		["Demon Skin"] = "악마의 피부",
		["Demonic Embrace"] = "악마의 은총",
		["Demonic Frenzy"] = "악마의 광기",
		["Demonic Sacrifice"] = "악의 제물",
		["Demoralizing Roar"] = "위협의 포효",
		["Demoralizing Shout"] = "사기의 외침",
		["Dense Sharpening Stone"] = "강도 높은 숫돌",
		["Desperate Prayer"] = "구원의 기도",
		["Destructive Reach"] = "파괴의 테두리",
		["Detect Greater Invisibility"] = "상급 투명체 감지",
		["Detect Invisibility"] = "투명체 감지",
		["Detect Lesser Invisibility"] = "하급 투명체 감지",
		["Detect Magic"] = "마법 감지",
		["Detect Traps"] = "함정 감지",
		["Detect"] = "감지",
		["Deterrence"] = "공격 저지",
		["Devastate"] = "압도",
		["Devastation"] = "황폐",
		["Devotion Aura"] = "기원의 오라",
		["Devour Magic Effect"] = "마법 삼키기 효과",
		["Devour Magic"] = "마법 삼키기",
		["Devouring Plague"] = "파멸의 역병",
		["Diplomacy"] = "외교",
		["Dire Bear Form"] = "광포한 곰 변신",
		["Disarm Trap"] = "함정 해제",
		["Disarm"] = "무장 해제",
		["Disease Cleansing Totem"] = "질병 정화 토템",
		["Disenchant"] = "마력 추출",
		["Disengage"] = "철수",
		["Dismiss Pet"] = "야수 소환해제",
		["Dispel Magic"] = "마법 무효화",
		["Distract"] = "혼란",
		["Distracting Shot"] = "견제 사격",
		["Dive"] = "급강하",
		["Divine Favor"] = "신의 은총",
		["Divine Fury"] = "신의 격노",
		["Divine Illumination"] = "Divine Illumination",  --  Need to translated
		["Divine Intellect"] = "천상의 지능",
		["Divine Intervention"] = "성스러운 중재",
		["Divine Protection"] = "신의 가호",
		["Divine Shield"] = "천상의 보호막",
		["Divine Spirit"] = "천상의 정신",
		["Divine Strength"] = "천상의 힘",
		["Dodge"] = "회피",
		["Dragon's Breath"] = "Dragon's Breath",  --  Need to translated
		["Dragonscale Leatherworking"] = "용비늘 가죽세공",
		["Drain Life"] = "생명력 흡수",
		["Drain Mana"] = "마나 흡수",
		["Drain Soul"] = "영혼 흡수",
		["Drink"] = "음료",
		["Dual Wield Specialization"] = "쌍수 무기 전문화",
		["Dual Wield"] = "쌍수 무기",
		["Duel"] = "주문 7266",
		["Eagle Eye"] = "독수리의 눈",
		["Earth Elemental Totem"] = "Earth Elemental Totem",  --  Need to translated
		["Earth Shield"] = "Earth Shield",  --  Need to translated
		["Earth Shock"] = "대지 충격",
		["Earthbind Totem"] = "속박의 토템",
		["Efficiency"] = "사격술",
		["Elemental Focus"] = "정기의 집중",
		["Elemental Fury"] = "자연의 격노",
		["Elemental Leatherworking"] = "원소 가죽세공",
		["Elemental Mastery"] = "정기의 깨달음",
		["Elemental Precision"] = "원소의 정밀함",  
		["Elemental Sharpening Stone"] = "원소 숫돌",
		["Elune's Grace"] = "엘룬의 은총",
		["Elusiveness"] = "약삭빠름",
		["Emberstorm"] = "불보라",
		["Enamored Water Spirit"] = "Enamored Water Spirit",  --  Need to translated
		["Enchanting"] = "마법부여",
		["Endurance Training"] = "지구력 훈련",
		["Endurance"] = "인내력",
		["Engineering Specialization"] = "기계공학 전문화",
		["Engineering"] = "기계공학",
		["Enrage"] = "격노",
		["Enriched Manna Biscuit"] = "맛좋은 만나빵",
		["Enslave Demon"] = "악마 지배",
		["Entangling Roots"] = "휘감는 뿌리",
		["Entrapment"] = "올가미",
		["Envenom"] = "Envenom",  --  Need to translated
		["Escape Artist"] = "탈출의 명수",
		["Evasion"] = "회피",
		["Eventide"] = "Eventide",  --  Need to translated
		["Eviscerate"] = "절개",
		["Evocation"] = "환기",
		["Execute"] = "마무리 일격",
		["Exorcism"] = "퇴마술",
		["Expansive Mind"] = "영리함",
		["Explosive Trap Effect"] = "폭발의 덫",
		["Explosive Trap"] = "폭발의 덫",
		["Expose Armor"] = "약점 노출",
		["Expose Weakness"] = "결점 노출",
		["Eye for an Eye"] = "눈에는 눈",
		["Eye of Kilrogg"] = "킬로그의 눈",
		["Eyes of the Beast"] = "야수의 눈",
		["Fade"] = "소실",
		["Faerie Fire (Feral)"] = "요정의 불꽃 (야성)",
		["Faerie Fire"] = "요정의 불꽃",
		["Far Sight"] = "천리안",
		["Fear Ward"] = "공포의 수호물",
		["Fear"] = "공포",
		["Feed Pet"] = "먹이주기",
		["Feedback"] = "역순환",
		["Feign Death"] = "죽은척하기",
		["Feint"] = "교란",
		["Fel Armor"] = "Fel Armor",  --  Need to translated
		["Fel Concentration"] = "마의 정신집중",
		["Fel Domination"] = "마의 지배",
		["Fel Intellect"] = "마의 지능",
		["Fel Stamina"] = "마의 체력",
		["Felfire"] = "지옥불",
		["Feline Grace"] = "살쾡이의 우아함",
		["Feline Swiftness"] = "살쾡이의 기민함",
		["Feral Aggression"] = "야생의 공격성",
		["Feral Charge"] = "야성의 돌진",
		["Feral Instinct"] = "야생의 본능",
		["Ferocious Bite"] = "흉포한 이빨",
		["Ferocity"] = "야수의 본성",    
		["Fetish"] = "우상",
		["Find Herbs"] = "약초 찾기",
		["Find Minerals"] = "광물 찾기",
		["Find Treasure"] = "보물 찾기",
		["Fire Blast"] = "화염 작열",
		["Fire Elemental Totem"] = "Fire Elemental Totem",  --  Need to translated
		["Fire Nova Totem"] = "불꽃 회오리 토템",
		["Fire Power"] = "화염 마법 강화",
		["Fire Resistance Aura"] = "화염 저항의 오라",
		["Fire Resistance Totem"] = "화염 저항 토템",
		["Fire Resistance"] = "화염 마법 저항",
		["Fire Shield"] = "화염 보호막",
		["Fire Vulnerability"] = "화염 저항력 약화",
		["Fire Ward"] = "화염계 수호",
		["Fire Weakness"] = "화염 약점",    
		["Fireball"] = "화염구",
		["Firebolt"] = "불화살",
		["First Aid"] = "응급치료",
		["Fishing Poles"] = "낚싯대",
		["Fishing"] = "낚시",
		["Fist Weapon Specialization"] = "장착 무기류 전문화",
		["Fist Weapons"] = "장착 무기류",
		["Flame Shock"] = "화염 충격",
		["Flame Throwing"] = "화염 발사",
		["Flamestrike"] = "불기둥",
		["Flamethrower"] = "화염방사기",
		["Flametongue Totem"] = "불꽃의 토템",
		["Flametongue Weapon"] = "불꽃의 무기",
		["Flare"] = "섬광",
		["Flash Heal"] = "순간 치유",
		["Flash of Light"] = "빛의 섬광",
		["Flight Form"] = "Flight Form",  --  Need to translated
		["Flurry"] = "질풍",
		["Focused Casting"] = "집중력",
		["Focused Mind"] = "흐트러짐 없는 마음",    
		["Food"] = "음식",
		["Forbearance"] = "참을성",
		["Force of Nature"] = "자연의 군대",
		["Force of Will"] = "의지의 힘",
		["Freezing Trap Effect"] = "얼음의 덫",
		["Freezing Trap"] = "얼음의 덫",
		["Frenzied Regeneration"] = "광포한 재생력",
		["Frenzy"] = "광기",
		["Frost Armor"] = "냉기 갑옷",
		["Frost Channeling"] = "냉기계 정신집중",
		["Frost Nova"] = "얼음 회오리",
		["Frost Resistance Aura"] = "냉기 저항의 오라",
		["Frost Resistance Totem"] = "냉기 저항 토템",
		["Frost Resistance"] = "냉기 마법 저항",
		["Frost Shock"] = "냉기 충격",
		["Frost Trap Aura"] = "냉기의 덫",
		["Frost Trap"] = "냉기의 덫",
		["Frost Ward"] = "냉기계 수호",
		["Frost Warding"] = "냉기의 수호", 
		["Frost Weakness"] = "냉기 약점",   
		["Frostbite"] = "동상",
		["Frostbolt"] = "얼음 화살",
		["Frostbrand Weapon"] = "냉기의 무기",
		["Furious Howl"] = "사나운 울음소리",
		["Furor"] = "광란",
		["Garrote"] = "목조르기",
		["Generic"] = "주문 2382",
		["Ghost Wolf"] = "늑대 정령",
		["Ghostly Strike"] = "그림자 일격",
		["Gift of Life"] = "생명의 선물",
		["Gift of Nature"] = "자연의 선물",
		["Gift of the Wild"] = "야생의 선물",
		["Gouge"] = "후려치기",
		["Grace of Air Totem"] = "은총의 토템",
		["Great Stamina"] = "강인한 체력",
		["Greater Blessing of Kings"] = "상급 왕의 축복",
		["Greater Blessing of Light"] = "상급 빛의 축복",
		["Greater Blessing of Might"] = "상급 힘의 축복",
		["Greater Blessing of Salvation"] = "상급 구원의 축복",
		["Greater Blessing of Sanctuary"] = "상급 성역의 축복",
		["Greater Blessing of Wisdom"] = "상급 지혜의 축복",
		["Greater Heal"] = "상급 치유",
		["Grim Reach"] = "냉혹의 테두리",
		["Grounding Totem"] = "마법정화 토템",
		["Grovel"] = "주문 7267",
		["Growl"] = "포효",
		["Guardian's Favor"] = "수호신의 은총",
		["Gun Specialization"] = "총기류 전문화",
		["Guns"] = "총",
		["Hammer of Justice"] = "심판의 망치",
		["Hammer of Wrath"] = "일격",
		["Hamstring"] = "무력화",
		["Harass"] = "괴롭히기",
		["Hardiness"] = "강인함",
		["Hawk Eye"] = "매의 눈",
		["Heal"] = "치유",
		["Healing Focus"] = "치유의 정신 집중",
		["Healing Light"] = "치유의 빛",
		["Healing Stream Totem"] = "치유의 토템",
		["Healing Touch"] = "치유의 손길",
		["Healing Wave"] = "치유의 물결",
		["Healing Way"] = "치유의 길",
		["Health Funnel"] = "생명력 집중",
		["Heart of the Wild"] = "야생의 정수",
		["Heavy Sharpening Stone"] = "단단한 숫돌",
		["Hellfire Effect"] = "지옥의 불길 효과",
		["Hellfire"] = "지옥의 불길",
		["Hemorrhage"] = "과다출혈",
		["Herb Gathering"] = "약초채집",
		["Herbalism"] = "약초 채집",
		["Heroic Strike"] = "영웅의 일격",
		["Heroism"] = "영웅심",
		["Hex of Weakness"] = "무력의 주술",
		["Hibernate"] = "겨울잠",
		["Holy Fire"] = "신성한 불꽃",
		["Holy Light"] = "성스러운 빛",
		["Holy Nova"] = "신성한 폭발",
		["Holy Power"] = "신성 마법 강화",
		["Holy Reach"] = "신성한 테두리",
		["Holy Shield"] = "신성한 방패",
		["Holy Shock"] = "신성 충격",
		["Holy Specialization"] = "신성 마법 전문화",
		["Holy Wrath"] = "신의 격노",
		["Honorless Target"] = "명예 점수 없음",
		["Horse Riding"] = "말 타기",
		["Howl of Terror"] = "공포의 울부짖음",
		["Humanoid Slaying"] = "인간형 사냥술",
		["Hunter's Mark"] = "사냥꾼의 징표",
		["Hurricane"] = "허리케인",
		["Ice Armor"] = "얼음 갑옷",
		["Ice Barrier"] = "얼음 보호막",
		["Ice Block"] = "얼음 방패",
		["Ice Lance"] = "Ice Lance",  --  Need to translated
		["Ice Shards"] = "얼음 파편",
		["Ignite"] = "작열",
		["Illumination"] = "계시",
		["Immolate"] = "제물",
		["Immolation Trap Effect"] = "제물의 덫",
		["Immolation Trap"] = "제물의 덫",
		["Impact"] = "충돌",
		["Impale"] = "꿰뚫기",
		["Improved Ambush"] = "매복 연마",
		["Improved Arcane Explosion"] = "신비한 폭발 연마",
		["Improved Arcane Missiles"] = "신비한 화살 연마",
		["Improved Arcane Shot"] = "신비한 사격 연마",
		["Improved Aspect of the Hawk"] = "매의 상 연마",
		["Improved Aspect of the Monkey"] = "원숭이의 상 연마",
		["Improved Backstab"] = "기습 연마",
		["Improved Battle Shout"] = "전투의 외침 연마",
		["Improved Berserker Rage"] = "광전사의 격노 연마",
		["Improved Blessing of Might"] = "힘의 축복 연마",
		["Improved Blessing of Wisdom"] = "지혜의 축복 연마",
		["Improved Blizzard"] = "눈보라 연마",
		["Improved Bloodrage"] = "피의 분노 연마",
		["Improved Chain Heal"] = "연쇄 치유 연마",
		["Improved Chain Lightning"] = "연쇄 번개 연마",
		["Improved Challenging Shout"] = "도전의 외침 연마",
		["Improved Charge"] = "돌진 연마",
		["Improved Cheap Shot"] = "Improved Cheap Shot",  --  Need to translated
		["Improved Cleave"] = "회전베기 연마",
		["Improved Concentration Aura"] = "집중의 오라 연마",
		["Improved Concussive Shot"] = "충격포 연마",
		["Improved Cone of Cold"] = "냉기 돌풍 연마",
		["Improved Corruption"] = "부패 연마",
		["Improved Counterspell"] = "마법 차단 연마",
		["Improved Curse of Agony"] = "고통의 저주 연마",
		["Improved Curse of Exhaustion"] = "피로의 저주 연마",
		["Improved Curse of Weakness"] = "무력화 저주 연마",
		["Improved Dampen Magic"] = "Improved Dampen Magic",  --  Need to translated
		["Improved Deadly Poison"] = "맹독 연구",
		["Improved Demoralizing Shout"] = "사기의 외침 연마",
		["Improved Devotion Aura"] = "기원의 오라 연마",
		["Improved Disarm"] = "무장 해제 연마",
		["Improved Distract"] = "혼란 연마",
		["Improved Drain Life"] = "생명력 흡수 연마",
		["Improved Drain Mana"] = "마나 흡수 연마",
		["Improved Drain Soul"] = "영혼 흡수 연마",
		["Improved Enrage"] = "분노 연마",
		["Improved Enslave Demon"] = "악마 지배 연마",
		["Improved Entangling Roots"] = "휘감는 뿌리 연마",
		["Improved Evasion"] = "Improved Evasion",  --  Need to translated
		["Improved Eviscerate"] = "절개 연마",
		["Improved Execute"] = "마무리 일격 연마",
		["Improved Expose Armor"] = "약점 노출 연마",
		["Improved Eyes of the Beast"] = "야수의 눈 연마",
		["Improved Fade"] = "소실 연마",
		["Improved Feign Death"] = "죽은척하기 연마",
		["Improved Fire Blast"] = "화염 작열 연마",
		["Improved Fire Nova Totem"] = "Improved Fire Nova Totem",  --  Need to translated
		["Improved Fire Ward"] = "화염계 수호 연마",
		["Improved Fireball"] = "화염구 연마",
		["Improved Firebolt"] = "불화살 연마",
		["Improved Firestone"] = "화염석 연마",
		["Improved Flamestrike"] = "불기둥 연마",
		["Improved Flametongue Weapon"] = "불꽃의 무기 연마",
		["Improved Flash of Light"] = "빛의 섬광 연마",
		["Improved Frost Nova"] = "얼음 회오리 연마",
		["Improved Frost Ward"] = "냉기의 수호",
		["Improved Frostbolt"] = "얼음 화살 연마",
		["Improved Frostbrand Weapon"] = "Improved Frostbrand Weapon",  --  Need to translated
		["Improved Garrote"] = "Improved Garrote",  --  Need to translated
		["Improved Ghost Wolf"] = "늑대 정령 연마",
		["Improved Gouge"] = "후려치기 연마",
		["Improved Grace of Air Totem"] = "Improved Grace of Air Totem",  --  Need to translated
		["Improved Grounding Totem"] = "Improved Grounding Totem",  --  Need to translated
		["Improved Hammer of Justice"] = "심판의 망치 연마",
		["Improved Hamstring"] = "무력화 연마",
		["Improved Healing Stream Totem"] = "Improved Healing Stream Totem",  --  Need to translated
		["Improved Healing Touch"] = "치유의 손길 연마",
		["Improved Healing Wave"] = "치유의 물결 연마",
		["Improved Healing"] = "치유 연마",
		["Improved Health Funnel"] = "생명력 집중 연마",
		["Improved Healthstone"] = "생명석 연마",
		["Improved Heroic Strike"] = "영웅의 일격 연마", 
		["Improved Hunter's Mark"] = "사냥꾼의 징표 연마",
		["Improved Immolate"] = "제물 연마",
		["Improved Imp"] = "임프 연마",
		["Improved Inner Fire"] = "내면의 열정 연마",
		["Improved Instant Poison"] = "Improved Instant Poison",  --  Need to translated
		["Improved Intercept"] = "봉쇄 연마",
		["Improved Intimidating Shout"] = "위협의 외침 연마",
		["Improved Judgement"] = "심판 연마",
		["Improved Kick"] = "발차기 연마",
		["Improved Kidney Shot"] = "급소 가격 연마",
		["Improved Lash of Pain"] = "고통의 채찍 연마",
		["Improved Lay on Hands"] = "신의 축복 연마",
		["Improved Lesser Healing Wave"] = "Improved Lesser Healing Wave",  --  Need to translated
		["Improved Life Tap"] = "생명력 전환 연마",
		["Improved Lightning Bolt"] = "번개 화살 연마",
		["Improved Lightning Shield"] = "번개 보호막 연마",
		["Improved Magma Totem"] = "용암 토템 연마",
		["Improved Mana Burn"] = "마나 연소 연마",
		["Improved Mana Shield"] = "마나 보호막 연마",
		["Improved Mana Spring Totem"] = "Improved Mana Spring Totem",  --  Need to translated
		["Improved Mark of the Wild"] = "야생의 징표 연마",
		["Improved Mend Pet"] = "동물 치료 연마",
		["Improved Mind Blast"] = "정신 분열 연마",
		["Improved Moonfire"] = "달빛 섬광 연마",
		["Improved Nature's Grasp"] = "자연의 손아귀 연마",
		["Improved Overpower"] = "제압 연마",
		["Improved Power Word: Fortitude"] = "신의 권능: 인내 연마",
		["Improved Power Word: Shield"] = "신의 권능: 보호막 연마",
		["Improved Prayer of Healing"] = "치유의 기원 연마",
		["Improved Psychic Scream"] = "영혼의 절규 연마",
		["Improved Pummel"] = "자루 공격 연마",
		["Improved Regrowth"] = "재생 연마",
		["Improved Reincarnation"] = "윤회 연마",
		["Improved Rejuvenation"] = "회복 연마",
		["Improved Rend"] = "분쇄 연마",
		["Improved Renew"] = "소생 연마",
		["Improved Retribution Aura"] = "응보의 오라 연마",
		["Improved Revenge"] = "복수 연마",
		["Improved Revive Pet"] = "야수 되살리기 연마",
		["Improved Righteous Fury"] = "정의의 격노 연마",
		["Improved Rockbiter Weapon"] = "Improved Rockbiter Weapon",  --  Need to translated
		["Improved Rupture"] = "파열 연마",
		["Improved Sap"] = "기절시키기 연마",
		["Improved Scorch"] = "불태우기 연마",
		["Improved Scorpid Sting"] = "전갈 쐐기 연마",
		["Improved Seal of Righteousness"] = "정의의 문장 연마",
		["Improved Seal of the Crusader"] = "성전사의 문장 연마",
		["Improved Searing Pain"] = "불타는 고통 연마",
		["Improved Searing Totem"] = "Improved Searing Totem",  --  Need to translated
		["Improved Serpent Sting"] = "독사 쐐기 연마",
		["Improved Shadow Bolt"] = "어둠의 화살 연마",
		["Improved Shadow Word: Pain"] = "어둠의 권능: 고통 연마",
		["Improved Shield Bash"] = "방패 가격 연마",
		["Improved Shield Block"] = "방패 막기 연마",
		["Improved Shield Wall"] = "방패의 벽 연마",
		["Improved Shred"] = "칼날 발톱 연마",
		["Improved Sinister Strike"] = "사악한 일격 연마",
		["Improved Slam"] = "격돌 연마",
		["Improved Slice and Dice"] = "난도질 연마",
		["Improved Spellstone"] = "주문석 연마",
		["Improved Sprint"] = "전력 질주 연마",
		["Improved Starfire"] = "별빛 화살 연마",
		["Improved Stoneclaw Totem"] = "Improved Stoneclaw Totem",  --  Need to translated
		["Improved Stoneskin Totem"] = "Improved Stoneskin Totem",  --  Need to translated
		["Improved Strength of Earth Totem"] = "Improved Strength of Earth Totem",  --  Need to translated
		["Improved Succubus"] = "서큐버스 연마",
		["Improved Sunder Armor"] = "방어구 가르기 연마",
		["Improved Taunt"] = "도발 연마",
		["Improved Thorns"] = "가시 연마",
		["Improved Thunder Clap"] = "천둥벼락 연마",
		["Improved Tranquility"] = "평온 연마",
		["Improved Vampiric Embrace"] = "흡혈의 선물 연마",
		["Improved Vanish"] = "소멸 연마",
		["Improved Voidwalker"] = "보이드워커 연마",
		["Improved Windfury Weapon"] = "Improved Windfury Weapon",  --  Need to translated
		["Improved Wing Clip"] = "날개 절단 연마",
		["Improved Wrath"] = "천벌 연마",
		["Incinerate"] = "소각",
		["Inferno"] = "불지옥",
		["Initiative"] = "선제 공격",
		["Inner Fire"] = "내면의 열정",
		["Inner Focus"] = "내면의 집중력",
		["Innervate"] = "정신 자극",
		["Insect Swarm"] = "곤충 떼",
		["Inspiration"] = "신의 계시",
		["Instant Poison II"] = "순간 효과 독 II",
		["Instant Poison III"] = "순간 효과 독 III",
		["Instant Poison IV"] = "순간 효과 독 IV",
		["Instant Poison V"] = "순간 효과 독 V",
		["Instant Poison VI"] = "순간 효과 독 VI",
		["Instant Poison"] = "순간 효과 독",
		["Intensity"] = "격렬",
		["Intercept Stun"] = "봉쇄 기절",
		["Intercept"] = "봉쇄",
		["Intervene"] = "Intervene",  --  Need to translated
		["Intimidating Shout"] = "위협의 외침",
		["Intimidation"] = "위협",
		["Invisibility"] = "투명화",
		["Invisibility"] = "Invisibility",  --  Need to translated
		["Iron Will"] = "강건한 의지",
		["Jewelcrafting"] = "Jewelcrafting",
		["Judgement of Command"] = "지휘의 심판",
		["Judgement of Justice"] = "정의의 심판",
		["Judgement of Light"] = "빛의 심판",
		["Judgement of Righteousness"] = "정의의 심판",  
		["Judgement of the Crusader"] = "성전사의 심판",
		["Judgement of Wisdom"] = "지혜의 심판",
		["Judgement"] = "심판",
		["Kick - Silenced"] = "발차기 - 침묵",
		["Kick"] = "발차기",
		["Kidney Shot"] = "급소 가격",
		["Kill Command"] = "Kill Command",  --  Need to translated
		["Killer Instinct"] = "살수의 본능",
		["Kodo Riding"] = "코도 타기",
		["Lacerate"] = "가르기",
		["Lacerate"] = "Lacerate",  --  Need to translated
		["Lash of Pain"] = "고통의 채찍",
		["Last Stand"] = "최후의 저항",
		["Lasting Judgement"] = "영원한 심판",
		["Lay on Hands"] = "신의 축복",
		["Leader of the Pack"] = "무리의 우두머리",
		["Leather"] = "가죽",
		["Leatherworking"] = "가죽 세공",
		["Lesser Heal"] = "하급 치유",
		["Lesser Healing Wave"] = "하급 치유의 물결",
		["Lesser Invisibility"] = "하급 투명화",
		["Lethal Shots"] = "정밀한 사격",
		["Lethality"] = "치명상",
		["Levitate"] = "공중 부양",
		["Libram"] = "성서",
		["Life Tap"] = "생명력 전환",
		["Lifebloom"] = "Lifebloom",  --  Need to translated
		["Lifegiving Gem"] = "Lifegiving Gem",
		["Lightning Bolt"] = "번개 화살",
		["Lightning Breath"] = "번개 숨결",
		["Lightning Mastery"] = "번개 전문화",
		["Lightning Reflexes"] = "번개같은 반사 신경",
		["Lightning Shield"] = "번개 보호막",
		["Lightwell Renew"] = "빛샘의 소생",
		["Lightwell"] = "빛샘",
		["Lockpicking"] = "자물쇠 따기",
		["Long Daze"] = "오랜 멍해짐",
		["Mace Specialization"] = "둔기류 전문화",
		["Mace Stun Effect"] = "철퇴 기절 효과",
		["Mage Armor"] = "마법사 갑옷",
		["Magic Attunement"] = "마법의 조화",  
		["Magma Totem"] = "용암 토템",
		["Mail"] = "사슬",
		["Maim"] = "Maim",  --  Need to translated
		["Malice"] = "원한",
		["Mana Burn"] = "마나 연소",
		["Mana Feed"] = "마나 섭취",  
		["Mana Shield"] = "마나 보호막",
		["Mana Spring Totem"] = "마나샘 토템",
		["Mana Tide Totem"] = "마나 해일 토템",
		["Mangle (Bear)"] = "Mangle (Bear)",  --  Need to translated
		["Mangle (Cat)"] = "Mangle (Cat)",  --  Need to translated
		["Mangle"] = "짓이기기",
		["Mark of the Wild"] = "야생의 징표",
		["Martyrdom"] = "헌신",
		["Mass Dispel"] = "대규모 무효화",
		["Master Demonologist"] = "악령술의 대가",
		["Master of Deception"] = "속임수의 대가",
		["Master of Elements"] = "원소 마법의 대가",  
		["Master Summoner"] = "소환의 대가",
		["Maul"] = "후려치기",
		["Mechanostrider Piloting"] = "기계타조 조종",
		["Meditation"] = "명상",
		["Melee Specialization"] = "근접 무기 전문화",
		["Mend Pet"] = "동물 치료",
		["Mental Agility"] = "마음의 기민함",
		["Mental Strength"] = "정신력",
		["Mind Blast"] = "정신 분열",
		["Mind Control"] = "정신 지배",
		["Mind Flay"] = "정신의 채찍",
		["Mind Soothe"] = "평정",
		["Mind Vision"] = "마음의 눈",
		["Mind-numbing Poison II"] = "정신 마비 독 II",
		["Mind-numbing Poison III"] = "정신 마비 독 III",
		["Mind-numbing Poison"] = "정신 마비 독",
		["Mining"] = "채광",
		["Misdirection"] = "Misdirection",  --  Need to translated
		["Mocking Blow"] = "도발의 일격",
		["Molten Armor"] = "Molten Armor",  --  Need to translated
		["Mongoose Bite"] = "살쾡이의 이빨",
		["Monster Slaying"] = "몬스터 사냥술",
		["Moonfire"] = "달빛 섬광",
		["Moonfury"] = "달의 분노",
		["Moonglow"] = "달빛",
		["Moonkin Aura"] = "달빛야수 오라",
		["Moonkin Form"] = "달빛야수 변신",
		["Mortal Shots"] = "죽음의 사격",
		["Mortal Strike"] = "죽음의 일격",
		["Multi-Shot"] = "일제 사격",
		["Murder"] = "학살",
		["Mutilate"] = "Mutilate",  --  Need to translated
		["Natural Armor"] = "무쇠 가죽",
		["Natural Shapeshifter"] = "변신의 대가",
		["Natural Weapons"] = "자연의 무기",
		["Nature Resistance Totem"] = "자연 저항 토템",
		["Nature Resistance"] = "자연 마법 저항",
		["Nature Weakness"] = "자연 약점",  
		["Nature's Focus"] = "자연의 정신 집중",
		["Nature's Grace"] = "자연의 은혜",
		["Nature's Grasp"] = "자연의 손아귀",
		["Nature's Reach"] = "자연의 테두리",
		["Nature's Swiftness"] = "자연의 신속함",
		["Negative Charge"] = "음전하",
		["Nightfall"] = "일몰",
		["Omen of Clarity"] = "청명의 전조",
		["One-Handed Axes"] = "한손 도끼",
		["One-Handed Maces"] = "한손 철퇴",
		["One-Handed Swords"] = "한손 검",
		["One-Handed Weapon Specialization"] = "한손 무기류 전문화",
		["Opening - No Text"] = "열기",
		["Opening"] = "열기",
		["Opportunity"] = "기회 포착",
		["Overpower"] = "제압",
		["Pain Suppression"] = "Pain Suppression",  --  Need to translated
		["Paranoia"] = "망상",
		["Parry"] = "무기 막기",
		["Pathfinding"] = "길 찾기",
		["Perception"] = "직관력",
		["Permafrost"] = "영구 결빙",
		["Pet Aggression"] = "야수의 공격성",
		["Pet Hardiness"] = "야수의 강인함",
		["Pet Recovery"] = "야수의 회복력",
		["Pet Resistance"] = "야수의 저항력",
		["Phase Shift"] = "위상 변화",
		["Pick Lock"] = "자물쇠 따기",
		["Pick Pocket"] = "훔치기",
		["Piercing Howl"] = "날카로운 고함",
		["Piercing Ice"] = "사무치는 냉기",
		["Plate Mail"] = "판금 갑옷",
		["Poison Cleansing Totem"] = "독 정화 토템",
		["Poisons"] = "독 조제",
		["Polearm Specialization"] = "장창류 전문화",
		["Polearms"] = "장창류",
		["Polymorph"] = "변이",
		["Polymorph: Pig"] = "변이: 돼지",
		["Polymorph: Turtle"] = "변이: 거북이",
		["Portal: Darnassus"] = "차원의 문: 다르나서스",
		["Portal: Ironforge"] = "차원의 문: 아이언포지",
		["Portal: Orgrimmar"] = "차원의 문: 오그리마",
		["Portal: Stormwind"] = "차원의 문: 스톰윈드",
		["Portal: Thunder Bluff"] = "차원의 문: 썬더 블러프",
		["Portal: Undercity"] = "차원의 문: 언더시티",
		["Positive Charge"] = "양전하",    
		["Pounce Bleed"] = "암습 피해",
		["Pounce"] = "암습",
		["Power Infusion"] = "마력 주입",
		["Power Word: Fortitude"] = "신의 권능: 인내",
		["Power Word: Shield"] = "신의 권능: 보호막",
		["Prayer of Fortitude"] = "인내의 기원",
		["Prayer of Healing"] = "치유의 기원",
		["Prayer of Mending"] = "Prayer of Mending",  --  Need to translated
		["Prayer of Shadow Protection"] = "암흑 보호의 기원",
		["Prayer of Spirit"] = "정신력의 기원",
		["Precision"] = "정밀함",
		["Predatory Strikes"] = "야생의 포식자",
		["Premeditation"] = "사전계획",
		["Preparation"] = "마음가짐",
		["Presence of Mind"] = "냉정",
		["Primal Fury"] = "야수의 분노",
		["Prowl"] = "숨기",
		["Psychic Scream"] = "영혼의 절규",
		["Pummel"] = "자루 공격",
		["Purge"] = "정화",
		["Purification"] = "심신의 정화",
		["Purify"] = "순화",
		["Pursuit of Justice"] = "심판의 추격",
		["Pyroblast"] = "불덩이 작열",
		["Pyroclasm"] = "화염 파열",
		["Quick Shots"] = "신속 사격",
		["Quick Shots"] = "Quick Shots",
		["Quickness"] = "민첩",
		["Rain of Fire"] = "불의 비",
		["Rake"] = "갈퀴 발톱",
		["Ram Riding"] = "산양 타기",
		["Rampage"] = "광란",
		["Ranged Weapon Specialization"] = "원거리 무기 전문화",
		["Rapid Concealment"] = "Rapid Concealment",  --  Need to translated
		["Rapid Fire"] = "속사",
		["Raptor Riding"] = "랩터 타기",
		["Raptor Strike"] = "랩터의 일격",
		["Ravage"] = "약탈",
		["Readiness"] = "만반의 준비",
		["Rebirth"] = "환생",
		["Reckless Charge"] = "무모한 돌진",
		["Recklessness"] = "무모한 희생",
		["Reckoning"] = "징벌",
		["Redemption"] = "구원",
		["Redoubt"] = "보루",
		["Reflection"] = "반사",
		["Regeneration"] = "재생력",
		["Regrowth"] = "재생",
		["Reincarnation"] = "윤회",
		["Rejuvenation"] = "회복",
		["Relentless Strikes"] = "가혹한 일격",
		["Remorseless Attacks"] = "냉혹함",
		["Remorseless"] = "냉혹함",
		["Remove Curse"] = "저주 해제",
		["Remove Insignia"] = "계급장 제거",
		["Remove Lesser Curse"] = "하급 저주 해제",
		["Rend"] = "분쇄",
		["Renew"] = "소생",
		["Repentance"] = "참회",
		["Restorative Totems"] = "회복의 토템",
		["Resurrection"] = "부활",
		["Retaliation"] = "보복",
		["Retribution Aura"] = "응보의 오라",
		["Revenge Stun"] = "복수 기절",
		["Revenge"] = "복수",
		["Reverberation"] = "산울림",
		["Revive Pet"] = "야수 되살리기",
		["Righteous Defense"] = "Righteous Defense",  --  Need to translated
		["Righteous Fury"] = "정의의 격노",
		["Rip"] = "도려내기",
		["Riposte"] = "반격",
		["Ritual of Doom Effect"] = "파멸의 의식",
		["Ritual of Doom"] = "파멸의 의식",
		["Ritual of Souls"] = "Ritual of Souls",  --  Need to translated
		["Ritual of Summoning"] = "소환 의식",
		["Rockbiter Weapon"] = "대지의 무기",
		["Rogue Passive"] = "Rogue Passive",    -- 확인요망
		["Rough Sharpening Stone"] = "조잡한 숫돌",
		["Ruin"] = "붕괴",
		["Rupture"] = "파열",
		["Ruthlessness"] = "무정함",
		["Sacrifice"] = "희생",
		["Safe Fall"] = "낙법",
		["Sanctity Aura"] = "고결의 오라",
		["Sap"] = "기절시키기",
		["Savage Fury"] = "맹렬한 격노",
		["Savage Strikes"] = "야생의 일격",
		["Scare Beast"] = "야수 겁주기",
		["Scatter Shot"] = "산탄 사격",
		["Scorch"] = "불태우기",
		["Scorpid Poison"] = "전갈독",
		["Scorpid Sting"] = "전갈 쐐기",
		["Screech"] = "날카로운 울음소리",
		["Seal Fate"] = "운명의 낙인",
		["Seal of Blood"] = "Seal of Blood",  --  Need to translated
		["Seal of Command"] = "지휘의 문장",
		["Seal of Justice"] = "심판의 문장",
		["Seal of Light"] = "빛의 문장",
		["Seal of Righteousness"] = "정의의 문장",
		["Seal of the Crusader"] = "성전사의 문장",
		["Seal of Vengeance"] = "Seal of Vengeance",  --  Need to translated
		["Seal of Wisdom"] = "지혜의 문장",
		["Searing Light"] = "타오르는 빛",
		["Searing Pain"] = "불타는 고통",
		["Searing Totem"] = "불타는 토템",
		["Second Wind"] = "재기의 바람",
		["Seduction"] = "현혹",
		["Seed of Corruption"] = "Seed of Corruption",  --  Need to translated
		["Sense Demons"] = "악마 감지",
		["Sense Undead"] = "언데드 감지",
		["Sentry Totem"] = "감시의 토템",
		["Serpent Sting"] = "독사 쐐기",
		["Setup"] = "사전 준비",
		["Shackle Undead"] = "언데드 속박",
		["Shadow Affinity"] = "암흑 마법 친화",
		["Shadow Bolt"] = "어둠의 화살",
		["Shadow Focus"] = "암흑 마법 집중",
		["Shadow Mastery"] = "암흑 마법 전문화",
		["Shadow Protection"] = "어둠의 보호",
		["Shadow Reach"] = "어둠의 테두리",
		["Shadow Resistance Aura"] = "암흑 저항의 오라",
		["Shadow Resistance"] = "암흑 마법 저항",
		["Shadow Trance"] = "어둠의 무아지경",
		["Shadow Vulnerability"] = "암흑 저항력 약화",
		["Shadow Ward"] = "암흑계 수호",
		["Shadow Weakness"] = "암흑 약점",  
		["Shadow Weaving"] = "어둠의 매듭",
		["Shadow Word: Death"] = "Shadow Word: Death",  --  Need to translated
		["Shadow Word: Pain"] = "어둠의 권능: 고통",
		["Shadowburn"] = "어둠의 연소",
		["Shadowfiend"] = "Shadowfiend",  --  Need to translated
		["Shadowform"] = "어둠의 형상",
		["Shadowfury"] = "Shadowfury",  --  Need to translated
		["Shadowguard"] = "어둠의 수호",
		["Shadowmeld Passive"] = "그림자 숨기",
		["Shadowmeld"] = "그림자 숨기",
		["Shadowstep"] = "Shadowstep",  --  Need to translated
		["Shamanistic Rage"] = "Shamanistic Rage",  --  Need to translated
		["Sharpened Claws"] = "날카로운 발톱",
		["Shatter"] = "산산조각",
		["Sheep"] = "Sheep",  --  Need to translated
		["Shell Shield"] = "껍질 방패",
		["Shield Bash - Silenced"] = "방패 가격 - 침묵",
		["Shield Bash"] = "방패 가격",
		["Shield Block"] = "방패 막기",
		["Shield Slam"] = "방패 밀쳐내기",
		["Shield Specialization"] = "방패 전문화",
		["Shield Wall"] = "방패의 벽",
		["Shield"] = "방패",
		["Shiv"] = "Shiv",  --  Need to translated
		["Shoot Bow"] = "활 발사",
		["Shoot Crossbow"] = "석궁 발사",
		["Shoot Gun"] = "총 발사",
		["Shoot"] = "마법봉 발사",
		["Shred"] = "절단",
		["Silence"] = "침묵",
		["Silencing Shot"] = "침묵의 사격",
		["Silent Resolve"] = "무언의 결심",
		["Sinister Strike"] = "사악한 일격",
		["Siphon Life"] = "생명력 착취",
		["Skinning"] = "무두질",
		["Slam"] = "격돌",
		["Sleep"] = "수면",
		["Slice and Dice"] = "난도질",
		["Slow Fall"] = "저속 낙하",
		["Slow"] = "감속",
		["Smelting"] = "제련술",
		["Smite"] = "성스러운 일격",
		["Snake Trap"] = "Snake Trap",  --  Need to translated
		["Solid Sharpening Stone"] = "견고한 숫돌",
		["Soothe Animal"] = "동물 달래기",
		["Soothing Kiss"] = "유혹의 입맞춤",
		["Soul Fire"] = "영혼의 불꽃",
		["Soul Link"] = "영혼의 고리",
		["Soul Siphon"] = "영혼 착취",
		["Soulshatter"] = "Soulshatter",  --  Need to translated
		["Soulstone Resurrection"] = "영혼석 부활",
		["Spell Lock"] = "주문 잠금",
		["Spell Reflection"] = "주문 반사",
		["Spell Warding"] = "주문 수호",
		["Spellsteal"] = "Spellsteal",  --  Need to translated
		["Spirit Bond"] = "정신의 결속",
		["Spirit of Redemption"] = "구원의 영혼",
		["Spirit Tap"] = "정신력 누출",
		["Spiritual Attunement"] = "Spiritual Attunement",  --  Need to translated
		["Spiritual Focus"] = "영적인 집중력",
		["Spiritual Guidance"] = "영혼의 길잡이",
		["Spiritual Healing"] = "영혼의 치유",
		["Sprint"] = "전력 질주",
		["Stance Mastery"] = "Stance Mastery",  --  Need to translated
		["Starfire Stun"] = "별빛 화살 기절",
		["Starfire"] = "별빛 화살",
		["Starshards"] = "별조각",
		["Staves"] = "지팡이",
		["Steady Shot"] = "Steady Shot",  --  Need to translated
		["Stealth"] = "은신",
		["Stoneclaw Totem"] = "돌발톱 토템",
		["Stoneform"] = "석화",
		["Stoneskin Totem"] = "돌가죽 토템",
		["Stormstrike"] = "폭풍의 일격",
		["Strength of Earth Totem"] = "대지력 토템",
		["Stuck"] = "고립 상태 벗어나기",
		["Subtlety"] = "영혼의 길잡이",
		["Suffering"] = "고통",
		["Summon Charger"] = "군마 소환",
		["Summon Dreadsteed"] = "공포마 소환",
		["Summon Felguard"] = "Summon Felguard",  --  Need to translated
		["Summon Felhunter"] = "지옥사냥개 소환",
		["Summon Felsteed"] = "지옥마 소환",
		["Summon Imp"] = "임프 소환",
		["Summon Succubus"] = "서큐버스 소환",
		["Summon Voidwalker"] = "보이드워커 소환",
		["Summon Warhorse"] = "군마 소환",
		["Summon Water Elemental"] = "물의 정령 소환",
		["Sunder Armor"] = "방어구 가르기",
		["Suppression"] = "억제",
		["Surefooted"] = "침착함",
		["Survivalist"] = "생존의 대가",
		["Sweeping Strikes"] = "휩쓸기 일격",
		["Swiftmend"] = "신속한 치유",
		["Swipe"] = "휘둘러치기",
		["Sword Specialization"] = "도검류 전문화",
		["Tactical Mastery"] = "전술 숙련",
		["Tailoring"] = "재봉술",
		["Tainted Blood"] = "얼룩진 피",
		["Tame Beast"] = "야수 길들이기",
		["Tamed Pet Passive"] = "길들인 소환수 지속효과", 
		["Taunt"] = "도발",
		["Teleport: Darnassus"] = "순간이동: 다르나서스",
		["Teleport: Ironforge"] = "순간이동: 아이언포지",
		["Teleport: Moonglade"] = "순간이동: 달의 숲",
		["Teleport: Orgrimmar"] = "순간이동: 오그리마",
		["Teleport: Stormwind"] = "순간이동: 스톰윈드",
		["Teleport: Thunder Bluff"] = "순간이동: 썬더 블러프",
		["Teleport: Undercity"] = "순간이동: 언더시티",
		["The Beast Within"] = "The Beast Within",  --  Need to translated
		["The Human Spirit"] = "인간의 정신력",
		["Thick Hide"] = "두꺼운 가죽",
		["Thorns"] = "가시",
		["Throw"] = "투척",
		["Throwing Specialization"] = "투척술 전문화",
		["Throwing Weapon Specialization"] = "Throwing Weapon Specialization",  --  Need to translated
		["Thrown"] = "투척",
		["Thunder Clap"] = "천둥벼락",
		["Thundering Strikes"] = "우레의 일격",
		["Thunderstomp"] = "천둥 발구르기",
		["Tidal Focus"] = "해일의 집중",
		["Tidal Mastery"] = "해일의 깨달음",
		["Tiger Riding"] = "호랑이 타기",
		["Tiger's Fury"] = "맹공격",
		["Torment"] = "고문",
		["Totem of Wrath"] = "Totem of Wrath",  --  Need to translated
		["Totem"] = "토템",
		["Totemic Focus"] = "토템 집중",
		["Touch of Weakness"] = "무력의 손길",
		["Toughness"] = "강인함",
		["Traces of Silithyst"] = "실리시스트의 자취",  
		["Track Beasts"] = "야수 추적",
		["Track Demons"] = "악마 추적",
		["Track Dragonkin"] = "용족 추적",
		["Track Elementals"] = "정령 추적",
		["Track Giants"] = "거인 추적",
		["Track Hidden"] = "은신 추적",
		["Track Humanoids"] = "인간형 추적",
		["Track Undead"] = "언데드 추적",
		["Tranquil Air Totem"] = "평온의 토템",
		["Tranquil Spirit"] = "평온한 정신",
		["Tranquility"] = "평온",
		["Tranquilizing Shot"] = "평정의 사격",
		["Trap Mastery"] = "덫 숙련",
		["Travel Form"] = "치타 변신",
		["Tree of Life"] = "Tree of Life",  --  Need to translated
		["Tremor Totem"] = "진동의 토템",
		["Tribal Leatherworking"] = "전통 가죽세공",
		["Trueshot Aura"] = "정조준 오라",
		["Turn Undead"] = "언데드 퇴치",
		["Two-Handed Axes and Maces"] = "양손 도끼류 및 둔기류",
		["Two-Handed Axes"] = "양손 도끼",
		["Two-Handed Maces"] = "양손 철퇴",
		["Two-Handed Swords"] = "양손 검",
		["Two-Handed Weapon Specialization"] = "양손 무기류 전문화",
		["Unarmed"] = "맨손",
		["Unbreakable Will"] = "굳은 의지",
		["Unbridled Wrath Effect"] = "Unbridled Wrath Effect",  --  Need to translated
		["Unbridled Wrath"] = "분노 해방",
		["Undead Horsemanship"] = "언데드 승마술",
		["Underwater Breathing"] = "수중 호흡",
		["Unending Breath"] = "영원의 숨결",
		["Unholy Power"] = "부정의 힘",
		["Unleashed Fury"] = "격노 폭발",
		["Unleashed Rage"] = "해방된 분노",
		["Unstable Affliction"] = "Unstable Affliction",  --  Need to translated
		["Unyielding Faith"] = "굳은 신념",
		["Vampiric Embrace"] = "흡혈의 선물",
		["Vampiric Touch"] = "Vampiric Touch",  --  Need to translated
		["Vanish"] = "소멸",
		["Vanished"] = "소멸",
		["Vengeance"] = "복수",
		["Victory Rush"] = "Victory Rush",  --  Need to translated
		["Vigor"] = "강한 체력",
		["Vile Poisons"] = "치명적인 독",
		["Vindication"] = "비호",
		["Viper Sting"] = "살무사 쐐기",
		["Volley"] = "연발 사격",
		["Wand Specialization"] = "마법봉류 전문화",
		["Wands"] = "마법봉",
		["War Stomp"] = "전투 발구르기",
		["Water Breathing"] = "수중 호흡", 
		["Water Shield"] = "Water Shield",  --  Need to translated
		["Water Walking"] = "수면 걷기",
		["Waterbolt"] =	"Waterbolt",  --  Need to translated
		["Weakened Soul"] = "약화된 영혼",
		["Weaponsmith"] = "무기제작",
		["Whirlwind"] = "소용돌이",
		["Will of the Forsaken"] = "포세이큰의 의지",
		["Windfury Totem"] = "질풍의 토템",
		["Windfury Weapon"] = "질풍의 무기",
		["Windwall Totem"] = "바람막이 토템",
		["Wing Clip"] = "날개 절단",
		["Winter's Chill"] = "혹한의 추위",
		["Wisp Spirit"] = "위습의 영혼",
		["Wolf Riding"] = "늑대 타기",
		["Wound Poison II"] = "상처 감염 독 II",
		["Wound Poison III"] = "상처 감염 독 III",
		["Wound Poison IV"] = "상처 감염 독 IV",
		["Wound Poison"] = "상처 감염 독",
		["Wrath of Air Totem"] = "Wrath of Air Totem",  --  Need to translated
		["Wrath"] = "천벌",
		["Wyvern Sting"] = "비룡 쐐기",
	}
end)

local spellIcons = {
	--	["Anesthetic Poison"] = true,
	--	["Anguish"] = true,
	--	["Arcane Blast"] = true,
	--	["Avenger's Shield"] = true,
	--	["Avenging Wrath"] = true,
	--	["Avoidance"] = true,
	--	["Backlash"] = true,
	--	["Binding Heal"] = true,
	--	["Blazing Speed"] = true,
	--	["Bloodlust"] = true,
	--	["Circle of Healing"] = true,
	--	["Cloak of Shadows"] = true,
	--	["Consume Magic"] = true,
	--	["Crusader Aura"] = true,
	--	["Crusader Strike"] = true,
	--	["Cyclone"] = true,
	--	["Deadly Throw"] = true,
	--	["Divine Illumination"] = true,
	--	["Dragon's Breath"] = true,
	--	["Dragonscale Leatherworking"] = true,	
	--	["Earth Elemental Totem"] = true,
	--	["Earth Shield"] = true,
	--	["Envenom"] = true,
	--	["Fel Armor"] = true,
	--	["Fire Elemental Totem"] = true,
	--	["Flight Form"] = true,
	--	["Heroism"] = true,
	--	["Ice Lance"] = true,
	--	["Invisibility"] = true,
	--	["Kill Command"] = true, 
	--	["Lacerate"] = true,
	--	["Lifebloom"] = true,
	--	["Maim"] = true,
	--	["Mangle (Bear)"] = true,
	--	["Mangle (Cat)"] = true,
	--	["Misdirection"] = true,
	--	["Molten Armor"] = true,
	--	["Mutilate"] = true,
	--	["Pain Suppression"] = true,
	--	["Prayer of Mending"] = true,
	--	["Rampage"] = true,
	--	["Righteous Defense"] = true,
	--	["Ritual of Souls"] = true,
	--	["Seal of Blood"] = true,
	--	["Seal of Vengeance"] = true,
	--	["Second Wind"] = true,
	--	["Seed of Corruption"] = true,
	--	["Shadow Word: Death"] = true,
	--	["Shadowfiend"] = true,
	--	["Shadowfury"] = true,
	--	["Shadowstep"] = true,
	--	["Shamanistic Rage"] = true,
	--	["Shiv"] = true,
	--	["Slow"] = true,
	--	["Snake Trap"] = true,
	--	["Soul Siphon"] = true,
	--	["Soulshatter"] = true,
	--	["Spellsteal"] = true,
	--	["Spiritual Attunement"] = true,
	--	["Stance Mastery"] = true,
	--	["Steady Shot"] = true,
	--	["Summon Felguard"] = true,
	--	["The Beast Within"] = true,
	--	["Tree of Life"] = true,
	--	["Unleashed Rage"] = true,
	--	["Unstable Affliction"] = true,
	--	["Vampiric Touch"] = true,
	--	["Victory Rush"] = true,
	--	["Water Shield"] = true,
	["Abolish Disease"] = "Spell_Nature_NullifyDisease",
	["Abolish Poison Effect"] = "Spell_Nature_NullifyPoison_02",
	["Abolish Poison"] = "Spell_Nature_NullifyPoison_02",
	["Acid Breath"] = "Spell_Nature_Acid_01",
	["Acid of Hakkar"] = "Spell_Nature_Acid_01",
	["Acid Spit"] = "Spell_Nature_CorrosiveBreath",
	["Acid Splash"] = "INV_Drink_06",
	["Activate MG Turret"] = "INV_Weapon_Rifle_10",
	["Adrenaline Rush"] = "Spell_Shadow_ShadowWordDominate",
	["Aftermath"] = "Spell_Fire_Fire",
	["Aggression"] = "Ability_Racial_Avatar",
	["Aimed Shot"] = "INV_Spear_07",
	["Alchemy"] = "Trade_Alchemy",
	["Ambush"] = "Ability_Rogue_Ambush",
	["Amplify Curse"] = "Spell_Shadow_Contagion",
	["Amplify Damage"] = "Spell_Nature_AbolishMagic",
	["Amplify Flames"] = "Spell_Fire_Fireball",
	["Amplify Magic"] = "Spell_Holy_FlashHeal",
	["Ancestral Fortitude"] = "Spell_Nature_UndyingStrength",
	["Ancestral Healing"] = "Spell_Nature_UndyingStrength",
	["Ancestral Knowledge"] = "Spell_Shadow_GrimWard",
	["Ancestral Spirit"] = "Spell_Nature_Regenerate",
	["Anger Management"] = "Spell_Holy_BlessingOfStamina",
	["Anticipation"] = "Spell_Nature_MirrorImage",
	["Aqua Jet"] = "Spell_Frost_ChillingBlast",
	["Aquatic Form"] = "Ability_Druid_AquaticForm",
	["Arcane Bolt"] = "Spell_Arcane_StarFire",
	["Arcane Brilliance"] = "Spell_Holy_ArcaneIntellect",
	["Arcane Concentration"] = "Spell_Shadow_ManaBurn",
	["Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Arcane Focus"] = "Spell_Holy_Devotion",
	["Arcane Instability"] = "Spell_Shadow_Teleport",
	["Arcane Intellect"] = "Spell_Holy_MagicalSentry",
	["Arcane Meditation"] = "Spell_Shadow_SiphonMana",
	["Arcane Mind"] = "Spell_Shadow_Charm",
	["Arcane Missiles"] = "Spell_Nature_StarFall",
	["Arcane Potency"] = "Spell_Arcane_StarFire",
	["Arcane Power"] = "Spell_Nature_Lightning",
	["Arcane Resistance"] = "Spell_Nature_StarFall",
	["Arcane Shot"] = "Ability_ImpalingBolt",
	["Arcane Subtlety"] = "Spell_Holy_DispelMagic",
	["Arcane Weakness"] = "INV_Misc_QirajiCrystal_01",
	["Arcing Smash"] = "Ability_Warrior_Cleave",
	["Arctic Reach"] = "Spell_Shadow_DarkRitual",
	["Arugal's Curse"] = "Spell_Shadow_GatherShadows",
	["Arugal's Gift"] = "Spell_Shadow_ChillTouch",
	["Ascendance"] = "INV_Misc_Gem_Pearl_04",
	["Aspect of Arlokk"] = "Ability_Vanish",
	["Aspect of Jeklik"] = "Spell_Shadow_Teleport",
	["Aspect of Mar'li"] = "Ability_Smash",
	["Aspect of the Beast"] = "Ability_Mount_PinkTiger",
	["Aspect of the Cheetah"] = "Ability_Mount_JungleTiger",
	["Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Aspect of the Pack"] = "Ability_Mount_WhiteTiger",
	["Aspect of the Wild"] = "Spell_Nature_ProtectionformNature",
	["Aspect of Venoxis"] = "Spell_Nature_CorrosiveBreath",
	["Astral Recall"] = "Spell_Nature_AstralRecal",
	["Attack"] = "Spell_Fire_SearingTotem",
	["Attacking"] = "Temp",
	["Aura of Command"] = "INV_Banner_03",
	["Aural Shock"] = "Spell_Shadow_Possession",
	["Auto Shot"] = "Ability_Whirlwind",
	["Avoidance"] = "Ability_Warrior_Revenge",
	["Axe Flurry"] = "INV_Axe_06",
	["Axe Specialization"] = "INV_Axe_06",
	["Axe Toss"] = "INV_Axe_04",
	["Backhand"] = "INV_Gauntlets_05",
	["Backstab"] = "Ability_BackStab",
	["Bane"] = "Spell_Shadow_DeathPact",
	["Baneful Poison"] = "Spell_Nature_CorrosiveBreath",
	["Banish"] = "Spell_Shadow_Cripple",
	["Banshee Curse"] = "Spell_Nature_Drowsy",
	["Banshee Shriek"] = "Spell_Shadow_ImpPhaseShift",
	["Barbed Sting"] = "Spell_Nature_NullifyPoison",
	["Barkskin Effect"] = "Spell_Nature_StoneClawTotem",
	["Barkskin"] = "Spell_Nature_StoneClawTotem",
	["Barrage"] = "Ability_UpgradeMoonGlaive",
	["Bash"] = "Ability_Druid_Bash",
	["Basic Campfire"] = "Spell_Fire_Fire",
	["Battle Shout"] = "Ability_Warrior_BattleShout",
	["Battle Stance Passive"] = "Ability_Warrior_OffensiveStance",
	["Battle Stance"] = "Ability_Warrior_OffensiveStance",
	["Bear Form"] = "Ability_Racial_BearForm",
	["Beast Lore"] = "Ability_Physical_Taunt",
	["Beast Slaying"] = "INV_Misc_Pelt_Bear_Ruin_02",
	["Beast Training"] = "Ability_Hunter_BeastCall02",
	["Befuddlement"] = "Spell_Shadow_MindSteal",
	["Benediction"] = "Spell_Frost_WindWalkOn",
	["Berserker Charge"] = "Ability_Warrior_Charge",
	["Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Berserker Stance Passive"] = "Ability_Racial_Avatar",
	["Berserker Stance"] = "Ability_Racial_Avatar",
	["Berserking"] = "Racial_Troll_Berserk",
	["Bestial Discipline"] = "Spell_Nature_AbolishMagic",
	["Bestial Swiftness"] = "Ability_Druid_Dash",
	["Bestial Wrath"] = "Ability_Druid_FerociousBite",
	["Biletoad Infection"] = "Spell_Holy_HarmUndeadAura",
	["Bite"] = "Ability_Racial_Cannibalize",
	["Black Arrow"] = "Ability_TheBlackArrow",
	["Blackout"] = "Spell_Shadow_GatherShadows",
	["Blacksmithing"] = "Trade_BlackSmithing",
	["Blade Flurry"] = "Ability_Warrior_PunishingBlow",
	["Blast Wave"] = "Spell_Holy_Excorcism_02",
	["Blaze"] = "Spell_Fire_Incinerate",
	["Blessed Recovery"] = "Spell_Holy_BlessedRecovery",
	["Blessing of Blackfathom"] = "Spell_Frost_FrostWard",
	["Blessing of Freedom"] = "Spell_Holy_SealOfValor",
	["Blessing of Kings"] = "Spell_Magic_MageArmor",
	["Blessing of Light"] = "Spell_Holy_PrayerOfHealing02",
	["Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Blessing of Protection"] = "Spell_Holy_SealOfProtection",
	["Blessing of Sacrifice"] = "Spell_Holy_SealOfSacrifice",
	["Blessing of Salvation"] = "Spell_Holy_SealOfSalvation",
	["Blessing of Sanctuary"] = "Spell_Nature_LightningShield",
	["Blessing of Shahram"] = "Spell_Holy_LayOnHands",
	["Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Blind"] = "Spell_Shadow_MindSteal",
	["Blinding Powder"] = "INV_Misc_Ammo_Gunpowder_02",
	["Blink"] = "Spell_Arcane_Blink",
	["Blizzard"] = "Spell_Frost_IceStorm",
	["Block"] = "Ability_Defend",
	["Blood Craze"] = "Spell_Shadow_SummonImp",
	["Blood Frenzy"] = "Ability_GhoulFrenzy",
	["Blood Funnel"] = "Spell_Shadow_LifeDrain",
	["Blood Fury"] = "Racial_Orc_BerserkerStrength",
	["Blood Leech"] = "Ability_Racial_Cannibalize",
	["Blood Pact"] = "Spell_Shadow_BloodBoil",
	["Blood Siphon"] = "Spell_Shadow_LifeDrain",
	["Blood Tap"] = "Ability_Racial_Cannibalize",
	["Bloodlust"] = "Spell_Nature_Bloodlust",
	["Bloodrage"] = "Ability_Racial_BloodRage",
	["Bloodthirst"] = "Spell_Nature_BloodLust",
	["Bomb"] = "Spell_Fire_SelfDestruct",
	["Booming Voice"] = "Spell_Nature_Purge",
	["Boulder"] = "INV_Stone_14",
	["Bow Specialization"] = "INV_Weapon_Bow_12",
	["Bows"] = "INV_Weapon_Bow_05",
	["Brain Wash"] = "Spell_Shadow_AntiMagicShell",
	["Bright Campfire"] = "Spell_Fire_Fire",
	["Brutal Impact"] = "Ability_Druid_Bash",
	["Burning Adrenaline"] = "INV_Gauntlets_03",
	["Burning Soul"] = "Spell_Fire_Fire",
	["Burning Wish"] = "Spell_Shadow_PsychicScream",
	["Butcher Drain"] = "Spell_Shadow_SiphonMana",
	["Call of Flame"] = "Spell_Fire_Immolation",
	["Call of the Grave"] = "Spell_Shadow_ChillTouch",
	["Call of Thunder"] = "Spell_Nature_CallStorm",
	["Call Pet"] = "Ability_Hunter_BeastCall",
	["Camouflage"] = "Ability_Stealth",
	["Cannibalize"] = "Ability_Racial_Cannibalize",
	["Cat Form"] = "Ability_Druid_CatForm",
	["Cataclysm"] = "Spell_Fire_WindsofWoe",
	["Cause Insanity"] = "Spell_Shadow_ShadowWordDominate",
	["Chain Bolt"] = "Spell_Nature_ChainLightning",
	["Chain Burn"] = "Spell_Shadow_ManaBurn",
	["Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Chained Bolt"] = "Spell_Nature_ChainLightning",
	["Chains of Ice"] = "Spell_Frost_ChainsOfIce",
	["Challenging Roar"] = "Ability_Druid_ChallangingRoar",
	["Challenging Shout"] = "Ability_BullRush",
	["Charge Rage Bonus Effect"] = "Ability_Warrior_Charge",
	["Charge Stun"] = "Spell_Frost_Stun",
	["Charge"] = "Ability_Warrior_Charge",
	["Cheap Shot"] = "Ability_CheapShot",
	["Chilled"] = "Spell_Frost_FrostArmor02",
	["Chilling Touch"] = "Spell_Frost_FrostArmor",
	["Chromatic Infusion"] = "Spell_Holy_MindVision",
	["Claw"] = "Ability_Druid_Rake",
	["Cleanse Nova"] = "Spell_Holy_HolyBolt",
	["Cleanse"] = "Spell_Holy_Renew",
	["Clearcasting"] = "Spell_Shadow_ManaBurn",
	["Cleave"] = "Ability_Warrior_Cleave",
	["Clever Traps"] = "Spell_Nature_TimeStop",
	["Closing"] = "Temp",
	["Cloth"] = "INV_Chest_Cloth_21",
	["Cobra Reflexes"] = "Spell_Nature_GuardianWard",
	["Cold Blood"] = "Spell_Ice_Lament",
	["Cold Snap"] = "Spell_Frost_WizardMark",
	["Combat Endurance"] = "Spell_Nature_AncestralGuardian",
	["Combustion"] = "Spell_Fire_SealOfFire",
	["Command"] = "Ability_Warrior_WarCry",
	["Commanding Shout"] = "Spell_Magic_Magearmor",
	["Concentration Aura"] = "Spell_Holy_MindSooth",
	["Concussion Blow"] = "Ability_ThunderBolt",
	["Concussion"] = "Spell_Fire_Fireball",
	["Concussive Shot"] = "Spell_Frost_Stun",
	["Cone of Cold"] = "Spell_Frost_Glacier",
	["Conflagrate"] = "Spell_Fire_Fireball",
	["Conjure Food"] = "INV_Misc_Food_10",
	["Conjure Mana Agate"] = "INV_Misc_Gem_Emerald_01",
	["Conjure Mana Citrine"] = "INV_Misc_Gem_Opal_01",
	["Conjure Mana Jade"] = "INV_Misc_Gem_Emerald_02",
	["Conjure Mana Ruby"] = "INV_Misc_Gem_Ruby_01",
	["Conjure Water"] = "INV_Drink_06",
	["Consecration"] = "Spell_Holy_InnerFire",
	["Consume Shadows"] = "Spell_Shadow_AntiShadow",
	["Consuming Shadows"] = "Spell_Shadow_Haunting",
	["Convection"] = "Spell_Nature_WispSplode",
	["Conviction"] = "Spell_Holy_RetributionAura",
	["Cooking"] = "INV_Misc_Food_15",
	["Corrosive Acid Breath"] = "Spell_Nature_Acid_01",
	["Corrosive Ooze"] = "Spell_Shadow_AnimateDead",
	["Corrosive Poison"] = "Spell_Nature_CorrosiveBreath",
	["Corrupted Blood"] = "Spell_Shadow_CorpseExplode",
	["Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Counterattack"] = "Ability_Warrior_Challange",
	["Counterspell - Silenced"] = "Spell_Frost_IceShock",
	["Counterspell"] = "Spell_Frost_IceShock",
	["Cower"] = "Ability_Druid_Cower",
	["Create Firestone (Greater)"] = "INV_Ammo_FireTar",
	["Create Firestone (Lesser)"] = "INV_Ammo_FireTar",
	["Create Firestone (Major)"] = "INV_Ammo_FireTar",
	["Create Firestone"] = "INV_Ammo_FireTar",
	["Create Healthstone (Greater)"] = "INV_Stone_04",
	["Create Healthstone (Lesser)"] = "INV_Stone_04",
	["Create Healthstone (Major)"] = "INV_Stone_04",
	["Create Healthstone (Minor)"] = "INV_Stone_04",
	["Create Healthstone"] = "INV_Stone_04",
	["Create Soulstone (Greater)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Lesser)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Major)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Minor)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone"] = "Spell_Shadow_SoulGem",
	["Create Spellstone (Greater)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Creeper Venom"] = "Spell_Nature_NullifyPoison",
	["Cripple"] = "Spell_Shadow_Cripple",
	["Crippling Poison II"] = "Ability_PoisonSting",
	["Crippling Poison"] = "Ability_PoisonSting",
	["Critical Mass"] = "Spell_Nature_WispHeal",
	["Crossbows"] = "INV_Weapon_Crossbow_01",
	["Crowd Pummel"] = "INV_Gauntlets_04",
	["Cruelty"] = "Ability_Rogue_Eviscerate",
	["Crusader Strike"] = "Spell_Holy_HolySmite",
	["Crusader's Wrath"] = "Spell_Nature_GroundingTotem",
	["Crystal Charge"] = "INV_Misc_Gem_Opal_01",
	["Crystal Force"] = "INV_Misc_Gem_Crystal_02",
	["Crystal Restore"] = "INV_Misc_Gem_Diamond_02",
	["Crystal Spire"] = "INV_Misc_Gem_Stone_01",
	["Crystal Ward"] = "INV_Misc_Gem_Ruby_02",
	["Crystal Yield"] = "INV_Misc_Gem_Amethyst_01",
	["Crystalline Slumber"] = "Spell_Nature_Sleep",
	["Cultivation"] = "INV_Misc_Flower_01",
	["Cure Disease"] = "Spell_Holy_NullifyDisease",
	["Cure Poison"] = "Spell_Nature_NullifyPoison",
	["Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Curse of Blood"] = "Spell_Shadow_RitualOfSacrifice",
	["Curse of Doom Effect"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Doom"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Curse of Idiocy"] = "Spell_Shadow_MindRot",
	["Curse of Recklessness"] = "Spell_Shadow_UnholyStrength",
	["Curse of Shadow"] = "Spell_Shadow_CurseOfAchimonde",
	["Curse of the Deadwood"] = "Spell_Shadow_GatherShadows",
	["Curse of the Elemental Lord"] = "Spell_Fire_LavaSpawn",
	["Curse of the Elements"] = "Spell_Shadow_ChillTouch",
	["Curse of Tongues"] = "Spell_Shadow_CurseOfTounges",
	["Curse of Tuten'kash"] = "Spell_Nature_Drowsy",
	["Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Cursed Blood"] = "Spell_Nature_Drowsy",
	["Cyclone"] = "Spell_Nature_Cyclone",
	["Dagger Specialization"] = "INV_Weapon_ShortBlade_05",
	["Daggers"] = "Ability_SteelMelee",
	["Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Dark Iron Bomb"] = "Spell_Fire_SelfDestruct",
	["Dark Offering"] = "Spell_Shadow_Haunting",
	["Dark Pact"] = "Spell_Shadow_DarkRitual",
	["Darkness"] = "Spell_Shadow_Twilight",
	["Dash"] = "Ability_Druid_Dash",
	["Dazed"] = "Spell_Frost_Stun",
	["Deadly Poison II"] = "Ability_Rogue_DualWeild",
	["Deadly Poison III"] = "Ability_Rogue_DualWeild",
	["Deadly Poison IV"] = "Ability_Rogue_DualWeild",
	["Deadly Poison V"] = "Ability_Rogue_DualWeild",
	["Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Death Coil"] = "Spell_Shadow_DeathCoil",
	["Death Wish"] = "Spell_Shadow_DeathPact",
	["Deep Sleep"] = "Spell_Nature_Sleep",
	["Deep Slumber"] = "Spell_Shadow_Cripple",
	["Deep Wounds"] = "Ability_BackStab",
	["Defense"] = "Ability_Racial_ShadowMeld",
	["Defensive Stance Passive"] = "Ability_Warrior_DefensiveStance",
	["Defensive Stance"] = "Ability_Warrior_DefensiveStance",
	["Defensive State 2"] = "Ability_Defend",
	["Defensive State"] = "Ability_Defend",
	["Defiance"] = "Ability_Warrior_InnerRage",
	["Deflection"] = "Ability_Parry",
	["Delusions of Jin'do"] = "Spell_Shadow_UnholyFrenzy",
	["Demon Armor"] = "Spell_Shadow_RagingScream",
	["Demon Skin"] = "Spell_Shadow_RagingScream",
	["Demonic Embrace"] = "Spell_Shadow_Metamorphosis",
	["Demonic Frenzy"] = "Spell_Shadow_Metamorphosis",
	["Demonic Sacrifice"] = "Spell_Shadow_PsychicScream",
	["Demoralizing Roar"] = "Ability_Druid_DemoralizingRoar",
	["Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Desperate Prayer"] = "Spell_Holy_Restoration",
	["Destructive Reach"] = "Spell_Shadow_CorpseExplode",
	["Detect Greater Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Lesser Invisibility"] = "Spell_Shadow_DetectLesserInvisibility",
	["Detect Magic"] = "Spell_Holy_Dizzy",
	["Detect Traps"] = "Ability_Spy",
	["Detect"] = "Ability_Hibernation",
	["Deterrence"] = "Ability_Whirlwind",
	["Detonation"] = "Spell_Fire_Fire",
	["Devastate"] = "INV_Sword_11",
	["Devastation"] = "Spell_Fire_FlameShock",
	["Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Devour Magic Effect"] = "Spell_Nature_Purge",
	["Devour Magic"] = "Spell_Nature_Purge",
	["Devouring Plague"] = "Spell_Shadow_BlackPlague",
	["Diamond Flask"] = "INV_Drink_01",
	["Diplomacy"] = "INV_Misc_Note_02",
	["Dire Bear Form"] = "Ability_Racial_BearForm",
	["Dire Growl"] = "Ability_Racial_Cannibalize",
	["Disarm Trap"] = "Spell_Shadow_GrimWard",
	["Disarm"] = "Ability_Warrior_Disarm",
	["Disease Cleansing Totem"] = "Spell_Nature_DiseaseCleansingTotem",
	["Disease Cloud"] = "Spell_Nature_AbolishMagic",
	["Diseased Shot"] = "Spell_Shadow_CallofBone",
	["Diseased Spit"] = "Spell_Shadow_CreepingPlague",
	["Disenchant"] = "Spell_Holy_RemoveCurse",
	["Disengage"] = "Ability_Rogue_Feint",
	["Disjunction"] = "Spell_Lightning_LightningBolt01",
	["Dismiss Pet"] = "Spell_Nature_SpiritWolf",
	["Dispel Magic"] = "Spell_Holy_DispelMagic",
	["Distract"] = "Ability_Rogue_Distract",
	["Distracting Pain"] = "Ability_Racial_Cannibalize",
	["Distracting Shot"] = "Spell_Arcane_Blink",
	["Dive"] = "Spell_Shadow_BurningSpirit",
	["Divine Favor"] = "Spell_Holy_Heal",
	["Divine Fury"] = "Spell_Holy_SealOfWrath",
	["Divine Intellect"] = "Spell_Nature_Sleep",
	["Divine Intervention"] = "Spell_Nature_TimeStop",
	["Divine Protection"] = "Spell_Holy_Restoration",
	["Divine Shield"] = "Spell_Holy_DivineIntervention",
	["Divine Spirit"] = "Spell_Holy_DivineSpirit",
	["Divine Strength"] = "Ability_GolemThunderClap",
	["Diving Sweep"] = "Ability_Warrior_Cleave",
	["Dodge"] = "Spell_Nature_Invisibilty",
	["Dominate Mind"] = "Spell_Shadow_ShadowWordDominate",
	["Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Drain Soul"] = "Spell_Shadow_Haunting",
	["Dredge Sickness"] = "Spell_Nature_NullifyDisease",
	["Druid's Slumber"] = "Spell_Nature_Sleep",
	["Dual Wield Specialization"] = "Ability_DualWield",
	["Dual Wield"] = "Ability_DualWield",
	["Duel"] = "Temp",
	["Dust Field"] = "Spell_Nature_Cyclone",
	["Eagle Eye"] = "Ability_Hunter_EagleEye",
	["Earth Shock"] = "Spell_Nature_EarthShock",
	["Earthbind Totem"] = "Spell_Nature_StrengthOfEarthTotem02",
	["Earthborer Acid"] = "Spell_Nature_Acid_01",
	["Earthgrab"] = "Spell_Nature_NatureTouchDecay",
	["Efficiency"] = "Spell_Frost_WizardMark",
	["Electric Discharge"] = "Spell_Lightning_LightningBolt01",
	["Electrified Net"] = "Ability_Ensnare",
	["Elemental Focus"] = "Spell_Shadow_ManaBurn",
	["Elemental Fury"] = "Spell_Fire_Volcano",
	["Elemental Mastery"] = "Spell_Nature_WispHeal",
	["Elemental Precision"] = "Spell_Ice_MagicDamage",
	["Elune's Grace"] = "Spell_Holy_ElunesGrace",
	["Elusiveness"] = "Spell_Magic_LesserInvisibilty",
	["Emberstorm"] = "Spell_Fire_SelfDestruct",
	["Enchanting"] = "Trade_Engraving",
	["Endurance Training"] = "Spell_Nature_Reincarnation",
	["Endurance"] = "Spell_Nature_UnyeildingStamina",
	["Engineering Specialization"] = "INV_Misc_Gear_01",
	["Engineering"] = "Trade_Engineering",
	["Enrage"] = "Ability_Druid_Enrage",
	["Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Entrapment"] = "Spell_Nature_StrangleVines",
	["Enveloping Web"] = "Spell_Nature_EarthBind",
	["Enveloping Webs"] = "Spell_Nature_EarthBind",
	["Enveloping Winds"] = "Spell_Nature_Cyclone",
	["Ephemeral Power"] = "Spell_Holy_MindVision",
	["Escape Artist"] = "Ability_Rogue_Trip",
	["Essence of Sapphiron"] = "INV_Trinket_Naxxramas06",
	["Evasion"] = "Spell_Shadow_ShadowWard",
	["Eventide"] = "Spell_Frost_Stun",
	["Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Evocation"] = "Spell_Nature_Purge",
	["Execute"] = "INV_Sword_48",
	["Exorcism"] = "Spell_Holy_Excorcism_02",
	["Expansive Mind"] = "INV_Enchant_EssenceEternalLarge",
	["Exploding Shot"] = "Spell_Fire_Fireball02",
	["Exploit Weakness"] = "Ability_BackStab",
	["Explosive Shot"] = "Spell_Fire_Fireball02",
	["Explosive Trap Effect"] = "Spell_Fire_SelfDestruct",
	["Explosive Trap"] = "Spell_Fire_SelfDestruct",
	["Expose Armor"] = "Ability_Warrior_Riposte",
	["Expose Weakness"] = "Ability_CriticalStrike",
	["Eye for an Eye"] = "Spell_Holy_EyeforanEye",
	["Eye of Kilrogg"] = "Spell_Shadow_EvilEye",
	["Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Fade"] = "Spell_Magic_LesserInvisibilty",
	["Faerie Fire (Feral)"] = "Spell_Nature_FaerieFire",
	["Faerie Fire"] = "Spell_Nature_FaerieFire",
	["Far Sight"] = "Spell_Nature_FarSight",
	["Fatal Bite"] = "Ability_BackStab",
	["Fear Ward"] = "Spell_Holy_Excorcism",
	["Fear"] = "Spell_Shadow_Possession",
	["Feed Pet"] = "Ability_Hunter_BeastTraining",
	["Feedback"] = "Spell_Shadow_RitualOfSacrifice",
	["Feign Death"] = "Ability_Rogue_FeignDeath",
	["Feint"] = "Ability_Rogue_Feint",
	["Fel Concentration"] = "Spell_Shadow_FingerOfDeath",
	["Fel Domination"] = "Spell_Nature_RemoveCurse",
	["Fel Intellect"] = "Spell_Holy_MagicalSentry",
	["Fel Stamina"] = "Spell_Shadow_AntiShadow",
	["Fel Stomp"] = "Ability_WarStomp",
	["Felfire"] = "Spell_Fire_Fireball",
	["Feline Grace"] = "INV_Feather_01",
	["Feline Swiftness"] = "Spell_Nature_SpiritWolf",
	["Feral Aggression"] = "Ability_Druid_DemoralizingRoar",
	["Feral Charge"] = "Ability_Hunter_Pet_Bear",
	["Feral Instinct"] = "Ability_Ambush",
	["Ferocious Bite"] = "Ability_Druid_FerociousBite",
	["Ferocity"] = "INV_Misc_MonsterClaw_04",
	["Fetish"] = "INV_Misc_Horn_01",
	["Fevered Plague"] = "Spell_Nature_NullifyDisease",
	["Fiery Burst"] = "Spell_Fire_FireBolt",
	["Find Herbs"] = "INV_Misc_Flower_02",
	["Find Minerals"] = "Spell_Nature_Earthquake",
	["Find Treasure"] = "Racial_Dwarf_FindTreasure",
	["Fire Blast"] = "Spell_Fire_Fireball",
	["Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Fire Nova"] = "Spell_Fire_SealOfFire",
	["Fire Power"] = "Spell_Fire_Immolation",
	["Fire Resistance Aura"] = "Spell_Fire_SealOfFire",
	["Fire Resistance Totem"] = "Spell_FireResistanceTotem_01",
	["Fire Resistance"] = "Spell_Fire_FireArmor",
	["Fire Shield Effect II"] = "Spell_Fire_Immolation",
	["Fire Shield Effect III"] = "Spell_Fire_Immolation",
	["Fire Shield Effect IV"] = "Spell_Fire_Immolation",
	["Fire Shield Effect"] = "Spell_Fire_Immolation",
	["Fire Shield"] = "Spell_Fire_FireArmor",
	["Fire Storm"] = "Spell_Fire_SelfDestruct",
	["Fire Vulnerability"] = "Spell_Fire_SoulBurn",
	["Fire Ward"] = "Spell_Fire_FireArmor",
	["Fire Weakness"] = "INV_Misc_QirajiCrystal_02",
	["Fireball Volley"] = "Spell_Fire_FlameBolt",
	["Fireball"] = "Spell_Fire_FlameBolt",
	["Firebolt"] = "Spell_Fire_FireBolt",
	["First Aid"] = "Spell_Holy_SealOfSacrifice",
	["Fishing Poles"] = "Trade_Fishing",
	["Fishing"] = "Trade_Fishing",
	["Fist of Ragnaros"] = "Spell_Holy_SealOfWrath",
	["Fist Weapon Specialization"] = "INV_Gauntlets_04",
	["Fist Weapons"] = "INV_Gauntlets_04",
	["Flame Buffet"] = "Spell_Fire_Fireball",
	["Flame Cannon"] = "Spell_Fire_FlameBolt",
	["Flame Lash"] = "Spell_Fire_Fireball",
	["Flame Shock"] = "Spell_Fire_FlameShock",
	["Flame Spike"] = "Spell_Fire_SelfDestruct",
	["Flame Spray"] = "Spell_Fire_Fire",
	["Flame Throwing"] = "Spell_Fire_Flare",
	["Flames of Shahram"] = "Spell_Fire_SelfDestruct",
	["Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Flamethrower"] = "Spell_Fire_Incinerate",
	["Flametongue Totem"] = "Spell_Nature_GuardianWard",
	["Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Flare"] = "Spell_Fire_Flare",
	["Flash Bomb"] = "Spell_Shadow_DarkSummoning",
	["Flash Heal"] = "Spell_Holy_FlashHeal",
	["Flash of Light"] = "Spell_Holy_FlashHeal",
	["Flurry"] = "Ability_GhoulFrenzy",
	["Focused Casting"] = "Spell_Arcane_Blink",
	["Focused Mind"] = "Spell_Nature_MirrorImage",
	["Forbearance"] = "Spell_Holy_RemoveCurse",
	["Force of Nature"] = "Spell_Nature_ForceOfNature",
	["Force of Will"] = "Spell_Nature_SlowingTotem",
	["Force Punch"] = "INV_Gauntlets_31",
	["Force Reactive Disk"] = "Spell_Lightning_LightningBolt01",
	["Forked Lightning"] = "Spell_Nature_ChainLightning",
	["Forsaken Skills"] = "Spell_Shadow_AntiShadow",
	["Frailty"] = "Spell_Shadow_AnimateDead",
	["Freeze Solid"] = "Spell_Fost_Glacier",
	["Freezing Trap"] = "Spell_Frost_ChainsOfIce",
	["Frenzied Regeneration"] = "Ability_BullRush",
	["Frenzy"] = "INV_Misc_MonsterClaw_03",
	["Frost Armor"] = "Spell_Frost_FrostArmor02",
	["Frost Breath"] = "Spell_Frost_FrostNova",
	["Frost Channeling"] = "Spell_Frost_Stun",
	["Frost Nova"] = "Spell_Frost_FrostNova",
	["Frost Resistance Aura"] = "Spell_Frost_WizardMark",
	["Frost Resistance Totem"] = "Spell_FrostResistanceTotem_01",
	["Frost Resistance"] = "Spell_Frost_FrostWard",
	["Frost Shock"] = "Spell_Frost_FrostShock",
	["Frost Shot"] = "Spell_Ice_MagicDamage",
	["Frost Trap Aura"] = "Spell_Frost_FreezingBreath",
	["Frost Trap"] = "Spell_Frost_FreezingBreath",
	["Frost Ward"] = "Spell_Frost_FrostWard",
	["Frost Warding"] = "Spell_Frost_FrostWard",
	["Frost Weakness"] = "INV_Misc_QirajiCrystal_04",
	["Frostbite"] = "Spell_Frost_FrostArmor",
	["Frostbolt Volley"] = "Spell_Frost_FrostBolt02",
	["Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Furious Howl"] = "Ability_Hunter_Pet_Wolf",
	["Furor"] = "Spell_Holy_BlessingOfStamina",
	["Fury of Ragnaros"] = "Spell_holy_MindSooth",
	["Gahz'ranka Slam"] = "Ability_Devour",
	["Gahz'rilla Slam"] = "Ability_Devour",
	["Garrote"] = "Ability_Rogue_Garrote",
	["Gehennas' Curse"] = "Spell_Shadow_GatherShadows",
	["Generic"] = "INV_Shield_09",
	["Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Ghostly Strike"] = "Spell_Shadow_Curse",
	["Gift of Life"] = "INV_Misc_Gem_Pearl_05",
	["Gift of Nature"] = "Spell_Nature_ProtectionformNature",
	["Gift of the Wild"] = "Spell_Nature_Regeneration",
	["Goblin Dragon Gun"] = "Spell_Fire_Incinerate",
	["Goblin Sapper Charge"] = "Spell_Fire_SelfDestruct",
	["Gouge"] = "Ability_Gouge",
	["Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Grasping Vines"] = "Spell_Nature_StrangleVines",
	["Great Stamina"] = "Spell_Nature_UnyeildingStamina",
	["Greater Blessing of Kings"] = "Spell_Magic_GreaterBlessingofKings",
	["Greater Blessing of Light"] = "Spell_Holy_GreaterBlessingofLight",
	["Greater Blessing of Might"] = "Spell_Holy_GreaterBlessingofKings",
	["Greater Blessing of Salvation"] = "Spell_Holy_GreaterBlessingofSalvation",
	["Greater Blessing of Sanctuary"] = "Spell_Holy_GreaterBlessingofSanctuary",
	["Greater Blessing of Wisdom"] = "Spell_Holy_GreaterBlessingofWisdom",
	["Greater Heal"] = "Spell_Holy_GreaterHeal",
	["Grim Reach"] = "Spell_Shadow_CallofBone",
	["Ground Tremor"] = "Spell_Nature_Earthquake",
	["Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Grovel"] = "Temp",
	["Growl"] = "Ability_Physical_Taunt",
	["Guardian's Favor"] = "Spell_Holy_SealOfProtection",
	["Guillotine"] = "Ability_Warrior_PunishingBlow",
	["Gun Specialization"] = "INV_Musket_03",
	["Guns"] = "INV_Weapon_Rifle_01",
	["Hail Storm"] = "Spell_Frost_FrostBolt02",
	["Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Hammer of Wrath"] = "Ability_ThunderClap",
	["Hamstring"] = "Ability_ShockWave",
	["Harass"] = "Ability_Hunter_Harass",
	["Hardiness"] = "INV_Helmet_23",
	["Haunting Spirits"] = "Spell_Shadow_BlackPlague",
	["Hawk Eye"] = "Ability_TownWatch",
	["Head Crack"] = "Ability_ThunderBolt",
	["Heal"] = "Spell_Holy_Heal",
	["Healing Circle"] = "Spell_Holy_PrayerOfHealing02",
	["Healing Focus"] = "Spell_Holy_HealingFocus",
	["Healing Light"] = "Spell_Holy_HolyBolt",
	["Healing of the Ages"] = "Spell_Nature_HealingWaveGreater",
	["Healing Stream Totem"] = "INV_Spear_04",
	["Healing Touch"] = "Spell_Nature_HealingTouch",
	["Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Healing Way"] = "Spell_Nature_Healingway",
	["Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Heart of the Wild"] = "Spell_Holy_BlessingOfAgility",
	["Hellfire Effect"] = "Spell_Fire_Incinerate",
	["Hellfire"] = "Spell_Fire_Incinerate",
	["Hemorrhage"] = "Spell_Shadow_LifeDrain",
	["Herbalism"] = "Spell_Nature_NatureTouchGrow",
	["Heroic Strike"] = "Ability_Rogue_Ambush",
	["Heroism"] = "Spell_Holy_Renew",
	["Hex of Jammal'an"] = "Spell_Shadow_AntiShadow",
	["Hex of Weakness"] = "Spell_Shadow_FingerOfDeath",
	["Hex"] = "Spell_Nature_Polymorph",
	["Hibernate"] = "Spell_Nature_Sleep",
	["Holy Fire"] = "Spell_Holy_SearingLight",
	["Holy Light"] = "Spell_Holy_HolyBolt",
	["Holy Nova"] = "Spell_Holy_HolyNova",
	["Holy Power"] = "Spell_Holy_Power",
	["Holy Reach"] = "Spell_Holy_Purify",
	["Holy Shield"] = "Spell_Holy_BlessingOfProtection",
	["Holy Shock"] = "Spell_Holy_SearingLight",
	["Holy Smite"] = "Spell_Holy_HolySmite",
	["Holy Specialization"] = "Spell_Holy_SealOfSalvation",
	["Holy Strength"] = "Spell_Holy_BlessingOfStrength",
	["Holy Strike"] = "Ability_ThunderBolt",
	["Holy Wrath"] = "Spell_Holy_Excorcism",
	["Honorless Target"] = "Spell_Magic_LesserInvisibilty",
	["Hooked Net"] = "Ability_Ensnare",
	["Horse Riding"] = "Spell_Nature_Swiftness",
	["Howl of Terror"] = "Spell_Shadow_DeathScream",
	["Humanoid Slaying"] = "Spell_Holy_PrayerOfHealing",
	["Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Hurricane"] = "Spell_Nature_Cyclone",
	["Ice Armor"] = "Spell_Frost_FrostArmor02",
	["Ice Barrier"] = "Spell_Ice_Lament",
	["Ice Blast"] = "Spell_Frost_FrostNova",
	["Ice Block"] = "Spell_Frost_Frost",
	["Ice Nova"] = "Spell_Frost_FrostNova",
	["Ice Shards"] = "Spell_Frost_IceShard",
	["Icicle"] = "Spell_Frost_FrostBolt02",
	["Ignite"] = "Spell_Fire_Incinerate",
	["Illumination"] = "Spell_Holy_GreaterHeal",
	["Immolate"] = "Spell_Fire_Immolation",
	["Immolation Trap Effect"] = "Spell_Fire_FlameShock",
	["Immolation Trap"] = "Spell_Fire_FlameShock",
	["Impact"] = "Spell_Fire_MeteorStorm",
	["Impale"] = "Ability_Gouge",
	["Improved Ambush"] = "Ability_Rogue_Ambush",
	["Improved Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Improved Arcane Missiles"] = "Spell_Nature_StarFall",
	["Improved Arcane Shot"] = "Ability_ImpalingBolt",
	["Improved Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Improved Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Improved Backstab"] = "Ability_BackStab",
	["Improved Battle Shout"] = "Ability_Warrior_BattleShout",
	["Improved Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Improved Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Improved Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Improved Blizzard"] = "Spell_Frost_IceStorm",
	["Improved Bloodrage"] = "Ability_Racial_BloodRage",
	["Improved Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Improved Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Improved Challenging Shout"] = "Ability_Warrior_Challange",
	["Improved Charge"] = "Ability_Warrior_Charge",
	["Improved Cheap Shot"] = "Ability_CheapShot",
	["Improved Cleave"] = "Ability_Warrior_Cleave",
	["Improved Concentration Aura"] = "Spell_Holy_MindSooth",
	["Improved Concussive Shot"] = "Spell_Frost_Stun",
	["Improved Cone of Cold"] = "Spell_Frost_Glacier",
	["Improved Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Improved Counterspell"] = "Spell_Frost_IceShock",
	["Improved Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Improved Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Improved Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Improved Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Improved Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Improved Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Improved Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Improved Disarm"] = "Ability_Warrior_Disarm",
	["Improved Distract"] = "Ability_Rogue_Distract",
	["Improved Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Improved Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Improved Drain Soul"] = "Spell_Shadow_Haunting",
	["Improved Enrage"] = "Ability_Druid_Enrage",
	["Improved Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Improved Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Improved Evasion"] = "Spell_Shadow_ShadowWard",
	["Improved Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Improved Execute"] = "INV_Sword_48",
	["Improved Expose Armor"] = "Ability_Warrior_Riposte",
	["Improved Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Improved Fade"] = "Spell_Magic_LesserInvisibilty",
	["Improved Feign Death"] = "Ability_Rogue_FeignDeath",
	["Improved Fire Blast"] = "Spell_Fire_Fireball",
	["Improved Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Improved Fire Ward"] = "Spell_Fire_FireArmor",
	["Improved Fireball"] = "Spell_Fire_FlameBolt",
	["Improved Firebolt"] = "Spell_Fire_FireBolt",
	["Improved Firestone"] = "INV_Ammo_FireTar",
	["Improved Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Improved Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Improved Flash of Light"] = "Spell_Holy_FlashHeal",
	["Improved Frost Nova"] = "Spell_Frost_FreezingBreath",
	["Improved Frost Ward"] = "Spell_Frost_FrostWard",
	["Improved Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Improved Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Improved Garrote"] = "Ability_Rogue_Garrote",
	["Improved Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Improved Gouge"] = "Ability_Gouge",
	["Improved Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Improved Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Improved Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Improved Hamstring"] = "Ability_ShockWave",
	["Improved Healing Stream Totem"] = "INV_Spear_04",
	["Improved Healing Touch"] = "Spell_Nature_HealingTouch",
	["Improved Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Improved Healing"] = "Spell_Holy_Heal02",
	["Improved Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Improved Healthstone"] = "INV_Stone_04",
	["Improved Heroic Strike"] = "Ability_Rogue_Ambush",
	["Improved Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Improved Immolate"] = "Spell_Fire_Immolation",
	["Improved Imp"] = "Spell_Shadow_SummonImp",
	["Improved Inner Fire"] = "Spell_Holy_InnerFire",
	["Improved Instant Poison"] = "Ability_Poisons",
	["Improved Intercept"] = "Ability_Rogue_Sprint",
	["Improved Intimidating Shout"] = "Ability_GolemThunderClap",
	["Improved Judgement"] = "Spell_Holy_RighteousFury",
	["Improved Kick"] = "Ability_Kick",
	["Improved Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Improved Lash of Pain"] = "Spell_Shadow_Curse",
	["Improved Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Improved Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Improved Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Improved Lightning Bolt"] = "Spell_Nature_Lightning",
	["Improved Lightning Shield"] = "Spell_Nature_LightningShield",
	["Improved Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Improved Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Improved Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Improved Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Improved Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Improved Mend Pet"] = "Ability_Hunter_MendPet",
	["Improved Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Improved Moonfire"] = "Spell_Nature_StarFall",
	["Improved Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Improved Overpower"] = "INV_Sword_05",
	["Improved Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Improved Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Improved Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Improved Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Improved Pummel"] = "INV_Gauntlets_04",
	["Improved Regrowth"] = "Spell_Nature_ResistNature",
	["Improved Reincarnation"] = "Spell_Nature_Reincarnation",
	["Improved Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Improved Rend"] = "Ability_Gouge",
	["Improved Renew"] = "Spell_Holy_Renew",
	["Improved Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Improved Revenge"] = "Ability_Warrior_Revenge",
	["Improved Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Improved Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Improved Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Improved Rupture"] = "Ability_Rogue_Rupture",
	["Improved Sap"] = "Ability_Sap",
	["Improved Scorch"] = "Spell_Fire_SoulBurn",
	["Improved Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Improved Seal of Righteousness"] = "Ability_ThunderBolt",
	["Improved Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Improved Searing Pain"] = "Spell_Fire_SoulBurn",
	["Improved Searing Totem"] = "Spell_Fire_SearingTotem",
	["Improved Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Improved Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Improved Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Improved Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Improved Shield Block"] = "Ability_Defend",
	["Improved Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Improved Shred"] = "Spell_Shadow_VampiricAura",
	["Improved Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Improved Slam"] = "Ability_Warrior_DecisiveStrike",
	["Improved Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Improved Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Improved Sprint"] = "Ability_Rogue_Sprint",
	["Improved Starfire"] = "Spell_Arcane_StarFire",
	["Improved Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Improved Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Improved Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Improved Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Improved Sunder Armor"] = "Ability_Warrior_Sunder",
	["Improved Taunt"] = "Spell_Nature_Reincarnation",
	["Improved Thorns"] = "Spell_Nature_Thorns",
	["Improved Thunder Clap"] = "Ability_ThunderClap",
	["Improved Tranquility"] = "Spell_Nature_Tranquility",
	["Improved Vampiric Embrace"] = "Spell_Shadow_ImprovedVampiricEmbrace",
	["Improved Vanish"] = "Ability_Vanish",
	["Improved Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Improved Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Improved Wing Clip"] = "Ability_Rogue_Trip",
	["Improved Wrath"] = "Spell_Nature_AbolishMagic",
	["Incinerate"] = "Spell_Fire_FlameShock",
	["Infected Bite"] = "Spell_Shadow_CallofBone",
	["Infected Wound"] = "Spell_Nature_NullifyDisease",
	["Inferno Shell"] = "Spell_Fire_SelfDestruct",
	["Inferno"] = "Spell_Shadow_SummonInfernal",
	["Initiative"] = "Spell_Shadow_Fumble",
	["Inner Fire"] = "Spell_Holy_InnerFire",
	["Inner Focus"] = "Spell_Frost_WindWalkOn",
	["Innervate"] = "Spell_Nature_Lightning",
	["Insect Swarm"] = "Spell_Nature_InsectSwarm",
	["Inspiration"] = "Spell_Holy_LayOnHands",
	["Instant Poison II"] = "Ability_Poisons",
	["Instant Poison III"] = "Ability_Poisons",
	["Instant Poison IV"] = "Ability_Poisons",
	["Instant Poison V"] = "Ability_Poisons",
	["Instant Poison VI"] = "Ability_Poisons",
	["Instant Poison"] = "Ability_Poisons",
	["Intensity"] = "Spell_Fire_LavaSpawn",
	["Intercept Stun"] = "Spell_Frost_Stun",
	["Intercept"] = "Ability_Rogue_Sprint",
	["Intimidating Roar"] = "Ability_GolemThunderClap",
	["Intimidating Shout"] = "Ability_GolemThunderClap",
	["Intimidation"] = "Ability_Devour",
	["Intoxicating Venom"] = "Ability_Creature_Poison_01",
	["Iron Will"] = "Spell_Magic_MageArmor",
	["Iron Will"] = "Spell_Magic_MageArmor",                                              -- INCORRECT! Needs path updated!!! Preferably before expansion.
	["Judgement of Command"] = "Ability_Warrior_InnerRage",
	["Judgement of Justice"] = "Spell_Holy_SealOfWrath",
	["Judgement of Light"] = "Spell_Holy_HealingAura",
	["Judgement of Righteousness"] = "Ability_ThunderBolt",
	["Judgement of the Crusader"] = "Spell_Holy_HolySmite",
	["Judgement of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Judgement"] = "Spell_Holy_RighteousFury",
	["Kick - Silenced"] = "Ability_Kick",
	["Kick"] = "Ability_Kick",
	["Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Killer Instinct"] = "Spell_Holy_BlessingOfStamina",
	["Knock Away"] = "INV_Gauntlets_05",
	["Knockdown"] = "Ability_GolemThunderClap",
	["Kodo Riding"] = "Spell_Nature_Swiftness",
	["Lacerate"] = "Spell_Shadow_VampiricAura",
	["Larva Goo"] = "Ability_Creature_Poison_02",
	["Lash of Pain"] = "Spell_Shadow_Curse",
	["Lash"] = "Ability_CriticalStrike",
	["Last Stand"] = "Spell_Holy_AshesToAshes",
	["Lasting Judgement"] = "Spell_Holy_HealingAura",
	["Lava Spout Totem"] = "Spell_Fire_SelfDestruct",
	["Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Leader of the Pack"] = "Spell_Nature_UnyeildingStamina",
	["Leather"] = "INV_Chest_Leather_09",
	["Leatherworking"] = "INV_Misc_ArmorKit_17",
	["Leech Poison"] = "Spell_Nature_NullifyPoison",
	["Lesser Heal"] = "Spell_Holy_LesserHeal",
	["Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Lesser Invisibility"] = "Spell_Magic_LesserInvisibilty",
	["Lethal Shots"] = "Ability_SearingArrow",
	["Lethality"] = "Ability_CriticalStrike",
	["Levitate"] = "Spell_Holy_LayOnHands",
	["Libram"] = "INV_Misc_Book_11",
	["Lich Slap"] = "Spell_Shadow_ChillTouch",
	["Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Lifegiving Gem"] = "INV_Misc_Gem_Pearl_05",
	["Lightning Blast"] = "Spell_Nature_Lightning",
	["Lightning Bolt"] = "Spell_Nature_Lightning",
	["Lightning Breath"] = "Spell_Nature_Lightning",
	["Lightning Cloud"] = "Spell_Nature_CallStorm",
	["Lightning Mastery"] = "Spell_Lightning_LightningBolt01",
	["Lightning Reflexes"] = "Spell_Nature_Invisibilty",
	["Lightning Shield"] = "Spell_Nature_LightningShield",
	["Lightning Wave"] = "Spell_Nature_ChainLightning",
	["Lightwell Renew"] = "Spell_Holy_SummonLightwell",
	["Lightwell"] = "Spell_Holy_SummonLightwell",
	["Lizard Bolt"] = "Spell_Nature_Lightning",
	["Localized Toxin"] = "Spell_Nature_CorrosiveBreath",
	["Long Daze"] = "Spell_Frost_Stun",
	["Mace Specialization"] = "INV_Mace_01",
	["Mace Stun Effect"] = "Spell_Frost_Stun",
	["Machine Gun"] = "Ability_Marksmanship",
	["Mage Armor"] = "Spell_MageArmor",
	["Magic Attunement"] = "Spell_Nature_AbolishMagic",
	["Magma Splash"] = "Spell_Fire_Immolation",
	["Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Mail"] = "INV_Chest_Chain_05",
	["Malice"] = "Ability_Racial_BloodRage",
	["Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Mana Feed"] = "Spell_Shadow_DarkRitual",
	["Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Mana Tide Totem"] = "Spell_Frost_SummonWaterElemental",
	["Mangle"] = "Ability_Druid_Mangle.tga",
	["Mark of Arlokk"] = "Ability_Hunter_SniperShot",
	["Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Martyrdom"] = "Spell_Nature_Tranquility",
	["Mass Dispel"] = "Spell_Shadow_Teleport",
	["Master Demonologist"] = "Spell_Shadow_ShadowPact",
	["Master of Deception"] = "Spell_Shadow_Charm",
	["Master of Elements"] = "Spell_Fire_MasterOfElements",
	["Master Summoner"] = "Spell_Shadow_ImpPhaseShift",
	["Maul"] = "Ability_Druid_Maul",
	["Mechanostrider Piloting"] = "Spell_Nature_Swiftness",
	["Meditation"] = "Spell_Nature_Sleep",
	["Megavolt"] = "Spell_Nature_ChainLightning",
	["Melee Specialization"] = "INV_Axe_02",
	["Melt Ore"] = "Spell_Fire_SelfDestruct",
	["Mend Pet"] = "Ability_Hunter_MendPet",
	["Mental Agility"] = "Ability_Hibernation",
	["Mental Strength"] = "Spell_Nature_EnchantArmor",
	["Mighty Blow"] = "INV_Gauntlets_05",
	["Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Mind Control"] = "Spell_Shadow_ShadowWordDominate",
	["Mind Flay"] = "Spell_Shadow_SiphonMana",
	["Mind Soothe"] = "Spell_Holy_MindSooth",
	["Mind Tremor"] = "Spell_Nature_Earthquake",
	["Mind Vision"] = "Spell_Holy_MindVision",
	["Mind-numbing Poison II"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison III"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison"] = "Spell_Nature_NullifyDisease",
	["Mining"] = "Spell_Fire_FlameBlades",
	["Mocking Blow"] = "Ability_Warrior_PunishingBlow",
	["Molten Blast"] = "Spell_Fire_Fire",
	["Molten Metal"] = "Spell_Fire_Fireball",
	["Mongoose Bite"] = "Ability_Hunter_SwiftStrike",
	["Monster Slaying"] = "INV_Misc_Head_Dragon_Black",
	["Moonfire"] = "Spell_Nature_StarFall",
	["Moonfury"] = "Spell_Nature_MoonGlow",
	["Moonglow"] = "Spell_Nature_Sentinal",
	["Moonkin Aura"] = "Spell_Nature_MoonGlow",
	["Moonkin Form"] = "Spell_Nature_ForceOfNature",
	["Mortal Cleave"] = "Ability_Warrior_SavageBlow",
	["Mortal Shots"] = "Ability_PierceDamage",
	["Mortal Strike"] = "Ability_Warrior_SavageBlow",
	["Mortal Wound"] = "Ability_CriticalStrike",
	["Multi-Shot"] = "Ability_UpgradeMoonGlaive",
	["Murder"] = "Spell_Shadow_DeathScream",
	["Naralex's Nightmare"] = "Spell_Nature_Sleep",
	["Natural Armor"] = "Spell_Nature_SpiritArmor",
	["Natural Shapeshifter"] = "Spell_Nature_WispSplode",
	["Natural Weapons"] = "INV_Staff_01",
	["Nature Aligned"] = "Spell_Nature_SpiritArmor",
	["Nature Resistance Totem"] = "Spell_Nature_NatureResistanceTotem",
	["Nature Resistance"] = "Spell_Nature_ResistNature",
	["Nature Weakness"] = "INV_Misc_QirajiCrystal_03",
	["Nature's Focus"] = "Spell_Nature_HealingWaveGreater",
	["Nature's Grace"] = "Spell_Nature_NaturesBlessing",
	["Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Nature's Reach"] = "Spell_Nature_NatureTouchGrow",
	["Nature's Swiftness"] = "Spell_Nature_RavenForm",
	["Necrotic Poison"] = "Ability_Creature_Poison_03",
	["Negative Charge"] = "Spell_ChargeNegative",
	["Net"] = "Ability_Ensnare",
	["Nightfall"] = "Spell_Shadow_Twilight",
	["Noxious Catalyst"] = "Spell_Holy_HarmUndeadAura",
	["Noxious Cloud"] = "Spell_Nature_AbolishMagic",
	["Omen of Clarity"] = "Spell_Nature_CrystalBall",
	["One-Handed Axes"] = "INV_Axe_01",
	["One-Handed Maces"] = "INV_Mace_01",
	["One-Handed Swords"] = "Ability_MeleeDamage",
	["One-Handed Weapon Specialization"] = "INV_Sword_20",
	["Opening - No Text"] = "Temp",
	["Opening"] = "Temp",
	["Opportunity"] = "Ability_Warrior_WarCry",
	["Overpower"] = "Ability_MeleeDamage",
	["Pacify"] = "Ability_Seal",
	["Paralyzing Poison"] = "Ability_PoisonSting",
	["Paranoia"] = "Spell_Shadow_AuraOfDarkness",
	["Parasitic Serpent"] = "INV_Misc_MonsterHead_03",
	["Parry"] = "Ability_Parry",
	["Pathfinding"] = "Ability_Mount_JungleTiger",
	["Perception"] = "Spell_Nature_Sleep",
	["Permafrost"] = "Spell_Frost_Wisp",
	["Pet Aggression"] = "Ability_Druid_Maul",
	["Pet Hardiness"] = "Ability_BullRush",
	["Pet Recovery"] = "Ability_Hibernation",
	["Pet Resistance"] = "Spell_Holy_BlessingOfAgility",
	["Petrify"] = "Ability_GolemThunderClap",
	["Phase Shift"] = "Spell_Shadow_ImpPhaseShift",
	["Pick Lock"] = "Spell_Nature_MoonKey",
	["Pick Pocket"] = "INV_Misc_Bag_11",
	["Pierce Armor"] = "Spell_Shadow_VampiricAura",
	["Piercing Howl"] = "Spell_Shadow_DeathScream",
	["Piercing Ice"] = "Spell_Frost_Frostbolt",
	["Piercing Shadow"] = "Spell_Shadow_ChillTouch",
	["Piercing Shot"] = "Ability_SearingArrow",
	["Plague Cloud"] = "Spell_Shadow_CallofBone",
	["Plate Mail"] = "INV_Chest_Plate01",
	["Poison Bolt Volley"] = "Spell_Nature_CorrosiveBreath",
	["Poison Bolt"] = "Spell_Nature_CorrosiveBreath",
	["Poison Cleansing Totem"] = "Spell_Nature_PoisonCleansingTotem",
	["Poison Cloud"] = "Spell_Nature_NatureTouchDecay",
	["Poison Shock"] = "Spell_Nature_Acid_01",
	["Poison"] = "Spell_Nature_CorrosiveBreath",
	["Poisoned Harpoon"] = "Ability_Poisons",
	["Poisoned Shot"] = "Ability_Poisons",
	["Poisonous Blood"] = "Spell_Nature_Regenerate",
	["Poisons"] = "Trade_BrewPoison",
	["Polearm Specialization"] = "INV_Weapon_Halbard_01",
	["Polearms"] = "INV_Spear_06",
	["Polymorph"] = "Spell_Nature_Polymorph",
	["Polymorph: Pig"] = "Spell_Magic_PolymorphPig", 
	["Polymorph: Turtle"] = "Ability_Hunter_Pet_Turtle",
	["Portal: Darnassus"] = "Spell_Arcane_PortalDarnassus",
	["Portal: Ironforge"] = "Spell_Arcane_PortalIronForge",
	["Portal: Orgrimmar"] = "Spell_Arcane_PortalOrgrimmar",
	["Portal: Stormwind"] = "Spell_Arcane_PortalStormWind",
	["Portal: Thunder Bluff"] = "Spell_Arcane_PortalThunderBluff",
	["Portal: Undercity"] = "Spell_Arcane_PortalUnderCity",
	["Positive Charge"] = "Spell_ChargePositive",
	["Pounce Bleed"] = "Ability_Druid_SupriseAttack",
	["Pounce"] = "Ability_Druid_SupriseAttack",
	["Power Infusion"] = "Spell_Holy_PowerInfusion",
	["Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Prayer Beads Blessing"] = "INV_Jewelry_Necklace_11",
	["Prayer of Fortitude"] = "Spell_Holy_PrayerOfFortitude",
	["Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Prayer of Shadow Protection"] = "Spell_Holy_PrayerofShadowProtection",
	["Prayer of Spirit"] = "Spell_Holy_PrayerofSpirit",
	["Precision"] = "Ability_Marksmanship",
	["Predatory Strikes"] = "Ability_Hunter_Pet_Cat",
	["Premeditation"] = "Spell_Shadow_Possession",
	["Preparation"] = "Spell_Shadow_AntiShadow",
	["Presence of Mind"] = "Spell_Nature_EnchantArmor",
	["Primal Fury"] = "Ability_Racial_Cannibalize",
	["Prowl"] = "Ability_Druid_SupriseAttack",
	["Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Pummel"] = "INV_Gauntlets_04",
	["Puncture"] = "Ability_Gouge",
	["Purge"] = "Spell_Nature_Purge",
	["Purification"] = "Spell_Frost_WizardMark",
	["Purify"] = "Spell_Holy_Purify",
	["Pursuit of Justice"] = "Spell_Holy_PersuitofJustice",
	["Putrid Breath"] = "Spell_Holy_HarmUndeadAura",
	["Putrid Enzyme"] = "Spell_Nature_NullifyDisease",
	["Pyroblast"] = "Spell_Fire_Fireball02",
	["Pyroclasm"] = "Spell_Fire_Volcano",
	["Quick Shots"] = "Ability_Warrior_Innerrage",
	["Quickness"] = "Ability_Racial_ShadowMeld",
	["Radiation Bolt"] = "Spell_Shadow_CorpseExplode",
	["Radiation Cloud"] = "Spell_Shadow_CorpseExplode",
	["Radiation Poisoning"] = "Spell_Shadow_CorpseExplode",
	["Radiation"] = "Spell_Shadow_CorpseExplode",
	["Rain of Fire"] = "Spell_Shadow_RainOfFire",
	["Rake"] = "Ability_Druid_Disembowel",
	["Ram Riding"] = "Spell_Nature_Swiftness",
	["Rampage"] = "Spell_Nature_NaturesWrath",
	["Ranged Weapon Specialization"] = "INV_Weapon_Rifle_06",
	["Rapid Concealment"] = "Ability_Ambush",
	["Rapid Fire"] = "Ability_Hunter_RunningShot",
	["Raptor Riding"] = "Spell_Nature_Swiftness",
	["Raptor Strike"] = "Ability_MeleeDamage",
	["Ravage"] = "Ability_Druid_Ravage",
	["Ravenous Claw"] = "Ability_GhoulFrenzy",
	["Readiness"] = "Spell_Nature_Sleep",
	["Rebirth"] = "Spell_Nature_Reincarnation",
	["Rebuild"] = "Spell_Shadow_LifeDrain",
	["Recently Bandaged"] = "INV_Misc_Bandage_08",
	["Recklessness"] = "Ability_CriticalStrike",
	["Reckoning"] = "Spell_Holy_BlessingOfStrength",
	["Recombobulate"] = "Spell_Magic_PolymorphChicken",
	["Redemption"] = "Spell_Holy_Resurrection",
	["Redoubt"] = "Ability_Defend",
	["Reflection"] = "Spell_Frost_WindWalkOn",
	["Regeneration"] = "Spell_Nature_Regenerate",
	["Regrowth"] = "Spell_Nature_ResistNature",
	["Reincarnation"] = "Spell_Nature_Reincarnation",
	["Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Relentless Strikes"] = "Ability_Warrior_DecisiveStrike",
	["Remorseless Attacks"] = "Ability_FiegnDead",
	["Remorseless"] = "Ability_Fiegndead",
	["Remove Curse"] = "Spell_Holy_RemoveCurse",
	["Remove Insignia"] = "Temp",
	["Remove Lesser Curse"] = "Spell_Nature_RemoveCurse",
	["Rend"] = "Ability_Gouge",
	["Renew"] = "Spell_Holy_Renew",
	["Repentance"] = "Spell_Holy_PrayerOfHealing",
	["Repulsive Gaze"] = "Ability_GolemThunderClap",
	["Restorative Totems"] = "Spell_Nature_ManaRegenTotem",
	["Resurrection"] = "Spell_Holy_Resurrection",
	["Retaliation"] = "Ability_Warrior_Challange",
	["Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Revenge Stun"] = "Ability_Warrior_Revenge",
	["Revenge"] = "Ability_Warrior_Revenge",
	["Reverberation"] = "Spell_Frost_FrostWard",
	["Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Rhahk'Zor Slam"] = "INV_Gauntlets_05",
	["Ribbon of Souls"] = "Spell_Nature_Lightning",
	["Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Rip"] = "Ability_GhoulFrenzy",
	["Riposte"] = "Ability_Warrior_Challange",
	["Ritual of Doom Effect"] = "Spell_Arcane_PortalDarnassus",
	["Ritual of Doom"] = "Spell_Shadow_AntiMagicShell",
	["Ritual of Summoning"] = "Spell_Shadow_Twilight",
	["Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Rogue Passive"] = "Ability_Stealth",
	["Ruin"] = "Spell_Shadow_ShadowWordPain",
	["Rupture"] = "Ability_Rogue_Rupture",
	["Ruthlessness"] = "Ability_Druid_Disembowel",
	["Sacrifice"] = "Spell_Shadow_SacrificialShield",
	["Safe Fall"] = "INV_Feather_01",
	["Sanctity Aura"] = "Spell_Holy_MindVision",
	["Sap"] = "Ability_Sap",
	["Savage Fury"] = "Ability_Druid_Ravage",
	["Savage Strikes"] = "Ability_Racial_BloodRage",
	["Scare Beast"] = "Ability_Druid_Cower",
	["Scatter Shot"] = "Ability_GolemStormBolt",
	["Scorch"] = "Spell_Fire_SoulBurn",
	["Scorpid Poison"] = "Ability_PoisonSting",
	["Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Screams of the Past"] = "Spell_Shadow_ImpPhaseShift",
	["Screech"] = "Ability_Hunter_Pet_Bat",
	["Seal Fate"] = "Spell_Shadow_ChillTouch",
	["Seal of Command"] = "Ability_Warrior_InnerRage",
	["Seal of Justice"] = "Spell_Holy_SealOfWrath",
	["Seal of Light"] = "Spell_Holy_HealingAura",
	["Seal of Reckoning"] = "Spell_Holy_SealOfWrath",
	["Seal of Righteousness"] = "Ability_ThunderBolt",
	["Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Seal of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Searing Light"] = "Spell_Holy_SearingLightPriest",
	["Searing Pain"] = "Spell_Fire_SoulBurn",
	["Searing Totem"] = "Spell_Fire_SearingTotem",
	["Second Wind"] = "INV_Jewelry_Talisman_06",
	["Seduction"] = "Spell_Shadow_MindSteal",
	["Sense Demons"] = "Spell_Shadow_Metamorphosis",
	["Sense Undead"] = "Spell_Holy_SenseUndead",
	["Sentry Totem"] = "Spell_Nature_RemoveCurse",
	["Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Setup"] = "Spell_Nature_MirrorImage",
	["Shackle Undead"] = "Spell_Nature_Slow",
	["Shadow Affinity"] = "Spell_Shadow_ShadowWard",
	["Shadow Bolt Volley"] = "Spell_Shadow_ShadowBolt",
	["Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Shadow Focus"] = "Spell_Shadow_BurningSpirit",
	["Shadow Mastery"] = "Spell_Shadow_ShadeTrueSight",
	["Shadow Protection"] = "Spell_Shadow_AntiShadow",
	["Shadow Reach"] = "Spell_Shadow_ChillTouch",
	["Shadow Resistance Aura"] = "Spell_Shadow_SealOfKings",
	["Shadow Resistance"] = "Spell_Shadow_AntiShadow",
	["Shadow Shock"] = "Spell_Shadow_ShadowBolt",
	["Shadow Trance"] = "Spell_Shadow_Twilight",
	["Shadow Vulnerability"] = "Spell_Shadow_ShadowBolt",
	["Shadow Ward"] = "Spell_Shadow_AntiShadow",
	["Shadow Weakness"] = "INV_Misc_QirajiCrystal_05",
	["Shadow Weaving"] = "Spell_Shadow_BlackPlague",
	["Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Shadowburn"] = "Spell_Shadow_ScourgeBuild",
	["Shadowform"] = "Spell_Shadow_Shadowform",
	["Shadowguard"] = "Spell_Nature_LightningShield",
	["Shadowmeld Passive"] = "Ability_Ambush",
	["Shadowmeld"] = "Ability_Ambush",
	["Sharpened Claws"] = "INV_Misc_MonsterClaw_04",
	["Shatter"] = "Spell_Frost_FrostShock",
	["Shell Shield"] = "Ability_Hunter_Pet_Turtle",
	["Shield Bash - Silenced"] = "Ability_Warrior_ShieldBash",
	["Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Shield Block"] = "Ability_Defend",
	["Shield Slam"] = "INV_Shield_05",
	["Shield Specialization"] = "INV_Shield_06",
	["Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Shield"] = "INV_Shield_04",
	["Shock"] = "Spell_Nature_WispHeal",
	["Shoot Bow"] = "Ability_Marksmanship",
	["Shoot Crossbow"] = "Ability_Marksmanship",
	["Shoot Gun"] = "Ability_Marksmanship",
	["Shoot"] = "Ability_ShootWand",
	["Shred"] = "Spell_Shadow_VampiricAura",
	["Shrink"] = "Spell_Shadow_AntiShadow",
	["Silence"] = "Spell_Shadow_ImpPhaseShift",
	["Silencing Shot"] = "Spell_Holy_Silence",
	["Silent Resolve"] = "Spell_Nature_ManaRegenTotem",
	["Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Siphon Life"] = "Spell_Shadow_Requiem",
	["Skinning"] = "INV_Misc_Pelt_Wolf_01",
	["Skull Crack"] = "Spell_Frost_Stun",
	["Slam"] = "Ability_Warrior_DecisiveStrike",
	["Sleep"] = "Spell_Nature_Sleep",
	["Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Slow Fall"] = "Spell_Magic_FeatherFall",
	["Slow"] = "Spell_Nature_Slow",
	["Slowing Poison"] = "Spell_Nature_SlowPoison",
	["Smelting"] = "Spell_Fire_FlameBlades",
	["Smite Slam"] = "INV_Gauntlets_05",
	["Smite Stomp"] = "Ability_WarStomp",
	["Smite"] = "Spell_Holy_HolySmite",
	["Smoke Bomb"] = "Ability_Hibernation",
	["Snap Kick"] = "Ability_Kick",
	["Sonic Burst"] = "Spell_Shadow_Teleport",
	["Soothe Animal"] = "Ability_Hunter_BeastSoothe",
	["Soothing Kiss"] = "Spell_Shadow_SoothingKiss",
	["Soul Bite"] = "Spell_Shadow_SiphonMana",
	["Soul Drain"] = "Spell_Shadow_LifeDrain02",
	["Soul Fire"] = "Spell_Fire_Fireball02",
	["Soul Link"] = "Spell_Shadow_GatherShadows",
	["Soul Siphon"] = "Spell_Shadow_LifeDrain02",
	["Soul Tap"] = "Spell_Shadow_LifeDrain02",
	["Soulstone Resurrection"] = "INV_Misc_Orb_04",
	["Spell Lock"] = "Spell_Shadow_MindRot",
	["Spell Reflection"] = "Spell_Shadow_Teleport",
	["Spell Warding"] = "Spell_Holy_SpellWarding",
	["Spirit Bond"] = "Ability_Druid_DemoralizingRoar",
	["Spirit Burst"] = "Spell_Shadow_Teleport",
	["Spirit of Redemption"] = "INV_Enchant_EssenceEternalLarge",
	["Spirit Tap"] = "Spell_Shadow_Requiem",
	["Spiritual Focus"] = "Spell_Arcane_Blink",
	["Spiritual Guidance"] = "Spell_Holy_SpiritualGuidence",
	["Spiritual Healing"] = "Spell_Nature_MoonGlow",
	["Spit"] = "Spell_Nature_CorrosiveBreath",
	["Spore Cloud"] = "Spell_Nature_DryadDispelMagic",
	["Sprint"] = "Ability_Rogue_Sprint",
	["Starfire Stun"] = "Spell_Arcane_StarFire",
	["Starfire"] = "Spell_Arcane_StarFire",
	["Starshards"] = "Spell_Arcane_StarFire",
	["Staves"] = "INV_Staff_08",
	["Stealth"] = "Ability_Stealth",
	["Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Stoneform"] = "Spell_Shadow_UnholyStrength",
	["Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Stormstrike"] = "Spell_Holy_SealOfMight",
	["Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Strike"] = "Ability_Rogue_Ambush",
	["Stuck"] = "Spell_Shadow_Teleport",
	["Stun"] = "Spell_Shadow_Teleport",
	["Subtlety"] = "Ability_EyeOfTheOwl",
	["Suffering"] = "Spell_Shadow_BlackPlague",
	["Summon Charger"] = "Ability_Mount_Charger",
	["Summon Dreadsteed"] = "Ability_Mount_Dreadsteed",
	["Summon Felhunter"] = "Spell_Shadow_SummonFelHunter",
	["Summon Felsteed"] = "Spell_Nature_Swiftness",
	["Summon Imp"] = "Spell_Shadow_SummonImp",
	["Summon Spawn of Bael'Gar"] = "Spell_Fire_LavaSpawn",
	["Summon Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Summon Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Summon Warhorse"] = "Spell_Nature_Swiftness",
	["Summon Water Elemental"] = "Spell_Shadow_Sealofkings",
	["Sunder Armor"] = "Ability_Warrior_Sunder",
	["Suppression"] = "Spell_Shadow_UnsummonBuilding",
	["Surefooted"] = "Ability_Kick",
	["Survivalist"] = "Spell_Shadow_Twilight",
	["Sweeping Slam"] = "Ability_Devour",
	["Sweeping Strikes"] = "Ability_Rogue_SliceDice",
	["Swiftmend"] = "INV_Relics_IdolofRejuvenation",
	["Swipe"] = "INV_Misc_MonsterClaw_03",
	["Swoop"] = "Ability_Warrior_Cleave",
	["Sword Specialization"] = "INV_Sword_27",
	["Tactical Mastery"] = "Spell_Nature_EnchantArmor",
	["Tailoring"] = "Trade_Tailoring",
	["Tainted Blood"] = "Spell_Shadow_LifeDrain",
	["Tame Beast"] = "Ability_Hunter_BeastTaming",
	["Tamed Pet Passive"] = "Ability_Mount_PinkTiger",
	["Taunt"] = "Spell_Nature_Reincarnation",
	["Teleport: Darnassus"] = "Spell_Arcane_TeleportDarnassus",
	["Teleport: Ironforge"] = "Spell_Arcane_TeleportIronForge",
	["Teleport: Moonglade"] = "Spell_Arcane_TeleportMoonglade",
	["Teleport: Orgrimmar"] = "Spell_Arcane_TeleportOrgrimmar",
	["Teleport: Stormwind"] = "Spell_Arcane_TeleportStormWind",
	["Teleport: Thunder Bluff"] = "Spell_Arcane_TeleportThunderBluff",
	["Teleport: Undercity"] = "Spell_Arcane_TeleportUnderCity",
	["Tendon Rip"] = "Ability_CriticalStrike",
	["Tendon Slice"] = "Ability_CriticalStrike",
	["Terrify"] = "Ability_Physical_Taunt",
	["Terrifying Screech"] = "Spell_Shadow_SummonImp",
	["The Eye of the Dead"] = "INV_Trinket_Naxxramas01",
	["The Furious Storm"] = "Spell_Nature_CallStorm",
	["The Human Spirit"] = "INV_Enchant_ShardBrilliantSmall",
	["Thick Hide"] = "INV_Misc_Pelt_Bear_03",
	["Thorn Volley"] = "Spell_Nature_NaturesWrath",
	["Thorns"] = "Spell_Nature_Thorns",
	["Thousand Blades"] = "INV_Sword_53",
	["Threatening Gaze"] = "Spell_Shadow_Charm",
	["Throw Axe"] = "INV_Axe_08",
	["Throw Dynamite"] = "Spell_Fire_SelfDestruct",
	["Throw Liquid Fire"] = "Spell_Fire_MeteorStorm",
	["Throw Wrench"] = "INV_Misc_Wrench_01",
	["Throw"] = "Ability_Throw",
	["Throwing Specialization"] = "INV_ThrowingAxe_03",
	["Throwing Weapon Specialization"] = "INV_ThrowingKnife_01",
	["Thrown"] = "INV_ThrowingKnife_02",
	["Thunder Clap"] = "Spell_Nature_ThunderClap",
	["Thunderclap"] = "Spell_Nature_ThunderClap",
	["Thunderfury"] = "Spell_Nature_Cyclone",
	["Thundering Strikes"] = "Ability_ThunderBolt",
	["Thundershock"] = "Spell_Lightning_LightningBolt01",
	["Thunderstomp"] = "Ability_Hunter_Pet_Gorilla",
	["Tidal Focus"] = "Spell_Frost_ManaRecharge",
	["Tidal Mastery"] = "Spell_Nature_Tranquility",
	["Tiger Riding"] = "Spell_Nature_Swiftness",
	["Tiger's Fury"] = "Ability_Mount_JungleTiger",
	["Torment"] = "Spell_Shadow_GatherShadows",
	["Totem of Wrath"] = "Spell_Fire_TotemOfWrath",
	["Totem"] = "Spell_Nature_StoneClawTotem",
	["Totemic Focus"] = "Spell_Nature_MoonGlow",
	["Touch of Weakness"] = "Spell_Shadow_DeadofNight",
	["Toughness"] = "Spell_Holy_Devotion",
	["Toxic Saliva"] = "Spell_Nature_CorrosiveBreath",
	["Toxic Spit"] = "Spell_Nature_CorrosiveBreath",
	["Toxic Volley"] = "Spell_Nature_CorrosiveBreath",
	["Traces of Silithyst"] = "Spell_Nature_TimeStop",
	["Track Beasts"] = "Ability_Tracking",
	["Track Demons"] = "Spell_Shadow_SummonFelHunter",
	["Track Dragonkin"] = "INV_Misc_Head_Dragon_01",
	["Track Elementals"] = "Spell_Frost_SummonWaterElemental",
	["Track Giants"] = "Ability_Racial_Avatar",
	["Track Hidden"] = "Ability_Stealth",
	["Track Humanoids"] = "Spell_Holy_PrayerOfHealing",
	["Track Undead"] = "Spell_Shadow_DarkSummoning",
	["Trample"] = "Spell_Nature_NaturesWrath",
	["Tranquil Air Totem"] = "Spell_Nature_Brilliance",
	["Tranquil Spirit"] = "Spell_Holy_ElunesGrace",
	["Tranquility"] = "Spell_Nature_Tranquility",
	["Tranquilizing Poison"] = "Ability_Creature_Poison_03",
	["Tranquilizing Shot"] = "Spell_Nature_Drowsy",
	["Trap Mastery"] = "Ability_Ensnare",
	["Travel Form"] = "Ability_Druid_TravelForm",
	["Tremor Totem"] = "Spell_Nature_TremorTotem",
	["Trueshot Aura"] = "Ability_TrueShot",
	["Turn Undead"] = "Spell_Holy_TurnUndead",
	["Twisted Tranquility"] = "Spell_Nature_Tranquility",
	["Two-Handed Axes and Maces"] = "INV_Axe_10",
	["Two-Handed Axes"] = "INV_Axe_04",
	["Two-Handed Maces"] = "INV_Mace_04",
	["Two-Handed Swords"] = "Ability_MeleeDamage",
	["Two-Handed Weapon Specialization"] = "INV_Axe_09",
	["Unarmed"] = "Ability_GolemThunderClap",
	["Unbreakable Will"] = "Spell_Magic_MageArmor",
	["Unbridled Wrath Effect"] = "Spell_Nature_StoneClawTotem",
	["Unbridled Wrath"] = "Spell_Nature_StoneClawTotem",
	["Undead Horsemanship"] = "Spell_Nature_Swiftness",
	["Underwater Breathing"] = "Spell_Shadow_DemonBreath",
	["Unending Breath"] = "Spell_Shadow_DemonBreath",
	["Unholy Frenzy"] = "Spell_Nature_BloodLust",
	["Unholy Power"] = "Spell_Shadow_ShadowWordDominate",
	["Unleashed Fury"] = "Ability_BullRush",
	["Unleashed Rage"] = "Spell_Nature_Ancestralguardian",
	["Unstable Concoction"] = "Spell_Fire_Incinerate",
	["Unstable Power"] = "Trade_Engineering",
	["Unyielding Faith"] = "Spell_Holy_UnyieldingFaith",
	["Uppercut"] = "INV_Gauntlets_05",
	["Vampiric Embrace"] = "Spell_Shadow_UnsummonBuilding",
	["Vanish"] = "Ability_Vanish",
	["Vanished"] = "Ability_Vanish",
	["Veil of Shadow"] = "Spell_Shadow_GatherShadows",
	["Vengeance"] = "Spell_Nature_Purge",
	["Venom Spit"] = "Spell_Nature_CorrosiveBreath",
	["Venom Sting"] = "Ability_PoisonSting",
	["Venomhide Poison"] = "Ability_Rogue_DualWeild",
	["Vicious Rend"] = "Ability_Gouge",
	["Vigor"] = "Spell_Nature_EarthBindTotem",
	["Vile Poisons"] = "Ability_Rogue_FeignDeath",
	["Vindication"] = "Spell_Holy_Vindication",
	["Viper Sting"] = "Ability_Hunter_AimedShot",
	["Virulent Poison"] = "Spell_Nature_CorrosiveBreath",
	["Void Bolt"] = "Spell_Shadow_ShadowBolt",
	["Volley"] = "Ability_Marksmanship",
	["Walking Bomb Effect"] = "Spell_Fire_SelfDestruct",
	["Wand Specialization"] = "INV_Wand_01",
	["Wandering Plague"] = "Spell_Shadow_CorpseExplode",
	["Wands"] = "Ability_ShootWand",
	["War Stomp"] = "Ability_WarStomp",
	["Water Breathing"] = "Spell_Shadow_DemonBreath",
	["Water Walking"] = "Spell_Frost_WindWalkOn",
	["Water"] = "Spell_Frost_SummonWaterElemental",
	["Waterbolt"] =	"Spell_Frost_FrostBolt",
	["Wavering Will"] = "Spell_Shadow_AnimateDead",
	["Weakened Soul"] = "Spell_Holy_AshesToAshes",
	["Web Explosion"] = "Ability_Ensnare",
	["Web Spin"] = "Spell_Nature_EarthBind",
	["Web Spray"] = "Ability_Ensnare",
	["Web"] = "Ability_Ensnare",
	["Whirling Barrage"] = "INV_Spear_05",
	["Whirling Trip"] = "INV_Spear_05",
	["Whirlwind"] = "Ability_Whirlwind",
	["Wide Slash"] = "Ability_Warrior_Cleave",
	["Will of Hakkar"] = "Spell_Shadow_ShadowWordDominate",
	["Will of the Forsaken"] = "Spell_Shadow_RaiseDead",
	["Windfury Totem"] = "Spell_Nature_Windfury",
	["Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Windsor's Frenzy"] = "Ability_Racial_BloodRage",
	["Windwall Totem"] = "Spell_Nature_EarthBind",
	["Wing Clip"] = "Ability_Rogue_Trip",
	["Wing Flap"] = "Spell_Nature_EarthBind",
	["Winter's Chill"] = "Spell_Frost_ChillingBlast",
	["Wisp Spirit"] = "Spell_Nature_WispSplode",
	["Wolf Riding"] = "Spell_Nature_Swiftness",
	["Wound Poison II"] = "INV_Misc_Herb_16",
	["Wound Poison III"] = "INV_Misc_Herb_16",
	["Wound Poison IV"] = "INV_Misc_Herb_16",
	["Wound Poison"] = "INV_Misc_Herb_16",
	["Wrath of Air Totem"] = "Spell_Nature_SlowingTotem",
	["Wrath"] = "Spell_Nature_AbolishMagic",
	["Wyvern Sting"] = "INV_Spear_02",
}

BabbleSpell:Debug()
BabbleSpell:SetStrictness(true)

function BabbleSpell:GetSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	local icon = spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function BabbleSpell:GetShortSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	return spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
end

AceLibrary:Register(BabbleSpell, MAJOR_VERSION, MINOR_VERSION)
BabbleSpell = nil