/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.agent;

import ai.levo.instrument.JRubyOpensslInstrumentation;
import ai.levo.instrument.JavaxSSLEngineInstrumentation;
import ai.levo.instrument.JavaxSslSocketInstrumentation;
import ai.levo.instrument.SunSecuritySslInstrumentation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import net.bytebuddy.dynamic.ClassFileLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);

    public static void premain(String agentArgs, Instrumentation inst) {
        logger.info("Retransform supported: " + inst.isRetransformClassesSupported());
        Agent.attachAgent(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        Agent.attachAgent(agentArgs, inst);
    }

    private static void attachAgent(String agentArgs, Instrumentation inst) {
        try {
            Map<String, Boolean> config = Agent.parseAgentArgs(agentArgs);
            File agentJar = new File(Agent.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            File agentDir = agentJar.getParentFile();
            File[] bootstrapCandidates = agentDir.listFiles((dir, name) -> name.startsWith("levo-agent-bootstrap") && name.endsWith(".jar"));
            if (bootstrapCandidates == null || bootstrapCandidates.length <= 0) {
                throw new FileNotFoundException("No bootstrap JAR found starting with 'levo-agent-bootstrap'");
            }
            File bootstrapJar = bootstrapCandidates[0];
            inst.appendToBootstrapClassLoaderSearch(new JarFile(bootstrapJar));
            ClassFileLocator bootstrapLocator = ClassFileLocator.ForJarFile.of(bootstrapJar);
            if (config.getOrDefault("TraceClientTrafficOnly", false).booleanValue()) {
                logger.info("TraceClientTrafficOnly is enabled");
                System.setProperty("levo.trace.client.traffic.only", "true");
            }
            if (config.getOrDefault("SunSecuritySslInstrumentation", true).booleanValue()) {
                SunSecuritySslInstrumentation.instrument(inst, bootstrapLocator);
                logger.info("SunSecuritySslInstrumentation enabled");
            }
            if (config.getOrDefault("JavaxSslSocketStreamInstrumentation", false).booleanValue()) {
                JavaxSslSocketInstrumentation.instrument(inst, bootstrapLocator);
                logger.info("JavaxSslSocketStreamInstrumentation enabled");
            }
            if (config.getOrDefault("JRubyOpensslInstrumentation", false).booleanValue()) {
                JRubyOpensslInstrumentation.instrument(inst, bootstrapLocator);
                logger.info("JRubyOpensslInstrumentation enabled");
            }
            if (config.getOrDefault("JavaxSSLEngineInstrumentation", false).booleanValue()) {
                JavaxSSLEngineInstrumentation.instrument(inst, bootstrapLocator);
                logger.info("JavaxSSLEngineInstrumentation enabled");
            }
        }
        catch (IOException | UnmodifiableClassException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Boolean> parseAgentArgs(String agentArgs) {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        if (agentArgs != null && !agentArgs.isEmpty()) {
            String[] args;
            for (String arg : args = agentArgs.split(",")) {
                String[] keyValue = arg.split("=");
                if (keyValue.length != 2) continue;
                config.put(keyValue[0].trim(), Boolean.parseBoolean(keyValue[1].trim()));
            }
        }
        return config;
    }
}

