/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.instrument;

import ai.levo.bootstrap.javaxnet.SSLEngineUnwrapAdvice;
import ai.levo.bootstrap.javaxnet.SSLEngineWrapAdvice;
import ai.levo.instrument.JavaxSslSocketInstrumentation;
import java.lang.instrument.Instrumentation;
import java.nio.ByteBuffer;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxSSLEngineInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(JavaxSslSocketInstrumentation.class);

    public static void instrument(Instrumentation inst, ClassFileLocator bootstrapLocator) {
        logger.info("Instrumenting JavaxSslEngineInstrumentation");
        new AgentBuilder.Default().with(AgentBuilder.Listener.StreamWriting.toSystemOut().withTransformationsOnly()).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).ignore(ElementMatchers.none()).type(ElementMatchers.nameStartsWith("javax.net.ssl.SSLEngine")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(SSLEngineUnwrapAdvice.class, bootstrapLocator).on(ElementMatchers.named("unwrap").and(ElementMatchers.takesArgument(0, ByteBuffer.class)).and(ElementMatchers.takesArgument(1, ByteBuffer.class)).and(ElementMatchers.returns(ElementMatchers.named("javax.net.ssl.SSLEngineResult"))))).visit(Advice.to(SSLEngineWrapAdvice.class, bootstrapLocator).on(ElementMatchers.named("wrap").and(ElementMatchers.takesArgument(0, ByteBuffer.class)).and(ElementMatchers.takesArgument(1, ByteBuffer.class))))).installOn(inst);
    }
}

