/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.instrument;

import ai.levo.bootstrap.sunsecurity.SSLSocketImplAcceptAdvice;
import ai.levo.bootstrap.sunsecurity.SSLSocketImplCloseAdvice;
import ai.levo.bootstrap.sunsecurity.appinputstreamadvice.AppInputStreamAdviceReadByteArray;
import ai.levo.bootstrap.sunsecurity.appinputstreamadvice.AppInputStreamAdviceReadByteArrayOffset;
import ai.levo.bootstrap.sunsecurity.appinputstreamadvice.AppInputStreamAdviceReadNoArg;
import ai.levo.bootstrap.sunsecurity.appoutputstreamadvice.AppOutputStreamAdviceWriteByteArray;
import ai.levo.bootstrap.sunsecurity.appoutputstreamadvice.AppOutputStreamAdviceWriteByteArrayOffset;
import ai.levo.bootstrap.sunsecurity.appoutputstreamadvice.AppOutputStreamAdviceWriteInt;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunSecuritySslInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(SunSecuritySslInstrumentation.class);

    public static void instrument(Instrumentation inst, ClassFileLocator bootstrapLocator) throws UnmodifiableClassException {
        logger.info("Instrumenting SunSecuritySslInstrumentation");
        new AgentBuilder.Default().ignore(ElementMatchers.none()).disableClassFormatChanges().with(AgentBuilder.Listener.StreamWriting.toSystemOut().withTransformationsOnly()).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.TypeStrategy.Default.REDEFINE).type(ElementMatchers.nameEndsWith("SSLSocketImpl$AppInputStream").or(ElementMatchers.nameEndsWith("SSLSocketImpl$AppOutputStream")).or(ElementMatchers.named("sun.security.ssl.SSLSocketImpl"))).transform((builder1, td, cl, module, pd) -> builder1.visit(Advice.to(AppInputStreamAdviceReadNoArg.class, bootstrapLocator).on(ElementMatchers.named("read").and(ElementMatchers.takesArguments(0)))).visit(Advice.to(AppInputStreamAdviceReadByteArray.class, bootstrapLocator).on(ElementMatchers.named("read").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, byte[].class)))).visit(Advice.to(AppInputStreamAdviceReadByteArrayOffset.class, bootstrapLocator).on(ElementMatchers.named("read").and(ElementMatchers.takesArguments(3)).and(ElementMatchers.takesArgument(0, byte[].class)).and(ElementMatchers.takesArgument(1, Integer.TYPE)).and(ElementMatchers.takesArgument(2, Integer.TYPE)))).visit(Advice.to(AppOutputStreamAdviceWriteInt.class, bootstrapLocator).on(ElementMatchers.named("write").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, Integer.TYPE)))).visit(Advice.to(AppOutputStreamAdviceWriteByteArray.class, bootstrapLocator).on(ElementMatchers.named("write").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, byte[].class)))).visit(Advice.to(AppOutputStreamAdviceWriteByteArrayOffset.class, bootstrapLocator).on(ElementMatchers.named("write").and(ElementMatchers.takesArguments(3)).and(ElementMatchers.takesArgument(0, byte[].class)).and(ElementMatchers.takesArgument(1, Integer.TYPE)).and(ElementMatchers.takesArgument(2, Integer.TYPE)))).visit(Advice.to(SSLSocketImplAcceptAdvice.class, bootstrapLocator).on(ElementMatchers.named("getInputStream"))).visit(Advice.to(SSLSocketImplCloseAdvice.class, bootstrapLocator).on(ElementMatchers.named("close").and(ElementMatchers.takesArguments(0))))).installOn(inst);
    }
}

