/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.erpc;

import ai.levo.bootstrap.erpc.NativeIoctl;
import ai.levo.bootstrap.model.SocketConnection;
import java.nio.charset.StandardCharsets;

public class Erpc {
    private NativeIoctl nativeIoctl;
    private final int IOCTL_DIR = 3;
    private final int SOCKET_IOCTL_TYPE = 218;
    private final int DATA_IOCTL_TYPE = 219;
    private final int SOCKET_IOCTL_TYPE_NIO = 220;
    private final int DATA_IOCTL_TYPE_NIO = 221;
    private final int IOCTL_NR = 122;
    private final int IOCTL_SIZE = 512;
    private final int CHUNK_SIZE_BYTES = 128;
    private final long SOCKET_IOCTL_CODE = this._IOW(3, 218, 122, 512);
    private final long DATA_IOCTL_CODE = this._IOW(3, 219, 122, 512);
    private final short EVENT_TYPE_VERSION = 1;
    private final long SOCKET_IOCTL_NIO_CODE = this._IOW(3, 220, 122, 512);
    private final long DATA_IOCTL_NIO_CODE = this._IOW(3, 221, 122, 512);

    private long _IOW(int dir, int type, int nr, int size) {
        return this._IOC(dir, type, nr, size);
    }

    private long _IOC(int dir, int type, int nr, int size) {
        return (long)dir << 30 | (long)type << 8 | (long)nr << 0 | (long)size << 16;
    }

    public Erpc() {
        this.nativeIoctl = new NativeIoctl(512L);
        this.nativeIoctl.address = this.nativeIoctl.allocateNativeMemory(512L);
    }

    public void sendIoctlMessage(String message, int event) {
        byte[] msgBytes = message.getBytes(StandardCharsets.UTF_8);
        int chunkSize = 128;
        int totalChunks = (msgBytes.length + chunkSize - 1) / chunkSize;
        for (int chunk = 0; chunk < totalChunks; ++chunk) {
            try {
                this.nativeIoctl.clearMemory(this.nativeIoctl.address, this.nativeIoctl.size);
                long offset = 0L;
                int pid = this.nativeIoctl.getPid();
                long threadId = Thread.currentThread().getId();
                this.nativeIoctl.writeShortToMemory(this.nativeIoctl.address, offset, (short)1);
                this.nativeIoctl.writeByteToMemory(this.nativeIoctl.address, offset += 2L, (byte)event);
                this.nativeIoctl.writeIntToMemory(this.nativeIoctl.address, ++offset, pid);
                this.nativeIoctl.writeLongToMemory(this.nativeIoctl.address, offset += 4L, threadId);
                int startIdx = chunk * chunkSize;
                int endIdx = Math.min(startIdx + chunkSize, msgBytes.length);
                int currentChunkSize = endIdx - startIdx;
                this.nativeIoctl.writeIntToMemory(this.nativeIoctl.address, offset += 8L, currentChunkSize);
                this.nativeIoctl.writeBytesToMemory(this.nativeIoctl.address, offset += 4L, msgBytes, startIdx, currentChunkSize);
                long nativeFd = 0L;
                long argp = this.nativeIoctl.address;
                long l = this.nativeIoctl.nativeIoctl(nativeFd, this.DATA_IOCTL_CODE, argp);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void sendIoctlSocketLifecycleInfo(SocketConnection connection, int event) {
        try {
            if (connection == null) {
                connection = new SocketConnection();
            }
            this.nativeIoctl.clearMemory(this.nativeIoctl.address, this.nativeIoctl.size);
            long offset = 0L;
            this.nativeIoctl.writeShortToMemory(this.nativeIoctl.address, offset, (short)1);
            byte[] localIp = connection.getLocalAddress().getBytes(StandardCharsets.UTF_8);
            byte[] remoteIp = connection.getRemoteAddress().getBytes(StandardCharsets.UTF_8);
            this.nativeIoctl.writeBytesToMemory(this.nativeIoctl.address, offset += 2L, localIp, 0, Math.min(localIp.length, 16));
            this.nativeIoctl.writeBytesToMemory(this.nativeIoctl.address, offset += 16L, remoteIp, 0, Math.min(remoteIp.length, 16));
            this.nativeIoctl.writeShortToMemory(this.nativeIoctl.address, offset += 16L, (short)connection.getLocalPort());
            this.nativeIoctl.writeShortToMemory(this.nativeIoctl.address, offset += 2L, (short)connection.getRemotePort());
            this.nativeIoctl.writeByteToMemory(this.nativeIoctl.address, offset += 2L, (byte)event);
            int pid = connection.getPid() == 0 ? this.nativeIoctl.getPid() : connection.getPid();
            this.nativeIoctl.writeIntToMemory(this.nativeIoctl.address, ++offset, pid);
            this.nativeIoctl.writeLongToMemory(this.nativeIoctl.address, offset += 4L, connection.getThreadId());
            this.nativeIoctl.writeByteToMemory(this.nativeIoctl.address, offset += 8L, connection.getAddrFamily());
            long nativeFd = 0L;
            long argp = this.nativeIoctl.address;
            long l = this.nativeIoctl.nativeIoctl(nativeFd, this.SOCKET_IOCTL_CODE, argp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

