/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.erpc;

public class NativeIoctl {
    private final String LIBRARY_NAME = "libnative_ioctl.so";
    private final String DEFAULT_LIBRARY_PATH = "/usr/lib/libnative_ioctl.so";
    private final String NATIVE_IOCTL_LIB_LOADED_SYS_PROPERTY_KEY = "native.ioctl.lib.loaded";
    public long address = 0L;
    public final long size;

    private synchronized void loadNativeLibrary() {
        if (Boolean.getBoolean("native.ioctl.lib.loaded")) {
            return;
        }
        try {
            String libNativeIoctlFilePath = System.getenv("LIB_NATIVE_IOCTL_FILE_PATH");
            if (libNativeIoctlFilePath == null || libNativeIoctlFilePath.isEmpty()) {
                libNativeIoctlFilePath = "/usr/lib/libnative_ioctl.so";
            }
            System.load(libNativeIoctlFilePath);
            System.setProperty("native.ioctl.lib.loaded", "true");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Failed to load libnative_ioctl.so: " + e.getMessage());
        }
    }

    public NativeIoctl(long size) {
        this.loadNativeLibrary();
        this.size = size;
    }

    public native long nativeIoctl(long var1, long var3, long var5);

    public native long allocateNativeMemory(long var1);

    public native void freeNativeMemory(long var1);

    public native void writeByteToMemory(long var1, long var3, byte var5);

    public native void writeLongToMemory(long var1, long var3, long var5);

    public native void writeIntToMemory(long var1, long var3, int var5);

    public native void writeShortToMemory(long var1, long var3, short var5);

    public native void writeBytesToMemory(long var1, long var3, byte[] var5, int var6, int var7);

    public native void clearMemory(long var1, long var3);

    public native int getPid();
}

