/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.javaxnet;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class InterceptingOutputStream
extends FilterOutputStream {
    public InterceptingOutputStream(OutputStream out) {
        super(out);
        System.out.println("Created new InterceptingOutputStream for socket: ");
    }

    @Override
    public void write(int b) throws IOException {
        try {
            System.out.println("write(int): " + b + " [char: " + (char)b + "]");
            super.write(b);
            System.out.println("write(int) completed");
        }
        catch (IOException e) {
            System.out.println("Error in write(int): " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            System.out.println("write(byte[]): " + new String(b));
            super.write(b);
            System.out.println("write(byte[]) completed, length: " + b.length);
        }
        catch (IOException e) {
            System.out.println("Error in write(byte[]): " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            System.out.println("write(byte[], off, len): offset=" + off + ", length=" + len);
            System.out.println("Content: " + new String(b, off, len));
            super.write(b, off, len);
            System.out.println("write(byte[], off, len) completed");
        }
        catch (IOException e) {
            System.out.println("Error in write(byte[], off, len): " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            System.out.println("flush() called");
            super.flush();
            System.out.println("flush() completed");
        }
        catch (IOException e) {
            System.out.println("Error in flush(): " + e.getMessage());
            throw e;
        }
    }
}

