/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.javaxnet;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLEngineResult;
import net.bytebuddy.asm.Advice;

public class SSLEngineUnwrapAdvice {
    @Advice.OnMethodExit
    public static void onUnwrapExit(@Advice.Return Object result, @Advice.Origin Method method, @Advice.AllArguments Object[] args) {
        SSLEngineResult.Status status;
        boolean traceClientTrafficOnly;
        String message = null;
        String payloadType = null;
        boolean bl = traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
        if (args.length >= 2 && args[1] instanceof ByteBuffer) {
            ByteBuffer dest = (ByteBuffer)args[1];
            byte[] buf = new byte[dest.position()];
            ByteBuffer copy = dest.duplicate();
            copy.flip();
            copy.get(buf);
            message = new String(buf, StandardCharsets.UTF_8);
            if (traceClientTrafficOnly) {
                HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
                payloadType = httpRegexMatcher.detectPayloadType(message);
            }
        }
        if ((!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("RESPONSE")) && result instanceof SSLEngineResult && ((status = ((SSLEngineResult)result).getStatus()) == SSLEngineResult.Status.OK || status == SSLEngineResult.Status.CLOSED)) {
            try {
                Erpc erpc = new Erpc();
                erpc.sendIoctlSocketLifecycleInfo(null, 0);
                if (message != null && !message.isEmpty()) {
                    erpc.sendIoctlMessage(message, 2);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

