/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.javaxnet;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLEngineResult;
import net.bytebuddy.asm.Advice;

public class SSLEngineWrapAdvice {
    @Advice.OnMethodExit
    static void onExit(@Advice.Return Object result, @Advice.Origin Method method, @Advice.AllArguments Object[] args) {
        SSLEngineResult.Status status;
        boolean traceClientTrafficOnly;
        String message = null;
        String payloadType = null;
        boolean bl = traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
        if (args.length >= 2 && args[0] instanceof ByteBuffer) {
            ByteBuffer src = (ByteBuffer)args[0];
            byte[] buf = new byte[src.position()];
            ByteBuffer copy = src.duplicate();
            copy.flip();
            copy.get(buf);
            message = new String(buf, StandardCharsets.UTF_8);
            if (traceClientTrafficOnly) {
                HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
                payloadType = httpRegexMatcher.detectPayloadType(message);
            }
        }
        if ((!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("REQUEST")) && result instanceof SSLEngineResult && ((status = ((SSLEngineResult)result).getStatus()) == SSLEngineResult.Status.OK || status == SSLEngineResult.Status.CLOSED)) {
            try {
                Erpc erpc = new Erpc();
                erpc.sendIoctlSocketLifecycleInfo(null, 0);
                if (message != null && !message.isEmpty()) {
                    erpc.sendIoctlMessage(message, 3);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

