/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.jruby;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.bytebuddy.asm.Advice;

public class ReadAdvice {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Advice.OnMethodExit
    public static void onExit(@Advice.Origin String method, @Advice.This Object socket, @Advice.Argument(value=0) ByteBuffer buffer, @Advice.Return int bytesRead) {
        if (bytesRead <= 0) {
            return;
        }
        int originalPosition = buffer.position();
        try {
            buffer.position(originalPosition - bytesRead);
            byte[] data = new byte[bytesRead];
            buffer.get(data);
            String message = new String(data, StandardCharsets.UTF_8);
            boolean traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
            String payloadType = null;
            if (traceClientTrafficOnly) {
                HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
                payloadType = httpRegexMatcher.detectPayloadType(message);
            }
            if (!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("RESPONSE")) {
                Erpc erpc = new Erpc();
                erpc.sendIoctlMessage(message, 2);
            }
        }
        finally {
            buffer.position(originalPosition);
        }
    }
}

