/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.jruby;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.bytebuddy.asm.Advice;

public class WriteAdvice {
    @Advice.OnMethodEnter
    public static void onEnter(@Advice.Origin String method, @Advice.This Object socket, @Advice.Argument(value=0) ByteBuffer buffer) {
        ByteBuffer copy = buffer.duplicate();
        copy.mark();
        String message = StandardCharsets.UTF_8.decode(copy).toString();
        boolean traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
        String payloadType = null;
        if (traceClientTrafficOnly) {
            HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
            payloadType = httpRegexMatcher.detectPayloadType(message);
        }
        if (!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("REQUEST")) {
            Erpc erpc = new Erpc();
            erpc.sendIoctlMessage(message, 3);
        }
    }
}

