/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.sunsecurity.appinputstreamadvice;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.nio.charset.StandardCharsets;
import net.bytebuddy.asm.Advice;

public class AppInputStreamAdviceReadByteArray {
    @Advice.OnMethodExit
    public static void onReadByteArray(@Advice.Argument(value=0) byte[] buf, @Advice.Return int ret, @Advice.This Object thisObject) {
        if (ret > 0) {
            String data = new String(buf, 0, ret, StandardCharsets.UTF_8);
            boolean traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
            String payloadType = null;
            if (traceClientTrafficOnly) {
                HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
                payloadType = httpRegexMatcher.detectPayloadType(data);
            }
            if (!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("RESPONSE")) {
                Erpc erpc = new Erpc();
                erpc.sendIoctlMessage(data, 2);
            }
        }
    }
}

