/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.sunsecurity.appinputstreamadvice;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.bytebuddy.asm.Advice;

public class AppInputStreamAdviceReadByteArrayOffset {
    @Advice.OnMethodExit
    public static void onReadByteArrayOffset(@Advice.Argument(value=0) byte[] buf, @Advice.Argument(value=1) int off, @Advice.Argument(value=2) int len, @Advice.Return int ret) {
        if (ret > 0) {
            byte[] actual = Arrays.copyOfRange(buf, off, off + ret);
            String data = new String(actual, StandardCharsets.UTF_8);
            boolean traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
            String payloadType = null;
            if (traceClientTrafficOnly) {
                HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
                payloadType = httpRegexMatcher.detectPayloadType(data);
            }
            if (!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("RESPONSE")) {
                Erpc erpc = new Erpc();
                erpc.sendIoctlMessage(data, 2);
            }
        }
    }
}

