/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.sunsecurity.appoutputstreamadvice;

import ai.levo.bootstrap.erpc.Erpc;
import ai.levo.bootstrap.utils.HTTPRegexMatcher;
import java.util.Arrays;
import net.bytebuddy.asm.Advice;

public class AppOutputStreamAdviceWriteByteArrayOffset {
    @Advice.OnMethodEnter
    public static void onEnter(@Advice.Argument(value=0) byte[] b, @Advice.Argument(value=1) int off, @Advice.Argument(value=2) int len) {
        byte[] data = Arrays.copyOfRange(b, off, off + len);
        String message = new String(data);
        boolean traceClientTrafficOnly = System.getProperty("levo.trace.client.traffic.only") != null && System.getProperty("levo.trace.client.traffic.only").equalsIgnoreCase("true");
        String payloadType = null;
        if (traceClientTrafficOnly) {
            HTTPRegexMatcher httpRegexMatcher = new HTTPRegexMatcher();
            payloadType = httpRegexMatcher.detectPayloadType(message);
        }
        if (!traceClientTrafficOnly || payloadType != null && payloadType.equalsIgnoreCase("REQUEST")) {
            Erpc erpc = new Erpc();
            erpc.sendIoctlMessage(message, 3);
        }
    }
}

