/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.utils;

import java.util.regex.Pattern;

public class HTTPRegexMatcher {
    public final String HTTP_REQUEST_REGEX = "^(GET|POST|PUT|DELETE|HEAD|OPTIONS|PATCH)\\s+([^\\s]+)\\s+HTTP/1\\.[01]$";
    public final String HTTP_RESPONSE_REGEX = "^HTTP/1\\.[01]\\s+(200|201|202|204|301|400|401|403|404|500)\\s+.*$";
    private final Pattern REQUEST_PATTERN = Pattern.compile("^(GET|POST|PUT|DELETE|HEAD|OPTIONS|PATCH)\\s+([^\\s]+)\\s+HTTP/1\\.[01]$", 8);
    private final Pattern STATUS_PATTERN = Pattern.compile("^HTTP/1\\.[01]\\s+(200|201|202|204|301|400|401|403|404|500)\\s+.*$", 8);

    public String detectPayloadType(String payload) {
        if (payload == null || payload.trim().isEmpty()) {
            return "";
        }
        String firstLine = HTTPRegexMatcher.getFirstLine(payload);
        if (this.REQUEST_PATTERN.matcher(firstLine).matches()) {
            return "REQUEST";
        }
        if (this.STATUS_PATTERN.matcher(firstLine).matches()) {
            return "RESPONSE";
        }
        return "";
    }

    public boolean containsRequestLine(String payload) {
        return payload != null && this.REQUEST_PATTERN.matcher(payload).find();
    }

    public boolean containsStatusLine(String payload) {
        return payload != null && this.STATUS_PATTERN.matcher(payload).find();
    }

    private static String getFirstLine(String payload) {
        int newlineIndex = payload.indexOf(10);
        if (newlineIndex == -1) {
            return payload.trim();
        }
        String firstLine = payload.substring(0, newlineIndex).trim();
        if (firstLine.endsWith("\r")) {
            firstLine = firstLine.substring(0, firstLine.length() - 1);
        }
        return firstLine;
    }
}

