/*
 * Decompiled with CFR 0.152.
 */
package ai.levo.bootstrap.utils;

import ai.levo.bootstrap.model.SocketConnection;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;

public class SocketInspector {
    private boolean shouldRecurse(Class<?> type, String fieldName, Object value) {
        HashSet<Class> SKIP_RECURSE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Integer.class, Long.class, Boolean.class, Byte.class, Short.class, Double.class, Float.class, Character.class, InetAddress.class, InetSocketAddress.class, Class.class));
        if (value == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (SKIP_RECURSE_TYPES.contains(type)) {
            return false;
        }
        String className = type.getName();
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.")) {
            return value instanceof Socket || value instanceof SocketChannel;
        }
        return fieldName.toLowerCase().contains("socket") || fieldName.toLowerCase().contains("channel");
    }

    private Socket unwrapSocket(Object obj) {
        if (obj instanceof Socket) {
            return (Socket)obj;
        }
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Socket s;
                    Object val = field.get(obj);
                    if (!this.shouldRecurse(field.getType(), field.getName(), val) || (s = this.unwrapSocket(val)) == null) continue;
                    return s;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public SocketConnection extractSocket5Tuple(Object obj) {
        try {
            SocketConnection socketConnection = null;
            Socket socket = this.unwrapSocket(obj);
            if (socket != null) {
                InetAddress localAddr = socket.getLocalAddress();
                InetAddress remoteAddr = socket.getInetAddress();
                int localPort = socket.getLocalPort();
                int remotePort = socket.getPort();
                long threadId = Thread.currentThread().getId();
                byte addrFamily = 0;
                if (localAddr instanceof Inet6Address) {
                    addrFamily = 6;
                } else if (localAddr instanceof Inet4Address) {
                    addrFamily = 4;
                }
                socketConnection = new SocketConnection(localAddr, localPort, remoteAddr, remotePort, threadId, 0, addrFamily);
            }
            return socketConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

